/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Resolver;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.util.Logger;

public class SmarterJmolAdapter
extends JmolAdapter {
    public static final String PATH_KEY = ".PATH";
    public static final String PATH_SEPARATOR = System.getProperty("path.separator");

    public SmarterJmolAdapter() {
        super("SmarterJmolAdapter");
    }

    public void finish(Object object) {
        ((AtomSetCollection)object).finish();
    }

    public Object openBufferedReader(String string, String string2, BufferedReader bufferedReader, Hashtable hashtable) {
        try {
            Object object = Resolver.resolve(string, string2, bufferedReader, hashtable);
            if (object instanceof String) {
                return object;
            }
            if (object instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)object;
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown reader error";
        }
        catch (Exception exception) {
            Logger.error(null, exception);
            bufferedReader = null;
            return "" + exception;
        }
    }

    public Object openBufferedReaders(String[] stringArray, String[] stringArray2, BufferedReader[] bufferedReaderArray) {
        int n = Math.min(stringArray.length, bufferedReaderArray.length);
        AtomSetCollection[] atomSetCollectionArray = new AtomSetCollection[n];
        for (int i = 0; i < n; ++i) {
            try {
                Object object = Resolver.resolve(stringArray[i], stringArray2 == null ? null : stringArray2[i], bufferedReaderArray[i]);
                if (object instanceof String) {
                    return object;
                }
                if (object instanceof AtomSetCollection) {
                    atomSetCollectionArray[i] = (AtomSetCollection)object;
                    if (atomSetCollectionArray[i].errorMessage == null) continue;
                    return atomSetCollectionArray[i].errorMessage;
                }
                return "unknown reader error";
            }
            catch (Exception exception) {
                Logger.error(null, exception);
                return "" + exception;
            }
        }
        AtomSetCollection atomSetCollection = new AtomSetCollection(atomSetCollectionArray);
        if (atomSetCollection.errorMessage != null) {
            return atomSetCollection.errorMessage;
        }
        return atomSetCollection;
    }

    public Object openDOMReader(Object object) {
        try {
            Object object2 = Resolver.DOMResolve(object);
            if (object2 instanceof String) {
                return object2;
            }
            if (object2 instanceof AtomSetCollection) {
                AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
                if (atomSetCollection.errorMessage != null) {
                    return atomSetCollection.errorMessage;
                }
                return atomSetCollection;
            }
            return "unknown DOM reader error";
        }
        catch (Exception exception) {
            Logger.error(null, exception);
            return "" + exception;
        }
    }

    public String getFileTypeName(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof BufferedReader) {
            return Resolver.getFileType((BufferedReader)object);
        }
        if (object instanceof AtomSetCollection) {
            return ((AtomSetCollection)object).fileTypeName;
        }
        return null;
    }

    public String getAtomSetCollectionName(Object object) {
        return ((AtomSetCollection)object).collectionName;
    }

    public Properties getAtomSetCollectionProperties(Object object) {
        return ((AtomSetCollection)object).atomSetCollectionProperties;
    }

    public Hashtable getAtomSetCollectionAuxiliaryInfo(Object object) {
        return ((AtomSetCollection)object).atomSetCollectionAuxiliaryInfo;
    }

    public int getAtomSetCount(Object object) {
        return ((AtomSetCollection)object).atomSetCount;
    }

    public int getAtomSetNumber(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetNumber(n);
    }

    public String getAtomSetName(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetName(n);
    }

    public Properties getAtomSetProperties(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetProperties(n);
    }

    public Hashtable getAtomSetAuxiliaryInfo(Object object, int n) {
        return ((AtomSetCollection)object).getAtomSetAuxiliaryInfo(n);
    }

    public int getEstimatedAtomCount(Object object) {
        return ((AtomSetCollection)object).getAtomCount();
    }

    public boolean coordinatesAreFractional(Object object) {
        return ((AtomSetCollection)object).coordinatesAreFractional;
    }

    public float[] getNotionalUnitcell(Object object) {
        return ((AtomSetCollection)object).notionalUnitCell;
    }

    public float[] getPdbScaleMatrix(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray2[i] = fArray[6 + i];
        }
        return fArray2;
    }

    public float[] getPdbScaleTranslate(Object object) {
        float[] fArray = ((AtomSetCollection)object).notionalUnitCell;
        if (fArray.length < 22) {
            return null;
        }
        float[] fArray2 = new float[]{fArray[9], fArray[13], fArray[17]};
        return fArray2;
    }

    public JmolAdapter.AtomIterator getAtomIterator(Object object) {
        return new AtomIterator((AtomSetCollection)object);
    }

    public JmolAdapter.BondIterator getBondIterator(Object object) {
        return new BondIterator((AtomSetCollection)object);
    }

    public JmolAdapter.StructureIterator getStructureIterator(Object object) {
        AtomSetCollection atomSetCollection = (AtomSetCollection)object;
        return atomSetCollection.structureCount == 0 ? null : new StructureIterator(atomSetCollection);
    }

    public class StructureIterator
    extends JmolAdapter.StructureIterator {
        int structureCount;
        Structure[] structures;
        Structure structure;
        int istructure;

        StructureIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.structureCount = atomSetCollection.structureCount;
            this.structures = atomSetCollection.structures;
            this.istructure = 0;
        }

        public boolean hasNext() {
            if (this.istructure == this.structureCount) {
                return false;
            }
            this.structure = this.structures[this.istructure++];
            return true;
        }

        public int getModelIndex() {
            return this.structure.modelIndex;
        }

        public String getStructureType() {
            return this.structure.structureType;
        }

        public char getStartChainID() {
            return JmolAdapter.canonizeChainID(this.structure.startChainID);
        }

        public int getStartSequenceNumber() {
            return this.structure.startSequenceNumber;
        }

        public char getStartInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
        }

        public char getEndChainID() {
            return JmolAdapter.canonizeChainID(this.structure.endChainID);
        }

        public int getEndSequenceNumber() {
            return this.structure.endSequenceNumber;
        }

        public char getEndInsertionCode() {
            return this.structure.endInsertionCode;
        }
    }

    class BondIterator
    extends JmolAdapter.BondIterator {
        AtomSetCollection atomSetCollection;
        Bond[] bonds;
        int ibond;
        Bond bond;
        int bondCount;

        BondIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.bonds = atomSetCollection.bonds;
            this.bondCount = atomSetCollection.bondCount;
            this.ibond = 0;
        }

        public boolean hasNext() {
            if (this.ibond == this.bondCount) {
                return false;
            }
            this.bond = this.bonds[this.ibond++];
            return true;
        }

        public Object getAtomUniqueID1() {
            return new Integer(this.bond.atomIndex1);
        }

        public Object getAtomUniqueID2() {
            return new Integer(this.bond.atomIndex2);
        }

        public int getEncodedOrder() {
            return this.bond.order;
        }
    }

    class AtomIterator
    extends JmolAdapter.AtomIterator {
        AtomSetCollection atomSetCollection;
        int iatom;
        Atom atom;
        int atomCount;
        Atom[] atoms;

        AtomIterator(AtomSetCollection atomSetCollection) {
            super(SmarterJmolAdapter.this);
            this.atomSetCollection = atomSetCollection;
            this.atomCount = atomSetCollection.atomCount;
            this.atoms = atomSetCollection.atoms;
            this.iatom = 0;
        }

        public boolean hasNext() {
            if (this.iatom == this.atomCount) {
                return false;
            }
            this.atom = this.atoms[this.iatom++];
            return true;
        }

        public int getAtomSetIndex() {
            return this.atom.atomSetIndex;
        }

        public BitSet getAtomSymmetry() {
            return this.atom.bsSymmetry;
        }

        public int getAtomSite() {
            return this.atom.atomSite + 1;
        }

        public Object getUniqueID() {
            return new Integer(this.atom.atomIndex);
        }

        public String getElementSymbol() {
            if (this.atom.elementSymbol != null) {
                return this.atom.elementSymbol;
            }
            return this.atom.getElementSymbol();
        }

        public int getElementNumber() {
            return this.atom.elementNumber;
        }

        public String getAtomName() {
            return this.atom.atomName;
        }

        public int getFormalCharge() {
            return this.atom.formalCharge;
        }

        public float getPartialCharge() {
            return this.atom.partialCharge;
        }

        public float getRadius() {
            return this.atom.radius;
        }

        public float getX() {
            return this.atom.x;
        }

        public float getY() {
            return this.atom.y;
        }

        public float getZ() {
            return this.atom.z;
        }

        public float getVectorX() {
            return this.atom.vectorX;
        }

        public float getVectorY() {
            return this.atom.vectorY;
        }

        public float getVectorZ() {
            return this.atom.vectorZ;
        }

        public float getBfactor() {
            return this.atom.bfactor;
        }

        public int getOccupancy() {
            return this.atom.occupancy;
        }

        public boolean getIsHetero() {
            return this.atom.isHetero;
        }

        public int getAtomSerial() {
            return this.atom.atomSerial;
        }

        public char getChainID() {
            return JmolAdapter.canonizeChainID(this.atom.chainID);
        }

        public char getAlternateLocationID() {
            return JmolAdapter.canonizeAlternateLocationID(this.atom.alternateLocationID);
        }

        public String getGroup3() {
            return this.atom.group3;
        }

        public int getSequenceNumber() {
            return this.atom.sequenceNumber;
        }

        public char getInsertionCode() {
            return JmolAdapter.canonizeInsertionCode(this.atom.insertionCode);
        }
    }
}

