# The LearningOnline Network
# Login Screen
#
# $Id: lonlogin.pm,v 1.106.2.3 2009/01/05 17:39:43 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

package Apache::lonlogin;

use strict;
use Apache::Constants qw(:common);
use Apache::File ();
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonauth();
use Apache::lonlocal;
use Apache::migrateuser();
use lib '/home/httpd/lib/perl/';
use LONCAPA;
 
sub handler {
    my $r = shift;

    &Apache::loncommon::get_unprocessed_cgi
	(join('&',$ENV{'QUERY_STRING'},$env{'request.querystring'},
	      $ENV{'REDIRECT_QUERY_STRING'}),
	 ['interface','username','domain','firsturl','localpath','localres',
	  'token']);
    if (!defined($env{'form.firsturl'})) {
        &Apache::lonacc::get_posted_cgi($r,['firsturl']);
    }

# -- check if they are a migrating user
    if (defined($env{'form.token'})) {
	return &Apache::migrateuser::handler($r);
    }

    &Apache::loncommon::no_cache($r);
    &Apache::lonlocal::get_language_handle($r);
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;


# Are we re-routing?
    if (-e '/home/httpd/html/lon-status/reroute.txt') {
	&Apache::lonauth::reroute($r);
	return OK;
    }


# -------------------------------- Prevent users from attempting to login twice
    my $handle = &Apache::lonnet::check_for_valid_session($r);
    if ($handle=~/^publicuser\_/) {
# For "public user" - remove it, we apparently really want to login
	unlink($r->dir_config('lonIDsDir')."/$handle.id");
    } elsif ($handle ne '') {
# Indeed, a valid token is found
	my $start_page = 
	    &Apache::loncommon::start_page('Already logged in');
	my $end_page = 
	    &Apache::loncommon::end_page();
	$r->print(
                  $start_page
                 .'<h1>'.&mt('You are already logged in!').'</h1>'
                 .'<p>'.&mt('Please either [_1]continue the current session[_2] or [_3]logout[_4].',
                  '<a href="/adm/roles">','</a>','<a href="/adm/logout">','</a>').'</p>'
                 .'<p><a href="/adm/loginproblems.html">'.&mt('Login problems?').'</a></p>'
                 .$end_page
                 );
        return OK;
    }

# ---------------------------------------------------- No valid token, continue

 # ---------------------------- Not possible to really login to domain "public"
    if ($env{'form.domain'} eq 'public') {
	$env{'form.domain'}='';
	$env{'form.username'}='';
    }
# ----------------------------------------------------------- Process Interface
    $env{'form.interface'}=~s/\W//g;

    my $textbrowsers=$r->dir_config('lonTextBrowsers');
    my $httpbrowser=$ENV{"HTTP_USER_AGENT"};
    
    foreach (split(/\:/,$textbrowsers)) {
	if ($httpbrowser=~/$_/i) {
	    $env{'form.interface'}='textual';
        }
    }

    my $fullgraph=($env{'form.interface'} ne 'textual');

    my $iconpath= 
	&Apache::loncommon::lonhttpdurl($r->dir_config('lonIconsURL'));

    my $domain = &Apache::lonnet::default_login_domain();
    if (($env{'form.domain'}) && 
	(&Apache::lonnet::domain($env{'form.domain'},'description'))) {
	$domain=$env{'form.domain'};
    }
    my $role    = $r->dir_config('lonRole');
    my $loadlim = $r->dir_config('lonLoadLim');
    my $servadm = $r->dir_config('lonAdmEMail');
    my $lonhost = $r->dir_config('lonHostID');
    my $tabdir  = $r->dir_config('lonTabDir');
    my $include = $r->dir_config('lonIncludes');
    my $expire  = $r->dir_config('lonExpire');
    my $version = $r->dir_config('lonVersion');
    my $host_name = &Apache::lonnet::hostname($lonhost);

# --------------------------------------------- Default values for login fields

    my $authusername=($env{'form.username'}?$env{'form.username'}:'');
    my $authdomain=($env{'form.domain'}?$env{'form.domain'}:$domain);

# ---------------------------------------------------------- Determine own load
    my $loadavg;
    {
	my $loadfile=Apache::File->new('/proc/loadavg');
	$loadavg=<$loadfile>;
    }
    $loadavg =~ s/\s.*//g;
    my $loadpercent=sprintf("%.1f",100*$loadavg/$loadlim);
    my $userloadpercent=&Apache::lonnet::userload();

# ------------------------------------------------------- Do the load balancing
    my $otherserver= &Apache::lonnet::absolute_url($host_name);
    my $firsturl=
    ($env{'request.firsturl'}?$env{'request.firsturl'}:$env{'form.firsturl'});
# ---------------------------------------------------------- Are we overloaded?
    if ((($userloadpercent>100.0)||($loadpercent>100.0))) {
        my $unloaded=Apache::lonnet::spareserver($loadpercent,$userloadpercent);
	if ($unloaded) { $otherserver=$unloaded; }
    }

# ----------------------------------------------------------- Get announcements
    my $announcements=&Apache::lonnet::getannounce();
# -------------------------------------------------------- Set login parameters

    my @hexstr=('0','1','2','3','4','5','6','7',
                '8','9','a','b','c','d','e','f');
    my $lkey='';
    for (0..7) {
        $lkey.=$hexstr[rand(15)];
    }

    my $ukey='';
    for (0..7) {
        $ukey.=$hexstr[rand(15)];
    }

    my $lextkey=hex($lkey);
    if ($lextkey>2147483647) { $lextkey-=4294967296; }

    my $uextkey=hex($ukey);
    if ($uextkey>2147483647) { $uextkey-=4294967296; }

# -------------------------------------------------------- Store away log token
    my $logtoken=Apache::lonnet::reply(
       'tmpput:'.$ukey.$lkey.'&'.$firsturl,
       $lonhost);

# ------------------- If we cannot talk to ourselves, we are in serious trouble

    if ($logtoken eq 'con_lost') {
        my $spares='';
	my $last;
        foreach my $hostid (sort
			    {
				&Apache::lonnet::hostname($a) cmp
				    &Apache::lonnet::hostname($b);
			    }
			    keys(%Apache::lonnet::spareid)) {
            next if ($hostid eq $lonhost);
	    my $hostname = &Apache::lonnet::hostname($hostid);
	    next if ($last eq $hostname);
            $spares.='<br /><font size="+1"><a href="http://'.
                $hostname.
                '/adm/login?domain='.$authdomain.'">'.
                $hostname.'</a>'.
                ' '.&mt('(preferred)').'</font>'.$/;
	    $last=$hostname;
        }
        $spares.= '<br />';
	my %all_hostnames = &Apache::lonnet::all_hostnames();
        foreach my $hostid (sort
			    {
				&Apache::lonnet::hostname($a) cmp
				    &Apache::lonnet::hostname($b);
			    }
			    keys(%all_hostnames)) {
            next if ($hostid eq $lonhost || $Apache::lonnet::spareid{$hostid});
	    my $hostname = &Apache::lonnet::hostname($hostid);
            next if ($last eq $hostname);
            $spares.='<br /><a href="http://'.
                $hostname.
                '/adm/login?domain='.$authdomain.'">'.
                $hostname.'</a>';
	    $last=$hostname;
        }
	$r->print(
           '<html>'
          .'<head><title>'
          .&mt('The LearningOnline Network with CAPA')
          .'</title></head>'
          .'<body bgcolor="#FFFFFF">'
          .'<h1>'.&mt('The LearningOnline Network with CAPA').'</h1>'
          .'<img src="/adm/lonKaputt/lonlogo_broken.gif" align="right" />'
          .'<h3>'.&mt('This LON-CAPA server is temporarily not available for login.').'</h3>'
          .'<p>'.&mt('Please attempt to login to one of the following servers:').'</p>'
          .$spares
          .'</body>'
          .'</html>'
        );
        return OK;
    }

# ----------------------------------------------- Apparently we are in business
    $servadm=~s/\,/\<br \/\>/g;

# ----------------------------------------------------------- Front page design
    my $pgbg=
      ($fullgraph?&Apache::loncommon::designparm('login.pgbg',$domain):'#FFFFFF');
    my $font=
      ($fullgraph?&Apache::loncommon::designparm('login.font',$domain):'#000000');
    my $link=
      ($fullgraph?&Apache::loncommon::designparm('login.link',$domain):'#0000FF');
    my $vlink=
      ($fullgraph?&Apache::loncommon::designparm('login.vlink',$domain):'#0000FF');
    my $alink=&Apache::loncommon::designparm('login.alink',$domain);
    my $mainbg=
      ($fullgraph?&Apache::loncommon::designparm('login.mainbg',$domain):'#FFFFFF');
    my $sidebg=
      ($fullgraph?&Apache::loncommon::designparm('login.sidebg',$domain):'#FFFFFF');
    my $textcol = 
      ($fullgraph?&Apache::loncommon::designparm('login.textcol',$domain):'#000000');
    my $bgcol =
      ($fullgraph?&Apache::loncommon::designparm('login.bgcol',$domain):'#FFFFFF');
    my $logo=&Apache::loncommon::designparm('login.logo',$domain);
    my $img=&Apache::loncommon::designparm('login.img',$domain);
    my $domainlogo=&Apache::loncommon::domainlogo($domain);
    my $login=&Apache::loncommon::designparm('login.login',$domain);
    if ($login eq '') {
        $login = $iconpath.'/'.&mt('userauthentication.gif');
    }
    my $showbanner = 1;
    my $showmainlogo = 1;
    if (defined(&Apache::loncommon::designparm('login.showlogo_img',$domain))) {
        $showbanner = &Apache::loncommon::designparm('login.showlogo_img',$domain);
    }
    if (defined(&Apache::loncommon::designparm('login.showlogo_logo',$domain))) {
        $showmainlogo = &Apache::loncommon::designparm('login.showlogo_logo',$domain);
    }
    my $showadminmail=&Apache::loncommon::designparm('login.adminmail',$domain);
    my $showcoursecat =
        &Apache::loncommon::designparm('login.coursecatalog',$domain);
    my $loginheader =&Apache::loncommon::designparm('login.loginheader',$domain);
    my $shownewuserlink = 
        &Apache::loncommon::designparm('login.newuser',$domain);
    my $now=time;
    my $js = (<<ENDSCRIPT);

 <script language="JavaScript">
    function send()
    {
        this.document.server.elements.uname.value
       =this.document.client.elements.uname.value;

        this.document.server.elements.udom.value
       =this.document.client.elements.udom.value;

        this.document.server.elements.imagesuppress.value
       =this.document.client.elements.imagesuppress.checked;

        this.document.server.elements.embedsuppress.value
       =this.document.client.elements.embedsuppress.checked;

        this.document.server.elements.appletsuppress.value
       =this.document.client.elements.appletsuppress.checked;

        this.document.server.elements.fontenhance.value
       =this.document.client.elements.fontenhance.checked;

        this.document.server.elements.blackwhite.value
       =this.document.client.elements.blackwhite.checked;

        this.document.server.elements.remember.value
       =this.document.client.elements.remember.checked;

        uextkey=this.document.client.elements.uextkey.value;
        lextkey=this.document.client.elements.lextkey.value;
        initkeys();

        this.document.server.elements.upass0.value
            =crypted(this.document.client.elements.upass$now.value.substr(0,15));
        this.document.server.elements.upass1.value
            =crypted(this.document.client.elements.upass$now.value.substr(15,15));
        this.document.server.elements.upass2.value
            =crypted(this.document.client.elements.upass$now.value.substr(30,15));

        this.document.client.elements.uname.value='';
        this.document.client.elements.upass$now.value='';

        this.document.server.submit();
        return false;
    }
 </script>

ENDSCRIPT

# --------------------------------------------------- Print login screen header

    my %add_entries = (topmargin    => "0",
                       leftmargin   => "0",
                       marginheight => "0",
                       marginwidth  => "0",
                       bgcolor      => "$pgbg",
                       text         => "$font",
                       link         => "$link",
                       vlink        => "$vlink",
                       alink        => "$alink",);

    $r->print(&Apache::loncommon::start_page('The LearningOnline Network with CAPA Login',$js,
                                       { 'redirect'       => [$expire,'/adm/roles'], 
                                         'add_entries' => \%add_entries,
                                         'only_body'   => 1,}));

# ----------------------------------------------------------------------- Texts

my %lt=&Apache::lonlocal::texthash(
		  'un'  => 'Username',
		  'pw'  => 'Password',
		  'dom' => 'Domain',
		  'load' => 'Server Load',
                  'userload' => 'User Load',
                  'about'  => 'About LON-CAPA',
                  'access' => 'Accessibility Options',
                  'catalog' => 'Course Catalog',
		  'log' => 'Log in',
		  'help' => 'Log-in Help',
		  'serv' => 'Server',
                  'servadm' => 'Server Administration',
                  'helpdesk' => 'Contact Helpdesk',
                  'forgotpw' => 'Forgot password?',
                  'newuser'  => 'New User?',
                  'options_headline' => 'Select Accessibility Options',
                  'sprs_img' => 'Suppress rendering of images',
                  'sprs_applet' => 'Suppress Java applets',
                  'sprs_embed' => 'Suppress rendering of embedded multimedia',
                  'sprs_font' => 'Increase font size',
                  'sprs_blackwhite' => 'Switch to black and white mode',
                  'remember' => 'Remember these settings for next login');
# -------------------------------------------------- Change password field name
    my $forgotpw = &forgotpwdisplay(%lt);
    my $loginhelp = &loginhelpdisplay(%lt);

# ---------------------------------------------------- Serve out DES JavaScript
    {
        my $jsh=Apache::File->new($include."/londes.js");
        $r->print(<$jsh>);
    }
# ---------------------------------------------------------- Serve rest of page

    if ($fullgraph) {
	$r->print(
		  '<table width="100%" cellpadding=0 cellspacing=0 border=0>');
    }

    $r->print(<<ENDSERVERFORM);
  <form name="server" action="$otherserver/adm/authenticate" method="post" target="_top">
   <input type="hidden" name="logtoken" value="$logtoken" />
   <input type="hidden" name="serverid" value="$lonhost" />
   <input type="hidden" name="interface" value="$env{'form.interface'}" />
   <input type="hidden" name="uname" value="" />
   <input type="hidden" name="upass0" value="" />
   <input type="hidden" name="upass1" value="" />
   <input type="hidden" name="upass2" value="" />
   <input type="hidden" name="udom" value="" />
   <input type="hidden" name="imagesuppress"  value="" />
   <input type="hidden" name="appletsuppress"  value="" />
   <input type="hidden" name="embedsuppress"  value="" />
   <input type="hidden" name="fontenhance"  value="" />
   <input type="hidden" name="blackwhite"  value="" />
   <input type="hidden" name="remember"  value="" />
   <input type="hidden" name="localpath" value="$env{'form.localpath'}" />
   <input type="hidden" name="localres" value="$env{'form.localres'}" />
  </form>
ENDSERVERFORM
    my $coursecatalog;
    if (($showcoursecat eq '') || ($showcoursecat)) {
        $coursecatalog = &coursecatalog_link($lt{'catalog'});
    }
    my $newuserlink;
    if ($shownewuserlink) {
        $newuserlink = &newuser_link($lt{'newuser'});
    }
    if ($fullgraph) {
        $r->print(<<HEADER);
  <!-- The LON-CAPA Header -->
  <tr>

   <!-- Row 1 Columns 2-4 -->
   <td width="100%" height=75 colspan=4 align="left" valign="top" bgcolor="$pgbg">
HEADER
        if ($showbanner) {
            $r->print(<<ENDBANNER); 
<img src="$img" border=0 alt="The Learning Online Network with CAPA" />
ENDBANNER
        }
        $r->print(<<ENDSTART);
   </td>
  </tr>

  <!-- The gray bar that starts the two table frames -->
  <tr>

   <!-- Row 2 Column 1 -->
   <td width=182 height=27 bgcolor="$sidebg">&nbsp;</td>

   <!-- Row 2 Column 2 -->
   <td width=27 height=27 align="left" background="$iconpath/filltop.gif"><img src="$iconpath/upperleft.gif" border=0 alt="" /></td>

   <!-- Row 2 Column 3 -->
   <td height=27 background="$iconpath/filltop.gif"><img src="$iconpath/filltop.gif" alt="" /></td>

   <!-- Row 2 Column 4 -->
   <td width=27 height=27 align="right" background="$iconpath/filltop.gif"><img src="$iconpath/upperright.gif" border=0 alt="" /></td>
  </tr>
  <tr>
   
   <!-- A cell that will hold the 'access', 'about', and 'catalog' links -->
   <!-- Row 3 Column 1 -->
   <td valign="top" height="60" align="left" bgcolor="$sidebg">
    <table cellpadding="0" cellspacing="2" border="0">
     <tr>
      <td>&nbsp;</td>
      <td><a href="/adm/login?interface=textual"><b>$lt{'access'}</b></a></td>
     </tr>
     <tr>
      <td>&nbsp;</td>
      <td><a href="/adm/about.html"><b>$lt{'about'}</b></a></td>
     </tr>$coursecatalog
     <tr>
      <td colspan="2">&nbsp;</td>
     </tr>
    </table>
   </td>
   <!-- The shaded space between the two main columns -->
   <!-- Row 3 Column 2 -->
   <td width=27 height=60 background="$iconpath/fillleft.gif"><img src="$iconpath/fillleft.gif" alt="" /></td>

   <!-- The right main column holding the large LON-CAPA logo-->
   <!-- Rows 3-4 Column 3 -->
   <td align="center" valign="top" width="100%" height="100%" bgcolor="$mainbg">
ENDSTART
        if ($showmainlogo) {
            $r->print(<<ENDLOGO);
    <center>
     <img src="$logo" alt="" />
    </center>
ENDLOGO
        }
        $r->print(<<ENDTOP);
   </td>

   <!-- Row 3 Column 4 -->
   <td width=27 background="$iconpath/fillright.gif"><img src="$iconpath/fillright.gif" alt="" /></td>
  </tr>
  <tr>

   <!-- The entry form -->
   <!-- Row 4 Column 1 -->
   <td align="center" valign="middle" bgcolor="$sidebg">
ENDTOP
    } else {
        $r->print('<h1>The Learning<i>Online</i> Network with CAPA</h1>'
                 .'<h2>'.&mt('Text-based Interface Login').'</h2>'
                 .$announcements);
    }
    $r->print('<form name="client" onsubmit="return(send())">');
    unless ($fullgraph) {
        $r->print(<<ENDACCESSOPTIONS);
<h3>$lt{'options_headline'}</h3>
<label><input type="checkbox" name="imagesuppress" /> $lt{'sprs_img'}</label><br />
<label><input type="checkbox" name="appletsuppress" /> $lt{'sprs_applet'}</label><br />
<label><input type="checkbox" name="embedsuppress" /> $lt{'sprs_embed'}</label><br />
<label><input type="checkbox" name="fontenhance" /> $lt{'sprs_font'}</label><br />
<label><input type="checkbox" name="blackwhite" /> $lt{'sprs_blackwhite'}</label><br />
<br />
<input type="checkbox" name="remember" /> $lt{'remember'}<hr />
ENDACCESSOPTIONS
    } else {
        $r->print(<<ENDNOOPT);
<input type="hidden" name="imagesuppress"  value="" />
<input type="hidden" name="embedsuppress"  value="" />
<input type="hidden" name="appletsuppress"  value="" />
<input type="hidden" name="fontenhance"  value="" />
<input type="hidden" name="blackwhite"  value="" />
<input type="hidden" name="remember"  value="" />
ENDNOOPT
    }
    my $logintitle;
    if ($loginheader eq 'text') {
        $logintitle = '<td bgcolor="'.$bgcol.'" colspan="2">&nbsp;&nbsp;&nbsp;<b><font size="+1" color="'.$textcol.'">'.$lt{'log'}.'</font></b></td>';
    } else {
        $logintitle = '<td bgcolor="'.$sidebg.'" colspan="2"><img src="'.$login.'" alt="'.
                      &mt('User Authentication').'" /></td>';
    }
    my $noscript_warning='<td colspan="2" bgcolor="'.$mainbg.'">'
                        .'<noscript><div class="LC_warning"><font size="-1">'
                        .&mt('Use of LON-CAPA requires Javascript to be enabled in your web browser.')
                        .'</font></div></noscript></td>';
    $r->print(<<ENDLOGIN);
     <input type="hidden" name="lextkey" value="$lextkey">
     <input type="hidden" name="uextkey" value="$uextkey">

     <!-- Start the sub-table for text and input alignment -->
     <table border=0 cellspacing=0 cellpadding=0>
      <tr>$logintitle</tr>
      <tr>$noscript_warning</tr>
      <tr>
       <td bgcolor="$mainbg"><br /><font size=-1><b>&nbsp;&nbsp;&nbsp;<label for="uname">$lt{'un'}</label>:</b></font></td>
       <td bgcolor="$mainbg"><br /><input type="text" name="uname" size="10" value="$authusername" /></td>
      </tr>
      <tr>
       <td bgcolor="$mainbg"><font size=-1><b>&nbsp;&nbsp;&nbsp;<label for="upass$now">$lt{'pw'}</label>:</b></font></td>
       <td bgcolor="$mainbg"><input type="password" name="upass$now" size="10" /></td>
      </tr>
      <tr>
       <td bgcolor="$mainbg"><font size=-1><b>&nbsp;&nbsp;&nbsp;<label for="udom">$lt{'dom'}</label>:</b></font></td>
       <td bgcolor="$mainbg"><input type="text" name="udom" size="10" value="$authdomain" /></td>
      </tr>
      <tr>
       <td bgcolor="$mainbg">&nbsp;</td>
       <td bgcolor="$mainbg" valign="bottom" align="center">
        <br />
        <input type="submit" value="$lt{'log'}" />
       </td>
      </tr>
      <tr>
       <td bgcolor="$mainbg" valign="bottom" align="left" colspan="2">
        $loginhelp
        $forgotpw
        $newuserlink
        <br />
       </td>
      </tr>
     </table>
     <!-- End sub-table -->
    </form>
ENDLOGIN
    if ($fullgraph) {
        my $helpdeskscript;
        my $contactblock = &contactdisplay(\%lt,$servadm,$showadminmail,
                                  $version,$authdomain,\$helpdeskscript);
	$r->print(<<ENDDOCUMENT);
   </td>

   <!-- Row 4 Column 2 -->
   <td width=27 background="$iconpath/fillleft.gif"><img src="$iconpath/fillleft.gif" alt="" /></td>

   <!-- Row 4 Column 3 -->
<td bgcolor="$mainbg">$announcements</td>

   <!-- Row 4 Column 4 -->
   <td width=27 background="$iconpath/fillright.gif"><img src="$iconpath/fillright.gif" alt="" /></td>
  </tr>
  <tr>

   <!-- Row 5 Column 1 -->
   <td bgcolor="$sidebg" valign="middle" align="left">
     <br />
     <table border=0 cellspacing=0 cellpadding=0>
      <tr>
       <td bgcolor="$sidebg" align="left" valign="top">
        <small><b>&nbsp;&nbsp;&nbsp;$lt{'dom'}:&nbsp;</b></small>
       </td>
       <td bgcolor="$sidebg" align="left" valign="middle">
        <small><tt>&nbsp;$domain</tt></small>
       </td>
      </tr>
      <tr>
       <td bgcolor="$sidebg" align="left" valign="top">
        <small><b>&nbsp;&nbsp;&nbsp;$lt{'serv'}:&nbsp;</b></small>
       </td>
       <td bgcolor="$sidebg" align="left" valign="middle">
        <small><tt>&nbsp;$lonhost ($role)</tt></small>
       </td>
      </tr>
      <tr>
       <td bgcolor="$sidebg" align="left" valign="top"><span class="LC_nobreak">
        <small><b>&nbsp;&nbsp;&nbsp;$lt{'load'}:&nbsp;</b></small></span>
       </td>
       <td bgcolor="$sidebg" align="left" valign="middle">
        <small><tt>&nbsp;$loadpercent%</tt></small>
       </td>
      </tr>
      <tr>
       <td bgcolor="$sidebg" align="left" valign="top"><span class="LC_nobreak">
        <small><b>&nbsp;&nbsp;&nbsp;$lt{'userload'}:&nbsp;</b></small></span>
       </td>
       <td bgcolor="$sidebg" align="left" valign="middle">
        <small><tt>&nbsp;$userloadpercent%</tt></small>
       </td>
      </tr>
     </table>
     <br />
    $contactblock
   </td>

   <!-- Row 5 Column 2 -->
   <td width=27 background="$iconpath/fillleft.gif"><img src="$iconpath/fillleft.gif" alt="" /></td>

   <!-- Row 5 Column 3 -->
   <td width="100%" valign="bottom" bgcolor="$mainbg">
$domainlogo
</td>

   <!-- Row 5 Column 4 -->
   <td width=27 background="$iconpath/fillright.gif"><img src="$iconpath/fillright.gif" alt="" /></td>
  </tr>
  <tr>

   <!-- Row 6 Column 1 -->
   <td bgcolor="$sidebg">&nbsp;</td>

   <!-- Row 6 Column 2 -->
   <td align="left" background="$iconpath/fillbottom.gif"><img src="$iconpath/lowerleft.gif" alt="" /></td>

   <!-- Row 6 Column 3 -->
   <td background="$iconpath/fillbottom.gif"><img src="$iconpath/fillbottom.gif" alt="" /></td>

   <!-- Row 6 Column 4 -->
   <td align="right" background="$iconpath/fillbottom.gif"><img src="$iconpath/lowerright.gif" alt="" /></td>
  </tr>
 </table>

<script type="text/javascript">
// the if prevents the script error if the browser can not handle this
if ( document.client.uname ) { document.client.uname.focus(); }
</script>
$helpdeskscript

ENDDOCUMENT
}
    my %endargs = ( 'noredirectlink' => 1, );
    $r->print(&Apache::loncommon::end_page(\%endargs));
    return OK;
}

sub contactdisplay {
    my ($lt,$servadm,$showadminmail,$version,$authdomain,$helpdeskscript) = @_;
    my $contactblock;
    my $showhelpdesk = 0;
    my $requestmail = $Apache::lonnet::perlvar{'lonSupportEMail'};
    if ($requestmail =~ m/^[^\@]+\@[^\@]+$/) {
        $showhelpdesk = 1;
    }
    if ($servadm && $showadminmail) {
        $contactblock .= '<b>&nbsp;&nbsp;&nbsp;'.$$lt{'servadm'}.':</b><br />'.
                         '<tt>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;'.$servadm.'</tt><br />&nbsp;<br />';
    }
    if ($showhelpdesk) {
        $contactblock .= '<b>&nbsp;&nbsp;&nbsp;<a href="javascript:helpdesk()"><font size="+1">'.$lt->{'helpdesk'}.'</font></a></b><br />';
        my $thisurl = &escape('/adm/login');
        $$helpdeskscript = <<"ENDSCRIPT";
<script type="text/javascript">
function helpdesk() {
    var codedom = document.client.udom.value;
    if (codedom == '') {
        codedom = "$authdomain";
    }
    var querystr = "origurl=$thisurl&codedom="+codedom;
    document.location.href = "/adm/helpdesk?"+querystr;
    return;
}
</script>
ENDSCRIPT
    }
    $contactblock .= <<"ENDBLOCK";
     &nbsp;&nbsp;&nbsp;$version
ENDBLOCK
    return $contactblock;
}

sub forgotpwdisplay {
    my (%lt) = @_;
    my $prompt_for_resetpw = 1; 
    if ($prompt_for_resetpw) {
        return '<br />&nbsp;&nbsp;&nbsp;<a href="/adm/resetpw">'.$lt{'forgotpw'}.'</a></b><br />';
    }
    return;
}

sub loginhelpdisplay {
    my (%lt) = @_;
    my $login_help = 1;
    if ($login_help) {
        return '&nbsp;&nbsp;&nbsp;<a href="/adm/loginproblems.html">'.$lt{'help'}.'</a></b>';
    }
    return;
}

sub coursecatalog_link {
    my ($linkname) = @_;
    return <<"END";
     <tr>
      <td>&nbsp;</td>
      <td><a href="/adm/coursecatalog"><b>$linkname</b></a></td>
     </tr>
END
}

sub newuser_link {
    my ($linkname) = @_;
    return '&nbsp;&nbsp;&nbsp;<a href="/adm/createaccount"><b>'.$linkname.'</b></a><br />';
}

1;
__END__
