#!/usr/bin/perl
#
# $Id: imagechoice.pl,v 1.4 2003/05/10 22:59:04 www Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/cgi-bin/plot.gif
#
# http://www.lon-capa.org/
#
use strict;

$|=1;

my %data;
foreach (split/&/,$ENV{'QUERY_STRING'}) {
    my ($name,$value)=split/=/;
    $data{$name}=$value;
}
my $filename = $data{'file'};
my $formname = $data{'formname'};
my $formx = $data{'formx'};
my $formy = $data{'formy'};
my $mode=$data{'mode'};
my $formwidth = $data{'formwidth'};
my $formheight = $data{'formheight'};
my $formcoord=$data{'formcoord'};
# unescape filename
$filename =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C",hex($1))/eg;

#
# Single coordinate, defined - store it
#
if ((defined($data{'x'})) && (defined($data{'y'})) && 
    ($mode ne 'pairtwo') && ($mode ne 'pairthree')) {
    my $output='';
    if ($data{'formwidth'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formwidth'}.
	    '.value=document.pickimg.width;';
    }
    if ($data{'formheight'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formheight'}.
	    '.value=document.pickimg.height;';
    }
    if ($data{'formx'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formx'}.
	    '.value='.$data{'x'}.';';
    }
    if ($data{'formy'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formy'}.
	    '.value='.$data{'y'}.';';
    }
    print <<"ENDSUBM";
Content-type: text/html

<html>
<script>
    function submitthis() {
	$output
	self.close();
    }
</script>
<body bgcolor="#FFFFFF" onLoad="submitthis()">
<h3>Position Selected</h3>
<img name="pickimg" src="$filename" />
</body>
</html>
ENDSUBM
#
# Coordinate Pair, Second Coordinate
#
} elsif ($mode eq 'pairthree') {
    my $output='';
    my $outputpair="($data{'selx'},$data{'sely'})-($data{'x'},$data{'y'})";
    if ($data{'formwidth'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formwidth'}.
	    '.value=document.pickimg.width;';
    }
    if ($data{'formheight'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formheight'}.
	    '.value=document.pickimg.height;';
    }
    if ($data{'formcoord'}) {
	$output.='opener.document.forms.'.$data{'formname'}.'.'.$data{'formcoord'}.
	    '.value="'.$outputpair.'";';
    }
    print <<"ENDCOORDSUB";
Content-type: text/html

<html>
<script>
    function submitthis() {
	$output
	self.close();
    }
</script>
<body bgcolor="#FFFFFF" onLoad="submitthis()">
<h3>Coordinates Selected</h3>
<img name="pickimg" src="$filename" />
</body>
</html>
ENDCOORDSUB
#
# First and second call
#
} else {
    my $heading='Position';
    my $nextstage='';
    if ($mode eq 'pair') {
       $heading='First Coordinate';
       $nextstage='<input type="hidden" name="mode" value="pairtwo" />';
   } elsif ($mode eq 'pairtwo') {
       $heading='Second Coordinate';
       $nextstage=<<ENDNEXTSTAGE;
<input type="hidden" name="mode" value="pairthree" />
<input type="hidden" name="selx" value="$data{'x'}" />
<input type="hidden" name="sely" value="$data{'y'}" />
ENDNEXTSTAGE
   }
    print <<"END";
Content-type: text/html

<html>
<body bgcolor="#FFFFFF">
<h3>Select $heading on Image</h3>
<form>
<input type="hidden" name="formname" value="$formname" />
<input type="hidden" name="formx" value="$formx" />
<input type="hidden" name="formy" value="$formy" />
<input type="hidden" name="formcoord" value="$formcoord" />
<input type="hidden" name="formwidth" value="$formwidth" />
<input type="hidden" name="formheight" value="$formheight" />
<input type="hidden" name="file" value="$filename" />
$nextstage
<input type="image" src="$filename" />
</form>
</body>
</html>
END
}



