#!/usr/bin/perl
#
#Automated Enrollment script
# $Id: Autoenroll.pl,v 1.31 2009/01/08 16:58:04 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
    use strict;
    use lib '/home/httpd/lib/perl';
    use localenroll;
    use LONCAPA::Configuration;
    use LONCAPA::Enrollment;
    use Apache::lonnet;
    use Apache::loncoursedata;
    use Apache::lonmsg;
    use Apache::longroup;
    use Apache::loncommon;
    use Apache::lonlocal;
    use HTML::Entities;
    use LONCAPA qw(:match);

# Determine the library server's domain and hostID
    my $perlvarref = LONCAPA::Configuration::read_conf('loncapa.conf');
    my $logfile = $$perlvarref{'lonDaemons'}.'/logs/autoenroll.log';
    my @domains = &Apache::lonnet::current_machine_domains();
    my @hostids = &Apache::lonnet::current_machine_ids();

# Determine the present time;
    my $timenow = time();

# For each domain ......
    foreach my $dom (@domains) {
        #only run if configured to
        my $run_enroll = 0;
        my $domsettings;
        my %domconfig =
            &Apache::lonnet::get_dom('configuration',['autoenroll'],$dom);
        if (ref($domconfig{'autoenroll'}) eq 'HASH') {
            $domsettings = $domconfig{'autoenroll'};
            if ($domsettings->{'run'} eq '1') {
                $run_enroll = 1;
            }
        } else {
            $run_enroll = &localenroll::run($dom);
        }
        next if ($run_enroll != 1);

        $env{'user.domain'} = $dom;
        # Initialize language handler
        &Apache::lonlocal::get_language_handle();
        # Determine the courses
        my %courses = &Apache::lonnet::courseiddump($dom,'.',1,'.','.','.',1,\@hostids,'Course'); 
        my %affiliates = ();
        my %enrollvar = ();
        my %reply = ();
        my %LC_code = ();
        foreach my $key (sort keys %courses) {
            my %args = (
                         one_time => 1,
                       );
            my %coursehash = &Apache::lonnet::coursedescription($key,\%args);
            my $crs = $coursehash{'num'};
            next if ($coursehash{'domain'} ne $dom);
# Get course settings
            my %settings = &Apache::lonnet::dump('environment',$dom,$crs);
            %{$enrollvar{$crs}} = ();
            @{$affiliates{$crs}} = ();
            %{$LC_code{$crs}} = ();
            foreach my $item (keys %settings) {
                if ($item =~ m/^internal\.(.+)$/) {
                    $enrollvar{$crs}{$1} = $settings{$item};
                } elsif ($item eq 'description') {
                    $enrollvar{$crs}{$item} = &HTML::Entities::decode($settings{$item});  
                } elsif ($item eq 'default_enrollment_start_date') {
                    $enrollvar{$crs}{startdate} = $settings{$item};
                }  elsif ($item eq 'default_enrollment_end_date') {
                    $enrollvar{$crs}{enddate} = $settings{$item};
                }
            }
            if (($enrollvar{$crs}{autostart} <= $timenow) && ( ($enrollvar{$crs}{autoend} > $timenow) || ($enrollvar{$crs}{autoend} == 0) ) ) {
                if ( ($enrollvar{$crs}{autoadds} == 1) || ($enrollvar{$crs}{autodrops} == 1) ) {
# Add to list of classes for retrieval
                    $enrollvar{$crs}{sectionnums} =~ s/ //g;
                    $enrollvar{$crs}{crosslistings} =~ s/ //g;
                    my @sections = ();
                    my @crosslistings = ();
                    if ($enrollvar{$crs}{sectionnums} =~ m/,/) {
                        @sections = split/,/,$enrollvar{$crs}{sectionnums};
                    } else {
                        $sections[0] = $enrollvar{$crs}{sectionnums};
                    }
                    if ($enrollvar{$crs}{crosslistings} =~ m/,/) {
                        @crosslistings = split/,/,$enrollvar{$crs}{crosslistings}
                    } else {
                        @crosslistings = $enrollvar{$crs}{crosslistings};
                    }
                    foreach my $sec (@sections) {
                        if ($sec =~ m/^(\w+):(\w*)$/ ) {
                            my $course_id = $enrollvar{$crs}{coursecode}.$1;
                            my $gp = $2;
                            if (!grep/^$course_id$/,@{$affiliates{$crs}}) {
                                push @{$affiliates{$crs}}, $course_id;
                                $LC_code{$crs}{$course_id} = $gp; 
                            }
                        }
                    }
                    foreach my $xlist (@crosslistings) {
                        if ($xlist =~ m/^([^:]+):(\w*)$/) {
                            my $course_id = $1;
                            my $gp = $2;
                            if (!grep/^$course_id$/,@{$affiliates{$crs}}) {
                                push @{$affiliates{$crs}}, $course_id;
                                $LC_code{$crs}{$course_id} = $gp;
                            }
                        }
                    }
                }
            }
        }
        my $outcome = &Apache::lonnet::fetch_enrollment_query('automated',\%affiliates,\%reply,$dom);

# Now go through classes and perform required enrollment changes.
        open (my $fh,">>$logfile");
        print $fh "********************\n".localtime(time).' '.&mt('Enrollment messages start').' --'."\n";
        print $fh &mt("Response from [_1] was [_2]",'fetch_enrollment_query',$outcome)."\n";
        foreach my $crs (sort keys %enrollvar) {
            my $logmsg = '';
            my $newusermsg = '';
            if ($reply{$crs} > 0) {
                if ( ($enrollvar{$crs}{autostart} < $timenow) && ( ($enrollvar{$crs}{autoend} > $timenow) || ($enrollvar{$crs}{autoend} == 0) ) ) {
                    if (($enrollvar{$crs}{autoadds} == 1) || ($enrollvar{$crs}{autodrops} == 1)) {
                        my ($changecount,$response) = &LONCAPA::Enrollment::update_LC($dom,$crs,$enrollvar{$crs}{autoadds},$enrollvar{$crs}{autodrops},$enrollvar{$crs}{startdate},$enrollvar{$crs}{enddate},$enrollvar{$crs}{authtype},$enrollvar{$crs}{autharg},\@{$affiliates{$crs}},\%{$LC_code{$crs}},\$logmsg,\$newusermsg,'automated');
                        print $fh &mt('Messages start for [_1]',$crs)."\n";
                        print $fh "$logmsg\n";
                        print $fh &mt('Messages end for [_1]',$crs)."\n";
                        if ($changecount > 0) {
# Set $env{'user.name'}, $env{'user.domain'}, $env{'user.home'}
# and $env{'request.course.id'} for use by logging in lonmsg
                            $env{'request.course.id'} = $dom.'_'.$crs;
                            my ($ownername,$ownerdom);
                            if ($enrollvar{$crs}{'courseowner'} ne '') {
                                if ($enrollvar{$crs}{'courseowner'} =~ /:/) {
                                    ($ownername,$ownerdom) =
                                        split(/:/,$enrollvar{$crs}{'courseowner'});
                                } else {
                                    $ownername = $enrollvar{$crs}{'courseowner'}; 
                                    $ownerdom = $dom;
                                }
                            }
                            $env{'user.name'} = $ownername;
                            $env{'user.domain'} = $ownerdom;
                            if (ref($domsettings) eq 'HASH') {
                                if (($domsettings->{'sender_uname'} ne '') && 
                                    ($domsettings->{'sender_domain'} ne '')) {
                                    $env{'user.name'} = $domsettings->{'sender_uname'};
                                    $env{'user.domain'} = $domsettings->{'sender_domain'};
                                }
                            }
                            if ($enrollvar{$crs}{notifylist}  eq '') {
                                if ($newusermsg ne '') {
                                    if (($ownername =~ /^$match_username$/) && 
                                        ($ownerdom =~ /^$match_domain$/)) {
                                        my $subject = &mt('New user accounts in [_1]',$enrollvar{$crs}{'coursecode'});
                                        my $status =  &Apache::lonmsg::user_normal_msg($ownername,$ownerdom,$subject,$newusermsg);
                                    }
                                }
                            } else {
                                $env{'form.can_reply'} = 'N';
                                my $msgcc;
# Send message about enrollment changes to notifylist.
                                $env{'user.home'} = &Apache::lonnet::homeserver($env{'user.name'},$env{'user.domain'});
                                my $subject = &mt('Student enrollment changes in [_1]',$enrollvar{$crs}{coursecode});
                                my $message = &mt('The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:',$changecount,$enrollvar{$crs}{description},$enrollvar{$crs}{coursecode})."\n\n".$response;
                                unless ($newusermsg eq '') { 
                                    $message .= "\n".$newusermsg;
                                }
                                my @to_notify = split(/,/,$enrollvar{$crs}{notifylist});
                                my $numsent = 0;
                                my @recusers;
                                my @recudoms;
                                foreach my $cc (@to_notify) {
                                    my ($ccname,$ccdom);
                                    if ($cc =~ /:/) {
                                        ($ccname,$ccdom) = split(/:/,$cc);
                                    } elsif ($cc =~ /\@/) {
                                        ($ccname,$ccdom) = split(/\@/,$cc);
                                    }
                                    push(@recusers,$ccname);
                                    push(@recudoms,$ccdom);
                                    $msgcc->{$ccname.':'.$ccdom}='';
                                    $numsent ++;
                                }
                                my %reciphash = (
                                    cc => $msgcc,
                                );
                                my %sentmessage;
                                my $stamp = time;
                                my $msgcount = &Apache::lonmsg::get_uniq();
                                &Apache::lonmsg::process_sent_mail($subject,'',$numsent,$stamp,$env{'user.name'},$env{'user.domain'},$msgcount,$crs,$$,$message,\@recusers,\@recudoms);
                                my ($recipid,$recipstatus) =
                                    &Apache::lonmsg::store_recipients($subject,
                                    $env{'user.name'},$env{'user.domain'},\%reciphash);
                                foreach my $recip (sort(keys(%{$msgcc}))) {
                                    my ($ccname,$ccdom) = split(/:/,$recip);
                                    my $status =  
                                        &Apache::lonmsg::user_normal_msg($ccname,$ccdom,$subject,$message,undef,undef,undef,undef,\%sentmessage,undef,undef,undef,1,$recipid);
                                }
                                delete($env{'form.can_reply'});
                            }
                            delete($env{'user.name'});
                            delete($env{'user.home'});
                            delete($env{'request.course.id'});
                            $env{'user.domain'} = $dom;
                        }
                    }
                }
            } else {
                if ( ($enrollvar{$crs}{autoadds} == 1) || ($enrollvar{$crs}{autodrops} == 1) ) {
                    if ( ($enrollvar{$crs}{autostart} < $timenow) && ( ($enrollvar{$crs}{autoend} > $timenow) || ($enrollvar{$crs}{autoend} == 0) ) ) {
                        print $fh &mt('No institutional classlist data could be retrieved for [_1]',$crs)."\n";
                    } else {
                        print $fh &mt('Not within time window for auto-enrollment in [_1]',$crs)."\n";
                    }
                } else {
                    print $fh &mt('Auto-enrollment not currently enabled for [_1]',$crs)."\n";
                }
            }
        }
        print $fh "-- ".localtime(time).' '.&mt('Enrollment messages end')."\n*******************\n\n";
        close($fh);
        delete($env{'user.domain'});
    }

1;
