/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;

public class Escape {
    public static String escape(Object object) {
        if (object instanceof String) {
            return Escape.escape("" + object);
        }
        return object.toString();
    }

    public static String escapeColor(int n) {
        return "[x" + Graphics3D.getHexColorFromRGB(n) + "]";
    }

    public static String escape(Point4f point4f) {
        return "{" + point4f.x + " " + point4f.y + " " + point4f.z + " " + point4f.w + "}";
    }

    public static String escape(Tuple3f tuple3f) {
        return "{" + tuple3f.x + " " + tuple3f.y + " " + tuple3f.z + "}";
    }

    public static String escape(float[] fArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append('\n');
            }
            stringBuffer.append("" + fArray[i]);
        }
        return stringBuffer.toString();
    }

    public static String escape(String string) {
        if (string == null) {
            return "\"\"";
        }
        int n = -2;
        while ((n = string.indexOf("\"", n + 2)) >= 0) {
            string = string.substring(0, n) + '\\' + string.substring(n);
        }
        string = TextFormat.simpleReplace(string, "\n", "\u0001");
        string = TextFormat.simpleReplace(string, "\u0001", "\\n");
        int n2 = string.length();
        while (--n2 >= 0) {
            if (string.charAt(n2) <= '\u007f') continue;
            string = string.substring(0, n2) + Escape.unicode(string.charAt(n2)) + string.substring(n2 + 1);
        }
        return "\"" + string + "\"";
    }

    private static String unicode(char c) {
        String string = "0000" + Integer.toHexString(c);
        return "\\u" + string.substring(string.length() - 4);
    }

    public static Object unescapePoint(String string) {
        int n;
        if (string == null || string.length() == 0 || string.charAt(0) != '{' || string.charAt(string.length() - 1) != '}') {
            return string;
        }
        float[] fArray = new float[5];
        String string2 = string.substring(1, string.length() - 1);
        int[] nArray = new int[1];
        for (n = 0; n < 5; ++n) {
            fArray[n] = Parser.parseFloat(string2, nArray);
            if (Float.isNaN(fArray[n])) break;
        }
        if (n == 3) {
            return new Point3f(fArray[0], fArray[1], fArray[2]);
        }
        if (n == 4) {
            return new Point4f(fArray[0], fArray[1], fArray[2], fArray[3]);
        }
        return string;
    }

    public static BitSet unescapeBitset(String string) {
        if (string == "{null}") {
            return null;
        }
        BitSet bitSet = new BitSet();
        int n = string.length();
        int n2 = -1;
        int n3 = -2;
        if (n < 3) {
            return bitSet;
        }
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case ' ': 
                case '{': 
                case '}': {
                    if (n3 < 0) continue block4;
                    if (n2 < 0) {
                        n2 = n3;
                    }
                    for (int j = n2; j <= n3; ++j) {
                        bitSet.set(j);
                    }
                    n2 = -1;
                    n3 = -2;
                    continue block4;
                }
                case ':': {
                    n2 = n3;
                    n3 = -2;
                    continue block4;
                }
                default: {
                    if (!Character.isDigit(c)) continue block4;
                    if (n3 < 0) {
                        n3 = 0;
                    }
                    n3 = (n3 << 3) + (n3 << 1) + (c - 48);
                }
            }
        }
        return bitSet;
    }

    public static String escape(BitSet bitSet, boolean bl) {
        char c;
        char c2 = bl ? (char)'(' : '[';
        char c3 = c = bl ? (char)')' : ']';
        if (bitSet == null) {
            return c2 + "{}" + c;
        }
        StringBuffer stringBuffer = new StringBuffer(c2 + "{");
        int n = bitSet.size();
        int n2 = -1;
        int n3 = -2;
        int n4 = -1;
        while (++n4 <= n) {
            boolean bl2 = bitSet.get(n4);
            if (n4 == n || n2 >= 0 && !bl2) {
                if (n2 >= 0 && n3 != n2) {
                    stringBuffer.append((n3 == n2 - 1 ? " " : ":") + n2);
                }
                if (n4 == n) break;
                n2 = -1;
            }
            if (!bitSet.get(n4)) continue;
            if (n2 < 0) {
                stringBuffer.append((n3 == -2 ? "" : " ") + n4);
                n3 = n4;
            }
            n2 = n4;
        }
        stringBuffer.append("}").append(c);
        return stringBuffer.toString();
    }

    public static String escape(BitSet bitSet) {
        return Escape.escape(bitSet, true);
    }
}

