#!/usr/bin/perl
# The LearningOnline Network with CAPA
# example submissions grader for use with <externalresponse>
#
# $Id: gradesubmission.pl,v 1.2 2005/11/16 23:34:27 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

use strict;
use CGI qw(:standard);

my %form;
&main();
sub main {
    my $q=new CGI;
    print $q->header(-type => 'text/xml');
    %form = $q->Vars();
    my ($result,$message) = &grade();
    &print_result($result,$message);
}

sub print_result {
    my ($result,$message) = @_;
    print("<loncapagrade>\n");
    print("<awarddetail>$result</awarddetail>\n");
    print("<message>$message</message>\n");
    print "</loncapagrade>";
}


sub grade {
    if ($form{'LONCAPA_student_response'} =~ /a/) {
	return ('APPROX_ANS','Go a!');
    } 
    if ($form{'LONCAPA_student_response'} =~ /b/) {
	return ('EXACT_ANS','Go b!');
    }
    if ($form{'LONCAPA_student_response'} =~ /c/) {
	return ('INCORRECT','No c');
    }
    if ($form{'LONCAPA_student_response'} eq 
	$form{'LONCAPA_correct_answer'}) {
	return ('EXACT_ANS','Yep!');
    }

    return ('INCORRECT','Hrrm');
}
