/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.shape.Mesh;
import org.jmol.util.ArrayUtil;

public class IsosurfaceMesh
extends Mesh {
    JvxlData jvxlData = new JvxlData();
    boolean hideBackground;
    int realVertexCount;
    int vertexIncrement = 1;
    int firstRealVertex = -1;
    boolean hasGridPoints;
    float[] vertexValues;
    short[] vertexColixes;
    Hashtable assocGridPointMap;
    Hashtable assocGridPointNormals;
    public BitSet[] surfaceSet;
    public int[] vertexSets;
    public int nSets = 0;

    IsosurfaceMesh(String string, Graphics3D graphics3D, short s) {
        super(string, graphics3D, s);
    }

    void clear(String string, boolean bl, boolean bl2) {
        super.clear(string);
        this.vertexColixes = null;
        this.vertexValues = null;
        this.assocGridPointMap = null;
        this.assocGridPointNormals = null;
        this.vertexSets = null;
        this.isColorSolid = true;
        this.firstRealVertex = -1;
        this.hasGridPoints = bl;
        this.showPoints = bl;
        this.showTriangles = bl2;
        this.jvxlData.jvxlSurfaceData = "";
        this.jvxlData.jvxlEdgeData = "";
        this.jvxlData.jvxlColorData = "";
        this.surfaceSet = null;
        this.nSets = 0;
    }

    void allocVertexColixes() {
        if (this.vertexColixes == null) {
            this.vertexColixes = new short[this.vertexCount];
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = this.colix;
            }
        }
        this.isColorSolid = false;
    }

    public void setColorSchemeSets() {
        this.allocVertexColixes();
        int n = 2;
        for (int i = 0; i < this.surfaceSet.length; ++i) {
            if (this.surfaceSet[i] == null) continue;
            int n2 = Graphics3D.getColorArgb(n++);
            short s = Graphics3D.getColix(n2);
            for (int j = 0; j < this.vertexCount; ++j) {
                if (!this.surfaceSet[i].get(j)) continue;
                this.vertexColixes[j] = s;
            }
        }
    }

    int addVertexCopy(Point3f point3f, float f, int n, boolean bl) {
        int n2 = this.addVertexCopy(point3f, f);
        switch (n) {
            case -1: {
                if (this.firstRealVertex >= 0) break;
                this.firstRealVertex = n2;
                break;
            }
            case -2: {
                this.hasGridPoints = true;
                break;
            }
            case -3: {
                this.vertexIncrement = 3;
                break;
            }
            default: {
                if (this.firstRealVertex < 0) {
                    this.firstRealVertex = n2;
                }
                if (!bl) break;
                if (this.assocGridPointMap == null) {
                    this.assocGridPointMap = new Hashtable();
                    this.assocGridPointNormals = new Hashtable();
                }
                Integer n3 = new Integer(n);
                this.assocGridPointMap.put(new Integer(n2), n3);
                if (this.assocGridPointNormals.containsKey(n3)) break;
                this.assocGridPointNormals.put(n3, new Vector3f(0.0f, 0.0f, 0.0f));
            }
        }
        return n2;
    }

    int addVertexCopy(Point3f point3f, float f) {
        if (this.vertexCount == 0) {
            this.vertexValues = new float[25];
        } else if (this.vertexCount >= this.vertexValues.length) {
            this.vertexValues = ArrayUtil.doubleLength(this.vertexValues);
        }
        this.vertexValues[this.vertexCount] = f;
        return this.addVertexCopy(point3f);
    }

    public void setTranslucent(boolean bl, float f) {
        super.setTranslucent(bl, f);
        if (this.vertexColixes != null) {
            int n = this.vertexCount;
            while (--n >= 0) {
                this.vertexColixes[n] = Graphics3D.getColixTranslucent(this.vertexColixes[n], bl, f);
            }
        }
    }

    void addTriangleCheck(int n, int n2, int n3, int n4) {
        if (this.vertexValues != null && (Float.isNaN(this.vertexValues[n]) || Float.isNaN(this.vertexValues[n2]) || Float.isNaN(this.vertexValues[n3]))) {
            return;
        }
        if (Float.isNaN(this.vertices[n].x) || Float.isNaN(this.vertices[n2].x) || Float.isNaN(this.vertices[n3].x)) {
            return;
        }
        if (this.polygonCount == 0) {
            this.polygonIndexes = new int[25][];
        } else if (this.polygonCount == this.polygonIndexes.length) {
            this.polygonIndexes = (int[][])ArrayUtil.doubleLength(this.polygonIndexes);
        }
        this.polygonIndexes[this.polygonCount++] = new int[]{n, n2, n3, n4};
    }

    void invalidateTriangles() {
        int n = this.polygonCount;
        while (--n >= 0) {
            int[] nArray = this.polygonIndexes[n];
            if (nArray == null) continue;
            int n2 = nArray[0];
            int n3 = nArray[1];
            int n4 = nArray[2];
            if (!Float.isNaN(this.vertexValues[n2]) && !Float.isNaN(this.vertexValues[n3]) && !Float.isNaN(this.vertexValues[n4])) continue;
            this.polygonIndexes[n] = null;
        }
    }

    public void initialize(int n) {
        Vector3f[] vector3fArray = new Vector3f[this.vertexCount];
        int n2 = this.vertexCount;
        while (--n2 >= 0) {
            vector3fArray[n2] = new Vector3f();
        }
        this.sumVertexNormals(vector3fArray, true);
        if (this.assocGridPointMap != null) {
            Integer n3;
            Enumeration enumeration = this.assocGridPointMap.keys();
            while (enumeration.hasMoreElements()) {
                n3 = (Integer)enumeration.nextElement();
                ((Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(n3))).add(vector3fArray[n3]);
            }
            enumeration = this.assocGridPointMap.keys();
            while (enumeration.hasMoreElements()) {
                n3 = (Integer)enumeration.nextElement();
                vector3fArray[n3.intValue()] = (Vector3f)this.assocGridPointNormals.get(this.assocGridPointMap.get(n3));
            }
        }
        this.initializeNormixes(n, vector3fArray);
    }
}

