/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.ByteArrayOutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Point4f;
import javax.vecmath.Vector3f;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolSelectionListener;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolViewer;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.AtomIndexIterator;
import org.jmol.g3d.Font3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.i18n.GT;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIterator;
import org.jmol.modelset.ModelManager;
import org.jmol.modelset.ModelSet;
import org.jmol.shape.Shape;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Base64;
import org.jmol.util.BitSetUtil;
import org.jmol.util.CommandHistory;
import org.jmol.util.Escape;
import org.jmol.util.JpegEncoder;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TempArray;
import org.jmol.util.TextFormat;
import org.jmol.viewer.ColorManager;
import org.jmol.viewer.Eval;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.FrameRenderer;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.MouseManager;
import org.jmol.viewer.MouseManager10;
import org.jmol.viewer.MouseWrapper11;
import org.jmol.viewer.MouseWrapper14;
import org.jmol.viewer.PickingManager;
import org.jmol.viewer.PropertyManager;
import org.jmol.viewer.RepaintManager;
import org.jmol.viewer.ScriptManager;
import org.jmol.viewer.SelectionManager;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.StatusManager;
import org.jmol.viewer.TransformManager;
import org.jmol.viewer.TransformManager10;
import org.jmol.viewer.TransformManager11;

public class Viewer
extends JmolViewer
implements AtomDataServer {
    private Component display;
    private Graphics3D g3d;
    private JmolAdapter modelAdapter;
    private CommandHistory commandHistory = new CommandHistory();
    private ColorManager colorManager;
    private Eval eval;
    private FileManager fileManager;
    private ModelManager modelManager;
    public MouseManager mouseManager;
    private PickingManager pickingManager;
    private PropertyManager propertyManager;
    private RepaintManager repaintManager;
    private ScriptManager scriptManager;
    private SelectionManager selectionManager;
    private StateManager stateManager;
    private StateManager.GlobalSettings global;
    private StatusManager statusManager;
    private TempArray tempManager;
    private TransformManager transformManager;
    private String strJavaVendor;
    private String strJavaVersion;
    private String strOSName;
    private String htmlName = "";
    private boolean jvm11orGreater = false;
    private boolean jvm12orGreater = false;
    private boolean jvm14orGreater = false;
    boolean isSilent = false;
    boolean isApplet = false;
    boolean autoExit = false;
    String writeInfo;
    boolean haveDisplay = true;
    boolean mustRender = true;
    boolean checkScriptOnly = false;
    boolean fileOpenCheck = true;
    static Hashtable dataValues = new Hashtable();
    boolean wasInMotion = false;
    int motionEventNumber;
    private boolean refreshing = true;
    private boolean axesAreTainted = false;
    final Dimension dimScreen = new Dimension();
    String interruptScript = "";
    int scriptIndex;
    boolean checking;
    int hoverAtomIndex = -1;
    String hoverText;
    int n;
    public static final int CURSOR_DEFAULT = 0;
    public static final int CURSOR_HAND = 1;
    public static final int CURSOR_CROSSHAIR = 2;
    public static final int CURSOR_MOVE = 3;
    public static final int CURSOR_WAIT = 4;
    private int currentCursor = 0;
    boolean isTainted = true;

    protected void finalize() throws Throwable {
        Logger.debug("viewer finalize " + this);
        super.finalize();
    }

    public Viewer(Component component, JmolAdapter jmolAdapter) {
        if (Logger.isActiveLevel(0)) {
            Logger.debug("Viewer constructor " + this);
        }
        this.display = component;
        this.modelAdapter = jmolAdapter;
        this.strJavaVendor = System.getProperty("java.vendor");
        this.strOSName = System.getProperty("os.name");
        this.strJavaVersion = System.getProperty("java.version");
        this.jvm11orGreater = this.strJavaVersion.compareTo("1.1") >= 0 && (!this.strJavaVendor.startsWith("Netscape") || this.strJavaVersion.compareTo("1.1.5") > 0 || !"Mac OS".equals(this.strOSName));
        this.jvm12orGreater = this.strJavaVersion.compareTo("1.2") >= 0;
        this.jvm14orGreater = this.strJavaVersion.compareTo("1.4") >= 0;
        this.stateManager = new StateManager(this);
        this.g3d = new Graphics3D(component);
        this.colorManager = new ColorManager(this, this.g3d);
        this.initialize();
        this.statusManager = new StatusManager(this);
        this.scriptManager = new ScriptManager(this);
        this.transformManager = new TransformManager11(this);
        this.selectionManager = new SelectionManager(this);
        this.mouseManager = this.jvm14orGreater ? MouseWrapper14.alloc(component, this) : (this.jvm11orGreater ? MouseWrapper11.alloc(component, this) : new MouseManager10(component, this));
        this.modelManager = new ModelManager(this);
        this.propertyManager = new PropertyManager(this);
        this.tempManager = new TempArray();
        this.pickingManager = new PickingManager(this);
        this.fileManager = new FileManager(this, jmolAdapter);
        this.repaintManager = new RepaintManager(this);
        this.eval = new Eval(this);
    }

    public static JmolViewer allocateViewer(Component component, JmolAdapter jmolAdapter) {
        return new Viewer(component, jmolAdapter);
    }

    public boolean isApplet() {
        return this.htmlName.length() > 0;
    }

    public void setAppletContext(String string, URL uRL, URL uRL2, String string2) {
        this.htmlName = string;
        this.isApplet = uRL != null;
        String string3 = string2;
        if (!this.isApplet) {
            if (string3.indexOf("-i") >= 0) {
                Logger.setLogLevel(3);
                this.isSilent = true;
            }
            if (string3.indexOf("-c") >= 0) {
                this.checkScriptOnly = true;
                this.fileOpenCheck = true;
            }
            if (string3.indexOf("-C") >= 0) {
                this.checkScriptOnly = true;
                this.fileOpenCheck = false;
            }
            if (string3.indexOf("-x") >= 0) {
                this.autoExit = true;
            }
            if (this.display == null || string3.indexOf("-n") >= 0) {
                this.haveDisplay = false;
                this.display = null;
            }
            this.writeInfo = null;
            if (string3.indexOf("-w") >= 0) {
                int n = string3.indexOf("\u0001");
                int n2 = string3.lastIndexOf("\u0001");
                this.writeInfo = string3.substring(n + 1, n2);
            }
            boolean bl = this.mustRender = this.haveDisplay || this.writeInfo != null;
        }
        if (!this.isSilent) {
            Logger.info("(C) 2007 Jmol Development\nJmol Version " + Viewer.getJmolVersion() + "\njava.vendor:" + this.strJavaVendor + "\njava.version:" + this.strJavaVersion + "\nos.name:" + this.strOSName + "\nmemory:" + this.getParameter("_memory") + "\nappletId:" + string);
        }
        if (this.isApplet) {
            this.fileManager.setAppletContext(uRL, uRL2, string2);
        }
        this.zap(false);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    public static String getJmolVersion() {
        return JmolConstants.version + "  " + JmolConstants.date;
    }

    private static int getJmolVersionInt() {
        String string = JmolConstants.version;
        int n = -1;
        try {
            int n2 = string.indexOf(".");
            if (n2 < 0) {
                n = 100000 * Integer.parseInt(string);
                return n;
            }
            n = 100000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf(".")) < 0) {
                return n += 1000 * Integer.parseInt(string);
            }
            n += 1000 * Integer.parseInt(string.substring(0, n2));
            if ((n2 = (string = string.substring(n2 + 1)).indexOf("_")) < 0) {
                n2 = string.length();
            }
            n += Integer.parseInt(string.substring(0, n2));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    String getHtmlName() {
        return this.htmlName;
    }

    boolean mustRenderFlag() {
        return this.mustRender && this.refreshing;
    }

    static int getLogLevel() {
        for (int i = 0; i < 5; ++i) {
            if (!Logger.isActiveLevel(i)) continue;
            return 5 - i;
        }
        return 0;
    }

    public Component getAwtComponent() {
        return this.display;
    }

    public boolean handleOldJvm10Event(Event event) {
        return this.mouseManager.handleOldJvm10Event(event);
    }

    void reset() {
        this.transformManager.homePosition();
        if (this.modelManager.useXtalDefaults()) {
            this.stateManager.setCrystallographicDefaults();
        }
        this.refresh(1, "Viewer:homePosition()");
    }

    public void homePosition() {
        this.script("reset");
    }

    Hashtable getAppletInfo() {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("htmlName", this.htmlName);
        hashtable.put("version", JmolConstants.version);
        hashtable.put("date", JmolConstants.date);
        hashtable.put("javaVendor", this.strJavaVendor);
        hashtable.put("javaVersion", this.strJavaVersion);
        hashtable.put("operatingSystem", this.strOSName);
        return hashtable;
    }

    void initialize() {
        this.resetAllParameters();
    }

    void resetAllParameters() {
        this.global = this.stateManager.getGlobalSettings();
        this.setIntProperty("_version", Viewer.getJmolVersionInt(), true);
        this.colorManager.resetElementColors();
        this.setObjectColor("background", "black");
        this.setObjectColor("axis1", "red");
        this.setObjectColor("axis2", "green");
        this.setObjectColor("axis3", "blue");
        Viewer.setAmbientPercent(this.global.ambientPercent);
        Viewer.setDiffusePercent(this.global.diffusePercent);
        Viewer.setSpecular(this.global.specular);
        Viewer.setSpecularPercent(this.global.specularPercent);
        Viewer.setSpecularExponent(this.global.specularExponent);
        Viewer.setSpecularPower(this.global.specularPower);
        this.setZShade(false);
    }

    String listSavedStates() {
        return this.stateManager.listSavedStates();
    }

    void saveOrientation(String string) {
        this.stateManager.saveOrientation(string);
    }

    boolean restoreOrientation(String string, float f) {
        return this.stateManager.restoreOrientation(string, f);
    }

    void saveBonds(String string) {
        this.stateManager.saveBonds(string);
    }

    boolean restoreBonds(String string) {
        return this.stateManager.restoreBonds(string);
    }

    void saveState(String string) {
        this.stateManager.saveState(string);
    }

    String getSavedState(String string) {
        return this.stateManager.getSavedState(string);
    }

    void saveStructure(String string) {
        this.stateManager.saveStructure(string);
    }

    String getSavedStructure(String string) {
        return this.stateManager.getSavedStructure(string);
    }

    void saveSelection(String string) {
        this.stateManager.saveSelection(string, this.selectionManager.bsSelection);
        this.stateManager.restoreSelection(string);
    }

    boolean restoreSelection(String string) {
        return this.stateManager.restoreSelection(string);
    }

    public float getRotationRadius() {
        return this.transformManager.getRotationRadius();
    }

    public void setRotationRadius(float f) {
        this.transformManager.setRotationRadius(f);
    }

    Point3f getRotationCenter() {
        return this.transformManager.getRotationCenter();
    }

    void setCenterAt(String string, Point3f point3f) {
        this.transformManager.setCenterAt(string, point3f);
        this.refresh(0, "Viewer:setCenter(" + string + ")");
    }

    void setCenterBitSet(BitSet bitSet, boolean bl) {
        Point3f point3f = bitSet != null && BitSetUtil.cardinalityOf(bitSet) > 0 ? this.getAtomSetCenter(bitSet) : null;
        this.transformManager.setNewRotationCenter(point3f, bl);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    void setNewRotationCenter(Point3f point3f) {
        this.transformManager.setNewRotationCenter(point3f, true);
        this.refresh(0, "Viewer:setCenterBitSet()");
    }

    Point3f getNavigationCenter() {
        return this.transformManager.getNavigationCenter();
    }

    public boolean getNavigationCentered() {
        return this.transformManager.isNavigationCentered();
    }

    float getNavigationDepthPercent() {
        return this.transformManager.getNavigationDepthPercent();
    }

    void navigate(int n, int n2) {
        this.transformManager.navigate(n, n2);
        if (!this.transformManager.vibrationOn) {
            this.refresh(1, "Viewer:navigate()");
        }
    }

    public Point3f getNavigationOffset() {
        return this.transformManager.getNavigationOffset();
    }

    float getNavigationOffsetPercent(char c) {
        return this.transformManager.getNavigationOffsetPercent(c);
    }

    public boolean getNavigating() {
        return this.transformManager.getNavigating();
    }

    boolean isInPosition(Point3f point3f, float f) {
        return this.transformManager.isInPosition(point3f, f);
    }

    void move(Vector3f vector3f, float f, Vector3f vector3f2, float f2, float f3, int n) {
        this.transformManager.move(vector3f, f, vector3f2, f2, f3, n);
    }

    void moveTo(float f, Point3f point3f, Point3f point3f2, float f2, float f3, float f4, float f5, float f6, Point3f point3f3, float f7, float f8, float f9) {
        this.transformManager.moveTo(f, point3f, point3f2, f2, f3, f4, f5, f6, point3f3, f7, f8, f9);
    }

    void moveTo(float f, Matrix3f matrix3f, Point3f point3f, float f2, float f3, float f4, float f5, Point3f point3f2, float f6, float f7, float f8) {
        this.transformManager.moveTo(f, matrix3f, point3f, f2, f3, f4, f5, point3f2, f6, f7, f8);
    }

    String getMoveToText(float f) {
        return this.transformManager.getMoveToText(f);
    }

    void navigate(float f, Point3f[] point3fArray, float[] fArray, int n, int n2) {
        this.transformManager.navigate(f, point3fArray, fArray, n, n2);
        this.refresh(1, "navigate");
    }

    void navigate(float f, Point3f point3f) {
        this.transformManager.navigate(f, point3f);
        this.refresh(1, "navigate");
    }

    void navigate(float f, Point3f[][] point3fArray) {
        this.transformManager.navigate(f, point3fArray);
        this.refresh(1, "navigate");
    }

    void navigate(float f, Vector3f vector3f, float f2) {
        this.transformManager.navigate(f, vector3f, f2);
        this.refresh(1, "navigate");
    }

    void navTranslate(float f, Point3f point3f) {
        this.transformManager.navTranslate(f, point3f);
        this.refresh(1, "navigate");
    }

    void navTranslatePercent(float f, float f2, float f3) {
        this.transformManager.navTranslatePercent(f, f2, f3);
        this.refresh(1, "navigate");
    }

    void rotateMolecule(int n, int n2) {
        this.setRotateSelected(true);
        this.setRotateMolecule(true);
        this.rotateXYBy(n, n2);
        this.setRotateMolecule(false);
        this.setRotateSelected(false);
    }

    void rotateXYBy(int n, int n2) {
        this.transformManager.rotateXYBy(n, n2);
        this.refresh(1, "Viewer:rotateXYBy()");
    }

    void rotateZBy(int n) {
        this.transformManager.rotateZBy(n);
        this.refresh(1, "Viewer:rotateZBy()");
    }

    public void rotateFront() {
        this.transformManager.rotateFront();
        this.refresh(1, "Viewer:rotateFront()");
    }

    public void rotateToX(float f) {
        this.transformManager.rotateToX(f);
        this.refresh(1, "Viewer:rotateToX()");
    }

    public void rotateToY(float f) {
        this.transformManager.rotateToY(f);
        this.refresh(1, "Viewer:rotateToY()");
    }

    public void rotateToZ(float f) {
        this.transformManager.rotateToZ(f);
        this.refresh(1, "Viewer:rotateToZ()");
    }

    public void rotateToX(int n) {
        this.rotateToX((float)n * ((float)Math.PI / 180));
    }

    public void rotateToY(int n) {
        this.rotateToY((float)n * ((float)Math.PI / 180));
    }

    void translateXYBy(int n, int n2) {
        this.transformManager.translateXYBy(n, n2);
        this.refresh(1, "Viewer:translateXYBy()");
    }

    void translateToXPercent(float f) {
        this.transformManager.translateToXPercent(f);
        this.refresh(1, "Viewer:translateToXPercent()");
    }

    void translateToYPercent(float f) {
        this.transformManager.translateToYPercent(f);
        this.refresh(1, "Viewer:translateToYPercent()");
    }

    void translateToZPercent(float f) {
        this.transformManager.translateToZPercent(f);
        this.refresh(1, "Viewer:translateToZPercent()");
    }

    float getTranslationXPercent() {
        return this.transformManager.getTranslationXPercent();
    }

    float getTranslationYPercent() {
        return this.transformManager.getTranslationYPercent();
    }

    float getTranslationZPercent() {
        return this.transformManager.getTranslationZPercent();
    }

    String getTranslationScript() {
        return this.transformManager.getTranslationScript();
    }

    void zoomBy(int n) {
        this.transformManager.zoomBy(n);
        this.refresh(1, "Viewer:zoomBy()");
    }

    public int getZoomPercent() {
        return (int)this.getZoomPercentFloat();
    }

    public float getZoomPercentFloat() {
        return this.transformManager.getZoomPercentFloat();
    }

    float getMaxZoomPercent() {
        return 200000.0f;
    }

    void zoomToPercent(float f) {
        this.transformManager.zoomToPercent(f);
        this.refresh(1, "Viewer:zoomToPercent()");
    }

    void zoomByPercent(int n) {
        this.transformManager.zoomByPercent(n);
        this.refresh(1, "Viewer:zoomByPercent()");
    }

    private void setZoomEnabled(boolean bl) {
        this.global.setParameterValue("zoomEnabled", bl);
        this.transformManager.setZoomEnabled(bl);
        this.refresh(1, "Viewer:setZoomEnabled()");
    }

    void slabReset() {
        this.transformManager.slabReset();
    }

    boolean getZoomEnabled() {
        return this.transformManager.zoomEnabled;
    }

    public boolean getSlabEnabled() {
        return this.transformManager.slabEnabled;
    }

    void slabByPixels(int n) {
        this.transformManager.slabByPercentagePoints(n);
        this.refresh(0, "Viewer:slabByPixels()");
    }

    void depthByPixels(int n) {
        this.transformManager.depthByPercentagePoints(n);
        this.refresh(0, "Viewer:depthByPixels()");
    }

    void slabDepthByPixels(int n) {
        this.transformManager.slabDepthByPercentagePoints(n);
        this.refresh(0, "Viewer:slabDepthByPixels()");
    }

    void slabToPercent(int n) {
        this.transformManager.slabToPercent(n);
        this.refresh(0, "Viewer:slabToPercent()");
    }

    void slabInternal(Point4f point4f, boolean bl) {
        this.transformManager.slabInternal(point4f, bl);
    }

    Point4f getDepthPlane(boolean bl) {
        return this.transformManager.getDepthPlane(bl);
    }

    Point4f getSlabPlane(boolean bl) {
        return this.transformManager.getSlabPlane(bl);
    }

    void slabInternalReference(Point3f point3f) {
        this.transformManager.slabInternalReference(point3f);
    }

    Point3f getSlabInternalReference() {
        return this.transformManager.slabRef;
    }

    void depthToPercent(int n) {
        this.transformManager.depthToPercent(n);
        this.refresh(0, "Viewer:depthToPercent()");
    }

    private void setSlabEnabled(boolean bl) {
        this.transformManager.setSlabEnabled(bl);
        this.refresh(0, "Viewer:setSlabEnabled()");
    }

    void setSlabDepthInternal(boolean bl) {
        this.transformManager.setSlabDepthInternal(bl);
    }

    public Matrix4f getUnscaledTransformMatrix() {
        return this.transformManager.getUnscaledTransformMatrix();
    }

    void finalizeTransformParameters() {
        this.transformManager.finalizeTransformParameters();
        this.g3d.setSlabAndDepthValues(this.transformManager.slabValue, this.transformManager.depthValue, this.global.zShade);
    }

    public Point3i transformPoint(Point3f point3f) {
        return this.transformManager.transformPoint(point3f);
    }

    public Point3i transformPoint(Point3f point3f, Vector3f vector3f) {
        return this.transformManager.transformPoint(point3f, vector3f);
    }

    public void transformPoint(Point3f point3f, Point3i point3i) {
        this.transformManager.transformPoint(point3f, point3i);
    }

    public void transformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.transformPoint(point3f, point3f2);
    }

    public void transformPoints(Point3f[] point3fArray, Point3i[] point3iArray) {
        this.transformManager.transformPoints(point3fArray.length, point3fArray, point3iArray);
    }

    public void transformVector(Vector3f vector3f, Vector3f vector3f2) {
        this.transformManager.transformVector(vector3f, vector3f2);
    }

    public void unTransformPoint(Point3f point3f, Point3f point3f2) {
        this.transformManager.unTransformPoint(point3f, point3f2);
    }

    public float getScalePixelsPerAngstrom() {
        return this.transformManager.scalePixelsPerAngstrom;
    }

    public short scaleToScreen(int n, int n2) {
        return this.transformManager.scaleToScreen(n, n2);
    }

    public float scaleToPerspective(int n, float f) {
        return this.transformManager.scaleToPerspective(n, f);
    }

    private void setScaleAngstromsPerInch(float f) {
        this.transformManager.setScaleAngstromsPerInch(f);
    }

    void setSpinX(int n) {
        this.transformManager.setSpinX(n);
    }

    String getSpinState() {
        return this.transformManager.getSpinState(false);
    }

    float getSpinX() {
        return this.transformManager.spinX;
    }

    void setSpinY(int n) {
        this.transformManager.setSpinY(n);
    }

    float getSpinY() {
        return this.transformManager.spinY;
    }

    void setSpinZ(int n) {
        this.transformManager.setSpinZ(n);
    }

    float getSpinZ() {
        return this.transformManager.spinZ;
    }

    void setSpinFps(int n) {
        this.transformManager.setSpinFps(n);
    }

    float getSpinFps() {
        return this.transformManager.spinFps;
    }

    void setSpinOn(boolean bl) {
        this.transformManager.setSpinOn(bl);
    }

    boolean getSpinOn() {
        return this.transformManager.getSpinOn();
    }

    String getOrientationText() {
        return this.transformManager.getOrientationText();
    }

    Hashtable getOrientationInfo() {
        return this.transformManager.getOrientationInfo();
    }

    Matrix3f getMatrixRotate() {
        return this.transformManager.getMatrixRotate();
    }

    void getAxisAngle(AxisAngle4f axisAngle4f) {
        this.transformManager.getAxisAngle(axisAngle4f);
    }

    String getTransformText() {
        return this.transformManager.getTransformText();
    }

    void getRotation(Matrix3f matrix3f) {
        this.transformManager.getRotation(matrix3f);
    }

    private void setDefaultColors(String string) {
        this.colorManager.setDefaultColors(string);
    }

    private void setDefaultTranslucent(float f) {
        this.global.defaultTranslucent = f;
    }

    float getDefaultTranslucent() {
        return this.global.defaultTranslucent;
    }

    public int getColixArgb(short s) {
        return this.g3d.getColixArgb(s);
    }

    void setRubberbandArgb(int n) {
        this.colorManager.setRubberbandArgb(n);
    }

    public short getColixRubberband() {
        return this.colorManager.colixRubberband;
    }

    void setElementArgb(int n, int n2) {
        this.global.setParameterValue("_color " + JmolConstants.elementNameFromNumber(n), Escape.escapeColor(n2));
        this.colorManager.setElementArgb(n, n2);
    }

    public float getVectorScale() {
        return this.global.vectorScale;
    }

    public void setVectorScale(float f) {
        this.global.setParameterValue("vectorScale", f);
        this.global.vectorScale = f;
        this.refresh(0, "set vectorScale");
    }

    float getVibrationScale() {
        return this.global.vibrationScale;
    }

    float getVibrationPeriod() {
        return this.global.vibrationPeriod;
    }

    public void setVibrationScale(float f) {
        this.transformManager.setVibrationScale(f);
        this.global.vibrationScale = f;
        this.global.setParameterValue("vibrationScale", f);
    }

    void setVibrationOff() {
        this.transformManager.setVibrationPeriod(0.0f);
    }

    public void setVibrationPeriod(float f) {
        this.transformManager.setVibrationPeriod(f);
        this.global.vibrationPeriod = f = Math.abs(f);
        this.global.setParameterValue("vibrationPeriod", f);
    }

    void setObjectColor(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            return;
        }
        this.setObjectArgb(string, Graphics3D.getArgbFromString(string2));
    }

    void setObjectArgb(String string, int n) {
        int n2 = StateManager.getObjectIdFromName(string);
        if (n2 < 0) {
            return;
        }
        this.global.objColors[n2] = n;
        switch (n2) {
            case 0: {
                this.g3d.setBackgroundArgb(n);
                this.colorManager.setColixBackgroundContrast(n);
            }
        }
        this.global.setParameterValue(string + "Color", Escape.escapeColor(n));
    }

    int getObjectArgb(int n) {
        return this.global.objColors[n];
    }

    public short getObjectColix(int n) {
        int n2 = this.getObjectArgb(n);
        if (n2 == 0) {
            return this.getColixBackgroundContrast();
        }
        return Graphics3D.getColix(n2);
    }

    public String getObjectState(String string) {
        int n = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n < 0) {
            return "";
        }
        short s = this.getObjectMad(n);
        StringBuffer stringBuffer = new StringBuffer();
        Shape.appendCmd(stringBuffer, string + (s == 0 ? " off" : (s == 1 ? " on" : (s == -1 ? " dotted" : (s < 20 ? " " + s : " " + (float)s / 2000.0f)))));
        return stringBuffer.toString();
    }

    public void setColorBackground(String string) {
        this.setObjectColor("background", string);
    }

    public int getBackgroundArgb() {
        return this.getObjectArgb(0);
    }

    void setObjectMad(int n, String string, short s) {
        int n2 = StateManager.getObjectIdFromName(string.equalsIgnoreCase("axes") ? "axis" : string);
        if (n2 < 0) {
            return;
        }
        if (s == -2 || s == -4) {
            short s2 = (short)(s + 3);
            s = this.getObjectMad(n2);
            if (s == 0) {
                s = s2;
            }
        }
        this.global.setParameterValue("show" + string, s != 0);
        boolean bl = this.global.objStateOn[n2] = s != 0;
        if (s == 0) {
            return;
        }
        this.global.objMad[n2] = s;
        this.setShapeSize(n, s);
    }

    public short getObjectMad(int n) {
        return this.global.objStateOn[n] ? this.global.objMad[n] : (short)0;
    }

    void setPropertyColorScheme(String string) {
        this.global.propertyColorScheme = string;
    }

    String getPropertyColorScheme() {
        return this.global.propertyColorScheme;
    }

    public short getColixBackgroundContrast() {
        return this.colorManager.colixBackgroundContrast;
    }

    String getSpecularState() {
        return this.global.getSpecularState();
    }

    private static void setSpecular(boolean bl) {
        ColorManager.setSpecular(bl);
    }

    boolean getSpecular() {
        return ColorManager.getSpecular();
    }

    private static void setSpecularPower(int n) {
        ColorManager.setSpecularPower(Math.abs(n));
    }

    private static void setSpecularExponent(int n) {
        ColorManager.setSpecularPower(-Math.abs(n));
    }

    private static void setAmbientPercent(int n) {
        ColorManager.setAmbientPercent(n);
    }

    static int getAmbientPercent() {
        return ColorManager.getAmbientPercent();
    }

    private static void setDiffusePercent(int n) {
        ColorManager.setDiffusePercent(n);
    }

    static int getDiffusePercent() {
        return ColorManager.getDiffusePercent();
    }

    private static void setSpecularPercent(int n) {
        ColorManager.setSpecularPercent(n);
    }

    static int getSpecularPercent() {
        return ColorManager.getSpecularPercent();
    }

    private void setZShade(boolean bl) {
        this.global.zShade = bl;
    }

    boolean getZShade() {
        return this.global.zShade;
    }

    public short getColixAtomPalette(Atom atom, byte by) {
        return this.colorManager.getColixAtomPalette(atom, by);
    }

    public static short getColixHbondType(short s) {
        return ColorManager.getColixHbondType(s);
    }

    int setColorScheme(String string) {
        return this.colorManager.setColorScheme(string);
    }

    short getColixFromPalette(float f, float f2, float f3) {
        return this.colorManager.getColixFromPalette(f, f2, f3);
    }

    void select(BitSet bitSet, boolean bl) {
        this.selectionManager.select(bitSet, bl);
        this.modelManager.setShapeSize(1, Integer.MAX_VALUE, null);
    }

    void selectBonds(BitSet bitSet) {
        this.modelManager.setShapeSize(1, Integer.MAX_VALUE, bitSet);
    }

    BitSet getSelectedAtoms() {
        return this.selectionManager.getSelectedAtoms();
    }

    void hide(BitSet bitSet, boolean bl) {
        this.selectionManager.hide(bitSet, bl);
    }

    void display(BitSet bitSet, BitSet bitSet2, boolean bl) {
        this.selectionManager.display(bitSet, bitSet2, bl);
    }

    BitSet getHiddenSet() {
        return this.selectionManager.getHiddenSet();
    }

    public boolean isSelected(int n) {
        return this.selectionManager.isSelected(n);
    }

    boolean isInSelectionSubset(int n) {
        return this.selectionManager.isInSelectionSubset(n);
    }

    void reportSelection(String string) {
        if (this.modelManager.getSelectionHaloEnabled()) {
            this.setTainted(true);
        }
        this.scriptStatus(string);
    }

    public Point3f getAtomSetCenter(BitSet bitSet) {
        return this.modelManager.getAtomSetCenter(bitSet);
    }

    public void selectAll() {
        this.selectionManager.selectAll();
        this.refresh(0, "Viewer:selectAll()");
    }

    public void clearSelection() {
        this.selectionManager.clearSelection();
        this.refresh(0, "Viewer:clearSelection()");
    }

    public void setSelectionSet(BitSet bitSet) {
        this.selectionManager.setSelectionSet(bitSet);
        this.refresh(0, "Viewer:setSelectionSet()");
    }

    void setSelectionSubset(BitSet bitSet) {
        this.selectionManager.setSelectionSubset(bitSet);
    }

    private void setHideNotSelected(boolean bl) {
        this.selectionManager.setHideNotSelected(bl);
    }

    void invertSelection() {
        this.selectionManager.invertSelection();
    }

    public BitSet getSelectionSet() {
        return this.selectionManager.bsSelection;
    }

    public int getSelectionCount() {
        return this.selectionManager.getSelectionCount();
    }

    void setFormalCharges(int n) {
        this.modelManager.setFormalCharges(this.selectionManager.bsSelection, n);
    }

    public void addSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    public void removeSelectionListener(JmolSelectionListener jmolSelectionListener) {
        this.selectionManager.addListener(jmolSelectionListener);
    }

    BitSet getAtomBitSet(Object object) {
        return Eval.getAtomBitSet(this.eval, this, object);
    }

    Vector getAtomBitSetVector(Object object) {
        return Eval.getAtomBitSetVector(this.eval, this, object);
    }

    public void setModeMouse(int n) {
        this.mouseManager.setModeMouse(n);
    }

    Rectangle getRubberBandSelection() {
        return this.mouseManager.getRubberBand();
    }

    public int getCursorX() {
        return this.mouseManager.xCurrent;
    }

    public int getCursorY() {
        return this.mouseManager.yCurrent;
    }

    private void setAppletProxy(String string) {
        this.fileManager.setAppletProxy(string);
    }

    private void setDefaultDirectory(String string) {
        this.global.defaultDirectory = string == null || string.length() == 0 ? null : TextFormat.simpleReplace(string, "\\", "/");
    }

    String getDefaultDirectory() {
        return this.global.defaultDirectory;
    }

    Object getInputStreamOrErrorMessageFromName(String string) {
        return this.fileManager.getInputStreamOrErrorMessageFromName(string);
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String string) {
        return this.fileManager.getUnzippedBufferedReaderOrErrorMessageFromName(string);
    }

    Object getBufferedReaderForString(String string) {
        return this.fileManager.getBufferedReaderForString(string);
    }

    public void openFile(String string) {
        String string2 = this.fileManager.getFileTypeName(string);
        this.checkHalt("exit");
        this.script((string2 == null ? "script " : "load ") + Escape.escape(TextFormat.simpleReplace(string, "\\", "/")));
    }

    void openFile(String string, Hashtable hashtable, String string2, boolean bl) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("string")) {
            this.openStringInline(this.fileManager.inlineData, hashtable, bl);
            return;
        }
        if (string.equalsIgnoreCase("string[]")) {
            this.openStringsInline(this.fileManager.inlineDataArray, hashtable, bl);
            return;
        }
        if (!bl) {
            this.zap(false);
        }
        long l = System.currentTimeMillis();
        this.fileManager.openFile(string, hashtable, string2, bl);
        long l2 = System.currentTimeMillis() - l;
        this.setStatusFileLoaded(1, string, "", this.getModelSetName(), null, null);
        String string3 = "";
        Logger.info("openFile(" + string + string3 + ")" + l2 + " ms");
    }

    public void openFiles(String string, String[] stringArray) {
        this.openFiles(string, stringArray, null, false);
    }

    void openFiles(String string, String[] stringArray, String string2, boolean bl) {
        if (!bl) {
            this.zap(false);
        }
        long l = System.currentTimeMillis();
        this.fileManager.openFiles(string, stringArray, string2, bl);
        long l2 = System.currentTimeMillis() - l;
        for (int i = 0; i < stringArray.length; ++i) {
            this.setStatusFileLoaded(1, stringArray[i], "", this.getModelSetName(), null, null);
        }
        Logger.info("openFiles(" + stringArray.length + ") " + l2 + " ms");
    }

    public void openStringInline(String string) {
        this.openStringInline(string, null, false);
    }

    private void openStringInline(String string, Hashtable hashtable, boolean bl) {
        if (!bl) {
            this.clear();
        }
        this.fileManager.openStringInline(string, hashtable, bl);
        String string2 = this.getOpenFileError(bl);
        if (string2 == null) {
            this.setStatusFileLoaded(1, "string", "", this.getModelSetName(), null, null);
        }
    }

    private void openStringsInline(String[] stringArray, Hashtable hashtable, boolean bl) {
        if (!bl) {
            this.clear();
        }
        this.fileManager.openStringsInline(stringArray, hashtable, bl);
        String string = this.getOpenFileError(bl);
        if (string == null) {
            this.setStatusFileLoaded(1, "string[]", "", this.getModelSetName(), null, null);
        }
    }

    public char getInlineChar() {
        return this.global.inlineNewlineChar;
    }

    public void loadInline(String string) {
        this.loadInline(string, this.global.inlineNewlineChar);
    }

    public void loadInline(String string, char c) {
        this.loadInline(string, c, false);
    }

    void loadInline(String string, char c, boolean bl) {
        String string2;
        int n;
        if (string == null) {
            return;
        }
        int[] nArray = this.global.getDefaultLatticeArray();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("params", nArray);
        if (this.global.applySymmetryToBonds) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        Logger.debug(string);
        if (c != '\u0000' && c != '\n') {
            int n2 = string.length();
            for (n = 0; n < n2 && string.charAt(n) == ' '; ++n) {
            }
            if (n < n2 && string.charAt(n) == c) {
                string = string.substring(n + 1);
            }
            string = TextFormat.simpleReplace(string, "" + c, "\n");
        }
        if ((string2 = (String)this.global.getParameter("dataseparator")) != null && string2 != "" && (n = string.indexOf(string2)) >= 0) {
            int n3 = 2;
            while ((n = string.indexOf(string2, n + 1)) >= 0) {
                ++n3;
            }
            String[] stringArray = new String[n3];
            int n4 = 0;
            int n5 = 0;
            for (n = 0; n < n3; ++n) {
                n4 = string.indexOf(string2, n5);
                if (n4 < 0) {
                    n4 = string.length();
                }
                stringArray[n] = string.substring(n5, n4);
                n5 = n4 + string2.length();
            }
            this.openStringsInline(stringArray, hashtable, bl);
            return;
        }
        this.openStringInline(string, hashtable, bl);
    }

    public void loadInline(String[] stringArray) {
        this.loadInline(stringArray, false);
    }

    void loadInline(String[] stringArray, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        int[] nArray = this.global.getDefaultLatticeArray();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("params", nArray);
        if (this.global.applySymmetryToBonds) {
            hashtable.put("applySymmetryToBonds", Boolean.TRUE);
        }
        this.openStringsInline(stringArray, hashtable, bl);
    }

    public boolean getApplySymmetryToBonds() {
        return this.global.applySymmetryToBonds;
    }

    void setApplySymmetryToBonds(boolean bl) {
        this.global.applySymmetryToBonds = bl;
    }

    void loadCoordinates(String string) {
        this.modelManager.loadCoordinates(string);
    }

    public void openDOM(Object object) {
        this.clear();
        long l = System.currentTimeMillis();
        this.fileManager.openDOM(object);
        long l2 = System.currentTimeMillis() - l;
        Logger.info("openDOM " + l2 + " ms");
        this.setStatusFileLoaded(1, "JSNode", "", this.getModelSetName(), null, this.getOpenFileError());
    }

    public void openReader(String string, String string2, Reader reader) {
        this.clear();
        this.fileManager.openReader(string, string2, reader);
        this.getOpenFileError();
        System.gc();
    }

    public String getOpenFileError() {
        return this.getOpenFileError(false);
    }

    String getOpenFileError(boolean bl) {
        String string = this.getFullPathName();
        String string2 = this.getFileName();
        Object object = this.fileManager.waitForClientFileOrErrorMessage();
        if (object instanceof String || object == null) {
            String string3 = (String)object;
            this.setStatusFileNotLoaded(string, string3);
            if (string3 != null) {
                this.zap(string3);
            }
            return string3;
        }
        if (bl) {
            this.modelManager.merge(this.modelAdapter, object);
            if (this.eval != null) {
                this.eval.clearDefinitionsAndLoadPredefined();
            }
            this.selectAll();
            this.setTainted(true);
        } else {
            this.openClientFile(string, string2, object);
        }
        return null;
    }

    public void openClientFile(String string, String string2, Object object) {
        this.setStatusFileLoaded(2, string, string2, this.modelManager.getModelSetName(), object, null);
        this.pushHoldRepaint();
        this.modelManager.setClientFile(string, string2, this.modelAdapter, object);
        this.initializeModel();
        this.popHoldRepaint();
        this.setStatusFileLoaded(3, string, string2, this.modelManager.getModelSetName(), object, null);
    }

    public String getCurrentFileAsString() {
        if (this.getFullPathName() == "string") {
            return this.fileManager.inlineData;
        }
        if (this.getFullPathName() == "string[]") {
            int n = this.getDisplayModelIndex();
            if (n < 0) {
                return "";
            }
            return this.fileManager.inlineDataArray[n];
        }
        if (this.getFullPathName() == "JSNode") {
            return "<DOM NODE>";
        }
        String string = this.modelManager.getModelSetPathName();
        if (string == null) {
            return null;
        }
        return this.fileManager.getFileAsString(string);
    }

    public String getFileAsString(String string) {
        return this.fileManager.getFileAsString(string);
    }

    public String getFullPathName() {
        return this.fileManager.getFullPathName();
    }

    public String getFileName() {
        return this.fileManager.getFileName();
    }

    public Point3f[] calculateSurface(BitSet bitSet, BitSet bitSet2, float f) {
        if (bitSet == null) {
            bitSet = this.getSelectionSet();
        }
        return this.modelManager.calculateSurface(bitSet, bitSet2, f);
    }

    public AtomIterator getWithinModelIterator(Atom atom, float f) {
        return this.modelManager.getWithinModelIterator(atom, f);
    }

    public AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        return this.modelManager.getWithinAtomSetIterator(n, f, bitSet, bl, bl2);
    }

    public void fillAtomData(AtomData atomData, int n) {
        atomData.fileName = this.getFileName();
        this.modelManager.fillAtomData(atomData, n);
    }

    void addStateScript(String string) {
        this.modelManager.addStateScript(string);
    }

    public boolean getEchoStateActive() {
        return this.modelManager.getEchoStateActive();
    }

    void setEchoStateActive(boolean bl) {
        this.modelManager.setEchoStateActive(bl);
    }

    void zap(boolean bl) {
        this.clear();
        this.modelManager.zap();
        this.initializeModel();
        Runtime runtime = Runtime.getRuntime();
        runtime.gc();
        long l = runtime.totalMemory();
        long l2 = runtime.freeMemory();
        long l3 = 0L;
        try {
            l3 = runtime.maxMemory();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Logger.debug("ZAP memory inuse, total, free, max: " + (l - l2) + " " + l + " " + l2 + " " + l3);
        if (bl) {
            this.setStatusFileLoaded(0, null, null, null, null, null);
        }
    }

    private void zap(String string) {
        this.zap(true);
        this.echoMessage(string);
    }

    void echoMessage(String string) {
        int n = 21;
        this.loadShape(n);
        this.setShapeProperty(n, "font", this.getFont3D("SansSerif", "Plain", 9));
        this.setShapeProperty(n, "target", "error");
        this.setShapeProperty(n, "text", string);
    }

    private void clear() {
        if (this.modelManager.getModelSet() == null) {
            return;
        }
        this.fileManager.clear();
        this.repaintManager.clear();
        this.transformManager.clear();
        this.pickingManager.clear();
        this.selectionManager.clear();
        this.clearAllMeasurements();
        this.modelManager.clear();
        this.mouseManager.clear();
        this.statusManager.clear();
        StateManager.clear(this.global);
        this.tempManager.clear();
        this.refresh(0, "Viewer:clear()");
        System.gc();
    }

    private void initializeModel() {
        this.reset();
        this.selectAll();
        this.transformManager.setCenter();
        if (this.eval != null) {
            this.eval.clearDefinitionsAndLoadPredefined();
        }
        this.repaintManager.initializePointers(1);
        this.setCurrentModelIndex(0);
        this.setBackgroundModelIndex(-1);
        this.setFrankOn(this.getShowFrank());
        this.mouseManager.startHoverWatcher(true);
        this.setTainted(true);
    }

    public String getModelSetName() {
        return this.modelManager.getModelSetName();
    }

    public String getModelSetFileName() {
        return this.modelManager.getModelSetFileName();
    }

    public String getUnitCellInfoText() {
        return this.modelManager.getUnitCellInfoText();
    }

    public String getSpaceGroupInfoText(String string) {
        return this.modelManager.getSpaceGroupInfoText(string);
    }

    public int getSpaceGroupIndexFromName(String string) {
        return this.modelManager.getSpaceGroupIndexFromName(string);
    }

    void getPolymerPointsAndVectors(BitSet bitSet, Vector vector) {
        this.modelManager.getPolymerPointsAndVectors(bitSet, vector);
    }

    public String getModelSetProperty(String string) {
        return this.modelManager.getModelSetProperty(string);
    }

    public Object getModelSetAuxiliaryInfo(String string) {
        return this.modelManager.getModelSetAuxiliaryInfo(string);
    }

    public String getModelSetPathName() {
        return this.modelManager.getModelSetPathName();
    }

    public String getModelSetTypeName() {
        return this.modelManager.getModelSetTypeName();
    }

    public boolean haveFrame() {
        return this.haveModelSet();
    }

    boolean haveModelSet() {
        return this.modelManager.getModelSet() != null;
    }

    public void calculateStructures() {
        this.modelManager.calculateStructures(this.getCurrentModelIndex());
        this.addStateScript("calculate structure");
    }

    void clearBfactorRange() {
        this.modelManager.clearBfactorRange();
    }

    public String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        return this.modelManager.getHybridizationAndAxes(n, vector3f, vector3f2, string, bl);
    }

    public BitSet getModelAtomBitSet(int n) {
        return this.modelManager.getModelAtomBitSet(n);
    }

    public BitSet getModelBitSet(BitSet bitSet) {
        return this.modelManager.getModelBitSet(bitSet);
    }

    Object getClientFile() {
        return null;
    }

    public String getClientAtomStringProperty(Object object, String string) {
        if (this.modelAdapter == null || string == null || string.length() == 0) {
            return null;
        }
        return this.modelAdapter.getClientAtomStringProperty(object, string);
    }

    JmolAdapter getExportJmolAdapter() {
        return null;
    }

    public ModelSet getModelSet() {
        return this.modelManager.getModelSet();
    }

    public Point3f getBoundBoxCenter() {
        return this.modelManager.getBoundBoxCenter();
    }

    Point3f getAverageAtomPoint() {
        return this.modelManager.getAverageAtomPoint();
    }

    float calcRotationRadius(Point3f point3f) {
        return this.modelManager.calcRotationRadius(point3f);
    }

    float calcRotationRadius(BitSet bitSet) {
        return this.modelManager.calcRotationRadius(bitSet);
    }

    public Vector3f getBoundBoxCornerVector() {
        return this.modelManager.getBoundBoxCornerVector();
    }

    Hashtable getBoundBoxInfo() {
        return this.modelManager.getBoundBoxInfo();
    }

    public int getBoundBoxCenterX() {
        return this.dimScreen.width / 2;
    }

    public int getBoundBoxCenterY() {
        return this.dimScreen.height / 2;
    }

    public int getModelCount() {
        return this.modelManager.getModelCount();
    }

    String getModelInfoAsString() {
        return this.modelManager.getModelInfoAsString();
    }

    String getSymmetryInfoAsString() {
        return this.modelManager.getSymmetryInfoAsString();
    }

    public Properties getModelSetProperties() {
        return this.modelManager.getModelSetProperties();
    }

    public Hashtable getModelSetAuxiliaryInfo() {
        return this.modelManager.getModelSetAuxiliaryInfo();
    }

    public int getModelNumber(int n) {
        if (n < 0) {
            return n;
        }
        return this.modelManager.getModelNumber(n);
    }

    public int getModelFileNumber(int n) {
        if (n < 0) {
            return 0;
        }
        return this.modelManager.getModelFileNumber(n);
    }

    public String getModelNumberDotted(int n) {
        if (n < 0) {
            return "0";
        }
        return this.getModelName(-1 - n);
    }

    public String getModelName(int n) {
        return this.modelManager.getModelName(n);
    }

    public Properties getModelProperties(int n) {
        return this.modelManager.getModelProperties(n);
    }

    public String getModelProperty(int n, String string) {
        return this.modelManager.getModelProperty(n, string);
    }

    public Hashtable getModelAuxiliaryInfo(int n) {
        return this.modelManager.getModelAuxiliaryInfo(n);
    }

    public Object getModelAuxiliaryInfo(int n, String string) {
        return this.modelManager.getModelAuxiliaryInfo(n, string);
    }

    int getModelNumberIndex(int n, boolean bl) {
        return this.modelManager.getModelNumberIndex(n, bl);
    }

    boolean modelSetHasVibrationVectors() {
        return this.modelManager.modelSetHasVibrationVectors();
    }

    public boolean modelHasVibrationVectors(int n) {
        return this.modelSetHasVibrationVectors() && this.modelManager.modelHasVibrationVectors(n);
    }

    public int getChainCount() {
        return this.modelManager.getChainCount();
    }

    public int getChainCountInModel(int n) {
        return this.modelManager.getChainCountInModel(n);
    }

    public int getGroupCount() {
        return this.modelManager.getGroupCount();
    }

    public int getGroupCountInModel(int n) {
        return this.modelManager.getGroupCountInModel(n);
    }

    public int getPolymerCount() {
        return this.modelManager.getBioPolymerCount();
    }

    public int getPolymerCountInModel(int n) {
        return this.modelManager.getBioPolymerCountInModel(n);
    }

    public int getAtomCount() {
        return this.modelManager.getAtomCount();
    }

    public int getAtomCountInModel(int n) {
        return this.modelManager.getAtomCountInModel(n);
    }

    public int getBondCount() {
        return this.modelManager.getBondCount();
    }

    public int getBondCountInModel(int n) {
        return this.modelManager.getBondCountInModel(n);
    }

    BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        return this.modelManager.getBondsForSelectedAtoms(bitSet);
    }

    boolean frankClicked(int n, int n2) {
        return this.modelManager.frankClicked(n, n2);
    }

    int findNearestAtomIndex(int n, int n2) {
        return this.modelManager.findNearestAtomIndex(n, n2);
    }

    BitSet findAtomsInRectangle(Rectangle rectangle) {
        return this.modelManager.findAtomsInRectangle(rectangle);
    }

    void toCartesian(Point3f point3f) {
        int n = this.getCurrentModelIndex();
        if (n < 0) {
            return;
        }
        this.modelManager.toCartesian(n, point3f);
    }

    void toUnitCell(Point3f point3f, Point3f point3f2) {
        int n = this.getCurrentModelIndex();
        if (n < 0) {
            return;
        }
        this.modelManager.toUnitCell(n, point3f, point3f2);
    }

    void toFractional(Point3f point3f) {
        int n = this.getCurrentModelIndex();
        if (n < 0) {
            return;
        }
        this.modelManager.toFractional(n, point3f);
    }

    public void setCenterSelected() {
        this.setCenterBitSet(this.selectionManager.bsSelection, true);
    }

    public void rebond() {
        this.modelManager.rebond();
        this.refresh(0, "Viewer:rebond()");
    }

    public void setBondTolerance(float f) {
        this.global.setParameterValue("bondTolerance", f);
        this.global.bondTolerance = f;
    }

    public float getBondTolerance() {
        return this.global.bondTolerance;
    }

    public void setMinBondDistance(float f) {
        this.global.setParameterValue("minBondDistance", f);
        this.global.minBondDistance = f;
    }

    public float getMinBondDistance() {
        return this.global.minBondDistance;
    }

    BitSet getAtomBits(String string) {
        return this.modelManager.getAtomBits(string);
    }

    BitSet getAtomBits(String string, String string2) {
        return this.modelManager.getAtomBits(string, string2);
    }

    public BitSet getAtomBits(String string, int n) {
        return this.modelManager.getAtomBits(string, n);
    }

    BitSet getAtomBits(String string, int[] nArray) {
        return this.modelManager.getAtomBits(string, nArray);
    }

    BitSet getAtomsWithin(String string, BitSet bitSet) {
        return this.modelManager.getAtomsWithin(string, bitSet);
    }

    BitSet getAtomsWithin(float f, Point3f point3f) {
        return this.modelManager.getAtomsWithin(f, point3f);
    }

    BitSet getAtomsWithin(float f, Point4f point4f) {
        return this.modelManager.getAtomsWithin(f, point4f);
    }

    BitSet getAtomsWithin(String string, String string2, BitSet bitSet) {
        return this.modelManager.getAtomsWithin(string, string2, bitSet);
    }

    BitSet getAtomsWithin(float f, BitSet bitSet) {
        return this.modelManager.getAtomsWithin(f, bitSet);
    }

    BitSet getAtomsConnected(float f, float f2, int n, BitSet bitSet) {
        return this.modelManager.getAtomsConnected(f, f2, n, bitSet);
    }

    int getAtomIndexFromAtomNumber(int n) {
        return this.modelManager.getAtomIndexFromAtomNumber(n);
    }

    public BitSet getElementsPresentBitSet(int n) {
        return this.modelManager.getElementsPresentBitSet(n);
    }

    public Hashtable getHeteroList(int n) {
        return this.modelManager.getHeteroList(n);
    }

    BitSet getVisibleSet() {
        return this.modelManager.getVisibleSet();
    }

    BitSet getClickableSet() {
        return this.modelManager.getClickableSet();
    }

    void calcSelectedGroupsCount() {
        this.modelManager.calcSelectedGroupsCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMonomersCount() {
        this.modelManager.calcSelectedMonomersCount(this.selectionManager.bsSelection);
    }

    void calcSelectedMoleculesCount() {
        this.modelManager.calcSelectedMoleculesCount(this.selectionManager.bsSelection);
    }

    String getFileHeader() {
        return this.modelManager.getFileHeader();
    }

    String getPDBHeader() {
        return this.modelManager.getPDBHeader();
    }

    public Hashtable getModelInfo() {
        return this.modelManager.getModelInfo();
    }

    public Hashtable getAuxiliaryInfo() {
        return this.modelManager.getAuxiliaryInfo();
    }

    public Hashtable getShapeInfo() {
        return this.modelManager.getShapeInfo();
    }

    int getShapeIdFromObjectName(String string) {
        return this.modelManager.getShapeIdFromObjectName(string);
    }

    Vector getAllAtomInfo(Object object) {
        return this.modelManager.getAllAtomInfo(this.getAtomBitSet(object));
    }

    Vector getAllBondInfo(Object object) {
        return this.modelManager.getAllBondInfo(this.getAtomBitSet(object));
    }

    Vector getMoleculeInfo(Object object) {
        return this.modelManager.getMoleculeInfo(this.getAtomBitSet(object));
    }

    public Hashtable getAllChainInfo(Object object) {
        return this.modelManager.getAllChainInfo(this.getAtomBitSet(object));
    }

    public Hashtable getAllPolymerInfo(Object object) {
        return this.modelManager.getAllPolymerInfo(this.getAtomBitSet(object));
    }

    public String getStateInfo() {
        StringBuffer stringBuffer = new StringBuffer("# Jmol state version " + Viewer.getJmolVersion() + ";\n\n");
        stringBuffer.append(this.global.getWindowState());
        stringBuffer.append(this.fileManager.getState());
        if (this.getModelSetFileName().equals("zapped")) {
            stringBuffer.append("zap;\n\n");
        }
        stringBuffer.append(this.global.getState());
        Viewer.getDataState(stringBuffer);
        stringBuffer.append(this.modelManager.getState());
        stringBuffer.append(this.repaintManager.getState());
        stringBuffer.append(this.transformManager.getState());
        stringBuffer.append(this.selectionManager.getState());
        stringBuffer.append("refreshing = true;\n");
        return stringBuffer.toString();
    }

    public String getStructureState() {
        return this.modelManager.getStructureState();
    }

    static void setData(String string, Object[] objectArray, int n, int n2, int n3) {
        if (string == null) {
            dataValues.clear();
            return;
        }
        if (objectArray[2] != null) {
            float[] fArray = new float[n];
            String string2 = (String)objectArray[1];
            if (n3 == 0) {
                Parser.parseFloatArray(string2, (BitSet)objectArray[2], fArray);
            } else if (n2 == 0) {
                Parser.parseFloatArrayFromMatchAndField(string2, (BitSet)objectArray[2], 0, null, n3, fArray);
            } else {
                Parser.parseFloatArrayFromMatchAndField(string2, null, n2, (int[])objectArray[2], n3, fArray);
            }
            objectArray[1] = fArray;
        }
        dataValues.put(string, objectArray);
    }

    public static Object[] getData(String string) {
        if (dataValues == null) {
            return null;
        }
        if (string.equalsIgnoreCase("types")) {
            Object[] objectArray = new String[]{"types", ""};
            int n = 0;
            Enumeration enumeration = dataValues.keys();
            while (enumeration.hasMoreElements()) {
                objectArray[1] = (String)objectArray[1] + (n++ == 0 ? "," : "") + enumeration.nextElement();
            }
            return objectArray;
        }
        return (Object[])dataValues.get(string);
    }

    void setCurrentColorRange(String string) {
        float[] fArray = Viewer.getDataFloat(string);
        BitSet bitSet = fArray == null ? null : (BitSet)Viewer.getData(string)[2];
        this.setCurrentColorRange(fArray, bitSet);
    }

    void setCurrentColorRange(float[] fArray, BitSet bitSet) {
        this.colorManager.setCurrentColorRange(fArray, bitSet, this.global.propertyColorScheme);
    }

    void setCurrentColorRange(float f, float f2) {
        this.colorManager.setCurrentColorRange(f, f2);
    }

    public static float[] getDataFloat(String string) {
        if (dataValues == null) {
            return null;
        }
        Object[] objectArray = Viewer.getData(string);
        if (objectArray == null || !(objectArray[1] instanceof float[])) {
            return null;
        }
        return (float[])objectArray[1];
    }

    public static float getDataFloat(String string, int n) {
        float[] fArray;
        Object[] objectArray;
        if (dataValues != null && (objectArray = Viewer.getData(string)) != null && objectArray[1] instanceof float[] && n < (fArray = (float[])objectArray[1]).length) {
            return fArray[n];
        }
        return Float.NaN;
    }

    private static void getDataState(StringBuffer stringBuffer) {
        if (dataValues == null) {
            return;
        }
        Enumeration enumeration = dataValues.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.indexOf("property_") != 0) continue;
            Object object = ((Object[])dataValues.get(string))[1];
            stringBuffer.append("DATA \"").append(string).append("\"");
            if (object instanceof float[]) {
                stringBuffer.append("\n");
                float[] fArray = (float[])object;
                for (int i = 0; i < fArray.length; ++i) {
                    stringBuffer.append(" ").append(fArray[i]);
                }
                stringBuffer.append("\n");
            } else {
                stringBuffer.append("").append(object);
            }
            stringBuffer.append("end \"").append(string).append("\";\n");
        }
    }

    public String getAltLocListInModel(int n) {
        return this.modelManager.getAltLocListInModel(n);
    }

    public BitSet setConformation() {
        return this.modelManager.setConformation(-1, this.getSelectionSet());
    }

    public BitSet setConformation(int n) {
        return this.modelManager.setConformation(this.getCurrentModelIndex(), n);
    }

    int autoHbond(BitSet bitSet) {
        BitSet bitSet2 = this.getSelectionSet();
        this.addStateScript("calculate hbonds");
        return this.autoHbond(bitSet2, bitSet2, bitSet);
    }

    int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        return this.modelManager.autoHbond(bitSet, bitSet2, bitSet3);
    }

    boolean hbondsAreVisible() {
        return this.modelManager.hbondsAreVisible(this.getCurrentModelIndex());
    }

    public boolean havePartialCharges() {
        return this.modelManager.havePartialCharges();
    }

    public UnitCell getCurrentUnitCell() {
        return this.modelManager.getUnitCell(this.getDisplayModelIndex());
    }

    Point3f getCurrentUnitCellOffset() {
        return this.modelManager.getUnitCellOffset(this.getDisplayModelIndex());
    }

    void setCurrentUnitCellOffset(int n) {
        int n2 = this.getCurrentModelIndex();
        if (this.modelManager.setUnitCellOffset(n2, n)) {
            this.global.setParameterValue("_frame " + this.getModelNumber(n2) + "; unitcell = ", n);
        }
    }

    void setCurrentUnitCellOffset(Point3f point3f) {
        int n = this.getCurrentModelIndex();
        if (this.modelManager.setUnitCellOffset(n, point3f)) {
            this.global.setParameterValue("_frame " + this.getModelNumber(n) + "; unitcell = ", Escape.escape(point3f));
        }
    }

    public String getDefaultMeasurementLabel(int n) {
        switch (n) {
            case 2: {
                return this.global.defaultDistanceLabel;
            }
            case 3: {
                return this.global.defaultAngleLabel;
            }
        }
        return this.global.defaultTorsionLabel;
    }

    private void setDefaultMeasurementLabel(int n, String string) {
        switch (n) {
            case 2: {
                this.global.defaultDistanceLabel = string;
            }
            case 3: {
                this.global.defaultAngleLabel = string;
            }
            case 4: {
                this.global.defaultTorsionLabel = string;
            }
        }
    }

    public int getMeasurementCount() {
        int n = this.getShapePropertyAsInt(6, "count");
        return n <= 0 ? 0 : n;
    }

    public String getMeasurementStringValue(int n) {
        String string = "" + this.getShapeProperty(6, "stringValue", n);
        return string;
    }

    Vector getMeasurementInfo() {
        return (Vector)this.getShapeProperty(6, "info");
    }

    public String getMeasurementInfoAsString() {
        return (String)this.getShapeProperty(6, "infostring");
    }

    public int[] getMeasurementCountPlusIndices(int n) {
        int[] nArray = (int[])this.getShapeProperty(6, "countPlusIndices", n);
        return nArray;
    }

    void setPendingMeasurement(int[] nArray) {
        this.setShapeProperty(6, "pending", nArray);
    }

    void clearAllMeasurements() {
        this.setShapeProperty(6, "clear", null);
        this.refresh(0, "Viewer:clearAllMeasurements()");
    }

    public void clearMeasurements() {
        this.script("measures delete");
    }

    private void setJustifyMeasurements(boolean bl) {
        this.global.justifyMeasurements = bl;
    }

    public boolean getJustifyMeasurements() {
        return this.global.justifyMeasurements;
    }

    void setMeasurementFormats(String string) {
        this.setShapeProperty(6, "setFormats", string);
    }

    void defineMeasurement(Vector vector, float[] fArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string) {
        this.setShapeProperty(6, "setConnected", bl2);
        this.setShapeProperty(6, "setRange", fArray);
        this.setShapeProperty(6, "setFormat", string);
        this.setShapeProperty(6, bl ? "deleteVector" : (bl3 ? (bl4 ? "hideVector" : "showVector") : "defineVector"), vector);
        this.setStatusNewDefaultModeMeasurement("scripted", 1, "?");
    }

    public void deleteMeasurement(int n) {
        this.setShapeProperty(6, "delete", new Integer(n));
    }

    void deleteMeasurement(int[] nArray) {
        this.setShapeProperty(6, "delete", nArray);
    }

    public void showMeasurement(int[] nArray, boolean bl) {
        this.setShapeProperty(6, bl ? "show" : "hide", nArray);
        this.refresh(0, "Viewer:showMeasurements()");
    }

    void hideMeasurements(boolean bl) {
        this.setShapeProperty(6, "hideAll", bl);
        this.refresh(0, "hideMeasurements()");
    }

    void toggleMeasurement(int[] nArray, String string) {
        this.setShapeProperty(6, string == null ? "toggle" : "toggleOn", nArray);
        if (string != null) {
            this.setShapeProperty(6, "setFormats", string);
        }
    }

    void repaint() {
        if (this.display == null) {
            return;
        }
        this.display.repaint();
    }

    void setAnimationDirection(int n) {
        this.repaintManager.setAnimationDirection(n);
    }

    void reverseAnimation() {
        this.repaintManager.reverseAnimation();
    }

    int getAnimationDirection() {
        return this.repaintManager.animationDirection;
    }

    Hashtable getAnimationInfo() {
        return this.repaintManager.getAnimationInfo();
    }

    public void setAnimationFps(int n) {
        this.global.setParameterValue("animationFps", n);
        this.repaintManager.setAnimationFps(n);
    }

    public int getAnimationFps() {
        return this.repaintManager.animationFps;
    }

    void setAnimationReplayMode(int n, float f, float f2) {
        this.repaintManager.setAnimationReplayMode(n, f, f2);
    }

    int getAnimationReplayMode() {
        return this.repaintManager.animationReplayMode;
    }

    void setAnimationOn(boolean bl) {
        boolean bl2 = this.repaintManager.animationOn;
        if (bl == bl2) {
            return;
        }
        this.repaintManager.setAnimationOn(bl);
    }

    void resumeAnimation() {
        if (this.repaintManager.animationOn) {
            Logger.debug("animation is ON in resumeAnimation");
            return;
        }
        this.repaintManager.resumeAnimation();
        this.refresh(0, "Viewer:resumeAnimation()");
    }

    void pauseAnimation() {
        if (!this.repaintManager.animationOn || this.repaintManager.animationPaused) {
            return;
        }
        this.repaintManager.pauseAnimation();
        this.refresh(0, "Viewer:pauseAnimation()");
    }

    void setTrajectory(int n) {
        this.modelManager.setTrajectory(n);
        this.repaintManager.setTrajectory(n);
    }

    int getTrajectoryCount() {
        return this.modelManager.getTrajectoryCount();
    }

    void setAnimationRange(int n, int n2, boolean bl) {
        this.repaintManager.setAnimationRange(n, n2, bl);
    }

    public BitSet getVisibleFramesBitSet() {
        return this.repaintManager.getVisibleFramesBitSet();
    }

    boolean isAnimationOn() {
        return this.repaintManager.animationOn;
    }

    void setAnimationNext() {
        if (this.repaintManager.setAnimationNext()) {
            this.refresh(0, "Viewer:setAnimationNext()");
        }
    }

    void setAnimationPrevious() {
        if (this.repaintManager.setAnimationPrevious()) {
            this.refresh(0, "Viewer:setAnimationPrevious()");
        }
    }

    void setAnimationLast() {
        this.repaintManager.setAnimationLast();
        this.refresh(0, "Viewer:setAnimationLast()");
    }

    void rewindAnimation() {
        this.repaintManager.rewindAnimation();
        this.refresh(0, "Viewer:rewindAnimation()");
    }

    void setCurrentModelIndex(int n) {
        this.repaintManager.setCurrentModelIndex(n);
    }

    public int getCurrentModelIndex() {
        return this.repaintManager.currentModelIndex;
    }

    public int getDisplayModelIndex() {
        int n = this.repaintManager.currentModelIndex;
        int n2 = this.getBackgroundModelIndex();
        return n2 >= 0 ? -2 - n : n;
    }

    boolean haveFileSet() {
        return this.getModelCount() > 1 && this.getModelNumber(0) > 1000000;
    }

    void setBackgroundModel(int n) {
        int n2 = this.getModelNumberIndex(n, !this.haveFileSet());
        this.setBackgroundModelIndex(n2);
    }

    private void setBackgroundModelIndex(int n) {
        this.repaintManager.setBackgroundModelIndex(n);
    }

    public int getBackgroundModelIndex() {
        return this.repaintManager.backgroundModelIndex;
    }

    public FrameRenderer getFrameRenderer() {
        return this.repaintManager.frameRenderer;
    }

    public int getMotionEventNumber() {
        return this.motionEventNumber;
    }

    void setInMotion(boolean bl) {
        if (this.wasInMotion ^ bl) {
            if (bl) {
                ++this.motionEventNumber;
            }
            this.repaintManager.setInMotion(bl);
            if (!bl) {
                this.repaintManager.refresh();
            }
            this.wasInMotion = bl;
        }
    }

    public boolean getInMotion() {
        return this.repaintManager.inMotion;
    }

    public void pushHoldRepaint() {
        this.repaintManager.pushHoldRepaint();
    }

    public void popHoldRepaint() {
        this.repaintManager.popHoldRepaint();
    }

    private void setRefreshing(boolean bl) {
        this.refreshing = bl;
    }

    boolean getRefreshing() {
        return this.refreshing;
    }

    public void refresh(int n, String string) {
        this.repaintManager.refresh();
        this.statusManager.setStatusViewerRefreshed(n, string);
    }

    void requestRepaintAndWait() {
        if (this.haveDisplay) {
            this.repaintManager.requestRepaintAndWait();
        }
    }

    public void repaintView() {
        this.repaintManager.repaintDone();
    }

    public boolean areAxesTainted() {
        boolean bl = this.axesAreTainted;
        this.axesAreTainted = false;
        return bl;
    }

    public void setScreenDimension(Dimension dimension) {
        int n = dimension.height;
        int n2 = dimension.width;
        if (this.getStereoMode() == 1) {
            n2 = (n2 + 1) / 2;
        }
        if (this.dimScreen.width == n2 && this.dimScreen.height == n) {
            return;
        }
        this.resizeImage(n2, n, false);
    }

    private void resizeImage(int n, int n2, boolean bl) {
        this.dimScreen.width = n;
        this.dimScreen.height = n2;
        if (!bl) {
            this.global.setParameterValue("_width", n);
            this.global.setParameterValue("_height", n2);
            this.setStatusResized(n, n2);
        }
        this.transformManager.setScreenDimension(n, n2, bl ? this.global.zoomLarge : false);
        this.g3d.setWindowSize(n, n2, this.global.enableFullSceneAntialiasing);
    }

    public int getScreenWidth() {
        return this.dimScreen.width;
    }

    public int getScreenHeight() {
        return this.dimScreen.height;
    }

    public void renderScreenImage(Graphics graphics, Dimension dimension, Rectangle rectangle) {
        if (this.isTainted || this.getSlabEnabled()) {
            this.setModelVisibility();
        }
        this.isTainted = false;
        if (dimension != null) {
            this.setScreenDimension(dimension);
        }
        int n = this.getStereoMode();
        switch (n) {
            case 1: {
                this.render1(graphics, this.getImage(true, false), this.dimScreen.width, 0);
            }
            case 0: {
                this.render1(graphics, this.getImage(false, false), 0, 0);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.render1(graphics, this.getStereoImage(n, false), 0, 0);
            }
        }
        this.repaintView();
    }

    private Image getImage(boolean bl, boolean bl2) {
        Matrix3f matrix3f = this.transformManager.getStereoRotationMatrix(bl);
        boolean bl3 = !this.getTestFlag1();
        this.g3d.beginRendering(matrix3f, bl2, bl3);
        this.repaintManager.render(this.g3d, this.modelManager.getModelSet());
        if (bl3 && this.g3d.setPass2()) {
            this.repaintManager.render(this.g3d, this.modelManager.getModelSet());
        }
        this.g3d.endRendering();
        return this.g3d.getScreenImage();
    }

    private Image getStereoImage(int n, boolean bl) {
        boolean bl2 = !this.getTestFlag1();
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(true), bl, bl2);
        ModelSet modelSet = this.modelManager.getModelSet();
        this.repaintManager.render(this.g3d, modelSet);
        if (bl2 && this.g3d.setPass2()) {
            this.repaintManager.render(this.g3d, modelSet);
        }
        this.g3d.endRendering();
        this.g3d.snapshotAnaglyphChannelBytes();
        this.g3d.beginRendering(this.transformManager.getStereoRotationMatrix(false), bl, bl2);
        this.repaintManager.render(this.g3d, modelSet);
        this.g3d.endRendering();
        switch (n) {
            case 2: {
                this.g3d.applyCyanAnaglyph();
                break;
            }
            case 5: {
                this.g3d.applyCustomAnaglyph(this.transformManager.stereoColors);
                break;
            }
            case 3: {
                this.g3d.applyBlueAnaglyph();
                break;
            }
            default: {
                this.g3d.applyGreenAnaglyph();
            }
        }
        return this.g3d.getScreenImage();
    }

    private void render1(Graphics graphics, Image image, int n, int n2) {
        if (graphics != null) {
            try {
                graphics.drawImage(image, n, n2, null);
            }
            catch (NullPointerException nullPointerException) {
                Logger.error("Sun!! ... fix graphics your bugs!");
            }
        }
        this.g3d.releaseScreenImage();
    }

    public Image getScreenImage() {
        boolean bl = true;
        boolean bl2 = false;
        int n = this.getStereoMode();
        switch (n) {
            case 1: {
                bl2 = true;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return this.getStereoImage(n, false);
            }
        }
        return this.getImage(bl2, bl);
    }

    public String getJpegBase64(int n) {
        Image image = this.getScreenImage();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        JpegEncoder jpegEncoder = new JpegEncoder(image, n, byteArrayOutputStream);
        jpegEncoder.Compress();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.releaseScreenImage();
        return Base64.getBase64(byArray).toString();
    }

    public void releaseScreenImage() {
        this.g3d.releaseScreenImage();
    }

    private void setAllowEmbeddedScripts(boolean bl) {
        this.global.allowEmbeddedScripts = bl;
    }

    boolean getAllowEmbeddedScripts() {
        return this.global.allowEmbeddedScripts;
    }

    public String evalFile(String string) {
        int n = string.indexOf(" -nowait");
        if (n >= 0) {
            return (String)this.evalStringWaitStatus("String", string.substring(0, n), "", true, false);
        }
        return this.scriptManager.addScript(string, true, false);
    }

    public String script(String string) {
        return this.evalString(string);
    }

    String getInterruptScript() {
        String string = this.interruptScript;
        this.interruptScript = "";
        if (string != "" && Logger.isActiveLevel(0)) {
            Logger.debug("interrupt: " + string);
        }
        return string;
    }

    public String evalString(String string) {
        boolean bl;
        this.getInterruptScript();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '!';
        if (bl) {
            string = string.substring(1);
        }
        if (this.checkResume(string)) {
            return "script processing resumed";
        }
        if (this.checkHalt(string)) {
            return "script execution halted";
        }
        if (this.isScriptExecuting() && (bl || this.eval.isExecutionPaused())) {
            this.interruptScript = string;
            return "!" + string;
        }
        return this.scriptManager.addScript(string, false, false);
    }

    boolean usingScriptQueue() {
        return this.scriptManager.useQueue;
    }

    public void clearScriptQueue() {
        this.scriptManager.clearQueue();
    }

    public boolean checkResume(String string) {
        if (string.equalsIgnoreCase("resume")) {
            this.resumeScriptExecution();
            return true;
        }
        return false;
    }

    public boolean checkHalt(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("pause")) {
            this.pauseScriptExecution();
            return true;
        }
        if (string2.startsWith("exit")) {
            this.haltScriptExecution();
            this.clearScriptQueue();
            if (this.checkScriptOnly) {
                Logger.info("exit -- stops script checking");
            }
            this.checkScriptOnly = false;
            return string2.equals("exit");
        }
        if (string2.startsWith("quit")) {
            this.haltScriptExecution();
            if (this.checkScriptOnly) {
                Logger.info("quit -- stops script checking");
            }
            this.checkScriptOnly = false;
            return string2.equals("quit");
        }
        return false;
    }

    public String evalStringQuiet(String string) {
        if (this.checkResume(string)) {
            return "script processing resumed";
        }
        if (this.checkHalt(string)) {
            return "script execution halted";
        }
        return this.scriptManager.addScript(string, false, true);
    }

    public String scriptWait(String string) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        String string2 = (String)this.evalStringWaitStatus("JSON", string, "+scriptStarted,+scriptStatus,+scriptEcho,+scriptTerminated", false, false);
        GT.setDoTranslate(bl);
        return string2;
    }

    public Object scriptWaitStatus(String string, String string2) {
        this.scriptManager.waitForQueue();
        boolean bl = GT.getDoTranslate();
        GT.setDoTranslate(false);
        Object object = this.evalStringWaitStatus("object", string, string2, false, false);
        GT.setDoTranslate(bl);
        return object;
    }

    public Object evalStringWaitStatus(String string, String string2, String string3) {
        this.scriptManager.waitForQueue();
        return this.evalStringWaitStatus(string, string2, string3, false, false);
    }

    synchronized Object evalStringWaitStatus(String string, String string2, String string3, boolean bl, boolean bl2) {
        if (this.checkResume(string2)) {
            return "script processing resumed";
        }
        if (this.checkHalt(string2)) {
            return "script execution halted";
        }
        if (string2 == null) {
            return null;
        }
        String string4 = this.statusManager.statusList;
        this.getProperty("String", "jmolStatus", string3);
        if (this.checkScriptOnly) {
            Logger.info("--checking script:\n" + this.eval.script + "\n----\n");
        }
        boolean bl3 = bl ? this.eval.loadScriptFile(string2, bl2) : this.eval.loadScriptString(string2, bl2);
        String string5 = this.eval.getErrorMessage();
        if (bl3) {
            this.statusManager.setStatusScriptStarted(++this.scriptIndex, string2);
            this.eval.runEval(this.checkScriptOnly, !this.checkScriptOnly || this.fileOpenCheck);
            int n = this.eval.getExecutionWalltime();
            string5 = this.eval.getErrorMessage();
            this.statusManager.setStatusScriptTermination(string5, n);
            if (bl && this.writeInfo != null) {
                this.createImage(this.writeInfo);
            }
        } else {
            this.scriptStatus(string5);
        }
        if (this.checkScriptOnly) {
            Logger.info((string5 == null ? "--script check ok" : "--script check error\n" + string5) + "\n(use 'exit' to stop checking)\n");
        }
        if (bl && this.autoExit) {
            System.out.flush();
            System.exit(0);
        }
        if (string.equalsIgnoreCase("String")) {
            return this.eval.getErrorMessage();
        }
        Object object = this.getProperty(string, "jmolStatus", string3);
        this.getProperty("object", "jmolStatus", string4);
        return object;
    }

    public String scriptCheck(String string) {
        if (string == null || this.checking) {
            return null;
        }
        this.checking = true;
        Object object = this.eval.checkScriptSilent(string);
        this.checking = false;
        if (object instanceof String) {
            return (String)object;
        }
        return null;
    }

    public boolean isScriptExecuting() {
        return this.eval.isScriptExecuting();
    }

    public void haltScriptExecution() {
        this.eval.haltExecution();
    }

    public void resumeScriptExecution() {
        this.eval.resumePausedExecution();
    }

    public void pauseScriptExecution() {
        this.refresh(0, "pauseScriptExecution");
        this.eval.pauseExecution();
    }

    private void setDefaultLoadScript(String string) {
        this.global.defaultLoadScript = string;
    }

    String getDefaultLoadScript() {
        return this.global.defaultLoadScript;
    }

    private void setLanguage(String string) {
        this.statusManager.setCallbackFunction("language", string);
        this.global.setParameterValue("language", GT.getLanguage());
    }

    private void setLoadFormat(String string) {
        this.global.loadFormat = string;
    }

    String getLoadFormat() {
        return this.global.loadFormat;
    }

    public String getStandardLabelFormat() {
        return this.stateManager.getStandardLabelFormat();
    }

    public int getRibbonAspectRatio() {
        return this.global.ribbonAspectRatio;
    }

    private void setRibbonAspectRatio(int n) {
        this.global.ribbonAspectRatio = n;
    }

    public float getSheetSmoothing() {
        return this.global.sheetSmoothing;
    }

    private void setSheetSmoothing(float f) {
        this.global.sheetSmoothing = f;
    }

    public boolean getSsbondsBackbone() {
        return this.global.ssbondsBackbone;
    }

    private void setHbondsBackbone(boolean bl) {
        this.global.hbondsBackbone = bl;
    }

    public boolean getHbondsBackbone() {
        return this.global.hbondsBackbone;
    }

    private void setHbondsSolid(boolean bl) {
        this.global.hbondsSolid = bl;
    }

    public boolean getHbondsSolid() {
        return this.global.hbondsSolid;
    }

    public void setMarBond(short s) {
        this.global.bondRadiusMilliAngstroms = s;
        this.global.setParameterValue("bondRadiusMilliAngstroms", s);
        this.setShapeSize(1, s * 2);
    }

    public void hoverOn(int n) {
        if (this.eval != null && this.isScriptExecuting() || n == this.hoverAtomIndex || this.global.hoverDelayMs == 0) {
            return;
        }
        this.loadShape(22);
        this.setShapeProperty(22, "text", null);
        this.setShapeProperty(22, "target", new Integer(n));
        this.hoverText = null;
        this.hoverAtomIndex = n;
    }

    int getHoverDelay() {
        return this.global.hoverDelayMs;
    }

    private void setHoverDelay(int n) {
        this.global.hoverDelayMs = n;
    }

    public void hoverOn(int n, int n2, String string) {
        if (this.eval != null && this.isScriptExecuting()) {
            return;
        }
        this.loadShape(22);
        this.setShapeProperty(22, "xy", new Point3i(n, n2, 0));
        this.setShapeProperty(22, "target", null);
        this.setShapeProperty(22, "text", string);
        this.hoverAtomIndex = -1;
        this.hoverText = string;
    }

    void hoverOff() {
        if (this.hoverAtomIndex >= 0) {
            this.setShapeProperty(22, "target", null);
            this.hoverAtomIndex = -1;
        }
        if (this.hoverText != null) {
            this.setShapeProperty(22, "text", null);
            this.hoverText = null;
        }
    }

    void setAtomHoverLabel(String string) {
        this.setShapeProperty(22, "atomLabel", string);
    }

    void setLabel(String string) {
        if (string != null) {
            this.loadShape(4);
            this.setShapeSize(4, 0);
        }
        this.setShapeProperty(4, "label", string);
    }

    void togglePickingLabel(BitSet bitSet) {
        this.loadShape(4);
        this.setShapeSize(4, 0, null);
        this.modelManager.setShapeProperty(4, "toggleLabel", null, bitSet);
        this.refresh(0, "Viewer:");
    }

    BitSet getBitSetSelection() {
        return this.selectionManager.bsSelection;
    }

    public void loadShape(int n) {
        this.modelManager.loadShape(n);
    }

    void setShapeSize(int n, int n2) {
        this.setShapeSize(n, n2, this.selectionManager.bsSelection);
    }

    void setShapeSize(int n, int n2, BitSet bitSet) {
        this.modelManager.setShapeSize(n, n2, bitSet);
        this.refresh(0, "Viewer:setShapeSize(" + n + "," + n2 + ")");
    }

    int getShapeSize(int n) {
        return this.modelManager.getShapeSize(n);
    }

    public void setShapeProperty(int n, String string, Object object) {
        if (n < 0) {
            return;
        }
        this.modelManager.setShapeProperty(n, string, object, this.selectionManager.bsSelection);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (n < 0) {
            return;
        }
        this.modelManager.setShapeProperty(n, string, object, bitSet);
        this.refresh(0, "Viewer:setShapeProperty()");
    }

    void setShapePropertyArgb(int n, String string, int n2) {
        this.setShapeProperty(n, string, n2 == 0 ? null : new Integer(n2 | 0xFF000000));
    }

    Object getShapeProperty(int n, String string) {
        return this.modelManager.getShapeProperty(n, string, Integer.MIN_VALUE);
    }

    Object getShapeProperty(int n, String string, int n2) {
        return this.modelManager.getShapeProperty(n, string, n2);
    }

    int getShapePropertyAsInt(int n, String string) {
        Object object = this.getShapeProperty(n, string);
        return object == null || !(object instanceof Integer) ? Integer.MIN_VALUE : (Integer)object;
    }

    short getColix(Object object) {
        return Graphics3D.getColix(object);
    }

    private void setRasmolHydrogenSetting(boolean bl) {
        this.global.rasmolHydrogenSetting = bl;
    }

    boolean getRasmolHydrogenSetting() {
        return this.global.rasmolHydrogenSetting;
    }

    private void setRasmolHeteroSetting(boolean bl) {
        this.global.rasmolHeteroSetting = bl;
    }

    boolean getRasmolHeteroSetting() {
        return this.global.rasmolHeteroSetting;
    }

    boolean getDebugScript() {
        return this.global.debugScript;
    }

    public void setDebugScript(boolean bl) {
        this.global.debugScript = bl;
        this.global.setParameterValue("debugScript", bl);
    }

    void atomPicked(int n, int n2) {
        if (!this.isInSelectionSubset(n)) {
            return;
        }
        this.pickingManager.atomPicked(n, n2);
    }

    void clearClickCount() {
        this.mouseManager.clearClickCount();
        this.setTainted(true);
    }

    public void setCursor(int n) {
        int n2;
        if (this.currentCursor == n || this.display == null) {
            return;
        }
        this.currentCursor = n;
        switch (this.currentCursor) {
            case 1: {
                n2 = 12;
                break;
            }
            case 3: {
                n2 = 13;
                break;
            }
            case 2: {
                n2 = 1;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
            default: {
                this.display.setCursor(Cursor.getDefaultCursor());
                return;
            }
        }
        this.display.setCursor(Cursor.getPredefinedCursor(n2));
    }

    private void setPickingMode(String string) {
        int n = JmolConstants.getPickingMode(string);
        if (n < 0) {
            n = 1;
        }
        this.pickingManager.setPickingMode(n);
    }

    public int getPickingMode() {
        return this.pickingManager.getPickingMode();
    }

    private void setPickingStyle(String string) {
        int n = JmolConstants.getPickingStyle(string);
        if (n < 0) {
            n = 0;
        }
        this.pickingManager.setPickingStyle(n);
    }

    void setDrawHover(boolean bl) {
        this.pickingManager.setDrawHover(bl);
    }

    public boolean getDrawHover() {
        return this.pickingManager.getDrawHover();
    }

    public String getAtomInfo(int n) {
        return this.modelManager.getAtomInfo(n);
    }

    public String getAtomInfoXYZ(int n) {
        return this.modelManager.getAtomInfoXYZ(n, this.getTestFlag1());
    }

    public Hashtable getMessageQueue() {
        return this.statusManager.messageQueue;
    }

    Viewer getViewer() {
        return this;
    }

    private void setCallbackFunction(String string, String string2) {
        if (string2.equalsIgnoreCase("none")) {
            string2 = null;
        }
        this.statusManager.setCallbackFunction(string, string2);
    }

    public void setStatusAtomPicked(int n, String string) {
        String string2 = this.statusManager.getCallbackScript("pickcallback");
        this.global.setParameterValue("_atompicked", n);
        if (string2 != null) {
            this.evalStringQuiet(string2);
        } else {
            this.statusManager.setStatusAtomPicked(n, string);
        }
    }

    public void setStatusAtomHovered(int n, String string) {
        String string2 = this.statusManager.getCallbackScript("hovercallback");
        this.global.setParameterValue("_atomhovered", n);
        if (string2 != null) {
            this.evalStringQuiet(string2);
        } else {
            this.statusManager.setStatusAtomHovered(n, string);
        }
    }

    public void setStatusNewPickingModeMeasurement(int n, String string) {
        this.statusManager.setStatusNewPickingModeMeasurement(n, string);
    }

    public void setStatusNewDefaultModeMeasurement(String string, int n, String string2) {
        this.statusManager.setStatusNewDefaultModeMeasurement(string, n, string2);
    }

    public void setStatusResized(int n, int n2) {
        String string = this.statusManager.getCallbackScript("resizecallback");
        if (string != null) {
            this.evalStringQuiet(string);
        } else {
            this.statusManager.setStatusResized(n, n2);
        }
    }

    void setStatusScriptStarted(int n, String string) {
        this.statusManager.setStatusScriptStarted(n, string);
    }

    void setStatusUserAction(String string) {
        this.statusManager.setStatusUserAction(string);
    }

    Vector getStatusChanged(String string) {
        return this.statusManager.getStatusChanged(string);
    }

    void popupMenu(int n, int n2) {
        if (this.global.disablePopupMenu) {
            return;
        }
        this.setFrankOn(true);
        this.statusManager.popupMenu(n, n2);
    }

    public void setJmolStatusListener(JmolStatusListener jmolStatusListener) {
        this.statusManager.setJmolStatusListener(jmolStatusListener);
    }

    void setStatusFrameChanged(int n) {
        String string;
        boolean bl;
        this.transformManager.setVibrationPeriod(Float.NaN);
        boolean bl2 = bl = this.getTrajectoryCount() > 1;
        if (bl) {
            return;
        }
        int n2 = this.repaintManager.currentModelIndex;
        int n3 = this.getModelFileNumber(n2);
        int n4 = n3 % 1000000;
        int n5 = this.getModelFileNumber(this.repaintManager.firstModelIndex);
        int n6 = this.getModelFileNumber(this.repaintManager.lastModelIndex);
        if (n3 == 0) {
            string = this.getModelNumberDotted(this.repaintManager.firstModelIndex) + " - " + this.getModelNumberDotted(this.repaintManager.lastModelIndex);
            if (n5 / 1000000 == n6 / 1000000) {
                n3 = n5;
            }
        } else {
            string = this.getModelNumberDotted(n2);
        }
        if (n3 != 0) {
            n3 = n3 < 1000000 ? 1 : n3 / 1000000;
        }
        this.global.setParameterValue("_currentFileNumber", n3);
        this.global.setParameterValue("_currentModelNumberInFile", n4);
        this.global.setParameterValue("_modelNumber", string);
        this.global.setParameterValue("_modelName", n2 < 0 ? "" : this.getModelName(n2));
        this.global.setParameterValue("_modelTitle", n2 < 0 ? "" : this.modelManager.getModelTitle(n2));
        this.global.setParameterValue("_modelFile", n2 < 0 ? "" : this.modelManager.getModelFile(n2));
        string = this.statusManager.getCallbackScript("animframecallback");
        if (string != null) {
            this.evalStringQuiet(string);
        } else {
            this.statusManager.setStatusFrameChanged(n, n3, n4, this.repaintManager.animationDirection < 0 ? -n5 : n5, this.repaintManager.currentDirection < 0 ? -n6 : n6);
        }
    }

    private void setStatusFileLoaded(int n, String string, String string2, String string3, Object object, String string4) {
        String string5 = this.statusManager.getCallbackScript("loadstructcallback");
        if (string5 != null) {
            this.evalStringQuiet(string5);
        } else {
            this.statusManager.setStatusFileLoaded(string, string2, string3, object, string4, n);
        }
    }

    private void setStatusFileNotLoaded(String string, String string2) {
        this.setStatusFileLoaded(-1, string, null, null, null, string2);
    }

    public void scriptEcho(String string) {
        this.statusManager.setScriptEcho(string);
    }

    void scriptStatus(String string) {
        this.statusManager.setScriptStatus(string);
    }

    private void setScriptDelay(int n) {
        this.global.scriptDelay = n;
    }

    int getScriptDelay() {
        return this.global.scriptDelay;
    }

    public void showUrl(String string) {
        if (string == null) {
            return;
        }
        if (string.indexOf(":") < 0) {
            String string2 = this.fileManager.getAppletDocumentBase();
            if (string2 == "") {
                string2 = this.fileManager.getFullPathName();
            }
            if (string2.indexOf("/") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("/") + 1);
            } else if (string2.indexOf("\\") >= 0) {
                string2 = string2.substring(0, string2.lastIndexOf("\\") + 1);
            }
            string = string2 + string;
        }
        Logger.info("showUrl:" + string);
        this.statusManager.showUrl(string);
    }

    void showConsole(boolean bl) {
        this.statusManager.showConsole(bl);
    }

    void clearConsole() {
        this.statusManager.clearConsole();
    }

    Object getParameterEscaped(String string) {
        return this.global.getParameterEscaped(string);
    }

    public Object getParameter(String string) {
        return this.global.getParameter(string);
    }

    void unsetProperty(String string) {
        this.global.setParameterValue(string, Float.NaN);
    }

    public boolean getBooleanProperty(String string) {
        return this.getBooleanProperty(string, true);
    }

    public boolean getBooleanProperty(String string, boolean bl) {
        if (string.equalsIgnoreCase("hideNotSelected")) {
            return this.selectionManager.getHideNotSelected();
        }
        if (string.equalsIgnoreCase("colorRasmol")) {
            return this.colorManager.getDefaultColorRasmol();
        }
        if (string.equalsIgnoreCase("perspectiveDepth")) {
            return this.getPerspectiveDepth();
        }
        if (string.equalsIgnoreCase("showAxes")) {
            return this.getShowAxes();
        }
        if (string.equalsIgnoreCase("showBoundBox")) {
            return this.getShowBbcage();
        }
        if (string.equalsIgnoreCase("showUnitcell")) {
            return this.getShowUnitCell();
        }
        if (string.equalsIgnoreCase("debugScript")) {
            return this.getDebugScript();
        }
        if (string.equalsIgnoreCase("showHydrogens")) {
            return this.getShowHydrogens();
        }
        if (string.equalsIgnoreCase("frank")) {
            return this.getShowFrank();
        }
        if (string.equalsIgnoreCase("showMultipleBonds")) {
            return this.getShowMultipleBonds();
        }
        if (string.equalsIgnoreCase("showMeasurements")) {
            return this.getShowMeasurements();
        }
        if (string.equalsIgnoreCase("showSelections")) {
            return this.getSelectionHaloEnabled();
        }
        if (string.equalsIgnoreCase("axesOrientationRasmol")) {
            return this.getAxesOrientationRasmol();
        }
        if (string.equalsIgnoreCase("zeroBasedXyzRasmol")) {
            return this.getZeroBasedXyzRasmol();
        }
        if (string.equalsIgnoreCase("testFlag1")) {
            return this.getTestFlag1();
        }
        if (string.equalsIgnoreCase("testFlag2")) {
            return this.getTestFlag2();
        }
        if (string.equalsIgnoreCase("testFlag3")) {
            return this.getTestFlag3();
        }
        if (string.equalsIgnoreCase("testFlag4")) {
            return this.getTestFlag4();
        }
        if (string.equalsIgnoreCase("chainCaseSensitive")) {
            return this.getChainCaseSensitive();
        }
        if (string.equalsIgnoreCase("hideNameInPopup")) {
            return this.getHideNameInPopup();
        }
        if (string.equalsIgnoreCase("autobond")) {
            return this.getAutoBond();
        }
        if (string.equalsIgnoreCase("greyscaleRendering")) {
            return this.getGreyscaleRendering();
        }
        if (string.equalsIgnoreCase("disablePopupMenu")) {
            return this.getDisablePopupMenu();
        }
        if (this.global.htPropertyFlags.containsKey(string = string.toLowerCase())) {
            return (Boolean)this.global.htPropertyFlags.get(string);
        }
        if (bl) {
            Logger.error("viewer.getBooleanProperty(" + string + ") - unrecognized");
        }
        return false;
    }

    public void setStringProperty(String string, String string2) {
        if (string.equalsIgnoreCase("language")) {
            this.setLanguage(string2);
            return;
        }
        if (string.equalsIgnoreCase("loadFormat")) {
            this.setLoadFormat(string2);
            return;
        }
        if (string.equalsIgnoreCase("backgroundColor")) {
            this.setObjectColor("background", string2);
            return;
        }
        if (string.equalsIgnoreCase("axesColor")) {
            this.setObjectColor("axis1", string2);
            this.setObjectColor("axis2", string2);
            this.setObjectColor("axis3", string2);
            return;
        }
        if (string.equalsIgnoreCase("axis1Color")) {
            this.setObjectColor("axis1", string2);
            return;
        }
        if (string.equalsIgnoreCase("axis2Color")) {
            this.setObjectColor("axis2", string2);
            return;
        }
        if (string.equalsIgnoreCase("axis3Color")) {
            this.setObjectColor("axis3", string2);
            return;
        }
        if (string.equalsIgnoreCase("boundBoxColor")) {
            this.setObjectColor("boundbox", string2);
            return;
        }
        if (string.equalsIgnoreCase("unitCellColor")) {
            this.setObjectColor("unitcell", string2);
            return;
        }
        if (string.equalsIgnoreCase("propertyColorScheme")) {
            this.setPropertyColorScheme(string2);
        } else if (string.equalsIgnoreCase("hoverLabel")) {
            this.setAtomHoverLabel(string2);
        } else if (string.equalsIgnoreCase("defaultDistanceLabel")) {
            this.setDefaultMeasurementLabel(2, string2);
        } else if (string.equalsIgnoreCase("defaultAngleLabel")) {
            this.setDefaultMeasurementLabel(3, string2);
        } else if (string.equalsIgnoreCase("defaultTorsionLabel")) {
            this.setDefaultMeasurementLabel(4, string2);
        } else if (string.equalsIgnoreCase("defaultLoadScript")) {
            this.setDefaultLoadScript(string2);
        } else if (string.equalsIgnoreCase("appletProxy")) {
            this.setAppletProxy(string2);
        } else if (string.equalsIgnoreCase("defaultDirectory")) {
            this.setDefaultDirectory(string2);
        } else if (string.equalsIgnoreCase("helpPath")) {
            this.setHelpPath(string2);
        } else if (string.equalsIgnoreCase("defaults")) {
            this.setDefaults(string2);
        } else if (string.equalsIgnoreCase("defaultColorScheme")) {
            this.setDefaultColors(string2);
        } else if (string.equalsIgnoreCase("picking")) {
            this.setPickingMode(string2);
        } else if (string.equalsIgnoreCase("pickingStyle")) {
            this.setPickingStyle(string2);
        } else if (!string.equalsIgnoreCase("dataSeparator")) {
            if (string.toLowerCase().indexOf("callback") >= 0) {
                this.setCallbackFunction(string, string2);
            } else if (string.charAt(0) != '@' && !this.global.htParameterValues.containsKey(string = string.toLowerCase())) {
                if (this.global.htPropertyFlags.containsKey(string)) {
                    this.scriptStatus("ERROR: cannot set boolean flag to string value");
                    return;
                }
                Logger.warn(string + " -- string variable defined (" + string2.length() + " bytes)");
            }
        }
        this.global.setParameterValue(string, string2);
    }

    public void setFloatProperty(String string, float f) {
        this.setFloatProperty(string, f, false);
    }

    private boolean setFloatProperty(String string, float f, boolean bl) {
        if (string.equalsIgnoreCase("defaultTranslucent")) {
            this.setDefaultTranslucent(f);
        } else if (string.equalsIgnoreCase("axesScale")) {
            this.setAxesScale(f);
        } else if (string.equalsIgnoreCase("visualRange")) {
            this.setVisualRange(f);
        } else if (string.equalsIgnoreCase("navigationDepth")) {
            this.setNavigationDepthPercent(0.0f, f);
        } else if (string.equalsIgnoreCase("navigationSpeed")) {
            this.setNavigationSpeed(f);
        } else if (string.equalsIgnoreCase("navigationSlab")) {
            this.setNavigationSlabOffset(f);
        } else if (string.equalsIgnoreCase("cameraDepth")) {
            this.setCameraDepth(f);
        } else if (string.equalsIgnoreCase("rotationRadius")) {
            this.setRotationRadius(f);
        } else if (string.equalsIgnoreCase("hoverDelay")) {
            this.setHoverDelay((int)(f * 1000.0f));
        } else if (string.equalsIgnoreCase("sheetSmoothing")) {
            this.setSheetSmoothing(f);
        } else if (string.equalsIgnoreCase("dipoleScale")) {
            this.setDipoleScale(f);
        } else if (string.equalsIgnoreCase("stereoDegrees")) {
            this.setStereoDegrees(f);
        } else {
            if (string.equalsIgnoreCase("vectorScale")) {
                this.setVectorScale(f);
                return true;
            }
            if (string.equalsIgnoreCase("vibrationPeriod")) {
                this.setVibrationPeriod(f);
                return true;
            }
            if (string.equalsIgnoreCase("vibrationScale")) {
                this.setVibrationScale(f);
                return true;
            }
            if (string.equalsIgnoreCase("bondTolerance")) {
                this.setBondTolerance(f);
            } else if (string.equalsIgnoreCase("minBondDistance")) {
                this.setMinBondDistance(f);
            } else if (string.equalsIgnoreCase("scaleAngstromsPerInch")) {
                this.setScaleAngstromsPerInch(f);
            } else if (string.equalsIgnoreCase("solventProbeRadius")) {
                this.setSolventProbeRadius(f);
            } else {
                if (string.equalsIgnoreCase("radius")) {
                    this.setFloatProperty("solventProbeRadius", f);
                    return true;
                }
                if (bl) {
                    return false;
                }
                if (!this.global.htParameterValues.containsKey(string = string.toLowerCase())) {
                    if (this.global.htPropertyFlags.containsKey(string)) {
                        Logger.error("cannot set boolean flag to numeric value");
                        this.scriptEcho("script WARNING: cannot set boolean flag to numeric value");
                        return true;
                    }
                    Logger.warn("viewer.setFloatProperty(" + string + "," + f + ") - float variable defined");
                }
            }
        }
        this.global.setParameterValue(string, f);
        return true;
    }

    public void setIntProperty(String string, int n) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, n);
            return;
        }
        this.setIntProperty(string, n, true);
    }

    private void setIntProperty(String string, int n, boolean bl) {
        if (!string.equalsIgnoreCase("propertyDataField")) {
            if (string.equalsIgnoreCase("strandCount")) {
                this.loadShape(12);
                this.setShapeProperty(12, "strandCount", new Integer(n));
                this.loadShape(13);
                this.setShapeProperty(13, "strandCount", new Integer(n));
                this.refresh(0, "set strandCount");
                return;
            }
            if (string.equalsIgnoreCase("perspectiveModel")) {
                this.setPerspectiveModel(n);
            } else if (string.equalsIgnoreCase("showScript")) {
                this.setScriptDelay(n);
            } else if (string.equalsIgnoreCase("specularPower")) {
                Viewer.setSpecularPower(n);
            } else if (string.equalsIgnoreCase("specularExponent")) {
                Viewer.setSpecularExponent(n);
            } else {
                if (string.equalsIgnoreCase("specular")) {
                    this.setIntProperty("specularPercent", n);
                    return;
                }
                if (string.equalsIgnoreCase("diffuse")) {
                    this.setIntProperty("diffusePercent", n);
                    return;
                }
                if (string.equalsIgnoreCase("ambient")) {
                    this.setIntProperty("ambientPercent", n);
                    return;
                }
                if (string.equalsIgnoreCase("specularPercent")) {
                    Viewer.setSpecularPercent(n);
                } else if (string.equalsIgnoreCase("diffusePercent")) {
                    Viewer.setDiffusePercent(n);
                } else if (string.equalsIgnoreCase("ambientPercent")) {
                    Viewer.setAmbientPercent(n);
                } else if (string.equalsIgnoreCase("ribbonAspectRatio")) {
                    this.setRibbonAspectRatio(n);
                } else if (string.equalsIgnoreCase("pickingSpinRate")) {
                    this.setPickingSpinRate(n);
                } else if (string.equalsIgnoreCase("animationFps")) {
                    this.setAnimationFps(n);
                } else if (string.equalsIgnoreCase("percentVdwAtom")) {
                    this.setPercentVdwAtom(n);
                } else {
                    if (string.equalsIgnoreCase("bondRadiusMilliAngstroms")) {
                        this.setMarBond((short)n);
                        return;
                    }
                    if (string.equalsIgnoreCase("hermiteLevel")) {
                        this.setHermiteLevel(n);
                    } else if (n != 0 && n != 1 || !this.setBooleanProperty(string, n == 1, false)) {
                        if (this.setFloatProperty(string, n, true)) {
                            return;
                        }
                        if (!this.global.htParameterValues.containsKey(string = string.toLowerCase())) {
                            if (this.global.htPropertyFlags.containsKey(string)) {
                                Logger.error("cannot set boolean flag to numeric value");
                                this.scriptEcho("script WARNING: cannot set boolean flag to numeric value");
                                return;
                            }
                            Logger.info("viewer.setIntProperty(" + string + "," + n + ") - integer variable defined");
                        }
                    }
                }
            }
        }
        if (bl) {
            if (this.global.htPropertyFlags.containsKey(string)) {
                this.scriptStatus(GT._("ERROR: Cannot set value of a boolean to another type. use \"{0}\" first.", string + " = NONE"));
                return;
            }
            this.global.setParameterValue(string, n);
        }
    }

    public void setBooleanProperty(String string, boolean bl) {
        if (string.charAt(0) == '_') {
            this.global.setParameterValue(string, bl);
            return;
        }
        this.setBooleanProperty(string, bl, true);
    }

    boolean setBooleanProperty(String string, boolean bl, boolean bl2) {
        boolean bl3 = false;
        if (string.equalsIgnoreCase("applySymmetryToBonds")) {
            this.setApplySymmetryToBonds(bl);
        } else if (string.equalsIgnoreCase("appendNew")) {
            this.setAppendNew(bl);
        } else if (string.equalsIgnoreCase("autoFPS")) {
            this.setAutoFps(bl);
        } else if (string.equalsIgnoreCase("useNumberLocalization")) {
            this.setUseNumberLocalization(bl);
        } else if (string.equalsIgnoreCase("showFrank")) {
            this.setFrankOn(bl);
        } else if (string.equalsIgnoreCase("solventProbe")) {
            this.setSolventOn(bl);
        } else if (string.equalsIgnoreCase("dynamicMeasurements")) {
            this.setDynamicMeasurements(bl);
        } else if (string.equalsIgnoreCase("allowRotateSelected")) {
            this.setAllowRotateSelected(bl);
        } else {
            if (string.equalsIgnoreCase("showScript")) {
                this.setIntProperty("showScript", bl ? 1 : 0);
                return true;
            }
            if (string.equalsIgnoreCase("allowEmbeddedScripts")) {
                this.setAllowEmbeddedScripts(bl);
            } else if (string.equalsIgnoreCase("navigationPeriodic")) {
                this.setNavigationPeriodic(bl);
            } else if (string.equalsIgnoreCase("zShade")) {
                this.setZShade(bl);
            } else if (string.equalsIgnoreCase("drawHover")) {
                this.setDrawHover(bl);
            } else if (string.equalsIgnoreCase("navigationMode")) {
                this.setNavigationMode(bl);
            } else if (string.equalsIgnoreCase("hideNavigationPoint")) {
                this.setHideNavigationPoint(bl);
            } else if (string.equalsIgnoreCase("showNavigationPointAlways")) {
                this.setShowNavigationPointAlways(bl);
            } else if (string.equalsIgnoreCase("refreshing")) {
                this.setRefreshing(bl);
            } else if (string.equalsIgnoreCase("justifyMeasurements")) {
                this.setJustifyMeasurements(bl);
            } else if (string.equalsIgnoreCase("ssBondsBackbone")) {
                this.setSsbondsBackbone(bl);
            } else if (string.equalsIgnoreCase("hbondsBackbone")) {
                this.setHbondsBackbone(bl);
            } else if (string.equalsIgnoreCase("hbondsSolid")) {
                this.setHbondsSolid(bl);
            } else if (string.equalsIgnoreCase("specular")) {
                Viewer.setSpecular(bl);
            } else if (string.equalsIgnoreCase("slabEnabled")) {
                this.setSlabEnabled(bl);
            } else if (string.equalsIgnoreCase("zoomEnabled")) {
                this.setZoomEnabled(bl);
            } else if (string.equalsIgnoreCase("solventProbe")) {
                this.setSolventOn(bl);
            } else if (string.equalsIgnoreCase("highResolution")) {
                this.setHighResolution(bl);
            } else if (string.equalsIgnoreCase("traceAlpha")) {
                this.setTraceAlpha(bl);
            } else if (string.equalsIgnoreCase("zoomLarge")) {
                this.setZoomLarge(bl);
            } else if (string.equalsIgnoreCase("languageTranslation")) {
                GT.setDoTranslate(bl);
            } else if (string.equalsIgnoreCase("hideNotSelected")) {
                this.setHideNotSelected(bl);
            } else if (string.equalsIgnoreCase("colorRasmol")) {
                this.setDefaultColors(bl ? "rasmol" : "jmol");
            } else if (string.equalsIgnoreCase("perspectiveDepth")) {
                this.setPerspectiveDepth(bl);
            } else if (string.equalsIgnoreCase("scriptQueue")) {
                this.scriptManager.setQueue(bl);
            } else if (string.equalsIgnoreCase("dotSurface")) {
                this.setDotSurfaceFlag(bl);
            } else if (string.equalsIgnoreCase("dotsSelectedOnly")) {
                this.setDotsSelectedOnly(bl);
            } else {
                if (string.equalsIgnoreCase("showAxes")) {
                    this.setShowAxes(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showBoundBox")) {
                    this.setShowBbcage(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("showUnitcell")) {
                    this.setShowUnitCell(bl);
                    return true;
                }
                if (string.equalsIgnoreCase("selectionHalos")) {
                    this.setSelectionHalos(bl);
                } else if (string.equalsIgnoreCase("debugScript")) {
                    this.setDebugScript(bl);
                } else if (string.equalsIgnoreCase("showHydrogens")) {
                    this.setShowHydrogens(bl);
                } else if (string.equalsIgnoreCase("selectHydrogen")) {
                    this.setRasmolHydrogenSetting(bl);
                } else if (string.equalsIgnoreCase("selectHetero")) {
                    this.setRasmolHeteroSetting(bl);
                } else if (string.equalsIgnoreCase("showMultipleBonds")) {
                    this.setShowMultipleBonds(bl);
                } else if (string.equalsIgnoreCase("showHiddenSelectionHalos")) {
                    this.setShowHiddenSelectionHalos(bl);
                } else if (string.equalsIgnoreCase("showMeasurements")) {
                    this.setShowMeasurements(bl);
                } else if (string.equalsIgnoreCase("axesOrientationRasmol")) {
                    this.setAxesOrientationRasmol(bl);
                } else if (string.equalsIgnoreCase("windowCentered")) {
                    this.setWindowCentered(bl);
                } else if (string.equalsIgnoreCase("displayCellParameters")) {
                    this.setDisplayCellParameters(bl);
                } else if (string.equalsIgnoreCase("testFlag1")) {
                    this.setTestFlag1(bl);
                } else if (string.equalsIgnoreCase("testFlag2")) {
                    this.setTestFlag2(bl);
                } else if (string.equalsIgnoreCase("testFlag3")) {
                    this.setTestFlag3(bl);
                } else if (string.equalsIgnoreCase("testFlag4")) {
                    this.setTestFlag4(bl);
                } else if (string.equalsIgnoreCase("ribbonBorder")) {
                    this.setRibbonBorder(bl);
                } else if (string.equalsIgnoreCase("cartoonRockets")) {
                    this.setCartoonRocketFlag(bl);
                } else if (string.equalsIgnoreCase("greyscaleRendering")) {
                    this.setGreyscaleRendering(bl);
                } else if (!this.setAxesMode(string, bl)) {
                    if (string.equalsIgnoreCase("frank")) {
                        return this.setBooleanProperty("showFrank", bl, true);
                    }
                    if (string.equalsIgnoreCase("solvent")) {
                        return this.setBooleanProperty("solventProbe", bl, true);
                    }
                    if (string.equalsIgnoreCase("bonds")) {
                        return this.setBooleanProperty("showMultipleBonds", bl, true);
                    }
                    if (string.equalsIgnoreCase("hydrogen")) {
                        return this.setBooleanProperty("selectHydrogen", bl, true);
                    }
                    if (string.equalsIgnoreCase("hetero")) {
                        return this.setBooleanProperty("selectHetero", bl, true);
                    }
                    if (string.equalsIgnoreCase("showSelections")) {
                        return this.setBooleanProperty("selectionHalos", bl, true);
                    }
                    if (string.equalsIgnoreCase("bondModeOr")) {
                        this.setBondSelectionModeOr(bl);
                    } else if (string.equalsIgnoreCase("zeroBasedXyzRasmol")) {
                        this.setZeroBasedXyzRasmol(bl);
                    } else if (string.equalsIgnoreCase("rangeSelected")) {
                        this.setRangeSelected(bl);
                    } else if (string.equalsIgnoreCase("measureAllModels")) {
                        this.setMeasureAllModels(bl);
                    } else if (string.equalsIgnoreCase("statusReporting")) {
                        this.setAllowStatusReporting(bl);
                    } else if (string.equalsIgnoreCase("chainCaseSensitive")) {
                        this.setChainCaseSensitive(bl);
                    } else if (string.equalsIgnoreCase("hideNameInPopup")) {
                        this.setHideNameInPopup(bl);
                    } else if (string.equalsIgnoreCase("autobond")) {
                        this.setAutoBond(bl);
                    } else if (string.equalsIgnoreCase("disablePopupMenu")) {
                        this.setDisablePopupMenu(bl);
                    } else if (string.equalsIgnoreCase("forceAutoBond")) {
                        this.setForceAutoBond(bl);
                    } else {
                        bl3 = true;
                    }
                    if (!bl2) {
                        return !bl3;
                    }
                    if (!bl3) {
                        this.global.setParameterValue(string, bl);
                        return true;
                    }
                    bl3 = true;
                }
            }
        }
        if (!bl2) {
            return !bl3;
        }
        if (bl3) {
            if (this.global.htParameterValues.containsKey(string = string.toLowerCase())) {
                this.scriptStatus(GT._("ERROR: Cannot set value of this variable to a boolean. use \"{0}\" first.", string + " = NONE"));
                return true;
            }
            if (!bl && !this.global.htPropertyFlags.containsKey(string)) {
                Logger.warn("viewer.setBooleanProperty(" + string + "," + bl + ") - boolean variable defined");
            }
        }
        this.global.setParameterValue(string, bl);
        if (bl3) {
            return false;
        }
        this.setTainted(true);
        this.refresh(0, "viewer.setBooleanProperty");
        return true;
    }

    void showParameter(String string, boolean bl, int n) {
        String string2 = "" + this.global.getParameterEscaped(string, n);
        if (bl || string2.indexOf("<not set>") < 0) {
            this.showString(string + " = " + string2);
        }
    }

    void showString(String string) {
        Logger.warn(string);
        this.scriptEcho(string);
    }

    String getAllSettings(int n) {
        return this.global.getAllSettings(n);
    }

    public boolean getDotSurfaceFlag() {
        return this.global.dotSurface;
    }

    private void setDotSurfaceFlag(boolean bl) {
        this.global.dotSurface = bl;
    }

    public boolean getDotsSelectedOnlyFlag() {
        return this.global.dotsSelectedOnly;
    }

    private void setDotsSelectedOnly(boolean bl) {
        this.global.dotsSelectedOnly = bl;
    }

    public boolean isRangeSelected() {
        return this.global.rangeSelected;
    }

    private void setRangeSelected(boolean bl) {
        this.global.rangeSelected = bl;
    }

    boolean isWindowCentered() {
        return this.transformManager.isWindowCentered();
    }

    private void setWindowCentered(boolean bl) {
        this.transformManager.setWindowCentered(bl);
    }

    private void setCameraDepth(float f) {
        this.transformManager.setCameraDepthPercent(f);
        this.refresh(1, "set cameraDepth");
    }

    void setNavigationDepthPercent(float f, float f2) {
        this.transformManager.setNavigationDepthPercent(f, f2);
        this.refresh(1, "set navigationDepth");
    }

    private void setNavigationSpeed(float f) {
        this.global.navigationSpeed = f;
    }

    float getNavigationSpeed() {
        return this.global.navigationSpeed;
    }

    private void setShowNavigationPointAlways(boolean bl) {
        this.global.showNavigationPointAlways = bl;
    }

    private void setHideNavigationPoint(boolean bl) {
        this.global.hideNavigationPoint = bl;
    }

    public boolean getShowNavigationPoint() {
        if (!this.global.navigationMode || !this.transformManager.canNavigate()) {
            return false;
        }
        return this.getNavigating() && !this.global.hideNavigationPoint || this.global.showNavigationPointAlways || this.getInMotion();
    }

    public void setVisualRange(float f) {
        this.transformManager.setVisualRange(f);
        this.refresh(1, "set visualRange");
    }

    private void setSolventProbeRadius(float f) {
        this.global.solventProbeRadius = f;
    }

    float getSolventProbeRadius() {
        return this.global.solventProbeRadius;
    }

    public float getCurrentSolventProbeRadius() {
        return this.global.solventOn ? this.global.solventProbeRadius : 0.0f;
    }

    private void setSolventOn(boolean bl) {
        this.global.solventOn = bl;
    }

    boolean getSolventOn() {
        return this.global.solventOn;
    }

    private void setAllowStatusReporting(boolean bl) {
        this.statusManager.setAllowStatusReporting(bl);
    }

    private void setTestFlag1(boolean bl) {
        this.global.testFlag1 = bl;
    }

    public boolean getTestFlag1() {
        return this.global.testFlag1;
    }

    public boolean getTestFlag2() {
        return this.global.testFlag2;
    }

    private void setTestFlag2(boolean bl) {
        this.global.testFlag2 = bl;
    }

    public boolean getTestFlag3() {
        return this.global.testFlag3;
    }

    private void setTestFlag3(boolean bl) {
        this.global.testFlag3 = bl;
    }

    public boolean getTestFlag4() {
        return this.global.testFlag4;
    }

    private void setTestFlag4(boolean bl) {
        this.global.testFlag4 = bl;
    }

    public void setPerspectiveDepth(boolean bl) {
        this.global.setParameterValue("perspectiveDepth", bl);
        this.transformManager.setPerspectiveDepth(bl);
        this.refresh(0, "Viewer:setPerspectiveDepth()");
    }

    public void setAxesOrientationRasmol(boolean bl) {
        this.transformManager.setAxesOrientationRasmol(bl);
        this.refresh(0, "Viewer:setAxesOrientationRasmol()");
    }

    public boolean getAxesOrientationRasmol() {
        return this.transformManager.axesOrientationRasmol;
    }

    void setAxesScale(float f) {
        this.global.axesScale = f;
        this.axesAreTainted = true;
        this.refresh(0, "set axesScale");
    }

    public float getAxesScale() {
        return this.global.axesScale;
    }

    boolean setAxesMode(String string, boolean bl) {
        if (string.equalsIgnoreCase("axesWindow")) {
            this.setAxesModeMolecular(!bl);
            return true;
        }
        if (string.equalsIgnoreCase("axesMolecular")) {
            this.setAxesModeMolecular(bl);
            return true;
        }
        if (string.equalsIgnoreCase("axesUnitCell")) {
            this.setAxesModeUnitCell(bl);
            return true;
        }
        return false;
    }

    private void setAxesModeMolecular(boolean bl) {
        this.global.axesMode = bl ? 1 : 0;
        this.axesAreTainted = true;
        this.global.removeParameter("axesunitcell");
        this.global.removeParameter(bl ? "axeswindow" : "axesmolecular");
    }

    void setAxesModeUnitCell(boolean bl) {
        this.global.axesMode = bl ? 2 : 0;
        this.axesAreTainted = true;
        this.global.removeParameter("axesmolecular");
        this.global.removeParameter(bl ? "axeswindow" : "axesunitcell");
    }

    public int getAxesMode() {
        return this.global.axesMode;
    }

    private void setDisplayCellParameters(boolean bl) {
        this.global.displayCellParameters = bl;
    }

    public boolean getDisplayCellParameters() {
        return this.global.displayCellParameters;
    }

    public boolean getPerspectiveDepth() {
        return this.transformManager.getPerspectiveDepth();
    }

    public void setSelectionHalos(boolean bl) {
        if (bl == this.getSelectionHaloEnabled() || this.getModelSet() == null) {
            return;
        }
        this.global.setParameterValue("selectionHalos", bl);
        this.loadShape(17);
        this.modelManager.setSelectionHaloEnabled(bl);
    }

    public boolean getSelectionHaloEnabled() {
        return this.modelManager.getSelectionHaloEnabled();
    }

    private void setBondSelectionModeOr(boolean bl) {
        this.global.bondModeOr = bl;
        this.refresh(0, "Viewer:setBondSelectionModeOr()");
    }

    public boolean getBondSelectionModeOr() {
        return this.global.bondModeOr;
    }

    public boolean getChainCaseSensitive() {
        return this.global.chainCaseSensitive;
    }

    private void setChainCaseSensitive(boolean bl) {
        this.global.chainCaseSensitive = bl;
    }

    public boolean getRibbonBorder() {
        return this.global.ribbonBorder;
    }

    private void setRibbonBorder(boolean bl) {
        this.global.ribbonBorder = bl;
    }

    public boolean getCartoonRocketFlag() {
        return this.global.cartoonRockets;
    }

    private void setCartoonRocketFlag(boolean bl) {
        this.global.cartoonRockets = bl;
    }

    boolean getHideNameInPopup() {
        return this.global.hideNameInPopup;
    }

    private void setHideNameInPopup(boolean bl) {
        this.global.hideNameInPopup = bl;
    }

    private void setNavigationPeriodic(boolean bl) {
        this.global.navigationPeriodic = bl;
    }

    boolean getNavigationPeriodic() {
        return this.global.navigationPeriodic;
    }

    private void setNavigationMode(boolean bl) {
        this.global.navigationMode = bl;
        if (bl && !this.transformManager.canNavigate()) {
            this.setVibrationOff();
            this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            this.reset();
        }
        this.transformManager.setNavigationMode(bl);
    }

    boolean getNavigationMode() {
        return this.global.navigationMode;
    }

    private void setNavigationSlabOffset(float f) {
        this.transformManager.setNavigationSlabOffsetPercent(f);
    }

    private void setPerspectiveModel(int n) {
        this.setVibrationOff();
        switch (n) {
            case 10: {
                this.transformManager = new TransformManager10(this, this.dimScreen.width, this.dimScreen.height);
                break;
            }
            default: {
                this.transformManager = this.transformManager.getNavigationManager(this, this.dimScreen.width, this.dimScreen.height);
            }
        }
        this.reset();
    }

    private void setZoomLarge(boolean bl) {
        this.global.zoomLarge = bl;
        this.transformManager.scaleFitToScreen(false, this.global.zoomLarge);
    }

    boolean getZoomLarge() {
        return this.global.zoomLarge;
    }

    private void setTraceAlpha(boolean bl) {
        this.global.traceAlpha = bl;
    }

    public boolean getTraceAlpha() {
        return this.global.traceAlpha;
    }

    public int getHermiteLevel() {
        return this.global.hermiteLevel;
    }

    private void setHermiteLevel(int n) {
        this.global.hermiteLevel = n;
    }

    public boolean getHighResolution() {
        return this.global.highResolutionFlag;
    }

    private void setHighResolution(boolean bl) {
        this.global.highResolutionFlag = bl;
    }

    private void setSsbondsBackbone(boolean bl) {
        this.global.ssbondsBackbone = bl;
    }

    String getLoadState() {
        return this.global.getLoadState();
    }

    public void setAutoBond(boolean bl) {
        this.global.setParameterValue("autobond", bl);
        this.global.autoBond = bl;
    }

    public boolean getAutoBond() {
        return this.global.autoBond;
    }

    int makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        this.clearAllMeasurements();
        return this.modelManager.makeConnections(f, f2, s, n, bitSet, bitSet2, bitSet3, bl);
    }

    private void setGreyscaleRendering(boolean bl) {
        this.global.greyscaleRendering = bl;
        this.g3d.setGreyscaleMode(bl);
        this.refresh(0, "Viewer:setGreyscaleRendering()");
    }

    boolean getGreyscaleRendering() {
        return this.global.greyscaleRendering;
    }

    private void setDisablePopupMenu(boolean bl) {
        this.global.disablePopupMenu = bl;
    }

    boolean getDisablePopupMenu() {
        return this.global.disablePopupMenu;
    }

    private void setForceAutoBond(boolean bl) {
        this.global.forceAutoBond = bl;
    }

    public boolean getForceAutoBond() {
        return this.global.forceAutoBond;
    }

    public void setPercentVdwAtom(int n) {
        this.global.setParameterValue("percentVdwAtom", n);
        this.global.percentVdwAtom = n;
        this.setShapeSize(0, -n);
    }

    public int getPercentVdwAtom() {
        return this.global.percentVdwAtom;
    }

    public short getMadAtom() {
        return (short)(-this.global.percentVdwAtom);
    }

    public short getMadBond() {
        return (short)(this.global.bondRadiusMilliAngstroms * 2);
    }

    public short getMarBond() {
        return this.global.bondRadiusMilliAngstroms;
    }

    public byte getModeMultipleBond() {
        return this.global.modeMultipleBond;
    }

    private void setShowMultipleBonds(boolean bl) {
        this.global.showMultipleBonds = bl;
        this.refresh(0, "Viewer:setShowMultipleBonds()");
    }

    public boolean getShowMultipleBonds() {
        return this.global.showMultipleBonds;
    }

    public void setShowHydrogens(boolean bl) {
        this.global.setParameterValue("showHydrogens", bl);
        this.global.showHydrogens = bl;
        this.refresh(0, "Viewer:setShowHydrogens()");
    }

    public boolean getShowHydrogens() {
        return this.global.showHydrogens;
    }

    private void setShowHiddenSelectionHalos(boolean bl) {
        this.global.showHiddenSelectionHalos = bl;
        this.refresh(0, "Viewer:setShowHiddenSelectionHalos()");
    }

    public boolean getShowHiddenSelectionHalos() {
        return this.global.showHiddenSelectionHalos;
    }

    public void setShowBbcage(boolean bl) {
        this.setObjectMad(19, "boundbox", (short)(bl ? -4 : 0));
    }

    public boolean getShowBbcage() {
        return this.getObjectMad(4) != 0;
    }

    public void setShowUnitCell(boolean bl) {
        this.setObjectMad(20, "unitcell", (short)(bl ? -4 : 0));
    }

    public boolean getShowUnitCell() {
        return this.getObjectMad(5) != 0;
    }

    public void setShowAxes(boolean bl) {
        this.setObjectMad(18, "axes", (short)(bl ? -2 : 0));
    }

    public boolean getShowAxes() {
        return this.getObjectMad(1) != 0;
    }

    public void setFrankOn(boolean bl) {
        this.setObjectMad(30, "frank", (short)(bl ? 1 : 0));
    }

    public boolean getShowFrank() {
        return this.getObjectMad(6) != 0;
    }

    public void setShowMeasurements(boolean bl) {
        this.global.setParameterValue("showMeasurements", bl);
        this.global.showMeasurements = bl;
        this.refresh(0, "setShowMeasurements()");
    }

    public boolean getShowMeasurements() {
        return this.global.showMeasurements;
    }

    private void setMeasureAllModels(boolean bl) {
        this.global.measureAllModels = bl;
    }

    public boolean getMeasureAllModelsFlag() {
        return this.global.measureAllModels;
    }

    void setMeasureDistanceUnits(String string) {
        this.global.setMeasureDistanceUnits(string);
        this.setShapeProperty(6, "reformatDistances", null);
    }

    public String getMeasureDistanceUnits() {
        return this.global.getMeasureDistanceUnits();
    }

    private void setUseNumberLocalization(boolean bl) {
        this.global.useNumberLocalization = bl;
        TextFormat.setUseNumberLocalization(bl);
    }

    public boolean getUseNumberLocalization() {
        return this.global.useNumberLocalization;
    }

    private void setAppendNew(boolean bl) {
        this.global.appendNew = bl;
    }

    public boolean getAppendNew() {
        return this.global.appendNew;
    }

    private void setAutoFps(boolean bl) {
        this.global.autoFps = bl;
    }

    boolean getAutoFps() {
        return this.global.autoFps;
    }

    public void setRasmolDefaults() {
        this.setDefaults("RasMol");
    }

    public void setJmolDefaults() {
        this.setDefaults("Jmol");
    }

    private void setDefaults(String string) {
        if (string.equalsIgnoreCase("RasMol")) {
            this.stateManager.setRasMolDefaults();
            return;
        }
        this.stateManager.setJmolDefaults();
    }

    private void setZeroBasedXyzRasmol(boolean bl) {
        this.global.zeroBasedXyzRasmol = bl;
        this.modelManager.setZeroBased();
    }

    public boolean getZeroBasedXyzRasmol() {
        return this.global.zeroBasedXyzRasmol;
    }

    public Point3f[] allocTempPoints(int n) {
        return this.tempManager.allocTempPoints(n);
    }

    public void freeTempPoints(Point3f[] point3fArray) {
        this.tempManager.freeTempPoints(point3fArray);
    }

    public Point3i[] allocTempScreens(int n) {
        return this.tempManager.allocTempScreens(n);
    }

    public void freeTempScreens(Point3i[] point3iArray) {
        this.tempManager.freeTempScreens(point3iArray);
    }

    public byte[] allocTempBytes(int n) {
        return this.tempManager.allocTempBytes(n);
    }

    public void freeTempBytes(byte[] byArray) {
        this.tempManager.freeTempBytes(byArray);
    }

    Font3D getFont3D(int n) {
        return this.g3d.getFont3D("SansSerif", "Plain", n);
    }

    Font3D getFont3D(String string, String string2, int n) {
        return this.g3d.getFont3D(string, string2, n);
    }

    public String formatText(String string) {
        int n;
        int n2 = -1;
        while ((n = string.indexOf("%{")) >= 0) {
            n2 = n + 2;
            if ((n = string.indexOf("}", n2)) < 0) {
                return string;
            }
            String string2 = string.substring(n2, n);
            if (string2.indexOf("{") >= 0) {
                while (string2.lastIndexOf("{") > string2.lastIndexOf("}")) {
                    if ((n = string.indexOf("}", n + 1)) < 0) {
                        return string;
                    }
                    string2 = string.substring(n2, n);
                }
            }
            if (string2.length() == 0) {
                return string;
            }
            Object object = Eval.evaluateExpression(this, string2);
            if (object instanceof Point3f) {
                object = Escape.escape((Point3f)object);
            }
            string = string.substring(0, n2 - 2) + object.toString() + string.substring(n + 1);
        }
        return string;
    }

    String getElementSymbol(int n) {
        return this.modelManager.getElementSymbol(n);
    }

    int getElementNumber(int n) {
        return this.modelManager.getElementNumber(n);
    }

    public String getAtomName(int n) {
        return this.modelManager.getAtomName(n);
    }

    public int getAtomNumber(int n) {
        return this.modelManager.getAtomNumber(n);
    }

    float getAtomX(int n) {
        return this.modelManager.getAtomX(n);
    }

    float getAtomY(int n) {
        return this.modelManager.getAtomY(n);
    }

    float getAtomZ(int n) {
        return this.modelManager.getAtomZ(n);
    }

    public Point3f getAtomPoint3f(int n) {
        return this.modelManager.getAtomPoint3f(n);
    }

    public float getAtomRadius(int n) {
        return this.modelManager.getAtomRadius(n);
    }

    public float getAtomVdwRadius(int n) {
        return this.modelManager.getAtomVdwRadius(n);
    }

    public int getAtomArgb(int n) {
        return this.g3d.getColixArgb(this.modelManager.getAtomColix(n));
    }

    String getAtomChain(int n) {
        return this.modelManager.getAtomChain(n);
    }

    public int getAtomModelIndex(int n) {
        return this.modelManager.getAtomModelIndex(n);
    }

    String getAtomSequenceCode(int n) {
        return this.modelManager.getAtomSequenceCode(n);
    }

    public Point3f getBondPoint3f1(int n) {
        return this.modelManager.getBondPoint3f1(n);
    }

    public Point3f getBondPoint3f2(int n) {
        return this.modelManager.getBondPoint3f2(n);
    }

    public float getBondRadius(int n) {
        return this.modelManager.getBondRadius(n);
    }

    public short getBondOrder(int n) {
        return this.modelManager.getBondOrder(n);
    }

    public int getBondArgb1(int n) {
        return this.g3d.getColixArgb(this.modelManager.getBondColix1(n));
    }

    public int getBondModelIndex(int n) {
        return this.modelManager.getBondModelIndex(n);
    }

    public int getBondArgb2(int n) {
        return this.g3d.getColixArgb(this.modelManager.getBondColix2(n));
    }

    public Point3f[] getPolymerLeadMidPoints(int n, int n2) {
        return this.modelManager.getPolymerLeadMidPoints(n, n2);
    }

    void setStereoMode(int n, String string) {
        this.global.stereoState = string;
        this.transformManager.setStereoMode(n);
        this.setBooleanProperty("greyscaleRendering", n > 1);
    }

    void setStereoMode(int[] nArray, String string) {
        this.global.stereoState = string;
        this.transformManager.setStereoMode(nArray);
        this.setBooleanProperty("greyscaleRendering", true);
    }

    int getStereoMode() {
        return this.transformManager.stereoMode;
    }

    float getStereoDegrees() {
        return this.transformManager.stereoDegrees;
    }

    private void setStereoDegrees(float f) {
        this.transformManager.setStereoDegrees(f);
    }

    public boolean isJvm12orGreater() {
        return this.jvm12orGreater;
    }

    public String getOperatingSystemName() {
        return this.strOSName;
    }

    public String getJavaVendor() {
        return this.strJavaVendor;
    }

    public String getJavaVersion() {
        return this.strJavaVersion;
    }

    public Graphics3D getGraphics3D() {
        return this.g3d;
    }

    public boolean showModelSetDownload() {
        return true;
    }

    public Object getProperty(String string, String string2, String string3) {
        return this.getProperty(string, string2, (Object)string3);
    }

    public Object getProperty(String string, String string2, Object object) {
        return this.propertyManager.getProperty(string, string2, object);
    }

    String getModelExtract(Object object) {
        return this.fileManager.getFullPathName() + "\nJmol version " + Viewer.getJmolVersion() + "\nEXTRACT: " + object + "\n" + this.modelManager.getModelExtract(this.getAtomBitSet(object));
    }

    public String getHexColorFromIndex(short s) {
        return this.g3d.getHexColorFromIndex(s);
    }

    void setModelVisibility() {
        this.modelManager.setModelVisibility();
    }

    void setTainted(boolean bl) {
        this.isTainted = bl && this.refreshing;
        this.axesAreTainted = bl && this.refreshing;
    }

    boolean checkObjectClicked(int n, int n2, int n3) {
        return this.modelManager.checkObjectClicked(n, n2, n3);
    }

    boolean checkObjectHovered(int n, int n2) {
        return this.modelManager.checkObjectHovered(n, n2);
    }

    void checkObjectDragged(int n, int n2, int n3, int n4, int n5) {
        this.modelManager.checkObjectDragged(n, n2, n3, n4, n5);
    }

    void rotateAxisAngleAtCenter(Point3f point3f, Vector3f vector3f, float f, float f2, boolean bl, boolean bl2) {
        this.transformManager.rotateAxisAngleAtCenter(point3f, vector3f, f, f2, bl, bl2);
    }

    void rotateAboutPointsInternal(Point3f point3f, Point3f point3f2, float f, float f2, boolean bl, boolean bl2) {
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, f, f2, false, bl, bl2);
    }

    private void setPickingSpinRate(int n) {
        if (n < 1) {
            n = 1;
        }
        this.global.pickingSpinRate = n;
    }

    int getPickingSpinRate() {
        return this.global.pickingSpinRate;
    }

    public void startSpinningAxis(int n, int n2, boolean bl) {
        Point3f point3f = this.modelManager.getAtomPoint3f(n);
        Point3f point3f2 = this.modelManager.getAtomPoint3f(n2);
        this.startSpinningAxis(point3f, point3f2, bl);
    }

    public void startSpinningAxis(Point3f point3f, Point3f point3f2, boolean bl) {
        if (this.getSpinOn()) {
            this.setSpinOn(false);
            return;
        }
        this.transformManager.rotateAboutPointsInternal(point3f, point3f2, this.global.pickingSpinRate, Float.MAX_VALUE, bl, true, false);
    }

    public Vector3f getModelDipole() {
        return this.modelManager.getModelDipole();
    }

    public void getBondDipoles() {
        this.modelManager.getBondDipoles();
    }

    private void setDipoleScale(float f) {
        this.loadShape(24);
        this.setShapeProperty(24, "dipoleVectorScale", new Float(f));
    }

    public void getAtomIdentityInfo(int n, Hashtable hashtable) {
        this.modelManager.getAtomIdentityInfo(n, hashtable);
    }

    void setDefaultLattice(Point3f point3f) {
        this.global.setDefaultLattice(point3f);
    }

    Point3f getDefaultLattice() {
        return this.global.getDefaultLatticePoint();
    }

    BitSet getTaintedAtoms() {
        return this.modelManager.getTaintedAtoms();
    }

    void setTaintedAtoms(BitSet bitSet) {
        this.modelManager.setTaintedAtoms(bitSet);
    }

    public String getData(String string, String string2) {
        String string3 = "";
        string3 = string2.toLowerCase().indexOf("property_") == 0 ? "{selected}.label(\"%{" + string2 + "}\")" : (string2.equalsIgnoreCase("PDB") ? "{selected and not hetero}.label(\"ATOM  %5i  %-3a%1A%3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines+{selected and hetero}.label(\"HETATM%5i %-4a%1A%3n %1c%4R%1E   %8.3x%8.3y%8.3z%6.2Q%6.2b          %2e  \").lines" : (string2.equalsIgnoreCase("MOL") ? "\"line1\nline2\nline3\n\"+(\"\"+{selected}.size)%-3+(\"\"+{selected}.bonds.size)%-3+\"  0  0  0\n\"+{selected}.labels(\"%10.4x%10.4y%10.4z %-2e  0  0  0  0  0\").lines+{selected}.bonds.labels(\"%3D1%3D2%3ORDER  0  0  0\").lines" : "\"\" + {selected}.size + \"\n\n\"+{selected}.label(\"%-2e %10.5x %10.5y %10.5z\").lines"));
        if (!string.equals("selected")) {
            string3 = TextFormat.simpleReplace(string3, "selected", string);
        }
        return (String)Eval.evaluateExpression(this, string3);
    }

    public void setAtomCoord(int n, float f, float f2, float f3) {
        this.modelManager.setAtomCoord(n, f, f2, f3);
    }

    public void setAtomCoordRelative(int n, float f, float f2, float f3) {
        this.modelManager.setAtomCoordRelative(n, f, f2, f3);
    }

    void setAtomCoordRelative(Point3f point3f) {
        this.modelManager.setAtomCoordRelative(point3f, this.selectionManager.bsSelection);
    }

    void setRotateSelected(boolean bl) {
        this.transformManager.setRotateSelected(bl);
    }

    void setRotateMolecule(boolean bl) {
        this.transformManager.setRotateMolecule(bl);
    }

    void setAllowRotateSelected(boolean bl) {
        this.global.allowRotateSelected = bl;
    }

    void setDynamicMeasurements(boolean bl) {
        this.global.dynamicMeasurements = bl;
    }

    public boolean getDynamicMeasurements() {
        return this.global.dynamicMeasurements;
    }

    boolean allowRotateSelected() {
        return this.global.allowRotateSelected;
    }

    void invertSelected(Point3f point3f, BitSet bitSet) {
        this.modelManager.invertSelected(point3f, null, bitSet);
    }

    void invertSelected(Point3f point3f, Point4f point4f) {
        this.modelManager.invertSelected(point3f, point4f, this.selectionManager.bsSelection);
    }

    void rotateSelected(Matrix3f matrix3f, Matrix3f matrix3f2, boolean bl, boolean bl2) {
        this.modelManager.rotateSelected(matrix3f, matrix3f2, this.selectionManager.bsSelection, bl, bl2);
    }

    public float[][] functionXY(String string, int n, int n2) {
        System.out.println("functionXY:::  " + string);
        if (string.indexOf("file:") < 0) {
            return this.statusManager.functionXY(string, n, n2);
        }
        String string2 = this.getFileAsString(string.substring(5));
        n = Math.abs(n);
        n2 = Math.abs(n2);
        float[] fArray = new float[n * n2];
        Parser.parseFloatArray(string2, null, fArray);
        float[][] fArray2 = new float[n][n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                fArray2[i][j] = fArray[n3++];
            }
        }
        return fArray2;
    }

    String eval(String string) {
        return this.statusManager.eval(string);
    }

    private void setHelpPath(String string) {
        this.global.helpPath = string;
    }

    void getHelp(String string) {
        if (string.length() > 0 && string.indexOf("?") != 0 && this.global.helpPath.indexOf("?") < 0) {
            string = "?search=" + string;
        }
        this.showUrl(this.global.helpPath + string);
    }

    void addCommand(String string) {
        this.commandHistory.addCommand(string);
    }

    String removeCommand() {
        return this.commandHistory.removeCommand();
    }

    public String getSetHistory(int n) {
        return this.commandHistory.getSetHistory(n);
    }

    private void createImage(String string) {
        if (string == null) {
            return;
        }
        if (string.length() == 0) {
            string = "JPG:jmol.jpg";
        }
        if (string.indexOf(":") < 0) {
            string = string + ":jmol.jpg";
        }
        int n = string.indexOf(":");
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        String string4 = "-1";
        String string5 = "-1";
        String string6 = "75";
        n = string3.indexOf(9);
        if (n > 0) {
            string4 = string3.substring(n + 1);
            string3 = string3.substring(0, n);
        }
        if ((n = string4.indexOf(9)) > 0) {
            string5 = string4.substring(n + 1);
            string4 = string4.substring(0, n);
        }
        if ((n = string5.indexOf(9)) > 0) {
            string6 = string5.substring(n + 1);
            string5 = string5.substring(0, n);
        }
        try {
            int n2 = Integer.parseInt(string4);
            int n3 = Integer.parseInt(string5);
            int n4 = Integer.parseInt(string6);
            this.createImage(string3, string2, n4, n2, n3);
        }
        catch (Exception exception) {
            System.out.println("error processing write request: " + string);
        }
    }

    void createImage(String string, String string2, int n, int n2, int n3) {
        int n4 = this.dimScreen.width;
        int n5 = this.dimScreen.height;
        if (n2 > 0 && n3 > 0) {
            this.resizeImage(n2, n3, true);
        }
        this.setModelVisibility();
        try {
            this.statusManager.createImage(string, string2, n);
        }
        catch (Exception exception) {
            Logger.error("Error creating image: " + exception.getMessage());
        }
        if (n2 > 0 && n3 > 0) {
            this.resizeImage(n4, n5, true);
        }
    }

    public void setSyncDriver(int n) {
        if (Logger.isActiveLevel(0)) {
            Logger.debug(this.htmlName + " viewer setting sync driver " + n);
        }
        this.statusManager.setSyncDriver(n);
    }

    public int getSyncMode() {
        return this.statusManager.getSyncMode();
    }

    public float[] getPartialCharges() {
        return this.modelManager.getPartialCharges();
    }

    void setProteinType(byte by, BitSet bitSet) {
        this.modelManager.setProteinType(bitSet == null ? this.selectionManager.bsSelection : bitSet, by);
    }
}

