# The LearningOnline Network with CAPA
# The bookmarks handler
#
# $Id: admbookmarks.pm,v 1.38 2008/11/20 13:51:07 jms Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# 08/25/00 Ben Tyszka
#
#
#
##################

=pod

=head1 NAME

Apache::admbookmarks

=head1 SYNOPSIS

This will take bookmarks and get/write/display
them for the LON-CAPA user interface.

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 OVERVIEW

(empty)


=head1 SUBROUTINES

=over write_bookmarks()

=item get_bookmarks()

=item construct_editor()

=item error_message()

=item construct_toolbar()

=item add_bookmark()

=item handler()

=back

=cut


package Apache::admbookmarks;

use strict;
use Apache::Constants qw(:common);
use Apache::lonnet;
use Apache::loncommon();
use Apache::lonlocal;

# --------------------------------------------------------------Put bookmarks

sub write_bookmarks {
    my ($marks) = @_;
    &Apache::lonnet::put("bookmarks",{'bookmarks' => $marks});
    return;
}

# --------------------------------------------------------------Get bookmarks

sub get_bookmarks {
    my %bookmark=&Apache::lonnet::get('bookmarks',['bookmarks']);
    my ($errormsg) = $bookmark{'bookmarks'};
    if ($errormsg =~ /^error/) { %bookmark = ('bookmarks' => ''); }

    return %bookmark;
}

# ---------------------------------------------------Construct bookmark editor

sub construct_editor {
    my ($bookmarks) = @_;
    my $js = <<ENDJS;
<script src="/res/adm/pages/bookmarkmenu/bookmarklib.js" type="text/javascript"></script>

<script type="text/javascript">
function initialize() {
window.tree = new newTree();
//-----------------------------------------------------------------------------
//                         The FOLLOWING data is supplied by the Perl Module
//-----------------------------------------------------------------------------
$bookmarks
//-----------------------------------------------------------------------------
//                         The PRECEDING data is supplied by the Perl Module
//-----------------------------------------------------------------------------
window.tree.redraw();
}
</script>
ENDJS

    my $start_page =
        &Apache::loncommon::start_page('Bookmark Tree Viewer/Editor',$js,
				       {'frameset'    => 1,
					'add_entries' => {
					    'rows'         => "25,*,40,25,1",
					    'topmargin'    => "0",
					    'leftmargin'   => "0",
					    'marginheight' => "0",
					    'marginwidth'  => "0",
					    'frameborder'  => "0",
					    'border'       => "0",
					    'framespacing' => "0",
					    'onload'       => "javascript:buildBookmarkMenu();initialize();"}});
    my $end_page =
	&Apache::loncommon::end_page({'frameset'    => 1,});

    return(<<END_HTML) 
$start_page
 <frameset cols="25, *, 25" frameborder="0" borders="0" framespacing="0">
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
 </frameset>
 <frameset cols="25, *, 25" frameborder="0" borders="0" framespacing="0">
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
  <frame src="/res/adm/pages/bookmarkmenu/blank.html" marginwidth="0"
         marginheight="0" scrolling="yes" />
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
 </frameset>
 <frameset cols="25, *, 25" frameborder="0" borders="0" framespacing="0">
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
  <frame src="/res/adm/pages/bookmarkmenu/bookmarkmenu_toolbar.html"
         marginwidth="0" marginheight="0" scrolling="no" />
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
 </frameset>
 <frameset cols="25, *, 25" frameborder="0" borders="0" framespacing="0">
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
  <frame marginwidth="0" marginheight="0" scrolling="no" src="javascript:''" />
 </frameset>
<frame name="closechildren" noresize="noresize" noscroll="noscroll"
       src="/res/adm/pages/bookmarkmenu/closechildren.html" />
$end_page
END_HTML
}

# ---------------------------------------------------------------Construct Error window

sub construct_error {
    my ($error_message) = @_;
    my $start_page = 
	&Apache::loncommon::start_page('Bookmark Tree Viewer/Editor',undef,
				       {'only_body' => 1,
					'bgcolor'   => '#BBBBBB',});

    my $end_page =  &Apache::loncommon::end_page();
    
    my $close = &mt('Close Window');

    return(<<END_ERROR)
$start_page
  <table bgcolor="#FFFFFF" width="100%" height="90%" align="center">
   <td>
    <i>
     $error_message
    </i>
   </td>
  </table>
  <center>
   <form>
    <input type="button" name="close" value="$close" 
           onclick="javascript:window.close();" />
   </form>
  </center>
$end_page
END_ERROR
}

# --------------------------------------------Construct toolbar (after saving)

sub construct_toolbar {
    my $start_page = 
	&Apache::loncommon::start_page('Bookmark Tree Viewer/Editor',undef,
				       {'only_body' => 1,
					'bgcolor'   => '#FFFFFF',});

    my $end_page =  &Apache::loncommon::end_page();

    my $msg = &mt('Bookmarks saved. ([_1]Continue[_2])',
		  '<a href="/res/adm/pages/bookmarkmenu/bookmarkmenu_toolbar.html" target="_self">',
		  '</a>');

    return(<<END_TOOLBAR)
$start_page
<div align="bottom">
<center>
$msg
</center>
</div>
$end_page
END_TOOLBAR
}

# ---------------------------------------------Add bookmark from remote control

sub add_bookmark {
    my ($location, $title, $bookmarks) = @_;
    my $start_page = 
	&Apache::loncommon::start_page('Bookmark Tree Viewer/Editor',undef,
				       {'only_body' => 1,
					'bgcolor'   => '#FFFFFF',});

    my $end_page =  &Apache::loncommon::end_page();

    $bookmarks .= "window.tree.bookmarks.addLink(\"$title\",\"$location\");\n";
#	$marks{'bookmarks'} += qq/\nwindow.tree.bookmarks.addlink("$title","$location");\n/;
    &write_bookmarks($bookmarks);
    my $page="$start_page $bookmarks<p>Bookmarks successfully saved</p><script type=\"text/javascript\">window.close()</script> $end_page";
    return($page);
}

# ----------------------------------------------------------------Main Handler

sub handler {
    my ($r) = @_;
    my %marks;
    my $save_mark;
    my $page;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    if (defined($env{'form.hiddenbookmarks'})) {
	$marks{'bookmarks'}=$env{'form.hiddenbookmarks'};
	&write_bookmarks($marks{'bookmarks'});
	$page=&construct_toolbar();
    } else {
	%marks=&get_bookmarks();
	if (exists($marks{"con_lost"})) {
	    #$page = construct_editor($marks{'bookmarks'});  # Delete this line and uncomment next
	    # in order to re-enable connection detection
	    $page=&construct_error(&mt("Connection broken with home server. Please contact your system administrator."));
	} else {
	    if (defined($env{'form.address'})) {
		$page=&add_bookmark($env{'form.address'},$env{'form.title'},$marks{'bookmarks'});
	    } else {
		if ($marks{'bookmarks'} eq "") {
		    $marks{'bookmarks'}=&defaultmarks();
		}
		$page = &construct_editor($marks{'bookmarks'});
	    }
	}
    }
    $r->print($page);
    return OK;
}

####################################
#
#            The following was used for debugging when the bookmarks get corrupted
#                            ben  10/12/2000
sub recovermarks {
    return(<<END_MARKS);
window.tree.bookmarks.addFolder("Default Bookmarks",true);
window.tree.bookmarks.p[0].addFolder("LON-CAPA",true);
window.tree.bookmarks.p[0].p[0].addLink("Main","http://www.lon-capa.org/");
window.tree.bookmarks.p[0].p[0].addLink("Help","http://help.lon-capa.org/");
window.tree.bookmarks.p[0].p[0].addLink("Bugs","http://bugs.lon-capa.org/");
END_MARKS
}
#
#
##########################################

##########################################
#
#          Here is a listing of default bookmarks. It may be used to replace 'recover'
#          eventually, but for now these will load after all bookmarks have been deleted.
#                ben 10/12/2000
sub defaultmarks {
    return(<<END_MARKS);
window.tree.bookmarks.addFolder("Default Bookmarks",true);
window.tree.bookmarks.p[0].addFolder("LON-CAPA",true);
window.tree.bookmarks.p[0].p[0].addLink("Main","http://www.lon-capa.org/");
window.tree.bookmarks.p[0].p[0].addLink("Help","http://help.lon-capa.org/");
window.tree.bookmarks.p[0].p[0].addLink("Bugs","http://bugs.lon-capa.org/");
END_MARKS
}

1;
__END__





