<!--
The LearningOnline Network
Resource Assembly Tool
// $Id: ratcode.js,v 1.10 2009/04/23 13:09:44 bisitz Exp $
//
// Copyright Michigan State University Board of Trustees
//
// This file is part of the LearningOnline Network with CAPA (LON-CAPA).
//
// LON-CAPA is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// LON-CAPA is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with LON-CAPA; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
// /home/httpd/html/adm/gpl.txt
//
// http://www.lon-capa.org/
//
YEAR 2000
7/23,7/24,7/26,
8/11,8/14,8/18,8/19,8/20,8/21,8/22,8/25,8/26,8/28,8/30,8/31,
9/1,9/2,9/4,9/5,9/6,
1/7,1/8,1/10,1/14,1/15,1/16,1/21,1/22,1/29,1/30,1/31,
2/2,2/3,2/10,2/12,2/13,2/14,2/15,2/17,2/18,2/19,2/20,2/21,2/22,
5/2,5/3,5/4,5/5,5/6,5/8,5/9,5/13,5/18,5/20,5/22,5/24,5/25,
6/7,6/8,6/9,6/10,6/12,6/15,7/4,7/26,7/28,7/31,8/5,8/19,8/24,
YEAR 2001
01/17/01,03/03,03/05 Gerd Kortemeyer
04/20 Gerd Kortemeyer
06/11,06/25,06/27,06/28,06/29,07/04 Gerd Kortemeyer
03/01/02 Matthew Hall
-->


<script type="text/javascript" language="JavaScript">

var row=new Array();
var maxrow=-1;
var col=new Array();
var maxcol=-1;

var colmap=new Array();
var colmap2=new Array();
var colmap3=new Array();
var colmap4=new Array();
var colmap5=new Array();
var colmap6=new Array();
var obj=new Array();
var objcont=new Array();
var objparms=new Array();
var objlinks=new Array();
var rowcont=new Array();
var rowtype=new Array();
var coltype=new Array();
var rcol=new Array();
var rrow=new Array();
var cw=new Array();
var rh=new Array();

var undostack=new Array();
var undopointer=0;
var stored=0;
var editmode=0;
var notclear=0;
var linkmode=0;
var lastinfo='';
var graphdef='no';
var mode='';
var mainrun=0;
var tablemode=0;
var mostrecent=0;
var zscale=3;

var disrows=0;
var discols=0;

var finishdone=0;
var tim=0;
var funny='|';
var reqaction='';
var canceltim;

var expense=0;

var data1=new Array(1024);
var data2=new Array(1024);
var data3=new Array(1024);
var data4=new Array(1024);
var data5=new Array(1024);
var data6=new Array(1024);

var inf;
var srch;
var srchflag=-1; // 1 means currently open
                 // 0 means closed (but has been open)
                 // -1 means never yet opened/defined
var srchmode='';

var idx;
var idxflag=-1; // 1 means currently open
                 // 0 means closed (but has been open)
                 // -1 means never yet opened/defined
var idxmode='';

var copydx;
var copydxflag=-1; // 1 means currently open
                 // 0 means closed (but has been open)
                 // -1 means never yet opened/defined
var copydxmode='';

var parm;
var parmflag=-1; // 1 means currently open
                 // 0 means closed (but has been open)
                 // -1 means never yet opened/defined
                 
var iconpath='/adm/lonIcons/';
var raticons='/adm/rat/';

function testfunction() {
   inf.document.forms.resinfo.elements.t.value="ABC";
}

// ------------------------------------------------ Insert a row into the table
function insertrow(j,ex1,ex2) {
   var kj;
   stored=0;
   expense++; expense++;
   objects1='';
   objects2='';
   for (kj=0;kj<=maxrow;kj++) {
      if ( row[kj]==j )   { objects1=rowcont[kj]; }
      if ( row[kj]==j+1 ) { objects2=rowcont[kj]; } 
      if ( row[kj]>j ) { row[kj]++; } 
   }
   maxrow++;
   row[maxrow]=j+1;
   rowcont[maxrow]=':';
   colcover=':'+ex1+':'+ex2+':';
   objects=objects1+':'+objects2;
   data1=objects.split(':');
   for (kj=0;kj<data1.length;kj++) {
     if ((data1[kj]!='') && (typeof(data1[kj])!="undefined")) {
       thisisobj=obj[data1[kj]];
       thisobjtype=thisisobj.split('&')[0];
       if (thisobjtype=='v') {
          if (rowcont[maxrow].indexOf(':'+data1[kj]+':',0)==-1) {
             thisobjcol=thisisobj.split('&')[1];
             if (colcover.indexOf(':'+thisobjcol+':',0)==-1) {
                colcover+=thisobjcol+':';  
                rowcont[maxrow]+=data1[kj]+':';
             }
          }
       }
       if (thisobjtype=='h') {
             updown=thisisobj.split('&')[4];
             leftupdown=updown.split(':')[0];
             rightupdown=updown.split(':')[1];          
             thisobjdest=thisisobj.split('&')[3];
             thisobjtofrom=thisisobj.split('&')[2];
             thisobjfrom=thisobjtofrom.split(':')[0];
             thisobjto=thisobjtofrom.split(':')[1];
             thisobjdir=col[thisobjto]-col[thisobjfrom];
             thisobjrow=row[thisisobj.split('&')[1]];
             topbottom=thisobjrow-j-1;
             newobj='';
             if (leftupdown==-1) {
                if (topbottom<0) {
                   if (thisobjdir<0) {
                      newobj='v&'+thisobjto+'&'+thisobjdest+'&-1';
                   } else {
                      newobj='v&'+thisobjfrom+'&'+thisobjdest+'&1';
                   }
                }
             } else {
                if (topbottom>0) {
                   if (thisobjdir<0) {
                      newobj='v&'+thisobjto+'&'+thisobjdest+'&1';
                   } else {
                      newobj='v&'+thisobjfrom+'&'+thisobjdest+'&-1';
                   }
                }
             }
             if ((newobj!='') && (typeof(newobj)!="undefined")) {
                thisobjcol=newobj.split('&')[1];
                if (colcover.indexOf(':'+thisobjcol+':',0)==-1) {
                   colcover+=thisobjcol+':';  
                   rowcont[maxrow]+=obj.length+':';
                   obj[obj.length]=newobj;
                }
             }
             newobj=''; 
             if (rightupdown==-1) {
                if (topbottom<0) {
                   if (thisobjdir<0) {
                      newobj='v&'+thisobjfrom+'&'+thisobjdest+'&1';
                   } else {
                      newobj='v&'+thisobjto+'&'+thisobjdest+'&-1';
                   }
                }
             } else {
                if (topbottom>0) {
                   if (thisobjdir<0) {
                      newobj='v&'+thisobjfrom+'&'+thisobjdest+'&-1';
                   } else {
                      newobj='v&'+thisobjto+'&'+thisobjdest+'&1';
                   }
                }
             }
             if ((newobj!='') && (typeof(newobj)!="undefined")) {
                thisobjcol=newobj.split('&')[1];
                if (colcover.indexOf(':'+thisobjcol+':',0)==-1) {
                   colcover+=thisobjcol+':';  
                   rowcont[maxrow]+=obj.length+':';
                   obj[obj.length]=newobj;
                }
             } 
       }
     }
   }
   if (rowcont[maxrow]!=':') {
      rowcont[maxrow]=rowcont[maxrow].substring(1,rowcont[maxrow].length-1);
   } else {
      rowcont[maxrow]='';
   }
}

// --------------------------------------------- Creates a new condition object
function newcondition(content,type) {
   var ko;
   stored=0;
   ko=obj.length;
   obj[ko]='c';
   objcont[ko]=content+':'+type+':cond';
   return ko;
}

// ---------------------------------------------- Creates a new resource object
function newresource(rid,cid,text,url,ext,type,oldidx) {
   stored=0;
   var newidx=addobj(rid,'b&'+rid+'&'+cid+':0:0:0',url,oldidx);

   objcont[newidx]=
    text+':'+url+':'+ext+':'+type+':res';
   return newidx;
}


// -------------------------------- Insert a condition into a port of an object
function insertcond(obj1,portnr,cond) {
   var k;
   stored=0;
   data1=obj[obj1].split('&');
   for (k=2;k<data1.length;k++) {
       data2=data1[k].split(':');
       if (data2[0]==portnr) {
          data2[3]=cond;
          data1[k]=data2.join(':');
       }
   }
   obj[obj1]=data1.join('&');
}
 
// --------------------------------------------- Insert a column into the table
// Inserts a new table column after table column j
function insertcol(j) {
   var kj;
   stored=0;
   for (kj=0;kj<=maxcol;kj++) {
      if ( col[kj]>j ) { col[kj]++; } 
   }
   maxcol++;
   expense++; expense++;
   col[maxcol]=j+1;
}
     
// --------------------------------------------------------------- Find the row
function findrow(jid) {
   var j;
   for (j=0;j<=maxrow;j++) { if (row[j]==jid) { return j; } }
   return -1;
}

// --------------------------------------------------------------- Find the col
function findcol(jid) {
   var j;
   for (j=0;j<=maxcol;j++) { if (col[j]==jid) { return j; } }
   return -1;
}

// -------------------------------------------------------------- Map out a row
//
// b&rowID&colID:inObj:outObj:outCond&...
// h&rowID&incolID:outcolID&inObj:outObj&inupdown:outupdown
// v&colID&inObj:outObj&updown
//
// returns middle (col number of middle of obj1)
// sets colmap (map of cols with object numbers)
function maprow (jid,obj1,ign) {
 var j; var k; var left; var right; var middle;
 middle=-1;
 for (j=0;j<=maxcol;j++) { colmap[j]=0; }
 if ((rowcont[jid]!='') && (typeof(rowcont[jid])!="undefined")) {
   data2=rowcont[jid].split(':');
   for (j=0;j<data2.length;j++) {
      data3=obj[data2[j]].split('&');
      if (data3[0]=='b') {
         left=maxcol;
         right=0;
         for (k=2;k<data3.length;k++) {
            thiscol=col[data3[k].split(':')[0]];
            if (thiscol<left)  { left=thiscol;  }
            if (thiscol>right) { right=thiscol; }
         }
      }
      if (data3[0]=='h') {
         data4=data3[2].split(':');
         if (col[data4[1]]>col[data4[0]]) {
            left=col[data4[0]];
            right=col[data4[1]];
         } else {
            right=col[data4[0]];
            left=col[data4[1]];
         }
      }
      if (data3[0]=='v') { left=col[data3[1]]; right=left; }
      if (data2[j]==obj1) { middle=Math.round((left+right)/2); }
      if ((data3[0]!='h') || (ign!=1)) {
         for (k=left;k<=right;k++) { colmap[k]=data2[j]; }
      } else {
         colmap[left]=data2[j];
         colmap[right]=data2[j];
      }
   }
 }
 return middle;
}

// --------------------------------------------------------- Find hole in a row
// jid: rowID
// kid: colID, find point close to this
// dkid: destination colID
// returns colID
function comingthru (jid,kid,dkid) {
   var k;
   maprow(jid,-1,1);
   knum=col[kid];
   if (colmap[knum]==0) { return kid; }
   right=-1;
   for (k=knum+1;(k<colmap.length) && (right==-1);k++) {
      if ((right==-1) && (colmap[k]!=colmap[knum])) { right=k; }
   }
   left=-1;
   for (k=knum-1;(k>=0) && (left==-1);k--) {
      if ((left==-1) && (colmap[k]!=colmap[knum])) { left=k; }
   }
   kup=-1;

   if ((left==-1) && (right==-1)) { right=colmap.length; }

   dknum=col[dkid];
   dleft=left-dknum;
   dright=right-dknum;

   if (dleft<0) { dleft=-dleft; }
   if (dright<0) { dright=-dright; }
   if ((dright<=dleft) && (right!=-1)) { kup=right; }
   if ((dright>=dleft) && (left!=-1)) { kup=left; }
   if (colmap[kup]==0) { return findcol(kup); }

   if (kup==right) { kup--; }

   if (kup<0) { 
      insertcol(-1);
      insertcol(0);
   } else {
      insertcol(kup);
   }
   return maxcol;
}

// ----------------------------------------------------- Insert port into block
// obj1: object number
// d: direction from middle (>0: right, <0 left)
// inout: in or out port (1: in, 2: out)
// linkobj: object that the link goes to/comes from
// sets inrow or outrow
// return column
function insertport (obj1,d,inout,linkobj) {
   var k; var port; var revport;
   stored=0;
   data1=obj[obj1].split('&');
   middle=maprow(data1[1],obj1,0);
   if (inout==1) {
      inrow=data1[1];
   } else {
      outrow=data1[1];
   }
   if (d>0) {
      for (k=middle;(colmap[k]==obj1) && (k<colmap.length);k++) { data3[k]=0; }
   } else {
      for (k=middle;(colmap[k]==obj1) && (k>=0);k--) { data3[k]=0; }
   }
   for (k=2;k<data1.length;k++) { 
      data2=data1[k].split(':');
      data3[col[data2[0]]]=data2[inout];
   }
   port=-1;
   if (d>0) {
      for (k=middle;(colmap[k]==obj1) && (k<colmap.length);k++) {
         if ((data3[k]==0) && (colmap[k]==obj1) && (port==-1)) { port=k; }
      }
   } else {
      for (k=middle;(colmap[k]==obj1) && (k>=0);k--) {
         if ((data3[k]==0) && (colmap[k]==obj1) && (port==-1)) { port=k; } 
      }
   }
   if (port==-1) {
      if (colmap[k]==0) {
         revport=findcol(k);
         if (inout==1) {
            data1[data1.length]=revport+":"+linkobj+":0:0";
         } else {
            data1[data1.length]=revport+":0:"+linkobj+":0";
         }
      } else {
         if (d>0) {
            insertcol(k-1);
         } else {
            insertcol(k);
         }
         revport=maxcol;
         if (inout==1) {
            data1[data1.length]=revport+":"+linkobj+":0:0";
         } else {
            data1[data1.length]=revport+":0:"+linkobj+":0";
         }
      }
   } else {
      portfound=-1;
      for (k=2;k<data1.length;k++) { 
         data2=data1[k].split(':');
         if (col[data2[0]]==port) {
            data2[inout]=linkobj;
            data1[k]=data2.join(':');
            portfound=1;
         }
      }
      revport=findcol(port);
      if (portfound==-1) {
         if (inout==1) {
            data1[data1.length]=revport+":"+linkobj+":0:0";
         } else {
            data1[data1.length]=revport+":0:"+linkobj+":0";
         }
      }
   }
   obj[obj1]=data1.join('&');
   return revport;
}

// ---------------------------- Make a new object and add it to the row content
// returns object number of generated object
function addobj(kjid,objs,url,oldindex) {
   stored=0;
   expense++;
   if ((rowcont[kjid]!='') && (typeof(rowcont[kjid])!="undefined")) { 
      rowcont[kjid]+=':'; 
   }
   var newindex=obj.length;
   if ((url!='') && (typeof(url)!="undefined")) {
// see if we have a zombie with that url and possibly oldindex
      for (oidx=0;oidx<objcont.length;oidx++) {
          if (typeof(objcont[oidx])!="undefined") {
             data6=objcont[oidx].split(':');	
             if (data6[4]=='zombie') {
                if (data6[1]==url) {
		   if (typeof(oldindex) == "undefined") {
                     newindex=oidx;
                   } else {
                     if (oidx == oldindex) {
                       newindex=oidx;
                     }
                   }
                }
             }
         }
      }
   }
   rowcont[kjid]+=newindex;
   obj[newindex]=objs;
   return newindex;
} 

// ---------------------------------------- Make horizontal connection for hrid
// hoffs=-1: this line goes on top of hrid
function horizontal(hrid,hoffs,hfcol,htcol,hdest,hends) {
   hcrid=-1;
   if (hoffs==-1) {
      hbrid=findrow(row[hrid]-1);
   } else {
      hbrid=findrow(row[hrid]+1);
   }
   if (hbrid!=-1) {
      maprow(hbrid,-1,0);
      hcrid=hbrid;
      if (col[hfcol]>col[htcol]) { left=col[htcol]; right=col[hfcol]; }
                            else { right=col[htcol]; left=col[hfcol]; }
      if (colmap[left]!=0) {
         hcrid=-1;
      } else {
         if (colmap[right]!=0) {
            hcrid=-1;
         } else {
            for (kh=left+1;kh<right;kh++) {
               if (colmap[kh]!=0) { 
                  if (obj[colmap[kh]].split('&')[0]!='v') { hcrid=-1; }
               }
            }
         }
      }
   }
   if (hcrid==-1) {
      insertrow(row[hrid]+hoffs,hfcol,htcol);
      addobj(maxrow,'h&'+maxrow+'&'+hfcol+':'+htcol+'&'+hdest+'&'+hends);
   } else {
      addobj(hcrid,'h&'+hcrid+'&'+hfcol+':'+htcol+'&'+hdest+'&'+hends);
   }   
}

// --------------------------------------- Deletes all references to object obj
function delobj(obj1) {
   var k;
   stored=0;
   for (k=0;k<rowcont.length;k++) {
      data4=rowcont[k].split(':');
      rowcont[k]='';
      for (k2=0;k2<data4.length;k2++) {
         if (data4[k2]!=obj1) {
            if ((rowcont[k]!='') && (typeof(rowcont[k])!="undefined")) { 
               rowcont[k]+=':'; 
            } 
            rowcont[k]+=data4[k2]; 
         }
      }
   }
   obj[obj1]='';
}

// --------------------------------------------------------- Garbage collection
function cleanup () {
   message("Garbage Collection");
   var j,kj,i;
   disrows=0;
   discols=0;
   var emptyspots=0;

   for (kj=0;kj<=maxcol;kj++) { data1[kj]=0; }
   for (kj=0;kj<=maxrow;kj++) {
     rowtype[kj]=0;
     if ((rowcont[kj]!='') && (typeof(rowcont[kj])!="undefined")) {
       data2=rowcont[kj].split(':');
       for (j=0;j<data2.length;j++) {
         if (obj[data2[j]].substring(0,2)=='e&') {
            rowtype[kj]=2;
            data1[(obj[data2[j]].split('&'))[1]]=2;
         }
       }
       maprow(kj,-1,1);
       for (j=0;j<=maxcol;j++) {
           if (colmap[j]!=0) {
              if (data1[j]==0) { data1[j]=1; }
              if (rowtype[kj]==0) {
                 if (obj[colmap[j]].substring(0,2)!='v&') { 
                    rowtype[kj]=1; 
                 }
              }
              if (obj[colmap[j]].substring(0,2)=='b&') { 
                 data1[j]=2;
                 if (colmap[maxcol]==0) { emptyspots++; }
                 rowtype[kj]=2;
              }  
           }
       }
     }
   }
   for (j=0;j<=maxcol;j++) { 
      coltype[j]=data1[col[j]];
      if (coltype[j]!=0) { discols+=1; } 
   }
   for (j=0;j<=maxrow;j++) {
       if (rowtype[j]==2) { disrows+=3; }
       if (rowtype[j]==1) { disrows+=1; }
   }
   if (emptyspots==0) {
      insertrow(maxrow);
      insertcol(maxcol);
      addobj(maxrow,'e&'+maxcol);
      discols++;
      disrows++;
      rowtype[maxrow]=2;
      coltype[maxcol]=2;
   }
}

// -------------------------------------------- Delete a condition from a block
function delcond(obj1,colid) {
   var k;
   stored=0;
   data3=obj[obj1].split('&');
   obj[obj1]=data3[0]+'&'+data3[1];
   for (k=2;k<data3.length;k++) {
      data4=data3[k].split(':');
      if (data4[0]==colid) { 
         data4[3]=0; 
         objlinks[data4[2]]=(objlinks[data4[2]].split(':'))[0]+':'+
                            (objlinks[data4[2]].split(':'))[1]+':0';
      }
      if ((data4[1]!=0) || (data4[2]!=0) || (data3.length==3)) {
         obj[obj1]+='&'+data4[0]+':'+data4[1]+':'+data4[2]+':'+data4[3];
      }
   }
}
    
// ----------------------------------------- Creates a new condition in a block
function crecond(obj1,colid,condtext,condtype) {
   var k;
   data3=obj[obj1].split('&');
   obj[obj1]=data3[0]+'&'+data3[1];
   for (k=2;k<data3.length;k++) {
      data4=data3[k].split(':');
      if (data4[0]==colid) { 
         data4[3]=newcondition(condtext,condtype);
         data2=objlinks[data4[2]].split(':');
         objlinks[data4[2]]=data2[0]+':'+data2[1]+':'+data4[3];
      }
      if ((data4[1]!=0) || (data4[2]!=0) || (data3.length==3)) {
         obj[obj1]+='&'+data4[0]+':'+data4[1]+':'+data4[2]+':'+data4[3];
      }
   }
}

// ---------------------------------------- Delete the path between two objects
// deletes the link linknr
// h&rowID&incolID:outcolID&inObj:outObj&inupdown:outupdown
// v&colID&inObj:outObj&updown
function dellink (linknr) {
  var k; var obj1; var obj2;
  stored=0;
  if ((objlinks[linknr]!='') && (typeof(objlinks[linknr])!="undefined")) {
   data3=objlinks[linknr].split(':');
   obj1=data3[0];
   obj2=data3[1];
   data3=obj[obj1].split('&');
   obj[obj1]=data3[0]+'&'+data3[1];
   for (k=2;k<data3.length;k++) {
      data4=data3[k].split(':');
      if (data4[2]==linknr) { data4[2]=0; data4[3]==0; }
      if ((data4[1]!=0) || (data4[2]!=0) || (data3.length==3)) {
         obj[obj1]+='&'+data4[0]+':'+data4[1]+':'+data4[2]+':'+data4[3];
      }
   }
   data3=obj[obj2].split('&');
   obj[obj2]=data3[0]+'&'+data3[1];
   for (k=2;k<data3.length;k++) {
      data4=data3[k].split(':');
      if (data4[1]==linknr) { data4[1]=0; }
      if ((data4[1]!=0) || (data4[2]!=0) || (data3.length==3)) {
         obj[obj2]+='&'+data4[0]+':'+data4[1]+':'+data4[2]+':'+data4[3];
      }
   }
   for (k=0;k<obj.length;k++) {
     if ((obj[k]!='') && (typeof(obj[k])!="undefined")) {
       data3=obj[k].split('&');
       if (((data3[0]=='v') || (data3[0]=='h')) && 
           (data3[data3.length-2]==linknr)) {
             delobj(k);
       }
     }
   }
   objlinks[linknr]='';
  }     
}

// ----------------------------------------------------------- Join two objects
// Links obj1 with obj2, creates new objlink, marks all elements with number
function joinres (obj1,obj2,cond) {
   stored=0;
   var minexpense;
   var best;

   expense=0;
   tryjoin(obj1,obj2,cond,1,1);
   minexpense=expense;
   best=0;
   finishload();

   expense=0;
   tryjoin(obj1,obj2,cond,1,-1);
   if (expense<minexpense) {
      best=1;
      minexpense=expense;
   }
   finishload();

   expense=0;
   tryjoin(obj1,obj2,cond,-1,1);
   if (expense<minexpense) {
      best=2;
      minexpense=expense;
   }
   finishload();

   expense=0;
   tryjoin(obj1,obj2,cond,-1,-1);
   if (expense<minexpense) {
      best=3;
      minexpense=expense;
   }

   if (best==0) {
      finishload();
      tryjoin(obj1,obj2,cond,1,1);
   }
   if (best==1) {
      finishload();
      tryjoin(obj1,obj2,cond,1,-1);
   }
   if (best==2) {
      finishload();
      tryjoin(obj1,obj2,cond,-1,1);
   }
}

function tryjoin(obj1,obj2,cond,d1,d2) {
   var k; var kr; var outcol; var incol; var d; var dest;

   dest=objlinks.length;
   objlinks[dest]=obj1+':'+obj2+':'+cond;

   outcol=insertport(obj1,d1,2,dest);
   insertcond(obj1,outcol,cond);
   incol=insertport(obj2,d2,1,dest);
   if (row[inrow]==(row[outrow]+1)) {
      insertrow(row[outrow],-1,-1);
   }
   if (row[inrow]<row[outrow]) {
      updown=1;
      tcol=comingthru(inrow,incol,outcol);
      horizontal(inrow,-1,tcol,incol,dest,'-1:-1');
      addobj(inrow,'v&'+tcol+'&'+dest+'&1');
      incol=tcol;
      tcol=comingthru(outrow,outcol,incol);
      horizontal(outrow,0,outcol,tcol,dest,'1:1');
      addobj(outrow,'v&'+tcol+'&'+dest+'&1');
      outcol=tcol;
   } else {
     updown=-1;
   }

   if (inrow==outrow) {
      tcol=comingthru(inrow,incol,outcol);
      horizontal(inrow,-1,tcol,incol,dest,'-1:-1');
      addobj(inrow,'v&'+tcol+'&'+dest+'&1');
      horizontal(outrow,0,outcol,tcol,dest,'1:1');
   } else {

      if (updown==-1) {
         for (kr=row[outrow]+1;kr<row[inrow];kr++) {
            rid=findrow(kr);
            ncol=comingthru(rid,outcol,incol);

            if (ncol!=outcol) {
               insertrow(kr-1,outcol,ncol);
               kr++;
               if (col[outcol]>col[ncol]) {
                  addobj(maxrow,
                            'h&'+maxrow+'&'+outcol+':'+ncol+'&'+dest+'&-1:1');
               } else {
                  addobj(maxrow,
                            'h&'+maxrow+'&'+outcol+':'+ncol+'&'+dest+'&1:-1');
               }
            }
            addobj(rid,'v&'+ncol+'&'+dest+'&-1');
            outcol=ncol;
         }

         if (incol!=outcol) {
            insertrow(row[inrow]-1,outcol,incol);
            if (col[outcol]>col[incol]) {
               addobj(maxrow,
                         'h&'+maxrow+'&'+outcol+':'+incol+'&'+dest+'&-1:1');
            } else {
               addobj(maxrow,
                         'h&'+maxrow+'&'+outcol+':'+incol+'&'+dest+'&1:-1');
            }
         }

      } else {
         for (kr=row[outrow]-1;kr>row[inrow];kr--) {
            rid=findrow(kr);
            ncol=comingthru(rid,outcol,incol);
            if (ncol!=outcol) {
               insertrow(kr,outcol,ncol);
               if (col[outcol]>col[ncol]) {
                  addobj(maxrow,
                            'h&'+maxrow+'&'+outcol+':'+ncol+'&'+dest+'&1:-1');
               } else {
                  addobj(maxrow,
                            'h&'+maxrow+'&'+outcol+':'+ncol+'&'+dest+'&-1:1');
               }
            }
            addobj(rid,'v&'+ncol+'&'+dest+'&1');
            outcol=ncol;
         }
         if (incol!=outcol) {
            insertrow(row[inrow],outcol,incol);
            if (col[outcol]>col[incol]) {
               addobj(maxrow,
                         'h&'+maxrow+'&'+outcol+':'+incol+'&'+dest+'&1:-1');
            } else {
               addobj(maxrow,
                         'h&'+maxrow+'&'+outcol+':'+incol+'&'+dest+'&-1:1');
            }
         }
      }
   }  
}

// ---------------------------------------------------------- Delete a resource
// Deletes resource obj1
// Reconnects resources going thru this one if recon=1
function delres (obj1,recon) {
   var infromobj=new Array();
   var inwithcon=new Array();
   var inwithlink=new Array();
   var outtoobj=new Array();
   var outwithcon=new Array();
   var outwithlink=new Array();
   var inobjs=new Array();
   var inobjscond=new Array();
   var outobjs=new Array();
   var outobjscond=new Array();

   var k; var k1; var k2; var found;

   stored=0;

   data1=obj[obj1].split('&');
   for (k=2;k<data1.length;k++) {
      data2=data1[k].split(':');
      if (data2[1]!=0) {
         k2=inwithlink.length;
         inwithlink[k2]=data2[1];
         data3=objlinks[data2[1]].split(':');
         infromobj[k2]=data3[0];
         inwithcon[k2]=data3[2];
      }
      if (data2[2]!=0) {
         k2=outwithlink.length;
         outwithlink[k2]=data2[2];
         data3=objlinks[data2[2]].split(':');
         outtoobj[k2]=data3[1];
         outwithcon[k2]=data3[2];
      }
   }
   for (k=0;k<inwithlink.length;k++)  { dellink(inwithlink[k]); }
   for (k=0;k<outwithlink.length;k++) { dellink(outwithlink[k]); }
   delobj(obj1);
// turn into a zombie
   data2=objcont[obj1].split(':');
   data2[3]='zombie';
   data2[4]='zombie';
   objcont[obj1]=data2.join(':');
// reconnect
   if (recon==1) {
     message("Reconnecting");
      for (k=0;k<inwithlink.length;k++) {
         if (infromobj[k]!=obj1) {
            found=0;
            for (k2=0;k2<inobjs.length;k2++) {
               if (inobjs[k2]==infromobj[k]) {
                  if (inwithcon[k]!=0) {
                     if ((inobjscond[k2]!='') &&
                         (typeof(inobjscond[k2])!="undefined")) { 
                         inobjscond[k2]+='||'; 
                     }
                     inobjscond[k2]+=
                      '('+(objcont[inwithcon[k]].split(':'))[0]+')';
                   }
                  found=1;
               }
            }
            if (found==0) {
               k2=inobjs.length;
               inobjs[k2]=infromobj[k];
               if (inwithcon[k]==0) {
                  inobjscond[k2]='';
               } else {
                  inobjscond[k2]=
                   '('+(objcont[inwithcon[k]].split(':'))[0]+')';
               }
            }
         }
      }  

      for (k=0;k<outwithlink.length;k++) {
         if (outtoobj[k]!=obj1) {
            found=0;
            for (k2=0;k2<outobjs.length;k2++) {
               if (outobjs[k2]==outtoobj[k]) {
                 if (outwithcon[k]!=0) {
                     if ((outobjscond[k2]!='') &&
                         (typeof(outobjscond[k2])!="undefined")) { 
                         outobjscond[k2]+='||'; 
                     }
                     outobjscond[k2]+=
                      '('+(objcont[outwithcon[k]].split(':'))[0]+')';
                  }
                  found=1;
               }
            }
            if (found==0) {
               k2=outobjs.length;
               outobjs[k2]=outtoobj[k];
               if (outwithcon[k]==0) {
                  outobjscond[k2]='';
               } else {
                  outobjscond[k2]=
                   '('+(objcont[outwithcon[k]].split(':'))[0]+')';
               }
            }
         }
      }

      for (k=0;k<inobjs.length;k++) {
          cond='';
          if ((inobjscond[k]!='') && (typeof(inobjscond[k])!="undefined")) { 
             cond='('+inobjscond[k]+')'; 
          }
          for (k2=0;k2<outobjs.length;k2++) {
              thiscond=cond;
              if ((outobjscond[k2]!='') && (typeof(outobjscond[k2])!="undefined")) {
                 if ((thiscond!='') && (typeof(thiscond)!="undefined")) { 
                    thiscond+='&&'; 
                 }
                 thiscond+='('+outobjscond[k2]+')';
              }
              condnr=0;
              if ((thiscond!='') && (typeof(thiscond)!="undefined")) { 
                 condnr=newcondition(thiscond,'normal'); 
              }
              save(); 
              joinres(inobjs[k],outobjs[k2],condnr);
          }
      }
   }
}

// -------------------------------------------------------------- Draw an entry
function drawcell (rtype,ctype,what,cm,obj1,ej,ek,ne) {
 var bgcolor;
 var url='';
 var urlparts=new Array;
 var mime;
 var ext;
 var objref;
 var objnum;

 if ((what=='') && (ne==0)) { cm="#DDDDDD"; }
 if (ctype!=0) {
   parent.mapout.document.write('<td bgcolor='+cm+' width='+cw[ctype]+'>');
   if ((what!='') && (typeof(what)!="undefined")) {
     if ((obj1!='') && (typeof(obj1)!="undefined")) {
       objref="'"+obj1+"'";
       parent.mapout.document.write
        ('<a href="javascript:parent.code.handler('+objref
         +');" onMouseOver="parent.code.info('+objref+');">');
     } 
     if (what=='r:') {
        mime='';
        objnum=(obj1.split('&'))[1];
        if (typeof(objcont[objnum])!="undefined") {
            urlparts=objcont[objnum].split(':');
            url=urlparts[1];
            ext=urlparts[2];
            urlparts=url.split('.');
            mime=urlparts[urlparts.length-1];
            if (typeof(mime)=="undefined") { mime=''; }
            mime=mime.toLowerCase();
        }
        parent.mapout.document.write
         ('<img border="0" width="'+cw[ctype]+'" height="'+rh[1]
          +'" src="'+raticons+'resource.gif" />');
       if (zscale==3) {
        if ((mime!='') && (ext!='true')) {
           parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'left.gif" /></a><a target="preview" href="'+
           url+'.meta"><img border="0" width="20" src="'+iconpath+
           'meta.gif" /><a target="preview" href="'+url+
           '"><img border="0" width="20" src="'+iconpath+mime+'.gif" />'+
           '<img border="0" src="'+raticons+'right.gif" />');
        } else {
           parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'middle.gif" />');
        }
        parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'bottom.gif" />');
       } else {
        parent.mapout.document.write
           ('<br /><img border="0" width="'+cw[ctype]+'" height="'+rh[1]
          +'" src="'+raticons+'bottom.gif" />');
       }
     } else {
        if (what=='c:') {
           parent.mapout.document.write
            ('<img border="0" width="'+cw[ctype]+'" height="'+rh[rtype]
             +'" src="'+raticons+'condition.gif" />');
        } else {
           if (what=='rs:') {
        mime='';
        objnum=(obj1.split('&'))[1];
        if (typeof(objcont[objnum])!="undefined") {
            urlparts=objcont[objnum].split(':');
            url=urlparts[1];
            ext=urlparts[2];
            urlparts=url.split('.');
            mime=urlparts[urlparts.length-1];
            if (typeof(mime)=="undefined") { mime=''; }
            mime=mime.toLowerCase();
        }
              parent.mapout.document.write
               ('<img border="0" width="'+cw[ctype]+'" height="'+rh[1]
               +'" src="'+raticons+'start.gif" />');
       if (zscale==3) {
        if ((mime!='') && (ext!='true')) {
           parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'left.gif" /></a><a target="preview" href="'+
           url+'.meta"><img border="0" width="20" src="'+iconpath+
           'meta.gif" /><a target="preview" href="'+url+
           '"><img border="0" width="20" src="'+iconpath+mime+'.gif" />'+
           '<img border="0" src="'+raticons+'right.gif" />');
        } else {
           parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'middle.gif" />');
        }
        parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'bottom.gif" />');
       } else {
        parent.mapout.document.write
           ('<br /><img border="0"  width="'+cw[ctype]+'" height="'+rh[1]
          +'" src="'+raticons+'bottom.gif" />');
       }

           } else {
             if (what=='rf:') {
        mime='';
        objnum=(obj1.split('&'))[1];
        if (typeof(objcont[objnum])!="undefined") {
            urlparts=objcont[objnum].split(':');
            url=urlparts[1];
            ext=urlparts[2];
            urlparts=url.split('.');
            mime=urlparts[urlparts.length-1];
            if (typeof(mime)=="undefined") { mime=''; }
            mime=mime.toLowerCase();
        }
                parent.mapout.document.write
                ('<img border="0" width="'+cw[ctype]+'" height="'+rh[1]
                +'" src="'+raticons+'finish.gif" />');
       if (zscale==3) {
        if ((mime!='') && (ext!='true')) {
           parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'left.gif" /></a><a target="preview" href="'+
           url+'.meta"><img border="0" width="20" src="'+iconpath+
           'meta.gif" /><a target="preview" href="'+url+
           '"><img border="0" width="20" src="'+iconpath+mime+'.gif" />'+
           '<img border="0" src="'+raticons+'right.gif" />');
        } else {
           parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'middle.gif" />');
        }
        parent.mapout.document.write
           ('<br /><img border="0" src="'+raticons+'bottom.gif" />');
       } else {
        parent.mapout.document.write
           ('<br /><img border="0"  width="'+cw[ctype]+'" height="'+rh[1]
          +'" src="'+raticons+'bottom.gif" />');
       }

             } else {
                parent.mapout.document.write
                ('<img border="0" width="'+cw[ctype]+'" height="'+rh[rtype]
                +'" src="'+raticons+rtype+'.'+ctype+'.'+what+'.gif" />');
             }
           }
        }
     }
     if ((obj1!='') && (typeof(obj1)!="undefined")) {
       parent.mapout.document.write('</a>');
     }
   } else {
      if (ne!=1) {
         parent.mapout.document.write
            ('<a href="javascript:parent.code.empty('+ej+','+ek+');" ');
      } else {
         parent.mapout.document.write
            ('<a href="javascript:parent.code.infoclear();" ');
      }
      parent.mapout.document.write
         ('onMouseOver="parent.code.infoclear();">');
      parent.mapout.document.write
         (
         '<img border="0" width="'+cw[ctype]+'" height="'+rh[rtype]
        +'" src="'+raticons+rtype+'.'+ctype+'.empty.gif" /></a>');
   }
   parent.mapout.document.write('</td>');
 }
}

// --------------------------------------------------------- Color of resources
function rescolor (ext,typ) {
   var rc; var gc; var bc;
   if (ext=='true') { bc='55'; } else { bc='99'; }
   if (typ=='mandatory') { rc='FF'; } else { rc='BB'; }
   if (typ=='optional') { gc='BB'; } else { gc='FF'; }
   if ((typ=='start') || (typ=='finish')) { rc='AA'; gc='AA'; bc='FF'; }
   return '#'+rc+gc+bc;
}

// -------------------------------------------------------- Color of conditions
function condcolor(typ) {
   if (typ=='stop')  { return '#EEAAAA'; }
   if (typ=='force') { return '#AAAAEE'; }
   return '#EEEEAA';
}

// ----------------------------------------------------------------- Draw a row
function drawrow (jid) {
var j; var jk; var k;  var ck; var rtype;
var objd1=new Array();
var objd2=new Array();
var notempty=new Array();
var condtype;
if (rowtype[jid]!=0) {
 for (j=0;j<=maxcol;j++) { 
    colmap[j]=''; colmap2[j]=''; colmap3[j]=''; colmap4[j]=''; 
    colmap5[j]='#CCCCCC'; colmap6[j]='#CCCCCC';
    objd1[j]=''; objd2[j]=''; notempty[j]=0;
 }

 parent.mapout.document.writeln('<tr height='+rh[rowtype[jid]]+'>');
 if ((rowcont[jid]!='') && (typeof(rowcont[jid])!="undefined")) {
   data2=rowcont[jid].split(':');
   for (jk=0;jk<data2.length;jk++) {
      data3=obj[data2[jk]].split('&');
      if (data3[0]=='b') {
         data1=objcont[data2[jk]].split(':');
         rtype=data1[3];
         ck=rescolor(data1[2],data1[3]);
         left=maxcol;
         leftin=maxcol;
         leftout=maxcol;
         right=0;
         rightin=0;
         rightout=0;
         anyout=0;
         for (k=2;k<data3.length;k++) {
            data1=data3[k].split(':');
            thiscol=col[data1[0]];
            if (thiscol<left)  { left=thiscol;  }
            if (thiscol>right) { right=thiscol; }
            if (data1[1]!=0) {
               if (thiscol<leftin)  { leftin=thiscol;  }
               if (thiscol>rightin) { rightin=thiscol; }
               colmap4[thiscol]=data1[1];
            }
            if (data1[2]!=0) {
               if (thiscol<leftout)  { anyout=1; leftout=thiscol;  }
               if (thiscol>rightout) { anyout=1; rightout=thiscol; }
               if (data1[3]!=0) {
                  colmap3[thiscol]='c:';
                  condtype=(objcont[data1[3]].split(':'))[1];
                  colmap6[thiscol]=condcolor(condtype);
                  objd2[thiscol]='c&'
                       +data1[0]+'&'+data2[jk]+'&'+data1[2]+'&'+data1[3];
               } else {
                  colmap3[thiscol]='ctd';
                  colmap6[thiscol]=ck;
                  objd2[thiscol]='c&'
                       +data1[0]+'&'+data2[jk]+'&'+data1[2]+'&-';
               }       
            }
         }
         for (k=left;k<=right;k++) { notempty[k]=1; colmap5[k]=ck; }
         middle=Math.round((left+right)/2);
         if (rtype=='start') {
            colmap[middle]='rs:';
         } else {
            if (rtype=='finish') {
               colmap[middle]='rf:';
            } else {
               colmap[middle]='r:';
            }
         }
         objd1[middle]+='r&'+data2[jk];

         if (rightin>middle) {
            for (k=middle+1;k<rightin;k++) { 
               if ((colmap4[k]!='') && (typeof(colmap4[k])!="undefined")) {
                  colmap[k]='rlt'; 
               } else {
                  colmap[k]='rl';
               }
            }
            colmap[rightin]='tl'; 
         }
         if (leftin<middle) {
            for (k=middle-1;k>leftin;k--) { 
               if ((colmap4[k]!='') && (typeof(colmap4[k])!="undefined")) {
                  colmap[k]='lrt'; 
               } else {
                  colmap[k]='lr';
               }
            }
            colmap[leftin]='tr'; 
         }

         if ((leftout>middle) && (anyout)) {
            colmap2[middle]='tr'; 
         }
         if (leftout==middle) {
            if (rightout==middle) { colmap2[middle]='td'; }
            if (rightout>middle)  { colmap2[middle]='rtd'; }
         }
         if (leftout<middle) {
            if (rightout<middle)  { colmap2[middle]='tl'; }
            if (rightout==middle) { colmap2[middle]='tdl'; }
            if (rightout>middle)  { 
              if ((colmap3[middle]!='') && (typeof(colmap3[middle])!="undefined")) {
                 colmap2[middle]='rtdl'; 
              } else {
                 colmap2[middle]='rtl';
              }
            }
         }
         if (leftout<middle) {
            for (k=middle-1;k>leftout;k--) { 
               if ((colmap3[k]!='') && (typeof(colmap3[k])!="undefined")) {
                  colmap2[k]='rld'; 
               } else {
                  colmap2[k]='rl';
               }
            }
            colmap2[leftout]='rd'; 
         }
         if (rightout>middle) {
            for (k=middle+1;k<rightout;k++) { 
               if ((colmap3[k]!='') && (typeof(colmap3[k])!="undefined")) {
                  colmap2[k]='lrd'; 
               } else {
                  colmap2[k]='lr';
               }
            }
            colmap2[rightout]='ld'; 
         }        
      }
      if (data3[0]=='h') {
         data4=data3[2].split(':');
         if (col[data4[1]]>col[data4[0]]) {
            left=col[data4[0]];
            right=col[data4[1]];
            thisarrow='lr';
         } else {
            right=col[data4[0]];
            left=col[data4[1]];
            thisarrow='rl';
         }
         if (data3[4].split(':')[0]==1) {
            colmap[left]='tr';
         } else {
            colmap[left]='rd'; colmap2[left]='utd'; colmap3[left]='utd';   
         }
         notempty[left]=1;
         notempty[right]=1;
         for (k=left+1;k<right;k++) { 
            notempty[k]=1;
            if (colmap[k]=='') {
               colmap[k]=thisarrow; 
               objd1[k]=data2[jk];
            } else {
               colmap[k]='tdrl';
               objd1[k]='';
            }
         }
         if (data3[4].split(':')[1]==1) {
            colmap[right]='tl';
         } else {
            colmap[right]='ld'; colmap2[right]='utd'; colmap3[right]='utd';   
         }
         objd1[left]=data2[jk];
         objd1[right]=data2[jk];
      }
      if (data3[0]=='v') { 
         left=col[data3[1]];
         if (colmap[left]=='') {
            if (data3[3]==1) { colmap[left]='dt'; } else { colmap[left]='td'; }
            objd1[left]=data2[jk]+'&'+jid;
            objd2[left]=objd1[left];
         } else {
            colmap[left]='tdrl';
            objd1[left]='';
         }
         colmap2[left]='utd'; colmap3[left]='utd';
      }
   }
   rtype=rowtype[jid];
   for (k=0;k<=maxcol;k++) {
    drawcell(rtype,coltype[rcol[k]],colmap[k],colmap5[k],objd1[k],jid,k,
             notempty[k]);
   }
   if (rowtype[jid]==2) {
      parent.mapout.document.writeln('</tr>');
      parent.mapout.document.writeln('<tr height='+rh[1]+'>');
      for (k=0;k<=maxcol;k++) {
       drawcell(1,coltype[rcol[k]],colmap2[k],colmap5[k],objd2[k],jid,k,
                notempty[k]);
      }
      parent.mapout.document.writeln('</tr>');
      parent.mapout.document.writeln('<tr height='+rh[1]+'>');
      for (k=0;k<=maxcol;k++) {
       drawcell(1,coltype[rcol[k]],colmap3[k],colmap6[k],objd2[k],jid,k,
                notempty[k]);
      }
   }     
 }
 parent.mapout.document.writeln('</tr>');
}
}

// -------------------------------------------------------------- Print message
function message(txt) {
   parent.window.status=txt;
}

// ------------------------------------------------------------- Draw the table
function draw () {
   var k; var kr;

   cleanup();
   save();

   rh[0]=0;
   rh[1]=zscale*10;
   rh[2]=zscale*20;
   cw[0]=0;
   cw[1]=zscale*10;
   cw[2]=zscale*20;

   parent.mapout.document.open('text/html','replace');
   parent.mapout.document.writeln('<html><body bgcolor="#FFFFFF">');
   
   if (tablemode==0) {
      if (graphdef=='no') { graphopt(); cleanup(); }
      for (k=0;k<=maxrow;k++) { rrow[row[k]]=k; }
      for (k=0;k<=maxcol;k++) { rcol[col[k]]=k; }
      parent.mapout.document.writeln(
       '<table cellpadding="0" cellspacing="0" border="0" rows="'
       +disrows+'" cols="'+discols+'">');
      for (kr=0;kr<=maxrow;kr++) {
        message("Generating Output Row "+kr); 
        drawrow(rrow[kr]); 
      }
   } else {
      message("Generating Table Output");
      for (k=0;k<=maxrow;k++) { rrow[row[k]]=k; }
      for (k=0;k<=maxcol;k++) { rcol[col[k]]=k; }

      parent.mapout.document.writeln( '<table>');
      if (tablemode==1) {
         tabledraw();
      } else {
         simpletabledraw();
      }
   } 

   parent.mapout.document.writeln('</table>');
   parent.mapout.document.writeln('</body></html>');
   parent.mapout.document.close();
   parent.focus();
   parent.mapout.focus();
}

// --------------------------------------------------------- Clears info window
function infoclear() {
 if (notclear!=1) {
  infcheck();
  inf.document.clear();
  inf.document.writeln
   ('<html><body bgcolor="#FFFFFF"><table><tr><td>'+
    '<img src="/adm/lonIcons/lonlogos.gif" /></td>');
  if (linkmode!=0) {
   if (tablemode==0) {
     inf.document.writeln(
      '<td><b>Link Mode</b><hr />Click on a resource to link it with<br /><b>'+
      (objcont[linkmode].split(':'))[0]+
      '</b><br />click anywhere else to cancel.</td>');
   } else {
     inf.document.writeln(
'<td><b>Link Mode</b><hr />Click on a resource number to link it with<br /><b>'+
     (objcont[linkmode].split(':'))[0]+'</b><br />'+
'<a href="javascript:opener.linkmode=0;opener.notclear=0;opener.infoclear();">'
   +'Cancel</a></td>');
   }
  } else {
   if (tablemode==0) {
      inf.document.writeln(
        '<td><b>Click to Edit</b><hr />Click in a light gray area<br />'
       +'to insert resources, columns and rows</td>'
      );
   }
  }
  inf.document.writeln('</tr></table></body></html>');
  inf.document.close();
  if (srchflag==1) {
    srchclose();
  }
  if (idxflag==1) {
    idxclose();
  }
  if (parmflag==1) {
    parmclose();
  }
  parent.top.focus();
  parent.mapout.focus();
  notclear=1;
  lastinfo='';
 }
}

// ------------------------------------------------------------ Open inf window
function infopen() {
   var options="scrollbars=1,resizable=1,menubar=0,width=400,height=300";
   inf=open("","infout",options);
}

// -------------------------------------------------------- Do inf status check
function infcheck() {
   if (inf.closed) {
      infopen();
   }
}

// --------------------------------------------------- Prints out resource info
function info(infostr) {
 var mime='';
 var ext;
 var urlparts=new Array;
 var url='';
 if ((editmode!=1) && (infostr!=lastinfo)) {
  notclear=1;
  infcheck();
  inf.document.clear();
  inf.document.writeln(
   '<html><body bgcolor="#FFFFFF">'+
   '<table><tr><td width="32"><img src="'+raticons+'info.gif" /></td><td bgcolor="#AAFFAA">');
  data1=infostr.split('&');
  if (data1[0]=='c') {
     inf.document.write('<b>Condition (');
     data3=objlinks[data1[3]].split(':');
     if (data1[4]=='-') {
        inf.document.write('not set');
     } else {
        data2=objcont[data1[4]].split(':');
        if (data2[1]=='force') {
           inf.document.write('Blocking Other Links');
        } else {
           if (data2[1]=='stop') {
              inf.document.write('Blocking This Link');
           } else {
              inf.document.write('Recommendation');
           }
       }
     }   
     inf.document.writeln(')</b><hr />From <b>'+objcont[data3[0]].split(':')[0]+
                 '</b><br />to <b>'+objcont[data3[1]].split(':')[0]+'</b>');
  } else {
     if (data1[0]=='r') {
        data2=objcont[data1[1]].split(':');
        url=data2[1];
        ext=data2[2];
        urlparts=url.split('.');
        mime=urlparts[urlparts.length-1];
        if (typeof(mime)=="undefined") { mime=''; }
        if (ext=='true') { mime=''; }
        if (mime!='') {
           inf.document.write
           ('<br /><a target="preview" align="right" href="'+url+
           '"><img border="0" width="20" src="'+iconpath+mime+'.gif" /></a>&nbsp;&nbsp;');
        }
       inf.document.write('<b>');
        if (data2[2]=='true') { inf.document.write('External '); }
        if (data2[3]=='start') {
           inf.document.writeln('<b>Start</b>');
        } else {
           if (data2[3]=='finish') {
              inf.document.writeln('<b>Finish</b>');
           } else {
              inf.document.writeln('<b>Resource</b>');
           }
        }
        if (data2[3]=='mandatory') {
           inf.document.write(' (Mandatory)');
        }
        if (data2[3]=='optional') {
           inf.document.write(' (Optional)');
        }
        inf.document.writeln('</b><hr /><b>'+data2[0]+'</b><br />');
        inf.document.writeln((data2[1].split('/')).join(' / '));
     } else {
        inf.document.writeln('<b>Link</b><hr />');
        data2=obj[data1[0]].split('&');
        data3=objlinks[data2[data2.length-2]].split(':');
        inf.document.writeln('From <b>'+objcont[data3[0]].split(':')[0]+
                 '</b><br />to <b>'+objcont[data3[1]].split(':')[0]+'</b>');
     }
  }
  if (linkmode==0) {
     inf.document.writeln('<p>(click to edit)');
  } else {
     if (data1[0]=='r') {
        inf.document.writeln('<p>(click to link)');
     } else {
        inf.document.writeln('<p>(click to cancel linking and edit)');
     }
  }
  inf.document.writeln('</td></tr></table></body></html>');
  inf.document.close();
  parent.top.focus();
  parent.mapout.focus();
  notclear=0;
  lastinfo=infostr;
 }
}

// ------------------------------------------------ "Escapes" out special chars
function escape(instring) {
   var outstring='';
   var thischar;
   var k;
   for (k=0;k<instring.length;k++) {
      thischar=instring.charAt(k);
      if (thischar==':') { thischar='&#58;'; }
      if (thischar=='"') { thischar='&#34;'; }// "
      if (thischar=="'") { thischar='&#39;'; }
      if (thischar==',') { thischar='&#44;'; }
      outstring+=thischar;
   }
   return outstring;
}

// -------------------------------------------------- Insert resource into link
function insertreslink(infostr) {
   var lnr;
   var fobj;
   var tobj;
   var nobj;
   var cobj;
   var cid;
   var rid;
   data1=infostr.split('&');
   data2=obj[data1[0]].split('&');
   lnr=data2[data2.length-2];
   data3=objlinks[lnr].split(':');
   fobj=data3[0];
   tobj=data3[1];
   cobj=data3[2];
   if (data2[0]=='v') {
      rid=data1[1];
      cid=data2[1];
   } else {
      rid=data2[1];
      cid=(data2[2].split(':'))[0];
   }
   dellink(lnr);
   newresource(rid,cid,'','','false','normal');
   nobj=obj.length-1;
   save();
   joinres(fobj,nobj,cobj);
   save();
   joinres(nobj,tobj,0);
}

// -------------------------------------------- Insert resource after condition
function insertcondlink(cid,lnr) {
   var fobj;
   var tobj;
   var nobj;
   var cobj;
   data3=objlinks[lnr].split(':');
   fobj=data3[0];
   tobj=data3[1];
   cobj=data3[2];
   rid=(obj[fobj].split('&'))[1];
   insertrow(row[rid]);
   dellink(lnr);
   newresource(maxrow,cid,'','','false','normal');
   nobj=obj.length-1;
   save();
   joinres(fobj,nobj,cobj);
   save();
   joinres(nobj,tobj,0);
}

// ------------------------------------------------------ Clears indexer window
function idxclear() {
  idx.document.clear();
}

// --------------------------------------------------------- Clears copy window
function copydxclear() {
  copydx.document.clear();
}
// ------------------------------------------------------- Clears search window
function srchclear() {
  srch.document.clear();
}

// --------------------------------------------------------- Clears parm window
function parmclear() {
  parm.document.clear();
}

// ------------------------------------------------------ Closes indexer window
function idxclose() {
  if (idx && !idx.closed) {
    idxflag=0;
    idx.close();
  }
}

// --------------------------------------------------------- Closes copy window
function copydxclose() {
  if (copydx && !copydx.closed) {
    copydxflag=0;
    copydx.close();
  }
}

// ------------------------------------------------------- Closes search window
function srchclose() {
  if (srch && !srch.closed) {
    srchflag=0;
    srch.close();
  }
}

// ------------------------------------------------------- Closes search window
function parmclose() {
  if (parm && !parm.closed) {
    parmflag=0;
    parm.close();
  }
}

// -------------------------------------------------------- Open indexer window
function idxopen(mode) {
   var options="scrollbars=1,resizable=1,menubar=0";
   idxmode=mode;
   idxflag=1;
   idx=open("/res/?launch=1&mode=rat&catalogmode="+mode,"idxout",options);
   idx.focus();
}
// -------------------------------------------------------- Open zombie window
function groupopen(url) {
   var options="scrollbars=1,resizable=1,menubar=0";
   idxmode=mode;
   idxflag=1;
   idx=open("/adm/groupsort?mode=rat&recover=1&readfile="+url,"idxout",options);
   idx.focus();
}
// ------------------------------------------------------- Open bookmark window
function bookmarkopen() {
   var options="scrollbars=1,resizable=1,menubar=0";
   idxmode=mode;
   idxflag=1;
   idx=open("/adm/groupsort?mode=rat&bookmarks=1","idxout",options);
   idx.focus();
}
// ------------------------------------------------- Open browser to select map
    var editbrowser;
    function openbrowser(formname,elementname,only,omit) {
        var url = '/res/?';
        if (editbrowser == null) {
            url += 'launch=1&';
        }
        url += 'catalogmode=interactive&';
        url += 'mode=edit&';
        url += 'form=' + formname + '&';
        if (only != null) {
            url += 'only=' + only + '&';
        } 
        if (omit != null) {
            url += 'omit=' + omit + '&';
        }
        url += 'element=' + elementname + '';
        var title = 'Browser';
        var options = 'scrollbars=1,resizable=1,menubar=0';
        options += ',width=700,height=600';
        editbrowser = copydx.open(url,title,options,'1');
        editbrowser.focus();
    }
// ----------------------------------------------------------- Open copy window
function copydxopen(mode) {
   var options="scrollbars=1,resizable=1,menubar=0";
   copydxmode=mode;
   copydxflag=1;
   copydx=open("",'copydxout',options);
   copydx.document.clear('');
   copydx.document.writeln(
 '<html><body bgcolor="#FFFFFF"><h1>Copy from Map</h1>'+
 '<form name="mapload"><input type="text" size="40" name="importmap">'+
 '<input type="button" onClick="javascript:opener.openbrowser'+
 "('mapload','importmap','sequence,page','')"+
 '" value="Browse"><input type="button" value="Load Map" '+
 'onClick="window.location=document.mapload.importmap.value+'+
 "'?launch=1&forceselect=1'"+'"></form>');

   copydx.document.writeln('</body></html>');
   copydx.focus();
}

// --------------------------------------------------------- Open search window
function srchopen(mode) {
   var options="scrollbars=1,resizable=1,menubar=0";
   srchmode=mode;
   srchflag=1;
   srch=open("/adm/searchcat?launch=1&mode=rat&catalogmode="+mode,"srchout",options);
   srch.focus();
}

// -------------------------------------------- Interface function to searching
function search() {
   alert("Searching not yet implemented");
}

// ------------------------------------------------------- Do srch status check
function srchcheck(mode) {
   if (!srch || srch.closed || srchmode!=mode) {
      srchopen(mode);
   }
   srch.focus();
}

// -------------------------------------------------------- Do idx status check
function idxcheck(mode) {
   if (!idx || idx.closed || idxmode!=mode) {
      idxopen(mode);
   }
   idx.focus();
}

// -------------------------------------------------------- Do idx status check
function copydxcheck(mode) {
   if (!copydx || copydx.closed || copydxmode!=mode) {
      copydxopen(mode);
   }
   copydx.focus();
}

// ---------------------------------------------------- Handles "click to edit"
function handler(infostr) {
  var k;
  editmode=1;
  notclear=1;
  infcheck();
  inf.document.clear();
  inf.document.writeln(
   '<html><body bgcolor="#FFFFFF">'+
   '<table><tr><td width="32"><img src="'+raticons+'edit.gif" /></td><td bgcolor="#AAFFAA">');
  data1=infostr.split('&');
  if (data1[0]=='c') {
     inf.document.writeln('<b>Condition</b><hr />');
     linkmode=0;
     if (data1[4]=='-') {
        data2[0]=''; data2[1]='normal';
     } else {
        data2=objcont[data1[4]].split(':');
     }
     inf.document.writeln(
         '<form name="condinfo"><textarea name="c" cols="30" rows="3">'
         +data2[0]+'</textarea><br /><input type="radio" name="s" value="normal" '+
    'onClick="self.document.forms.condinfo.elements.h.value='+"'normal'"+'"');
     if (data2[1]=='normal') { inf.document.write(' checked'); }
     inf.document.write(
      '> Recommendation if true<br /><input type="radio" name="s" value="stop" '+
      'onClick="self.document.forms.condinfo.elements.h.value='+"'stop'"+'"');
     if (data2[1]=='stop') { inf.document.write(' checked'); }
     inf.document.write(
      '> Blocking this link if false<br /><input type="radio" name="s" value="force" '+
      'onClick="self.document.forms.condinfo.elements.h.value='+"'force'"+'"');
     if (data2[1]=='force') { inf.document.write(' checked'); }
     inf.document.write(
   '> Blocking other links if true<br /><a href="javascript:opener.editmode=0;'
      +'opener.notclear=0;');
     if (data1[4]=='-') {
        inf.document.write('opener.crecond('+data1[2]+','+data1[1]+','
      +'opener.escape(self.document.forms.condinfo.elements.c.value),'
      +'self.document.forms.condinfo.elements.h.value);');
     } else {
        inf.document.write('opener.objcont['+data1[4]+']='
      +'opener.escape(self.document.forms.condinfo.elements.c.value)+'+"':'"
      +'+self.document.forms.condinfo.elements.h.value+'+"':cond';");
     }
     inf.document.writeln(
      'opener.infoclear();opener.editmode=0;opener.draw('
      +');"><b>Save Changes</b></a>&nbsp;&nbsp;'
    +' <a href="javascript:self.document.forms.condinfo.reset()">Reset</a><br />'
      +'<input type="hidden" name="h" value="'+data2[1]+'">');

        inf.document.writeln(
           '<a href="javascript:opener.notclear=0;opener.infoclear();'
   +'opener.delcond('+data1[2]+','+data1[1]+');opener.editmode=0;opener.draw('
         +');">Delete Condition</a><br />');
          inf.document.writeln(
           '<a href="javascript:opener.notclear=0;opener.infoclear();'
   +'opener.dellink('+data1[3]+');opener.editmode=0;opener.draw('
         +');">Delete Link</a>');

        inf.document.writeln('<br /><a href="javascript:'+
         'opener.insertcondlink('+data1[1]+','+data1[3]+');'+
         'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">Insert Resource Into Link</a>');
} else {
     if (data1[0]=='r') {
       if (linkmode!=0) {
        joinres(linkmode,data1[1],0);
        editmode=0;
        notclear=0;
        linkmode=0;
        inf.document.writeln('<b>Linked Resources</b>');
        draw();
       } else {
        data2=objcont[data1[1]].split(':');
        if (data2[3]=='start') {
           inf.document.writeln('<b>Start</b>');
        } else {
           if (data2[3]=='finish') {
              inf.document.writeln('<b>Finish</b>');
           } else {
              inf.document.writeln('<b>Resource</b>');
           }
        }
        inf.document.write(
         '<form name="resinfo"><table><tr><td>Title:</td><td colspan="2">'
        +'<input type="text" name="t" size="30" value="'
+escape(data2[0])+'"><input type="hidden" name="h" value='+data2[3]+'></td></tr>');
           inf.document.write('<tr><td>URL:</td><td colspan="2">'
        +'<input type="text" name="u" size="30" value="'+data2[1]+'"></td></tr>'
        +'<tr><td>External:</td><td><input type="checkbox" name="e"');
        if (data2[2]=='true') { inf.document.write(' checked="checked"'); }
        inf.document.write('></td><td align="right">'
        +'<a href="javascript:opener.idxcheck(\'interactive\')">Browse</a> '
        +'<a href="javascript:opener'
	+'.srchcheck(\'interactive\')">Search</a></td></tr>');
    if ((data2[3]!='start') && (data2[3]!='finish')) {
        inf.document.write('<tr><td colspan="3">'
        +'<input type="radio" name="y" value="normal" '+
 'onClick="self.document.forms.resinfo.elements.h.value='+"'normal'"+'"');
     if (data2[3]=='normal') { inf.document.write(' checked="checked"'); }
     inf.document.write(
      '> Regular&nbsp;&nbsp;<input type="radio" name="y" value="mandatory" '+
 'onClick="self.document.forms.resinfo.elements.h.value='+"'mandatory'"+'"');
     if (data2[3]=='mandatory') { inf.document.write(' checked="checked"'); }
     inf.document.write(
      '> Mandatory&nbsp;&nbsp;<input type="radio" name="y" value="optional" '+
 'onClick="self.document.forms.resinfo.elements.h.value='+"'optional'"+'"');
     if (data2[3]=='optional') { inf.document.write(' checked="checked"'); }
     inf.document.write('> Optional</td></tr>');
    } 
        inf.document.writeln(
         '<tr><td colspan="3"><a href="javascript:opener.editmode=0;'
        +'opener.notclear=0;opener.objcont['+data1[1]
        +']=opener.escape(self.document.forms.resinfo.elements.t.value)+'+"':'"
        +'+opener.escape(self.document.forms.resinfo.elements.u.value)+'+"':'"
        +'+self.document.forms.resinfo.elements.e.checked+'+"':'"
        +'+self.document.forms.resinfo.elements.h.value+'+"':res'"
        +';opener.infoclear();opener.editmode=0;opener.draw();">'
        +'<b>Save Changes</b></a>&nbsp;&nbsp;'
        +' <a href="javascript:self.document.forms.resinfo.reset()">Reset</a>'
        +'</td></tr></table>');
    if ((data2[3]!='start') && (data2[3]!='finish')) {
        inf.document.writeln(
           '<a href="javascript:opener.notclear=0;opener.infoclear();'
         +'opener.delres('+data1[1]+',0);opener.editmode=0;opener.draw('
         +');">Delete Resource (cutting links)</a>');
        inf.document.writeln(
          '<br /><a href="javascript:opener.notclear=0;opener.infoclear();'
         +'opener.delres('+data1[1]+',1);opener.editmode=0;opener.draw('
         +');">Delete Resource (preserving links)</a>');
    }
    if (data2[3]!='finish') {
        inf.document.writeln(
          '<br /><a href="javascript:opener.editmode=0;opener.notclear=0;'
         +'opener.linkmode='+data1[1]+';'
         +'opener.infoclear();">Link Resource</a>');
    }
        inf.document.writeln(
          '<br /><a href="javascript:'
         +'opener.setparms('+data1[1]+');'
         +'opener.infoclear();">Set Parameters</a>');
    
      }
     } else {
        linkmode=0;
        inf.document.writeln('<b>Link</b><hr /><form>');
        data2=obj[data1[0]].split('&');
        k=data2[data2.length-2];
        data3=objlinks[k].split(':');
        inf.document.writeln('From <b>'+objcont[data3[0]].split(':')[0]+
              '</b><br />to <b>'+objcont[data3[1]].split(':')[0]+'</b>');
        inf.document.writeln('<br /><a href="javascript:opener.dellink('+
     k+');opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">Delete Link</a>');
        inf.document.writeln('<br /><a href="javascript:'+
         "opener.insertreslink('"+infostr+"');"+
         'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">Insert Resource Into Link</a>');
     }
  }
  inf.document.writeln(
     '<br /><a href="javascript:opener.editmode=0;opener.notclear=0;'
     +'opener.infoclear();">Cancel</a>');
  inf.document.writeln('</form></td></tr></table></body></html>');
  inf.document.close();
  inf.focus();
}

// ----------------------------------------------------- Clicks on empty fields
function empty(rid,k) {
  var cid=findcol(k);
  var lcol=k-1;
  trow=row[rid];
  lrow=trow-1;
  editmode=1;
  notclear=1;
  linkmode=0;
  infcheck();
  inf.document.clear();
  inf.document.writeln(
   '<html><body bgcolor="#FFFFFF">'+
   '<table><tr><td width="32"><img src="'+raticons+'edit.gif" /></td><td bgcolor="#AAFFAA">'+
   '<b>Empty Field</b><hr />');

        inf.document.writeln('<br /><a href="javascript:opener.newresource('+
          rid+','+cid+",'','','false','normal');"+
         'opener.mostrecent=opener.obj.length-1;'+
         'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
          +');">Insert resource</a>');

  if ((mostrecent!=0) && (objcont[mostrecent]!='') && 
                         (typeof(objcont[mostrecent])!="undefined")) {

        inf.document.writeln('<br /><a href="javascript:opener.newresource('+
          rid+','+cid+",'','','false','normal');"+
         'opener.mostrecent=opener.obj.length-1;'+
        'opener.joinres('+mostrecent+',opener.obj.length-1,0);'+
  'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
          +');">Insert resource linked to from most recent one</a>');

        inf.document.writeln('<br /><a href="javascript:opener.newresource('+
          rid+','+cid+",'','','false','normal');"+
         'opener.mostrecent=opener.obj.length-1;'+
        'opener.joinres(opener.obj.length-1,'+mostrecent+',0);'+
  'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
          +');">Insert resource linking to most recent one</a>');
  }


  inf.document.writeln('<hr />Insert column:');
        inf.document.writeln('<a href="javascript:opener.insertcol('+
        lcol+');opener.addobj('+rid+",'e&'+opener.maxcol);"
       +'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">left</a>');
        inf.document.writeln('<a href="javascript:opener.insertcol('+
        k+');opener.addobj('+rid+",'e&'+opener.maxcol);"
       +'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">right</a> ');
   inf.document.writeln('<br />Insert row:');
        inf.document.writeln('<a href="javascript:opener.insertrow('+
        trow+');opener.addobj(opener.maxrow'+",'e&"+cid+"');"
       +'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">below</a>');
        inf.document.writeln('<a href="javascript:opener.insertrow('+
        lrow+');opener.addobj(opener.maxrow'+",'e&"+cid+"');"
       +'opener.editmode=0;opener.notclear=0;opener.infoclear();opener.draw('
                              +');">above</a> ');


  inf.document.writeln(
   '<br /><a href="javascript:opener.editmode=0;opener.notclear=0;'
  +'opener.infoclear();">Cancel</a>');
  inf.document.writeln('</td></tr></table></body></html>');
  inf.document.close();
  inf.focus();
}

// ---------------------------------------------------- Save into hidden fields
function save() {
  var k;
  if (graphdef=='yes') {
   parent.server.document.forms.storage.output.value='graphdef<:>yes';
   for (k=1;k<obj.length;k++) {
         parent.server.document.forms.storage.output.value+=
          '<&>obj<:>'+k+'<:>'+obj[k];
   }
   for (k=0;k<row.length;k++) {
         parent.server.document.forms.storage.output.value+=
          '<&>row<:>'+k+'<:>'+row[k];
   }
   for (k=0;k<col.length;k++) {
         parent.server.document.forms.storage.output.value+=
          '<&>col<:>'+k+'<:>'+col[k];
   }
   for (k=0;k<rowcont.length;k++) {
      if (rowcont[k]) {
         parent.server.document.forms.storage.output.value+=
          '<&>rowcont<:>'+k+'<:>'+rowcont[k];
      }
   }
   parent.server.document.forms.storage.output.value+=
      '<&>maxcol<:>'+maxcol; 
   parent.server.document.forms.storage.output.value+=
      '<&>maxrow<:>'+maxrow;
    parent.server.document.forms.storage.output.value+=
      '<&>zscale<:>'+zscale;
} else {
   parent.server.document.forms.storage.output.value='graphdef<:>no';
 }
 parent.server.document.forms.storage.output.value+=
   '<&>tablemode<:>'+tablemode;
      
   for (k=0;k<objparms.length;k++) {
      if (objparms[k]) {
         parent.server.document.forms.storage.output.value+=
          '<&>objparms<:>'+k+'<:>'+objparms[k];
      }
   }  
   for (k=0;k<objcont.length;k++) {
      if (objcont[k]) {
         parent.server.document.forms.storage.output.value+=
          '<&>objcont<:>'+k+'<:>'+objcont[k];
      }
   }
   for (k=0;k<objlinks.length;k++) {
      if (objlinks[k]) {
         parent.server.document.forms.storage.output.value+=
          '<&>objlinks<:>'+k+'<:>'+objlinks[k];
      }
   }
   undopointer++;
   undostack[undopointer]=
    parent.server.document.forms.storage.output.value;
}

// ----------------------------------------------- Reset all layout information
function graphreset() {

   var k;

   for (k=0;k<obj.length;k++) { obj[k]=''; }
   obj.length=0;
   obj[0]='';

   rowcont.length=0;
   rowcont[0]='';

   row.length=0;
   row[0]=0;
   maxrow=0;

   col.length=0;
   colmap.length=0;
   maxcol=-1;
   insertcol(-1);

   objcont[0]='';
   objlinks[0]='';

   graphdef='no';

}

// --------------------- Compare two resources with each other for "straighten"
function rescompare(a,b) {
   data1=a.split(':');
   data2=b.split(':');
   var rvalue=0;
   var k;
   for (k=1;k<data1.length;k++) {
      if (data1[k]==data2[0]) { rvalue--; }
   }
   for (k=1;k<data2.length;k++) {
      if (data2[k]==data1[0]) { rvalue++; }
   }
   if (rvalue==0) { rvalue=data2.length-data1.length; }
   return rvalue;
}

// -------------------------------------------- Draw the table instead of graph
function tabledraw() {
  var objsorted=new Array();
  var robjs=new Array();
  var iobjs=new Array();
  var k;
  var i;
  var j;
  var nr;
  var ck;
  var cck;
  var condid;
  var url='';
  var mime='';
  var ext='';
  var urlparts=new Array;
  var sortstr=sortobjs();
 insrestab(1,-1,-1,'');
 if ((sortstr!='') && (typeof(sortstr)!="undefined")) {
  objsorted=sortstr.split('&');
  for (k=0;k<objsorted.length;k++) {
     i=(objsorted[k].split(':'))[0];
     iobjs[k]=i;
     robjs[i]=k;
  }
  for (k=0;k<iobjs.length;k++) {
       i=iobjs[k];
       if (k<objsorted.length-1) {
          nr=iobjs[k+1];
       } else {
          nr=-1;
       }
       data1=objcont[i].split(':');
       ck=rescolor(data1[2],data1[3]);
        parent.mapout.document.write('<tr><td bgcolor="'+ck+'">');
        url=data1[1];
        ext=data1[2];
        urlparts=url.split('.');
        mime=urlparts[urlparts.length-1];
        if (typeof(mime)=="undefined") { mime=''; }
        if ((mime!='') && (ext!='true')) {
           parent.mapout.document.write
           ('<a target="preview" align="right" href="'+url+'.meta'+
           '"><img width="20" src="'+iconpath+'meta.gif" /></a><p>'+
           '<a target="preview" align="right"href="'+url+
           '"><img width="20" src="'+iconpath+mime+'.gif" /></a><p>');
        }
         parent.mapout.document.write(
         '<b><a href="javascript:if (parent.code.linkmode!=0) { '
        +'parent.code.joinres(parent.code.linkmode,'+i+',0);'
        +'parent.code.linkmode=0;parent.code.editmode=0;'
        +'parent.code.notclear=0;parent.code.infoclear();'
        +'parent.code.draw(); }">'+k+'</a></b></td><td bgcolor="'+ck
        +'"><form name="r'+i+'" method="post">');
      data2=obj[i].split('&');
      parent.mapout.document.write('<table bgcolor="#CCCCCC">');

      if (data1[3]=='start') { 
         parent.mapout.document.writeln('<tr><td><b>Start</b></td></tr>');
      }
      if (data1[3]=='finish') { 
         parent.mapout.document.writeln('<tr><td><b>Finish</b></td></tr>');
      }
      parent.mapout.document.write(
       '<tr><td>Title:</td><td><input type="text" name="t" size="50" value="'
            +data1[0]+'"><input type="hidden" name="h" value="'+data1[3]
            +'"></td></tr>');
      parent.mapout.document.write(
       '<tr><td>URL:</td><td><input type="text" name="u" size="50" value="'
                                  +data1[1]+'"></td></tr>'
          +'<tr><td>External:</td><td><input type="checkbox" name="e"');
        if (data1[2]=='true') { parent.mapout.document.write(' checked="checked"'); }
        parent.mapout.document.write('></td></tr>');
    if ((data1[3]!='start') && (data1[3]!='finish')) {
        parent.mapout.document.write(
        '<tr><td colspan="2"><input type="radio" name="y" value="normal" '+
 'onClick="parent.mapout.document.forms.r'+i+'.elements.h.value='+
     "'normal'"+'"');
     if (data1[3]=='normal') { parent.mapout.document.write(' checked="checked"'); }
     parent.mapout.document.write(
      '> Regular&nbsp;&nbsp;<input type="radio" name="y" value="mandatory" '+
 'onClick="parent.mapout.document.forms.r'+i+'.elements.h.value='+
     "'mandatory'"+'"');
     if (data1[3]=='mandatory') { parent.mapout.document.write(' checked="checked"'); }
     parent.mapout.document.write(
      '> Mandatory&nbsp;&nbsp;<input type="radio" name="y" value="optional" '+
 'onClick="parent.mapout.document.forms.r'+i+'.elements.h.value='+
     "'optional'"+'"');
     if (data1[3]=='optional') { parent.mapout.document.write(' checked="checked"'); }
     parent.mapout.document.write('> Optional</td></tr>');
    } 
     parent.mapout.document.write(
         '<tr><td colspan="2"><a href="javascript:parent.code.objcont['+i        
        +']=parent.code.escape(parent.mapout.document.forms.r'+i
        +'.elements.t.value)+'+"':'"
        +'+parent.code.escape(parent.mapout.document.forms.r'+i
        +'.elements.u.value)+'+"':'"
        +'+parent.mapout.document.forms.r'+i+'.elements.e.checked+'+"':'"
        +'+parent.mapout.document.forms.r'+i+'.elements.h.value+'+"':res'"
        +';parent.code.draw();">'
        +'<b>Save Changes</b></a>&nbsp;&nbsp;'
        +' <a href="javascript:parent.mapout.document.forms.r'+i
        +'.reset()">Reset</a></td></tr><tr><td colspan="2">');
    if ((data1[3]!='start') && (data1[3]!='finish')) {
     parent.mapout.document.writeln(
 '<a href="javascript:parent.code.notclear=0;parent.code.infoclear();'
+'parent.code.delres('+i+',0);parent.code.editmode=0;parent.code.draw();">'
+'Delete Resource (cutting links)</a><br />'
+'<a href="javascript:parent.code.notclear=0;parent.code.infoclear();'
+'parent.code.delres('+i+',1);parent.code.editmode=0;parent.code.draw();">'
+'Delete Resource (preserving links)</a><br />');
    }
    if (data1[3]!='finish') {
       parent.mapout.document.writeln(
        '<a href="javascript:parent.code.linkmode='+i+
       ';parent.code.notclear=0;parent.code.infoclear();">'+
       'Link resource</a>');
    }
        parent.mapout.document.writeln(
          '<br /><a href="javascript:'
         +'parent.code.setparms('+i+');">Set Parameters</a>');

      parent.mapout.document.writeln('</td></tr>');
       parent.mapout.document.writeln('<tr><td colspan="2"><table><tr>');
       for (j=2;j<data2.length;j++) {
           data4=data2[j].split(':');
           data3=objlinks[data4[2]].split(':');
           if (data3.length>1) {
              if (data3[1]==nr) {
                 cck='#AAAAAA';
                 if (data3[2]!=0) { 
                   cck=condcolor((objcont[data3[2]].split(':'))[1]);
                   condid=data3[2];
                 } else {
                   condid='-';
                 }                 
                 parent.mapout.document.writeln(
                  '<td bgcolor="'+cck+'">Next<br />');
                 parent.mapout.document.writeln(
                  '<a href="javascript:parent.code.handler('+
                  "'c&"+data4[0]+'&'+i+'&'+data4[2]+'&'+condid+"');"
                  +'">Edit</a>');
                 parent.mapout.document.writeln('</td>');
              }
           }
       }
       for (j=2;j<data2.length;j++) {
           data4=data2[j].split(':');
           data3=objlinks[data4[2]].split(':');
           if (data3.length>1) {
              if ((data3[1]!=nr) && (data3[1]!=0)) {
                 cck='#AAAAAA';
                 if (data3[2]!=0) { 
                   cck=condcolor((objcont[data3[2]].split(':'))[1]);
                   condid=data3[2];
                 } else {
                   condid='-';
                 }
                 parent.mapout.document.writeln(
                  '<td bgcolor="'+cck+'">To: '+robjs[data3[1]]+'<br />');
                 parent.mapout.document.writeln(
                  '<a href="javascript:parent.code.handler('+
                  "'c&"+data4[0]+'&'+i+'&'+data4[2]+'&'+condid+"');"
                  +'">Edit</a>');
                 parent.mapout.document.writeln('</td>');
              }
           }
       }
       parent.mapout.document.writeln(
        '</tr></table></td></tr></table></form>');
       insrestab(rrow[data2[1]],i,nr,data1[3]);

   }
  }
}

// ----------------------------------------------------- Insert Resource Output
function insrestab(irow,be,af,typ) {
  parent.mapout.document.writeln('<tr><td colspan="2">'+
       '<table><tr><td><a href="javascript:parent.code.insertrow('
       +irow+');parent.code.newresource(parent.code.maxrow,'+rcol[1]
 +",'','','false','normal');parent.code.mostrecent=parent.code.obj.length-1;"
       +'parent.code.draw();">'
       +'Insert resource</a></td><td>');
  if ((be!=-1) && (typ!='finish')) {
   parent.mapout.document.writeln(
       '<a href="javascript:parent.code.insertrow('
       +irow+');parent.code.newresource(parent.code.maxrow,'+rcol[0]
 +",'','','false','normal');parent.code.mostrecent=parent.code.obj.length-1;"
       +"parent.code.save();"
       +'parent.code.joinres('+be+',parent.code.mostrecent,0);'
       +'parent.code.draw();">'
       +'Insert resource linked to from above</a><br />');
  }
  if ((be!=-1) && (af!=-1) && (typ!='finish')) {
     parent.mapout.document.writeln(
       '<a href="javascript:parent.code.insertrow('
       +irow+');parent.code.newresource(parent.code.maxrow,'+rcol[0]
 +",'','','false','normal');parent.code.mostrecent=parent.code.obj.length-1;"
       +"parent.code.save();"
       +'parent.code.joinres('+be+',parent.code.mostrecent,0);'
       +"parent.code.save();"
       +'parent.code.joinres(parent.code.mostrecent,'+af+',0);'
       +'parent.code.draw();">'
       +'Insert resource linked to from above and linking to below</a><br />');
  }
  if (af!=-1) {
     parent.mapout.document.writeln(
       '<a href="javascript:parent.code.insertrow('
       +irow+');parent.code.newresource(parent.code.maxrow,'+rcol[0]
 +",'','','false','normal');parent.code.mostrecent=parent.code.obj.length-1;"
       +"parent.code.save();"
       +'parent.code.joinres(parent.code.mostrecent,'+af+',0);'
       +'parent.code.draw();">'
       +'Insert resource linking to below</a><br />');
  }
  parent.mapout.document.writeln('</td></tr></table></tr>');
}

// ---------------------------------------- Draw simple table instead of graph
function simpletabledraw() {
  var objsorted=new Array();
  var robjs=new Array();
  var iobjs=new Array();
  var k;
  var i;
  var j;
  var nr;
  var ck;
  var cck;
  var mime;
  var ext;
  var url;
  var urlparts=new Array;
  var condid;
  var sortstr=sortobjs();
 if ((sortstr!='') && (typeof(sortstr)!="undefined")) {
  objsorted=sortstr.split('&');
  for (k=0;k<objsorted.length;k++) {
     i=(objsorted[k].split(':'))[0];
     iobjs[k]=i;
     robjs[i]=k;
  }
  for (k=0;k<iobjs.length;k++) {
       i=iobjs[k];
       if (k<objsorted.length-1) {
          nr=iobjs[k+1];
       } else {
          nr=-1;
       }
       data1=objcont[i].split(':');
       ck=rescolor(data1[2],data1[3]);
        parent.mapout.document.write('<tr><td bgcolor="'+ck+'">');
        url=data1[1];
        ext=data1[2];
        urlparts=url.split('.');
        mime=urlparts[urlparts.length-1];
        if (typeof(mime)=="undefined") { mime=''; }
        if ((mime!='') && (ext!='true')) {
           parent.mapout.document.write
           ('<a target="preview" align="right" href="'+url+'.meta'+
           '"><img width="20" src="'+iconpath+'meta.gif" /></a><p>'+
           '<a target="preview" align="right"href="'+url+
           '"><img width="20" src="'+iconpath+mime+'.gif" /></a><p>');
        }        
      parent.mapout.document.write('<b>'+k+'</b></td><td bgcolor="'+ck+'">');
      data2=obj[i].split('&');
      parent.mapout.document.write('<table>');

      if (data1[3]=='start') { 
         parent.mapout.document.writeln('<tr><td><b>Start</b></td></tr>');
      }
      if (data1[3]=='finish') { 
         parent.mapout.document.writeln('<tr><td><b>Finish</b></td></tr>');
      }
      parent.mapout.document.write(
       '<tr><td>Title:</td><td>'+data1[0]+'</td></tr>');
      parent.mapout.document.write(
       '<tr><td>URL:</td><td>'+data1[1]+'</td></tr>'
      +'<tr><td colspan="2"><table><tr>');
       for (j=2;j<data2.length;j++) {
           data4=data2[j].split(':');
           data3=objlinks[data4[2]].split(':');
           if (data3.length>1) {
              if (data3[1]==nr) {
                 cck='#AAAAAA';
                 if (data3[2]!=0) { 
                   cck=condcolor((objcont[data3[2]].split(':'))[1]);
                   condid=data3[2];
                 } else {
                   condid='-';
                 }                 
                 parent.mapout.document.writeln(
                  '<td bgcolor='+cck+'>Next<br />');
                  parent.mapout.document.writeln('</td>');
              }
           }
       }
       for (j=2;j<data2.length;j++) {
           data4=data2[j].split(':');
           data3=objlinks[data4[2]].split(':');
           if (data3.length>1) {
              if ((data3[1]!=nr) && (data3[1]!=0)) {
                 cck='#AAAAAA';
                 if (data3[2]!=0) { 
                   cck=condcolor((objcont[data3[2]].split(':'))[1]);
                   condid=data3[2];
                 } else {
                   condid='-';
                 }
                 parent.mapout.document.writeln(
                  '<td bgcolor="'+cck+'">To: '+robjs[data3[1]]+'<br />');
                 parent.mapout.document.writeln('</td>');
              }
           }
       }
       parent.mapout.document.writeln('</tr></table></td></tr></table></tr>');
   }
  } else {
    parent.mapout.document.writeln('<tr><td>No Resources</td></tr>');
  }
}

// ---------------------------------- Sort objects to straighten graph or table
function sortobjs() {
   message("Sorting Resources: "+funny);
   var k;
   var ij;
   var dol;
   var dtl;
   var kj;
   var sortthis=0;
   var objsort=new Array();
   for (k=1;k<objcont.length;k++) {
      if (objcont[k]) {
         data1=objcont[k].split(':');
         if (data1[data1.length-1]=='res') {
            objsort[objsort.length]=''+k;
         }
      }
   }
   if (objsort.length==0) { return ''; }
   for (k=1;k<objlinks.length;k++) {
     wheelswitch();
     message("Sorting Resources: "+funny);
     if ((typeof(objlinks[k])!="undefined") && (objlinks[k]!='')) {
      sortthis=1;
      data1=objlinks[k].split(':');
      kj=-1;
      for (j=0;j<objsort.length;j++) {
         if ((objsort[j].split(':'))[0]==data1[0]) {
            kj=j;
         }
      }
      if (kj!=-1) { objsort[kj]+=':'+data1[1]; }
     }
   }
   if (sortthis!=0) {
    for (k=0;k<objsort.length;k++) {
      wheelswitch();
      message("Sorting Resources: "+funny);
      for (j=0;j<objsort.length;j++) {
        if (k!=j) {
          data1=objsort[k].split(':');
          data2=objsort[j].split(':');
          dol=data1.length;
          dtl=data2.length;
          if (dol+dtl<200) {
           for (kj=1;kj<dol;kj++) {
             if (data1[kj]==data2[0]) {
                for (ij=1;ij<dtl;ij++) {
                   data1[data1.length]=data2[ij];
                }
             }
           }
           for (kj=1;kj<dtl;kj++) {
             if (data2[kj]==data1[0]) {
                 for (ij=1;ij<dol;ij++) {
                    data2[data2.length]=data1[ij];
                 }
             }
           }
           objsort[k]=data1.join(':');
           objsort[j]=data2.join(':');
          }
         }
      } 
   }
   message("Sorting Resources: finishing up.");
   return objsort.sort(rescompare).join('&');
  } else {
   return objsort.join('&');
  }
}

// ----------------------------------------------------------- Straighten graph
function graphopt() {
  var k;
  var kj;
  var ij;
  var objsorted=new Array();
  condense(); 
  graphreset();
  objsorted=(sortobjs()).split('&');
  if (objsorted.length==0) { return; }
   message("Creating Optimized Graph");
   var thisnewobj=''+(objsorted[0].split(':'))[0];
   rowcont[1]=thisnewobj;
   var thiscolmax=1;
   obj[thisnewobj]='b&1&'+thiscolmax+':0:0:0';   
   var allcolmax=0;
   for (k=1;k<objsorted.length;k++) {
      thisnewobj=(objsorted[k].split(':'))[0];
      if (rescompare(objsorted[k-1],objsorted[k])==0) {
         rowcont[rowcont.length-1]+=':'+thisnewobj;
         thiscolmax++;
      } else {
         rowcont[rowcont.length]=thisnewobj;
         thiscolmax=1;
      }
      kj=rowcont.length-1;
      obj[thisnewobj]='b&'+kj+'&'+thiscolmax+':0:0:0';
      if (thiscolmax>allcolmax) { allcolmax=thiscolmax; }
   }
   for (k=0;k<obj.length;k++) {
       if (!obj[k]) { obj[k]=''; }
   }
   for (k=0;k<=allcolmax;k++) { insertcol(0); }
   for (k=0;k<rowcont.length;k++) { 
      row[k]=k;
   }
   maxrow=rowcont.length-1;
   var oldlinks=new Array();
   for (k=0;k<objlinks.length;k++) { 
      oldlinks[k]=objlinks[k]; 
      objlinks[k]='';
   }
   objlinks.length=0;
   objlinks[0]='';
   graphdef='yes';
   save();

   for (k=0;k<objsorted.length;k++) {
     wheelswitch();
     message("Connecting Resources: "+funny);
     kj=(objsorted[k].split(':'))[0];
      for (ij=1;ij<oldlinks.length;ij++) {
        if (oldlinks[ij]) {
          data1=oldlinks[ij].split(':');
          if (data1[0]==kj) {
             joinres(data1[0],data1[1],data1[2]);
             save();
          }
         }
      }
   }
}

// ----------------------------------------------------------- Remove e-objects
function condense() {
   message("Condensing");
   var j;
   for (j=0;j<=maxrow;j++) {
     if ((rowcont[j]!='') && (typeof(rowcont[j])!="undefined")) {
      data1=rowcont[j].split(':');
      rowcont[j]='';
      for (k=0;k<data1.length;k++) {
         if (obj[data1[k]].substring(0,2)!='e&') {
            if ((rowcont[j]!='') && (typeof(rowcont[j])!="undefined")) { 
               rowcont[j]+=':'; 
            }
            rowcont[j]+=data1[k];
         }
      }
     }
   }
}

// ---------------------------------------------------- Load from hidden fields
function load() {
   message("Loading");
   schedule('load');
}

function finishload() {
   var k;
   for (k=0;k<objcont.length;k++) { objcont[k]=''; }
   objcont.length=0;
   for (k=0;k<objlinks.length;k++) { objlinks[k]=''; }
   objlinks.length=0;
   for (k=0;k<objparms.length;k++) { objparms[k]=''; }
   objparms.length=0;
   objlinks[0]='';
   objcont[0]='';
   editmode=0;
   notclear=0;
   lastinfo='';
   graphreset();
   var inputstr=parent.server.document.forms.storage.output.value;
   if ((inputstr!='') && (typeof(inputstr)!="undefined")) {
   data1=inputstr.split('<&>');
   var k;
   for (k=0;k<data1.length;k++) {
       data2=data1[k].split('&colon;').join('&#58;').split('<:>');
       if (data2[0]=='graphdef') { graphdef=data2[1]; }
       if (data2[0]=='maxcol') { maxcol=1*data2[1]; }
       if (data2[0]=='maxrow') { maxrow=1*data2[1]; }
       if (data2[0]=='obj') { obj[data2[1]]=data2[2]; }
       if (data2[0]=='objcont') { objcont[data2[1]]=data2[2]; }
       if (data2[0]=='objlinks') { objlinks[data2[1]]=data2[2]; }
       if (data2[0]=='objparms') {
          if (typeof(objparms[data2[1]])=="undefined") {
             objparms[data2[1]]=data2[2];
          } else {
             if (objparms[data2[2]]=='') {
                 objparms[data2[1]]=data2[2];
             } else {
                 objparms[data2[1]]+=':'+data2[2];
             }
          }
       }
       if (data2[0]=='rowcont') { rowcont[data2[1]]=data2[2]; }
       if (data2[0]=='row') { row[data2[1]]=1*data2[2]; }
       if (data2[0]=='col') { col[data2[1]]=1*data2[2]; }
       if (data2[0]=='mode') { mode=data2[1]; }
       if (data2[0]=='tablemode') { tablemode=1*data2[1]; }
       if (data2[0]=='zscale') { zscale=1*data2[1]; }
   }
  }
  if (graphdef=='yes') {
     for (k=1;k<=maxrow;k++) {
        if (typeof(rowcont[k])=="undefined") { rowcont[k]=''; }
     }
  } else {
   var hasstart=0;
   var hasfinish=0;
   for (k=0;k<objcont.length;k++) {
       if (typeof(objcont[k])!="undefined") {
          var objfunctype=(objcont[k].split(':'))[3];
          if (objfunctype=='start') { hasstart=1; }
          if (objfunctype=='finish') { hasfinish=1; }
       }       
   }
   if (!hasstart) {
      if ((typeof(objcont[1])=="undefined") || (objcont[1]=='')) {
         objcont[1]='Start::false:start:res';
      }
   } 
   if (!hasfinish) {
      if ((typeof(objcont[2])=="undefined") || (objcont[2]=='')) {
         objcont[2]='Finish::false:finish:res';
      }
   }
  }
}

// -------------------------------------------------------------- Parameter set
function setparms(resid) {
   var options="scrollbars=1,resizable=1,menubar=0";
   parmflag=1;
   data1=objcont[resid].split(':');
   parm=open("/adm/ratparms?url="+data1[1]+"&parms="+objparms[resid]+
             "&resid="+resid,"parmout",options);
   parm.focus();
}

// -------------------------------------------------------------- Undo function
function undo() {
   if (undopointer>1) {
      undopointer--;
      parent.server.document.forms.storage.output.value
       =undostack[undopointer];
      finishload();
      undopointer--;
      draw();
      stored=0;
   } else {
      alert("Cannot undo: reached beginning of edit session");
   }
}

// -------------------------------------------------------------- Redo function
function redo() {
   if (undopointer<undostack.length-1) {
      undopointer++;
      parent.server.document.forms.storage.output.value
       =undostack[undopointer];
      finishload();
      undopointer--;
      draw();
      stored=0;
   } else {
      alert("Cannot redo: reached end of edit session");
   }
}
 
// ------------------------------------------------------------ Revert function
function revert() {
   if (confirm("Revert to beginning of edit session?")) {
      undopointer=2;
      undo();
   }
}

// ---------------------------------------------------------------- Wheelswitch
function wheelswitch() {
   if (funny=='|') { 
      funny='/'; 
   } else {
      if (funny=='/') {
         funny='-';
      } else {
         if (funny=='-') { 
            funny='\\'; 
         } else {
            if (funny=='\\') { funny='|'; }
         }
      }
   } 
}

// --------------------------------------------- Checks if server frame defined
function checkdef() {
   if (parent.flag==1) {
     srvloaded();
   }
   if ((finishdone==0) && (tim==0)) { setTimeout('checkdef()',100); }
}

// ---------------------------------------------------------- The wait function
function wait() {
   if ((finishdone==1) || (tim==1)) {
      if (tim==0) {
         clearTimeout(canceltim);
         if (reqaction=='save') { finishsave(); }
         if (reqaction=='load') { finishload(); draw(); }
      } else {
         alert("Server Communication Timed Out.");
      }
   } else {
      wheelswitch();
      message('Waiting for server reply: '+funny);
      setTimeout('wait();',100);
   }
}

// ---------------------------------------------------------- Schedule function
function schedule(action) {
   reqaction=action;
   tim=0;
   finishdone=0;
   canceltim=setTimeout('tim=1;',20000);
   checkdef();
   wait();
}

// ----------------------------------------------------- launch indexer browser
function groupsearch() {
   srchcheck('import');
}

function groupimport() {
   idxcheck('import');
}

function groupcopy() {
   copydxcheck('import');
}

// -------------------------------------------------------------- Store changes
function storechange() {
   var k;
   parent.flag=0;
   parent.server.document.forms.storage.submit();
   schedule('save');
}

function finishsave() {
   finishload();
   draw();
   stored=1;
}

// --------------------------------------- Gets called when submission finished
function srvloaded() {
   finishdone=1;
   message("Server replied.");
}

// ---------------------------------------------------------------- Toggle Mode
function togglemode() {
   if (tablemode==0) { 
      tablemode=1; 
   } else {
      if (tablemode==1) { 
         tablemode=2; 
      } else {
         tablemode=0; 
      } 
   } 
   notclear=0;
   infoclear();
   draw();
}

// -------------------------------------------------------- Main program onLoad
function main() {
   if (mainrun==0) {
      infopen();
      infoclear();
      load();
      stored=1;
      mainrun=1;
   }
}

// ---------------------------------------------------------- Close the window?
function leave() {
   if (!inf.closed) {
      inf.close();
   }
   if (srch && !srch.closed) {
      srchclose();
   }
   if (idx && !idx.closed) {
      idxclose();
   }
   if (copydx && !copydx.closed) {
      copydxclose();
   }
}

</script>
