/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.BitSet;
import javax.vecmath.Point3f;
import org.jmol.modelset.Atom;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;

public class NucleicPolymer
extends BioPolymer {
    NucleicPolymer(Monomer[] monomerArray) {
        super(monomerArray);
    }

    Atom getNucleicPhosphorusAtom(int n) {
        return this.monomers[n].getLeadAtom();
    }

    boolean hasWingPoints() {
        return true;
    }

    public void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        int n = this.model.getBioPolymerCount();
        while (--n >= 0) {
            BioPolymer bioPolymer = (BioPolymer)this.model.getBioPolymer(n);
            if (bioPolymer == this || bioPolymer == null || !(bioPolymer instanceof NucleicPolymer)) continue;
            this.lookForHbonds((NucleicPolymer)bioPolymer, bitSet, bitSet2);
        }
    }

    void lookForHbonds(NucleicPolymer nucleicPolymer, BitSet bitSet, BitSet bitSet2) {
        int n = this.monomerCount;
        while (--n >= 0) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[n];
            if (!nucleicMonomer.isPurine()) continue;
            Atom atom = nucleicMonomer.getN1();
            Atom atom2 = null;
            float f = 25.0f;
            NucleicMonomer nucleicMonomer2 = null;
            int n2 = nucleicPolymer.monomerCount;
            while (--n2 >= 0) {
                Atom atom3;
                float f2;
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)nucleicPolymer.monomers[n2];
                if (!nucleicMonomer3.isPyrimidine() || !((f2 = atom.distanceSquared((Point3f)(atom3 = nucleicMonomer3.getN3()))) < f)) continue;
                nucleicMonomer2 = nucleicMonomer3;
                atom2 = atom3;
                f = f2;
            }
            if (atom2 == null) continue;
            this.model.addHydrogenBond(atom, atom2, (short)1024, bitSet, bitSet2);
            if (nucleicMonomer.isGuanine()) {
                this.model.addHydrogenBond(nucleicMonomer.getN2(), nucleicMonomer2.getO2(), (short)1024, bitSet, bitSet2);
                this.model.addHydrogenBond(nucleicMonomer.getO6(), nucleicMonomer2.getN4(), (short)1024, bitSet, bitSet2);
                continue;
            }
            this.model.addHydrogenBond(nucleicMonomer.getN6(), nucleicMonomer2.getO4(), (short)1024, bitSet, bitSet2);
        }
    }
}

