/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.awt.Rectangle;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Point4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import org.jmol.atomdata.AtomData;
import org.jmol.atomdata.AtomDataServer;
import org.jmol.atomdata.AtomIndexIterator;
import org.jmol.bspt.Bspf;
import org.jmol.bspt.SphereIterator;
import org.jmol.bspt.Tuple;
import org.jmol.g3d.Graphics3D;
import org.jmol.geodesic.EnvelopeCalculation;
import org.jmol.modelset.Atom;
import org.jmol.modelset.AtomIterator;
import org.jmol.modelset.AtomIteratorWithinModel;
import org.jmol.modelset.AtomIteratorWithinSet;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.modelset.BondIteratorSelected;
import org.jmol.modelset.CellInfo;
import org.jmol.modelset.Group;
import org.jmol.modelset.Mmset;
import org.jmol.modelset.Model;
import org.jmol.modelset.Molecule;
import org.jmol.shape.Closest;
import org.jmol.shape.Dipoles;
import org.jmol.shape.Labels;
import org.jmol.shape.Shape;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.StateManager;
import org.jmol.viewer.Viewer;

public abstract class ModelSet {
    Viewer viewer;
    Mmset mmset;
    Graphics3D g3d;
    protected String modelSetTypeName;
    protected boolean isXYZ;
    protected boolean isPDB;
    protected Vector trajectories;
    protected boolean isZeroBased;
    CellInfo[] cellInfos;
    public Atom[] atoms;
    int atomCount;
    String[] atomNames;
    private final AtomIteratorWithinModel withinModelIterator = new AtomIteratorWithinModel();
    private final AtomIteratorWithinSet withinAtomSetIterator = new AtomIteratorWithinSet();
    Bond[] bonds;
    int bondCount;
    protected Molecule[] molecules = new Molecule[4];
    protected int moleculeCount;
    protected int modelCount;
    protected final Shape[] shapes = new Shape[31];
    protected final Point3f averageAtomPoint = new Point3f();
    protected final Point3f centerBoundBox = new Point3f();
    protected final Vector3f boundBoxCornerVector = new Vector3f();
    protected final Point3f[] bboxVertices = new Point3f[8];
    int[] atomSerials;
    byte[] specialAtomIDs;
    Object[] clientAtomReferences;
    Vector3f[] vibrationVectors;
    byte[] occupancies;
    short[] bfactor100s;
    float[] partialCharges;
    protected int[] surfaceDistance100s;
    private BitSet bsHidden = new BitSet();
    protected boolean someModelsHaveSymmetry;
    private boolean selectionHaloEnabled = false;
    private boolean echoShapeActive = false;
    protected BitSet[] elementsPresent;
    private BitSet tainted;
    Bspf bspf;
    private final Matrix3f matTemp = new Matrix3f();
    private final Matrix3f matInv = new Matrix3f();
    private final Point3f ptTemp = new Point3f();
    private boolean reportFormalCharges = false;
    private float maxBondingRadius = Float.MIN_VALUE;
    private float maxVanderwaalsRadius = Float.MIN_VALUE;
    private static final boolean showRebondTimes = true;
    private boolean hasBfactorRange;
    private int bfactor100Lo;
    private int bfactor100Hi;
    private int surfaceDistanceMax;
    private BitSet bsSurface;
    private int nSurfaceAtoms;
    private static final int bondGrowthIncrement = 250;
    static final int MAX_BONDS_LENGTH_TO_CACHE = 5;
    static final int MAX_NUM_TO_CACHE = 200;
    int[] numCached = new int[5];
    Bond[][][] freeBonds = new Bond[5][][];
    private BitSet bsPseudoHBonds;
    private boolean haveWarned;
    protected short defaultCovalentMad;
    private float hbondMax;
    private float hbondMin;
    private float hbondMin2;
    private static final boolean useRasMolHbondsCalculation = true;
    private static final boolean MIX_BSPT_ORDER = false;
    private BitSet bsTemp;
    private BitSet selectedMolecules;
    private int selectedMoleculeCount;
    private final Closest closest;
    private static final int minimumPixelSelectionRadius = 6;
    final BitSet bsEmpty;
    final BitSet bsFoundRectangle;
    protected BitSet bsSymmetry;
    private Vector stateScripts;
    private int thisStateModel;

    public ModelSet() {
        int n = 5;
        while (--n > 0) {
            this.freeBonds[n] = new Bond[200][];
        }
        this.haveWarned = false;
        this.hbondMax = 3.25f;
        this.hbondMin = 2.5f;
        this.hbondMin2 = this.hbondMin * this.hbondMin;
        this.bsTemp = new BitSet();
        this.selectedMolecules = new BitSet();
        this.closest = new Closest();
        this.bsEmpty = new BitSet();
        this.bsFoundRectangle = new BitSet();
        this.stateScripts = new Vector();
        this.thisStateModel = 0;
    }

    boolean isPDB() {
        return this.isPDB;
    }

    void setZeroBased() {
        this.isZeroBased = this.isXYZ && this.viewer.getZeroBasedXyzRasmol();
    }

    public CellInfo[] getCellInfos() {
        return this.cellInfos;
    }

    Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtomAt(int n) {
        return this.atoms[n];
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public String[] getAtomNames() {
        return this.atomNames;
    }

    AtomIterator getWithinModelIterator(Atom atom, float f) {
        this.initializeBspf();
        this.withinModelIterator.initialize(this.bspf, atom.modelIndex, atom, f);
        return this.withinModelIterator;
    }

    AtomIndexIterator getWithinAtomSetIterator(int n, float f, BitSet bitSet, boolean bl, boolean bl2) {
        this.initializeBspf();
        this.withinAtomSetIterator.initialize(this, this.bspf, this.atoms[n].modelIndex, n, f, bitSet, bl, bl2);
        return this.withinAtomSetIterator;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBondAt(int n) {
        return this.bonds[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public BondIterator getBondIterator(short s, BitSet bitSet) {
        return new BondIteratorSelected(this, s, bitSet, this.viewer.getBondSelectionModeOr());
    }

    public BondIterator getBondIterator(BitSet bitSet) {
        return new BondIteratorSelected(this, bitSet);
    }

    int getMoleculeCount() {
        return this.moleculeCount;
    }

    public int getModelCount() {
        return this.modelCount;
    }

    private Shape allocateShape(int n) {
        if (n == 2 || n == 3) {
            return null;
        }
        String string = JmolConstants.getShapeClassName(n);
        try {
            Class<?> clazz = Class.forName(string);
            Shape shape = (Shape)clazz.newInstance();
            shape.initializeShape(this.viewer, this.g3d, this, n);
            return shape;
        }
        catch (Exception exception) {
            Logger.error((String)("Could not instantiate shape:" + string), (Throwable)exception);
            return null;
        }
    }

    public Shape getShape(int n) {
        return this.shapes[n];
    }

    Point3f getAverageAtomPoint() {
        return this.averageAtomPoint;
    }

    Point3f getBoundBoxCenter() {
        return this.centerBoundBox;
    }

    Vector3f getBoundBoxCornerVector() {
        return this.boundBoxCornerVector;
    }

    public Point3f[] getBboxVertices() {
        return this.bboxVertices;
    }

    float[] getPartialCharges() {
        return this.partialCharges;
    }

    public void setBsHidden(BitSet bitSet) {
        this.bsHidden = bitSet;
    }

    public boolean isAtomHidden(int n) {
        return this.bsHidden.get(n);
    }

    public float[] getNotionalUnitcell() {
        return this.cellInfos == null || this.cellInfos[0] == null ? null : this.cellInfos[0].getNotionalUnitCell();
    }

    boolean haveSymmetry() {
        return this.someModelsHaveSymmetry;
    }

    public boolean modelSetHasVibrationVectors() {
        return this.vibrationVectors != null;
    }

    public void setSelectionHaloEnabled(boolean bl) {
        if (this.selectionHaloEnabled != bl) {
            this.selectionHaloEnabled = bl;
        }
    }

    boolean getSelectionHaloEnabled() {
        return this.selectionHaloEnabled;
    }

    boolean getEchoStateActive() {
        return this.echoShapeActive;
    }

    public void setEchoStateActive(boolean bl) {
        this.echoShapeActive = bl;
    }

    BitSet getTaintedAtoms() {
        return this.tainted;
    }

    private void taint(int n) {
        if (this.tainted == null) {
            this.tainted = new BitSet(this.atomCount);
        }
        this.tainted.set(n);
    }

    void setTaintedAtoms(BitSet bitSet) {
        if (bitSet == null) {
            this.tainted = null;
            return;
        }
        if (this.tainted == null) {
            this.tainted = new BitSet(this.atomCount);
        }
        BitSetUtil.copy((BitSet)bitSet, (BitSet)this.tainted);
    }

    void loadCoordinates(String string) {
        this.bspf = null;
        int[] nArray = Parser.markLines((String)string, (char)';');
        try {
            int n = Parser.parseInt((String)string.substring(0, nArray[0] - 1));
            for (int i = 1; i <= n; ++i) {
                String[] stringArray = Parser.getTokens((String)Parser.parseTrimmed((String)string.substring(nArray[i], nArray[i + 1])));
                int n2 = Parser.parseInt((String)stringArray[0]) - 1;
                float f = Parser.parseFloat((String)stringArray[3]);
                float f2 = Parser.parseFloat((String)stringArray[4]);
                float f3 = Parser.parseFloat((String)stringArray[5]);
                this.setAtomCoord(n2, f, f2, f3);
            }
        }
        catch (Exception exception) {
            Logger.error((String)("Frame.loadCoordinate error: " + exception));
        }
    }

    void setAtomCoord(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.bspf = null;
        ((Tuple3f)this.atoms[n]).x = f;
        ((Tuple3f)this.atoms[n]).y = f2;
        ((Tuple3f)this.atoms[n]).z = f3;
        this.taint(n);
    }

    void setAtomCoordRelative(int n, float f, float f2, float f3) {
        if (n < 0 || n >= this.atomCount) {
            return;
        }
        this.bspf = null;
        ((Tuple3f)this.atoms[n]).x += f;
        ((Tuple3f)this.atoms[n]).y += f2;
        ((Tuple3f)this.atoms[n]).z += f3;
        this.taint(n);
    }

    void setAtomCoordRelative(BitSet bitSet, float f, float f2, float f3) {
        this.bspf = null;
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            this.setAtomCoordRelative(n, f, f2, f3);
        }
    }

    void rotateSelected(Matrix3f matrix3f, Matrix3f matrix3f2, BitSet bitSet, boolean bl, boolean bl2) {
        this.bspf = null;
        BitSet bitSet2 = bl ? this.getMoleculeBitSet(bitSet) : bitSet;
        this.matInv.set(matrix3f2);
        this.matInv.invert();
        this.ptTemp.set(0.0f, 0.0f, 0.0f);
        this.matTemp.mul(matrix3f, matrix3f2);
        this.matTemp.mul(this.matInv, this.matTemp);
        int n = 0;
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (!bitSet2.get(n2)) continue;
            this.ptTemp.add((Tuple3f)this.atoms[n2]);
            this.matTemp.transform((Tuple3f)this.atoms[n2]);
            this.ptTemp.sub((Tuple3f)this.atoms[n2]);
            this.taint(n2);
            ++n;
        }
        if (bl2) {
            return;
        }
        this.ptTemp.scale(1.0f / (float)n);
        n2 = this.atomCount;
        while (--n2 >= 0) {
            if (!bitSet2.get(n2)) continue;
            this.atoms[n2].add((Tuple3f)this.ptTemp);
        }
    }

    BitSet getMoleculeBitSet(BitSet bitSet) {
        int n;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        BitSet bitSet2 = (BitSet)bitSet.clone();
        BitSet bitSet3 = (BitSet)bitSet.clone();
        while ((n = BitSetUtil.length((BitSet)bitSet3)) > 0) {
            this.bsTemp = this.getMoleculeBitSet(n - 1);
            BitSetUtil.andNot((BitSet)bitSet3, (BitSet)this.bsTemp);
            bitSet2.or(this.bsTemp);
        }
        return bitSet2;
    }

    BitSet getMoleculeBitSet(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].atomList;
        }
        return null;
    }

    void invertSelected(Point3f point3f, Point4f point4f, BitSet bitSet) {
        this.bspf = null;
        if (point3f != null) {
            int n = this.atomCount;
            while (--n >= 0) {
                if (!bitSet.get(n)) continue;
                float f = (point3f.x - ((Tuple3f)this.atoms[n]).x) * 2.0f;
                float f2 = (point3f.y - ((Tuple3f)this.atoms[n]).y) * 2.0f;
                float f3 = (point3f.z - ((Tuple3f)this.atoms[n]).z) * 2.0f;
                this.setAtomCoordRelative(n, f, f2, f3);
            }
            return;
        }
        Vector3f vector3f = new Vector3f(point4f.x, point4f.y, point4f.z);
        vector3f.normalize();
        float f = (float)Math.sqrt(point4f.x * point4f.x + point4f.y * point4f.y + point4f.z * point4f.z);
        int n = this.atomCount;
        while (--n >= 0) {
            if (!bitSet.get(n)) continue;
            float f4 = -Graphics3D.distanceToPlane((Point4f)point4f, (float)f, (Point3f)this.atoms[n]) * 2.0f;
            float f5 = vector3f.x * f4;
            float f6 = vector3f.y * f4;
            float f7 = vector3f.z * f4;
            this.setAtomCoordRelative(n, f5, f6, f7);
        }
    }

    public Mmset getMmset() {
        return this.mmset;
    }

    String getModelSetTypeName() {
        return this.modelSetTypeName;
    }

    Properties getModelSetProperties() {
        return this.mmset.getModelSetProperties();
    }

    String getModelSetProperty(String string) {
        return this.mmset.getModelSetProperty(string);
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.mmset.getModelSetAuxiliaryInfo();
    }

    Object getModelSetAuxiliaryInfo(String string) {
        return this.mmset.getModelSetAuxiliaryInfo(string);
    }

    void calcSelectedGroupsCount(BitSet bitSet) {
        this.mmset.calcSelectedGroupsCount(bitSet);
    }

    void calcSelectedMonomersCount(BitSet bitSet) {
        this.mmset.calcSelectedMonomersCount(bitSet);
    }

    void setShapeSize(int n, int n2, BitSet bitSet) {
        if (n2 != 0) {
            this.loadShape(n);
        }
        if (this.shapes[n] != null) {
            this.shapes[n].setSize(n2, bitSet);
        }
    }

    void loadShape(int n) {
        if (this.shapes[n] == null) {
            this.shapes[n] = this.allocateShape(n);
        }
    }

    void setShapeProperty(int n, String string, Object object, BitSet bitSet) {
        if (this.shapes[n] != null) {
            this.shapes[n].setProperty(string, object, bitSet);
        }
    }

    Object getShapeProperty(int n, String string, int n2) {
        return this.shapes[n] == null ? null : this.shapes[n].getProperty(string, n2);
    }

    void setModelVisibility() {
        int n;
        BitSet bitSet = this.viewer.getVisibleFramesBitSet();
        for (n = 1; n < 31; ++n) {
            if (this.shapes[n] == null) continue;
            this.shapes[n].setVisibilityFlags(bitSet);
        }
        this.shapes[0].setVisibilityFlags(bitSet);
        for (n = 0; n < 31; ++n) {
            Shape shape = this.shapes[n];
            if (shape == null) continue;
            shape.setModelClickability();
        }
    }

    void calculateStructuresAllExcept(BitSet bitSet) {
        this.mmset.calculateStructuresAllExcept(bitSet);
        this.mmset.freeze();
    }

    BitSet setConformation(int n, int n2) {
        BitSet bitSet = new BitSet();
        String string = this.getAltLocListInModel(n);
        if (string.length() > 0) {
            BitSet bitSet2 = this.getModelAtomBitSet(n);
            if (n2 >= 0) {
                int n3 = this.getAltLocCountInModel(n);
                while (--n3 >= 0) {
                    if (n3 == n2) continue;
                    BitSetUtil.andNot((BitSet)bitSet2, (BitSet)this.getSpecAlternate(string.substring(n3, n3 + 1)));
                }
            }
            if (BitSetUtil.length((BitSet)bitSet2) > 0) {
                this.setConformation(n, bitSet2);
                bitSet.or(bitSet2);
            }
        }
        return bitSet;
    }

    void setConformation(int n, BitSet bitSet) {
        this.mmset.setConformation(n, bitSet);
    }

    void setTrajectory(int n) {
        if (this.trajectories == null || n < 0 || n >= this.trajectories.size()) {
            return;
        }
        Point3f[] point3fArray = (Point3f[])this.trajectories.get(n);
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            this.atoms[n2].set((Tuple3f)point3fArray[n2]);
        }
    }

    int getTrajectoryCount() {
        return this.trajectories == null ? 1 : this.trajectories.size();
    }

    Model getModel(int n) {
        return this.mmset.getModel(n);
    }

    int getModelNumberIndex(int n, boolean bl) {
        return this.mmset.getModelNumberIndex(n, bl);
    }

    int getModelNumber(int n) {
        return this.mmset.getModelNumber(n);
    }

    int getModelFileNumber(int n) {
        return this.mmset.getModelFileNumber(n);
    }

    String getModelName(int n) {
        return this.mmset.getModelName(n);
    }

    String getModelTitle(int n) {
        return this.mmset.getModelTitle(n);
    }

    String getModelFile(int n) {
        return this.mmset.getModelFile(n);
    }

    Properties getModelProperties(int n) {
        return this.mmset.getModelProperties(n);
    }

    String getModelProperty(int n, String string) {
        return this.mmset.getModelProperty(n, string);
    }

    Hashtable getModelAuxiliaryInfo(int n) {
        return this.mmset.getModelAuxiliaryInfo(n);
    }

    Object getModelAuxiliaryInfo(int n, String string) {
        return this.mmset.getModelAuxiliaryInfo(n, string);
    }

    public int getAltLocIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getAltLocListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    public int getInsertionCodeIndexInModel(int n, char c) {
        if (c == '\u0000') {
            return 0;
        }
        String string = this.getInsertionListInModel(n);
        if (string.length() == 0) {
            return 0;
        }
        return string.indexOf(c) + 1;
    }

    String getAltLocListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        return string == null ? "" : string;
    }

    String getInsertionListInModel(int n) {
        String string = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        return string == null ? "" : string;
    }

    String getModelSymmetryList(int n) {
        if (this.cellInfos == null || this.cellInfos[n] == null) {
            return "";
        }
        String[] stringArray = this.cellInfos[n].symmetryOperations;
        String string = "";
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                string = string + "\n" + stringArray[i];
            }
        }
        return string;
    }

    public int getModelSymmetryCount(int n) {
        return this.cellInfos == null || this.cellInfos[n] == null ? 0 : this.cellInfos[n].symmetryOperations.length;
    }

    public int getAltLocCountInModel(int n) {
        return this.mmset.getNAltLocs(n);
    }

    public int getInsertionCountInModel(int n) {
        return this.mmset.getNInsertions(n);
    }

    public int[] getModelCellRange(int n) {
        if (this.cellInfos == null) {
            return null;
        }
        return this.cellInfos[n].getCellRange();
    }

    boolean modelHasVibrationVectors(int n) {
        if (this.vibrationVectors != null) {
            int n2 = this.atomCount;
            while (--n2 >= 0) {
                if (n >= 0 && this.atoms[n2].modelIndex != n || this.vibrationVectors[n2] == null || !(this.vibrationVectors[n2].length() > 0.0f)) continue;
                return true;
            }
        }
        return false;
    }

    BitSet getElementsPresentBitSet(int n) {
        if (n >= 0) {
            return this.elementsPresent[n];
        }
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.modelCount; ++i) {
            bitSet.or(this.elementsPresent[i]);
        }
        return bitSet;
    }

    String getSymmetryInfoAsString(int n) {
        if (this.cellInfos == null) {
            return "no symmetry information";
        }
        return this.cellInfos[n].symmetryInfoString;
    }

    void toCartesian(int n, Point3f point3f) {
        if (n < 0) {
            n = 0;
        }
        if (this.cellInfos == null || n >= this.cellInfos.length || this.cellInfos[n] == null) {
            return;
        }
        String string = "Frame convertFractional " + point3f + "--->";
        this.cellInfos[n].toCartesian(point3f);
        Logger.info((String)(string + point3f));
    }

    void toUnitCell(int n, Point3f point3f, Point3f point3f2) {
        if (n < 0) {
            return;
        }
        if (this.cellInfos == null || n >= this.cellInfos.length || this.cellInfos[n] == null) {
            return;
        }
        this.cellInfos[n].toUnitCell(point3f, point3f2);
    }

    void toFractional(int n, Point3f point3f) {
        if (n < 0) {
            return;
        }
        if (this.cellInfos == null || n >= this.cellInfos.length || this.cellInfos[n] == null) {
            return;
        }
        this.cellInfos[n].toFractional(point3f);
    }

    int getAtomCountInModel(int n) {
        if (n < 0) {
            return this.atomCount;
        }
        int n2 = 0;
        int n3 = this.atomCount;
        while (--n3 >= 0) {
            if (this.atoms[n3].modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    int getFirstAtomIndexInModel(int n) {
        return this.mmset.getFirstAtomIndex(n);
    }

    int getAtomIndexFromAtomNumber(int n) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].getAtomNumber() != n) continue;
            return i;
        }
        return -1;
    }

    void setFormalCharges(BitSet bitSet, int n) {
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            this.atoms[i].setFormalCharge(n);
        }
        this.reportFormalCharges = true;
    }

    void setProteinType(BitSet bitSet, byte by) {
        int n = -1;
        int n2 = -1;
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            if (n2 != i - 1) {
                n = -1;
            }
            n2 = i;
            n = this.atoms[i].setProteinStructureType(by, n);
        }
    }

    float calcRotationRadius(Point3f point3f) {
        float f = 0.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            float f2;
            Atom atom = this.atoms[n];
            float f3 = point3f.distance((Point3f)atom);
            float f4 = f3 + (f2 = atom.getVanderwaalsRadiusFloat());
            if (!(f4 > f)) continue;
            f = f4;
        }
        return f == 0.0f ? 10.0f : f;
    }

    float calcRotationRadius(BitSet bitSet) {
        Point3f point3f = this.getAtomSetCenter(bitSet);
        float f = 0.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            float f2;
            Atom atom;
            float f3;
            float f4;
            if (!bitSet.get(n) || !((f4 = (f3 = point3f.distance((Point3f)(atom = this.atoms[n]))) + (f2 = atom.getVanderwaalsRadiusFloat())) > f)) continue;
            f = f4;
        }
        return f == 0.0f ? 10.0f : f;
    }

    Point3f getAtomSetCenter(BitSet bitSet) {
        Point3f point3f = new Point3f(0.0f, 0.0f, 0.0f);
        int n = BitSetUtil.cardinalityOf((BitSet)bitSet);
        if (n == 0) {
            return point3f;
        }
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (!bitSet.get(n2)) continue;
            point3f.add((Tuple3f)this.atoms[n2]);
        }
        point3f.scale(1.0f / (float)n);
        return point3f;
    }

    public float getMaxVanderwaalsRadius() {
        if (this.maxVanderwaalsRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        return this.maxVanderwaalsRadius;
    }

    private void findMaxRadii() {
        int n = this.atomCount;
        while (--n >= 0) {
            float f;
            Atom atom = this.atoms[n];
            float f2 = atom.getBondingRadiusFloat();
            if (f2 > this.maxBondingRadius) {
                this.maxBondingRadius = f2;
            }
            if (!((f = atom.getVanderwaalsRadiusFloat()) > this.maxVanderwaalsRadius)) continue;
            this.maxVanderwaalsRadius = f;
        }
    }

    Point3f getAveragePosition(int n, int n2) {
        Atom atom = this.atoms[n];
        Atom atom2 = this.atoms[n2];
        return new Point3f((((Tuple3f)atom).x + ((Tuple3f)atom2).x) / 2.0f, (((Tuple3f)atom).y + ((Tuple3f)atom2).y) / 2.0f, (((Tuple3f)atom).z + ((Tuple3f)atom2).z) / 2.0f);
    }

    Vector3f getAtomVector(int n, int n2) {
        Vector3f vector3f = new Vector3f((Tuple3f)this.atoms[n]);
        vector3f.sub((Tuple3f)this.atoms[n2]);
        return vector3f;
    }

    void clearBfactorRange() {
        this.hasBfactorRange = false;
    }

    private void calcBfactorRange(BitSet bitSet) {
        if (!this.hasBfactorRange) {
            this.bfactor100Lo = Integer.MAX_VALUE;
            this.bfactor100Hi = Integer.MIN_VALUE;
            int n = this.atomCount;
            while (--n > 0) {
                if (bitSet != null && !bitSet.get(n)) continue;
                int n2 = this.atoms[n].getBfactor100();
                if (n2 < this.bfactor100Lo) {
                    this.bfactor100Lo = n2;
                    continue;
                }
                if (n2 <= this.bfactor100Hi) continue;
                this.bfactor100Hi = n2;
            }
            this.hasBfactorRange = true;
        }
    }

    public int getBfactor100Lo() {
        if (!this.hasBfactorRange) {
            if (this.viewer.isRangeSelected()) {
                this.calcBfactorRange(this.viewer.getSelectionSet());
            } else {
                this.calcBfactorRange(null);
            }
        }
        return this.bfactor100Lo;
    }

    public int getBfactor100Hi() {
        this.getBfactor100Lo();
        return this.bfactor100Hi;
    }

    public int getSurfaceDistanceMax() {
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistanceMax;
    }

    int getSurfaceDistance100(int n) {
        if (this.nSurfaceAtoms == 0) {
            return -1;
        }
        if (this.surfaceDistance100s == null) {
            this.calcSurfaceDistances();
        }
        return this.surfaceDistance100s[n];
    }

    private void calcSurfaceDistances() {
        this.calculateSurface(null, null, -1.0f);
    }

    Point3f[] calculateSurface(BitSet bitSet, BitSet bitSet2, float f) {
        if (f < 0.0f) {
            f = 3.0f;
        }
        EnvelopeCalculation envelopeCalculation = new EnvelopeCalculation((AtomDataServer)this.viewer, this.atomCount, null);
        envelopeCalculation.calculate(Float.MAX_VALUE, f, 1.0f, Float.MAX_VALUE, bitSet, bitSet2, false, false, false, false, true);
        Point3f[] point3fArray = envelopeCalculation.getPoints();
        this.surfaceDistanceMax = 0;
        this.bsSurface = envelopeCalculation.getBsSurfaceClone();
        this.surfaceDistance100s = new int[this.atomCount];
        this.nSurfaceAtoms = BitSetUtil.cardinalityOf((BitSet)this.bsSurface);
        if (this.nSurfaceAtoms == 0 || point3fArray == null || point3fArray.length == 0) {
            return point3fArray;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.bsSurface.get(i)) {
                this.surfaceDistance100s[i] = 0;
                continue;
            }
            float f2 = Float.MAX_VALUE;
            Atom atom = this.atoms[i];
            int n = point3fArray.length;
            while (--n >= 0) {
                float f3 = point3fArray[n].distance((Point3f)atom) - f;
                if (f3 < 0.0f && Logger.isActiveLevel((int)0)) {
                    Logger.debug((String)("draw d" + n + " " + Escape.escape((Tuple3f)point3fArray[n]) + " \"" + f3 + " ? " + atom.getIdentity() + "\""));
                }
                f2 = Math.min(f3, f2);
            }
            n = this.surfaceDistance100s[i] = (int)(f2 * 100.0f);
            this.surfaceDistanceMax = Math.max(this.surfaceDistanceMax, n);
        }
        return point3fArray;
    }

    public float getMeasurement(int[] nArray) {
        float f = Float.NaN;
        if (nArray == null) {
            return f;
        }
        int n = nArray[0];
        if (n < 2) {
            return f;
        }
        int n2 = n;
        while (--n2 >= 0) {
            if (nArray[n2 + 1] >= 0) continue;
            return f;
        }
        switch (n) {
            case 2: {
                f = this.getDistance(nArray[1], nArray[2]);
                break;
            }
            case 3: {
                f = this.getAngle(nArray[1], nArray[2], nArray[3]);
                break;
            }
            case 4: {
                f = this.getTorsion(nArray[1], nArray[2], nArray[3], nArray[4]);
                break;
            }
            default: {
                Logger.error((String)("Invalid count in measurement calculation:" + n));
                throw new IndexOutOfBoundsException();
            }
        }
        return f;
    }

    public float getDistance(int n, int n2) {
        return this.atoms[n].distance((Point3f)this.atoms[n2]);
    }

    public float getAngle(int n, int n2, int n3) {
        Atom atom = this.atoms[n];
        Atom atom2 = this.atoms[n2];
        Atom atom3 = this.atoms[n3];
        return Measure.computeAngle((Point3f)atom, (Point3f)atom2, (Point3f)atom3, (boolean)true);
    }

    public float getTorsion(int n, int n2, int n3, int n4) {
        return Measure.computeTorsion((Point3f)this.atoms[n], (Point3f)this.atoms[n2], (Point3f)this.atoms[n3], (Point3f)this.atoms[n4], (boolean)true);
    }

    int getBondCountInModel(int n) {
        int n2 = 0;
        int n3 = this.bondCount;
        while (--n3 >= 0) {
            if (n >= 0 && this.bonds[n3].atom1.modelIndex != n) continue;
            ++n2;
        }
        return n2;
    }

    BitSet getBondsForSelectedAtoms(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        boolean bl = this.viewer.getBondSelectionModeOr();
        for (int i = 0; i < this.bondCount; ++i) {
            boolean bl2;
            boolean bl3;
            Bond bond = this.bonds[i];
            if (!(!bl & (bl3 = bitSet.get(bond.atom1.atomIndex)) & (bl2 = bitSet.get(bond.atom2.atomIndex))) && !(bl & (bl3 | bl2))) continue;
            bitSet2.set(i);
        }
        return bitSet2;
    }

    public Bond bondAtoms(Atom atom, Atom atom2, short s, short s2, BitSet bitSet) {
        return this.getOrAddBond(atom, atom2, s, s2, bitSet);
    }

    private Bond getOrAddBond(Atom atom, Atom atom2, short s, short s2, BitSet bitSet) {
        int n;
        if (atom.isBonded(atom2)) {
            n = atom.getBond((Atom)atom2).index;
        } else {
            if (this.bondCount == this.bonds.length) {
                this.bonds = (Bond[])ArrayUtil.setLength((Object)this.bonds, (int)(this.bondCount + 250));
            }
            if (s < 0) {
                s = 1;
            }
            n = this.setBond((int)this.bondCount++, (Bond)this.bondMutually((Atom)atom, (Atom)atom2, (short)s, (short)s2)).index;
        }
        if (bitSet != null) {
            bitSet.set(n);
        }
        return this.bonds[n];
    }

    Bond setBond(int n, Bond bond) {
        bond.index = n;
        this.bonds[n] = bond;
        return this.bonds[n];
    }

    protected Bond bondMutually(Atom atom, Atom atom2, short s, short s2) {
        Bond bond = new Bond(atom, atom2, s, s2, 0);
        this.addBondToAtom(atom, bond);
        this.addBondToAtom(atom2, bond);
        return bond;
    }

    private void addBondToAtom(Atom atom, Bond bond) {
        if (atom.bonds == null) {
            atom.bonds = new Bond[1];
            atom.bonds[0] = bond;
        } else {
            atom.bonds = this.addToBonds(bond, atom.bonds);
        }
    }

    private Bond[] addToBonds(Bond bond, Bond[] bondArray) {
        Bond[] bondArray2;
        if (bondArray == null) {
            if (this.numCached[1] > 0) {
                this.numCached[1] = this.numCached[1] - 1;
                bondArray2 = this.freeBonds[1][this.numCached[1]];
            } else {
                bondArray2 = new Bond[]{bond};
            }
        } else {
            int n = bondArray.length;
            int n2 = n + 1;
            if (n2 < 5 && this.numCached[n2] > 0) {
                int n3 = n2;
                int n4 = this.numCached[n3] - 1;
                this.numCached[n3] = n4;
                bondArray2 = this.freeBonds[n2][n4];
            } else {
                bondArray2 = new Bond[n2];
            }
            bondArray2[n] = bond;
            int n5 = n;
            while (--n5 >= 0) {
                bondArray2[n5] = bondArray[n5];
            }
            if (n < 5 && this.numCached[n] < 200) {
                int n6 = n;
                int n7 = this.numCached[n6];
                this.numCached[n6] = n7 + 1;
                this.freeBonds[n][n7] = bondArray;
            }
        }
        return bondArray2;
    }

    Vector3f getModelDipole() {
        Vector3f vector3f = (Vector3f)this.mmset.getModelSetAuxiliaryInfo("dipole");
        if (vector3f == null) {
            vector3f = (Vector3f)this.mmset.getModelSetAuxiliaryInfo("DIPOLE_VEC");
        }
        return vector3f;
    }

    void getBondDipoles() {
        if (this.partialCharges == null) {
            return;
        }
        this.loadShape(24);
        Dipoles dipoles = (Dipoles)this.shapes[24];
        dipoles.clear(true);
        int n = this.bondCount;
        while (--n >= 0) {
            if (!this.bonds[n].isCovalent()) continue;
            Atom atom = this.bonds[n].atom1;
            Atom atom2 = this.bonds[n].atom2;
            float f = this.partialCharges[atom.atomIndex];
            float f2 = this.partialCharges[atom2.atomIndex];
            if (f == f2) continue;
            dipoles.setDipole(atom, atom2, f, f2);
        }
    }

    void addHydrogenBond(Atom atom, Atom atom2, short s, BitSet bitSet, BitSet bitSet2) {
        boolean bl;
        if (atom == null || atom2 == null) {
            return;
        }
        boolean bl2 = bitSet == null || bitSet.get(atom.atomIndex);
        boolean bl3 = bitSet2 == null || bitSet2.get(atom.atomIndex);
        boolean bl4 = bitSet == null || bitSet.get(atom2.atomIndex);
        boolean bl5 = bl = bitSet2 == null || bitSet2.get(atom2.atomIndex);
        if (bl2 && bl || bl3 && bl4) {
            this.getOrAddBond(atom, atom2, s, (short)1, this.bsPseudoHBonds);
        }
    }

    void rebond() {
        this.stateScripts.addElement("connect;");
        this.deleteAllBonds();
        this.autoBond(null, null, null);
    }

    protected int autoBond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        if (this.atomCount == 0) {
            return 0;
        }
        if (this.maxBondingRadius == Float.MIN_VALUE) {
            this.findMaxRadii();
        }
        float f = this.viewer.getBondTolerance();
        float f2 = this.viewer.getMinBondDistance();
        float f3 = f2 * f2;
        short s = this.viewer.getMadBond();
        int n = 0;
        this.initializeBspf();
        long l = 0L;
        l = System.currentTimeMillis();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            Atom atom;
            float f4;
            boolean bl;
            boolean bl2 = bitSet == null || bitSet.get(n2);
            boolean bl3 = bl = bitSet2 == null || bitSet2.get(n2);
            if (!bl2 && !bl || (f4 = (atom = this.atoms[n2]).getBondingRadiusFloat()) == 0.0f) continue;
            float f5 = f4 + this.maxBondingRadius + f;
            SphereIterator sphereIterator = this.bspf.getSphereIterator((int)atom.modelIndex);
            sphereIterator.initializeHemisphere((Tuple)atom, f5);
            while (sphereIterator.hasMoreElements()) {
                short s2;
                boolean bl4;
                Atom atom2 = (Atom)sphereIterator.nextElement();
                if (atom2 == atom) continue;
                int n3 = atom2.atomIndex;
                boolean bl5 = bitSet == null || bitSet.get(n3);
                boolean bl6 = bl4 = bitSet2 == null || bitSet2.get(n3);
                if (!bl5 && !bl4 || (!bl2 || !bl4) && (!bl || !bl5) || (s2 = this.getBondOrder(atom, f4, atom2, atom2.getBondingRadiusFloat(), sphereIterator.foundDistance2(), f3, f)) <= 0) continue;
                this.checkValencesAndBond(atom, atom2, s2, s, bitSet3);
                ++n;
            }
            sphereIterator.release();
        }
        if (Logger.isActiveLevel((int)0)) {
            long l2 = System.currentTimeMillis();
            Logger.debug((String)("Time to autoBond=" + (l2 - l)));
        }
        return n;
    }

    private short getBondOrder(Atom atom, float f, Atom atom2, float f2, float f3, float f4, float f5) {
        if (f == 0.0f || f2 == 0.0f) {
            return 0;
        }
        float f6 = f + f2 + f5;
        float f7 = f6 * f6;
        if (f3 < f4) {
            return 0;
        }
        if (f3 <= f7) {
            return 1;
        }
        return 0;
    }

    void checkValencesAndBond(Atom atom, Atom atom2, short s, short s2, BitSet bitSet) {
        if (atom.getCurrentBondCount() > 20 || atom2.getCurrentBondCount() > 20) {
            if (!this.haveWarned) {
                Logger.warn((String)"maximum auto bond count reached");
            }
            this.haveWarned = true;
            return;
        }
        int n = atom.getFormalCharge();
        if (n != 0) {
            int n2 = atom2.getFormalCharge();
            if (n < 0 && n2 < 0 || n > 0 && n2 > 0) {
                return;
            }
        }
        if (atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != 0 && atom2.alternateLocationID != 0) {
            return;
        }
        this.getOrAddBond(atom, atom2, s, s2, bitSet);
    }

    public void deleteAllBonds() {
        this.stateScripts.clear();
        this.viewer.setShapeProperty(1, "reset", null);
        int n = this.bondCount;
        while (--n >= 0) {
            this.bonds[n].deleteAtomReferences();
            this.bonds[n] = null;
        }
        this.bondCount = 0;
    }

    int makeConnections(float f, float f2, short s, int n, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        if (n != 5) {
            String string = "connect " + f + " " + f2 + " ";
            string = bl ? string + Escape.escape((BitSet)bitSet, (boolean)false) + " " : string + Escape.escape((BitSet)bitSet) + " " + Escape.escape((BitSet)bitSet2) + " ";
            string = string + JmolConstants.getBondOrderNameFromOrder(s) + " " + JmolConstants.connectOperationName(n);
            string = string + ";";
            this.stateScripts.addElement(string);
        }
        if (n == 0) {
            return this.deleteConnections(f, f2, s, bitSet, bitSet2, bl);
        }
        if (n == 4) {
            return this.autoBond(s, bitSet, bitSet2, bitSet3, bl);
        }
        if (s == -1) {
            s = 1;
        }
        float f3 = f * f;
        float f4 = f2 * f2;
        this.defaultCovalentMad = this.viewer.getMadBond();
        short s2 = this.getDefaultMadFromOrder(s);
        int n2 = 0;
        int n3 = 0;
        boolean bl2 = n == 5;
        Bond bond = null;
        int n4 = bl ? this.bondCount : this.atomCount;
        int n5 = bl ? 1 : this.atomCount;
        Atom atom = null;
        Atom atom2 = null;
        int n6 = n4;
        while (--n6 >= 0) {
            if (!bitSet.get(n6)) continue;
            if (bl) {
                bond = this.bonds[n6];
                atom = bond.atom1;
                atom2 = bond.atom2;
            } else {
                atom = this.atoms[n6];
            }
            int n7 = n5;
            while (--n7 >= 0) {
                float f5;
                if (!bl) {
                    if (n7 == n6 || !bitSet2.get(n7)) continue;
                    atom2 = this.atoms[n7];
                    if (atom.modelIndex != atom2.modelIndex || atom.alternateLocationID != atom2.alternateLocationID && atom.alternateLocationID != 0 && atom2.alternateLocationID != 0) continue;
                    bond = atom.getBond(atom2);
                }
                if (bond == null && (bl2 || 1 == n) || bond != null && 2 == n || (f5 = atom.distanceSquared((Point3f)atom2)) < f3 || f5 > f4) continue;
                if (bond != null) {
                    if (s >= 0 && !bl2) {
                        bond.setOrder(s);
                    }
                    if (bl2 && s != bond.order && s != -2 && (s != 128 || !bond.isHydrogen())) continue;
                    bitSet3.set(bond.index);
                    ++n3;
                    continue;
                }
                this.bondAtoms(atom, atom2, s, s2, bitSet3);
                ++n2;
            }
        }
        Logger.info((String)(n2 + " new bonds; " + n3 + " modified"));
        return n2 + n3;
    }

    protected short getDefaultMadFromOrder(short s) {
        return (s & 0x780) > 0 ? (short)1 : this.defaultCovalentMad;
    }

    private int autoBond(short s, BitSet bitSet, BitSet bitSet2, BitSet bitSet3, boolean bl) {
        if (bl) {
            BitSet bitSet4 = bitSet;
            bitSet = new BitSet();
            bitSet2 = new BitSet();
            int n = this.bondCount;
            while (--n >= 0) {
                if (!bitSet4.get(n)) continue;
                bitSet.set(this.bonds[n].atom1.atomIndex);
                bitSet2.set(this.bonds[n].atom2.atomIndex);
            }
        }
        if (s == -1) {
            return this.autoBond(bitSet, bitSet2, bitSet3);
        }
        if (s == 128) {
            return this.autoHbond(bitSet, bitSet2, bitSet3);
        }
        Logger.warn((String)("autoBond() unknown order: " + s));
        return 0;
    }

    private int deleteConnections(float f, float f2, short s, BitSet bitSet, BitSet bitSet2, boolean bl) {
        BitSet bitSet3 = new BitSet();
        float f3 = f * f;
        float f4 = f2 * f2;
        if (s != -1 && (s & 0x780) != 0) {
            s = (short)1920;
        }
        int n = 0;
        int n2 = this.bondCount;
        while (--n2 >= 0) {
            float f5;
            Bond bond = this.bonds[n2];
            Atom atom = bond.atom1;
            Atom atom2 = bond.atom2;
            if (!(!bl && (bitSet.get(atom.atomIndex) && bitSet2.get(atom2.atomIndex) || bitSet.get(atom2.atomIndex) && bitSet2.get(atom.atomIndex))) && (!bl || !bitSet.get(n2)) || !bond.atom1.isBonded(bond.atom2) || !((f5 = atom.distanceSquared((Point3f)atom2)) >= f3) || !(f5 <= f4) || s != -1 && s != (bond.order & 0xFFFFFFBF) && (s & bond.order & 0x780) == 0) continue;
            bitSet3.set(n2);
            ++n;
        }
        this.deleteBonds(bitSet3);
        Logger.info((String)(n + " bonds deleted"));
        return n;
    }

    private void deleteBonds(BitSet bitSet) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.bondCount; ++n) {
            Bond bond = this.bonds[n];
            if (!bitSet.get(n)) {
                this.setBond(n2++, bond);
                continue;
            }
            bond.deleteAtomReferences();
        }
        n = this.bondCount;
        while (--n >= n2) {
            this.bonds[n] = null;
        }
        this.bondCount = n2;
    }

    int autoHbond(BitSet bitSet, BitSet bitSet2, BitSet bitSet3) {
        this.bsPseudoHBonds = new BitSet();
        if (this.bondCount > 0) {
            if (this.mmset != null) {
                this.mmset.calcHydrogenBonds(bitSet, bitSet2);
            }
            bitSet3 = this.bsPseudoHBonds;
            return BitSetUtil.cardinalityOf((BitSet)bitSet3);
        }
        int n = 0;
        this.initializeBspf();
        long l = 0L;
        l = System.currentTimeMillis();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            Atom atom = this.atoms[n2];
            short s = atom.getElementNumber();
            if (s != 7 && s != 8) continue;
            SphereIterator sphereIterator = this.bspf.getSphereIterator((int)atom.modelIndex);
            sphereIterator.initializeHemisphere((Tuple)atom, this.hbondMax);
            while (sphereIterator.hasMoreElements()) {
                Atom atom2 = (Atom)sphereIterator.nextElement();
                short s2 = atom2.getElementNumber();
                if (s2 != 7 && s2 != 8 || atom2 == atom || sphereIterator.foundDistance2() < this.hbondMin2 || atom.isBonded(atom2)) continue;
                this.getOrAddBond(atom, atom2, (short)128, (short)1, this.bsPseudoHBonds);
                ++n;
            }
            sphereIterator.release();
        }
        if (Logger.isActiveLevel((int)0)) {
            long l2 = System.currentTimeMillis();
            Logger.debug((String)("Time to hbond=" + (l2 - l)));
        }
        return n;
    }

    void initializeBspf() {
        if (this.bspf == null) {
            long l = 0L;
            l = System.currentTimeMillis();
            this.bspf = new Bspf(3);
            Logger.debug((String)"sequential bspt order");
            int n = this.atomCount;
            while (--n >= 0) {
                Atom atom = this.atoms[n];
                this.bspf.addTuple((int)atom.modelIndex, (Tuple)atom);
            }
            long l2 = System.currentTimeMillis();
            Logger.debug((String)("time to build bspf=" + (l2 - l) + " ms"));
            this.bspf.stats();
        }
    }

    int getChainCount() {
        return this.mmset.getChainCount();
    }

    int getGroupCount() {
        return this.mmset.getGroupCount();
    }

    int getBioPolymerCount() {
        return this.mmset.getBioPolymerCount();
    }

    int getChainCountInModel(int n) {
        return this.mmset.getChainCountInModel(n);
    }

    int getBioPolymerCountInModel(int n) {
        return this.mmset.getBioPolymerCountInModel(n);
    }

    int getGroupCountInModel(int n) {
        return this.mmset.getGroupCountInModel(n);
    }

    private void getMolecules() {
        if (this.moleculeCount > 0) {
            return;
        }
        if (this.molecules == null) {
            this.molecules = new Molecule[4];
        }
        this.moleculeCount = 0;
        int n = this.getAtomCount();
        BitSet bitSet = new BitSet(n);
        BitSet bitSet2 = new BitSet(n);
        int n2 = -1;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        for (int i = 0; i < n; ++i) {
            if (bitSet.get(i) || bitSet2.get(i)) continue;
            n3 = this.atoms[i].modelIndex;
            if (n3 != n2) {
                n4 = -1;
                this.mmset.getModel((int)n3).firstMolecule = this.moleculeCount;
                n5 = this.moleculeCount - 1;
                n2 = n3;
            }
            ++n4;
            bitSet2 = this.getConnectedBitSet(i);
            bitSet.or(bitSet2);
            if (this.moleculeCount == this.molecules.length) {
                this.molecules = (Molecule[])ArrayUtil.setLength((Object)this.molecules, (int)(this.moleculeCount * 2));
            }
            this.molecules[this.moleculeCount] = new Molecule(this, this.moleculeCount, bitSet2, n2, n4);
            this.mmset.getModel((int)n2).moleculeCount = this.moleculeCount - n5;
            ++this.moleculeCount;
        }
    }

    private BitSet getConnectedBitSet(int n) {
        int n2 = this.getAtomCount();
        BitSet bitSet = new BitSet(n2);
        BitSet bitSet2 = this.getModelAtomBitSet(this.atoms[n].modelIndex);
        this.getCovalentlyConnectedBitSet(this.atoms[n], bitSet, bitSet2);
        return bitSet;
    }

    private void getCovalentlyConnectedBitSet(Atom atom, BitSet bitSet, BitSet bitSet2) {
        int n = atom.atomIndex;
        if (!bitSet2.get(n)) {
            return;
        }
        bitSet2.clear(n);
        bitSet.set(n);
        if (atom.bonds == null) {
            return;
        }
        int n2 = atom.bonds.length;
        while (--n2 >= 0) {
            Bond bond = atom.bonds[n2];
            if ((bond.order & 0x780) != 0) continue;
            if (bond.atom1 == atom) {
                this.getCovalentlyConnectedBitSet(bond.atom2, bitSet, bitSet2);
                continue;
            }
            this.getCovalentlyConnectedBitSet(bond.atom1, bitSet, bitSet2);
        }
    }

    Vector getMoleculeInfo(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.moleculeCount; ++i) {
            this.bsTemp = BitSetUtil.copy((BitSet)bitSet);
            this.bsTemp.and(this.molecules[i].atomList);
            if (BitSetUtil.length((BitSet)this.bsTemp) <= 0) continue;
            vector.addElement(this.molecules[i].getInfo());
        }
        return vector;
    }

    public int getMoleculeIndex(int n) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.moleculeCount; ++i) {
            if (!this.molecules[i].atomList.get(n)) continue;
            return this.molecules[i].indexInModel;
        }
        return 0;
    }

    public int getMoleculeCountInModel(int n) {
        int n2 = 0;
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (n != i && n >= 0) continue;
            n2 += this.mmset.getModel((int)i).moleculeCount;
        }
        return n2;
    }

    void calcSelectedMoleculesCount(BitSet bitSet) {
        if (this.moleculeCount == 0) {
            this.getMolecules();
        }
        this.selectedMolecules.xor(this.selectedMolecules);
        this.selectedMoleculeCount = 0;
        for (int i = 0; i < this.moleculeCount; ++i) {
            BitSetUtil.copy((BitSet)bitSet, (BitSet)this.bsTemp);
            this.bsTemp.and(this.molecules[i].atomList);
            if (BitSetUtil.length((BitSet)this.bsTemp) <= 0) continue;
            this.selectedMolecules.set(i);
            ++this.selectedMoleculeCount;
        }
    }

    boolean frankClicked(int n, int n2) {
        Shape shape = this.shapes[30];
        if (shape == null) {
            return false;
        }
        return shape.wasClicked(n, n2);
    }

    int findNearestAtomIndex(int n, int n2) {
        int n3;
        if (this.atomCount == 0) {
            return -1;
        }
        this.closest.atom = null;
        this.findNearestAtomIndex(n, n2, this.closest);
        for (n3 = 0; n3 < this.shapes.length && this.closest.atom == null; ++n3) {
            if (this.shapes[n3] == null) continue;
            this.shapes[n3].findNearestAtomIndex(n, n2, this.closest);
        }
        n3 = this.closest.atom == null ? -1 : this.closest.atom.atomIndex;
        this.closest.atom = null;
        return n3;
    }

    private void findNearestAtomIndex(int n, int n2, Closest closest) {
        Atom atom = null;
        int n3 = this.atomCount;
        while (--n3 >= 0) {
            Atom atom2 = this.atoms[n3];
            if (!atom2.isClickable() || !this.isCursorOnTopOf(atom2, n, n2, 6, atom)) continue;
            atom = atom2;
        }
        closest.atom = atom;
    }

    boolean isCursorOnTopOf(Atom atom, int n, int n2, int n3, Atom atom2) {
        return atom.screenZ > 1 && !this.g3d.isClippedZ(atom.screenZ) && this.g3d.isInDisplayRange(atom.screenX, atom.screenY) && atom.isCursorOnTopOf(n, n2, n3, atom2);
    }

    BitSet findAtomsInRectangle(Rectangle rectangle) {
        this.bsFoundRectangle.and(this.bsEmpty);
        int n = this.atomCount;
        while (--n >= 0) {
            Atom atom = this.atoms[n];
            if (!rectangle.contains(atom.screenX, atom.screenY)) continue;
            this.bsFoundRectangle.set(n);
        }
        return this.bsFoundRectangle;
    }

    void fillAtomData(AtomData atomData, int n) {
        boolean bl;
        if (n == 3) {
            int[] nArray = new int[1];
            atomData.hAtomRadius = (float)JmolConstants.vanderwaalsMars[1] / 1000.0f;
            atomData.hAtoms = this.getAdditionalHydrogens(atomData.bsSelected, nArray);
            atomData.hydrogenAtomCount = nArray[0];
            return;
        }
        atomData.firstAtomIndex = atomData.modelIndex < 0 ? Math.max(0, BitSetUtil.firstSetBit((BitSet)atomData.bsSelected)) : this.getFirstAtomIndexInModel(atomData.modelIndex);
        atomData.firstModelIndex = this.atomCount == 0 ? 0 : (int)this.atoms[atomData.firstAtomIndex].modelIndex;
        atomData.lastModelIndex = atomData.firstModelIndex;
        atomData.modelName = this.getModelName(-1 - atomData.modelIndex);
        atomData.atomXyz = this.atoms;
        atomData.atomCount = this.atomCount;
        atomData.atomicNumber = new int[this.atomCount];
        boolean bl2 = bl = n == 2;
        if (bl) {
            atomData.atomRadius = new float[this.atomCount];
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (atomData.modelIndex >= 0 && this.atoms[i].modelIndex != atomData.firstModelIndex) {
                if (atomData.bsIgnored == null) {
                    atomData.bsIgnored = new BitSet();
                }
                atomData.bsIgnored.set(i);
                continue;
            }
            atomData.atomicNumber[i] = this.atoms[i].getElementNumber();
            atomData.lastModelIndex = this.atoms[i].modelIndex;
            if (!bl) continue;
            atomData.atomRadius[i] = atomData.useIonic ? this.atoms[i].getBondingRadiusFloat() : this.atoms[i].getVanderwaalsRadiusFloat();
        }
    }

    private Point3f[][] getAdditionalHydrogens(BitSet bitSet, int[] nArray) {
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Point3f[][] point3fArrayArray = new Point3f[this.atomCount][];
        int n = 0;
        block5: for (int i = 0; i < this.atomCount; ++i) {
            String string;
            int n2;
            if (!bitSet.get(i) || this.atoms[i].getElementNumber() != 6) continue;
            int n3 = 0;
            Atom atom = this.atoms[i];
            int n4 = n2 = atom.getCovalentHydrogenCount() > 0 ? 0 : atom.getCovalentBondCount();
            if (!(n2 != 3 && n2 != 2 || (string = this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true)) != null && !string.equals("sp"))) {
                n2 = 0;
            }
            if (n2 > 0 && n2 <= 4) {
                n3 += 4 - n2;
            }
            point3fArrayArray[i] = new Point3f[n3];
            n += n3;
            n3 = 0;
            switch (n2) {
                case 1: {
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3a", false);
                    Point3f point3f = new Point3f((Tuple3f)vector3f);
                    point3f.scaleAdd(1.1f, (Tuple3f)atom);
                    point3fArrayArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3b", false);
                    point3f = new Point3f((Tuple3f)vector3f);
                    point3f.scaleAdd(1.1f, (Tuple3f)atom);
                    point3fArrayArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3c", false);
                    point3f = new Point3f((Tuple3f)vector3f);
                    point3f.scaleAdd(1.1f, (Tuple3f)atom);
                    point3fArrayArray[i][n3++] = point3f;
                    continue block5;
                }
                case 2: {
                    string = this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true);
                    if (string == null || string.equals("sp")) continue block5;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "lpa", false);
                    Point3f point3f = new Point3f((Tuple3f)vector3f);
                    point3f.scaleAdd(1.1f, (Tuple3f)atom);
                    point3fArrayArray[i][n3++] = point3f;
                    this.getHybridizationAndAxes(i, vector3f, vector3f2, "lpb", false);
                    point3f = new Point3f((Tuple3f)vector3f);
                    point3f.scaleAdd(1.1f, (Tuple3f)atom);
                    point3fArrayArray[i][n3++] = point3f;
                    continue block5;
                }
                case 3: {
                    if (this.getHybridizationAndAxes(i, vector3f, vector3f2, "sp3", true) == null) continue block5;
                    Point3f point3f = new Point3f((Tuple3f)vector3f);
                    point3f.scaleAdd(1.1f, (Tuple3f)atom);
                    point3fArrayArray[i][n3++] = point3f;
                }
            }
        }
        nArray[0] = n;
        return point3fArrayArray;
    }

    String getHybridizationAndAxes(int n, Vector3f vector3f, Vector3f vector3f2, String string, boolean bl) {
        String string2 = string.length() > 0 && string.charAt(0) == '-' ? string.substring(1) : string;
        Atom atom = this.atoms[n];
        String string3 = "";
        vector3f.set(0.0f, 0.0f, 0.0f);
        vector3f2.set(0.0f, 0.0f, 0.0f);
        Atom atom2 = atom;
        Atom atom3 = atom;
        int n2 = 0;
        float f = 2.984513f;
        Vector3f vector3f3 = new Vector3f();
        Vector3f vector3f4 = new Vector3f();
        Vector3f vector3f5 = new Vector3f(3.14159f, 2.71828f, 1.41421f);
        Vector3f vector3f6 = new Vector3f();
        Vector3f vector3f7 = new Vector3f();
        Vector3f vector3f8 = new Vector3f();
        if (atom.bonds != null) {
            int n3 = atom.bonds.length;
            block11: while (--n3 >= 0) {
                if (!atom.bonds[n3].isCovalent()) continue;
                atom2 = atom.bonds[n3].getOtherAtom(atom);
                vector3f3.sub((Tuple3f)atom, (Tuple3f)atom2);
                vector3f3.normalize();
                vector3f.add((Tuple3f)vector3f3);
                switch (++n2) {
                    case 1: {
                        vector3f2.set((Tuple3f)vector3f3);
                        atom3 = atom2;
                        continue block11;
                    }
                    case 2: {
                        vector3f4.set((Tuple3f)vector3f3);
                        continue block11;
                    }
                    case 3: {
                        vector3f5.set((Tuple3f)vector3f3);
                        vector3f6.set(-vector3f.x, -vector3f.y, -vector3f.z);
                        continue block11;
                    }
                    case 4: {
                        vector3f6.set((Tuple3f)vector3f3);
                        continue block11;
                    }
                }
                n3 = -1;
            }
        }
        switch (n2) {
            case 0: {
                vector3f.set(0.0f, 0.0f, 1.0f);
                vector3f2.set(1.0f, 0.0f, 0.0f);
                break;
            }
            case 1: {
                if (string2.indexOf("sp3") == 0) {
                    string3 = "sp3";
                    vector3f2.cross(vector3f5, vector3f);
                    vector3f7.cross(vector3f, vector3f2);
                    vector3f2.normalize();
                    vector3f7.normalize();
                    vector3f8.set((Tuple3f)vector3f2);
                    vector3f.normalize();
                    vector3f2.scaleAdd(2.828f, (Tuple3f)vector3f2, (Tuple3f)vector3f);
                    if (!string2.equals("sp3a") && !string2.equals("sp3")) {
                        vector3f2.normalize();
                        AxisAngle4f axisAngle4f = new AxisAngle4f(vector3f.x, vector3f.y, vector3f.z, (float)(string2.equals("sp3b") ? 1 : -1) * 2.0943952f);
                        Matrix3f matrix3f = new Matrix3f();
                        matrix3f.setIdentity();
                        matrix3f.set(axisAngle4f);
                        matrix3f.transform((Tuple3f)vector3f2);
                    }
                    vector3f.set((Tuple3f)vector3f2);
                    vector3f2.cross(vector3f7, vector3f);
                    break;
                }
                string3 = "sp";
                if (atom2.getCovalentBondCount() == 3) {
                    this.getHybridizationAndAxes(atom2.atomIndex, vector3f, vector3f5, string2, false);
                    vector3f5.set((Tuple3f)vector3f2);
                    if (string2.indexOf("sp2") == 0) {
                        string3 = "sp2";
                        vector3f.scale(-1.0f);
                    }
                }
                vector3f2.cross(vector3f5, vector3f);
                break;
            }
            case 2: {
                if ((double)vector3f.length() < 0.1) {
                    string3 = "sp";
                    if (!string2.equals("pz")) {
                        if (atom2.getCovalentBondCount() != 3) {
                            atom2 = atom3;
                        }
                        if (atom2.getCovalentBondCount() == 3) {
                            this.getHybridizationAndAxes(atom2.atomIndex, vector3f2, vector3f, "pz", false);
                            if (string2.equals("px")) {
                                vector3f2.scale(-1.0f);
                            }
                            vector3f.set((Tuple3f)vector3f4);
                            break;
                        }
                    }
                    vector3f.set((Tuple3f)vector3f2);
                    vector3f2.cross(vector3f5, vector3f);
                    break;
                }
                string3 = string2.indexOf("sp3") == 0 ? "sp3" : "sp2";
                vector3f5.cross(vector3f, vector3f2);
                if (string2.indexOf("sp") == 0) {
                    if (string2.equals("sp2a") || string2.equals("sp2b")) {
                        vector3f.set((Tuple3f)(string2.indexOf("b") >= 0 ? vector3f4 : vector3f2));
                        vector3f.scale(-1.0f);
                    }
                    vector3f2.cross(vector3f, vector3f5);
                    break;
                }
                if (string2.indexOf("lp") == 0) {
                    string3 = "lp";
                    vector3f5.normalize();
                    vector3f.normalize();
                    vector3f7.scaleAdd(1.2f, (Tuple3f)vector3f5, (Tuple3f)vector3f);
                    vector3f8.scaleAdd(-1.2f, (Tuple3f)vector3f5, (Tuple3f)vector3f);
                    if (!string2.equals("lp")) {
                        vector3f.set((Tuple3f)(string2.indexOf("b") >= 0 ? vector3f8 : vector3f7));
                    }
                    vector3f2.cross(vector3f, vector3f5);
                    break;
                }
                string3 = string2;
                vector3f2.cross(vector3f, vector3f5);
                vector3f.set((Tuple3f)vector3f5);
                if (!(vector3f.z < 0.0f)) break;
                vector3f.set(-vector3f.x, -vector3f.y, -vector3f.z);
                vector3f2.set(-vector3f2.x, -vector3f2.y, -vector3f2.z);
                break;
            }
            default: {
                if (vector3f2.angle(vector3f4) < f) {
                    vector3f7.cross(vector3f2, vector3f4);
                } else {
                    vector3f7.cross(vector3f2, vector3f5);
                }
                vector3f7.normalize();
                if (vector3f4.angle(vector3f5) < f) {
                    vector3f8.cross(vector3f4, vector3f5);
                } else {
                    vector3f8.cross(vector3f2, vector3f5);
                }
                vector3f8.normalize();
                if (Math.abs(vector3f8.dot(vector3f7)) < 0.95f) {
                    string3 = "sp3";
                    if (string2.indexOf("sp") == 0) {
                        vector3f.set((Tuple3f)(string2.equalsIgnoreCase("sp3") || string2.indexOf("d") >= 0 ? vector3f6 : (string2.indexOf("c") >= 0 ? vector3f5 : (string2.indexOf("b") >= 0 ? vector3f4 : vector3f2))));
                        vector3f.scale(-1.0f);
                        vector3f2.set((Tuple3f)vector3f7);
                        break;
                    }
                    if (string2.indexOf("lp") == 0 && n2 == 3) {
                        string3 = "lp";
                    }
                    vector3f2.cross(vector3f, vector3f2);
                    break;
                }
                string3 = "sp2";
                if (string2.indexOf("sp") == 0) {
                    vector3f.set((Tuple3f)(string2.equalsIgnoreCase("sp3") || string2.indexOf("d") >= 0 ? vector3f6 : (string2.indexOf("c") >= 0 ? vector3f5 : (string2.indexOf("b") >= 0 ? vector3f4 : vector3f2))));
                    vector3f.scale(-1.0f);
                    vector3f2.set((Tuple3f)vector3f7);
                    break;
                }
                vector3f.set((Tuple3f)vector3f7);
                if (!(vector3f.z < 0.0f)) break;
                vector3f.set(-vector3f.x, -vector3f.y, -vector3f.z);
                vector3f2.set(-vector3f2.x, -vector3f2.y, -vector3f2.z);
            }
        }
        vector3f2.normalize();
        vector3f.normalize();
        if (Logger.isActiveLevel((int)0)) {
            Logger.debug((String)(atom.getIdentity() + " nBonds=" + n2 + " " + string3));
        }
        if (bl) {
            if (string3 == "") {
                return null;
            }
            if (string2.indexOf("p") == 0 ? string3 == "sp3" : string2.indexOf(string3) < 0) {
                return null;
            }
        }
        return string3;
    }

    BitSet getModelBitSet(BitSet bitSet) {
        BitSet bitSet2 = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (!bitSet.get(i)) continue;
            bitSet2.set(this.atoms[i].modelIndex);
        }
        return bitSet2;
    }

    BitSet getAtomBits(String string) {
        if (string.equals("specialposition")) {
            return this.getSpecialPosition();
        }
        if (string.equals("symmetry")) {
            return this.getSymmetrySet();
        }
        if (string.equals("unitcell")) {
            return this.getUnitCellSet();
        }
        if (string.equals("hetero")) {
            return this.getHeteroSet();
        }
        if (string.equals("hydrogen")) {
            return this.getHydrogenSet();
        }
        if (string.equals("protein")) {
            return this.getProteinSet();
        }
        if (string.equals("carbohydrate")) {
            return this.getCarbohydrateSet();
        }
        if (string.equals("nucleic")) {
            return this.getNucleicSet();
        }
        if (string.equals("dna")) {
            return this.getDnaSet();
        }
        if (string.equals("rna")) {
            return this.getRnaSet();
        }
        if (string.equals("purine")) {
            return this.getPurineSet();
        }
        if (string.equals("pyrimidine")) {
            return this.getPyrimidineSet();
        }
        return null;
    }

    private BitSet getSpecialPosition() {
        BitSet bitSet = new BitSet(this.atomCount);
        short s = -1;
        int n = 0;
        int n2 = this.atomCount;
        block0: while (--n2 >= 0) {
            Atom atom = this.atoms[n2];
            BitSet bitSet2 = atom.getAtomSymmetry();
            if (bitSet2 == null) continue;
            if (atom.modelIndex != s) {
                s = atom.modelIndex;
                n = this.getModelSymmetryCount(s);
            }
            int n3 = 0;
            int n4 = n;
            while (--n4 >= 0) {
                if (!bitSet2.get(n4) || ++n3 <= 1) continue;
                bitSet.set(n2);
                continue block0;
            }
        }
        return bitSet;
    }

    private BitSet getUnitCellSet() {
        BitSet bitSet = new BitSet();
        UnitCell unitCell = this.viewer.getCurrentUnitCell();
        if (unitCell == null) {
            return bitSet;
        }
        Point3f point3f = new Point3f(unitCell.getFractionalOffset());
        point3f.x += 1.0f;
        point3f.y += 1.0f;
        point3f.z += 1.0f;
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isInLatticeCell(point3f)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    protected BitSet getSymmetrySet() {
        return BitSetUtil.copy((BitSet)(this.bsSymmetry == null ? (this.bsSymmetry = new BitSet(this.atomCount)) : this.bsSymmetry));
    }

    private BitSet getHeteroSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isHetero()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getHydrogenSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (this.atoms[n].getElementNumber() != 1) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getProteinSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isProtein()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getCarbohydrateSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isCarbohydrate()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getNucleicSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isNucleic()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getDnaSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isDna()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getRnaSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isRna()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getPurineSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isPurine()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getPyrimidineSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isPyrimidine()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    BitSet getAtomBits(String string, String string2) {
        if (string.equals("IdentifierOrNull")) {
            return this.getIdentifierOrNull(string2);
        }
        if (string.equals("SpecAtom")) {
            return this.getSpecAtom(string2);
        }
        if (string.equals("SpecName")) {
            return this.getSpecName(string2);
        }
        if (string.equals("SpecAlternate")) {
            return this.getSpecAlternate(string2);
        }
        return null;
    }

    private BitSet getIdentifierOrNull(String string) {
        int n;
        BitSet bitSet;
        BitSet bitSet2 = this.getSpecNameOrNull(string);
        if (bitSet2 != null || string.indexOf("?") > 0) {
            return bitSet2;
        }
        int n2 = string.indexOf("*");
        if (n2 > 0) {
            return this.getSpecNameOrNull(string.substring(0, n2) + "??????????" + string.substring(n2 + 1));
        }
        int n3 = string.length();
        for (n2 = 0; n2 < n3 && Character.isLetter(string.charAt(n2)); ++n2) {
        }
        bitSet2 = this.getSpecNameOrNull(string.substring(0, n2));
        if (n2 == n3) {
            return bitSet2;
        }
        if (bitSet2 == null) {
            bitSet2 = new BitSet();
        }
        int n4 = n2;
        while (n2 < n3 && Character.isDigit(string.charAt(n2))) {
            ++n2;
        }
        int n5 = 0;
        try {
            n5 = Integer.parseInt(string.substring(n4, n2));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        char c = ' ';
        if (n2 < n3 && string.charAt(n2) == '^' && ++n2 < n3) {
            c = string.charAt(n2);
        }
        if ((bitSet = this.getSpecSeqcode(n = Group.getSeqcode(n5, c), false)) == null) {
            if (c != ' ') {
                bitSet = this.getSpecSeqcode(Character.toUpperCase(string.charAt(n2)), false);
            }
            if (bitSet == null) {
                return null;
            }
            ++n2;
        }
        bitSet2.and(bitSet);
        if (n2 >= n3) {
            return bitSet2;
        }
        char c2 = string.charAt(n2++);
        bitSet2.and(this.getSpecChain(c2));
        if (n2 == n3) {
            return bitSet2;
        }
        return null;
    }

    private BitSet getSpecAtom(String string) {
        BitSet bitSet = new BitSet();
        string = string.toUpperCase();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isAtomNameMatch(string)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getSpecName(String string) {
        BitSet bitSet = this.getSpecNameOrNull(string);
        if (bitSet != null) {
            return bitSet;
        }
        int n = string.indexOf("*");
        if (n > 0) {
            bitSet = this.getSpecNameOrNull(string.substring(0, n) + "??????????" + string.substring(n + 1));
        }
        return bitSet == null ? new BitSet() : bitSet;
    }

    private BitSet getSpecNameOrNull(String string) {
        BitSet bitSet = null;
        string = string.toUpperCase();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isGroup3OrNameMatch(string)) continue;
            if (bitSet == null) {
                bitSet = new BitSet(n + 1);
            }
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getSpecAlternate(String string) {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isAlternateLocationMatch(string)) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    BitSet getAtomBits(String string, int n) {
        if (string.equals("SpecResid")) {
            return this.getSpecResid(n);
        }
        if (string.equals("SpecSeqcode")) {
            return this.getSpecSeqcode(n, true);
        }
        if (string.equals("SpecChain")) {
            return this.getSpecChain((char)n);
        }
        if (string.equals("atomno")) {
            return this.getSpecAtomNumber(n);
        }
        if (string.equals("SpecModel")) {
            return this.getSpecModel(n);
        }
        return null;
    }

    private BitSet getSpecResid(int n) {
        BitSet bitSet = new BitSet();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.atoms[n2].getGroupID() != n) continue;
            bitSet.set(n2);
        }
        return bitSet;
    }

    private BitSet getSpecSeqcode(int n, boolean bl) {
        BitSet bitSet = new BitSet();
        int n2 = n >> 8;
        boolean bl2 = true;
        char c = Group.getInsertionCode(n);
        switch (c) {
            case '?': {
                int n3 = this.atomCount;
                while (--n3 >= 0) {
                    int n4 = this.atoms[n3].getSeqcode();
                    if (n2 != 0 && n2 != n4 >> 8 || (n4 & 0xFF) == 0) continue;
                    bitSet.set(n3);
                    bl2 = false;
                }
                break;
            }
            default: {
                int n5 = this.atomCount;
                while (--n5 >= 0) {
                    int n6 = this.atoms[n5].getSeqcode();
                    if (n != n6 && (n2 != 0 || n != (n6 & 0xFF)) && (c != '*' || n2 != n6 >> 8)) continue;
                    bitSet.set(n5);
                    bl2 = false;
                }
                break block0;
            }
        }
        return !bl2 || bl ? bitSet : null;
    }

    private BitSet getSpecChain(char c) {
        boolean bl = this.viewer.getChainCaseSensitive();
        if (!bl) {
            c = Character.toUpperCase(c);
        }
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            char c2 = this.atoms[n].getChainID();
            if (!bl) {
                c2 = Character.toUpperCase(c2);
            }
            if (c != c2) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    private BitSet getSpecAtomNumber(int n) {
        BitSet bitSet = new BitSet();
        int n2 = this.atomCount;
        while (--n2 >= 0) {
            if (this.atoms[n2].getAtomNumber() != n) continue;
            bitSet.set(n2);
        }
        return bitSet;
    }

    private BitSet getSpecModel(int n) {
        return this.getModelAtomBitSet(this.getModelNumberIndex(n, true));
    }

    BitSet getAtomBits(String string, int[] nArray) {
        if (string.equals("SpecSeqcodeRange")) {
            return this.getSpecSeqcodeRange(nArray[0], nArray[1]);
        }
        if (string.equals("Cell")) {
            return this.getCellSet(nArray[0], nArray[1], nArray[2]);
        }
        return null;
    }

    private BitSet getSpecSeqcodeRange(int n, int n2) {
        BitSet bitSet = new BitSet();
        this.mmset.selectSeqcodeRange(n, n2, bitSet);
        return bitSet;
    }

    private BitSet getCellSet(int n, int n2, int n3) {
        BitSet bitSet = new BitSet();
        Point3f point3f = new Point3f((float)n / 1000.0f, (float)n2 / 1000.0f, (float)n3 / 1000.0f);
        int n4 = this.atomCount;
        while (--n4 >= 0) {
            if (!this.atoms[n4].isInLatticeCell(point3f)) continue;
            bitSet.set(n4);
        }
        return bitSet;
    }

    BitSet getModelAtomBitSet(int n) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < this.atomCount; ++i) {
            if (n >= 0 && this.atoms[i].modelIndex != n) continue;
            bitSet.set(i);
        }
        return bitSet;
    }

    BitSet getAtomsWithin(float f, Point4f point4f) {
        BitSet bitSet = new BitSet();
        int n = this.getAtomCount();
        while (--n >= 0) {
            Atom atom = this.getAtomAt(n);
            float f2 = Graphics3D.distanceToPlane((Point4f)point4f, (Point3f)atom);
            if (!(f > 0.0f && (double)f2 >= -0.1 && f2 <= f || f < 0.0f && (double)f2 <= 0.1 && f2 >= f) && (f != 0.0f || !((double)Math.abs(f2) < 0.01))) continue;
            bitSet.set(atom.atomIndex);
        }
        return bitSet;
    }

    BitSet getVisibleSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isVisible()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    BitSet getClickableSet() {
        BitSet bitSet = new BitSet();
        int n = this.atomCount;
        while (--n >= 0) {
            if (!this.atoms[n].isClickable()) continue;
            bitSet.set(n);
        }
        return bitSet;
    }

    void addStateScript(String string) {
        int n = this.viewer.getCurrentModelIndex();
        if (this.thisStateModel != n) {
            this.thisStateModel = n;
            string = "frame " + (n < 0 ? "" + n : this.getModelName(-1 - n)) + ";\n" + string;
        }
        this.stateScripts.addElement(string);
    }

    String getState(boolean bl) {
        int n;
        int n2;
        Serializable serializable;
        StringBuffer stringBuffer = new StringBuffer();
        if (bl && this.reportFormalCharges) {
            stringBuffer.append("\n# charges;\n");
            serializable = new Hashtable();
            for (n2 = 0; n2 < this.atomCount; ++n2) {
                StateManager.setStateInfo((Hashtable)serializable, n2, n2, "formalCharge = " + this.atoms[n2].getFormalCharge());
            }
            stringBuffer.append(StateManager.getCommands(serializable));
        }
        if (bl && this.tainted != null) {
            stringBuffer.append("\n# positions;\n");
            serializable = new StringBuffer();
            n2 = 0;
            for (n = 0; n < this.atomCount; ++n) {
                if (!this.tainted.get(n)) continue;
                ((StringBuffer)serializable).append(n + 1).append(" ").append(this.atoms[n].getElementSymbol()).append(" ").append(TextFormat.simpleReplace((String)this.atoms[n].getIdentity(), (String)" ", (String)"_")).append(" ").append(((Tuple3f)this.atoms[n]).x).append(" ").append(((Tuple3f)this.atoms[n]).y).append(" ").append(((Tuple3f)this.atoms[n]).z).append(" ;\n");
                ++n2;
            }
            stringBuffer.append("DATA \"coord set\"\n").append(n2).append(" ;\nJmol Coordinate Data Format 1 -- Jmol ").append(Viewer.getJmolVersion()).append(";\n");
            stringBuffer.append((StringBuffer)serializable);
            stringBuffer.append("end \"coord set\";\n");
        }
        if (bl) {
            stringBuffer.append("\n# connections;\n");
            serializable = this.stateScripts;
            n2 = ((Vector)serializable).size();
            for (n = 0; n < n2; ++n) {
                stringBuffer.append(((Vector)serializable).get(n)).append("\n");
            }
            this.viewer.loadShape(4);
            ((Labels)this.shapes[4]).getDefaultState(stringBuffer);
            stringBuffer.append("\n# model state;\n");
        }
        this.setModelVisibility();
        stringBuffer.append(this.getProteinStructureState());
        stringBuffer.append("\n");
        for (int i = 0; i < 31; ++i) {
            String string;
            Shape shape = this.shapes[i];
            if (shape == null || !bl && !JmolConstants.isShapeSecondary(i) || (string = shape.getShapeState()) == null || string.length() <= 1) continue;
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    private String getProteinStructureState() {
        BitSet bitSet = null;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        for (int i = 0; i <= this.atomCount; ++i) {
            n2 = Integer.MIN_VALUE;
            if (i == this.atomCount || (n2 = this.atoms[i].getProteinStructureID()) != n4) {
                if (bitSet != null) {
                    stringBuffer.append("structure ").append(JmolConstants.getProteinStructureName(n)).append(" ").append(Escape.escape(bitSet)).append("    \t# model=").append(this.getModelName(-1 - this.atoms[n3].modelIndex)).append(" & (").append(n5).append(" - ").append(n6).append(");\n");
                    bitSet = null;
                }
                if (n2 == Integer.MIN_VALUE) continue;
                n5 = this.atoms[i].getResno();
            }
            if (bitSet == null) {
                bitSet = new BitSet();
                n = this.atoms[i].getProteinStructureType();
            }
            bitSet.set(i);
            n4 = n2;
            n6 = this.atoms[i].getResno();
            n3 = i;
        }
        return stringBuffer.toString();
    }
}

