/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.more;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.more.MopacData;
import org.jmol.adapter.readers.more.MopacDataReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

public class MopacGraphfReader
extends MopacDataReader {
    int[] atomicNumbers;
    int atomCount;

    public AtomSetCollection readAtomSetCollection(BufferedReader bufferedReader) {
        this.reader = bufferedReader;
        this.atomSetCollection = new AtomSetCollection("mopac");
        try {
            this.readAtoms();
            this.readSlaterBasis();
            this.readMOs();
            this.readKeywords();
        }
        catch (Exception exception) {
            return this.setError(exception);
        }
        return this.atomSetCollection;
    }

    void readAtoms() throws Exception {
        this.atomSetCollection.newAtomSet();
        this.atomCount = this.parseInt(this.readLine());
        this.atomicNumbers = new int[this.atomCount];
        for (int i = 0; i < this.atomCount; ++i) {
            this.readLine();
            this.atomicNumbers[i] = this.parseInt(this.line.substring(0, 4));
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.x = this.parseFloat(this.line.substring(4, 17));
            atom.y = this.parseFloat(this.line.substring(17, 29));
            atom.z = this.parseFloat(this.line.substring(29, 41));
            if (this.line.length() > 41) {
                atom.partialCharge = this.parseFloat(this.line.substring(41));
            }
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol((int)this.atomicNumbers[i]);
        }
    }

    void readSlaterBasis() throws Exception {
        this.nOrbitals = 0;
        float[] fArray = new float[3];
        for (int i = 0; i < this.atomCount; ++i) {
            float f;
            int n;
            AtomSetCollectionReader.getTokensFloat((String)this.readLine(), (float[])fArray, (int)3);
            int n2 = this.atomicNumbers[i];
            float f2 = fArray[0];
            if (f2 != 0.0f) {
                this.addSlater(i, 0, 0, 0, MopacData.getNPQs(n2) - 1, f2, MopacData.getMopacConstS(n2, f2));
            }
            if ((f2 = fArray[1]) != 0.0f) {
                n = MopacData.getNPQp(n2) - 2;
                f = MopacData.getMopacConstP(n2, f2);
                this.addSlater(i, 1, 0, 0, n, f2, f);
                this.addSlater(i, 0, 1, 0, n, f2, f);
                this.addSlater(i, 0, 0, 1, n, f2, f);
            }
            if ((f2 = fArray[2]) == 0.0f) continue;
            n = MopacData.getNPQd(n2) - 3;
            f = MopacData.getMopacConstD(n2, f2);
            int n3 = 0;
            for (int j = 0; j < 5; ++j) {
                this.addSlater(i, MopacDataReader.dValues[n3++], MopacDataReader.dValues[n3++], MopacDataReader.dValues[n3++], n, f2, f * MopacData.getFactorD(j));
            }
        }
        this.nOrbitals = this.intinfo.size();
        this.setSlaters();
    }

    void readMOs() throws Exception {
        int n;
        int n2;
        int n3;
        float[][] fArray = new float[this.nOrbitals][this.nOrbitals];
        for (int i = 0; i < this.nOrbitals; ++i) {
            n3 = -1;
            for (n2 = 0; n2 < this.nOrbitals; ++n2) {
                if ((n3 = (n3 + 1) % 5) == 0) {
                    this.readLine();
                }
                fArray[i][n2] = this.parseFloat(this.line.substring(n3 * 15, (n3 + 1) * 15));
            }
        }
        float[][] fArray2 = new float[this.nOrbitals][this.nOrbitals];
        for (n3 = 0; n3 < this.nOrbitals; ++n3) {
            n2 = -1;
            for (n = 0; n < n3 + 1; ++n) {
                if ((n2 = (n2 + 1) % 5) == 0) {
                    this.readLine();
                }
                float f = this.parseFloat(this.line.substring(n2 * 15, (n2 + 1) * 15));
                fArray2[n][n3] = f;
                fArray2[n3][n] = f;
            }
        }
        float[][] fArray3 = new float[this.nOrbitals][this.nOrbitals];
        for (n2 = 0; n2 < this.nOrbitals; ++n2) {
            for (n = 0; n < this.nOrbitals; ++n) {
                for (int i = 0; i < this.nOrbitals; ++i) {
                    float[] fArray4 = fArray3[n2];
                    int n4 = n;
                    fArray4[n4] = fArray4[n4] + fArray[n2][i] * fArray2[i][n];
                }
                if (!(Math.abs(fArray3[n2][n]) < 1.0E-4f)) continue;
                fArray3[n2][n] = 0.0f;
            }
        }
        float[] fArray5 = new float[2];
        for (n = 0; n < this.nOrbitals; ++n) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            AtomSetCollectionReader.getTokensFloat((String)this.readLine(), (float[])fArray5, (int)2);
            hashtable.put("energy", new Float(fArray5[0]));
            hashtable.put("occupancy", new Integer((int)fArray5[1]));
            hashtable.put("coefficients", fArray3[n]);
            this.orbitals.addElement(hashtable);
        }
        this.setMOs("eV");
    }

    private void readKeywords() throws Exception {
        if (this.readLine() == null || this.line.indexOf(" Keywords:") < 0) {
            return;
        }
        this.moData.put("calculationType", this.line.substring(11).trim());
    }
}

