"""Latex Splitter quickee python app.

This application assists in spliting large Latex files into lots of
smaller ones.

To use this application, paste a latex file into the window. Highlight
the section you wish to save as an independent fragment. Then hit the
button, give the fragment a file name and a topic, and save
it. Continue until you've retreived everything out of the file you
want.

Starting it with a command-line parameter will try to load that file
into the text box.

This program may require Python as high as 2.2, though 2.1 should
do."""

from Tkinter import *
from ScrolledText import *
import anydbm
import sys
import string

dirprefix = "/home/jerf/loncapa/loncom/html/adm/help/tex/"

class LatexSplitter:
    def __init__(self, master):
        self.frame = Frame(master)
        self.frame.pack()

        self.label = Label(self.frame, text = "For documentation on" 
                           "this program, consult the source code.")
        self.label.pack()

        self.text = ScrolledText(self.frame, width=120, height = 40);
        self.text.pack(fill = BOTH, expand = 1)

        self.l2 = Label(self.frame, text = "File Root Name (no .tex):")
        self.l2.pack()
        self.topic = Text(self.frame, width=60, height = 1)
        self.topic.pack()

        self.button = Button(self.frame, text = "Split & Save", \
                             command = self.splitAndSave)
        self.button.pack()

        if len(sys.argv) > 1:
            f = file(sys.argv[1])
            self.text.insert("1.0", f.read())
            f.close()

    def splitAndSave(self):
        selection = self.text.get("sel.first", "sel.last")
        topic = string.strip(self.topic.get("1.0", "end"))
	labelname = string.replace(topic, " ", "_")
        filename = dirprefix + labelname + ".tex"

        try:
            f = file(filename, 'w')
        except:
            return
	f.write("\\label{%s}\n\n" % labelname)
        f.write(selection)
        f.close()

        self.topic.delete("1.0", END)
        self.text.delete("sel.first", "sel.last")

        f = file("latexSplitterTempResults", 'w')
	f.write(self.text.get("1.0", END))
        f.close()

root = Tk()
app = LatexSplitter(root)
root.mainloop()

