#  Implement a simple queue in terms of a list.
#
# $Id: Queue.pm,v 1.4 2003/04/24 15:12:40 albertel Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#

=pod

=head1 Queue

An object oriented implementation of a queue data structure.  queues
are first in last out data structures.

=head1 Member functions:

=cut

package Queue;


=pod

=head2 new 

  Construct a new queue.

=cut

sub new {
    my $class = shift;		# Class name to bless into.
    my $self  = [];		# Our data is a reference to an anon. array.

    bless($self, $class);	# Type this as an object.

    return $self;
}

=pod

=head2 enqueue

   Add an element to the tail of the queue.

=cut

sub enqueue {
    my $self = shift;		# Get object reference.
    my $item = shift;		# Get the item to enqueue...
    push(@$self, $item);		# Push the item to the back of the array.


}

=pod

=head2 dequeue

   Remove an element from the front of the queue.

=cut

sub dequeue {
    my $self = shift;		# Get object reference....
    return shift @$self;		# Remove from the front of the queue.
}


=pod  

=head1 Count

Returns number of items in a queue.

=cut

sub Count {
    my $self = shift;
    my $count = scalar(@$self);
    return $count;
}

1;

=pod

=head1 Theory

The queue is implemented as an array... enqueue is a thinly disguised
push, and dequeue is a thinly disguised shift.  This is probably quite
in efficient for large queues, but should be fine for reasonably sized
queues.

Note that since Perl is a dynamically typed language, queues can
contain objects of any data type and can even be heterogenously typed.

=cut
