# The LearningOnline Network with CAPA
# Build menu bar for Advanced RAT. Uses javascript code originally in
# static file: rat/client/code.html, now in  rat/client/ratcode.js  
#
# $Id: lonratmenu.pm,v 1.11 2009/04/23 17:31:25 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
package Apache::lonratmenu;

use strict;
use Apache::Constants qw(:common);
use Apache::File;
use Apache::loncommon;
use Apache::lonnet;

sub handler {
    my $r = shift;
    my $include = $Apache::lonnet::perlvar{'lonIncludes'};
    my $jsh=Apache::File->new($include."/ratcode.js");
    $r->send_http_header('text/html');
    my $js = join('',<$jsh>);
    my %loaditem = ('onunload' => "leave();",);
    my $start_page = 
	&Apache::loncommon::start_page('Advanced Editor',$js,
				       {'add_entries' => \%loaditem, 'suppress_header_logos' => 1});
    $r->print($start_page);
    my $readfile=$r->uri;
    $readfile=~s/\/loadonly\/adveditmenu$//;
    $r->print(&print_html($readfile));
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub print_html {
    my $readfile=shift;
    my $help=&Apache::loncommon::help_open_menu('Sequence_Advanced_Editor_Creation','Sequence_Advanced_Editor_Creation',6,'RAT');

    my $pagetext = <<"END";
<table border="0"><tr><td bgcolor="#AAAAAA">
<table border="0"><tr>
<td bgcolor="#ffffcc">$help</td>
<td bgcolor="#ffffcc"><a href="javascript:togglemode();"><font size="-2">Toggle display</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:if (zscale>1) { zscale--; draw();}"><font size="-2">Zoom out</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:if (zscale<3) { zscale++; draw();}"><font size="-2">Zoom in</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:condense();draw();"><font size="-2">Condense</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:graphopt();draw();"><font size="-2">Straighten</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:revert();"><font size="-2">Revert</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:undo();"><font size="-2">Undo</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:redo();"><font size="-2">Redo</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:groupopen('$readfile');"><font size="-2">Recover deleted</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:groupsearch();"><font size="-2">Search</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:groupimport();"><font size="-2">Import</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:bookmarkopen();"><font size="-2">Import Bookmarks</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:groupcopy();"><font size="-2">Copy</font></a></td>
<td bgcolor="#ffffcc"><a href="javascript:graphdef='no';save();storechange();"><font size="-2">Save map</font></a></td>
<td bgcolor="#ccffcc"><a href="javascript:storechange();"><font size="-2">Save map and layout</font></a></td>
</tr></table>
</td></tr></table>
<script type="text/javascript">
main();
</script>
END
    return $pagetext;
}

1;

