/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.util.ArrayUtil;

public final class Mmset {
    ModelSet modelSet;
    Properties modelSetProperties;
    Hashtable modelSetAuxiliaryInfo;
    private int modelCount = 0;
    private Properties[] modelProperties = new Properties[1];
    private Hashtable[] modelAuxiliaryInfo = new Hashtable[1];
    private Model[] models = new Model[1];
    private int structureCount = 0;
    private Structure[] structures = new Structure[10];

    Mmset(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    void merge(Mmset mmset) {
        for (int i = 0; i < mmset.modelCount; ++i) {
            this.models[i] = mmset.getModel(i);
            this.modelProperties[i] = mmset.getModelProperties(i);
            this.modelAuxiliaryInfo[i] = mmset.getModelAuxiliaryInfo(i);
        }
    }

    void defineStructure(int n, String string, char c, int n2, char c2, char c3, int n3, char c4) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.setLength((Object)this.structures, (int)(this.structureCount + 10));
        }
        this.structures[this.structureCount++] = new Structure(n, string, c, Group.getSeqcode(n2, c2), c3, Group.getSeqcode(n3, c4));
    }

    void clearStructures(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            if (!this.models[n].isPDB || bitSet.get(n)) continue;
            this.models[n].clearStructures();
        }
    }

    void calculateStructuresAllExcept(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            if (!this.models[n].isPDB || bitSet.get(n)) continue;
            this.models[n].calculateStructures();
        }
    }

    void setConformation(int n, BitSet bitSet) {
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            if (n2 != n && n >= 0) continue;
            this.models[n2].setConformation(bitSet);
        }
    }

    Hashtable getHeteroList(int n) {
        Hashtable hashtable = new Hashtable();
        boolean bl = false;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            Hashtable hashtable2;
            if (n >= 0 && n2 != n || (hashtable2 = (Hashtable)this.getModelAuxiliaryInfo(n2, "hetNames")) == null) continue;
            bl = true;
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                hashtable.put(string, hashtable2.get(string));
            }
        }
        return bl ? hashtable : (Hashtable)this.getModelSetAuxiliaryInfo("hetNames");
    }

    void freeze() {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].freeze();
        }
        this.propogateSecondaryStructure();
    }

    void setModelSetProperties(Properties properties) {
        this.modelSetProperties = properties;
    }

    void setModelSetAuxiliaryInfo(Hashtable hashtable) {
        this.modelSetAuxiliaryInfo = hashtable;
    }

    Properties getModelSetProperties() {
        return this.modelSetProperties;
    }

    Hashtable getModelSetAuxiliaryInfo() {
        return this.modelSetAuxiliaryInfo;
    }

    String getModelSetProperty(String string) {
        return this.modelSetProperties == null ? null : this.modelSetProperties.getProperty(string);
    }

    Object getModelSetAuxiliaryInfo(String string) {
        return this.modelSetAuxiliaryInfo == null ? null : this.modelSetAuxiliaryInfo.get(string);
    }

    boolean getModelSetAuxiliaryInfoBoolean(String string) {
        return this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string) && (Boolean)this.modelSetAuxiliaryInfo.get(string) != false;
    }

    int getModelSetAuxiliaryInfoInt(String string) {
        if (this.modelSetAuxiliaryInfo != null && this.modelSetAuxiliaryInfo.containsKey(string)) {
            return (Integer)this.modelSetAuxiliaryInfo.get(string);
        }
        return Integer.MIN_VALUE;
    }

    void setModelCount(int n) {
        if (this.modelCount != 0) {
            throw new NullPointerException();
        }
        this.modelCount = n;
        this.models = (Model[])ArrayUtil.setLength((Object)this.models, (int)n);
        this.modelProperties = (Properties[])ArrayUtil.setLength((Object)this.modelProperties, (int)n);
        this.modelAuxiliaryInfo = (Hashtable[])ArrayUtil.setLength((Object)this.modelAuxiliaryInfo, (int)n);
    }

    String getModelTitle(int n) {
        return this.models[n].modelTitle;
    }

    String getModelFile(int n) {
        return this.models[n].modelFile;
    }

    int getFirstAtomIndex(int n) {
        return this.models[n].firstAtomIndex;
    }

    void setFirstAtomIndex(int n, int n2) {
        this.models[n].firstAtomIndex = n2;
    }

    String getModelName(int n) {
        if (n < 0) {
            return this.getModelNumberDotted(-1 - n);
        }
        return this.models[n].modelTag;
    }

    String getModelNumberDotted(int n) {
        if (this.modelCount < 1) {
            return "";
        }
        return this.models[n].modelNumberDotted;
    }

    int getModelNumberIndex(int n, boolean bl) {
        if (bl) {
            for (int i = 0; i < this.modelCount; ++i) {
                if (this.models[i].modelNumber != n) continue;
                return i;
            }
            return -1;
        }
        for (int i = 0; i < this.modelCount; ++i) {
            if (this.models[i].modelFileNumber != n) continue;
            return i;
        }
        return -1;
    }

    int getModelNumber(int n) {
        return this.models[n].modelNumber;
    }

    int getModelFileNumber(int n) {
        return this.models[n].modelFileNumber;
    }

    Properties getModelProperties(int n) {
        return this.modelProperties[n];
    }

    String getModelProperty(int n, String string) {
        Properties properties = this.modelProperties[n];
        return properties == null ? null : properties.getProperty(string);
    }

    Hashtable getModelAuxiliaryInfo(int n) {
        return n < 0 ? null : this.modelAuxiliaryInfo[n];
    }

    void setModelAuxiliaryInfo(int n, Object object, Object object2) {
        this.modelAuxiliaryInfo[n].put(object, object2);
    }

    Object getModelAuxiliaryInfo(int n, String string) {
        if (n < 0) {
            return null;
        }
        Hashtable hashtable = this.modelAuxiliaryInfo[n];
        return hashtable == null ? null : hashtable.get(string);
    }

    boolean getModelAuxiliaryInfoBoolean(int n, String string) {
        Hashtable hashtable = this.modelAuxiliaryInfo[n];
        return hashtable != null && hashtable.containsKey(string) && (Boolean)hashtable.get(string) != false;
    }

    int getModelAuxiliaryInfoInt(int n, String string) {
        Hashtable hashtable = this.modelAuxiliaryInfo[n];
        if (hashtable != null && hashtable.containsKey(string)) {
            return (Integer)hashtable.get(string);
        }
        return Integer.MIN_VALUE;
    }

    Model getModel(int n) {
        return this.models[n];
    }

    int getNAltLocs(int n) {
        return this.models[n].nAltLocs;
    }

    int getNInsertions(int n) {
        return this.models[n].nInsertions;
    }

    boolean setModelNameNumberProperties(int n, String string, int n2, Properties properties, Hashtable hashtable, boolean bl) {
        this.modelProperties[n] = properties;
        this.modelAuxiliaryInfo[n] = hashtable;
        String string2 = (String)this.getModelAuxiliaryInfo(n, "title");
        String string3 = (String)this.getModelAuxiliaryInfo(n, "fileName");
        if (n2 != Integer.MAX_VALUE) {
            this.models[n] = new Model(this, n, n2, string, string2, string3);
        }
        String string4 = (String)this.getModelAuxiliaryInfo(n, "altLocs");
        this.models[n].setNAltLocs(string4 == null ? 0 : string4.length());
        string4 = (String)this.getModelAuxiliaryInfo(n, "insertionCodes");
        this.models[n].setNInsertions(string4 == null ? 0 : string4.length());
        this.models[n].isPDB = this.getModelAuxiliaryInfoBoolean(n, "isPDB");
        return this.models[n].isPDB;
    }

    void finalizeModelNumbers(int n) {
        int n2;
        if (this.modelCount == n) {
            return;
        }
        int n3 = 0;
        int n4 = -1;
        if (n > 0) {
            if (this.models[0].modelNumber < 1000000) {
                for (n2 = 0; n2 < n; ++n2) {
                    this.models[n2].modelNumber = 1000000 + n2 + 1;
                    this.models[n2].modelNumberDotted = "1." + (n2 + 1);
                    this.models[n2].modelTag = "" + this.models[n2].modelNumber;
                }
            }
            n3 = this.models[n - 1].modelNumber;
            n3 -= n3 % 1000000;
            if (this.models[n].modelNumber < 1000000) {
                n3 += 1000000;
            }
            for (n2 = n; n2 < this.modelCount; ++n2) {
                this.models[n2].modelNumber += n3;
                this.models[n2].modelNumberDotted = n3 / 1000000 + "." + n3 % 1000000;
                this.models[n2].modelTag = "" + this.models[n2].modelNumber;
            }
        }
        for (n2 = n; n2 < this.modelCount; ++n2) {
            String string;
            int n5 = this.models[n2].modelNumber / 1000000;
            if (n5 != n4) {
                n3 = 0;
                n4 = n5;
            }
            ++n3;
            if (n5 == 0) {
                string = "" + this.getModelNumber(n2);
                n5 = 1;
            } else {
                string = n5 + "." + n3;
            }
            this.models[n2].modelNumberDotted = string;
            this.models[n2].fileIndex = n5 - 1;
            this.models[n2].modelInFileIndex = n3 - 1;
            this.models[n2].modelFileNumber = n5 * 1000000 + n3;
        }
    }

    public static int modelFileNumberFromFloat(float f) {
        int n = (int)f;
        int n2 = (int)(((double)(f - (float)n) + 1.0E-5) * 10000.0);
        while (n2 % 10 == 0) {
            n2 /= 10;
        }
        return n * 1000000 + n2;
    }

    int getAltLocCountInModel(int n) {
        return this.models[n].nAltLocs;
    }

    private void propogateSecondaryStructure() {
        int n = this.structureCount;
        while (--n >= 0) {
            Structure structure = this.structures[n];
            int n2 = this.modelCount;
            while (--n2 >= 0) {
                if (structure.modelIndex != n2 && structure.modelIndex != -1) continue;
                this.models[n2].addSecondaryStructure(structure.type, structure.startChainID, structure.startSeqcode, structure.endChainID, structure.endSeqcode);
            }
        }
    }

    public int getModelCount() {
        return this.modelCount;
    }

    public Model[] getModels() {
        return this.models;
    }

    int getChainCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getChainCount();
        }
        return n;
    }

    public int getBioPolymerCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getBioPolymerCount();
        }
        return n;
    }

    int getBioPolymerCountInModel(int n) {
        if (n < 0) {
            return this.getBioPolymerCount();
        }
        return this.models[n].getBioPolymerCount();
    }

    int getChainCountInModel(int n) {
        if (n < 0) {
            return this.getChainCount();
        }
        return this.models[n].getChainCount();
    }

    int getGroupCount() {
        int n = 0;
        int n2 = this.modelCount;
        while (--n2 >= 0) {
            n += this.models[n2].getGroupCount();
        }
        return n;
    }

    int getGroupCountInModel(int n) {
        if (n < 0) {
            return this.getGroupCount();
        }
        return this.models[n].getGroupCount();
    }

    void calcSelectedGroupsCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedGroupsCount(bitSet);
        }
    }

    void calcSelectedMonomersCount(BitSet bitSet) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcSelectedMonomersCount(bitSet);
        }
    }

    void calcHydrogenBonds(BitSet bitSet, BitSet bitSet2) {
        int n = this.modelCount;
        while (--n >= 0) {
            this.models[n].calcHydrogenBonds(bitSet, bitSet2);
        }
    }

    void selectSeqcodeRange(int n, int n2, BitSet bitSet) {
        int n3 = this.modelCount;
        while (--n3 >= 0) {
            this.models[n3].selectSeqcodeRange(n, n2, bitSet);
        }
    }

    Vector getStructureInfo() {
        Vector<Hashtable> vector = new Vector<Hashtable>();
        for (int i = 0; i < this.structureCount; ++i) {
            vector.addElement(this.structures[i].toHashtable());
        }
        return vector;
    }

    static class Structure {
        String typeName;
        byte type;
        char startChainID;
        int startSeqcode;
        char endChainID;
        int endSeqcode;
        int modelIndex;

        Structure(int n, String string, char c, int n2, char c2, int n3) {
            this.modelIndex = n;
            this.typeName = string;
            this.startChainID = c;
            this.startSeqcode = n2;
            this.endChainID = c2;
            this.endSeqcode = n3;
            this.type = "helix".equals(string) ? (byte)3 : ("sheet".equals(string) ? (byte)2 : ("turn".equals(string) ? (byte)1 : 0));
        }

        Hashtable toHashtable() {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("type", this.typeName);
            hashtable.put("startChainID", this.startChainID + "");
            hashtable.put("startSeqcode", new Integer(this.startSeqcode));
            hashtable.put("endChainID", this.endChainID + "");
            hashtable.put("endSeqcode", new Integer(this.endSeqcode));
            return hashtable;
        }
    }
}

