# The LearningOnline Network with CAPA
# Perl script to render texxml files to a dvi
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
# 7-16-2002 Jeremy Bowers

use strict;
use Fcntl;
use POSIX qw(tmpnam);

if ( scalar(@ARGV) < 2 )
{
    print (<<USAGE);
Usage: $0 texxml_file_name or
       perl $0 -- texxml_file_name [epssource] [--with-filenames]
       where "texxml_file_name" optionally includes the extension
Output: texxml_file_name.dvi

$0 renders texxml files into dvi files by copying the tex file
resulting from from texxml2latex.pl and the referenced eps files
into a temporary directory and running LaTeX on the .tex file.

If a second argument is passed, it is used as the location of the 
.eps files the document uses.

Must be run as somebody with permissions to write temp files and 
access /home/httpd/html/adm/help/eps.

If thre is a second argument, it will be used as the path to the 
eps files, otherwise "../../loncom/html/adm/help/eps" is used.

If the optional argument --with-filenames is included then
the filename for each fragment is stuck into the finished file.
USAGE

    exit();
}

my $tmpdir = tmpnam();
my $fileroot = $ARGV[1];

if (substr($fileroot, -7) eq ".texxml")
{
    $fileroot = substr($fileroot, 0, -7);
}

my $epssource = "../../loncom/html/adm/help/eps";
# override eps source, for build on install
if ( $ARGV[2] && $ARGV[2] ne '--with-filenames') {
    $epssource = $ARGV[2];
}

my $include_filenames='';
if ( $ARGV[2] eq '--with-filenames' || $ARGV[3] eq '--with-filenames') {
    $include_filenames='--with-filenames';
}

#my $redir = ">& /dev/null"; # empty this for easier debugging
my $redir = "~/error_log.txt";
system("rm -f $redir");
$redir=">> $redir";

mkdir $tmpdir, 0755;

print "Converting texxml to tex...\n";
if (system ( "perl texxml2latex.pl $fileroot.texxml $include_filenames > $tmpdir/$fileroot.tex" )) {
    $! = 1;
    die "Terminated render because texxml2latex failed; see previous error message.";
};

print "Copying .eps files...\n";
system ( "cp $epssource/* $tmpdir/" );

print "Running Latex...\n";
system ( "cd $tmpdir; echo | latex $fileroot $redir; echo | latex $fileroot $redir; makeindex $fileroot.idx; echo | latex $fileroot\ $redir; " );

print "Running dvips...\n";
system ( "cd $tmpdir; dvips -Ppdf -G0 -f $fileroot.dvi > $fileroot.ps  " );

print "Copying ps file...\n";
system ( "cp $tmpdir/$fileroot.ps .");

print "Converting to PDF (may take a bit)...\n";
system ( "ps2pdf $fileroot.ps $fileroot.pdf" );

print "Rescuing log and tex file for debugging ...\n";
system ("cp $tmpdir/$fileroot.log ."); 
system ("cp $tmpdir/$fileroot.tex ."); 

print "Clearing temp directory...\n";
system ( "rm -rf $tmpdir" );

if ( -e $fileroot . ".ps" )
{
    print "$fileroot.ps and $fileroot.pdf are ready.\n";
}
else
{
    print "Generation of $fileroot.ps failed.\n";
}
