"""simpleEdit can be used to edit the tex fragments in context
determined by a texxml file.

Use:

python simpleEdit.py [name of texxml file]

simpleEdit will read the texxml file, and present the referenced tex
fragments in order determined by the file. When you save (CTRL-S),
simpleEdit will save all the tex fragments back to their little
files.

Very, very simple.
"""

import sys
if len(sys.argv) < 2:
    print "Usage: python simpleEdit.py [name of texxml file]"
    print "See top of source code for usage."
    print "To save files, press CTRL-s in the editor."
    sys.exit()

import xml.parsers.expat

dirprefix = "/home/httpd/html/adm/help/tex/"

fileList = []

def startElement(name, attrs):
    if name == "file":
        fileList.append(str(attrs["name"]))

p = xml.parsers.expat.ParserCreate()
p.StartElementHandler = startElement
f = file(sys.argv[1], 'r')
p.Parse(f.read())


from Tkinter import *
from ScrolledText import *
import string
import os

class simpleEditor:
    def __init__(self, master):
        self.frame = Frame(master)
        self.frame.pack()

        self.label = Label(self.frame, text = "For documentation on" 
                           "this program, consult the source code.")
        self.label.pack()

        self.text = ScrolledText(self.frame, width=120, height = 40);
        self.text.pack(fill = BOTH, expand = 1)

        self.searchText = Text(self.frame, width = 40, height = 1);
        self.searchText.pack()
        self.searchButton = Button(self.frame, text = "Search",
                                   command = self.search)
        self.searchButton.pack()

        self.button = Button(self.frame, text = "Save", \
                             command = self.save)
        self.button.pack()

    def search(self):
        searchText = self.searchText.get("1.0", END)
        searchText = searchText.strip()
        print self.text.index(INSERT + "+%ic" % len(searchText))
        pos = self.text.search(searchText,
                               self.searchText.index(INSERT) +
                               "+%ic" % (len(searchText) + 1))
        self.text.see(pos)
        self.text.tag_add(SEL, pos, pos + "+%ic" % len(searchText))
        self.text.mark_set(INSERT, pos)

    def load(self):
        """Loads in all the tex files."""

        colors = ["#FFFFFF", "#CCCCCC"]

        c = 0

        for f in fileList:
            f = file(dirprefix + f, 'r')
            tex = f.read()
            f.close()
            self.text.tag_config("texfile%i" % c,
                                 background = colors[c%len(colors)])
            self.text.insert(END, tex, "texfile%i" % c)
            self.text.insert(END, "\n\n") # prettier
            c += 1

    def save(self):
        c = 0
        
        for f in fileList:
            tex = self.text.get("texfile%i.first" % c,
                                "texfile%i.last" % c)
            os.rename ( dirprefix + f, dirprefix + f + "~" )
            f = file(dirprefix + f, 'w')
            f.write(tex)
            f.close()
            c += 1

            


root = Tk()
app = simpleEditor(root)
app.load()
root.mainloop()

