# The LearningOnline Network with CAPA
# The LON-CAPA Homework handler
#
# $Id: lonhomework.pm,v 1.310.4.1 2010/08/20 03:48:29 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/


package Apache::lonhomework;
use strict;
use Apache::style();
use Apache::lonxml();
use Apache::lonnet;
use Apache::lonplot();
use Apache::inputtags();
use Apache::structuretags();
use Apache::randomlabel();
use Apache::response();
use Apache::hint();
use Apache::outputtags();
use Apache::caparesponse();
use Apache::radiobuttonresponse();
use Apache::optionresponse();
use Apache::imageresponse();
use Apache::essayresponse();
use Apache::externalresponse();
use Apache::rankresponse();
use Apache::matchresponse();
use Apache::chemresponse();
use Apache::drawimage();
use Apache::Constants qw(:common);
use Apache::loncommon();
use Apache::lonlocal;
use Time::HiRes qw( gettimeofday tv_interval );
use HTML::Entities();
use File::Copy();

# FIXME - improve commenting


BEGIN {
    &Apache::lonxml::register_insert();
}


=pod

=item set_bubble_lines()

Called at analysis time to set the bubble lines
hash for the problem.. This should be called in the
end_problemtype tag in analysis mode.

We fetch the hash of part id counters from lonxml
    and push them into analyze:{part_id.bubble_lines}.

=cut

sub set_bubble_lines {
    my %bubble_counters = &Apache::lonxml::get_bubble_line_hash();

    foreach my $key (keys(%bubble_counters)) {
	$Apache::lonhomework::analyze{"$key.bubble_lines"} =
	    $bubble_counters{"$key"};
    }
}

#
# Decides what targets to render for.
# Implicit inputs:
#   Various session environment variables:
#      request.state -  published  - is a /res/ resource
#                       uploaded   - is a /uploaded/ resource
#                       contruct   - is a /priv/ resource
#      form.grade_target - a form parameter requesting a specific target
sub get_target {
    &Apache::lonxml::debug("request.state = $env{'request.state'}");
    if( defined($env{'form.grade_target'})) {
	&Apache::lonxml::debug("form.grade_target= $env{'form.grade_target'}");
    } else {
	&Apache::lonxml::debug("form.grade_target <undefined>");
    }
    if (($env{'request.state'} eq "published") ||
	($env{'request.state'} eq "uploaded")) {
	if ( defined($env{'form.grade_target'}  ) 
	     && ($env{'form.grade_target'} eq 'tex')) {
	    return ($env{'form.grade_target'});
	} elsif ( defined($env{'form.grade_target'}  ) 
		  && ($Apache::lonhomework::viewgrades eq 'F' )) {
	    return ($env{'form.grade_target'});
	} elsif ( $env{'form.grade_target'} eq 'webgrade'
		  && ($Apache::lonhomework::queuegrade eq 'F' )) {
	    return ($env{'form.grade_target'});
        } elsif ($env{'form.grade_target'} eq 'answer') {
            if ($env{'form.answer_output_mode'} eq 'tex') {
                return ($env{'form.grade_target'});
            }
        }
	if ($env{'form.webgrade'} &&
	    ($Apache::lonhomework::modifygrades eq 'F'
	     || $Apache::lonhomework::queuegrade eq 'F' )) {
	    return ('grade','webgrade');
	}
	if ( defined($env{'form.submitted'}) &&
	     ( !defined($env{'form.newrandomization'}))) {
	    return ('grade', 'web');
	} else {
	    return ('web');
	}
    } elsif ($env{'request.state'} eq "construct") {
	if ( defined($env{'form.grade_target'}) ) {
	    return ($env{'form.grade_target'});
	}
	if ( defined($env{'form.preview'})) {
	    if ( defined($env{'form.submitted'})) {
		return ('grade', 'web');
	    } else {
		return ('web');
	    }
	} else {
	    if ($env{'form.problemstate'} eq 'WEB_GRADE') {
		#$env{'form.webgrade'} = 'yes';
		return ('grade','webgrade','answer');
	    } elsif (($env{'form.problemmode'} eq 'view') ||
		     ($env{'form.problemmode'} eq 'discard')) {
		if ( defined($env{'form.submitted'}) &&
		     (!defined($env{'form.resetdata'})) &&
		     (!defined($env{'form.newrandomization'}))) {
		    return ('grade', 'web','answer');
		} else {
		    return ('web','answer');
		}
	    } elsif ($env{'form.problemmode'} eq 'edit') {
		if ( $env{'form.submitted'} eq 'edit' ) {
		    if ( $env{'form.submitbutton'} eq &mt('Save and View') ) {
			return ('modified','web','answer');
		    } else {
			return ('modified','no_output_web','edit');
		    }
		} else {
		    return ('no_output_web','edit');
		}
	    } else {
		return ('web');
	    }
	}
    }
    return ();
}

sub setup_vars {
    my ($target) = @_;
    return ';'
#  return ';$external::target='.$target.';';
}

sub createmenu {
    my ($which,$request)=@_;
    if ($which eq 'grade') {
	$request->print('<script type="text/javascript" language="JavaScript"> 
          hwkmenu=window.open("/res/adm/pages/homeworkmenu.html","homeworkremote",
                 "height=350,width=150,menubar=no");
          </script>');
    }
}

sub proctor_checked_in {
    my ($slot_name,$slot,$type)=@_;
    my @possible_proctors=split(",",$slot->{'proctor'});
    
    return 1 if (!@possible_proctors);

    my $key;
    if ($type eq 'Task') {
	my $version=$Apache::lonhomework::history{'resource.0.version'};
	$key ="resource.$version.0.checkedin";
    } elsif ($type eq 'problem') {
	$key ='resource.0.checkedin';
    }
    # backward compatability, used to be username@domain, 
    # now is username:domain
    my $who = $Apache::lonhomework::history{$key};
    if ($who !~ /:/) {
	$who =~ tr/@/:/;
    }     
    foreach my $possible (@possible_proctors) { 
	if ($who eq $possible
	    && $Apache::lonhomework::history{$key.'.slot'} eq $slot_name) {
	    return 1;
	}
    }
    
    return 0;
}

sub check_slot_access {
    my ($id,$type)=@_;

    # does it pass normal muster
    my ($status,$datemsg)=&check_access($id);
    
    my $useslots = &Apache::lonnet::EXT("resource.0.useslots");
    if ($useslots ne 'resource' && $useslots ne 'map' 
	&& $useslots ne 'map_map') {
	return ($status,$datemsg);
    }

    if ($status eq 'SHOW_ANSWER' ||
	$status eq 'CLOSED' ||
	$status eq 'INVALID_ACCESS' ||
	$status eq 'UNAVAILABLE') {
	return ($status,$datemsg);
    }
    if ($env{'request.state'} eq "construct") {
	return ($status,$datemsg);
    }
    
    if ($type eq 'Task') {
	my $version=$Apache::lonhomework::history{'resource.version'};
	if ($Apache::lonhomework::history{"resource.$version.0.checkedin"} &&
	    $Apache::lonhomework::history{"resource.$version.0.status"} eq 'pass') {
	    return ('SHOW_ANSWER');
	}
    }

    my $availablestudent = &Apache::lonnet::EXT("resource.0.availablestudent");
    my $available = &Apache::lonnet::EXT("resource.0.available");
    my @slots= (split(':',$availablestudent),split(':',$available));

#    if (!@slots) {
#	return ($status,$datemsg);
#    }
    my $slotstatus='NOT_IN_A_SLOT';
    my ($returned_slot,$slot_name);
    foreach my $slot (@slots) {
	$slot =~ s/(^\s*|\s*$)//g;
	&Apache::lonxml::debug("getting $slot");
	my %slot=&Apache::lonnet::get_slot($slot);
	&Apache::lonhomework::showhash(%slot);
	if ($slot{'starttime'} < time &&
	    $slot{'endtime'} > time &&
	    &Apache::loncommon::check_ip_acc($slot{'ip'})) {
	    &Apache::lonxml::debug("$slot is good");
	    $slotstatus='NEEDS_CHECKIN';
	    $returned_slot=\%slot;
	    $slot_name=$slot;
	    last;
	}
    }
    if ($slotstatus eq 'NEEDS_CHECKIN' &&
	&proctor_checked_in($slot_name,$returned_slot,$type)) {
	&Apache::lonxml::debug("protoctor checked in");
	$slotstatus='CAN_ANSWER';
    }

    my ($is_correct,$got_grade,$checkedin);
    if ($type eq 'Task') {
	my $version=$Apache::lonhomework::history{'resource.0.version'};
	$got_grade = 
	    ($Apache::lonhomework::history{"resource.$version.0.status"} 
	     =~ /^(?:pass|fail)$/);
	$is_correct =  
	    ($Apache::lonhomework::history{"resource.$version.0.status"} eq 'pass'
	     || $Apache::lonhomework::history{"resource.0.solved"} =~ /^correct_/ );
	$checkedin =
	    $Apache::lonhomework::history{"resource.$version.0.checkedin"};
    } elsif ($type eq 'problem') {
	$got_grade  = 1;
	$checkedin  = $Apache::lonhomework::history{"resource.0.checkedin"};
	$is_correct =
	    ($Apache::lonhomework::history{"resource.0.solved"} =~/^correct_/);
    }
    
    &Apache::lonxml::debug(" slot is $slotstatus checkedin ($checkedin) got_grade ($got_grade) is_correct ($is_correct)");
    
    # no slot is currently open, and has been checked in for this version
    # but hasn't got a grade, therefore must be awaiting a grade
    if (!defined($slot_name)
	&& $checkedin 
	&& !$got_grade) {
	return ('WAITING_FOR_GRADE');
    }

    # Previously used slot is no longer open, and has been checked in for this version.
    # However, the problem is not closed, and potentially, another slot might be
    # used to gain access to it to work on it, until the due date is reached, and the
    # problem then becomes CLOSED.  Therefore return the slotstatus - 
    # (which will be NOT_IN_SLOT).
    if (!defined($slot_name)
	&& $checkedin 
	&& $type eq 'problem') {
        return ($slotstatus);
    }

    if ($slotstatus eq 'NOT_IN_A_SLOT' 
	&& $checkedin ) {

	if ($got_grade) {
	    return ('SHOW_ANSWER');
	} else {
	    return ('WAITING_FOR_GRADE');
	}

    }

    if ( $is_correct) {
	if ($type eq 'problem') {
	    return ($status);
	}
	return ('SHOW_ANSWER');
    }

    if ( $status eq 'CANNOT_ANSWER' && 
	 ($slotstatus ne 'NEEDS_CHECKIN' && $slotstatus ne 'NOT_IN_A_SLOT')) {
	return ($status,$datemsg);
    }

    return ($slotstatus,$datemsg,$slot_name,$returned_slot);
}

# JB, 9/24/2002: Any changes in this function may require a change
# in lonnavmaps::resource::getDateStatus.
sub check_access {
    my ($id) = @_;
    my $date ='';
    my $status;
    my $datemsg = '';
    my $lastdate = '';
    my $type;
    my $passed;

    if ($env{'request.state'} eq "construct") {
	if ($env{'form.problemstate'}) {
	    if ($env{'form.problemstate'} =~ /^CANNOT_ANSWER/) {
		if ( ! ($env{'form.problemstate'} eq 'CANNOT_ANSWER_correct' 
			&& &hide_problem_status())) {
		    return ('CANNOT_ANSWER',
			    &mt('is in this state due to author settings.'));
		}
	    } else {
		return ($env{'form.problemstate'},
			&mt('is in this state due to author settings.'));
	    }
	}
	&Apache::lonxml::debug("in construction ignoring dates");
	$status='CAN_ANSWER';
	$datemsg=&mt('is in under construction');
#	return ($status,$datemsg);
    }

    &Apache::lonxml::debug("checking for part :$id:");
    &Apache::lonxml::debug("time:".time);

    my ($symb)=&Apache::lonnet::whichuser();
    &Apache::lonxml::debug("symb:".$symb);
    #if ($env{'request.state'} ne "construct" && $symb ne '') {
    if ($env{'request.state'} ne "construct") {
        my $idacc = &Apache::lonnet::EXT("resource.$id.acc");
	my $allowed=&Apache::loncommon::check_ip_acc($idacc);
	if (!$allowed && ($Apache::lonhomework::browse ne 'F')) {
	    $status='INVALID_ACCESS';
	    $date=&mt("can not be accessed from your location.");
	    return($status,$date);
	}
	
	foreach my $temp ("opendate","duedate","answerdate") {
	    $lastdate = $date;
	    if ($temp eq 'duedate') {
		$date = &due_date($id);
	    } else {
		$date = &Apache::lonnet::EXT("resource.$id.$temp");
	    }
	    
	    my $thistype = &Apache::lonnet::EXT("resource.$id.$temp.type");
	    if ($thistype =~ /^(con_lost|no_such_host)/ ||
		$date     =~ /^(con_lost|no_such_host)/) {
		$status='UNAVAILABLE';
		$date=&mt("may open later.");
		return($status,$date);
	    }
	    if ($thistype eq 'date_interval') {
		if ($temp eq 'opendate') {
		    $date=&Apache::lonnet::EXT("resource.$id.duedate")-$date;
		}
		if ($temp eq 'answerdate') {
		    $date=&Apache::lonnet::EXT("resource.$id.duedate")+$date;
		}
	    }
	    &Apache::lonxml::debug("found :$date: for :$temp:");
	    if ($date eq '') {
		$date = &mt("an unknown date"); $passed = 0;
	    } elsif ($date eq 'con_lost') {
		$date = &mt("an indeterminate date"); $passed = 0;
	    } else {
		if (time < $date) { $passed = 0; } else { $passed = 1; }
		$date = &Apache::lonlocal::locallocaltime($date);
	    }
	    if (!$passed) { $type=$temp; last; }
	}
	&Apache::lonxml::debug("have :$type:$passed:");
	if ($passed) {
	    $status='SHOW_ANSWER';
	    $datemsg=$date;
	} elsif ($type eq 'opendate') {
	    $status='CLOSED';
	    $datemsg = &mt("will open on")." $date";
	} elsif ($type eq 'duedate') {
	    $status='CAN_ANSWER';
	    $datemsg = &mt("is due at")." $date";
	} elsif ($type eq 'answerdate') {
	    $status='CLOSED';
	    $datemsg = &mt("was due on")." $lastdate".&mt(", and answers will be available on")." $date";
	}
    }
    if ($status eq 'CAN_ANSWER' ||
	(($Apache::lonhomework::browse eq 'F') && ($status eq 'CLOSED'))) {
	#check #tries, and if correct.
	my $tries = $Apache::lonhomework::history{"resource.$id.tries"};
	my $maxtries = &Apache::lonnet::EXT("resource.$id.maxtries");
	if ( $tries eq '' ) { $tries = '0'; }
	if ( $maxtries eq '' && 
	     $env{'request.state'} ne 'construct') { $maxtries = '2'; } 
	if ($maxtries && $tries >= $maxtries) { $status = 'CANNOT_ANSWER'; }
	# if (correct and show prob status) or excused then CANNOT_ANSWER
	if(($Apache::lonhomework::history{"resource.$id.solved"}=~/^correct/
	    &&
	    &show_problem_status())
	   ||
	   $Apache::lonhomework::history{"resource.$id.solved"}=~/^excused/) {
	    $status = 'CANNOT_ANSWER';
	}
	if ($status eq 'CANNOT_ANSWER'
	    && &show_answer_problem_status()) {
	    $status = 'SHOW_ANSWER';
	}
    }
    if ($status eq 'CAN_ANSWER' || $status eq 'CANNOT_ANSWER') {
	my @interval=&Apache::lonnet::EXT("resource.$id.interval");
	&Apache::lonxml::debug("looking for interval @interval");
	if ($interval[0]) {
	    my $first_access=&Apache::lonnet::get_first_access($interval[1]);
	    &Apache::lonxml::debug("looking for accesstime $first_access");
	    if (!$first_access) {
		$status='NOT_YET_VIEWED';
		my $due_date = &due_date($id);
		my $seconds_left = $due_date - time;
		if ($seconds_left > $interval[0] || $due_date eq '') {
		    $seconds_left = $interval[0];
		}
		$datemsg=&seconds_to_human_length($seconds_left);
	    }
	}
    }

  #if (($status ne 'CLOSED') && ($Apache::lonhomework::type eq 'exam') &&
  #    (!$Apache::lonhomework::history{"resource.0.outtoken"})) {
  #    return ('UNCHECKEDOUT','needs to be checked out');
  #}


    &Apache::lonxml::debug("sending back :$status:$datemsg:");
    if (($Apache::lonhomework::browse eq 'F') && ($status eq 'CLOSED')) {
	&Apache::lonxml::debug("should be allowed to browse a resource when closed");
	$status='CAN_ANSWER';
	$datemsg=&mt('is closed but you are allowed to view it');
    }

    return ($status,$datemsg);
}
# this should work exactly like the copy in lonnavmaps.pm
sub due_date {
    my ($part_id,$symb,$udom,$uname)=@_;
    my $date;
    my @interval= &Apache::lonnet::EXT("resource.$part_id.interval",$symb,
				       $udom,$uname);
    &Apache::lonxml::debug("looking for interval $part_id $symb @interval");
    my $due_date= &Apache::lonnet::EXT("resource.$part_id.duedate",$symb,
				       $udom,$uname);
    &Apache::lonxml::debug("looking for due_date $part_id $symb $due_date");
    if ($interval[0] =~ /\d+/) {
	my $first_access=&Apache::lonnet::get_first_access($interval[1],$symb);
	&Apache::lonxml::debug("looking for first_access $first_access ($interval[1])");
	if (defined($first_access)) {
	    my $interval = $first_access+$interval[0];
	    $date = (!$due_date || $interval < $due_date) ? $interval
                                                          : $due_date;
	} else {
	    $date = $due_date;
	}
    } else {
	$date = $due_date;
    }
    return $date
}

sub seconds_to_human_length {
    my ($length)=@_;

    my $seconds=$length%60; $length=int($length/60);
    my $minutes=$length%60; $length=int($length/60);
    my $hours=$length%24;   $length=int($length/24);
    my $days=$length;

    my $timestr;
    if ($days > 0) { $timestr.=&mt('[quant,_1,day]',$days); }
    if ($hours > 0) { $timestr.=($timestr?", ":"").
			  &mt('[quant,_1,hour]',$hours); }
    if ($minutes > 0) { $timestr.=($timestr?", ":"").
			    &mt('[quant,_1,minute]',$minutes); }
    if ($seconds > 0) { $timestr.=($timestr?", ":"").
			    &mt('[quant,_1,second]',$seconds); }
    return $timestr;
}

sub showhash {
    my (%hash) = @_;
    &showhashsubset(\%hash,'.');
    return '';
}

sub showarray {
    my ($array)=@_;
    my $string="(";
    foreach my $elm (@{ $array }) {
	if (ref($elm) eq 'ARRAY') {
	    $string.=&showarray($elm);
	} elsif (ref($elm) eq 'HASH') {
	    $string.= "HASH --- \n<br />";
	    $string.= &showhashsubset($elm,'.');
	} else {
	    $string.="$elm,"
	}
    }
    chop($string);
    $string.=")";
    return $string;
}

sub showhashsubset {
    my ($hash,$keyre) = @_;
    my $resultkey;
    foreach $resultkey (sort keys %$hash) {
	if ($resultkey !~ /$keyre/) { next; }
	if (ref($$hash{$resultkey})  eq 'ARRAY' ) {
	    &Apache::lonxml::debug("$resultkey ---- ".
				   &showarray($$hash{$resultkey}));
	} elsif (ref($$hash{$resultkey}) eq 'HASH' ) {
	    &Apache::lonxml::debug("$resultkey ---- $$hash{$resultkey}");
	    &showhashsubset($$hash{$resultkey},'.');
	} else {
	    &Apache::lonxml::debug("$resultkey ---- $$hash{$resultkey}");
	}
    }
    &Apache::lonxml::debug("\n<br />restored values^</br>\n");
    return '';
}

sub setuppermissions {
    $Apache::lonhomework::browse= &Apache::lonnet::allowed('bre',$env{'request.filename'});
    my $viewgrades = &Apache::lonnet::allowed('vgr',$env{'request.course.id'});
    if (! $viewgrades && 
	exists($env{'request.course.sec'}) && 
	$env{'request.course.sec'} !~ /^\s*$/) {
	$viewgrades = &Apache::lonnet::allowed('vgr',$env{'request.course.id'}.
                                               '/'.$env{'request.course.sec'});
    }
    $Apache::lonhomework::viewgrades = $viewgrades;

    if ($Apache::lonhomework::browse eq 'F' && 
	$env{'form.devalidatecourseresdata'} eq 'on') {
	my (undef,$courseid) = &Apache::lonnet::whichuser();
	&Apache::lonnet::devalidatecourseresdata($env{"course.$courseid.num"},
					      $env{"course.$courseid.domain"});
    }

    my $modifygrades = &Apache::lonnet::allowed('mgr',$env{'request.course.id'});
    if (! $modifygrades && 
	exists($env{'request.course.sec'}) && 
	$env{'request.course.sec'} !~ /^\s*$/) {
	$modifygrades = 
	    &Apache::lonnet::allowed('mgr',$env{'request.course.id'}.
				     '/'.$env{'request.course.sec'});
    }
    $Apache::lonhomework::modifygrades = $modifygrades;

    my $queuegrade = &Apache::lonnet::allowed('mqg',$env{'request.course.id'});
    if (! $queuegrade && 
	exists($env{'request.course.sec'}) && 
	$env{'request.course.sec'} !~ /^\s*$/) {
	$queuegrade = 
	    &Apache::lonnet::allowed('qgr',$env{'request.course.id'}.
				     '/'.$env{'request.course.sec'});
    }
    $Apache::lonhomework::queuegrade = $queuegrade;
    return '';
}

sub unset_permissions {
    undef($Apache::lonhomework::queuegrade);
    undef($Apache::lonhomework::modifygrades);
    undef($Apache::lonhomework::viewgrades);
    undef($Apache::lonhomework::browse);
}

sub setupheader {
    my $request=$_[0];
    &Apache::loncommon::content_type($request,'text/html');
    if (!$Apache::lonxml::debug && ($ENV{'REQUEST_METHOD'} eq 'GET')) {
	&Apache::loncommon::no_cache($request);
    }
#    $request->set_last_modified(&Apache::lonnet::metadata($request->uri,
#							  'lastrevisiondate'));
    $request->send_http_header;
    return OK if $request->header_only;
    return ''
}

sub handle_save_or_undo {
    my ($request,$problem,$result) = @_;
    my $file    = &Apache::lonnet::filelocation("",$request->uri);
    my $filebak =$file.".bak";
    my $filetmp =$file.".tmp";
    my $error=0;
    if ($env{'form.Undo'} eq &mt('undo')) {
	my $error=0;
	if (!&File::Copy::copy($file,$filetmp)) { $error=1; }
	if ((!$error) && (!&File::Copy::copy($filebak,$file))) { $error=1; }
	if ((!$error) && (!&File::Copy::move($filetmp,$filebak))) { $error=1; }
	if (!$error) {
	    &Apache::lonxml::info("<p><b>".
				  &mt("Undid changes, Switched [_1] and [_2]",
				      '<span class="LC_filename">'.$filebak.
				      '</span>',
				      '<span class="LC_filename">'.$file.
				      '</span>')."</b></p>");
	} else {
	    &Apache::lonxml::info("<p><span class=\"LC_error\">".
				  &mt("Unable to undo, unable to switch [_1] and [_2]",
				      '<span class="LC_filename">'.
				      $filebak.'</span>',
				      '<span class="LC_filename">'.
				      $file.'</span>')."</span></p>");
	    $error=1;
	}
    } else {
        &Apache::lonnet::correct_line_ends($result);
	my $fs=Apache::File->new(">$filebak");
	if (defined($fs)) {
	    print $fs $$problem;
	} else {
	    &Apache::lonxml::info("<span class=\"LC_error\">".
				  &mt("Unable to make backup [_1]",
				      '<span class="LC_filename">'.
				      $filebak.'</span>')."</span>");
	    $error=2;
	}
	my $fh=Apache::File->new(">$file");
	if (defined($fh)) {
	    print $fh $$result;
	} else {
	    &Apache::lonxml::info('<span class="LC_error">'.
				  &mt("Unable to write to [_1]",
				      '<span class="LC_filename">'.
				      $file.'</span>').
				  '</span>');
	    $error|=4;
	}
    }
    return $error;
}

sub analyze_header {
    my ($request) = @_;
    my $js = &Apache::structuretags::setmode_javascript();
    my $result =
	&Apache::loncommon::start_page('Analyzing a problem',$js);

    $result .= 
	&Apache::lonxml::message_location().'
            <form name="lonhomework" method="post" action="'.
	    &HTML::Entities::encode($env{'request.uri'},'<>&"').'">'.
            '<input type="hidden" name="problemmode" value="'.
            $env{'form.problemmode'}.'" />'.
	    &Apache::structuretags::remember_problem_state().'
            <div class="LC_edit_problem_analyze_header">
            <input type="button" name="submitmode" value="'.&mt("EditXML").'" '.
            'onclick="javascript:setmode(this.form,'."'editxml'".')" />
            <input type="button" name="submitmode" value="'.&mt('Edit').'" '.
            'onclick="javascript:setmode(this.form,'."'edit'".')" />
            <hr class="LC_edit_problem_divide" />
            <input type="button" name="submitmode" value="'.&mt("View").'" '.
            'onclick="javascript:setmode(this.form,'."'view'".')" />
            <hr class="LC_edit_problem_divide" />
            </div>
            </form>';
    &Apache::lonxml::add_messages(\$result);
    $request->print($result);
    $request->rflush();
}

sub analyze_footer {
    my ($request) = @_;
    $request->print(&Apache::loncommon::end_page());
    $request->rflush();
}

sub analyze {
    my ($request,$file) = @_;
    &Apache::lonxml::debug("Analyze");
    my $result;
    my %overall;
    my %seedexample;
    my %allparts;
    my $rndseed=$env{'form.rndseed'};
    &analyze_header($request);
    my %prog_state=
	&Apache::lonhtmlcommon::Create_PrgWin($request,&mt('Analyze Progress'),
					      &mt('Getting Problem Variants'),
					      $env{'form.numtoanalyze'},
					      'inline',undef);
    for(my $i=1;$i<$env{'form.numtoanalyze'}+1;$i++) {
	&Apache::lonhtmlcommon::Increment_PrgWin($request,\%prog_state,
						 &mt('last problem'));
	if (&Apache::loncommon::connection_aborted($request)) { return; }
        my $thisseed=$i+$rndseed;
	my $subresult=&Apache::lonnet::ssi($request->uri,
					   ('grade_target' => 'analyze'),
					   ('rndseed' => $thisseed));
	(my $garbage,$subresult)=split(/_HASH_REF__/,$subresult,2);
	my %analyze=&Apache::lonnet::str2hash($subresult);
	my @parts;
	if (defined(@{ $analyze{'parts'} })) {
	    @parts=@{ $analyze{'parts'} };
	}
	foreach my $part (@parts) {
	    if (!exists($allparts{$part})) {$allparts{$part}=1;};
	    if ($analyze{$part.'.type'} eq 'numericalresponse'	||
		$analyze{$part.'.type'} eq 'stringresponse'	||
		$analyze{$part.'.type'} eq 'formularesponse'   ) {
		foreach my $name (keys(%{ $analyze{$part.'.answer'} })) {
		    my $i=0;
		    foreach my $answer_part (@{ $analyze{$part.'.answer'}{$name} }) {
			push( @{ $overall{$part.'.answer'}[$i] },
			      $answer_part);
			my $concatanswer= join("\0",@{ $answer_part });
			if (($concatanswer eq '') || ($concatanswer=~/^\@/)) {
			    $answer_part = ['<span class="LC_error">'.&mt('Error').'</span>'];
			}
			$seedexample{join("\0",$part,$i,@{$answer_part})}=
			    $thisseed;
			$i++;
		    }
		}
		if (!keys(%{ $analyze{$part.'.answer'} })) {
		    my $answer_part = 
			['<span class="LC_error">'.&mt('Error').'</span>'];
		    $seedexample{join("\0",$part,0,@{$answer_part})}=
			$thisseed;
		    push( @{ $overall{$part.'.answer'}[0] },
			  $answer_part);
		}
	    }
	}
    }
    &Apache::lonhtmlcommon::Update_PrgWin($request,\%prog_state,
					  &mt('Analyzing Results'));
    $request->print('<hr class="LC_edit_problem_divide" />'
                   .'<h3>'
                   .&mt('List of possible answers')
                   .'</h3>'
    );
    foreach my $part (sort(keys(%allparts))) {
	if (defined(@{ $overall{$part.'.answer'} })) {
	    for (my $i=0;$i<scalar(@{ $overall{$part.'.answer'} });$i++) {
		my $num_cols=scalar(@{ $overall{$part.'.answer'}[$i][0] });
                $request->print(&Apache::loncommon::start_data_table()
                               .&Apache::loncommon::start_data_table_header_row()
                               .'<th colspan="'.($num_cols+1).'">'
                               .&mt('Part').' '.$part
                );
		if (scalar(@{ $overall{$part.'.answer'} }) > 1) {
		    $request->print(' '.&mt('Answer [_1]',$i+1));
		}
		$request->print('</th>'
                               .&Apache::loncommon::end_data_table_header_row()
                );
		my %frequency;
		foreach my $answer (sort {$a->[0] <=> $b->[0]} (@{ $overall{$part.'.answer'}[$i] })) {
		    $frequency{join("\0",@{ $answer })}++;
		}
                $request->print(&Apache::loncommon::start_data_table_header_row()
                               .'<th colspan="'.($num_cols).'">'.&mt('Answer').'</th>'
                               .'<th>'.&mt('Frequency').'<br />'
                               .'('.&mt('click for example').')</th>'
                               .&Apache::loncommon::end_data_table_header_row()
                );
		foreach my $answer (sort {(split("\0",$a))[0] <=> (split("\0",$b))[0]} (keys(%frequency))) {
                    $request->print(&Apache::loncommon::start_data_table_row()
                                   .'<td>'
                                   .join('</td><td>',split("\0",$answer))
				   .'</td>'
                                   .'<td>'
                                   .'<a href="'.$request->uri.'?rndseed='.$seedexample{join("\0",$part,$i,$answer)}.'">'.$frequency{$answer}.'</a>'
				   .'</td>'
                                   .&Apache::loncommon::end_data_table_row()
                    );
		}
                $request->print(&Apache::loncommon::end_data_table());
	    }
	} else {
            $request->print('<p class="LC_warning">'
                           .&mt('Response [_1] is not analyzable at this time.',$part)
			   .'</p>'
            );
	}
    }
    if (scalar(keys(%allparts)) == 0 ) {
        $request->print('<p class="LC_warning">'
                       .&mt('Found no analyzable responses in this problem.'
                           .' Currently only Numerical, Formula and String response styles are supported.')
                       .'</p>'
        );
    }
    &Apache::lonhtmlcommon::Close_PrgWin($request,\%prog_state);
    &analyze_footer($request);
    &Apache::lonhomework::showhash(%overall);
    return $result;
}

{
    my $show_problem_status;
    sub reset_show_problem_status {
	undef($show_problem_status);
    }

    sub set_show_problem_status {
	my ($new_status) = @_;
	$show_problem_status = lc($new_status);
    }

    sub hide_problem_status {
	return ($show_problem_status eq 'no'
		|| $show_problem_status eq 'no_feedback_ever');
    }

    sub show_problem_status {
	return ($show_problem_status eq 'yes'
		|| $show_problem_status eq 'answer'
		|| $show_problem_status eq '');
    }
    
    sub show_some_problem_status {
	return ($show_problem_status eq 'no');
    }

    sub show_no_problem_status {
	return ($show_problem_status eq 'no_feedback_ever');
    }
  
    sub show_answer_problem_status {
	return ($show_problem_status eq 'answer');
    }
}

sub editxmlmode {
    my ($request,$file) = @_;
    my $result;
    my $problem=&Apache::lonnet::getfile($file);
    if ($problem eq -1) {
	&Apache::lonxml::error(
            '<b> '
           .&mt('Unable to find [_1]',
                '<span class="LC_filename">'.$file.'</span>')
           .'</b>');

	$problem='';
    }
    if (defined($env{'form.editxmltext'}) || defined($env{'form.Undo'})) {
	my $error=&handle_save_or_undo($request,\$problem,
				       \$env{'form.editxmltext'});
	if (!$error) { $problem=&Apache::lonnet::getfile($file); }
    }
    &Apache::lonhomework::showhashsubset(\%env,'^form');
    if ( $env{'form.submitbutton'} eq &mt('Save and View') ) {
	&Apache::lonhomework::showhashsubset(\%env,'^form');
	$env{'form.problemmode'}='view';
	&renderpage($request,$file);
    } else {
	my ($rows,$cols) = &Apache::edit::textarea_sizes(\$problem);
	if ($cols > 80) { $cols = 80; }
	if ($cols < 70) { $cols = 70; }
	if ($rows < 20) { $rows = 20; }
	my $js =
	    &Apache::edit::js_change_detection(). 
	    &Apache::loncommon::resize_textarea_js().
            &Apache::structuretags::setmode_javascript().
            &Apache::lonhtmlcommon::dragmath_js("EditMathPopup");
	my $only_body =  ($env{'environment.remote'} eq 'off')? 0 : 1;
	my $dragmath_button = 
            &Apache::lonhtmlcommon::dragmath_button("LC_editxmltext",1);
	my $start_page = 
	    &Apache::loncommon::start_page(&mt("EditXML [_1]",$file),$js,
					   {'no_auto_mt_title' => 1,
					    'only_body'        => $only_body,
					    'add_entries'      => {
						'onresize' => q[resize_textarea('LC_editxmltext','LC_aftertextarea')],
						'onload'   => q[resize_textarea('LC_editxmltext','LC_aftertextarea')],
				    }});
	$result.=$start_page.
	    &renderpage($request,$file,['no_output_web'],1).
            '<form '.&Apache::edit::form_change_detection().' name="lonhomework" method="post" action="'.
	    &HTML::Entities::encode($env{'request.uri'},'<>&"').'">'.
	    &Apache::structuretags::remember_problem_state().'
            <div class="LC_edit_problem_editxml_header">
              <table class="LC_edit_problem_header_title"><tr><td>
               '.&mt('Problem Editing').&Apache::loncommon::help_open_topic('Problem_Editor_XML_Index').'
                </td><td align="right">
                  '.&Apache::loncommon::helpLatexCheatsheet('Problem_LON-CAPA_Functions','Script Functions').'
                </td></tr>
              </table>
              <div class="LC_edit_problem_discards">
                <input type="hidden" name="problemmode" value="editxml" />

                <input type="button" name="submitmode" accesskey="d" value="'.&mt('Discard Edits and View').'" '.
                'onclick="javascript:setmode(this.form,'."'discard'".')" />
                <input type="button" '.&Apache::edit::submit_ask_anyway('setmode(this.form,'."'edit'".')').'name="submitmode" accesskey="e" value="'.&mt('Edit').'" />
                <input type="submit" name="Undo" accesskey="u" value="'.&mt('undo').'" />
                '.$dragmath_button.'
              </div>
              <div class="LC_edit_problem_saves">
                <input type="submit" name="submitbutton" accesskey="s" value="'.&mt('Save').'"  />
                <input type="submit" name="submitbutton" accesskey="v" value="'.&mt('Save and View').'" />
              </div>
              <hr class="LC_edit_problem_divide" />
	      '.&Apache::lonxml::message_location().'
            </div>
            '  . '
            <textarea '.&Apache::edit::element_change_detection().
	              ' rows="'.$rows.'" cols="'.$cols.'" style="width:100%" '.
		      ' name="editxmltext" id="LC_editxmltext">'.
		      &HTML::Entities::encode($problem,'<>&"').'</textarea>
            <div id="LC_aftertextarea">
            </div>
            </form>'.&Apache::loncommon::end_page();
	&Apache::lonxml::add_messages(\$result);
	$request->print($result);
    }
    return '';
}

#
#    Render the page in whatever target desired.
#
sub renderpage {
    my ($request,$file,$targets,$return_string) = @_;

    my @targets = @{$targets || [&get_target()]};
    &Apache::lonhomework::showhashsubset(\%env,'form.');
    &Apache::lonxml::debug("Running targets ".join(':',@targets));

    my $overall_result;
    foreach my $target (@targets) {
	# FIXME need to do something intelligent when a problem goes
        # from viewable to not viewable due to map conditions
	#&setuppermissions();
	#if (   $Apache::lonhomework::browse ne '2'
	#    && $Apache::lonhomework::browse ne 'F' ) {
	#    $request->print(" You most likely shouldn't see me.");
	#}
	#my $t0 = [&gettimeofday()];
	my $output=1;
	if ($target eq 'no_output_web') {
	    $target = 'web'; $output=0;
	}
	my $problem=&Apache::lonnet::getfile($file);
	my $result;
	if ($problem eq -1) {
	    $problem='';
	    my $filename=(split('/',$file))[-1];
	    my $error =
		"<b> ".&mt('Unable to find [_1]',
			   '<span class="LC_filename">'.$filename.'</span>')
		."</b>";
	    $result.=
		&Apache::loncommon::simple_error_page($request,'Not available',
						      $error);
	    return;
	}

	my %mystyle;
	if ($target eq 'analyze') { %Apache::lonhomework::analyze=(); }
	if ($target eq 'answer') { &showhash(%Apache::lonhomework::history); }
	if ($target eq 'web') {&Apache::lonhomework::showhashsubset(\%env,'^form');}

	&Apache::lonxml::debug("Should be parsing now");
	$result .= &Apache::lonxml::xmlparse($request, $target, $problem,
					     &setup_vars($target),%mystyle);
	&finished_parsing();
	if (!$output) { $result = ''; }
	#$request->print("Result follows:");
	if ($target eq 'modified') {
	    &handle_save_or_undo($request,\$problem,\$result);
	} else {
	    if ($target eq 'analyze') {
		$result=&Apache::lonnet::hashref2str(\%Apache::lonhomework::analyze);
		undef(%Apache::lonhomework::analyze);
	    }
	    #my $td=&tv_interval($t0);
	    #if ( $Apache::lonxml::debug) {
	    #$result =~ s:</body>::;
	    #$result.="<br />Spent $td seconds processing target $target\n</body>";
	    #}
#	    $request->print($result);
	    $overall_result.=$result;
#	    $request->rflush();
	}
	#$request->print(":Result ends");
	#my $td=&tv_interval($t0);
    }
    if (!$return_string) {
	&Apache::lonxml::add_messages(\$overall_result);
	$request->print($overall_result);   
	$request->rflush();   
    } else {
	return $overall_result;
    }
}

sub finished_parsing {
    undef($Apache::lonhomework::parsing_a_problem);
    undef($Apache::lonhomework::parsing_a_task);
}

sub get_template_list {
    my ($extension) = @_;
    my $result;
    my @allnames;
    &Apache::lonxml::debug("Looking for :$extension:");
    my $glob_extension  = $extension;
    if ($extension eq 'survey' || $extension eq 'exam') {
	$glob_extension = 'problem';
    }
    my @files = glob($Apache::lonnet::perlvar{'lonIncludes'}.
		     '/templates/*.'.$glob_extension);
    @files = map {[$_,&mt(&Apache::lonnet::metadata($_, 'title')),
                      (&Apache::lonnet::metadata($_, 'category')?&mt(&Apache::lonnet::metadata($_, 'category')):&mt('Miscellaneous')),
                      &mt(&Apache::lonnet::metadata($_, 'help'))]} (@files);
    @files = sort {$a->[2].$a->[1] cmp $b->[2].$b->[1]} (@files);
    my ($midpoint,$seconddiv,$numfiles);
    $numfiles = 0;
    foreach my $file (@files) {
        next if ($file->[1] !~ /\S/);
        $numfiles ++;
    }
    if ($numfiles > 0) {
        $result = '<div class="LC_left_float">';
        $midpoint = int($numfiles/2);
        if ($numfiles%2) {
            $midpoint ++;
        }
    }
    my $count = 0;
    my $currentcategory='';
    foreach my $file (@files) {
	next if ($file->[1] !~ /\S/);
        if ($file->[2] ne $currentcategory) {
           $currentcategory=$file->[2];
           if ((!$seconddiv) && ($count >= $midpoint)) {
               $result .= '</div>'."\n".'<div class="LC_left_float">'."\n";
               $seconddiv = 1;
           }
           $result.='<h3>'.$currentcategory.'</h3>';
           $count++;
        }
	$result .=
	    '<label><input type="radio" name="template" value="'.$file->[0].'" />'.
	    $file->[1].'</label>';
        if ($file->[3]) {
           $result.=&Apache::loncommon::help_open_topic($file->[3]);
        }
        my $filename=$file->[0];
        $filename=~s/^\/home\/httpd\/html//;
        $result.=' <font size="-2"><a href="'.$filename.'" target="sample">'.&mt('Example').'</font></a><br />'."\n";
        $count ++;
    }
    if ($numfiles > 0) {
        $result .= '</div>'."\n".'<div class="LC_clear_float_footer"></div>'."\n";
    }
    return $result;
}

sub newproblem {
    my ($request) = @_;

    if ($env{'form.template'}) {
	my $file = $env{'form.template'};
	my $dest = &Apache::lonnet::filelocation("",$request->uri);
	&File::Copy::copy($file,$dest);
	&renderpage($request,$dest);
	return;
    }

    my ($extension) = ($request->uri =~ m/\.(\w+)$/);
    &Apache::lonxml::debug("Looking for :$extension:");
    my $templatelist=&get_template_list($extension);
    if ($env{'form.newfile'} && !$templatelist) {
	# no templates found
	my $templatefilename =
	    $request->dir_config('lonIncludes').'/templates/blank.'.$extension;
	&Apache::lonxml::debug("$templatefilename");
	my $dest = &Apache::lonnet::filelocation("",$request->uri);
	&File::Copy::copy($templatefilename,$dest);
	&renderpage($request,$dest);
    } else {
	my $url=&HTML::Entities::encode($request->uri,'<>&"');
	my $shownurl=$url;	
	$shownurl=~s-^/~-/priv/-;
	my $dest = &Apache::lonnet::filelocation("",$request->uri);
	my $errormsg;
	my $instructions;
	my $start_page = 
	    &Apache::loncommon::start_page("Create New $extension");
	$request->print("
$start_page
<h1>".&mt("Creating a new $extension resource.")."</h1>
$errormsg
".&mt("The requested file [_1] currently does not exist.",
      '<span class="LC_filename">'.$shownurl.'</span>')."
<p>
<b>
".&mt("To create a new $extension, select a template from the".
      " list below. Then click on the \"Create $extension\" button.").'</b>
</p><form action="'.$url.'" method="post">');

	if (defined($templatelist)) {
	    $request->print($templatelist);
	}
	$request->print('<br /><input type="submit" name="newfile" value="'.
			&mt("Create $extension").'" />');
	$request->print("</form></p>".&Apache::loncommon::end_page());
    }
    return;
}

sub update_construct_style {
    if ($env{'request.state'} eq "construct"
	&& $env{'form.problemmode'} eq 'view' 
	&&  defined($env{'form.submitted'})
	&& !defined($env{'form.resetdata'})
	&& !defined($env{'form.newrandomization'})) {
	if ((!$env{'form.style_file'} && $env{'construct.style'})
	    ||$env{'form.clear_style_file'}) {
	    &Apache::lonnet::delenv('construct.style');
	} elsif ($env{'form.style_file'} 
	    && $env{'construct.style'} ne $env{'form.style_file'}) {
	    &Apache::lonnet::appenv({'construct.style' => 
				        $env{'form.style_file'}});
	}
    }
}


sub handler {
    #my $t0 = [&gettimeofday()];
    my $request=$_[0];
    $Apache::lonxml::request=$request;
    $Apache::lonxml::debug=$env{'user.debug'};
    $env{'request.uri'}=$request->uri;
    &setuppermissions();

    my $file=&Apache::lonnet::filelocation("",$request->uri);

    #check if we know where we are
    if ($env{'request.course.fn'} && !&Apache::lonnet::symbread()) { 
	# if we are browsing we might not be able to know where we are
	if ($Apache::lonhomework::browse ne 'F' && 
	    $env{'request.state'} ne "construct") {
	    #should know where we are, so ask
	    &unset_permissions();
	    $request->internal_redirect('/adm/ambiguous');
	    return OK;
	}
    }
    if (&setupheader($request)) {
	&unset_permissions();
	return OK;
    }
    &Apache::lonxml::debug("Permissions:$Apache::lonhomework::browse:$Apache::lonhomework::viewgrades:$Apache::lonhomework::modifygrades:$Apache::lonhomework::queuegrade");
    &Apache::lonxml::debug("Problem Mode ".$env{'form.problemmode'});
    my ($symb) = &Apache::lonnet::whichuser();
    &Apache::lonxml::debug('symb is '.$symb);
    if ($env{'request.state'} eq "construct") {
	if ( -e $file ) {
	    &Apache::loncommon::get_unprocessed_cgi($ENV{'QUERY_STRING'},
						    ['problemmode']);
	    if (!(defined $env{'form.problemmode'})) {
		#first visit to problem in construction space
		$env{'form.problemmode'}= 'view';
		&renderpage($request,$file);
	    } elsif ($env{'form.problemmode'} eq 'editxml') {
		&editxmlmode($request,$file);
	    } elsif ($env{'form.problemmode'} eq 'calcanswers') {
		&analyze($request,$file);
	    } else {
		&update_construct_style();
		&renderpage($request,$file);
	    }
	} else {
	    # requested file doesn't exist in contruction space
	    &newproblem($request);
	}
    } else {
	# just render the page normally outside of construction space
	&Apache::lonxml::debug("not construct");
	&renderpage($request,$file);
    }
    #my $td=&tv_interval($t0);
    #&Apache::lonxml::debug("Spent $td seconds processing");
    # always turn off debug messages
    $Apache::lonxml::debug=0;
    &unset_permissions();
    return OK;

}

1;
__END__
