# The LearningOnline Network
# Search for a user
#
# $Id: lonpickuser.pm,v 1.4 2009/09/06 19:09:54 raeburn Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
###

=head1 NAME

Apache::lonpickuser.pm

=head1 SYNOPSIS

Allows users to search by username, lastname, or lastname,firstname in LON-CAPA,
and also in an institutional directory (if enabled).

This is part of the LearningOnline Network with CAPA project
described at http://www.lon-capa.org.

=head1 SUBROUTINES

=over

=item handler()

=item gochoose_javascript()
 
=back

=cut

package Apache::lonpickuser;

use strict;
use Apache::Constants qw(:common :http);
use Apache::lonnet;
use Apache::loncommon;
use Apache::lonlocal;
use Apache::lonuserutils;
use Apache::loncreateuser;
use LONCAPA;

sub handler {
    my ($r) = @_;
    &Apache::loncommon::content_type($r,'text/html');
    $r->send_http_header;
    return OK if $r->header_only;

    # Get parameters from query string
    &Apache::loncommon::get_unprocessed_cgi
        ($ENV{'QUERY_STRING'},['srchdom','form','udomelement','unameelement','ulastelement',
                               'ufirstelement','uemailelement','hideudomelement','coursedom','caller']);
    my $js;

    if (($env{'form.phase'} eq 'get_user_info') || 
        ($env{'form.phase'} eq 'store_newuser')) {
        $js = &gochoose_javascript();
    } elsif ($env{'form.phase'} eq 'define_newuser') {
        $js = <<"ENDSP";
<script type="text/javascript">
// <![CDATA[
function setphase(caller) {
    document.newuserinfo.phase.value = caller;
    document.newuserinfo.submit();
    return;
}
// ]]>
</script>
ENDSP
    } elsif ($env{'form.caller'} eq 'checkusername') {
        $js = <<"ENDCHK";
<script type="text/javascript">
// <![CDATA[
function checkUser() {
    var uname = opener.document.$env{'form.form'}.$env{'form.unameelement'}.value;
    var udom;
    var slct=opener.document.$env{'form.form'}.$env{'form.udomelement'};
    if (slct.options == undefined) {
        udom = opener.document.$env{'form.form'}.$env{'form.udomelement'}.value;
    } else {
        udom = slct.options[slct.selectedIndex].value;
    }
    if (uname != '') {
        document.userpicker.srchterm.value = uname;
        document.userpicker.srchdomain.value = udom;
    }
    document.userpicker.submit();
}
// ]]>
</script>
ENDCHK
    } elsif ($env{'form.phase'} eq '') {
        $js = <<"ENDSET";
<script type="text/javascript">
// <![CDATA[
function setUserSearch() {
    var uname = opener.document.$env{'form.form'}.$env{'form.unameelement'}.value;
    var udom;
    var slct=opener.document.$env{'form.form'}.$env{'form.udomelement'};
    if (slct.options == undefined) {
        udom = opener.document.$env{'form.form'}.$env{'form.udomelement'}.value;
    } else {
        udom = slct.options[slct.selectedIndex].value;
    }
    if (uname != '') {
        document.userpicker.srchterm.value = uname;
        var seldom = document.userpicker.srchdomain;
        if (seldom.options != undefined) {
            var i;
            for (i=0;i<seldom.length;i++) {
                if (seldom.options[i].value==udom) { seldom.selectedIndex=i; }
            }
        }
        var selby = document.userpicker.srchby;
        if (selby.options != undefined) {
            var i;
            for (i=0;i<selby.length;i++) {
                if (selby.options[i].value=="uname") { selby.selectedIndex=i; }
            }
        }
        var seltype = document.userpicker.srchtype;
        if (seltype.options != undefined) {
            var i;
            for (i=0;i<seltype.length;i++) {
                if (seltype.options[i].value=="exact") { seltype.selectedIndex=i; }
            }
        }
        var selin = document.userpicker.srchin;
        if (selin.options != undefined) {
            var i;
            for (i=0;i<selin.length;i++) {
                if (selin.options[i].value=="dom") { selin.selectedIndex=i; }
            }
        }
    }
    return;
}
// ]]>
</script>
ENDSET
    }
    my $startargs = {'no_nav_bar'  => 1, };
    if ($env{'form.phase'} eq 'store_newuser') {
        my $uname = $env{'form.srchterm'};
        my $udom = $env{'form.srchdomain'};
        my $newfirst = $env{'form.newfirst'};
        my $newlast = $env{'form.newlast'};
        my $newemail = $env{'form.newemail'};
        $startargs->{'add_entries'} = { onload => 'javascript:gochoose('."'$uname','$udom','$newfirst','$newlast','$newemail'".');' };
    } elsif ($env{'form.caller'} eq 'checkusername') {
        $startargs->{'add_entries'} = { onload => 'javascript:checkUser();' };
    } elsif ($env{'form.phase'} eq '') {
        $startargs->{'add_entries'} = { onload => 'javascript:setUserSearch();' };
    }
    $r->print(&Apache::loncommon::start_page('Selecting course personnel',
                                             $js,$startargs));
    if ($env{'form.caller'} eq 'checkusername') {
        $r->print(&check_user_form().
                  &Apache::loncommon::end_page());
        return OK;
    }
    my %toset = (
                  uname   => 'unameelement',
                  udom    => 'udomelement',
                  first   => 'ufirstelement',
                  lastn   => 'ulastelement',
                  email   => 'uemailelement',
                  hidedom => 'hideudomelement',
                );

    my @search = ('srchterm','srchby','srchin','srchtype','srchdomain');
    my %srch;
    foreach my $item (@search) {
        $srch{$item} = $env{'form.'.$item};
    }
    my $forcenewuser;
    my $context = 'requestcrs';
    my $usertype;
    if (($srch{'srchin'} eq 'dom') &&
        ($srch{'srchby'} eq 'uname') &&
        ($srch{'srchtype'} eq 'exact') &&
        ($srch{'srchdomain'} ne '') &&
        ($srch{'srchterm'} ne '')) {
        my ($rules,$ruleorder) =
            &Apache::lonnet::inst_userrules($srch{'srchdomain'},'username');
        $usertype = &Apache::lonuserutils::check_usertype($srch{'srchdomain'},
                                                          $srch{'srchterm'},$rules);
    }

    my $dom = $env{'form.coursedom'};

    my $cancreate =
        &Apache::lonuserutils::can_create_user($dom,$context,$usertype);
    my $userpicker =
       &Apache::loncommon::user_picker($dom,\%srch,$forcenewuser,
                                       'document.userpicker',$cancreate,$usertype);
    my $srchbutton = &mt('Search');

    my $headertext = &mt('Search for a user to add to course personnel');  
    my $opener_elems = '<input type="hidden" name="form" value="'.
                       $env{'form.form'}.'" />'."\n".
                       '<input type="hidden" name="coursedom" value="'.
                       $env{'form.coursedom'}.'" />'."\n".
                       &set_opener_elems();
    unless ($env{'form.phase'} eq 'define_newuser') { 
        $r->print(<<"ENDBLOCK");
<h3>$headertext</h3>
<form action="/adm/pickuser" method="post" name="userpicker">
$opener_elems
<input type="hidden" name="phase" value="get_user_info" />
$userpicker
<input name="userrole" type="button" value="$srchbutton" onclick="javascript:validateEntry(document.userpicker)" />
</form>
ENDBLOCK
    }
    if (($env{'form.phase'} eq 'get_user_info') && ($env{'form.srchterm'} ne '')) {
        $r->print('<hr /><div>'.&mt('Searching ...').'</div>');
        $r->rflush();
        my ($currstate,$response,$forcenewuser,$results) = 
            &Apache::loncreateuser::user_search_result($context,\%srch);
        if (($currstate eq 'select') || ($currstate eq 'modify')) {
            &Apache::loncreateuser::print_user_selection_page($r,$response,\%srch,$results,
                                                              \@search,$context,$opener_elems);
        } else {
            $r->print('<div>'.$response.'</div>');
            if ($forcenewuser) {
                if ($srch{'srchby'} eq 'uname' && 
                    $srch{'srchtype'} eq 'exact' && 
                    $srch{'srchin'} eq 'dom' && 
                    $srch{'srchdomain'} eq $env{'form.coursedom'}) {
                    if ($cancreate) {
                        $r->print("\n".'<div><form name="newuser" '.
                                  'method="post" action="/adm/pickuser">');
                        foreach my $item (keys(%srch)) {
                            $r->print('<input type="hidden" name="'.$item.'"'.
                                      ' value="'.$srch{$item}.'" />'."\n");
                        }
                        $r->print('
<input type="hidden" name="phase" value="define_newuser">
<input type="submit" name="forcenew" value="'.
&HTML::Entities::encode(&mt('Make new user "[_1]"',$srch{'srchterm'}),'<>&"').'" />'."\n".
$opener_elems.'
</form></div>');
                    } else {
                        my $helplink = 'javascript:helpMenu('."'display'".')';
                        my %usertypetext = 
                            &Apache::lonlocal::texthash(
                              official   => 'You are not authorized to create new institutional users in this domain.',
                              unofficial => 'You are not authorized to create new non-institutional users in this domain.',
                        );
                        $r->print('<div class="LC_warning">'.
                                  $usertypetext{$usertype}.' '.
                                  &mt('Please contact the [_1]helpdesk[_2] for assistance.','<a href="'.$helplink.'">','</a>').'</div>');

                    }
                }
            }
        }
    }
    if ($env{'form.phase'} eq 'define_newuser') {
        $r->print('<h3>'.&mt('Define new user').' '.$srch{'srchterm'}.':'.
                  $srch{'srchdomain'}.'</h3>'."\n".'<div>'.
                  '<form name="newuserinfo" method="post" action="/adm/pickuser">'."\n".
                  '<input type="hidden" name="phase" value="" />'."\n".
                  $opener_elems.
                  &Apache::lonhtmlcommon::start_pick_box()."\n".
                  &Apache::lonhtmlcommon::row_title(&mt('First Name')).
                  '<input type="text" name="newfirst" value="" size="15" />'.
                  &Apache::lonhtmlcommon::row_closure()."\n".
                  &Apache::lonhtmlcommon::row_title(&mt('Last Name')).
                  '<input type="text" name="newlast" value="" size="25" />'
.
                  &Apache::lonhtmlcommon::row_closure()."\n".
                  &Apache::lonhtmlcommon::row_title(&mt('E-mail Address')).
                  '<input type="text" name="newemail" value="" size="25" />'
.
                  &Apache::lonhtmlcommon::row_closure(1)."\n".
                  &Apache::lonhtmlcommon::end_pick_box());
        foreach my $item (keys(%srch)) {
            $r->print('<input type="hidden" name="'.$item.'"'.
                      ' value="'.$srch{$item}.'" />'."\n");
        }
        $r->print('<br /><input type="button" name="cancelnew" value="'.
                  &mt('Cancel').'" onclick="javascript:setphase('.
                  "'get_user_info'".');" />'."\n".
                  '<input type="button" name="definenew" value="'.
                  &mt('Save').'" onclick="javascript:setphase('.
                  "'store_newuser'".');" /></form></div>');
    }
    $r->print(&Apache::loncommon::end_page());
    return OK;
}

sub gochoose_javascript {
    return <<"ENDGC"; 
<script type="text/javascript">
// <![CDATA[
function gochoose(uname,udom,ufirst,ulast,uemail) {
    opener.document.$env{'form.form'}.$env{'form.unameelement'}.value=uname;
    opener.document.$env{'form.form'}.$env{'form.ufirstelement'}.value=ufirst;
    opener.document.$env{'form.form'}.$env{'form.ulastelement'}.value=ulast;
    opener.document.$env{'form.form'}.$env{'form.uemailelement'}.value=uemail;

    var slct=opener.document.$env{'form.form'}.$env{'form.udomelement'};
    if (slct.options == undefined) {
        opener.document.$env{'form.form'}.$env{'form.udomelement'}.value=udom;
    }
    else {
        var i;
        for (i=0;i<slct.length;i++) {
            if (slct.options[i].value==udom) { slct.selectedIndex=i; }
        }
    }
    opener.document.$env{'form.form'}.$env{'form.hideudomelement'}.value=udom;
    self.close();
}
// ]]>
</script>

ENDGC
}

sub check_user_form {
    return '
<form action="/adm/pickuser" method="post" name="userpicker">
<input type="hidden" name="form" value="'.$env{'form.form'}.'" />
<input type="hidden" name="coursedom" value="'.$env{'form.coursedom'}.'" />'."\n".
                 &set_opener_elems().'
<input type="hidden" name="srchby" value="uname" />
<input type="hidden" name="srchin" value="dom" />
<input type="hidden" name="srchterm" value="" />
<input type="hidden" name="srchdomain" value="" />
<input type="hidden" name="srchtype" value="exact" />
<input type="hidden" name="phase" value="get_user_info" />
</form>'."\n";
}

sub set_opener_elems {
    my %toset = (
                  uname   => 'unameelement',
                  udom    => 'udomelement',
                  first   => 'ufirstelement',
                  lastn   => 'ulastelement',
                  email   => 'uemailelement',
                  hidedom => 'hideudomelement',
                );
    my $output;
    foreach my $item (keys(%toset)) {
        if (exists($env{'form.'.$toset{$item}})) {
            $output .= '<input type="hidden" name="'.$toset{$item}.'" value="'.$env{'form.'.$toset{$item}}.'" />'."\n";
        }
    }
    return $output;
}

1;
