# The LearningOnline Network with CAPA
# Spanish Localization Lexicon
#
# $Id: es.pm,v 1.60 2010/10/06 17:58:20 ramirez Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################



package Apache::localize::es;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,

'char_encoding'=> 'UTF-8',
'language_code'=> 'es',
'lang_locale' => 'es_ES.utf8',
'date_locale'  =>
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds hs',
'date_months'  => 'En,Feb,Mar,Abr,May,Jun,Jul,Ago,Set,Oct,Nov,Dic',
'date_days'    => 'Dom,Lun,Mar,Mie,Jue,Vie,Sab',
'date_am' => 'mañana',
'date_pm' => 'tarde',
'htmlarea_lang' => 'es',
'spellcheck_lang' => 'es',


   'Send Messages'
=> 'Enviar Mensajes',

   'New Message'
=> 'Mensaje Nuevo',

   'Send a message to users.'
=> 'Enviar un mensaje a usuarios.',

   'New Broadcast Message'
=> 'Nuevo Mensaje de Emisión',

   'Send a broadcast message to members of this Course and/or other users.'
=> 'Emitir un mensaje a miembros de este Curso y/o otros usuarios.',

   'New Messages from File'
=> 'Mensaje Nuevo desde Archivo',

   'Create a message from file and send to users.'
=> 'Crear un mensaje desde un archivo y enviar a usuarios',

   'Message Administration'
=> 'Mensajes de la Administración',

   'Message Log for Selected Users'
=> 'Registro de Mensajes para Usuarios Selecionados',

   'User notes, records of face-to-face discussions, critical messages, broadcast messages and archived messages in Course.'
=> 'Notas de Usuarios, Registros de Discusiones Cara-a-Cara, mensajes críticos, emitir mensajes y mensajes archivados en el Curso.',

   'Discussion and message records for [_1] ([_2])'
=> 'Registros de Discusión y mensaje para [_1] ([_2])',

   'Domain'
=> 'Dominio',

   'Domain:'
=> 'Dominio:',

   'Server'
=> 'Servidor',

   'Server Load'
=> 'Utilización',

   'User Load'
=> 'Usuarios',

   'Help'
=> 'Ayuda',

   'Log in'
=> 'Entrar',

   'Log-in to LON-CAPA'
=> 'Entrar a LON-CAPA',

   'Username'
=> 'Usuario',

   'Password'
=> 'Contraseña',

   'choose'
=> 'elija',

   'enter'
=> 'entrar',

   'view'
=> 'ver',

   'calendar'
=> 'calendario',

   'role'
=> 'Su función',

   'course'
=> 'Curso',

   'Course'
=> 'Curso',

   'Section/Group'
=> 'Sección/Grupo',

   'today'
=> 'hoy',

   'last week'
=> 'semana pasada',

   'last month'
=> 'mes pasado',

   'last three months'
=> 'últimos tres meses',

   'last six months'
=> 'últimos seis meses',

   'last year'
=> 'año pasado',

   'Submit'
=> 'Enviar',

   'Rename'
=> 'Renombrar',

   'Save'
=> 'Guardar',

   'Save All'
=> 'Guardar Todo',

   'Done'
=> 'Hecho',

   'Select User'
=> 'Seleccionar Usuario',

   'Select Course'
=> 'Seleccione Curso',

   're-initializing course'
=> 'reiniciar curso',

   'Uploaded Document'
=> 'Documento Cargado',

   'No content modifications yet.'
=> 'No hay modificaciones en el contenido.',

   'Part is not open to be viewed. It'
=> 'El objeto no está abierto para ser visualizado.',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Imposible determinar si el recurso está abierto debido a problemas de la red. Por favor intentelo de nuevo más tarde',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'Nota: los cambios pueden tardar 10 minutos en hacer efecto.',

   'Language'
=> 'Idioma',

   'Notes'
=> 'Notas',

   'Abstract'
=> 'Sumario',

   'Create a user or modify the roles and privileges of a user'
=> 'Crear un usuario o modificar sus funciones y privilegios',

   'View course assessment statistics'
#=> 'Ver las estadísticas de los ejercicios del curso',
=> 'Ver estadísticas de los problemas resueltos por los estudiantes',

   'Set deadlines and other assessment parameters, as well as modify course environment'
#=> 'Fijar plazos y otros parámetros de aproximación, modificar entorno del curso',
=> 'Establecer plazos y otros parámetros de evaluación, modificar entorno del curso',

   'New Folder'
=> 'Carpeta Nueva',

   'Simple Course Page'
=> 'Página Simple de Curso',

   'Simple Problem'
=> 'Problema Simple',

   'Upload Document'
=> 'Cargar Documento',

   'Search'
=> 'Buscar',

   'Import'
=> 'Importar',

   'Main Course Documents'
=> 'Documentos Principales del Curso',

   'Supplemental Course Documents'
=> 'Documentos Suplementarios del Curso',

   'Discussion Board'
=> 'Foro de Discusión',

   'Published Resources'
=> 'Recursos Publicados',

   'Special Documents'
=> 'Documentos Especiales',

   'Document'
=> 'Documento',

   'Settings'
=> 'Preferencias',

   'create'
=> 'crear',

   'grades'
=> 'notas',

   'enroll'
=> 'matrícular',

   'Table of Contents'
=> 'Tabla de Contenidos',

   'Announcements and Calendar'
=> 'Anuncios y Calendario',

   'Author'
=> 'Autor',

   'Change Your Preferences'
=> 'Modificar Sus Preferencias',

   'Choose the user role'
=> 'Elegir función de usuario',

   'Co-Author'
=> 'Co-Autor',

   'Co-Author [_1]'
=> 'Co-Autor [_1]',

   'Communication and Messages'
=> 'Comunicación y Mensajes',

   'Course Coordinator'
=> 'Coordinador de Curso',

   'Course Statistics and Charts'
#=> 'Estadísticas de Curso y Gráficos',
=> 'Estadísticas del Curso y Desempeño',

   'Compiling Excel spreadsheet for [quant,_1,student]...'
=> 'Generando Hoja de Excel para [quant,_1,estudiante,estudiantes]...',

   'Course Announcements'
=> 'Anuncios del Curso',

    'Course announcements and my calendar'
=> 'Avisos de curso y mi calendario',

   'Create Users, Change User Privileges'
=> 'Crear Usuarios, Cambiar los permisos de usuario',

   'Domain Coordinator'
=> 'Coordinador de Dominio',

   'Enrollment Manager'
#=> 'Gestor de Inscripciones',
=> 'Control de Inscripciones',

   'Enter grades from check-out assessment resources'
#=> 'Introducir notas desde check-out assessment resources',
=> 'Introducir las notas desde el chequeo los recursos de validación',

   'Exam Proctor'
=> 'Examinador',#=> 'Procurador de Exámen',

   'Grades Spreadsheet'
=> 'Balance de Notas',

   'Grading'
=> 'Calificación',

   'Instructor'
=> 'Instructor',

   'Launch Remote Control'
=> 'Activar el Control Remoto',

   'Main Menu'
=> 'Menu Principal',

   'Navigate Course Contents'
=> 'Navegar por los Contenidos del Curso',

   'No Role, Cumulative Privileges'
=> 'Sin función, privilegios acumulados',

   'Return to Last Location'
=> 'Volver a la Última Dirección',

   'Send and receive messages'
=> 'Enviar y Recibir Mensajes',

   'Send and display messages'
=> 'Enviar y mostrar mensajes',

   'Send message to [_1]'
=> 'Enviar mensaje a [_1]',

   'Send message to student'
=> 'Enviar mensaje a estudiante',

   'Send message to member'
=> 'Enviar mensaje a miembro',

   'Message to student and add to user notes'
=> 'Mensaje a estudiante y añadir notas sobre usuario',

   'Message to member and add to user notes'
=> 'Mensaje a miembro y añadir notas sobre usuario',

   'Set my user preferences'
#=> 'Elegir mis preferencias de usuario',
=> 'Establecer mis preferencias de usuario',

   'Student'
=> 'Estudiante',

   'Student: '
=> 'Estudiante: ',

   'Switch to another user role'
#=> 'Cambiar a Otra Función',
=> 'Cambiar de Función',

   'Teaching Assistant'
=> 'Asistente del profesor',

   'Use or edit my bookmark collection'
=> 'Usar o editar mi colección de marcadores',

   'User Roles'
=> 'Funciones de Usuario',

   'Calculate course grades (Spreadsheet)'
#=> 'Plantilla para calcular las notas del curso',
=> 'Calcular notas del curso (Hoja de Cálculo)',

   'Enter the chat room for the course'
=> 'Entrar en la sala de chat del curso',

   'Navigate the table of contents for this course'
#=> 'Navegar en la lista de contenidos del curso',
=> 'Navegar contenidos de este curso',

   'Syllabus'
=> 'Plan de Estudios',

   'Course syllabus'
=> 'Plan de Estudios del Curso',

   'View the course assessment progress chart'
=> 'Ver tablón de progreso de los estudiantes del curso',

   'Class Hours'
=> 'Horas de Clase',

   'Course Title'
=> 'Título del Curso',

   'Course title'
=> 'Título del curso',

   'Coursepack'
=> 'Coursepack(Contenido)',

   'Current Month'
=> 'Mes Actual',

   'Deadlines'
=> 'Plazos finales',

   'Fri'
=> 'Vie',

   'Grading Information'
=> 'Información de Calificaciones',

   'Helproom Hours'
=> 'Horas de Ayuda',

   'Instructor Information'
=> 'información de Instructor',

   'Mon'
=> 'Lun',

   'Next Month'
=> 'Próximo Mes',

   'Office Hours'
=> 'Horas de Oficina',

   'Prerequisites'
=> 'Pre-Requisitos',

   'Previous Month'
=> 'Mes Pasado',

   'Readings'
=> 'Lecturas',

   'Sat'
=> 'Sab',

   'January'
=> 'Enero',

   'February'
=> 'Febrero',

   'March'
=> 'Marzo',

   'April'
=> 'Abril',

   'May'
=> 'Mayo',

   'June'
=> 'Junio',

   'August'
=> 'Agosto',

   'September'
=> 'Septiembre',

   'October'
=> 'Octubre',

   'November'
=> 'Noviembre',

   'December'
=> 'Diciembre',

   'Sun'
=> 'Dom',

   'Textbook'
=> 'Libro de Texto',

   'Thu'
=> 'Jue',

   'Tue'
=> 'Mar',

   'Web Links'
=> 'Enlaces Web',

   'Wed'
=> 'Mie',

   'Drop/Add students in this course'
#=> 'Agregar/Borrar estudiantes al curso',
=> 'Añadir/Quitar estudiantes del curso',

   'A score has been assigned.'
=> 'Se asignó una puntuación.',

   'Some parts were not submitted.'
=> 'Algunas partes no se han rellenado.',

   'Due'
=> 'Límite',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'La extensión del archivo que ha cargado no es válida.',

   'Units incorrect.'
=> 'Unidades incorrectas.',

   'Only a number required.'
=> 'Solo se pide un número.',

   'Units required'
=> 'Unidades requeridas',

   'Tries'
=> 'Intentos',

   'Submit Answer'
=> 'Enviar Respuesta',

   'Prepare a printable document'
=> 'Preparar un documento para Imprimir',

   'Go To My First Homework Problem'
=> 'Ir a Mi Hoja Primera Hoja de Ejercicios',

   'Cancel'
=> 'Cancelar',

   'Discussions'
=> 'Discusiones',

   'New discussion since'
=> 'Nueva discusion desde',

   'New message (click to open)'
=> 'Nuevo mensaje (click para abrir)',

   'Close all folders'
=> 'Cerrar todas las carpetas',

   'Goodbye'
=> 'Adios',

   'Select'
=> 'Seleccionar',

   'Re-Initialize'
=> 'Reiniciar',

   'Currently selected.'
=> 'Función actual.',

   'Switch Server'
=> 'Cambiar Servidor',

   'system wide'
=> 'todo el sistema',

   'Currently not available'
=> 'No Disponible por el  momento',

   'No role specified'
=> 'Ninguna función especificada',

   'Remark'
=> 'Observación',

   'Extent'
=> 'Extensión',

   'Current Privileges'
=> 'Privilegios Actuales',

   'User Role'
=> 'Función',

   'User role'
=> 'función',

   'Start'
=> 'Inicio',

   'End'
=> 'Fin',

   'System'
=> 'Sistema',

   'Display'
=> 'Mostrar',

   'Display:'
=> 'Mostrar:',

   'Do not display'
=> 'No mostrar',

   "an unknown date"
=> 'una fecha desconocida',

   "an indeterminate date"
=> 'fecha no determinada',

   "will open on"
=> "se abrirá en",

   "is due at"
=> "se hará el",

   "was due on"
=> "fue cerrado el",

   'is closed but you are allowed to view it'
=> "está cerrado, pero tiene permisos para verlo",

   "Undid changes, Switched [_1] and [_2]"
=> "Deshacer Cambios, con intercambio de [_1] y [_2]",

   "Unable to undo, unable to switch [_1] and [_2]"
=> "Imposible deshacer, No se ha podido intercambiar [_1] and [_2]",

   "Unable to make backup [_1]"
=> "No se ha podido hacer copia de seguridad [_1]",

   "Saving Modifications to [_1]"
=> "Guardando Cambios en [_1]",

   "Unable to write to [_1]"
=> "No se puede escribir en [_1]",

   "Analyzing a problem"
=> "Analizando un problema",

   "EditXML"
=> "Editar XML",

   'Discard Edits and View'
=> 'Descartar cambios y Ver',

   'Submit Changes'
=> 'Introducir Cambios',

   'Submit Changes and View'
=> 'Introducir Cambios y Ver',

   'Edit'
=> 'Editar',

   ', select a template from the pull-down menu below'
=> ', selecione un modelo del menu de debajo',

   'undo'
=> 'deshacer',

   'Answer'
=> 'Respuesta',

   'Frequency'
=> 'Frecuencia',

   'You did not select a template.'
=> 'No ha seleccionado un modelo.',

   'Analyze Progress'
=> 'Analizar Progreso',

   'Getting Problem Variants'
=> 'Sacando Variantes del Problema',

   'last problem'
=> 'último problema',

   "may open later."
=> 'puede abrir más tarde.',

   ', and answers will be available on'
=> ', y las respuestas estarán disponibles en',

   "Select a"
=> "Seleccione un",

   'Part'
=> 'Parte',

   "Then"
=> 'Entonces',

   'is in under construction'
=> 'está en construcción',

   'List of possible answers'
=> 'Lista de posibles respuestas',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Se han encontrado partes no analizables en el problema, actualmente solo los Tipos Numerico, Formula y Concatenados estan permitidos.',

   'Response [_1] is not analyzable at this time.'
=> 'Respuesta [_1] no se puede analizar en este momento',

   'Title'
=> 'Título',

   'Path'
=> 'Ruta',

   'New Search'
=> 'Nueva Búsqueda',

   'Go Back'
=> 'Volver',

   'Go back'
=> 'Volver',

   'File'
=> 'Archivo',

   'Date'
=> 'Fecha',

   'You have no unread messages'
=> 'No tiene mensajes sin leer',

   'New Messages'
=> 'Mensajes Nuevos',

   'All Messages'
=> 'Todos los Mensajes',

   'Map'
=> 'Mapa/Secuencia',

   'Page'
=> 'Página',

   'Page:'
=> 'Página:',

   'Sequence'
=> 'Secuencia',

   'Map contents are not shown in order.'
=> 'Los contenidos del mapa no están mostrados en orden.',

   'Empty'
=> 'Vacío',

   'File [_1] could not be copied.'
=> 'Archivo [_1] no pudo ser copiado.',

   'Back to Directory'
=> 'Volver al directorio',

   'No upload file specified.'
=> 'No se ha especificado archivo a cargar.',

   'The target is an existing directory.'
=> 'El destino es un directorio que ya existe.',

   'Please use browser "Back" button and pick a filename'
=> 'Por favor, use el botón "Volver" e introduzca un nombre de archivo',

   "You do not have authoring privileges for this resource"
=> "No tiene privilegios de autor para este recurso",

   'Copying file'
=> 'Copiando archivo',

   'No write permission to user directory, FAIL'
=> 'No tiene permisos para el directorio de usuario, FALLO',

   'Name'
=> 'Nombre',

   'Status'
=> 'Estado',

   'Last Modified'
=> 'Última Modificación',

   'Yes'
=> 'Si',

   'Construction Space Directory'
=> 'Directorio del Espacio de Construcción',

   'Contact [_1] for access.'
=> 'Contactar [_1] para accesar.',

   'Please log into [_1] to edit.'
=> 'Por favor, ingrese a [_1] para editar.',

   'Save uploaded file as [_1]'
=> 'Guardar archivo cargado como [_1]',

   'Searching'
=> 'Buscando',

   'Searching ...'
=> 'Buscando ...',

   'Owner:Domain'
=> 'Dueño:Dominio',

   'Owner/Co-owner(s)'
=> 'Dueño/Co-Dueño',

   'Select the Construction Space'
#=> 'Seleccione un  Area de Construcción',
=> 'Seleccione la  Zona de Construcción',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Se recomienda que use un antivirus actualizado antes de manejar este archivo.',

   'not displayed'
=> 'no mostrado',

   "Open, no due date"
=> "Abierto, sin fecha límite",

   "Uncompleted Homework"
=> "Ejercicios sin Completar",

   "Show Only Uncompleted Homework"
#=> "<p>Mostrar solo los Ejercicios sin Resolver",
=> "Mostrar solo los Ejercicios sin Resolver",

   "All homework is currently completed."
=> "Todos los ejercicios están completados.",

   'This course is empty.'
=> 'Este curso está vacío',

   'Coursemap undefined.'
=> 'Mapa del curso no definido',

   "Was due"
=> "Plazo Final Fue",

   "Answer available"
=> "Respuesta disponible",

   "Excused by instructor"
=> "Disculpas del instructor",

   "Answer submitted, not yet graded"
=> "Resposta enviada, todavía no corregida",

   "No due date"
=> "Sin Fecha de inicio",

   'never'
=> 'nunca',

   'Answer submitted'
=> 'Respuesta enviada',

   '[_1] of [quant,_2,try,tries] used'
=> '[_1] de [quant,_2,intento usado,intentos usados]',

   'Processing'
=> 'Procesando',

   'Access and Usage Statistics'
=> 'Estadísticas de Uso y Acceso',

   'Evaluation Comments'
=> 'Comentarios de evaluación',

   'Evaluation Data'
=> 'Datos de Evaluación',

   'July'
=> 'Julio',

   'Server Administration'
=> 'Administración del Servidor',

   'System Administration'
=> 'Administración del Sistema',

   'Users with Roles Assigned by'
=> 'Usuarios con funciones atribuidas por',

   'Name starting with'
=> 'Nombre(s) que comiencen con',

   'This resource has been marked obsolete by the author(s)'
=> 'Este recurso ha sido marcado como obsoleto por el(los) autor(es)',

   'Uploaded'
=> 'Cargado',

   'Dynamic Metadata'
=> 'Metadatos dinámicos',

   'View file'
=> 'Ver archivo',

   'Illegal filename.'
=> 'Nombre de archivo NO valido.',

   'Rule'
=> 'Regla',

   'Back to Source Directory'
=> 'Volver al directorio',

   'Back to Source'
=> 'Volver a la fuente',

   'Back to Resource'
=> 'Volver al Recurso',

   'File copied.'
=> 'Archivo copiado',

   'FAIL'
=> 'FALLO',

   'Back to [_1]'
=> 'Volver a [_1]',

   'untitled'
=> 'sin título',

   'The extension on this file, [_1], is reserved internally by LON-CAPA.'
=> 'La extensión en este archivo, [_1], está reservado internamente por LON-CAPA.',

   'The extension on this file is reserved internally by LON-CAPA.'
=> 'La extensión en este archivo está reservado internamente por LON-CAPA.',

   'The extension on this file, [_1], is not recognized by LON-CAPA.'
=> 'La extensión en este archivo, [_1], no es reconocido por LON-CAPA.',

   'The extension on this file is not recognized by LON-CAPA.'
=> 'La extensión en este archivo no es reconocido por LON-CAPA.',

   'Please change the extension.'
=> 'Por favor cambie la extensión.',

   'Became this version on ...'
=> 'Se actualizó a esta versión en ...',

   'Browse published resources'
=> 'Navegar por los Recursos Publicados',

   'Choose the course to work on'
=> 'Seleccione el curso para trabajar',

   'Create a new course'
=> 'Crear un curso nuevo',

   'Customized right of use ...'
=> 'Derechos de uso modificados...',

   'Delete messages from discussion boards'
=> 'Eliminar mensajes del foro de discusión',

   'Domain only - use limited to courses in the domain'
=> 'Solo Dominio - se limita el uso a cursos dentro del dominio',

   'Edit and view documents included in this course'
#=> 'Editar y ver los documentos incluidos en este curso',
=> 'Editar y verificar documentos de este curso',

   'Edit course contents'
=> 'Editar contenido del curso',

   'Enter my construction space'
=> 'Entrar en mi zona de construcción de recursos',

   'Failed to copy source'
=> 'Fallo al copiar fuente',

   'Failed to write metadata copy'
=> 'Falló al escribir copia de metadatos',

   'Finalize Publication'
=> 'Publicación Finalizada',

   'Grant/revoke role of Co-Author'
=> 'Añadir/Eliminar función de Co-Autor',

   'Grant/revoke role of Domain Coordinator'
=> 'Añadir/Eliminar función de Coordinador de Dominio',

   'Grant/revoke role of Exam Proctor'
=> 'Añadir/Eliminar función de Examinador',

   'Grant/revoke role of Instructor'
=> 'Añadir/Eliminar función de Instructor',

   'Grant/revoke role of Student'
=> 'Añadir/Eliminar función de Estudiante',

   'Grant/revoke role of Superuser'
=> 'Añadir/Eliminar función de Superusuario',

   'No previous versions published.'
=> 'No hay versiones anteriores a la publicada.',

   'No write permission to'
=> 'Sin permisos de Escritura para',

   'Please pick a version to retrieve:'
=> 'Por favor elija una versión a recuperar:',

   'Private - visible to author only for testing purposes'
=> 'Privado - Visible al autor solo para fines de prueba',

#   'Private Publication - did not synchronize database'
#=> 'Publicación Privada - no se sincroniza la base de dados',

   'Public - no authentication or authorization required for use'
=> 'Público - no se requiere autenticación ni autorización para usar',

   'Retrieval of an old version will overwrite the file currently in construction space.'
=> 'La versión antigua sobreescribirá el archivo que está en el espacio de construcción',

   'Retrieve selected Version'
=> 'Recuperar Versión anterior',

   'Retrieve previous version'
=> 'Recuperar versión anterior',

   'Retrieve previous versions of [_1]'
=> 'Recuperar versiones anteriores de [_1]',

   'Search the contents of this course'
=> 'Buscar los contenidos de este curso',

   'Search the database of published resources and accessible portfolio files'
=> 'Buscar la base de datos de recursos publicados y archivos de portafolio disponibles',

   'Send broadcast and receipt-required message'
=> 'Emitir mensaje con acuso de recibo requerido',

   'Show Problem Completeness'
=> 'Mostrar lo completado de las soluciones',
#=> 'Ver evoluciones de los problemas',

   'Switch to another course'
#=> 'Cambiar a otro curso',
=> 'Cambiar de curso',

   'System wide - can be used for any courses system wide'
=> 'Alcance de Sistema - se puede usar para cualquier curso del sistema',

   'The extension on this file'
=> 'La extensión de este archivo',

   'Unsupported character combination [_1] in filename, FAIL.'
=> 'Combinación de caracteres incompatible [_1] en archivo, FALLÓ.',

   'No valid extension found in filename, FAIL'
=> 'Extensión no valida encontrada en archivo, FALLÓ',

   'Filename of resource contains internal version number. Cannot publish such resources, FAIL'
=> 'Nombre del recurso contiene número de versión interno. No puedo publicarse tales recursos, FALLÓ',

   'No valid custom distribution rights file specified, FAIL'
=> 'Archivo de derechos de distribucion personalizado específico no valido, FALLÓ',

   'Could not write metadata, FAIL'
=> 'No se pudieron escribir los meta-datos, FALLÓ',

   'View documents included in this course'
#=> 'Visualizar los documentos contenidos en este curso',
=> 'Ver documentos del curso',

   'Additional Keywords'
=> 'Palabras-Clave adicionales',

   'Additional Metadata (non-standard, parameters, exports)'
=> 'Meta-datos Adicionales (non-standard, parameters, exports)',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'Las Funciones de Co-Autor no están disponibles en otros servidores que no sea su servidor local.',

   'Author(s)'
=> 'Autor(es)',

   'Average number of tries till solved'
=> 'Número medio de intentos antes de resolver',

   'Browse Resources'
=> 'Navegar por los recursos',

   'Collapse Remote Control'
=> 'Cerrar el Control Remoto',

   'Construction Space'
=> 'Zona de Construcción',

   'Copied metadata'
=> 'Metadato copiado',

   'Copied source file'
=> 'Archivo fuente copiado',

   'Copyright/Distribution'
=> 'Copyright/Distribución',

   'Copyright/Distribution:'
=> 'Copyright/Distribución:',

   'Course Documents'
=> 'Documentos del Curso',

   'Creation Date'
=> 'Fecha de creación',

   'Custom Distribution File'
=> 'Archivo de Distribución Personalizado',

   'Degree of difficulty'
=> 'Grado de dificultad',

   'Dump Course DOCS to Construction Space'
=> 'Descargar Documentos del Curso en Zona de Construcción',

   'Dump Course DOCS to Construction Space: available on other servers'
=> 'Descargar Documentos del Curso en Zona de Construcción: disponible en otros servidores',

   'Entering course ...'
=> 'Entrando en el curso ...',

   'Exam Information'
=> 'Información de Examen',

   'External Resource'
=> 'Recurso Externo',

   'Generate new role ...'
=> 'Generar nueva función ...',

   'Go to the next resource in the course sequence'
=> 'Ir al siguiente recurso en la secuencia del curso',

   'Go to the previous resource in the course sequence'
=> 'Volver al recurso anterior en la secuencia del curso',

   'Import a published document'
=> 'Importar un documento publicado',

   'Keyword(s)'
=> 'Palabra(s) Clave(s)',

   'Logged Out'
=> 'Sesión cerrada',

   'MIME Type'
=> 'Tipo MIME',

   'Make notes and annotations about this resource'
=> 'Añadir notas y anotaciones sobre este recurso',

   'The material is covered with sufficient depth'
=> 'El material es cubierto con  suficiente profundidad',

   'Metadata Information'
=> 'Información de meta-datos',

   'My Personal Information Page'
=> 'Mi Página de Información Personal',

   'Network-wide number of accesses (hits)'
=> 'Número de accesos a través de la red (hits)',

   'Network-wide number of courses using resource'
=> 'Número de cursos en la red que utilizan este recurso',

   'Number of resources that follow this resource in maps'
=> 'Número de recursos que siguen este recurso en secuencias',

   'Number of resources that lead up to this resource in maps'
=> 'Número de recursos que carga este recurso en mapas',

   'Number of resources using or importing resource'
=> 'Número de recursos usando o importando recursos',

   'Obsolete'
=> 'Obsoleto',

   'Parent Directory'
=> 'Directorio Padre',

   'Project Information'
=> 'Información del Proyecto',

   'Publisher/Owner'
=> 'Publicante/Dueño',

   'Publishing'
=> 'Publicando',

   'Publishing [_1]'
=> 'Publicando [_1]',

   'Resource Details'
=> 'Detalles sobre el recurso',

   'Link to Resource'
=> 'Enlace Web al Recurso',

   'Searching for your resource will be based on the following metadata. Please provide as much data as possible.'
=> 'La busqueda para sus recursos sera basado en el siguiente meta-dato. Por favor provea tantos datos como le sea posible.',

   'Resource Publication'
=> 'Publicación de Recurso',

   'Resource is technically correct'
=> 'El Recurso es técnicamente correcto',

   'Score Upload Form'
=> 'Formulario para Cargar Resultados',

   'Select Map'
=> 'Seleccione Mapa/Secuencia',

   'Load Map'
=> 'Cargar Mapa/Secuencia',

   'Set a bookmark for this resource'
#=> 'Fijar un marcador para este recurso',
=> 'Establecer un marcador para este recurso',

   'Show all roles'
=> 'Mostrar todas las funciones',

   'Special documents'
=> 'Documentos especiales',

   'Subject'
=> 'Asunto',

   'Successful Login'
=> 'Login Correcto',

   'Suggested Replacement for Obsolete File'
=> 'Se sugiere el cambio para el Archivo Obsoleto',

   'Switching Role'
=> 'Cambiando Función',

   'Target'
=> 'Destino',

   'This syllabus can be publicly viewed at [_1]'
=> 'Este Plan de Estudios puede ser visto públicamente en [_1]',

   'Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Parameters[_2].'
=> 'En lugar de usar este modelo usted puede especificar un URL externo como Plan de estudios en los [_1]Parámetros del Curso[_2].',

   'Total number of students who have worked on this problem'
=> 'Número total de estudiantes que han trabajado en este problema',

   'URLs To Include in Syllabus'
=> 'URLs para Incluir en Plan de Estudios',

   'Upload a new main course document'
=> 'Cargar un nuevo documento principal para el curso',

   'Upload a new supplemental course document'
=> 'Cargar un nuevo Documento Suplemental para el curso',

   'User'
=> 'Usuario',

   'Wrote Metadata'
=> 'Meta-dados Escritos',

   'Your home server is '
=> 'Su servidor local es ',

   'announce'
=> 'notícias',

   'bookmark'
=> 'marcador',

   'chart'
=> 'cuadro',

   'chat'
=> 'chat',

   'close this window'
=> 'cerrar esta ventana',

   'docs'
=> 'documentos',

   'exit'
=> 'salir',

   'library'
=> 'catálogo',

   'log in again'
=> 'logar otra vez',

   'my'
=> 'mis',

   'or'
=> 'o',

   'Or'
=> 'O',

   'prepare'
=> 'Preparar',

   'printout'
=> 'impresión',

   'resource'
=> 'recurso',

   'roles'
=> 'funciones',

   'search'
=> 'busqueda',

   'set'
=> 'establecer',

   'space'
=> 'publicado(s)',

   'stats'
=> 'estadísticas',

   'struct'
=> 'de recursos',

   'switch'
=> 'intercambiar',

   'updated periodically'
=> 'actualizado periódicamente',

   'user'
=> 'usuario',

   'visible to author and co-authors only'
=> 'sólamente visible para autor y co-autores',

   'All versions'
=> 'Todas las versiones',

   'Default Metadata for Directory [_1]'
=> 'Metadatos para el Directorio [_1]',

   'Error Messages'
=> 'Mensajes de Error',

   'Update Display'
=> 'Actualizar Pantalla',

   'Content changed'
=> 'Contenido cambiado',

   'Differences'
=> 'Diferencias',

   'Last Week'
=> 'Semana Pasada',

   'Modification Date'
=> 'Fecha de Modificación',

   'Since Start of Course'
=> 'Desde el Inicio del Curso',

   'Since Yesterday'
=> 'Desde Ayer',

   'Verify Course Documents'
=> 'Verificar Documentos del Curso',

   'Version'
=> 'Version',

   'access denied'
=> 'acceso denegado',

   'connection down'
=> 'sin conexión',

   'during the last'
=> 'durante la última',

   'not found'
=> 'no se encuentra',

   'warning(s)'
=> 'advertencia(s)',



#SYNC Mon Sep 29 11:02:04 2003

   'Advanced Catalog Search'
=> 'Búsqueda Avanzada del Catálogo',

   'Advanced Search'
=> 'Búsqueda Avanzada',

   'Any Language'
=> 'Cualquier Idioma',

   'Any category'
=> 'Cualquier Categoria',

   'Any copyright/distribution'
=> 'Cualquier copyright/distribución',

   'Broadcast Message to Course'
=> 'Enviar Mensajes para todos los Usuarios del Curso',

   "Click to download or use your browser's Save Link function"
=> "Haga click para bajar o usar la función de guardar enlace del navegador",

   'Close'
=> 'Cerrar',

   'Compact View'
=> 'Vista Compacta',

   'Detailed Citation View'
=> 'Vista detallada de Citación',

   'Distribute Messages from Uploaded File to Course'
=> 'Distribuir Mensajes de los Archivos Cargados para el curso',

   'Edit Metadata'
=> 'Editar Metadatos',

   'Edit Content of a Map'
=> 'Editar Contenido del Mapa',

   'Edit Directory Metadata'
=> 'Editar Directorio de Metadatos',

   'Evaluate Resource'
=> 'Evaluar Recurso',

   'Failed Access to Construction Space'
=> 'Acceso Fallido a Zona de Construcción',

   'Fielded Format'
=> 'Formato en Campos',

   'File Category'
=> 'Categoria del Archivo',

   'Force publication of unmodified files'
=> 'Forzar publicación de archivos no modificados',

   'Keywords'
=> 'Palabras Claves',

   'Last access'
=> 'Último acceso',

   'Last modified'
=> 'Última modificación',

   'Limit by copyright/distribution'
=> 'Limitado por copyright/distribuición',

   'Limit by language'
=> 'Limitado por idioma',

   'Open'
=> 'Abrir',

   'Per Page'
=> 'Por página',

   'Printing Helper'
=> 'Asistente de Impresión',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'Producir mensajes de reacción o contribuir a la discusión sobre este recurso',

   'Provide my evaluation of this resource'
=> 'Producir mi evaluación de este recurso',

   'Publish'
=> 'Publicar',

   'Publish Directory'
=> 'Publicar Directorio',

   'Publish Directory and Sub Directories'
=> 'Publicar Directorio y Sub-Directorios',

   'Related'
=> 'Relacionado',

   'Resource Feedback and Discussion'
=> 'Reacción al Recurso y discusión',

   'Search Complete'
=> 'Busqueda Completa',

   'Show Metadata'
=> 'Mostrar Metadatos',

   'Show resource'
=> 'Mostrar recurso',

   'Statistics'
=> 'Estadísticas',

   'Summary View'
=> 'Ver Resumen',

   'There are currently no results.'
=> 'No hay resultados por el momento.',

   'Search: '
=> 'Buscar: ',

   'URL'
=> 'URL',

   'Unpublished'
=> 'No Publicado',

   'Up'
=> 'Arriba',

   'View'
=> 'Ver',

   'Display Critical Messages'
=> 'Ver Mensajes Críticos',

   'Words'
=> 'Palabras',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
#=> 'extracto',
=> 'resumen',

   'audio'
=> 'audio',

   'author'
=> 'autor',

   'catalog'
=> 'Catálogo',

   'copyright'
=> 'copyright',

   'directory'
=> 'directorio',

   'info'
=> 'info',

   'keywords'
=> 'palabras clave',

   'language'
=> 'idioma',

   'movies'
=> 'películas',

   'notes'
=> 'notas',

   'obsolete'
=> 'obsoleto',

   'pages'
=> 'páginas',

   'pictures'
=> 'imagenes',

   'problem'
=> 'problema',

   'resources'
=> 'recursos',

   'sequence'
=> 'secuencia',

   'subject'
=> 'asunto',

   'this'
=> 'este',

   'title'
=> 'Título',

#SYNC Sat Oct  4 20:36:34 2003

   'Group Discussion Boards'
=> 'Foros de Discusión Grupal',

   'Group Discussion Board'
=> 'Foro de Discusión Grupal',

   'Course Discussion Board'
=> 'Foro de Discusión del Curso',

   'Clear All'
=> 'Limpiar Todo',

   'Close All Folders'
=> 'Cerrar Todas las Carpetas',

   'Construction Space File Operation'
=> 'Operación de Archivo de Zona de Construcción',

   'Copied old metadata'
=> 'Meta-dato antiguo copiado',

   'Failed to write old metadata copy'
=> 'Falló guardar copia de meta-dato antiguo',

   'Copied old target file'
=> 'Archivo de destino antiguo copiado',

   'Failed to copy old target'
=> 'Falló copiar destino antiguo',

   'Created directory [_1]'
=> 'Directorio Creado [_1]',

   'Copyright'
=> 'Copyright',

   'Could Not Process Request'
=> 'No se Puede Procesar su Petición',

   'Default'
=> 'Defecto',

   'Discard Selected'
=> 'Descartar Selección',

   'Edit this resource'
=> 'Editar este recurso',

   'Enter construction space as co-author'
=> 'Entrar en Zona de Construcción como Co-Autor',

   'Enter construction space as a co-author'
=> 'Entrar en Zona de Construcción como un Co-Autor',

   'Enter construction space as assistant co-author'
=> 'Entrar en Zona de Construcción como Co-Autor asistente',

   'Host'
=> 'Host',

   'Last updated'
=> 'Última actualización',

   'Mime type'
=> 'Tipo Mime',

   'Modified'
=> 'Modificado',

   'Modify deadlines, etc, for this assessment resource'
=> 'Modifica plazos finales, etc. para este recurso de validación',

   'Modify user grades for this assessment resource'
=> 'Modificar notas de usuario para este recurso de validación',

   'View user submissions for this assessment resource'
=> 'Ver invíos de usuario para este recurso de validación',

   'Move Down'
=> 'Mover para Abajo',

   'Move Up'
=> 'Mover para Arriba',

   'New Title'
=> 'Nuevo Título',

   'Open All Folders'
=> 'Expandir todas las Carpetas',

   'Owner/Publisher'
=> 'Dueño/Publicante',

   'Personal Information Page - [_1]'
=> 'Página de Información Personal - [_1]',

   'Go to personal information page for [_1]'
=> 'Ir a página de información personal para [_1]',

   'Viewable files - [_1]'
=> 'Archivos visibles - [_1]',

   'Viewable portfolio files for [_1]'
=> 'Archivos de portafolio visible para [_1]',

   'Personal Information Page'
=> 'Página de Información Personal',

   'Personal Information'
=> 'Información Personal',

   'Privacy Note:'
=> 'Nota Privada:',

   'Published'
=> 'Publicado',

   'Reading results from'
=> 'Leyendo resultados de',

   'Retrieve'
=> 'Recuperar',

   'Revert to Last Saved'
=> 'Volver a la Última Versión Guardada',

   'Revision Date'
=> 'Fecha de Revisión',

   'Shared by course faculty and staff'
=> 'Compartido por profesores de curso y personal',

   'Synchronized SQL metadata database'
=> 'Base de meta-datos SQL sincronizada',

   'Task'
=> 'Tarea',

   'Temporary Assembly Workspace'
=> 'Zona de Trabajo Temporal',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'La información que ha introducido puede ser vista por cualquiera que entre en LON-CAPA. No proporcione información que no esté dispuesto a compartir públicamente.',

   'Topic'
=> 'Tópico',

   'Upload a Photo'
=> 'Carga de una imagen',

   'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages'
=> 'Notas de Usuarios, Cara-a-Cara, Mensajes Crítoocs, Mensajes de difusión, Mensajes Archivados',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'Notas de Usuarios, Registros de Discusiones Cara-a-Cara, y Mensajes Críticos',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'Notas de Usuarios, Registros de Discusiones Cara-a-Cara, y Mensajes Críticos en el Curso',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course'
=> 'Notas de Usuarios, Registros de Discusiones Cara-a-Cara, Mensajes Críticos, Mensajes de difusión y Mensajes Archivados en el Curso',

   'No notes, face-to-face discussion records, critical messages, or broadcast messages in this [_1].'
=> 'NO hay notas, registros de discusiones cara-a-cara, mensajes críticos, o mensajes de difusión en este [_1].',

   'No notes, face-to-face discussion records, critical messages or broadcast messages in this [_1].'
=> 'NO hay notas, registros de discusiones cara-a-cara, mensajes críticos o mensajes de difusión en este [_1].',

   'Version Number'
=> 'Número de Versión',

   'View Published Version'
=> 'Ver Versiones Publicadas',

   'Web References'
=> 'Referencias Web',

   'co res'
=> 'co res',

   'contacting'
=> 'contactando',

   'edit'
=> 'editar',

   'interface available'
=> 'Interfaz disponible',

   'missions'
=> 'misiones',

   'view sub-'
=> 'visualizar sub-',

   'waiting on'
=> 'esperando',

#SYNC Wed Oct  8 14:13:34 2003

   '#Stdnts'
=> '#Estudiantes',

   '#YES'
=> '#SI',

   '%Wrng'
=> '%Errados',

   'Brief view of each students performance in course.'
#=> 'Breve resumen de evolución de cada estudiante en el curso.',
=> 'Breve resumen del desempeño de cada estudiante en el curso.',

   'Clear Caches'
=> 'Limpiar Caches',

   'Course Statistics and Charts cannot be retrieved until the database is restarted. Your data is intact but cannot be displayed at this time.'
=> 'No se mostrarán las Estadísticas del curso y los Gráficos hasta que la base de datos se reinicie. Sus datos están intactos, pero no se mostrarán por ahora.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Estadísticas detalladas y gráficos del desempeño de los estudiantes en los problemas.',

   'DoDiff'
=> 'Calcula Diff',

   'Enrollment Status'
=> 'Estado de las Inscripciones',

   'Generate Statistics'
=> 'Generar Estadísticas',

   'Max Tries'
=> 'Máx. de Intentos',

   'Mean Tries'
=> 'Media de Intentos',

   'Output'
=> 'Salida',

   'Overall Problem Statistics'
=> 'Estadísticas globales de los ejercicios',

   'Please notify the server administrator [_1]'
=> 'Por favor, notifique al administrador del servidor [_1]',

   'Preparing Excel Spreadsheet'
=> 'Preparar Hoja de Cálculo Excel',

   'Problem Status Chart'
=> 'Problema de dos Estados',

   'S.D. tries'
=> 'Desv. Estd. Intentos',

   'Sections'
=> 'Secciones',

   'Sequence or Folder'
=> 'Secuencia o Carpeta',

   'Sequences and Folders'
=> 'Secuencias y carpetas',

   'Skew Tries'
=> 'Intentos sesgados',

   'Statistics and Problem Analysis'
=> 'Estadísticas y Análisis de Problemas',

   'Student performance statistics on all problems.'
=> 'Estadísticas de desempeño del estudiante en todos los problemas.',

   'Unable to connect to database!'
=> '¡No se pudo conectar con la base de datos!',

   'Your Excel Spreadsheet'
=> 'Su Hoja de Cálculo Excel',

   'Your Excel spreadsheet.'
=> 'Su Hoja de cálculo Excel.',

   'Your Excel spreadsheet'
=> 'Su Hoja de cálculo Excel',

   'Your CSV file.'
=> 'Su archivo CSV.',

   'Your CSV file'
=> 'Su archivo CSV',

   'part'
=> 'parte',

   'part - '
=> 'parte - ',

   'problem statistics grouped by sequence'
=> 'estadísticas de problemas agrupadas por secuencias',

   'problem statistics ungrouped'
=> 'estadísticas de problemas desagrupadas',

   'problem statistics, Excel'
=> 'estadísticas de problemas, Excel',

#SYNC Wed Oct  8 14:49:53 2003
   'Significant figures are incorrect, submission was not graded.'
=> 'Las figuras significantivas son incorrectas, lo enviado no se ha calificado.',

#SYNC Fri Oct 10 11:36:26 2003

   '. . . for a particular section'
=> '. . . para una sección particular',

   '. . . for all students in the course'
=> '. . . para todos los estudiantes del curso',

   '. . . for an individual student'
=> '. . . para un solo estudiante',

   '12 am' # midnight
=> '00:00',

   'midnight'
=> 'media noche',

   '1 am'
=> '1:00',

   '2 am'
=> '2:00',

   '3 am'
=> '3:00',

   '4 am'
=> '4:00',

   '5 am'
=> '5:00',

   '6 am'
=> '6:00',

   '7 am'
=> '7:00',

   '8 am'
=> '8:00',

   '9 am'
=> '9:00',

   '10 am'
=> '10:00',

   '11 am'
=> '11:00',

   '12 noon'
=> '12:00',

   'noon'
=> 'medio dia',

   '1 pm'
=> '13:00',

   '2 pm'
=> '14:00',

   '3 pm'
=> '15:00',

   '4 pm'
=> '16:00',

   '5 pm'
=> '17:00',

   '6 pm'
=> '18:00',

   '7 pm'
=> '19:00',

   '8 pm'
=> '20:00',

   '9 pm'
=> '21:00',

   '10 pm'
=> '22:00',

   '11 pm'
=> '23:00',

   'ALL'
=> 'TODO',

   'All Maps or Folders'
=> 'Todos los Mapas o Carpetas',

   'Any User'
=> 'Cualquier Usuario',

   'Assessment URL and Title'
=> 'Evaluación de URL y título',

   'Assigned User Roles'
=> 'Funciones Asignadas al Usuario',


   'Browse resources'
=> 'Navegar por los recursos',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Los cambios pueden tardar más de 10 minutos en estar activos para todos los estudiantes.',

   'Course Assessment Parameter - Helper Mode'
=> 'Parámetros de Evaluación del Curso - Modo Asistente',

   'Course Assessment Parameters - Overview Mode'
=> 'Parámetros de Evaluación del Curso - Modo Overview',

   'Course Assessments Parameters - Table Mode'
=> 'Parámetros de Evaluación del Curso - Modo Tabla',

   'Course Environment Parameters'
=> 'Parámetros de Entorno del Curso',

   'Course Parameter Helper'
=> 'Asistente de Parámetros de el Curso',

   'Create New Environment Variable'
=> 'Crea Nueva Variable de Entorno',

   'Current Session Value'
=> 'Valor de Sesión Actual',

   'Default Value'
=> 'Valor Por Defecto',

   'Delete a role'
=> 'Eliminar una función',

   'Disable all communication among students'
=> 'Deshabilitar toda la comunicación entre los estudiantes',

   'Enclosing Map or Folder'
=> 'Incluir Mapa o Carpeta',

   'Every problem in a particular folder'
=> 'Cada problema en una carpeta particular',

   'Every problem in the course'
=> 'Cada problema del curso',

   'Folder'
=> 'Carpeta',

   'Grant/revoke Course Custom Role'
=> 'Añadir/Eliminar Función Personalizada al Curso',

   'Grant/revoke role of Administrator'
=> 'Añadir/Eliminar función de Administrador',

   'Grant/revoke role of Author'
=> 'Añadir/Eliminar función de Autor',

   'Grant/revoke role of Course Coordinator'
=> 'Añadir/Eliminar función de Coordinador de Curso',

   'Grant/revoke role of Domain Guest'
=> 'Añadir/Eliminar función de Invitado de Dominio',

   'Grant/revoke role of Librarian'
=> 'Añadir/Eliminar función de Bibliotecario',

   'Grant/revoke role of Teaching Assistant'
=> 'Añadir/Eliminar función de Asistente del Profesor',

   'Internally authenticated'
=> 'Autentificado Internamente',

   'Kerberos authenticated'
=> 'Autentificado por Kerberos',

   'LON-CAPA Helper:'
=> 'Asistente de LON-CAPA:',

   'Lock and unlock assessments'
=> 'Bloquear y desbloquear evaluaciones',

   'Manage Access Keys'
=> 'Gestionar Claves de Acceso',

   'Manage access keys'
=> 'Gestionar claves de acceso',

   'Max Possible To Date'
#=> 'Fecha Máx. posible Para',
=> 'Máx. posible a la Fecha',

   'Modify Course Assessment Parameters'
#=> 'Modificar Parámetros de Acceso al Curso',
=> 'Modificar Parámetros de Evaluación  del Curso',

   'Modify authentication mechanism and data for a user'
=> 'Modificar mecanismo de autenticación y los datos de un usuario',

   'Modify grades'
=> 'Modificar notas',

   'One particular problem'
=> 'Un problema particular',

   'Parameter Name'
=> 'Nombre del Parámetro',

   'Parameter Type'
=> 'Tipo de Parámetro',

   'Parameter in Effect'
=> 'Parámetro en Efecto',

   'Please select a problem to analyze'
=> 'Por favor, selecione un problema para analizar',

   'Post anonymously'
=> 'Enviar anónimamente',

   'Post discussion on course resources'
=> 'Enviar discusión en los recursos del curso',

   'Post system frontpage announcements'
=> 'Enviar anuncios en la página principal del sistema',

   'Post to chat rooms'
=> 'Enviar a los chat',

   'Problems Not Contained In A Folder'
=> 'Problemas que no estan contenidos en una carpeta',

   'Section'
=> 'Sección',

   'Section:'
=> 'Sección:',

   'Select Date'
=> 'Selecione una Fecha',

   'Select Enclosing Map or Folder'
=> 'Selecione un Mapa o una Carpeta',

   'Select Parameter Level'
=> 'Seleccione Nível de Parámetro',

   'Send internal message'
=> 'Enviar mensaje interno',

   'Set Course Environment Parameters'
=> 'Establecer Parametros de Entorno del Curso',

   'Set Date'
=> 'Establecer Fecha',

   'Set Defaults for All Resources in [_1]Specifically for [_2][_3]'
=> 'Establecer Parámetros predefinidos a Todos los Recursos en [_1]Específicamente para [_2][_3]',

   'Set a due date'
=> 'Establecer fecha de vencimiento',

   'Set an answer open date'
=> 'Establecer fecha para publicar respuestas',

   'Set an open date'
=> 'Establecer fecha de inicio',

   'Set opening datefor all problems in the course for. . .'
=> 'Establecer fecha de inicio de todos los problemas del curso para. . .',

   'Set the number of tries'
=> 'Establecer el número de intentos',

   'Set the problem weight'
=> 'Establecer el valor del puntaje del problema',

   'Set/Modify Course Assessment Parameter'
#=> 'Fijar/Modificar los Parámetros de Validación del Curso',
=> 'Establecer/Modificar Parámetro de Evaluación del Curso',

   'Set/Modify Course Assessment Parameters'
#=> 'Fijar/Modificar Parámetros de Validación del Curso',
=> 'Establecer/Modificar Parámetros de Evaluación del Curso',

   'Set/Modify Course Parameters'
#=> 'Fijar/Modificar Parámetro del Curso',
=> 'Establecer/Modificar Parámetros del Curso',

   'Show More Options'
=> 'Mostrar Más Opciones',

   'Students Affected'
=> 'Estudiantes Afectados',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Este asistente le ayudará a establecer las fechas de inicio, de vencimiento y de publicar respuesta de los problemas, o estableciendo el número de intentos de los problemas. Se le pedirá que seleccione los problemas que desea establecer los parámetros, después qué parámetros quiere cambiar y a quién quiere que afecten los cambios. Después del asistente, se le mostrará en el interfaz avanzado para que en el futuro pueda hacerlo directamente. Pulse Siguiente -&gt; para iniciar, o elija &lt;- Anterior para volver a la pantalla anterior.',

   'Total'
=> 'Total',

   'Total Parts In Course'
=> 'Total de Partes del Curso',

   'Type'
=> 'Tipo',

   'Type: [_1]'
=> 'Tipo: [_1]',

   'UNIX authenticated'
=> 'autentificado por UNIX',

   'USERS'
=> 'USUARIOS',

   'Unknown ID'
=> 'ID desconocida',

   'Unknown user'
=> 'Usuario desconocido',

   'Update Course Assessment Parameter Display'
=> 'Actualizar la Pantalla de Parámetros de Evaluación del Curso',#=> 'Actualizar La Pantalla de Parámetros de Validación',

   'Update Section or Specific User'
=> 'Actualizar Sección o un Usuario Específico',

   'Verify Selection'
=> 'Verificar Selección',

   'Welcome to the Assignment Parameter Helper'
#=> 'Bienvenido al Asistente de Parámetros de Configuración',
=> 'Bienvenido al Asistente de Asignación de Parámetros',

   'What parameter do you want to set for all problems in the course?'
#=> '¿Qué parámetro quiere configurar para todos los problemas del curso?',
=> '¿Qué parámetro quiere establecer para todos los problemas del curso?',

   'What should the opening date be set to?'
#=> '¿Para cuando quiere configurar la fecha de apertura?',
=> '¿Para cuando quiere establecer la fecha de inicio?',

   'Which Problem or Problems?'
=> '¿Qué Problema o Problemas?',

   'Which problems do you wish to set a parameter for?'
#=> '¿Para que problemas quiere configurar algún parámetro?',
=> '¿Para que problemas desea establecer algún parámetro?',

'You need to choose another user role or enter a specific course or community for this function.'
=> 'Necesita elegir otra función de usuario o entrar a un curso o comunidad específico para esta función.', # 'Necesita elegir otra función o introducir un curso específico para esta función',

   'a.m.'
=> 'a.m.',

   'acc keys'
=> 'clav. de acceso',

   'according to course preferences'
=> 'de acuerdo a las preferencias del curso',

   'according to resource settings'
=> 'de acuerdo a la configuración de recurso',

   'according to user session state'
=> 'de acuerdo al estado de sesión del usuario',

   'all'
=> 'todo',

   'at'
=> 'en',

   'at Domain'
=> 'en Dominio',

   'at domain'
=> 'en dominio',

   'default'
=> 'por defecto',

   'for Enclosing Map or Folder'
#=> 'para el incluir Mapa o Carpeta',
=> 'para Mapa adjuntado o Carpeta',

   'for Resource'
=> 'para el Recurso',

   'from Enclosing Map or Folder'
#=> 'desde incluir Mapa o Carpeta',
=> 'desde Mapa adjuntado o Carpeta',

   'general'
=> 'general',

   'in Course'
=> 'en Curso',

   'in Section/Group'
=> 'en Sección/Grupo',

   'manage'
=> 'gestionar',

   'of'
=> 'de',

   'or ID'
=> 'o ID',

   'p.m.'
=> 'p.m.',

   'percent'
#=> '%',
=> 'porciento',

   'unless locked'
=> 'a menos que esté bloqueado',

   'users in'
=> 'usuarios en',

#SYNC Tue Oct 14 14:28:20 2003

   'Access Key Management'
#=> 'Gestión de claves de Acceso',
=> 'Gestor de claves de Acceso',

   'Assessment'
#=> 'Validación',
=> 'Evaluación',

   'Calculations'
=> 'Cálculos',

   'Comma Separated Values'
=> 'Valores separados por Coma (CSV)',

   'Course ID'
=> 'ID (identificación) del curso',

   'Course level sheet'
=> 'Plantilla - nivel del curso',

   'Detailed Problem Analysis'
=> 'Análisis detallado de los Problemas',

   'End Helper'
=> 'Finalizar Asistente',

   'Excel'
=> 'Excel',

   'Text (essays only)'
=> 'Texto (solo ensayos)',

   'Finish Course Initialization'
#=> 'Final de Internacionalización del Curso',
=> 'Final de Inicialización del Curso',

   'Generate Spreadsheet'
=> 'Generar Hoja de Cálculo',

   'Grant/revoke role of Bubblesheet Scanning Operator'
=> 'Añadir/Eliminar Función de Operador de Escaneo de Hoja de Respuesta',

   'HTML'
=> 'HTML',

   'Invalid date entry'
=> 'Entrada de datos inválida',

   'Load:'
=> 'Carga:',

   'No changes were made to the current settings.'
=> 'No se hicieron cambios a la configuración actual.',

   'Output Format'
=> 'Formato de Salida',

   'Processing course structure'
=> 'Procesando estrutura del curso',

   'Processing first student'
=> 'Procesando primer estudiante',

   'Row'
=> 'fila',

   'Save as'
=> 'Guardar como',

   'Save as &amp; Make This Sheet the Default'
=> 'Guardar Como y Hacer esta Hoja por Defecto',

   'Bubblesheet Scanning Operator'
=> 'Operador de escaneo de Hoja de Respuesta',

   'Select All'
=> 'Seleccionar Todo',

   'Select All Students'
=> 'Seleccionar Todos los Estudiantes',

   'Select Spreadsheet File'
=> 'Seleccione un Archivo de Hoja de Cálculo',

   'Send bubblesheet data to a course'
=> 'Enviar datos de hoja de respuestas para un curso',

   'Spreadsheet Computation'
#=> 'Procesado de Plantilla',
=> 'Computo de Hoja de Cálculo',

   'Spreadsheet Computation Status'
#=> 'Estado del Procesado de Plantilla',
=> 'Estado del Procesado de Hoja de Cálculo',

   'Student level sheet'
=> 'Hoja de cálculo - nivel de estudiante',

   'Summary'
#=> 'Sumario',
=> 'Resumen',

   'Template'
=> 'Modelo',

   'Unselect All'
=> 'Deseleccionar Todo',

   'Unselect All Students'
=> 'Deseleccionar Todos los Estudiantes',

   'Upload bubblesheet data'
=> 'Cargar datos Hoja de Respuesta',

   'You must choose at least one student to continue.'
=> 'Debería seleccionar al menos un estudiante para continuar.',

   'You must choose one or more choices to continue.'
=> 'Debería seleccionar uno o más opciones para continuar.',

   'may be open from a different computer.'
=> 'puede que esté abierto en otro ordenador.',

   'minutes'
=> 'minutos',

   'remaining'
=> 'restante',

   'second'
=> 'segundo',

   'seconds'
=> 'segundos',

#SYNC Wed Oct 15 20:34:21 2003

   'Additional Recipients'
=> 'Destinatarios Adicionales',

   'Analyze Over [_1] [_2]'
=> 'Analizar Sobre [_1] [_2]',

   'Analyze Problem'
=> 'Analizar Problema',

   'Analyze Problem Again'
=> 'Analizar Problema Otra vez',

   'Analyze as '
=> 'Analizar como ',

   'Browsing resource, all submissions are temporary.'
#=> 'Navegando por los recursos, todos los cambios serán temporales.',
=> 'Navegando por los recursos, todos las contestaciones serán de carácter temporal.',

   'By'
=> 'Por',

   'Check All'
=> 'Seleccionar Todo',

   'Check for All'
=> 'Seleccionar para Todos',

   'Check for None'
=> 'Seleccionar para Ninguno',

   'Check for Section/Group'
=> 'Seleccionar por Sección/Grupo',

   'Choose a different resource'
=> 'Seleccione un recurso diferente',

   'Concepts'
=> 'Conceptos',

   'Critical Messages'
=> 'Mensajes Críticos',

   'Delete'
=> 'Borrar',#=> 'Excluir',

   'Delete Checked'
=> 'Borrar Seleccionados',#=> 'Excluir Seleccionados',

   'Display All Messages'
=> 'Mostrar Todos los Mensajes',

   'Foils'
=> 'Alternativas',

   'Forward'
=> 'Reenviar',

   'Forwarded message from'
=> 'Mensaje reenviado de',

   'Forwarding'
=> 'Reenviando',

   'From'
=> 'De',

   'Functions'
=> 'Funciones',

   'Mail'
=> 'Mail',

   'Mark Unread'
=> 'Marcado como No Leído',

   'New Problem Variation'
=> 'Nueva Variación del Problema',

   'New Randomization'
=> 'Nueva Aleatorización',

   'Next'
=> 'Siguiente',

   'Number of Plots [_1]'
=> 'Número de Gráficos [_1]',

   'Option Response Problem Analysis'
#=> 'Análisis de problema de Responder un opción',
=> 'Opción de Análisis de Respuestas al Problema',

   'Re'
=> 'Re',

   'Record'
=> 'Registro',

   'Reset Submissions'
=> 'Reiniciar Envios',

   'Select a course'
=> 'Seleccione un curso',

   'Selecting a User'
=> 'Seleccione un Usuario',

   'Send New'
=> 'Enviar',

   'Send Reply'
=> 'Enviar Respuesta',

   'Send as critical message'
=> 'Enviar como mensage crítico',

   'Simple Problem Editor'
=> 'Editor de Problema Simplificado',

   'Starting'
=> 'Iniciando',

   'Student Data Compilation Progress'
=> 'Progreso de la Compilación de los Datos del Estudiante',

   'Student Data Compilation Status'
=> 'Estado de la Compilación de los Datos del Estudiante',

   'Time'
=> 'Tiempo',

   'To'
=> 'Para',

   'Uncheck All'
=> 'Deseleccionar Todo',

   'Unsuccessful Login'
=> 'Login no Correcto',

   'Update Student Data'
=> 'Actualizar datos del estudiante',

   'You have no critical messages.'
=> 'No tiene mensajes críticos.',

   'and return receipt'
=> 'y recibo de devolución',

   'can not be accessed from your location.'
=> 'no se puede acceder desde su localización.',

#SYNC Fri Nov  7 16:59:44 2003

   '[_1]: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '[_1]: No se acepta ese Nombre de usuario [_2] [_3] [_4] [_5]',

   'All Documents in Course'
=> 'Todos los documentos del Curso',

   'All Resources (possibly large output)'
=> 'Todos los Recursos (salida posíblemente extensa)',

   'Anonymous'
=> 'Anónimo',

   'Anonymous contribution to course discussion of resource'
=> 'Contribución anónima para la discusión del recurso del curso',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Como regla general, solo los autores o co-autores debería ser autentificados por el sistema de archivos (que permite acceso al servidor de archivos).',

   'Associate columns with student attributes.'
=> 'Asociar columnas con atributos de estudiante.',

   'Attribute'
=> 'Atributo',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (hoja de cálculo, valores separados por coma)',

   'Check Course Document Versions'
=> 'Comprobar las Versiones de los Documentos del Curso',

   'Check/Set Resource Versions'
#=> 'Comprobar/Fijar Versiones de Recurso',
=> 'Comprobar/Establecer Versiones de Recurso',

   'Chronological View'
=> 'Visualización Cronológica',

   'Column'
=> 'Columna',

   'Column [_1]'
=> 'Columna [_1]',

   'Continue enrollment?'
=> '¿Continuar matrícula?',

   'Contribution to course discussion of resource'
=> 'Contribución a la discusión del recurso',

   'Diffs'
=> 'Diferencias',

#   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
#=> 'Desabilitar verificación de conflitos de ID/número de identificación de los estudiantes, y forzar cambios de IDs conflictivas (solamente haga esto si sabe lo que está haciendo).',


   'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> 'Desabilitar bloqueo de seguridad de ID(número de identificación) de Estudiante/Empleado y forzar cambios de IDs conflictivas.',

   '(only do if you know what you are doing.)'
=> '(solamente haga esto si sabe lo que está haciendo.)',

   'Discussion Contributions'
=> 'Contribuciones para Discusión',

   'Drop Students'
=> 'Retirar Estudiante(s)',#=> 'Excluir Estudiante(s)',

   'Dropped [_1]'
=> 'Retirado [_1]',#=> 'Excluído [_1]',

   'Dropped [quant,_1,student].'
=> '[quant,_1,Estudiante Retirado,Estudiantes Retirados].',

   'Dropping Students'
=> 'Retirando Estudiantes',#=> 'Excluyendo Estudiantes',

   'Dump Course Documents'
=> 'Lanzar DOCS del curso',#=> 'Excluir DOCS del curso',

   'Enroll a single student'
=> 'Matricular un único estudiante',

   'Enrolling Students'
=> 'Matriculando estudiantes',

   'Error'
=> 'Error',

   'Error: '
=> 'Error: ',

   'Error: [_1]'
=> 'Error: [_1]',

   'Field'
=> 'Campo',

   'Filenames in Construction Space'
=> 'Nombres de archivos en el Espacio de Construcción',

   'Folder in Construction Space'
=> 'Carpetas en Zona de Construcción',

   'Full Update'
=> 'Actualización Completa',

   'Full update (also print list of users not enrolled anymore)'
=> 'Actualización completa (también imprime lista de usuários que no se matricularán)',

   'Generation'
=> 'Generación',

   'Group/Section'
=> 'Grupo/Sección',

   'HTML/XML'
=> 'HTML/XML',

   'Hide'
=> 'Ocultar',

   'Student/Employee ID'
=> 'Estudiante/Empleado ID',

   'Identify fields'
#=> 'Campos de Identificación',
=> 'Identificar los Campos',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'Si está activa, la nueva función se activará cuando los estudiantes entren la próxima vez en LON-CAPA.',

   'Ignore First Line'
=> 'Ignorar Primera Línea',

   'Initial Password'
=> 'Contraseña Inicial',

   'Internal Filename'
=> 'Nombre de archivo interno',

   'Invalid home server specified'
=> 'Nombre de servidor local especificado NO Valido',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Mantener todos los Recursos actualizados con las Versiones más recientes(Por defecto)',

   'LON-CAPA Domain for Students'
=> 'Dominio LON-CAPA para los estudiantes',

   'LON-CAPA Enrollment Manager'
=> 'Gestor de Matrículas de LON-CAPA',

   'LON-CAPA domain: [_1]'
=> 'Dominio LON-CAPA: [_1]',

   'First Name'
=> 'Nombre',

   'Middle Name'
=> 'Segundo Nombre',

   'Last Name'
=> 'Apellidos',

   'Last Name, First Names'
=> 'Apellidos, Nombres',

   'Login Type'
=> 'Tipo de Login',

   'Middle Names/Initials'
=> 'Nombres /Iniciales',

   'Modify Parameters'
=> 'Modificar Parámetros',

   'Modify student data'
=> 'Modificar datos de un estudiante',

   'Most recently published Version'
=> 'Versión publicada más reciente',

   'None Found'
=> 'No se ha Encontrado',

   'Note: For large courses, this operation may be time consuming.'
=> 'Nota: Para cursos extensos, esta operación se podrá tomar algo de tiempo.',

   'This will not take effect if the user already exists.'
=> 'Esto no tendrá ningún efecto si el usuario ya existe.',

   'Processed [quant,_1,student].'
=> '[quant,_1,estudiante procesado,estudiantes procesados].',

   'Re-enrollment will re-activate data.'
=> 'Re-matrícula volverá a actualizar los datos.',

   'Registering clickers: [_1]'
=> 'Registrando clickers: [_1]',

   'Samples'
=> 'Ejemplos',

   'Save as ...'
=> 'Guardar como ...',

   'Set Version to be used in Course'
#=> 'Fijar Versión para ser usada en curso',
=> 'Establecer Versión para ser usada en curso',

   'Set Versions to be used in Course according to Selections below'
#=> 'Fijar Versión para ser usada en Curso de acuerdo a la selección de abajo',
=> 'Establecer Versión para ser usada en Curso de acuerdo a la selección de abajo',

   'Set all Resource Versions to current Version (Fix Versions)'
#=> 'Fijar todas las Versiones de los Recursos para la Versión Actual (Corregir Versiones)',
=> 'Establecer todas las Versiones de los Recursos a la Versión Actual (Fijar Versiones)',

   'Show Preview'
=> 'Pre-visualizar',

   'Space separated'
=> 'Separado por espacio',

   'Starting and Ending Dates'
=> 'Fechas de Inicio y Fin',

   'Tabulator separated'
=> 'Separado por tabulador',#=> 'Tabulator separado??'

   'The optional e-mail address field was not specified.'
=> 'El campo opcional de E-Mail no se ha especificado.',

   'The optional name field was not specified.'
=> 'El campo opcional de nombre no se ha especificado.',

   'The optional student/employee ID field was not specified.'
=> 'El campo opcional de ID de estudiante/empleado no se ha especificado.',

   'The optional section or group field was not specified.'
=> 'El campo opcional sección/grupo no se ha especificado.',

   'The optional section field was not specified.'
=> 'El campo opcional sección no se ha especificado.',

   'The optional role field was not specified.'
=> 'El campo opcional función no se ha especificado.',

   'The optional domain field was not specified.'
=> 'El campo opcional dominio no se ha especificado.',

   'There are no students currently enrolled.'
=> 'No hay estudiantes matriculados en este momento.',

   'Continue adding users?'
=> 'Continuar añadiendo usuarios?',

   'Threaded View'
#=> 'Vista en linea (Threaded)',
=> 'Vista por tópico',

   'Total number of records found in file: [_1]'
=> 'Número total de registros encontrados en el archivo: [_1]',

   'Unable to enroll students'
=> 'No ha sido posible matricular estudiantes',

   'Updating discussion time'
=> 'Actualizando tiempo de discusión',

   'Upload a class list'
=> 'Cargar una lista de estudiantes',

   'Uploading Class List'
=> 'Cargando lista de estudiantes',

   'Verify Content'
=> 'Verificar Contenido',

   'Version used in Course'
=> 'Versión usada en Curso',

   'View Class List'
=> 'Ver Lista de Estudiantes',

   'View Class list'
=> 'Ver Lista de Estudiantes',

   'Welcome'
=> 'Bienvenido',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up.'
#=> 'Bienvenido a la Red de Aprendizaje <i>Online</i> con CAPA ("Learning Online Network with CAPA" LON-CAPA). Por favor, espere mientras se configura su sesión',
=> 'Bienvenido a la Red de Aprendizaje <i>Online</i> con CAPA ("Learning Online Network with CAPA" LON-CAPA). Por favor, espere mientras se establece su sesión',

   'You must choose an authentication type.'
#=> 'Debe elegir un tipo de autentificación.',
=> 'Debe seleccionar un tipo de autenticación.',

   'You need to specify the Kerberos domain.'
#=> 'Debe especificar el dominio Kerberos.',
=> 'Necesita especificar el dominio Kerberos.',

   'You need to specify the initial password.'
#=> 'Debe especificar el password inicial.',
=> 'Necesita especificar el password inicial.',

   'You need to specify the username field.'
#=> 'Debe especificar el campo Usuario.',
=> 'Necesita especificar el campo Usuario.',

   'Your Version Settings have been Saved'
#=> 'Su Configuración de Versión se ha almacenado',
=> 'Su Versión establecida se ha Guardado',

   '[_1] Do not change login data'
=> '[_1] No cambiar los datos de login',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]'
=> '[_1] Autentificación via Kerberos, dominio [_2] [_3] Versión 4 [_4] Versión 5 [_5]',

   'Currently Kerberos authenticated with domain [_1] Version [_2].'
=> 'Actualmente Kerberos Autentificado, con dominio [_1] Versión [_2].',

   'Currently Kerberos authenticated, Version [_1].'
=> 'Actualmente Kerberos Autentificado, Versión [_1].',

   'most recent'
=> 'más reciente',

   'name only visible to course faculty'
#=> 'nombre sólamente visíble para el personal del curso',
=> 'nombre sólamente visíble para los profesores del curso',

   'Calculate answers'
=> 'Calcular respuestas',

   'Show All Foils'
=> 'Mostrar Todas las Alternativas',

   'Show All Instances'
=> 'Mostrar Todas las Instancias',

   '1 out of N multiple choice (radio button)'
=> '1 de N alternativas de solución múltiple (radio button)',

   'Add new option'
=> 'Añadir nueva opción',

   'Administrator'
=> 'Administrador',

   'Answer:'
=> 'Respuesta:',

   'Attachment'
=> 'Adjunto',

   '(128 KB max size)'
=> '(tamaño max 128 Kb)',

   'Change'
=> 'Cambiar',

   'Change Random Seed To:'
#=> 'Cambiar generador de números:',
=> 'Cambiar semilla del generador de números:',

   'Change Your Language Preferences'
=> 'Cambiar Idioma',

   'Concept:'
=> 'Concepto:',

   'Correct Option:'
=> 'Opción Correcta:',

   'Create a New Course'
=> 'Crear un Curso Nuevo',

   'Create a New Group'
=> 'Crear un Grupo Nuevo',

   'Create a New Course or Group Space'
=> 'Crear un Curso Nuevo o Espacio Grupal',

   'Current'
=> 'Actual',

   'Delete an option'
#=> 'Excluir una opción',
=> 'Borrar una opción',

   'Delete:'
=> 'Borrar:',

   'Diffs with Current Version'
=> 'Diferencias con la Versión Actual',

   'Diffs with Version'
=> 'Diferencias con la Versión',

   'Diffs with current Version'
=> 'Diferencias con la Versión actual',

   'Display and analysis of submission times on assessments.'
#=> 'Análisis y envío de los tiempos en los ejercicios.',
=> 'Visualización y Análisis de los tiempos de envío de respuestas las evaluaciones.',

   'Display foils in order given'
=> 'Mostrar alternativas en el orden dado',

   'Display foils in random order'
=> 'Mostrar alternativas aleatoriamente',

   'Domain Guest'
=> 'Invitado de Dominio',

   'Essay, open end'
=> 'Ensayo, plazo final abierto',

   'False'
=> 'Falso',

   'Foil'
=> 'Alternativa',

   'Format:'
=> 'Formato:',

   'Height(pixel):'
=> 'Altura(pixeles):',

   'Hint Text'
#=> 'Texto Oculto',
=> 'Texto de Sugerencia',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
#=> 'Si este recurso está activo, la evolución de los datos de los estudiantes previa será inaccesible.',
=> 'Si este recurso está activo, los datos del desempeño de los estudiantes de versiones anteriores puede llegar a ser inaccesible.',

   'Image:'
=> 'Imagen:',

   'Incorrect Answers:'
=> 'Respuestas Incorrectas:',

   'Last accessed'
=> 'Último acceso',

   'Librarian'
=> 'Bibliotecario',

   'Making Backup to [_1]'
=> 'Creando copia de seguridad a [_1]',

   'Max Number Of Shown Foils:'
#=> 'Número Máximo de Alternativas Mostradas:',
=> 'Número Máximo de Alternativas a Mostrar:',

   'Max number of foils displayed'
=> 'Número Máximo de alternativas Mostradas',

   'Metadata'
=> 'Metadatos',

   'metadata'
=> 'metadatos',

   'Metadata Version'
=> 'Versión de los Meta-datos',

   'Metadata current version'
=> 'Versión Actual de los Meta-datos',

   'Save Metadata'
=> 'Guardar Metadatos',

   'Name:'
=> 'Nombre:',

   'New parameters or saved values'
=> 'Nuevos parámetros o valores guardados',

   'No language preference'
=> 'Sin preferencia de idioma',

   'Not shown, not used'
=> 'No mostrado, no usado',

   'Obsolete parameters or saved values'
#=> 'Parámetros obsoletos o valores guardados',
=> 'Parámetros obsoletos o valores almacenados',

   'Option response'
=> 'Opción de respuesta',

   'Position'
=> 'Posición',

   'Preferred language'
=> 'Idioma Preferido',

   'Problems'
=> 'Problemas',

   'Produce Excel Output'
=> 'Producir salida para Excel',

   'Question Text'
=> 'Texto de la pregunta',

   'Random position'
=> 'Posición Aleatoria',

   'Retrieve Published Resources'
#=> 'Restaurar Recursos Publicados',
=> 'Recuperar Recursos Publicados',

   'Short string response'
#=> 'Respuesta con frase corta (string)',
=> 'Respuesta concatenada (string) corta',

   'Show always at bottom position'
=> 'Mostrar siempre en la posición inferior',

   'Show always at top position'
=> 'Mostrar siempre en la posición superior',

   'Size:'
=> 'Tamaño:',

   'Save Changes'
=> 'Guardar Cambios',

   'Submission Time Analysis'
#=> 'Análisis de Tiempos de Envío',
=> 'Análisis de Tiempos de Envío de respuesta',

   'Submit Changes and Edit'
=> 'Enviar Cambios y Editar',

   'TeXWidth(mm):'
#=> 'TeXWidth(mm):',
=> 'TeX-Ancho(mm):',

   'Text'
=> 'Texto',

   'Text Block'
=> 'Bloque de Texto',

   'This is an automatic e-mail generated by the LON-CAPA system.'
=> 'Este es un E-Mail automático generado por el sistema LON-CAPA.',

   'True'
=> 'Verdadero',

   'unused'
=> 'sin usar',

   'Type-in value'
=> 'Teclee un valor',

   'Unit:'
=> 'Unidad:',

   'Value'
=> 'Valor',

   'Warning!'
=> 'Alerta!',

   'Width(pixel):'
=> 'Anchura(píxeles):',

   'anonymous'
=> 'anónimo',

   'bytes'
=> 'bytes',

   'loginproblems.html'
=> 'loginproblems.html',

   'versions of this problem'
=> 'versiones de este problema',

# Begin remote control (mydesk.tab)
# 2x8 chars, only lower case
# Same order as in mydesk.tab!

   'choose[_1]'
=> 'seleccionar[_1]',
   'course[_1]'
=> 'curso[_1]',

   'switch[_1]'
=> 'intercambiar[_1]',
   'course[_2]'
=> 'curso[_2]',

   'switch[_2]'
=> 'intercambiar[_2]',
   'role[_1]'
=> 'funcion[_1]',#no usar acentos

   'choose[_2]'
=> 'seleccionar[_2]',
   'role[_2]'
=> 'funcion[_2]',  #no usar acentos

   'course[_3]'
=> 'documentos[_3]',
   'docs[_1]'
=> 'del curso[_1]',

   'course[_7]'
=> 'editar[_1]',#=> 'editar documentos[_1]',
   'editor[_1]'
=> 'docs crs[_2]',#=> 'del curso[_2]',

   'navigate[_1]'
=> 'navegar[_1]',
   'contents[_1]'
=> 'contenidos[_1]',

   'request-[_1]'
=> 'solicita',
   'course[_16]'
=> 'curso',

   'my[_1]'
=> 'mis[_1]',
   'grades[_1]'
=> 'notas[_1]',

   'course[_4]'
=> 'notas[_4]',
   'grades[_2]'
=> 'del curso[_2]',

   'course[_5]'
=> 'grafica[_5]',#no usar acentos
   'chart[_1]'
=> 'del curso[_1]',

   'course[_6]'
=> 'estadisica[_6]',#no usar acentos
   'stats[_1]'
=> 'del curso[_1]',

   'manage[_1]'
=> 'gestionar[_1]',
   'acc keys[_1]'
=> 'clav. de acceso[_1]',

   'course[_12]'
=> 'lista[_12]',
   'roster[_1]'
=> 'del curso[_1]',

   'user[_1]'
=> 'zona de[_1]',
   'privs[_1]'
=> 'usuario[_1]',

   'create[_1]'
=> 'crear[_1]',
   'course[_8]'
=> 'curso[_8]',

   'course[_9]'
=> 'parametros[_9]',#no usar acentos
   'parms[_1]'
=> 'del curso[_1]',

   'con-[_1]'
=> 'area de[_1]',
   'struct[_1]'
=> 'construccion[_1]',

   'co con-[_1]'
=> 'coautor',
   'struct[_2]'
=> 'construc',

   'domain[_1]'
=> 'configur',
   'config[_1]'
=> 'dominio[_1]',

   'upload[_1]'
=> 'cargar',
   'pdf form[_1]'
=> 'arch.pdf',

   'resource[_1]'
=> 'zona[_1]',
   'space[_1]'
=> 'de recursos[_1]',

   'co res[_1]'
=> 'espacio[_1]',
   'space[_2]'
=> 'co res[_2]',

   'what is[_1]'
=> 'que es[_1]',
   'new[_1]'
=> 'nuevo[_1]',

   'enter[_1]'
=> 'entrar[_1]',
   'grades[_3]'
=> 'notas[_3]',

   'send bub[_1]'
=> 'enviar h[_1]',
   'blesheet[_1]'
=> 'oja resp[_1]',

   'course[_13]'
=> 'catalogo[_13]',
   'catalog[_1]'
=> 'del curso[_1]',

   'view[_1]'
=> 'ver[_1]',
   'bookmark[_1]'
=> 'marcadores[_1]',

   'calendar[_1]'
=> 'calendario-',
   'announce[_1]'
=> 'anuncios',

   'commu-[_1]'
=> 'comu-',
   'nication[_1]'
=> 'nicacion',

   'course[_10]'
=> 'chat del',
   'chatroom[_1]'
=> 'curso',

   'course[_14]'
=> 'grupos',
   'groups[_1]'
=> 'del curso',

   'port-[_1]'
=> 'porta-',
   'folio[_1]'
=> 'folio',

   'edit[_1]'
=> 'editar[_1]',
   'blogs[_1]'
=> 'blogs[_1]',

   'search[_3]'
=> 'buscar [_3]',
   'prtfolio[_1]'
=> 'prtfolio[_1]',

   'search[_1]'
=> 'buscar[_1]',
   'course[_11]'
=> 'en curso[_11]',

   'search[_2]'
=> 'buscar',#=> 'buscar en[_2]',
   'library[_1]'
=> 'recursos',

   'prefer-[_1]'
=> 'prefe-',
   'ences[_1]'
=> 'rencias',

   'logout[_1]'
=> 'salir[_1]',
   ' [_1]'
=> ' ',

#=====================
# Remote control entries which occur only in lonmenu.pm

   'problem[_1]'
=> 'nota de',
   'grades[_4]'
=> 'problema',

   'sub-[_1]'
=> 'envios',
   'missions[_1]'
=> ' ',

   'problem[_2]'
=> 'Parm. de',
   'parms[_2]'
=> 'problema',

   'dir[_1]'
=> 'listar[_1]',
   'list[_1]'
=> 'carpeta[_1]',

   'retrieve[_1]'
=> 'recobrar',
   'version[_1]'
=> 'version',

   'publish[_1]'
=> 'publica',
   'resource[_3]'
=> 'recurso',

   'delete[_1]'
=> 'borrar',
   'resource[_2]'
=> 'recurso',

   'prepare[_1]'
=> 'preparar',
   'printout[_1]'
=> 'impresion',

   'backward[_1]'
=> 'volver', #atras

   'forward[_1]'
=> 'siguiente', #adelante

   'set[_1]'
=> 'establecer',
   'bookmark[_2]'
=> 'favoritos',  #marcadores

   'anno-[_1]'
=> 'anota-',
   'tations[_1]'
=> 'ciones',

   'catalog[_2]'
=> 'info de',
   'info[_1]'
=> 'catalogo',

   'evaluate[_1]'
=> 'evaluar',
   'this[_1]'
=> 'esto',

   'feedback[_1]'
=> 'reaccion', #comentarios de reacción
   'discuss[_1]'
=> 'discusion',

# End remote control
#=====================


#SYNC Sat Apr 17 10:04:35 2004

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(Entre máximo [_1] colaboradores utilizando el nombre de usuario o usuario@dominio, por ejemplo, pperez o pperez@[_2].)',

   '(Hand in a file you have prepared on your computer)'
=> '(Entregar un archivo que ha preparado en su computador)',

   ', select a template from the pull-down menu below.'
=> ', seleccione un modelo desde el menó desplegable a continuación.',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> 'etiquetas <*response> están dentro de <part> y afuera de <part>, este no es un problema válido, errores en la corrección podrían ocurrir.',

   'ABSTRACT'
=> 'RESUMEN ',

   'Access Control'
=> 'Control de Acceso',

   'Activate'
=> 'Activar',

   'Add Roles'
=> 'Añadir funciones',

   "Add one empty page/column after each student's assignment"
=> "Añadir una página/columna vacía después de cada asignación del estudiante",

   "Add three empty pages/column after each student's assignment"
=> "Añadir tres páginas/columnas vacías después de cada asignación del estudiante",

   "Add two empty pages/column after each student's assignment"
=> "Añadir dos páginas/columnas vacías después de cada asignación del estudiante",

   'Date Shift'
=> 'Correr Fecha',

   'Do not clone date parameters'
=> 'No clonar parámetros de fechas',

   'Clone date parameters as-is'
=> 'Clonar parámetros de fechas como estan',

   'Shift date parameters by number of days'
=> 'Correr parámetros de fechas por número de días',

   'Additional settings, if specified below, will override cloned settings'
=> 'Ajustes adicionales, si se especifica abajo, eliminará los ajustes',

   'Advanced Edit'
=> 'Edición Avanzada',

   'All Resources'
=> 'Todos los Recursos',

   'All Students'
=> 'Todos los estudiantes',

   'Previous Student'
=> 'Estudiante Anterior',

   'Previous Student ([_1])'
=> 'Estudiante Anterior ([_1])',

   'Next Student'
=> 'Siguiente Estudiante',

   'Next Student ([_1])'
=> 'Siguiente Estudiante ([_1])',

   'Allowed filetypes: [_1]'
=> 'Tipos de archivos permitidos: [_1]',

   'An error occurred during the attempt to change the section for this student.'
=> 'Ha ocurrido un error mientras se intentaba cambiar la sección para este estudiante.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'Ha ocurrido un error mientras se intentaba cambiar la información de función para este estudiante.',

   'Analyzing Results'
=> 'Analizando Resultados',

   'Answerable'
=> 'Para Responder',

   'Assessment Parameters'
=> 'Parámetros de Evaluación',

   'Automated adds'
=> 'Inserciones Automáticas',

   'Automated drops'
=> 'Eliminaciones Automáticas',

   'Automated enrollment settings'
=> 'Ajustes de matrículas automáticas',

   'Bad Filename'
#=> 'Filename Erroneo',
=> 'Archivo Malo',

   'Begin Enrollment'
=> 'Comenzar Matrícula',

   'Binary File'
=> 'Archivo Binario',

   'Blank'
=> 'Vacío',

   'Browse'
=> 'Navegar',

   'CSV format'
=> 'Formato CSV',

   'Cannot publish directory'
=> 'No se puede publicar el directorio',

   'Cannot retrieve directory'
=> 'No se puede recuperar directorio',

   'Catalog Search'
=> 'Búsqueda de Catálogo',

   'Change User Privileges'
=> 'Cambiar los Privilegios de Usuario',

   'Click here for FAQ'
=> 'Pinchar aquí para las FAQ',

   'Click here for help'
=> 'Pinchar aquí para ayuda',

   'Click here to report bugs'
#=> 'Click aquí para enviar errores',
=> 'Pinchar aquí para reportar errores del programa (bugs)',

   'Click-On Texts (comma sep):'
=> 'Pinchar en Textos (coma sep):',

   'Clone an existing course'
=> 'Clonar un curso existente',

   'Close This Window'
=> 'Cerrar esta ventana',

   'Closed'
=> 'Cerrado',

   'Communication'
=> 'Comunicación',

   'Compare versions of'
=> 'Comparar versiones de',

   'No differences found'
=> 'No se encontró diferencias',

   'Completely new course'
=> 'Curso completamente nuevo',

   'Construction Space Version'
=> 'Versiones del espacio de Construcción',

   'Continue'
=> 'Continuar',

   'Copy current file to'
=> 'Copiar este archivo a',

   'Copy selected'
=> 'Copiar seleccionados',

   'Course Code'
=> 'Código del Curso',

   'Course Content'
=> 'Contenido del Curso',

   'Course Data'
=> 'Fecha del Curso',

   'Course Home Server'
=> 'Servidor Local del Curso',

   'Course ID/Number'
=> 'Número/ID del Curso',

   'Course Information'
=> 'Información del curso',

   'Resource Level'
=> 'Nivel del Recurso',

   'Map/Folder Level'
=> 'Nivel de Mapa/Folder',

   'Course Level'
=> 'Nivel del Curso',

   'Course Search'
=> 'Buscar en Curso',

   'Create New User'
=> 'Crear Nuevo Usario',

   'Create User'
=> 'Crear Usuario',

   'Crosslisted courses'
=> 'Lista de cursos cruzados',

   'Current Class List'
=> 'Lista de Clase Actual',

   'Current Ending Date: [_1]'
=> 'Fecha Actual de Finalización: [_1]',

   'Current Ending Date: not set'
=> 'Fecha Actual de Finalización: no establecido',

   'Current Resource'
=> 'Recurso Actual',

   'Current Starting Date: [_1]'
=> 'Fecha Actual de Inicio: [_1]',

   'Current Starting Date: not set'
=> 'Fecha Actual de Inicio: no establecido',

   'Current Version'
=> 'Versión Actual',

   'Currently no active roles, courses or communities'
=> 'Actualmente no hay funciones activas, cursos o comunidades', # 'Actualmente no hay funciones activas o cursos',

   'Currently no additional roles, courses or communities'
=> 'Actualmente no hay funciones adicionales, cursos o comunidades', # 'Actualmente no hay funciones adicionales o cursos',

   'The following [quant,_1,role,roles] will become active in the future:'
=> 'Los siguientes [quant,_1,función,funciones] se activarán en el futuro:',

   'Currently submitted: [_1]'
=> 'Actualmente enviado: [_1]',

   'Custom Role Editor'
=> 'Editor de Función de usuario personalizada',

   'Cut selected'
=> 'Corte seleccionado',

   'Decompress'
=> 'Descomprimir',

   'Default Assessment Spreadsheet'
=> 'Hoja de Cálculo predeterminada de Evaluación ',

   'Default Course Spreadsheet'
=> 'Hoja de Cálculo predeterminada del Curso ',

   'Default Student Spreadsheet'
=> 'Hoja de Cálculo predeterminada del Estudiante ',

   'Default XML Style File'
=> 'Archivo de Estilo XML Predeterminado',

   'Default for new courses is'
=> 'Por Defecto para nuevos cursos es',

   'Default:'
=> 'Por defecto:',

   'Dependencies'
=> 'Dependencias',

   'Description:'
=> 'Descripción:',

   'Disable student resource discussion'
=> 'Desabilitar recurso de discusión para estudiante',

   'Disable student use of chat rooms'
=> 'Desabilitar uso de chat para estudiante',

   'Disable member use of chat rooms'
=> 'Desabilitar uso de chat a miembro',

   'Display file attributes'
=> 'Mostrar atributos de archivo',

   'Do NOT generate as standard course'
=> 'NO generar como curso estándar',

   'Domain Level'
=> 'Nivel de Dominio',

   "Don't Show Feedback"
=> "No Mostrar Commentario de Reacción",

   'Duration of automated classlist updates'
=> 'Duración de actualización automatizada de la lista de clases',

   'Dynamic Metadata (updated periodically)'
=> 'Metadato Dinámico(periódicamente actualizado)',

   'ERROR'
=> 'ERROR',

   'Edit Custom Role Privileges'
=> 'Editar Privilegios de Funciones Personalizadas',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> 'Errores del Editor - estos errores puede que no interfieran en el funcionamiento del problema, pero es probable que causen problemas con un uso futuro del modo de Edición. Por favor, use el modo de edición de XML (EditXML) para corregir los errores.',

   'End Time'
=> 'Tiempo de Término',

   'Ending Date'
=> 'Fecha de Finalización',

   'Ending date'
=> 'Fecha de finalización',

   'Enroll One Student'
=> 'Matricular Un Estudiante',

   'Enroll as student'
=> 'Matricular como estudiante',

   'Enrolling'
=> 'Matriculando',

   'Enrolling Student'
=> 'Matriculando Estudiante',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Introduzca el mayor número de campos que pueda. El sistema le informará y regresará a esta página si los datos seleccionados son insuficientes para matricular estudiantes en su clase.',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> 'Introduzca términos o frases separadas por AND, OR, o NOT y luego pulse BUSCAR debajo',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> 'Introduzca términos o frases separadas por operadores de búsqueda tales como AND, OR, o NOT',

   'Entering Construction Space'
=> 'Entrando a Zona de Construcción',

   'Error: Directory Non Empty'
=> 'Error: Directorio no Vacío',

   'Error: destination for operation is an existing directory.'
=> 'Error: destino de operación es un directorio existente.',

   'Evaluation Error '
=> 'Evaluación de Error',

   'Homework Problem'
=> 'Problema de Asignación',

   'Exam Problem'
=> 'Problema de Exámen',

   'Excel format'
=> 'Formato excel',

   'Feedback Addresses for Course Content Comments'
=> 'Direcciones de Comentarios de Reacción para Comentarios del Contenido del Curso',

   'Feedback Addresses for Course Policy'
=> 'Direcciones de Comentarios de Reacción para Política del Curso',

   'Feedback Addresses for Resource Content Question'
=> 'Direcciones de Comentarios de Reacción para preguntas del Contenido del Recursos.',

   'First'
=> 'Primera',

   'First Resource'
=> 'Primer Recurso',

   'Foil name [_1] appears more than once. Foil names need to be unique.'
=> 'Nombres de alternativas [_1] se repite. Nombres de alternativas necesitan ser únicas.',

   'Folder/Map'
=> 'Folder/Mapa',

   'For one or more students'
=> 'Para uno o más estudiantes',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Se encontró etiquetas <*response> fuera de un <part> en un problema con <part>es',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Se encontró respuestas no analizables en este problema, actualmente respuestas de estilo solo Númerico, Fórmula y Concatenamiento(String) son funcionales.',

   'Generate messages from a file'
=> 'Generar mensajes desde un archivo',

   'Arabic - UTF'
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'German - UTF'
=> 'Deutsch - UTF',

   'English - UTF'
=> 'English - UTF',

   'Spanish (Castellan) - UTF'
=> 'Español (Castellano) - UTF',

   'Persian - UTF'
=> 'ﺍیﺭﺎﻧی - UTF',

   'French - UTF'
=> 'français - UTF',

   'Hebrew - UTF'
=> 'עברית - UTF',

   'Japanese - UTF'
=> '日本語 - UTF',

   'Portuguese - UTF'
=> 'Português - UTF',

   'Russian - UTF'
=> 'Русский - UTF',

   'Turkish - UTF'
=> 'türkçe - UTF',

   'Chinese Simplified - UTF'
=> '简体中文 - UTF',

   'Swedish Chef - UTF'
=> 'Dänischer Koch - UTF',

   'Go'
=> 'Ir',

   'go'
=> 'ir',

   'Go to ...'
=> 'Ir a ...',

   'Help on Creating Courses'
=> 'Ayuda Creando Cursos',

   'Home Server'
=> 'Servidor Local',

   'Homework problem'
=> 'Problema de Asignación',

   'How do I create a CSV file from a spreadsheet'
=> '¿Cómo creo un archivo CSV a partir de una hoja de cálculo?',

   'How should the results be printed?'
=> 'Cómo debe imprimirse los resultados?',

   'Immediately expire own role as Course Coordinator'
=> 'Immediatamente expirar mi función de Coordinador de Curso',

   'Import and Paste Area'
=> 'Area de Importar y Pegar',

   'Include retrieval of student photographs?'
=> 'Incluir recuperación de fotografías de estudiantes?',

   'Institutional Information'
=> 'Información Institucional',

   'Invalid Significant figures detected'
=> 'Se detectó Número de Cifras Significativas Inválido',

   'Invalid characters in requested name have been removed.'
=> 'Caracteres Inválidos en nombre solicitado han sido removidos.',

   'Invalid login mode or password.'
=> 'Modo de login o password Inválido.',

   'Invalid username or domain'
=> 'usuario o dominio Inválido',

   'KEYWORDS'
=> 'Palabras Claves(KEYWORDS)',

   'LaTeX batchmode'
=> 'LaTeX batchmode',

   'LaTeX mode'
=> 'modo LaTeX',

   'Languages used'
=> 'Idiomas usados',

   'Last'
=> 'Última',

   'Leave blank on scoring form'
=> 'Dejar en blanco el formulario de puntuación',

   'List Directory'
=> 'Listar Directorio',

   'Location'
=> 'Localización',

   'Login Data'
=> 'Datos de Login',

   'Logout'
=> 'Salir',

   'Make new directory [_1]?'
=> '¿Crear nuevo directorio[_1]?',

   'Make new file'
=> 'Crear nuevo archivo',

   'Manual Grading'
=> 'Calificación Manual',

   'Map has branchings. Use advanced editor.'
=> 'Mapa tiene ramificaciones. Use editor avanzado.',

   'Map has conditions. Use advanced editor.'
=> 'Mapa tiene condiciones. Use editor avanzado.',

   'Map has resource parameters. Use advanced editor.'
=> 'Mapa tiene parámetros de recurso. Use editor avanzado.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Mapa tiene recursos desconectados. Use editor avanzado.',

   'Messaging'
=> 'Envío de mensajes',

   'Missing Kerberos domain information.'
=> 'Falta información de dominio Kerberos.',

   'Modification may make assessment data inaccessible!'
=> 'Modificación puede causar que los datos de evaluación sean inaccesibles!',

   'Modify Enrollment for'
=> 'Modificar Matrícula para',

   'Modify User'
=> 'Modificar Usuario',

   'Modify deadlines, etc, for this resource'
=> 'Modificar plazos finales, etc, para este recurso',

   'Modifying data for user'
=> 'Modificando datos para el usuario',

   'Modifying this will make problems have different numbers and answers!'
=> 'Modificandolo hará problemas con números y respuestas diferentes!',

   'Move current file to'
=> 'Mover actual archivo a',

   'Must create new subdirectory inside a directory'
=> 'Debe crear nuevo subdirectorio dentro de directorio',

   'Name of Role'
=> 'Nombre de función de usuario',

   'New Directory'
=> 'Nueva Directorio',

   'New HTML file'
=> 'Nuevo archivo HTML',

   'New Resource'
=> 'Nuevo Recurso',

   'New Role'
=> 'Nueva Función de usuario',

   'New User'
=> 'Nuevo Usuario',

   'New Value'
=> 'Nuevo Valor',

   'New assembled page'
=> 'Nueva página ensamblada',

   'New assembled sequence'
=> 'Nueva secuencia ensamblada',

   'New custom rights file'
=> 'Nuevo archivo de derechos personalizado',

   'New file'
=> 'Nuevo archivo',

   'New problem'
=> 'Nuevo problema',

   'New style file'
=> 'Nuevo archivo de estilo',

   'New subdirectory'
=> 'Nuevo subdirectorio',

   'Next    '
=> 'Siguiente    ',

   'No'
=> 'No',

   'No Access or Usages Statistics are available for this resource.'
=> 'Sin acceso o los usos de Estadística no están disponibles para este recurso',

   'No Assessment Statistical Data is available for this resource'
=> 'No hay Datos de Evaluación Estadística disponibles para este recurso',

   'No Evaluation Data is available for this resource.'
=> 'No hay Datos de Evaluación disponibles para este recurso.',

   'No new filename specified.'
=> 'Nuevo nombre de archivo NO especificado.',

   'No such file'
=> 'No hay tal archivo',

   'No such file: [_1]'
=> 'No hay tal archivo: [_1]',

   'Not Allowed'
=> 'No permitido',

   'Not applicable -'
=> 'No aplicable -',

   'Not open to be viewed'
=> 'No abierto para ser visto',

   'Notification of enrollment changes'
=> 'Notificación de cambios de matrícula',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Notificación al <b>coordinador del curso</b> vía mensaje de LON-CAPA cuando cambios de matrícula ocurren durante la actualización automática?',

   'Number of columns'
=> 'Número de columnas',

   'Old Value'
=> 'Valor Anterior',

   'One particular problem (overrides folder and course defaults)'
=> 'Un problema particular (sobreescribe la carpeta y las predefiniciones del curso)',

   'Online Help'
=> 'Ayuda Online',

   'Help: [_1]'
=> 'Asistencia: [_1]',

   'Only domain coordinators can change a users password.'
=> 'Solo los coordinadores de dominio pueden cambiar la contraseña de usuarios.',

   'Open Course'
=> 'Abrir Curso',

   'Open all assessments'
=> 'Abrir todas las evaluaciones',

   'Open and correct'
=> 'Abrir y corregir',

   'Open with full tries'
=> 'Abrir con los intentos completos',

   'Output Format: [_1]'
=> 'Formato de Salida: [_1]',

   'Layout Options'
=> 'Opciones de Diseño ',

   'Page layout'
=> 'de página',

   'Paper type'
=> 'Tipo de papel',

   'PDF-Formfields'
=> 'PDF-Formato de Campos',

   'with Formfields'
=> 'con formato de campos',

   'without Formfields'
=> 'sin formato de campos',

   'Problems from the Whole Course'
=> 'Problemas del Curso Completo',

   'Resources from the Whole Course'
=> 'Recurso del Curso Completo',

   'Parameter'
=> 'Parámetro',

   'Paste after selected'
=> 'Pegar después de seleccionado',

   'Personal Data'
=> 'Datos Personales',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Por favor elija el método de autenticación a ser usado por los usuarios nuevos añadidos a este dominio de LON-CAPA por el proceso de matríula automatizado',

   'No such user [_1] at domain [_2].' # 1: user, 2: domain
=> 'No existe usuario [_1] en el dominio [_1].',

   'Please click Back on your browser and select another user, or [_1]Create User[_2]'
=> 'Por favor volver para atrás en su navegador y seleccione otro usuario, o [_1]Crear Usuario[_2]',

   'Invalid home server for course: [_1]'
=> 'Servidor local inválido para curso: [_1]',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Por favor contacte su administrador de LON-CAPA respecto a esta situación.',

   'Please select an authentication mechanism'
=> 'Por favor seleccione un mecanismo de autenticación',

   'Please select the Authentication mechanism'
=> 'Por favor seleccione el mecanismo de Autenticación',

   'Please stand by.'
=> 'Por favor espere.',

   "Please use browser 'Back' button and pick a filename"
=> "Por favor use el boton 'para atras' del nevagador y escoja un archivo",

   'Preparing Printout'
=> 'Preparando Impresión',

   'Print'
=> 'Imprimir',

   'Print Index'
=> 'Imprimir Índice',

   'Print Discussions'
=> 'Imprimir Discusiones',

   'Print Annotations'
=> 'Imprimir Anotaciones',

   'Print Table of Contents'
=> 'Imprimir Tabla de Contenidos',

   'Print:'
=> 'Imprimir:',

   'Problems from entire course'
=> 'Problemas del curso entero',

   'Processed file: [_1]'
=> 'archivo Procesado: [_1]',

   'Publish this Resource'
=> 'Publicar este Recurso',

   'Randomization algorithm used'
=> 'algoritmo usado de Aleatorizacion',

   'Recent'
=> 'Reciente',

   'Rename current file to'
=> 'Renombrar archivo actual a',

   'Report a Bug'
=> 'Reportar un problema del programa(Bug)',

   'Resource'
=> 'Recurso',

   'Resource Differences'
=> 'Diferencias del Recurso',

   'Resources from selected sequence in course'
=> 'Recursos de la secuencia seleccionada en curso',

   'Response'
=> 'Respuesta',

   'Retrieve Old Version'
=> 'Recuperar Version Anterior',

   'Retrieving current (most recent) version'
=> 'Recuperando la Versión Actual (más reciente)',

   'Retrieving old version'
=> 'Recuperando versión anterior',

   'Return to DOCS'
=> 'Retornar a DOCS',

   'Reverse Association'
=> 'Revertir Asociación',

   'Revoke'
=> 'Revocar',

   'Revoke Existing Roles'
=> 'Revocar Funciones Existentes',

   'Role'
=> 'Función de Usuario',

   'Role:'
=> 'Función de Usuario:',

   'Role Information'
=> 'información de Función',

   'Sample Points:'
=> 'Puntos de Muestra:',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Guardar entradas de abajo como un borrador de la respuesta (todavía no enviarlas para correccion)',

   'Select Action'
=> 'Seleccionar Acción',

   'Select All Resources'
=> 'Seleccionar Todos los Recursos',

   'Select Printing Options:'
=> 'Seleccionar opciones de impresión:',

   'Select Problem(s) to print'
=> 'Seleccionar Problema(s) para imprimir',

   'Select Resource(s) to print'
=> 'Seleccionar Recurso(s) para imprimir',

   'Select Resources To Print'
=> 'Seleccionar Recursos para Imprimir',

   'Select Section'
=> 'Seleccionar Seccion',

   'Select Sequence To Print From'
=> 'Seleccionar Secuencia para Imprimir Desde',

   'Select Students and Resources'
=> 'Seleccionar Estudiantes and Recursos',

   'Select Style File'
=> 'Seleccionar Archivos de Estilo',

   "Select a user name to modify the student's information"
=> "Seleccionar un nombre de usuario para modificar la información del estudiante",

   "Select a user name to view the user's personal information page."
=> 'Seleccionar una nombre de usuario para ver la página de información personal del usuario.',

   'Select resources for the assignment'
=> 'Seleccionar recursos para la asignación',

   'Set'
=> 'Establecer',

   'Set?'
=> 'Establecer?',

   'Set Course Environment'
=> 'Establecer Entorno del Curso',

   'Set End Date'
=> 'Establecer Fecha de Finalizacion',

   'Set Individual User Roles'
=> 'Establecer Funciones de Usuario Individual',

   'Set Start Date'
=> 'Establecer Fecha de Inicio',

   'Set content feedback to Course Coordinator'
=> 'Establecer contenido de comentarios de reacción para el Coordinador del Curso',

   'Set course policy feedback to Course Coordinator'
=> 'Establecer politica de comentarios de reacción del curso para el Coordinador del Curso',

   'Set opening date for all problems in the course for. . .'
=> 'Establecer fecha de apertura de todos los problemas en el curso para. . .',

   'Set to ...'
=> 'Establecer en ...',

   'Show Answer'
=> 'Mostrar Respuesta',

   'Show Feedback'
=> 'Mostrar Comentarios de Reacción',

   'Simple Edit'
=> 'Editor Simple',

   'Start Time'
=> 'Tiempo de Inicio',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Empezar cada asignacion del estudiante en una nueva página/columna (añadir una página extra después de cada asignacion)",

   'Starting Date'
=> 'Fecha de Inicio',

   'Starting date'
=> 'Fecha de inicio',

   'Student Information'
=> 'Información del Estudiante',

   'Student Sheet Links'
=> 'Enlaces para las Plantillas de Estudiante',

   'Student Status'
=> 'Estado del Estudiante',

   'Student Status: [_1]'
=> 'Estado del Estudiante: [_1]',

   'Student information updated successfully.'
=> 'información del estudiante actualizada exitosamente.',

   'Students need access key to enter course'
=> 'Estudiantes necesitan clave de acceso para entrar al curso',

   'Students with expired roles'
=> 'Estudiantes con funciones de usuario expiradas',

   'Subject:'
=> 'Asunto:',

   'Submissions'
=> 'Respuestas enviadas',

   'Submit Modifications'
=> 'Enviar Modificacion',

   'Submit entries below as answer to receive credit'
=> 'Enviar entradas de abajo como respuesta para recibir creditos',

   'Survey Question'
=> 'Pregunta de Encuesta',

   'Survey question'
=> 'pregunta de Encuesta',

   'System Level'
=> 'Nivel del Sistema',

   'Target Edit Map'
=> 'Objetivo Editar Mapa',

   'TeX unconverted due to errors'
=> 'TeX no convertido debido a errores',

   'TeX unconverted due to previous errors'
=> 'TeX no convertido debido a errores previos',

   'The error reported was'
=> 'El error reportado fue',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'Las siguentes entradas seran usadas para indentificar el curso de acuerdo al esquema de nombres adoptado por su institución. Su elección sera usado para hacer un mapa del ID de un curso interno de LON-CAPA al correspondiente ID de la sección del curso usado por la oficina responsable de proveer la lista oficial de clase para los cursos en su institucion. Este mapeo es requerido si usted escoge llenar su lista de clases automaticamente.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "La siguente configuración controla la matricula automatica de estudiantes en esta clase basado en la información disponible para este curso en específico de la lista oficial de clase de su institucion.",

   'The requested file'
=> 'El archivo solicitado',

   'The student must log out and log in again to see these changes.'
=> 'El estudiante debe salir y volver a entra para ver estos cambios.',

   'There are currently no Error Messages for this resource.'
=> 'Actualmente no hay Mensajes de Error para este recurso.',

   'There are no Evaluation Comments on this resource.'
=> 'No hay Comentarios de Evaluacion para este recurso.',

   'There was an error determining the environment values for'
=> 'Hubo un error determinando los valores de entorno para',

   'Top Level Map'
=> 'Mapa de Nivel Superior',

   'Type Name Here'
=> 'Introduzca el Nombre Aqui',

   'Type in value'
=> 'Introduzca el valor',

   'Type:'
=> 'Tipo:',

   'UNDISPLAYABLE'
=> 'NO VISUALIZABLE',

   'Unable to enroll'
=> 'No se puede matricular',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'No se puede publicar archivo, este contiene ID(s) duplicados, Los ID(s) necesitan ser únicos. Los ID(s) duplicados son',

   'Unable to retrieve environment data for'
=> 'No se puede recuperar los datos de entorno para',

   'Unable to set default dates for course'
=> 'No se puede establecer las fechas por defecto del curso',

   'Unavailable course'
=> 'Curso no disponible',

   'Unknown Action'
=> 'Acción desconocida',

   'Upload class list'
=> 'Cargar lista de clase',

   'Upload file'
=> 'Cargar Archivo',

   'Upload file to Construction Space'
=> 'Cargar archivo a Zona de Construcción',

   'VIEW'
=> 'VER',

   'View the FAQ'
=> 'Ver Preguntas Frecuentes (FAQ)',

   'Visibly Separate Items on Pages'
=> 'Visiblemente Separar Temas en páginas',

   'Warning: change of MIME type!'
=> 'Advertencia: cambio de tipo MIME!',

   'Warning: target file exists!'
=> 'Advertencia: archivo destino existe!',

   'Warning: target file exists, and has been published!'
=> 'Advertencia: archivo destino existe, y ha sido publicado!',

   'Width'
=> 'Ancho',

   'Print Options'
=> 'Opciones de Impresión',

   'Print Answers'
=> 'Imprimir respuestas',

   'Only Answers'
=> 'Solo Respuestas',

   'With Answers'
=> 'Con Respuestas',

   'Without Answers'
=> 'Sin Respuestas',

   'You are working with an unsaved version of your map.'
=> 'Usted está trabajando con una versión no guardada de su mapa.',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Su solicitud de cambiar la función de infomación de este estudiante fue rechazada. Usted carece de la autoridad suficiente para cambiar la información del estudiante.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (lo que usted acaba de ver en pantalla)',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] Autenticación Local con argumento [_2]',

   'Currently using local (institutional) authentication.'
=> 'Actualmente usando autenticación local (institucional).',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) sectionID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2'
=> 'lista de secciones del curso separados por coma del curso actual, con cada entrada incluyendo el nombre institucional de la sección del curso seguido por dos puntos y luego el ID de sección (opcional) a ser usado en LON-CAPA, por ejemplo, fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'lista de número de secciones institucionales separadas por coma, cada una separada por dos puntos del ID de sección correspondiente (opcional) a ser usado en LON-CAPA, por ejemplo, 001:1,002:2',

   'after selected'
=> 'después de seleccionado',

   'and'
=> 'y',

   'between'
=> 'en medio de',

   'button'
=> 'botón',

   'by'
=> 'por',

   'check all'
=> 'seleccionar todo',

   'chmod error'
=> 'error del comando chmod',

   'click on the'
=> 'pinchar en',

   'copy Error'
=> 'Error al copiar',

   'currently does not exist'
=> 'actualmente no existe',

   'custom'
=> 'personlizar',

   'domain'
=> 'dominio',

   'expired or revoked'
=> 'expirado o revocado',

   'extension'
=> 'extension',

   'external'
=> 'externo',

   'file<br />extension'
=> 'extensión <br /> del archivo',

   'first name'
=> 'nombre',

   'generation'
=> 'generación',

   'in domain'
=> 'en dominio',

   'internal'
=> 'interno',

   'is in this state by royal decree.'
=> 'Esta en este estado por decreto real.',

   'last name'
=> 'apellidos',

   'make these dates the default for future enrollment'
=> 'use estas fechas por defecto para matriculas futuras',

   'middle name'
=> 'segundo nombre',

   'name'
=> 'nombre',

   'no ending date'
=> 'sin fecha de finalización',

   'number'
=> 'número',

   'obsolete replacement'
=> 'reemplazo de obsoleto',

   'only check if you know what you are doing'
=> 'seleccione sólo si sabe lo que está haciendo',

   'only search domain [_1]'
=> 'buscar sólo en el dominio [_1]',

   'optional'
=> 'opcional',

   'or any other value'
=> 'o cualquier otro valor',

   'private'
=> 'privado',

   'public'
=> 'público',

   'publisher<br />owner'
=> 'publicante<br />dueño',

   'section'
=> 'sección',

   'standard'
=> 'estándar',

   'standard LaTeX mode'
=> 'modo LaTeX estándar',

   'standard courses only'
=> 'solamente cursos estándar',

   'student name'
=> 'nombre de estudiante',

   'template'
=> 'modelo',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'vinculación con datos institucionales, p.e., <tt>f08fisi3171</tt> para <i>otoño 2008 Física 3171</i>',

   'unable to enroll'
=> 'no se pudo matrícular',

   'uncheck all'
=> 'deseleccionar todo',

   'use related words'
=> 'utilice palabras similares',

   'username'
=> 'usuario',

   'versus'
=> 'contra',

   'with server'
=> 'con servidor',

   'yes'
=> 'si',

   'Swedish Chef'
=> 'Sueco Chef',

#SYNC Tue Aug 15 14:23:05 2006

   '[_1] for default hiding'
=> '[_1] por defecto oculto',

   '[_1] for visible separation.'
=> '[_1] para separación visible.',

   'Changes will not show until next login.'
=> 'Cambios no se mostrarán hasta la próxima sesión.',

   '[_1] if allowed, anything else if not'
=> '[_1] permitido, todo lo demas no permitido',

   '"[_1]" to disable, anything else if not'
=> '"[_1]" desabilitar, todo lo demas no',

   '[_1] to suppress, anything else to not suppress'
=> '[_1] suprimir, todo lo demas no',

   'Set value to [_1] to allow all roles.'
=> 'Establecer valores a [_1] para permitir todas las funciones de usuario.',

   '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '[_1] no es un número aceptable de intentos. Los intentos deben ser números positivos sin punto decimal.',

   '[_1] is not an acceptable weight. Weight must be a positive number.'
=> '[_1] no es una ponderación aceptable. El peso de ponderación debe ser un número positivo.',

   '1 minute'
=> '1 minuto',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML permitido</b>: Los participantes de la Discusión pueden usar HTML limitado en sus postings.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML prohibido</b>: HTML no se permitirá en postings de discusión.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Instructor</b> - instructores no podrán participar en discusiones',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Instructor</b> - instructores no podrán usar o ver la sala de chat',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Estudiantes</b> - los estudiantes no podrán participar en las discusiones',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Estudiantes</b> - los estudiantes no podrán usar o ver la sala de chat.',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Asistentes de enseñanza</b> - los asistentes de enseñanza no podrán participar en las discusiones',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Asistentes de enseñanza</b> - los asistentes de enseñanza no podrán ver o usar la sala de chat',

   'Your current LON-CAPA domain is [_1].'
=> 'Su dominio actual LON-CAPA es [_1].',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Avanzado: Puede enviar el informe desde diferentes secciones a diferentes personas, haciendo lo siguiente: Separar cada entrada con una coma. Para enviar informes a una dirección en concreto, añadir el nombre o nombres (separados por ;) en una lista entre paréntesis después del usuario:dominio. Por ejemplo, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) enrutará el informe del curso a &quot;john102&quot; para las secciones 1, 2, y 3, a &quot;bob293&quot; para 4, 5, y 6, y a &quot;madeupname:here&quot; para 7, 8, y 9. Nota no hace falta que las direcciones estén en un dominio en particular.',

   'Granting permission to clone course'
=> 'Dar permiso de clonar curso',

   'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:'
=> 'Cursos existentes pueden ser clonados cuando crea nuevos cursos. La clonacición copiará la estructura del curso, contenido y la mayoría de parámetros (automaticamente avanzando cualquier fecha por seis meses). Usuarios dueños de otros cursos permitidos a clonar este curso:',

   '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.'
=> '(Coordinadores de Curso automáticamente tienen derecho de clonar sus propios cursos.) Formato: usuario:dominio, donde &quot;usuario&quot; y &quot;dominio&quot; son el usuario y domino LON-CAPA del usuario. Separar diferentes usuarios con una coma. Usar *:dominio para permitir que el curso sea clonado por cualquier dueño de curso en el dominio específico. Usar * para permitir clonar sin restricciones a todo dueño de curso en todos los dominios.',

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click &quot;Next&quot;.'
=> 'Todos los ajustes que haga con este Ayudante también se pueden cambiar yendo a la pantalla PARM y pulsando &quot;Establecer entorno del Curso&quot; . Si no tiene experiencia coordinando cursos LON-CAPA o si prefiere el interfaz de Ayudante, por favor pulse &quot;Próximo&quot; -&gt;.',

   'Allow limited HTML in discussion posts'
=> 'Permitir HTML limitado en los posts de discusión',

   'Allow problems to be split over pages'
=> 'Permitir que los problemas se puedan dividir en páginas',

   'Answer Date (answerdate)'
=> 'Fecha de respuesta (answerdate)',

   'Chat Room Participation'
=> 'Participación Chat',

   'Click here to return to the chart.'
=> 'Pulse aqui para volver al cuadro.',

   'Completed'
=> 'Completado',

   'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.'
=> 'Confirmar que esta información es correcta, entonces pulsar &quot;Guardar&quot; para completar los ajustes de los parámetros.',

   'Course ID or number'
=> 'Curso ID o número',

   'Course Initialization Helper'
=> 'Ayudante de inicio de curso',

   'Course default for all problems'
=> 'Ajuste por defecto del curso para todos los problemas',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an e-mail address.'
=> 'Los miembros pueden enviar informes sobre el curso. Puede elegir quien recibirá el informe, como otro instructor o un TA. Por favor, introduzca sus direcciones LON-CAPA debajo, en el campo usuario:dominio, donde &quot;user&quot; y &quot;dominio&quot; son los nombre LON-CAPA y dominio LON-CAPA, no la dirección de e-Mail.',

   'Courses'
=> 'Cursos',

   'Default beginning date when enrolling students'
=> 'Fecha inicial, por defecto, para matricular estudiantes',

   'Default ending date when enrolling students'
=> 'Fecha final, por defecto, para terminar de matricular estudiantes',

   'Default set of options to pass to tth/m when converting TeX'
=> 'Conjunto de Opciones, por defecto, para pasar a tth/m cuando convierta TeX',

   'Disable display of problem receipts'
=> 'Desactivar visualizacion de recibos de problemas',

   'Disallow Resource Discussion for Roles'
=> 'Prohibir Discusion de Recursos a Funciones de usuario',

   'Disallow Resource Discussion for Users'
=> 'Prohibir Discusion de Recursos a Usuarios',

   'Disallow chat room use for Roles'
=> 'Prohibir uso de salas de chat a Funciones de usuario',

   'Disallow chat room use for Users'
=> 'Prohibir uso de salas de chat a Usuarios',

   'Discussion Participation'
=> 'Discusión Participación',

   'Due Date (contentclose)'
=> 'Fecha Final (contentclose)',

   'Due Date (duedate)'
=> 'Fecha Final (duedate)',

   'Every problem in a particular folder (overrides course default)'
=> 'Todos los problemas en una carpeta en particular (precede al valor nominal del curso)',

   'Exit'
=> 'Salir',

   'Feedback Addresses for Course Content'
=> 'Direcciones de comentarios de reaccion del Contenido del Curso',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML puede permitirse o prohibirse dentro de la discusión del curso.',

   'HTML in Discussions'
=> 'HTML en Discusiones',

   'Hide Empty Rows in Spreadsheets'
=> 'Ocultar Filas Vacías en Hojas de Cálculo',

   'How many tries should be set for all problems in the course?'
=> '¿Cuantos intentos se establecerán para todos los problemas de curso?',

   'How many tries should be set for the selected folder?'
=> '¿Cuantos intentos se establecerán para la carpeta selecionada?',

   'How many tries should be set for the selected problem?'
=> '¿Cuantos intentos se establecerán para el problema seleccionado?',

   'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA tiene funcionalidad de chat. Este curso tendrá su propia sala de chat. Usted puede negar el derecho de acceso a estudiantes, asistentes, o instructores a la sala de chat.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA acoge los debates de todos los recursos de un curso. Nominalmente, todos los usuarios son permitidos de participar en esos debates. Si no desea ciertos tipos de usuarios que usen estas herramientas de debate, selecionelos debajo. Su classe podria no tener esas funciones; usted puede ignorar usuarios que no desea que los usen. (Por ejemplo, &quot;Examinadores&quot; es generalmente util para cursos grandes.) Usuarios prohibidos de participar en debates pueden ver cualquier debate.',

   'No section assigned'
=> 'No hay sección asignada',

   'Number of assignments printed at the same time:'
=> 'Número de ejercicios a imprimirse simultáneamente:',

   'Opening Date (contentopen)'
=> 'Fecha de Inicio (contentopen)',

   'Opening Date (opendate)'
=> 'Fecha de Inicio (opendate)',

   'Please adjust significant figures.'
=> 'Por favor ajuste las cifras significativas.',

   'Please select the section you wish to set the answer open date for:'
=> 'Por favor seleccionar la sección a la que desea establecer la fecha de apertura de respuestas:',

   'Please select the section you wish to set the due date for:'
=> 'Por favor seleccionar la sección a la que desea establecer la fecha límite:',

   'Please select the section you wish to set the number of tries for:'
=> 'Por favor seleccionar la sección a la que desea establecer el número de intentos:',

   'Please select the section you wish to set the opening date for:'
=> 'Por favor seleccionar la sección a la que desea establecer la fecha de inicio:',

   'Please select the section you wish to set the problem weight for:'
=> 'Por favor seleccionar la sección a la que desea establecer la ponderación de problemas:',

   'Please select the student you wish to set the answer open date for:'
=> 'Por favor seleccionar al estudiante que desea establecerle la fecha de apertura de respuestas:',

   'Please select the student you wish to set the due date for:'
=> 'Por favor seleccionar al estudiante que desea establecerle la fecha límite:',

   'Please select the student you wish to set the number of tries for:'
=> 'Por favor seleccionar al estudiante que desea establecerle el número de intentos:',

   'Please select the student you wish to set the opening date for:'
=> 'Por favor seleccionar al estudiante que desea establecerle la fecha de inicio:',

   'Please select the student you wish to set the problem weight for:'
=> 'Por favor seleccionar al estudiante que desea establecerle la ponderación de problemas:',

   'Privileged users that should not be hidden on staff listings'
=> 'Usuarios privilegiados que no deben ser ocultados de la lista de personal',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Semilla para generar aleatoriamente número de recursos (opcional, solamente establecer si sabe lo que esta haciendo) (randompickseed)',

   'Reading results from [_1]'
=> 'Leyendo resultado desde [_1]',

   'Receipt algorithm used'
=> 'Recibo de algoritmo usado',

   'Receiving results from [_1]'
=> 'Recibiendo resultados desde [_1]',

   'Resources'
=> 'Recursos',

   'Search Complete on Server [_1]'
=> 'Busqueda Completa en Servidor [_1]',

   'Unable to retrieve search results. Unable to determine the table results were saved in.'
=> 'No se pudo recuperar resultados de búsqueda. No se pudo determinar si la tabla de resultados fue guardada en.',

   'Search: [_1]'
=> 'Buscar: [_1]',

   'Select All Files'
=> 'Seleccionar Todos los Archivos',

   'Select All Published'
=> 'Seleccionar Todos los Publicados',

   'Select Folder'
=> 'Seleccionar Carpeta',

   'Select Only Current Students'
=> 'Seleccionar Solo Estudiantes Actuales',

   'Select Problem'
=> 'Seleccionar Problema',

   'Select Student'
=> 'Seleccionar Estudiante',

   'Select for Section/Group'
=> 'Seleccionar para Seccion/Groupo',

   'Select the folder you wish to set the parameter for:'
=> 'Seleccione la carpeta que desea establecerle los parámetros:',

   'Select the problem you wish to set the parameter for:'
=> 'Seleccione el problema que desea esteblecerle los parámetros:',

   'Set Problem Tries'
=> 'Establecer número de Intentos al Problema',

   'Set Problem Weight'
=> 'Establecer ponderación al Problema',

   'Set answer open date for all problems in the course for ...'
=> 'Establecer la fecha de apertura de respuestas a todos los problemas in el curso  ...',

   'Set answer open date for the selected folder for ...'
=> 'Establecer la fecha de apertura de respuestas a la carpeta seleccionada ...',

   'Set answer open date for the selected problem for...'
=> 'Establecer la fecha de apertura de respuestas al problema seleccionado ...',

   'Set due date for all problems in the course for ...'
=> 'Establecer fecha límite a todos los problemas de curso para ...',

   'Set due date for the selected folder for ...'
=> 'Establecer la fecha límite a la carpeta seleccionada para ...',

   'Set due date for the selected problem for ...'
=> 'Establecer la fecha límite al problema seleccionado para ...',

   'Set number of tries for all problems in the course for ...'
=> 'Establecer el número de intentos a todos los problemas del curso para ...',

   'Set number of tries for the selected folder for ...'
=> 'Establecer el número de intentos a la carpeta seleccionada para ...',

   'Set number of tries for the selected problem for ...'
=> 'Establecer el número de intentos al problema seleccionado para ...',

   'Set opening date for all problems in the course for ...'
=> 'Establecer fecha de inicio de todos los problemas del curso para ...',

   'Set opening date for the selected folder for ...'
=> 'Establecer fecha de inicio de la carpeta seleccionada para ...',

   'Set opening date for the selected problem for ...'
=> 'Establecer fecha de inicio del problema seleccionado para ...',

   'Set problem weight for all problems in the course for ...'
=> 'Establecer ponderación a todos los problemas in el curso para ...',

   'Set problem weight for the selected folder for ...'
=> 'Establecer ponderación a la carpeta seleccionada para  ...',

   'Set problem weight for the selected problem for ...'
=> 'Establecer ponderación al problema seleccionado para ...',

   'Set value to [_1] to allow.'
=> 'Establecer valores a [_1] para permitir.',

   'Setting the [_1]'
=> 'Estableciendo  [_1]',

   'Setting the [_1] to [_2]'
=> 'Estableciendo  [_1] a [_2]',

   'Student Name'
=> 'Nombre de Estudiante',

   'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.'
=> 'El &quot;Título del Curso&quot; es el nombre del  curso que será visto por los estudiantes. Ahora puede modificar la descripción y pulsar &quot;Próximo -&gt;&quot; para continuar.',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'La prequnta no puede contestarse correctamente, las siguentes alternativas en la etiqueta &lt;optionresponse&gt; tiene opciones "correctas" inválidas',

   'There are no currently enrolled students in the course.'
=> 'Actualmente no hay estudiantes matriculados en el curso.',

   'There are no currently enrolled students in the selected sections.'
=> 'Actualmente no hay estudiantes matriculados en las secciones seleccionadas.',

   'There are no previously enrolled students in the course.'
=> 'No hay estudiantes previamente matriculados en el curso.',

   'There are no previously enrolled students in the selected sections.'
=> 'No hay estudiantes previamente matriculados en las secciones seleccionadas.',

   'There are no students with future access in the course.'
=> 'No hay estudiantes con acceso futuro en el curso.',

   'There are no students with future access in the selected sections.'
=> 'No hay estudiantes con acceso futuro en las secciones seleccionadas.',

   'There are no students in the course.'
=> 'No hay estudiantes en el curso.',

   'There are no students in the selected sections.'
=> 'No hay estudiantes en las secciones seleccionadas.',

   'This controls how receipt numbers are generated.'
=> 'Esto controla como los números de recibo son generados.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'Este asistente establecerá su curso de LON-CAPA y escogerá que herramientas activar.',

   'Unselect All Files'
=> 'Deseleccionar Todos los Archivos',

   'Unselect All Published'
=> 'Deseleccionar Todo lo Publicados',

   'Unselect All Resources'
=> 'Deseleccionar Todos los Recursos',

   'Unselect for Section/Group'
=> 'Deseleccionar para Seccion/Grupo',

   'Welcome to Your New LON-CAPA Course'
=> 'Bienvenido a su Curso Nuevo de LON-CAPA',

   'What parameter do you want to set for the selected folder?'
=> '¿Qué parámetro desea establecer para la carpeta seleccionada?',

   'What parameter do you want to set for the selected problem?'
=> '¿Qué parámetro desea establecer para el problema seleccionado?',

   'What should the answer open date be set to?'
=> '¿Para cuando establecerá la fecha de apertura de respuestas?',

   'What should the due date be set to?'
=> '¿Para cuando establecerá la fecha límite?',

   'What weight should be set for all problems in the course?'
=> '¿Qué ponderación establecerá a todos los problemas del curso?',

   'What weight should be set for the selected folder?'
=> '¿Qué ponderación establecerá a la carpeta seleccionada?',

   'What weight should be set for the selected problem?'
=> '¿Qué ponderación establecerá al problema seleccionado?',

#   'Your course is now set up. Please select the Save button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen (Course Configuration).'
   'Your course is now set up. Please select the Save button to re-initialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen (Course Configuration).'
=> 'Su curso está ahora establecido. Por favor seleccione el boton "Guardar" para re-iniciar el curso con la configuración selecionada. Recuerde que toda la configuración puede cambiarse en la pantalla PARMS (Configuración del Curso)',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Autentificación por Sistema de Archivos (con password inicial [_2])',

   'Currently Filesystem Authenticated.'
=> 'Archivo de Sistema Actualmente Autentificado.',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] Autentificado Internamente (con password inicial [_2])',

   'Currently internally authenticated.'
=> 'Actualmente internamente autentificado',

   'Records per Page:'
=> 'Registros por página:',

   '[_1] with value [_2]'
=> '[_1] con valor [_2]',

   'all resources in the course'
=> 'todos los recursos en el curso',

   'all students in course'
=> 'todos los estudiantes en el curso',

   'anonymous students'
=> 'estudiantes anónimos',

   'answer date'
=> 'fecha de apertura de respuesta',

   'contacting [_1]'
=> 'contactando [_1]',

   'due date'
=> 'fecha límite',

   'for'
=> 'para',

   'for [_1]all resources in the course[_2]'
=> 'para [_1]todos los recursos en el curso[_2]',

   'for [_1]all students in course[_2]'
=> 'para [_1]todos los estudiantes en el curso[_2]',

   'for [_1]'
=> 'para [_1]',

   'for section [_1]'
=> 'para la sección [_1]',

   'for the map named [_1]'
=> 'para el mapa nombrado [_1]',

   'for the resource named [_1], part [_2]'
=> 'para el recurso nombrado [_1], parte [_2]',

   'for the resource ID [_1] (name unavailable), part [_2]'
=> 'para el recurso de ID [_1] (nombre no disponible), parte [_2]',

   'from'
=> 'de',

   'from current subdirectory'
=> 'del sub-directorio actual',

   'helper'
=> 'asistente',

   'in'
=> 'en',

   'instructor'
=> 'instructor',

   'number of tries'
=> 'número de intentos',

   'opening date'
=> 'fecha de inicio',

   'problem weight'
=> 'ponderación (peso) del problema',

   'role,role,...'
=> 'funcion de usario,funcion,...',

   'selected students'
=> 'estudiantes seleccionados',

   'student'
=> 'estudiante',

   'textual_remote_display'
=> 'textual_remote_display',

   'to'
=> 'para',

   'to [_1] ([_2])'
=> 'para [_1] ([_2])',

   'waiting on [_1]'
=> 'aguardando [_1]',

   'what you just saw on the screen'
=> 'lo que acaba de ver en pantalla',

#SYNC Tue Aug 15 14:43:20 2006

   'Enter my portfolio space'
=> 'Entrar en mi espacio de portafolio',

   'No syllabus information provided.'
=> 'Información del Plan de Estudios NO provisto.',

   'Sorry ...'
=> 'Lo siento ...',

   'This resource might be part of another course.'
=> 'Este recurso puede se parte de otro curso.',

#SYNC Tue Aug 15 16:12:09 2006

   'Agree'
=> 'De Acuerdo',

   'Copy this column'
=> 'Copiar esta columna',

   'Disagree'
=> 'En Desacuerdo',

   'General Intro'
=> 'Introducción General',

   'Greek Symbols'
=> 'Simbolos Griegos',

   'HTML character entities'
=> 'Código de Caracteres HTML',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'Si esta viendo esto en linea, copie y pegue el cualquier texto de la columna derecha en si area para obtener el simbolo en la izquierda.',

   'LON-CAPA Help'
=> 'Ayuda LON-CAPA ',

   'Landscape'
=> 'A lo ancho',

   'Launch navigation window'
=> 'Lanzar ventana de navegación',

   'Grade Levels'
=> 'Niveles del Grado',

   'Lowest Grade Level'
=> 'Nivel mas bajo de Grado',

   'Lowest Grade Level:'
=> 'Nivel mas bajo de Grado:',

   'Highest Grade Level'
=> 'Nivel mas alto de Grado',

   'Highest Grade Level:'
=> 'Nivel mas alto de Grado:',

   'Mark all posts read'
=> 'Marcar todos los mensajes de discusión leídos',

   'My question/comment/feedback:'
=> 'Mi pregunta/comentario/reacción:',

   'Not set -'
=> 'No establecido -',

   'Other Symbols'
=> 'Otros Símbolos',

   'Please check at least one of the following feedback types:'
=> 'Por favor marque al menos uno de los siguentes tipos de comentarios de reacción:',

   'Please rank the following criteria:'
=> 'Por favor evaluar los siguiente criterios:',

   'Portrait'
=> 'A lo largo',

   'Question about resource content'
=> 'Pregunta sobre el contenido del curso',

   'Question/Comment/Feedback about course policy'
=> 'Pregunta/Comentario/Reacción sobre la politica del curso',

   'Select a Course to Enter'
=> 'Seleccione el Curso deseado',

   'Show Me My First Homework Problem'
=> 'Muestrame Mi Primer Problema de la Asignación',

   'Standards'
=> 'Estandares',

   'Strongly Agree'
=> 'Muy de Acuerdo',

   'Strongly Disagree'
=> 'Muy en Desacuerdo',

   'Symbol'
=> 'Símbolo',

   'The material appears to be correct'
=> 'El material parece ser correcto',

   'The material is helpful'
=> 'El material es util',

   'The material is presented in a clear way'
=> 'El material es presentado de una manera clara',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)'
=> 'El recurso esta tecnicamente correcto (carga lo suficientemente rapido, no produce errores, enlaces web funcionan, etc)',

#SYNC Fri Aug 18 20:46:54 2006

   'HTML character enties'
=> 'caracteres HTML',

#SYNC Sat Aug 19 09:31:18 2006

   '"Waiting for Remote Control window to load: "+[_1]'
=> '"Esperando mientras se carga la ventana del Control Remoto: "+[_1]',

   '[_1]Continue[_2] on in Inline Menu mode'
=> '[_1]Continuar[_2] en el modo de Menú en línea',

   'All posts'
=> 'Todos los mensajes de discusión',

   'Change Color Scheme'
=> 'Cambiar Esquema de Colores',

   'Change Colors'
=> 'Cambiar Colores',

   'Change Discussion Display Preferences'
=> 'Cambiar Preferencias de Visualización de Discusión',

   'Change How Math Equations Are Displayed'
=> 'Cambiar cómo las Ecuaciones Matemáticas son Vistas',

   'Change Language'
=> 'Cambiar Idioma',

   'Change Language Preferences'
=> 'Cambiar Preferencias de Idioma',

   'Change Password'
=> 'Cambiar Contraseña',

   'Change Preferences'
=> 'Cambiar Preferencias',

   'Change Roles Page Preferences'
=> 'Cambiar Preferencias de la Página de Funciones',

   'Change Screen Name'
=> 'Cambiar Nombre de la Pantalla',

   'Change Screenname'
=> 'Cambiar nombre de la Pantalla',

   'Change WYSIWYG Editor Preferences'
=> 'Cambiar Preferencias de Editor WYSIWYG',

   'Contact Helpdesk'
=> 'Contactar Centro de Asistencia (Helpdesk)',

   'Current discussion settings'
=> 'Configuración actual para discusiones',

   'Duedate'
=> 'Fecha límite',

   'Due date: [_1]'
=> 'Fecha límite: [_1]',

   'Each post can be toggled read/unread'
=> 'Cada contribución puede marcarse como leído/no leído',

   "Edit the Personal Information Page"
=> "Editar la página de Información Personal",

   'Enable WYSIWYG Editor'
=> 'Usar Editor WYSIWYG',

   'End of Sequence'
=> 'Final de Secuencia',

   'Entering Course'
=> 'Entrando al Curso',

   'Get help'
=> 'Obtener Ayuda',

   'Go to main menu'
=> 'Ir al menú principal',

   'Has New Discussion'
=> 'Tener Discusiones Nuevas',

   'Launching of the Remote Control menu will fail if pop-up window filters are active. To use the Remote Control, disable the filter for this site.'
=> 'Iniciar el Control Remoto fallará si tiene activado el filtro de control de ventanas. Para usar el Control Remoto, desabilite el filtro para este sitio Web.',

   'Navigate Course Content'
=> 'Navegar Contenido del Curso',

   'New posts only'
=> 'Nuevas Contribuciones solamente',

   'No Resource'
=> 'No existe Recurso',

   'No syllabus available'
=> 'Plan de Estudio NO disponible',

   'Not currently assigned.'
=> 'Actualmente NO asignado.',

   'Not new'
=> 'No Nuevo',

   'Off'
=> 'Apagado',

   'On'
=> 'Prendido',

   'Once displayed'
=> 'Una vez mostrado',

   'Once marked not NEW'
=> 'Una vez marcado como no NUEVO',

   'Please click on the the resource you intend to access'
=> 'Por favor pinche en el recurso que intenta accesar',

   'Posts cease to be marked "NEW"'
=> 'Mensajes de Discusión dejaron de marcarse como "NUEVO"',

   'Posts to be displayed'
=> 'Mensajes de Discusión a ser mostrados',

   'Role selected. Please stand by.'
=> 'Función seleccionada. Por favor espere.',

   'Send'
=> 'Enviar',

   'Set User Preferences'
=> 'Establecer Preferencias de Usuario',

   'Show Preview and Check Spelling'
=> 'Mostrar Previa y Revisar Ortografía',

   'Sort by:'
=> 'Ordenar por:',

   'The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu.'
=> 'El menú externo (Control Remoto) ha sido desabilitado, estará trabajando con el menú en línea.',

   'You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.'
=> 'Usted puede haber cerrado la ventana del Control Remoto, o fue bloqueado por el filtro de control de ventanas en su navegador.',

   'To use the Remote Control, disable the filter for this site, and re-launch the Remote Control.'
=> 'Para usar el Control Remoto, desabilite el filtro para este sitio Web, y reinice el Control Remoto.',

   'Re-launch Remote Control'
=> 'Reiniciar Control Remoto',

   'Continue without Remote Control'
=> 'Continuar sin Control Remoto',

   'Assuming no pop-up blocking, the Remote Control can be launched at any time from the [_1]Set User Preferences[_2] page, linked to in the [_3]Main Menu[_2].'
=> 'Asumiendo que no hay bloqueo de ventana, el control remoto puede iniciarse en cualquier momento desde la página [_1]Establecer Preferencias de Usuario[_2] enlazada al [_3]Menú Principal[_2].',

   'There are several possibilities of where to go next'
=> 'Hay varias posibildades de a donde continuar',

   'To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> 'Para usar el Control Remoto, desabilite el filtro para este sitio Web, y reinice el Control Remoto desde el menú en línea..',

   'Toggle read/unread'
=> 'Marcar como leído/no leído',

   'Unread only'
=> 'Solo No leído',

   "View this user's personal information page"
=> "Ver la página de información personal de este usuario",

   'You have reached the end of the sequence of materials.'
=> 'Llegó al final de la secuencia de materiales.',

   'attachments'
=> 'archivos adjuntos',

   'Personal Information Page for a User'
=> 'Página de Información Personal para un Usuario',

   'All documents out of a published map into this folder'
=> 'Todos los documentos pertenecientes a un mapa publicado dentro de esta carpeta',

   'Change Math Pref'
=> 'Cambiar Pref. de Mate.',

   'Change Math Preferences'
=> 'Cambiar Preferencias de Mate.',

   'Comment'
=> 'Comentar',

   'Communication/Messages'
=> 'Communicación/Mensajes',

   'Configure blocking of student communication during exams'
=> 'Configurar bloqueo de la comunición de estudiantes durante exámenes',

   'Convert to Images'
=> 'Convertir a Imágenes',

   'Course and Catalog Search'
=> 'Búsqueda de Curso y Catálogo',

   'Create Subdirectory'
=> 'Crear Subdirectorio',

   'Upload file to current directory'
=> 'Cargar archivo a directorio actual',

   'Create subdirectory in current directory'
=> 'Crear subdirectorio en directorio actual',

   'Upload embedded images/multimedia/css/linked files if HTML file'
=> 'Si es archivo HTML: cargar archivos de imagenes/multimedia/css/enlaces contenidos dentro',

   'Delete Selected'
=> 'Borrar Seleccionado',

   'Critical'
=> 'Crítico',

   'Currently no documents.'
=> 'Actualmente no hay documentos.',

   'Enter terms or phrases, then press "Search" below'
=> 'Entrar términos o frases, luego presione "Buscar"',

   'INBOX'
=> 'BANDEJA de ENTRADA',

   'Upload embedded images/multimedia files if HTML file'
=> 'Si es archivo HTML:<br /> cargar archivos de imagenes/multimedia contenidos dentro',

   'IMS Import'
=> 'Importar IMS',

   'Import IMS package'
=> 'Importar paquete IMS',

   'IMS Export'
=> 'Exportar IMS',

   'Export Course to IMS Package'
=> 'Exportar Curso a paquete IMS',

   'Export content item?'
=> '¿Exportar contenido de elemento?',

   'Export discussion posts?'
=> '¿Exportar mensajes de foros?',

   'As you did not select any content items or discussions for export, an IMS package has not been created.'
=> 'Como no seleccionó ningún contenido de elemento o discusiones de foro para exportar, no se ha creado ningún paquete IMS.',

   'Please [_1]go back[_2] to select either content items or discussions for export.'
=> 'Por favor [_1]volver[_2] a selecionar un contenido de elemento o foro para exportar.',

   '[_1]Your IMS package[_2] is ready for download.'
=> '[_1]Su paquete IMS[_2] está listo para descargar.',

   'Import a document'
=> 'Importar documento',

   'New Composite Page'
=> 'Página Nueva de Compuestos secundarios',

   'New Messages Only'
=> 'Solo Mensajes Nuevos',

   'Portfolio Manager'
=> 'Gestor de Portafolio',

   'Preferred method to display Math'
=> 'Método preferido para mostrar Mate',

   'Published documents'
=> 'Documentos Publicados',

   'Recover Deleted Documents'
=> 'Recuperar Documentos Borrados',

   'Send a Message'
=> 'Enviar Mensaje',

   'Sent Messages'
=> 'Mensajes Enviados',

   'Show'
=> 'Mostrar',

   'TRASH'
=> 'PAPELERA',

   'TeX to HTML'
=> 'TeX a HTML',

   'Upload'
=> 'Cargar',

   'View Folder'
=> 'Ver Carpeta',

   'fulltext search (time consuming)'
=> 'busqueda de texto completo (toma tiempo)',

   'search discussion postings (resources and discussion boards)'
=> 'búsqueda de mensajes de discusión (recursos y foros de discusión)',


#SYNC Sat Aug 19 11:49:40 2006
   'Roles'
=> 'Funciones',

#SYNC Sat Aug 19 12:35:56 2006
   'Select style file'
=> 'Selecionar archivo de estilo (.sty)',

   '(mark them then click "next" button)'
=> '(marquelos luego pinche el botón "siguiente")',

   '100 Level'
=> '1er año universidad', #primer año

   '200 Level'
=> '2do año universidad',

   '300 Level'
=> '3er año universidad',

   '400 Level'
=> '4to año universidad',

   'Action'
=> 'Acción',

   'Actions for current directory'
=> 'Acciones para el directorio actual',

   'Change Discussion Preferences'
=> 'Cambiar Preferencias de Discusión',

   'Change Message Forwarding/Notification'
=> 'Cambiar Mensajes de Reenvío/Notificación',

   'Change WYSIWYG Preferences'
=> 'Cambiar Preferencias del Editor WYSIWYG',

   'Change to '
=> 'Cambiar a ',

   'Clean Up'
=> 'Limpiar',

   'Closed - XML source is closed to everyone'
=> 'Cerrado - fuente XML está cerrado a todos',

   'Copy'
=> 'Copiar',

   'Create a new directory or LON-CAPA document'
=> 'Crear un directorio nuevo o documento LON-CAPA',

   'Current setting '
=> 'Ajuste actual ',

   'Delete Directory'
=> 'Borrar Directorio',

   'Delete directory'
=> 'Borrar directorio',

   'Delete this resource'
=> 'Borrar este recurso',

   'Disable WYSIWYG editor'
=> 'Apagar editor WYSIWYG',

   'Enable WYSIWYG editor'
=> 'Prender Editor WYSIWYG',

   'The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.'
=> 'El editor WYSIWYG solo soporta HTML simple y es en muchos casos inadecuado para autoría avanzada. En un número de casos, puede destruir autoría avanzada que envuelven llamadas LaTeX y funciones de script.',

   'Display Preference'
=> 'Visualizar Preferencia',

   'Grade 1'
=> '1er Grado',

   'Grade 10'
=> '10mo Grado',

   'Grade 11'
=> '11vo Grado',

   'Grade 12'
=> '12vo Grado',

   'Grade 13'
=> '13vo Grado',

   'Grade 2'
=> '2do Grado',

   'Grade 3'
=> '3er Grado',

   'Grade 4'
=> '4to Grado',

   'Grade 5'
=> '5to Grado',

   'Grade 6'
=> '6to Grado',

   'Grade 7'
=> '7mo Grado',

   'Grade 8'
=> '8vo Grado',

   'Grade 9'
=> '9no Grado',

   'Graduate Level'
=> 'Nivel Graduado',

   'List current directory'
=> 'Listar directorio actual',

   'Mark obsolete'
=> 'Marcar como obsoleto',

   'Move'
=> 'Mover',

   'New library file'
=> 'Nuevo archivo de biblioteca',

   'No file: [_1]'
=> 'El archivo no existe: [_1]',

   'No personal information provided'
=> 'No hubo información personal proporcionada',

   'Not specified'
=> 'No especificado',

   'Once marked as read'
=> 'Marcados como leídos',

   'Open - XML source is open to people who want to use it'
=> 'Abierto - fuente XML está abierto para quien quiera usarlo',

   'Points Display'
=> 'Información de Puntos',

   'Completed Problems Display'
=> 'Mostrar Problemas Completados',

   'Points Scored'
=> 'Puntos Obtenidos',

   'Attempted'
=> 'Intentado',

   'Posts displayed?'
=> '¿Qué mensajes de discusión mostrar?',

   'Preferences can be set that determine'
=> 'Las preferencias pueden ser establecidas para determinar ...',

   'Publish this Directory'
=> 'Publicar este Directorio',

   'Publish this resource'
=> 'Publicar este recurso',

   'Retrieve old version'
=> 'Recobrar versión anterior',

   'Select action'
=> 'Selecionar acción',

   'Send message'
=> 'Enviar mensaje',

   'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.'
=> 'Establecer preferencias de visualización para mensajes de discusión en el foro y en los recursos individuales de todos sus cursos.',

   'Source Distribution'
=> 'Distribución de código Fuente',

   'Under what circumstances posts are identfied as "New"'
=> 'Bajo que circunstacias los mensajes de discusión son identificados como "Nuevo"',

   'Upload a new document'
=> 'Cargar un documento nuevo',

   'Use random seed'
=> 'Usar semilla aleatoria',

   'Use style file'
=> 'Usar archivo estilo (.sty)',

   'Which posts are displayed when you display a discussion board or resource, and'
=> 'Que mensajes son mostrados, cuando visualiza un foro de discusión o recurso, y',

   'Source: closed'
=> 'Código Fuente: cerrado',

   'Source: open'
=> 'Código Fuente:abrierto',

   '(mark desired resources then click "next" button)'
=> '(marque los recursos deseados y luego pulse el botón "siguente")',

   '[_1]Change[_2] for just [_3]this course[_4] or for [_5]all your courses/communities[_6].'
=> '[_1]Cambiar[_2] sólo [_3]este curso[_4] o todos [_5]sus cursos/comunidades[_6].',

   '[_1]Change[_2] for just [_3]this community[_4] or for [_5]all your courses/communities[_6].'
=> '[_1]Cambiar[_2] sólo [_3]esta comunidad[_4] o todos [_5]sus cursos/comunidades[_6].',

   "Page displayed after role selection in course now set by [_1]user's global preferences[_2]."
=> "La página mostrada después de seleccionar su función en el curso está ahora establecido por [_1]preferencias globales de usuario[_2].",

   "Page displayed after role selection in community now set by [_1]user's global preferences[_2]."
=> "La página mostrada después de seleccionar su función en la comunidad está ahora establecido por [_1]preferencias globales de usuario[_2].",

   'Page displayed after role selection in this course set to [_1].'
=> 'La página mostrada después de seleccionar su función en este curso esta ajustado a [_1].',

   'Unable to set control of page display to [_1] due to [_2].'
=> 'No se pudo configurar el control de visualización de página a [_1] debido a [_2].',

   'Unable to set page display, after role selection, for this course to [_1] due to [_2].'
=> 'No se pudo configurar visualización de página, después de seleccionar su función, para este curso [_1] debido a [_2].',

   'Add or Edit Blog Entries'
=> 'Añadir o Editar Entradas de Blog',

   'Add to my public course blog'
=> 'Añadir a mi blog público del curso',

   'Annotator'
=> 'Anotator',

   'Av. Attempts'
=> 'Intentos promedio',

   'Available RSS Feeds and Blogs'
=> 'RSS Feeds y Blogs Disponibles',

   'New RSS Feed or Blog'
=> 'Nuevo RSS Feed o Blog',

   'New Feed'
=> 'Nuevo Feed',

   'Average number of attempts'
=> 'Promedio de Número de Intentos',

   'Bookmarks'
=> 'Marcadores',

   'Change interval?'
=> '¿Cambiar intérvalo?',

   'Change options?'
=> '¿Cambiar opciones?',

   'Change thresholds?'
=> '¿Cambiar Umbrales?',

   'Clean up'
=> 'Limpiar',

   'Close Folder'
=> 'Cerrar Carpeta',

   'Configure Blocking of Student Communication during Exams'
=> 'Configurar Bloqueo de la comunicación de Estudiantes durante Exámenes',

   'Communication Blocked'
=> 'Comunicación bloqueada',

   'Communication Blocking Status Information'
=> 'Informe de estado de Bloqueo de la comunicación',

   'Currently active communication blocks'
=> 'Bloques de comunicación actualmente activos',

   'Block set by'
=> 'Bloqueo establecido para',

   '[_1] to [_2]'
=> '[_1] hasta [_2]',

   "Group portfolio in the course '[_1]' will be inaccessible between [_2] and [_3] because communication is being blocked."
=> "Portafolio grupal en el curso '[_1]' estará inaccesible entre [_2] y [_3] porque la comunicación está siendo bloqueada.",

   'Portfolio files belonging to [_1] will be inaccessible between [_2] and [_3] because communication is being blocked.'
=> 'Archivos de portafolio pertenecientes a [_1] estarán inaccesibles entre [_2] y [_3] porque la comunicación está siendo bloqueada.',

   'Your portfolio files will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Sus archivos de portafolio estarán inaccesibles entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'Discussion posts in this course will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Mensajes de foros de discusión en este curso estarán inaccesibles entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'Chat will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Chat estará inaccesible entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'This message will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Este mensaje estará inaccesible entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'Blogs will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Blogs estarán inaccesibles entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'Groups in this course will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'Grupos en este curso estarán inaccesibles entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'Communication will be inaccessible between [_1] and [_2] because communication is being blocked.'
=> 'La comunicación estará inaccesible entre [_1] y [_2] porque la comunicación está siendo bloqueada.',

   'Creating PDF'
=> 'Creando PDF',

   'Currently: [_1].'
=> 'Actualmente: [_1].',

   'Deg. Diff'
=> 'Grado Dif.',

   'Description'
=> 'Descripción',

   'Enter my groups in the course'
=> 'Entrar en mis grupos en el curso',

   'Entering [_1]'
=> 'Entrando [_1]',

   'Entering [_1] ...'
=> 'Entrando [_1] ...',

   'First resource'
=> 'Primer recurso',

   'Generated [_1] ([_2] bytes)'
=> 'Generado [_1] ([_2] bytes)',

   'Go to first resource'
=> 'Ir al primer recurso',

   'Group Documents'
=> 'Documentos del Grupo',

   'Groups'
=> 'Grupos',

   'Help Menu'
=> 'Menu de Asistencia',

   'Hide all'
=> 'Ocultar todo',

   'Hide this Feed'
=> 'Ocultar este Feed',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA-Feed "[_1]" para [_2]',

   'Last Reset'
=> 'Último Reinicio',

   'Last revised'
=> 'Última Revisión',

   'Link'
=> 'Enlace Web',

   'Log In'
=> 'Iniciar Sesión',

   'Move Checked to Folder'
=> 'Mover Seleccionados a Carpeta',

   'Name for New Feed'
=> 'Nombre para Nuevo Feed',

   'Name of this Feed'
=> 'Nombre de este Feed',

   'New course messages'
=> 'Nuevos mensajes del curso',

   'New critical messages in course'
=> 'Nuevos mensajes críticos en el curso',

   'New in course'
=> 'Nuevo en el curso',

   'New version'
=> 'Nueva Versión',

   'No messages sent.'
=> 'No hay mensajes enviados.',

   'No new course messages'
=> 'No hay mensajes nuevos del curso',

   'No problems require handgrading'
=> 'No hay problemas que requieran correción manual',

   'No problems satisfy threshold criteria'
=> 'No hay problemas que satisfacen el criterio umbral',

   'No problems with errors'
=> 'No hay problemas con errores',

   'No unread critical messages in course'
=> 'No hay mensajes críticos NO leídos en el curso',

   'No unread posts in course discussions'
=> 'No hay mensajes de discusión NO leídos en el curso',

   'No updated versions'
=> 'No versiones actualizadas',

   'Num. students'
=> 'Num. estudiantes',

   'Number of errors'
=> 'Número de errores',

   'Number of new posts'
=> 'Número de mensajes de discusión nuevos',

   'Number ungraded'
=> 'Número de problemas no corregidos',

   'Open Folder'
=> 'Abrir Carpeta',

   'Open all folders'
=> 'Abrir todas las carpetas',

   'Page set to be displayed after you have selected a role in this course'
=> 'Página establecida para ser mostrada después de seleccionar su función en este curso',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Por favor seleccione el tipo de entidad LON-CAPA - Curso o Grupo - para el cual desea añadir/modificar la función de usuario.',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Por favor espere mientras se procesa su solicitud de impresión. Esto puede tomar algún tiempo...',

   'Print contents of directory'
=> 'Imprimir contenido de directorio',

   'Print directory'
=> 'Imprimir directorio',

   'Problem'
=> 'Problema',

   'Problem Document'
=> 'Documento de Problema',

   'Problem Name'
=> 'Nombre de Problema',

   'Problem is not open to be viewed. It'
=> 'Problema no está abierto para ser visto. Este',

   'Problems requiring handgrading'
=> 'Problemas que requieren corrección manual',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]'
=> '(Problemas con intentos promedio &ge; [_1] o grado de dificultad &ge; [_2]) [_3] y número total de estudiantes con respuestas enviadas &ge; [_4]',

   'Problems with errors'
=> 'Problemas con errores',

   'Re-publish'
=> 'Re-publicar',

   'Recently generated printouts'
=> 'Impresiones generadas recientemente',

   'Recently generated printout zip files'
=> 'Archivos zip de impresiones generadas recientemente',

   'Reset Count?'
=> '¿Reiniciar Cuenta?',

   'Reset counters to 0'
=> 'Reiniciar contadores a 0',

   'Select [_1]'
=> 'Seleccionar [_1]',

   'Select the sequence to print resources from:'
=> 'Selecionar la secuencia para imprimir recursos desde:',

   'Selected [_1]Problems[_2] from folder [_3]'
=> '[_1]Problemas[_2] seleccionados de carpeta [_3]',

   'Selected [_1]Resources[_2] from folder [_3]'
=> '[_1]Recursos[_2] seleccionados de carpeta [_3]',

   'Selected Problems from entire course'
=> 'Problemas seleccionados de todo el curso',

   'Selected Resources from entire course'
=> 'Recursos seleccionados de todo el curso',

   'Selected Problems from entire course for selected people'
=> 'Problemas seleccionados de todo el curso a personas seleccionadas',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]selected people[_5]'
=> '[_1]Problemas[_2] seleccionados de carpeta [_3] para [_4]personas seleccionadas[_5]',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> '[_1]Problemas[_2] seleccionados de carpeta [_3] para [_4]asignaciones CODE[_5]', # ???

   'Selected [_1]Resources[_2] from folder [_3] for [_4]selected people[_5]'
=> '[_1]Recursos[_2] seleccionados de carpeta [_3] para [_4]personas seleccionadas[_5]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> '[_1]Recursos[_2] seleccionados de carpeta [_3] para [_4]asignaciones CODE[_5]', # ???

   'Selected [_1]Problems[_2] from current subdirectory [_3]'
=> '[_1]Problemas[_2] seleccionados de subdirectorio actual [_3]',

   'Selected Resources from selected folder in course'
=> 'Recursos seleccionados de carpeta seleccionada en curso',

   'Send Message'
=> 'Enviar Mensaje',

   'Send Feedback'
=> 'Enviar Reacción',

   'Show all'
=> 'Mostrar todo',

   'Show my first due problem'
=> 'Mostrar mi primer problema en finalizar',

   'Show only uncompleted problems'
=> 'Mostrar sólo problemas sin resolver',

   'Show everything'
=> 'Mostrar todo',

   'Uncompleted Problems'
=> 'Problemas sin resolver',

   'All homework assignments have been completed.'
=> 'Todos los ejercicios asignados han sido completados.',

   'Speller Suggestions'
=> 'Ortográficas Sugerencias',

   'Start a New Feed'
=> 'Empezar un Nuevo Feed',

   'Save Marked Changes'
=> 'Guardar Cambios Marcados',

   'Save changes'
=> 'Guardar cambios',

   'The preferences you set here can be overridden within each individual discussion.'
=> 'Las preferencias que usted establece aquí pueden ser modificadas dentro de cada discusión individual.',

   'This action is currently not authorized.'
=> 'Esta acción actualmente no está autorizada.',

   'Time of last post'
=> 'Hora del último mensaje de discusión',

   'Title of document goes here'
=> 'Título del documento va aquí',

   'Body of document goes here'
=> 'Cuerpo del documento va aquí',

   'Total number of students with submissions'
=> 'Número total de estudiantes con respuestas enviadas',

   'Unread course discussion posts'
=> 'Mensajes de discusión no leídos del curso',

   'Version used'
=> 'Versión usada',

   'View current problem status and grading information'
=> 'Ver estado actual de problemas y la información de notas',

   "What's New?"
=> "¿Qué hay de Nuevo?",

   "What's New Page"
=> "Página Qué hay de Nuevo",

   'course only'
=> 'curso solamente',

   'delete'
=> 'borrar',

   'first resource in the course'
=> 'primer recurso en el curso',

   'hidden'
=> 'oculto',

   'since last month'
=> 'desde el último mes',

   'since last week'
=> 'desde la última semana',

   'since start of course'
=> 'desde el inicio del curso',

   'since yesterday'
=> 'desde ayer',

   'specific setting for this course'
=> 'configuración específica para este curso',

   'user preference'
=> 'preferencia de usuario',

   'your general user preferences'
=> 'su preferencia de usuario en general',


#SYNC Fri Sep  1 17:10:10 2006

   'Submitting as Comment'
=> 'Enviando como Comentario',

   'Submitting as Policy Feedback'
=> 'Enviando como Reacción a Política del curso',

   'Submitting as Question'
=> 'Enviando como Pregunta',

   'Total Points In Course'
=> 'Puntos Totales en en Curso',

   'You are accessing an invalid course'
=> 'Está accesando un curso inválido',

   'the resource you just saw on the screen'
=> 'el recurso que acaba de ver en pantalla',


#SYNC Fri Sep  1 22:23:03 2006

   'Annotations'
=> 'Anotaciones',

   'Save and Update'
=> 'Guardar y Actualizar',

#SYNC Fri Sep  1 22:39:12 2006

   'Bookmark Tree Viewer/Editor'
=> 'Editar/Mostrar Arbol de Marcadores(Favoritos)',

   'Chat'
=> 'Chat',

   'Chat Room'
=> 'Sala de Chat',

   'Import Bookmarks'
=> 'Importar Marcadores(Favoritos)',

   'The LearningOnline Network with CAPA'
=> 'Red de Aprendizaje en Línea con CAPA (LON-CAPA)',

   'This LON-CAPA server is temporarily not available for login.'
=> 'Este servidor LON-CAPA istá temporalmente no disponible para sesiones.',

   'Please attempt to login to one of the following servers:'
=> 'Por favor intente conectarse desde uno de los siguientes servidores:',

   '(preferred)'
=> '(preferido)',

#SYNC Fri Sep  1 23:07:39 2006

   'Although your current role has privileges to view any existing groups in this course, you do not have privilegesto create new groups.'
=> 'Si bien su función actual tiene privilegios para ver cualquier grupo existente en este curso, usted no tiene privilegio paraa crear grupos nuevos.',

   'Collaborative Tools'
=> 'Herramientas Colaborativas',

   'Course content'
=> 'Contenido de Curso',

   'Create a new group'
=> 'Crear un grupo nuevo',

   'Created'
=> 'Creado',

   'Creator'
=> 'Creador',

   'Discussion Boards'
=> 'Foro de Discusión',

   'Disk Use (%)'
=> 'Uso del Disco (%)',

   'Enable Recent Roles Hotlist:'
=> 'Habilitar Lista Reciente de Funciones:',

   'Files'
=> 'Archivos',

   'Group Name'
=> 'Nombre del Grupo',

   'Group Title'
=> 'Título del Grupo',

   'Members'
=> 'Miembros',

   'Modify'
=> 'Modificar',

   'Re-enable'
=> 'Reactivar',

   'Expire'
=> 'Expirar',

   'Group settings'
=> 'Configuración Grupal',

   'Modify group membership'
=> 'Modificar membresía grupal',

   'No groups exist.'
=> 'No existen grupos.',

   'Number of roles in Hotlist:'
=> 'Número de funciones en Lista Reciente:',

   'Quota (Mb)'
=> 'Cuota (Mb)',

   'Remote Control'
=> 'Control Remoto',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> 'Algunos usuarios LON-CAPA tienen una lista larga de funciones. La Lista Reciente de Funciones tiene la característica de mantener un registro de las últimas N funciones las cuales han sido visitadas y hace una tabla de estas al comienzo de la página de funciones. Personas con muy pocas funciones deberían dejar esta característica desabilitada.',

   'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.'
=> 'Algunos usuarios LON-CAPA tienen una lista larga de cursos. La Lista Reciente de Cursos tiene la característica de mantener un registro de los últimos N cursos los cuales han sido visitados y hace una tabla de estos al comienzo de la página de cursos. Personas con muy pocos cursos deberían dejar esta característica desabilitada.',

   'Switch to Inline Menu Mode'
=> 'Intercambiar al Modo de Menú en línea',

   'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.'
=> 'La lista de abajo puede ser usada para <q>congelar</q> funciones en su pantalla. Las que son marcadas como congeladas no serán removidas de la lista, aun si no han sido usadas recientemente.',

   'View Status'
=> 'Ver Estado',

   'View/Change Status'
=> 'Ver/Cambiar estado',

   'You are not currently a member of any active groups in this course.'
=> 'Actualmente no es miembro de ningún grupo activo en este curso',

   'Group [_1] was updated.'
=> 'Grupo [_1] fue actualizado.',

   'An error occurred while setting parameters for Discussion Boards folder: [_1]'
=> 'Ocurrió un error mientras se configuraba los parámetros de la carpeta del Foro de Discusión: [_1]',

   'Discussion Boards Folder created.'
=> 'Carpeta del Foro de Discusión creada.',

   'You do not have group administration privileges in this course.'
=> 'No tiene privilegios grupales de administración en este curso.',

   'An error occurred when [_1] the group. Please try again.'
=> 'Ocurrió un error cuando "[_1]" el grupo. Por favor trate otra vez.',

   'You have requested deletion of the group [_1].'
=> 'Solicitó eliminación del grupo [_1].',

   'The following users could not be activated, because an error occurred:'
=> 'Los siguientes usuarios no pudieron ser activados porque ocurrió un error:',

   'The following users could not be reenabled, because an error occurred:'
=> 'Los siguientes usuarios no pudieron ser reactivados porque ocurrió un error:',

   'The following users could not be modified, because an error occurred:'
=> 'Los siguientes usuarios no pudieron ser modificados porque ocurrió un error:',

   'The following users could not be added, because an error occurred:'
=> 'Los siguientes usuarios no pudieron ser añadidos porque ocurrió un error:',

   'The following users could not be deleted, because an error occurred:'
=> 'Los siguientes usuarios no pudieron ser eliminados porque ocurrió un error:',

   'The following users could not be expired, because an error occurred:'
=> 'Los siguientes usuarios no pudieron ser expirados porque ocurrió un error:',

   'No change occurred for the following users:'
=> 'Sin cambios para los siguientes usuarios:',

   'When a group is deleted the following occurs:'
=> 'Cuando un grupo es eliminado lo siguiente ocurre:',

   'All group membership is terminated.'
=> 'Toda membresía es terminada.',

   'The group ceases to be available either for viewing or for modification of group settings and membership.'
=> 'El grupo deja de esta disponible para ser visto o modificado en configuración y membresía.',

   'The group folder is removed from the folder containing it - normally this is the "Course Groups" folder which contains folders for all groups in the course.'
=> 'La carpeta grupal es removida de la carpeta que la contenga - normalmente esta es la carpeta "Grupos del Curso" que contiene carpetas para todos los grupos en el cursos.',

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.'
=> 'A pesar que un grupo eliminado ya no es accesible, el nombre usado para el grupo será reservado y no será disponible para asignarse a un nuevo grupo en el mismo curso en el futuro.',

   'Delete group'
=> 'Eliminar grupo',

   'Group deletion failed because deletion of [_1] out of [_2] members failed.'
=> 'Eliminación de Grupo falló porque eliminación de [_1] de [_2] miembros falló.',

   'Group successfully deleted.'
=> 'Grupo eliminado exitosamente.',

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Course Groups' folder: [_1]"
=> "A pesar que el grupo fue eliminado, ocurrió un error cuando se removía la carpeta grupal de la carpeta 'Grupos del Curso': [_1]",

   'Group deletion failed.'
=> 'Falló eliminación de grupo.',

   'Course Folder -[_1]'
=> 'Carpeta del Curso - [_1]',

   'An error occurred when saving updated parent folder to group:'
=> 'Ocurrió un error cuando guardaba actualización de carpeta superior al grupo:',

   'An error occurred when reading contents of parent folder to group:'
=> 'Ocurrió un error cuando leía contenido de carpeta superior al grupo:',

   'You have requested enabling the previously deleted group [_1].'
=> 'Solicitó activar un grupo previamente eliminado [_1].',

   'When a deleted group is re-enabled the following occurs:'
=> 'Cuando un grupo eliminado es reactivado ocurre lo siguiente:',

   'Group settings and membership at the time the group was deleted are reinstated.'
=> 'Se reinstala la configuración y membresía del grupo al momento que el grupo fue eliminado.',

   'A group folder is added to the "Course Groups" folder which contains folders for all groups in the course.'
=> 'Una carpeta grupal es añadida a la carpeta "Grupos del Curso", que contiene carpetas de todos los grupos del curso.',

   'Reenable group'
=> 'Reactiva grupo',

   'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?'
=> 'El grupo [_1] no fue reactivado, porque no es un grupo eliminado.[_2]¿Quizas ya había sido reactivado?.',

   'No end date set'
=> 'Sin fecha de finalizar',

   'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]'
=> 'Membresía reinstalada para [_quant,_1,usuario], cada uno con fechas de inicio y término para acceso grupal preestablecido a: [_2] y [_3].',

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]"
=> "A pesar que el grupo fue reactivado,ocurrió un error cuando añadía la carpeta grupal a la carpeta 'Grupos del Curso': [_1]",

   'Re-enabling group failed.'
=> 'Falló reactivación de grupo.',

   'with related words'
=> 'con palabras relacionadas',

   'with no related words'
=> 'sin palabras relacionadas',

#SYNC Fri Sep  1 23:29:38 2006

   'Change Roles Preferences'
=> 'Cambiar Preferencias de Función',

   'Display [_1] Most Recent Roles'
=> 'Mostrar [_1] Funciones Más Recientes',

   'Freeze Role'
=> 'Congelar Función',

   'Recent Roles Hotlist is Disabled'
=> 'Lista de Funciones Recientes está desactivado',

   'Recent Roles Hotlist is Enabled'
=> 'Lista de Funciones Recientes está activado',


#SYNC Sat Sep  2 00:00:45 2006

   'Author Space'
=> 'Area de Autor',

   'Degree of discrimination'
=> 'Grado de discriminación',

   'Disable WYSIWYG Editor'
=> 'Desactivar Editor WYSIWYG',

   'Hypertext Document'
=> 'Documento HTML',

   'Last Modifying User'
=> 'Última Modificación de Usuario',

   'Last Revision Date'
=> 'Fecha de Última Revisión',

   'Linked/Related Resources'
=> 'Recursos Enlazados/Relacionados',

   'Network-wide courses using resource'
=> 'Cursos a lo largo de la red usando el recurso',

   'Never'
=> 'Nunca',

   'Preview'
=> 'Vista Previa',

   'Resources that follow this resource in maps'
=> 'Recursos que siguen este recurso en mapas',

   'Resources that lead up to this resource in maps'
=> 'Recurso que llevan a este recurso en mapas',

   'Resources used by this resource'
=> 'Recursos usados por este recurso',

   'Resources using or importing resource'
=> 'Recursos usando o importando recurso',

   'Return'
=> 'Volver',

   'Source Available'
=> 'Fuente Disponible',

   'Source Custom Distribution File'
=> 'Fuente de Archivo de Distribución Personalizado',

   'Start new page<br />before selected'
=> 'Empezar página nueva<br />previamente seleccionada',

   'on'
=> 'prendido',

   '(on)'
=> '(prendido)',

   'off'
=> 'apagado',

   '(off)'
=> '(apagado)',

#SYNC Sat Sep  2 20:43:30 2006

   '(re-initialize course to access)'
=> '(reinicilizar curso para accesar)',

   'All Parts'
=> 'Todas las Partes',

   'Changes will become active for your current session after [_1], or the next time you log in.'
=> 'Los cambios se activarán para su sesión actual después de [_1], o la próxima vez que inicie una sesión.',

   'Cut'
=> 'Cortar',

   'Random Order'
=> 'Orden al azar',

   'Due and Answer Available'
=> 'Finalizó y Respuesta Disponible',

   'Edit any group in the course'
=> 'Editar cualquier grupo del curso',

   'Editing the Table of Contents for your Course'
=> 'Editando la Tabla de Contenidos para su Curso',

   'Enter any group in the course'
=> 'Entrar un grupo cualquiera en el curso',

   'Existing Parameter Settings for Your Resources'
=> 'Existe Ajuste de Parámetros para sus Recursos',

   'Group'
=> 'Grupo',

   'Group:'
=> 'Grupo:',

   'Hidden'
=> 'Ocultar',

   'List Symbs'
=> 'Identificador interno',

   'Symb List'
=> 'Lista de indentificadores internos',

   'Manage Course Slots'
=> 'Establecer Franjas horarias del Curso',

   'Manage student enrollment '
=> 'Controlar matrícula de estudiante ',

   'Modify Resource Parameters - Overview Mode'
=> 'Modificar Parámetros de Recurso - Modo Panorámico',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> 'Modificar ajuste de parámetros (fechas, etc) para recursos y el curso',

   'Modify parameter settings for this resource'
=> 'Modificar ajuste de parámetros para este recurso',

   'New and Existing Parameter Settings for Your Resources'
=> 'Ajuste de Parámetros Nuevos y Existentes para sus Recursos',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> 'Bitácora de Cambios a Parámetros y Notificación al blog del curso de mensajes/usuarios ',

   'Parameter Manager'
=> 'Control de Parámetros',

   'Randomly Pick: '
=> 'Escoger al azar: ',

   'Remove'
=> 'Eliminar',

   'Rendering:'
=> 'Representación:',

   'Select Parameters to View'
=> 'Seleccionar Parámetros a Ver',

   'Select Parts to View'
=> 'Seleccionar Partes a Ver',

   'Set Parameter Setting Default Actions'
=> 'Establecer Ajuste de Parámetros de Acciones Predeterminadas',

   'Set Portfolio Metadata'
=> 'Establecer Metadatos de Portafolio',

   'Set/Modify Resource Parameters - Helper Mode'
=> 'Establecer/Modificar Parámetros de Recurso - Modo Asistente',

   'Set/Modify Resource Parameters - Overview Mode'
=> 'Establecer/Modificar Parámetros de Recurso - Modo Panorámico',

   'Set/Modify Resource Parameters - Table Mode'
=> 'Establecer/Modificar Parámetros de Recursor - Modo de Tabla',

   'Settings for Your Course'
=> 'Configuración para su Curso',

   'Table Mode'
=> 'Modo de Tabla',

   'Table Mode Parameter Setting'
=> 'Ajuste de Parámetros Modo de Tabla',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'El recurso en "[_1]" está abierto por tiempo limitado. Una vez presione el botón "[_2]" de abajo, usted tiene [_3] para completar todos los recursos en "[_1]".',

   'URL hidden'
=> 'Ocultar URL',

   'Update Parameter Display'
=> 'Actualizar Visualización de Parámetros',

   'View calculated grades (Spreadsheet)'
=> 'Ver cómputo de notas (Hoja de Cálculo)',

   're-initializing Course'
=> 'reinicializar el Curso',

   'Show Resource'
=> 'Mostrar Recurso',

   'Feedback to resource author'
=> 'Comentario de reacción al autor del recurso',

   'Click to add/remove attachments',
=> 'Pulsar para añadir/quitar archivos adjuntos',

   'New attachments'
=> 'Nuevos archivos adjuntos',

   'Retained attachments'
=> 'Archivos adjuntos Retenidos',

   'Add a new attachment to this post.'
=> 'Añadir un nuevo archivo adjunto a este comentario.',

   'Discussion Post Attachments'
=> 'Archivos adjuntos al Comentario de Discusión',

   'Modify course settings'
=> 'Modificar configuración del curso',

   'Send and display broadcast e-mail'
=> 'Enviar y mostrar emisión de e-mail',

   'Awarded Total Points'
=> 'Total de puntos adjudicados',

   'Total Parts Done'
=> 'Total de Partes Resueltas',

   'Create a single course'
=> 'Crear un curso',

   'Create a new course by completing an online form.'
=> 'Crear un curso nuevo completando una forma en línea.',

   'Create a single collaborative group space'
=> 'Crear un area grupal colaborativa',

   'Create a new group space for non-course use by completing an online form.'
=> 'Crear un area grupal para usarse sin curso completando una forma en línea.',

   'Create courses/groups by uploading an attributes file'
=> 'Crear cursos/grupos cargando archivo de atributos.',

   'Upload an attributes file containing specifications for one or more courses or groups in XML format.'
=> 'Cargar un archivo de atributos que contiene especificaciones para uno o más cursos o grupos en formato XML.',

   'current'
=> 'actual',

   'Version changes'
=> 'Cambios de Versión',

   'Change interval'
=> 'Cambiar intérvalo',

   'Student Submission Reports'
=> 'Reporte del Envio de Respuestas de los Estudiantes',

   'Prepare reports of student submissions.'
=> 'Preparar reporte del Envio de Respuestas de Estudiantes',

   'Survey Reports'
=> 'Reporte de Encuestas',

   'Prepare reports on survey results.'
=> 'Preparar reporte de los resultados de encuestas',

   'View survey'
=> 'Ver encuesta',

   'Previous Survey'
=> 'Encuesta anterior',

   'Next Survey'
=> 'Siguiente encuesta',

   'Choose a different Survey'
=> 'Elija una encuesta diferente',

   'Generate Report'
=> 'Generar Reporte',

   'Part [_1], Response [_2]'
=> 'Parte [_1], Respuesta [_2]',

   'Foil Name'
=> 'Nombre de Opción',

   'Foil Text'
=> 'Texto de Opción',

   'Percent'
=> 'Porciento',

   'Correct Problems Plot'
=> 'Gráfica de Problemas Correctos',

   'Display a histogram of student performance in the course.'
=> 'Mostrar histograma del desempeño de los estudiantes en el curso',

   'Access Status'
=> 'Estado de Acceso',

   '[_1] Limit by time'
=> '[_1] Límite por tiempo',

   'Submission Time Plots'
=> 'Gráficas de tiempos de envíos de respuesta',

   'Currently Has Access'
=> 'Actualmente tienen Acceso',

   'Will Have Future Access'
=> 'Tendrán Acceso',

   'Previously Had Access'
=> 'Previamente tuvo Acceso',

   'Any Access Status'
=> 'Cualquier Estado de Acceso',

   'Previous Problem'
=> 'Problema Anterior',

   'Next Problem'
=> 'Siguiente Problema',

   'Choose a different Problem'
=> 'Escoger un Problema diferente',

   'Update Caches'
=> 'Actualizar Caches',

   'Begin'
=> 'Empezar',

   'There are no students in the sections selected.'
=> 'No hay estudientes en las secciones seleccionadas.',

   'There are no students in the sections/groups selected.'
=> 'No hay estudientes en las secciones/grupos seleccionados.',

   'There is no submission data for this problem at all.'
=> 'No hay ningun dato enviado para este problema.',

   'There is no submission data for this problem.'
=> 'No hay datos enviados para este problema.',

   'There is no submission data for this resource.'
=> 'No hay datos enviados para este recurso.',

   'There is no student data for this problem.'
=> 'No hay datos de estudiantes para este problema.',

   'There is no data to plot.'
=> 'No hay datos para graficar.',

   'Analysis of [_1] is not supported.'
=> 'Análisis de "[_1]" no es funcional.',

   'None of the selected students attempted the problem more than [quant,_1,time].'
=> 'Ninguno de los estudiantes seleccionados intentó el problema más de [quant,_1,vez,veces].',

   'None of the selected students have attempted the problem.'
=> 'Ninguno de los estudiantes seleccionados intentó el problema.',

   'The analysis you have selected is not supported at this time.'
=> 'El análisis que seleccionó no es funcional en este momento.',

   'Graph Problem Submission Times'
=> 'Graficar Tiempo de Envios de Respuesta del Problema',

   'Return to Directory'
=> 'Volver al Directorio',

   'Return to directory'
=> 'Volver al directorio',

   'My Roles'
=> 'Mis Funciones ',

   'My Space'
=> 'Mi Area',

   'Edit blogs, RSS feeds, and podcasts'
=> 'Editar Blogs, RSS-Feeds y Podcasts',

   'Content Library'
=> 'Contenido de la Biblioteca',

   'Search the contents of this course or accessible portfolio files'
=> 'Buscar en el contenido de este curso o en los archivos permitidos del portafolio',

   'Grading and Statistics'
#=> 'Corrección de Notas y Estadísticas',
=> 'Calificación y Estadísticas',

   'Other'
=> 'Otros',

   'group'
=> 'grupo',

   'Actions'
=> 'Acciones',

   'Size'
=> 'Tamaño',

   'Current Access Status'
=> 'Estado de Acceso Actual',

   'Delete Checked Files'
=> 'Borrar Archivos Marcados',

   'Using the portfolio file list'
=> 'Usando la lista de archivos del portafolio',

   'Help on the portfolio'
=> 'Asistencia con portafolio',

   'Private'
=> 'Privado',

   'Change How Menus are Displayed'
=> 'Cambiar como los Menús son Visualizados',

   'Use icons and text'
=> 'Usar iconos y texto',

   'Use buttons and text'
=> 'Usar botones y texto',

   'Use icons only'
=> 'Usar solo iconos',

   'Previous Tries'
=> 'Intentos Anteriores',

   'Change Main Menu'
=> 'Cambiar Menú Principal',

   'Screenname'
=> 'Nombre de Pantalla',

   '(shown if you post anonymously)'
=> '(Si envía comentarios anónimos)',

   'Nickname'
=> 'Apodo',

   '(shown if you post non-anonymously)'
=> '(Si envía comentarios NO anónimos)',

   'Choose the time window to use to display roles for which access to the course expired.'
=> 'Escoger ventana de tiempo a usarse para mostrar funciones para las cuales el acceso al curso a expirado.',

   'Choose the time window to use to display roles for which access to the course became available.'
=> 'Escoger ventana de tiempo a usarse para mostrar funciones para las cuales el acceso al curso está disponible.',

   'Choose the time window to use to display resources in the course with version changes.'
=> 'Escoger ventana de tiempo a usarse para mostrar recursos en el curso con cambios de versión.',

   'User Management'
=> 'Control de Usuarios',

   'Manage student enrollment'
=> 'Control de Matrícula de estudiantes',

   'Modify an existing group'
=> 'Modificar un grupo existente',

   'Delete an existing group'
=> 'Eliminar un grupo existente',

   'Re-enable a deleted group'
=> 'Reactivar un grupo eliminado',

   'Enter an existing group'
=> 'Entrar un grupo existente',

   'Course Management'
=> 'Gerencia del Curso',

   'Reset Student Access Times'
=> 'Reiniciar Tiempos de Acceso de Estudiantes',

   'Submission #'
=> 'Respuesta #',

   'Try'
=> 'Intento',

   'Try [_1]'
=> 'Intento [_1]',

   'Submitted Answer'
=> 'Respuesta Enviada',

   'Close Window'
=> 'Cerrar Ventana',

   'Close window'
=> 'Cerrar ventana',

   'Portfolio Search'
=> 'Buscar en Portafolio',

   'Enter words and quoted phrases'
=> 'Entrar palabras y frases entre comillas',

   'Portfolio and Course Search'
=> 'Busqueda en Portafolio y Curso',

   'Message Status'
=> 'Estado de Mensaje',

   'Any'
=> 'Cualquiera',

   'Unread'
=> 'No leído',

   'Read'
=> 'Leído',

   'Replied to'
=> 'Respondido a',

   'Forwarded'
=> 'Reenviado',

   'Rename Folder'
=> 'Renombrar Carpeta',

   'Delete Folder'
=> 'Borrar Carpeta',

   'Recent Roles'
=> 'Funciones Recientes',

   'Close navigation window'
=> 'Cerrar ventana de navegación',

   'Post Anonymous'
=> 'Mensaje Anónimo',

   'Post'
=> 'Mensaje',

   'Back to preferences menu'
=> 'Volver al menú de preferencias',

   'Forward messages to other account(s) in LON-CAPA'
=> 'Reenviar mensajes a otra(s) cuenta(s) en LON-CAPA',

   'Forward to account(s)'
=> 'Reenviar a cuenta(s)',  # 'Direccion(es) de Reenvío',

   'e.g. <tt>userA:domain1,userB:domain2,...</tt>'
=> 'p.e. <tt>usuarioA:dominio1,usuarioB:Dominio2,...</tt>',

   'E-mail notification of LON-CAPA messages'
=> 'Notificación por E-mail de mensajes LON-CAPA', # 'Notificación de dirección de E-mail',

   'E-mail address(es) which should be notified about new LON-CAPA messages'
=> 'Direccion(es) de E-mail que deben ser notificados acerca de nuevos mensajes LON-CAPA',

   'e.g. <tt>joe@doe.com</tt>'
=> 'p.e. <tt>instructor@domino.edu</tt>',

   'Notification address'
=> 'Dirección de Notificación',

   'Types of message for which notification is sent'
=> 'Tipos de mensaje por lo que la notificación es enviada',

   'Excerpt retains HTML tags in message'
=> 'Extracto conserva etiquetas HTML en mensaje',

   'All'
=> 'Todos',

   'Critical only'
=> 'Solo Críticos',

   'Non-critical only'
=> 'Solo NO Críticos',

   'Add new address'
=> 'Añadir nueva dirección',

   'What are forwarding and notification addresses?'
=> '¿Cuales son direcciones de reenvío y notificación?',

   'What are critical messages?'
=> '¿Cuales son mensajes críticos?',

   'Change Roles Page Pref'
=> 'Cambiar Preferencias de la Página de Funciones',

   'Number of Roles in Hotlist:'
=> 'Número de Funciones en Lista Reciente:',

   'Current Password'
=> 'Contraseña Actual',

   'New Password'
=> 'Contraseña Nueva',

   'Confirm Password'
=> 'Confirmar Contraseña',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> 'Contraseña debe tener un mínimo de 7 caracteres. Por favor trate de nuevo.',

   'The new passwords you entered do not match. Please try again.'
=> 'La nueva contraseña que entró no coinciden. Por favor trate de nuevo',

   'Send me a message'
=> 'Envíame un mensaje',

   'Show Public View'
=> 'Mostrar Vista Pública',

   'Delete Photo'
=> 'Borrar Foto',

   'Help with filling in text boxes'
=> 'Asistencia con llenado de caja de textos',

   'Examples'
=> 'Ejemplos',

   'Summary Preview'
=> 'Resumen de Vista Previa',

   'Send copy to permanent e-mail address (if known)'
=> 'Enviar copia a dirección permanente de E-Mail (si conoce)',

   'Include in course RSS newsfeed'
=> 'Incluir en curso nuevo RSS-Feeds',

   'Allow replies:'
=> 'Permitir contestar:',

   'Reply to:'
=> 'Contestar a:',

   'Domain Management'
=> 'Administración del Dominio',

   'Course ID of Key Authority:'
=> 'ID del Curso que tiene Llave de Autoridad:',

   'Set domain configuration'
=> 'Establecer configuración del dominio',

   'Domain Configuration'
=> 'Configuración del Dominio',

   'View/Modify Domain Settings'
=> 'Ver/Modificar Configuración del Dominio',

   'Menu'
=> 'Menú',

   'Domain Settings'
=> 'Configuración del dominio',

   'Course Environment'
=> 'Variables de Ambiente del Curso',

   'Edit Course Environment'
=> 'Editar Variables de Ambiente del Curso',

   'Users allowed to clone course'
=> 'Usuarios permitidos de clonar curso',

   'Users with active Course Coordinator role in this course are permitted to clone and need not be included.'
=> 'Usuarios con función activa de Coordinador del Curso en este curso están permitidos de clonar y no necesitan ser incluídos.',

   'Use [_1] to allow course to be cloned by anyone in the specified domain.'
=> 'Usar [_1] para permitir clonar el curso por quien quiera del dominio especificado.',

   'Use [_1] to allow unrestricted cloning in all domains.'
=> 'Usar [_1] para permitir clonar sin restricciones en todos los dominios.',

   'URL of Syllabus (not using internal handler)'
=> 'URL del Plan de Estudios (si no usa la herramienta interna)',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Personalizar Texto para opción de preguntas sobre el Contenido del Recurso en comentarios de Reación',

   'Custom Text for Course Content Option in Feedback'
=> 'Personalizar Texto para opción sobre el contenido del curso en comentarios de Reación',

   'Custom Text for Course Policy Option in Feedback'
=> 'Personalizar Texto para opción sobre la política del curso en comentarios de Reación',

   'Allow students to view classlist.'
=> 'Permitir a los estudiantes ver la lista de clase',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Permitir editar/borrar sus propios mensajes de discusión a usuarios con funciones especificas',

   'Suppress number of tries in printing'
=> 'Suprimir número de intentos en impresión',

   'Default paper type'
=> 'Formato de papel estándar',

   'Default beginning date for student access.'
=> 'Determinación de la fecha de inicio de acceso a los estudiantes.',

   'Default ending date for student access.'
=> 'Determinación de la fecha de finalización de acceso  a los estudiantes.',

   'Disable checking of Significant Figures'
=> 'Desactivar revisión de Cifras Significativas',

   'Disable automatically printing point values onto exams.'
=> 'Desactivar impresión automatica de puntos en los exámenes',

   'Send message to student when clicking Done on Tasks'
=> 'Enviar mensaje al estudiante cuando presiona Hecho en los Ejercicios', # ???

   'Restrict Metadata'
=> 'Metadato Restringido',

   'Show to student'
=> 'Mostrar a los estudiantes',

   'Provide text area for students to type metadata'
=> 'Proveer area de texto a los estudiantes para tipear metadatos',

   'Provide choices for students to select from'
=> 'Proveer alternativas a los estudiantes de donde seleccionar',

   'Student may select multiple choices from list'
=> 'El estudiante puede seleccionar varias alternativas de una lista',

   'Student may select only one choice from list'
=> 'El estudiante puede seleccionar solo una altenativa de una lista',

   'Add a Metadata Field'
=> 'Añadir un campo de Metadata',

   'Order Metadata Fields'
=> 'Organizar los Campos de Metadatos',

   'Continue Import'
=> 'Continuar Importando',

   'Continue Search'
=> 'Continuar Busqueda',

   'Finish Import'
=> 'Terminar de Importar',

   'Include'
=> 'Incluir',

   'LON-CAPA Catalog Search'
=> 'Buscar en Catálogo LON-CAPA',

   '[_1] include external resources'
=> '[_1] incluir recursos externos',

   'Change Course Initialization Preference'
=> 'Cambiar Preferencias en Inicialización del Curso',

   'Change Course Init. Pref.'
=> 'Cambiar Pref. de Inicia. del Curso',

   'Reset Access Times'
=> 'Reiniciar Tiempos de Acceso',

   'Select Scope'
=> 'Seleccionar Alcance',

   'Reset times on one or more folders/maps for a single student.'
=> 'Reiniciar tiempos en uno o más carpetas/mapas para un estudiante.',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Reiniciar tiempos en una sóla carpeta/mapa para una sección o toda la clase.',

   'Choose a student:'
=> 'Escoja  un estudiante:',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Seleccionar Estudiantes Matriculados Actualmente y Personal Activo del Curso',

   'This is a list of first access times and what was accessed, please select those you want deleted.'
=> 'Esta es una lista tiempos de accesos por primera vez y que fue accesado, por favor selecciones aquellos que quiera borrar.',

   'Select:'
=> 'Seleccionar:',

   'All Course Personnel'
=> 'Todo el personal del Curso',

   'No Section'
=> 'Sin Sección',

   'Unselect'
=> 'Deseleccionar',

   'Select a folder/map'
=> 'Seleccionar carpeta/mapa',

   'Will remove access times for'
=> 'Se eliminará los tiempos de acceso para',

   'from users'
=> 'de usuarios',

   'No Access times found for student'
=> 'No se encontró tiempo acceso para estudiante',

   'Finish'
=> 'Terminar',

   'Name of New Folder'
=> 'Nombre de Carpeta Nueva',

   'Name of New Page'
=> 'Nombre de Página Nueva',

   'New Page'
=> 'Página Nueva',

   'WARNING: Removing a resource makes associated grades and scores inaccessible!'
=> 'ADVERTENCIA: Eliminando un recurso hace inaccesible las notas y puntos asociados es este!',

   'Clipboard'
=> 'Portapapeles',

   'Remove[_99]'
=> 'Eliminar[_99]',

   '?[_99]'
=> '?[_99]',

   'WARNING: Cutting a resource makes associated grades and scores inaccessible!'
=> 'ADVERTENCIA: Cortando un recurso hace inaccesible las notas y puntos asociados es este!',

   'Grades remain inaccessible if resource is pasted into another folder.'
=> 'Calificaciones permanecen inaccesibles si recurso es pegado dentro de otra carpeta.',

   'Cut[_98]'
=> 'Cortar[_98]',

   '?[_98]'
=> '?[_98]',

   'Paste'
=> 'Pegar',

   'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].'
=> 'Esta ventana muestra cuantos problemas (o partes de problema) ha completado y cuantos no ha hecho aún. También puede ver en [_1]hoja de puntuación detallada[_2].',

   'This may take a few moments to display.'
=> 'Esto puede tomar algunos momentos en mostrase.',

   'Detailed Citation Preview'
=> 'Previa de la Citación detallada',

   'related words'
=> 'palabras relacionadas',

   'Any domain'
=> 'Cualquier dominio',

   'Reset'
=> 'Reiniciar',

   'MIME Type Category'
=> 'Categoria Tipo-MIME',

   'Domains'
=> 'Dominios',

   'Custom Metadata fields'
=> 'Personalizar campos de Metadato',

   'Field Name'
=> 'Nombre del Campo',

   'Field Value(s)'
=> 'Valor(es) del Campo',

   'Another custom field/value pair?'
=> '¿Personalizar otro par campo/valor?',

   'Creation and Modification dates'
=> 'Fechas de Creación y Modificación',

   'Created between'
=> 'Creado entre',

   'Last modified between'
=> 'Última vez modificado entre',

   'Standard Portfolio Metadata'
=> 'Metadato de Portafolio Estándar',

   'Advanced Portfolio Search'
=> 'Busqueda avanzada en Portafolio',

   'Standard Catalog Metadata'
=> 'Metadato de Catálogo Estándar',

   'Problem Statistics'
=> 'Estadísticas del Problema',

   'Statistics calculated for number of students'
=> 'Estadística calculada para número de estudiantes',

   'Portfolio and Catalog Search'
=> 'Buesqueda en Portafolio y Catálogo',

# 2007-06-22
   'Search the database of accessible portfolio files'
=> 'Buscar en la base de datos las archivos accesibles de portafolio',

   'Construction Space:'
=> 'Zona de Construcción:',

   'Problem Status:'
=> 'Estado del Problema:',

   'Problem Type:'
=> 'Problema Tipo:',

   'Feedback Mode:'
=> 'Modo de Reacción:',

   'Answer for Part: [_1]'
=> 'Respuesta para Parte [_1]',

   'Script Vars'
=> 'Variables de Script',

   'Regular file'
=> 'Archivo Regular',

   'Testbank file'
=> 'Archivo de Banco de problemas',

   'IMS package'
=> 'Paquete IMS',

   'There are unsaved changes'
=> 'Cambios no se guardaron!',

   'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'Se encontró respuestas NO analizables en este problema, actualmente sólo respuestas de estilo Fórmula Númerica y Texto Concatenados tienen soporte.',

   'Page Background Color'
=> 'Color de Página de Fondo',

   'Header Background Color'
=> 'Color de Fondo del Encabezado',

   'Header Border Color'
=> 'Color del Borde del Encabezado',

   'Font Color'
=> 'Color de Caracter',

   'Font Menu Color'
=> 'Menú de Color de Caracter',

   'Un-Visited Link Color'
=> 'Color de enlaces Web no visitados',

   'Visited Link Color'
=> 'Enlaces Web Visitados',

   'Active Link Color'
=> 'Color de enlaces Web activos',

   'Reset All'
=> 'Reiniciar Todo',

   'Reset All Colors to Default'
=> 'Reiniciar todos los colores',

   'Set [_1] to [_2]'
=> 'Establecer [_1] en [_2]',

   'Reset [_1]'
=> 'Reiniciar [_1]',

   'Save and Edit'
=> 'Guardar y Editar',

   'Save and View'
=> 'Guardar y Ver',

   'Check Spelling'
=> 'Revisar Ortografía',

   'Selecting a Course'
=> 'Seleccionar un Curso',

   'Course Activity:'
=> 'Actividad del Curso:',

   'Course Domain:'
=> 'Dominio del Curso:',

   'Course Institutional Code:'
=> 'Código Institucional del Curso:',

   "Course Owner's Username:"
=> 'Usuario Dueño del Curso:',

   "Course Owner's Domain:"
=> 'Dominio del Dueño del Curso:',

   'LON-CAPA course ID:'
=> 'ID del curso LON-CAPA:',

   'Course Title:'
=> 'Título del Curso:',

   'Course Description'
=> 'Descripción del Curso',

   'Resource Space Home'
=> 'Area de Origen del Recurso',

   'Default start and end dates for student access'
=> 'Fechas definidas de inicio y término para acceso de estudiantes',

   'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> '¿Notificación al coordinador del dominio vía mensaje LON-CAPA cuando ocurre cambios de matrícula durante la actualización automática?',

   'Course Group Settings'
=> 'Configuración de Grupos del Curso',

   'Set a quota for the total disk space available for storage of course group portfolio files'
=> 'Establecer una cuota para el espacio total del disco a almacenar para los arcchivos de portafolio grupal del curso',

   'Creation Options'
=> 'Opciones de Creación',

   ' Creation Settings'
=> ' Configuración de Creación',

   'Creation Outcome'
=> 'Resultado de la Creación',

   'New LON-CAPA course ID:'
=> 'Nuevo ID de curso LON-CAPA:',

   'Created on'
=> 'Creado en',

   'Cloning course from'
=> 'Clonando curso de',

   'Setting environment'
=> 'Configurando Ambiente',

   'Opening all assignments'
=> 'Abriendo todas las asignaciones',

   'Setting first resource'
=> 'Estableciendo primer recurso',

   'Assigning role of Course Coordinator to [_1]:'
=> 'Asignando función de Coordinador de Curso a [_1]: ',

   'Assigning role of Group Coordinator to [_1]:'
=> 'Asignando función de Coordinador de Grupo a [_1]: ',

   'Roles will be active at next login'
=> 'Funciones se activarán en la siguiente sesión',

   'Active at next login.'
=> 'Activo en la siguiente sesión. ',

   'Expired after logout.'
=> 'Expira cuando termine sesión.',

   'No new course created.'
=> 'No hay curso nuevo creado.',

   'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.'
=> 'NO se pudo clonar un nuevo curso  ( del original [_1]) porque no existe el curso.',

   'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).'
=> 'NO se pudo clonar el curso nuevo basado en el curso existente porque el dueño del curso nuevo ([_1]) no tiene derechos para clonar el curso existente ([_2]).',

   'Create Another Course'
=> 'Crear Otro Curso',

   'Create Another Group'
=> 'Crear Otro Grupo',

   'from domain'
=> 'del dominio',

   'Submit Evaluation'
=> 'Enviar Evaluación',

   'Thank you for your input!'
=> 'Gracias por su participación',

   'Saving feedback: [_1]'
=> 'Guardando Reacción: [_1]',

   'Logging first evaluation'
=> 'Registrando primera evaluación',

   'Standard Problem'
=> 'Problema Estándar',

   'Practice'
=> 'Práctica',

   'Exam'
=> 'Examen',

   'Survey'
=> 'Encuesta',

   'Library'
=> 'Biblioteca',

   'Value:'
=> 'Valor:',

   'String Value'
=> 'Valor de Texto',

   'practice'
=> 'práctica',

   'Loading Domain Coordinator Menu'
=> 'Cargando Menú de Coordinador de Dominio...',

   "Disk space allocated to user's portfolio files"
=> "Espacio de Disco asignado a los archivos de portafolio del usuario",

   'Current quota'
=> 'Cuota actual',

   'Change quota'
=> 'Cambiar cuota',

   'Custom quota'
=> 'Personalizar cuota',

   'Existing sections'
=> 'Secciones existentes',

   'Define new section'
=> 'Definir sección nueva',

   'Create/Modify Another User'
=> 'Crear/Modificar Otro Usuario',

   'Set Privileges for New User'
=> 'Establecer Privilegios para Usuario Nuevo',

   'Generating user'
=> 'Generando usuario',

   'Generating user: [_1]'
=> 'Generando usario: [_1]',

   'Home server'
=> 'Servidor de Origen (Home)',

   'Home server: [_1]'
=> 'Servidor de Origen (Home): [_1]',

   'Modifying Roles'
=> 'Modificando Funciones',

   'No roles to modify'
=> 'Sin funciones que modificar',

   'starting'
=> 'Empezando',

   'Add to classlist:'
=> 'Añadir a la lista de clase:',

   'Change Current Login Data'
=> 'Cambiar Datos Actuales de entrada a sesión',

   'Enter New Login Data'
=> 'Neue Login-Einstellungen',

   'will override current values'
=> 'se sobreescribirá los valores actuales',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Los números de Sección y los IDs de sección LON-CAPA correspondientes',

   'Overall Assessment Statistical Data'
=> 'Evaluación Global de Datos Estadísticos',

   'No new dynamic data found.'
=> 'No se encontró datos dinámicos nuevos.',

   'Current value is'
=> 'Valor actual es',

   'Interval set to version changes [_1]'
=> 'Intérvalo establecido para el cambio de versiones [_1]',

   'Creating a new problem resource.'
=> 'Creando un nuevo recurso tipo problema',

   'Creating a new library resource.'
=> 'Creando un nuevo recurso tipo biblioteca',

   'Creating a new survey resource.'
=> 'Creando un nuevo recurso tipo encuesta',

   'Creating a new task resource.'
=> 'Creando un nuevo recurso tipo "puente de tareas"',

   'The requested file [_1] currently does not exist.'
=> 'El archivo solicitado [_1] actualmente no existe.',

   'To create a new problem, select a template from the list below. Then click on the "Create problem" button.'
=> 'Para crear un problema nuevo, seleccionar un modelo de la lista de abajo. Luego presione el botón "Crear problema".',

   'To create a new library, select a template from the list below. Then click on the "Create library" button.'
=> 'Para crear una biblioteca nueva, seleccionar un modelo de la lista de abajo. Luego presione el botón "Crear biblioteca".',

   'To create a new survey, select a template from the list below. Then click on the "Create survey" button.'
=> 'Para crear una encuesta nueva, seleccionar un modelo de la lista de abajo. Luego presione el botón "Crear encuesta".',

   'To create a new task, select a template from the list below. Then click on the "Create task" button.'
=> 'Para crear un "puente de tareas" nuevo, seleccionar un modelo de la lista de abajo. Luego presione el botón "Crear puente de tareas".',

   'Accessibility Options'
=> 'Opciones de Accesibilidad',

   'About LON-CAPA'
=> 'Acerca de LON-CAPA',

   'Course/Community Catalog'
=> 'Catálogo de Cursos/Comunidades', # 'Catálogo de Cursos',

   'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:'
=> 'Si está esperando ver una lista de funciones activas para un curso en particular en el dominio [_1], podría estar extraviado por una de las siguientes razones:',

   'The course has yet to be created.'
=> 'El curso aún necesita ser creado.',

   'Automatic enrollment of registered students has not been enabled for the course.'
=> 'La matrícula automatizada de estudiantes registrados no ha sido activada para el curso.',

   'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.'
=> 'Está en una sección del curso para el cual la matrícula automatizada en el curso LON-CAPA correspondiente, no está activa.',

   'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.'
=> 'Usted se matriculó para el curso recientemente y hay un retraso entre el momento que matriculó y el momento que esta información está disponible para actualizar las listas de cursos LON-CAPA.',

   'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.'
=> 'Si está esperando ver una lista de funciones activas para un curso en particular, ese curso pudo no ser creado aún.',

   'The [_1]Course/Community Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created, as well as any communities in the domain.' # [_3]: domain
=> 'El [_1]Catálogo de Cursos/Comunidades[_2] provee información sobre todas las clases en el dominio [_3], para los cuales se crearon cursos LON-CAPA, asi como también cualquier comunidad en el dominio.', # 'El [_1]Catálogo de Cursos[_2] provee información sobre todas las clases en el dominio [_3], para los cuales se crearon cursos LON-CAPA.',

   'You can search the Course/Community Catalog for courses and communities which permit self-enrollment, if you would like to enroll in one.'
=> 'Puede buscar en el Catálogo de Cursos/Comunidades por cursos y comunidades que permiten auto-matricularse, si quisiera matricular en alguno.', # 'Puede buscar en el catalogo de cursos por cursos que permiten auto-matricularse, si quisiera matricular en un curso.',

   'User Authentication'
=> 'Autenticación de Usuario',

   'Log-in Help'
=> 'Asistencia en Entrar',

   'Forgot password?'
=> '¿Olvidó contraseña?',

   'New User?'
=> '¿Usuario Nuevo?',

   'Crosslisted'
=> 'cruzados',

   'Owner'
=> 'Dueño',

   'Code'
=> 'Código',

   'Course listing'
=> 'Listado de cursos',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Mostrar información acerca de clases oficiales [_1] para los cuales cursos LON-CAPA fueron creados:',

   'help/support'
=> 'Asistencia/Apoyo',

   'Log-in help'
=> 'Asistencia en iniciar sesión',

   'Ask helpdesk'
=> 'Preguntar al centro de asistencia',

   'Back to last location'
=> 'Volver a última localización',

   'Note'
=> 'Nota',

   'Student questions about course content should be directed to the course instructor'
=> 'Preguntas de estudiantes sobre el contenido del curso deben ser dirigidos al instructor del curso',

   'Submit Request'
=> 'Enviar Solicitud',

   'E-mail address'
=> 'dirección E-Mail',

   'e-mail address'
=> 'dirección E-Mail',

   'Enter the username you use to log-in to LON-CAPA, and your domain.'
=> 'Entrar el nombre de usario que usa para entrar a LON-CAPA, y su dominio.',

   'URL of page'
=> 'URL de Página',

   'Phone'
=> 'Telefono',

   'Course Details'
=> 'Detalles del Curso',

   'Enter institutional course code'
=> 'Entrar código institucional del curso',

   'Enter course title'
=> 'Entrar título del curso',

   'Section Number'
=> 'Número de Sección',

   'Detailed Description'
=> 'Descripción detallada',

   'Clear Form'
=> 'Reiniciar Formulario',

   'Material presented in clear way'
=> 'El material está presentado de una manera clara',

   'Material covered with sufficient depth'
=> 'El material fue cubierto con suficiente profundidad',

   'Material is helpful'
=> 'El material es útil',

   'Material appears to be correct'
=> 'El material parece ser correcto',

   'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.'
=> 'Esto solo recobrará el recurso. Si quiere recobrar el metadato, necesitará hacerlo separadamente.',

   'is in this state due to author settings.'
=> 'está en este estado debido a la configuración del autor.',

   'User Data for'
=> 'Datos de Usuario para',

   'Enroll Student'
=> 'Matricular Estudiante',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'Si está activo, la nueva función estará disponible cuando el estudiante inicie su sesión en LON-CAPA.',

   'Enroll another student'
=> 'Matricular otro estudiante',

   'Enroll Another Student'
=> 'Matricular otro Estudiante',

   'start date'
=> 'fecha de inicio',

   'end date'
=> 'fecha de finalización',

   'active groups'
=> 'grupos activos',

   'active group(s)'
=> 'grupo(s) activo(s)',

   'View recent activity'
=> 'Ver actividad reciente',

   'View recent activity by this student'
=> 'Ver actividad reciente por este estudiante',

   'Recent activity of [_1]'
=> 'Actividad reciente de [_1]',

   'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.'
=> 'Compilar datos de la actividad del estudiante puede tomar mucho tiempo. Su solicitud continua siendo procesada mientras los resultados son mostrados.',

   'Composing Query'
=> 'Composición de Consulta',

   'Student Activity'
=> 'Actividad de Estudiante',

   'Waiting up to [_1] seconds for results'
=> 'Esperando hasta un máximo de [_1] segundos por los resultados',

   'Activity data compiled up to [_1]'
=> 'Datos de la actividad compilada hasta [_1]',

   'While data is processed, periodically reload this page for more recent activity'
=> 'Mientras los datos son procesados, recargar periódicamente esta página para actividad más reciente.',

   'Data'
=> 'Datos',

   'Resubmit last request to check for newer data'
=> 'Re-enviar último pedido para ver por nuevos datos',

   'View Classlist'
=> 'Ver Lista de Clase',

   'Count'
=> 'Contador',

   'Modifying authentication:'
=> 'Cambiando autenticación:',

   'Modify User Privileges'
=> 'Modificar Privilegios de Usuario',

   'Insert:'
=> 'Insertar:',

   'Delete?'
=> 'Borrar?',

   'Randomize Foil Order:'
=> 'Ordenar al azar Alternativas:',

   'Use template:'
=> 'Usar modelo:',

   'Display Direction'
=> 'Mostrar Dirección',

   'vertical'
=> 'vertical',

   'horizontal'
=> 'horizontal',

   'Script'
=> 'Script',

   'Problem Editing'
=> 'Editando Problema',

   'Hint'
=> 'Sugerencia',

   'Show hint even if problem Correct:'
=> 'Mostrar sugerencia aún si el problema está correcto:',

   'Single Line Text Entry Area'
=> 'Area de Entrada de una línea de texto',

   'Parameters for a response'
=> 'Parámetros para respuesta',

   'Problem Part'
=> 'Parte de Problema',

   'Part:'
=> 'Parte:',

   'Part ID:'
=> 'ID de Parte',

   'Part ID: [_1]'
=> 'ID de Parte: [_1]',

   'Points:'
=> 'Puntos:',

   'Trial not counted'
=> 'Intento no contado',

   'Trial: [_1]'
=> 'Intento: [_1]',

   'Displayed Part Description:'
=> 'Descripción de Partes Mostradas:',

   'Readonly:'
=> 'Solo Lectura:',

   'Response: Numerical'
=> 'Respuesta: Numérica',

   'random'
=> 'al azar',

   'top'
=> 'arriba',

   'bottom'
=> 'abajo',

   'Add new Option:'
=> 'Añadir opción nueva:',

   'Delete an Option:'
=> 'Borrar una opción:',

   'Print options:'
=> 'Opciones de impresión:',

   "Don't show option list"
=> "No muestre lista de opciones",

   'Display of options when printed'
=> 'Mostrar opciones cuando imprima',

   'Normal list'
=> 'Lista Normal',

   'Listed in vertical column'
=> 'Listado en columna vertical',

   'Multiple Option Response Question'
=> 'Pregunta con Opción de Multiples Respuestas',

   'Select Options'
=> 'Selecionar opciones',

   'Image'
=> 'Imagen',

   'Image Url:'
=> 'URL de Imagen:',

   'width (pixel):'
=> 'ancho (pixel):',

   'height (pixel):'
=> 'altura (pixel):',

   'Alignment:'
=> 'Alineamiento:',

   'Encrypt URL:'
=> 'Encriptar URL:',

   'no'
=> 'no',

   'Location:'
=> 'Ubicación:',

   'Randomly labeled image'
=> 'Imagen con etiquetas al azar',

   'Response: Click on Image'
=> 'Respuesta: Pulsar en Imagen',

   'Collection of Imageresponse foils'
=> 'Colección de alternativas de imagen como respuesta',

   'Image response foil'
=> 'alternativas de imagen como respuesta ',

   'Enter Coordinates'
=> 'Entrar Coordenadas',

   'Rectangle'
=> 'Rectángulo',

   'Coordinate Pairs'
=> 'Pares Coordenados',

   'Polygon'
=> 'Polígono',

   'Coordinate list'
=> 'Lista de Coordenadas',

   'Create Polygon Data'
=> 'Crear Datos de Polígono',

   'Task Description'
=> 'Descripción de Tarea',

   'Clickable Image'
=> 'Imagen sencible a clic',

   'Image Source File'
=> 'Archivo fuente de imagen',

   'Select Position on Image'
=> 'Selecionar Posición en Imagen',

   'Select First Coordinate on Image'
=> 'Selecionar primera coordenada en imagen',

   'Select Second Coordinate on Image'
=> 'Seleccionar segunda coordenada en imagen',

   'Select Finish to save selection'
=> 'Seleccionar Terminar para guardar selección',

   'Enter Coordinate or click finish to close Polygon'
=> 'Entrar Coordenadas o pulse terminar para cerrar Polígono',

   'Click to select a Coordinate or click Finish to save current selection'
=> 'Pulsar para seleccionar una Cordenada o pulse Terminar para guardar selección actual',

   'New Name'
=> 'Nombre Nuevo',

   'Make Obsolete'
=> 'Hacerlo obsoleto',

   'Set Margins'
=> 'Establecer Márgenes',

   'How should each column be formatted?'
=> '¿Como quiere el formato de cada columna?',

   'Height'
=> 'Largo',

   'Width:'
=> 'Ancho:',

   'Height:'
=> 'Largo:',

   'Left Margin'
=> 'Margen Izquierdo',

   'Username and/or password could not be authenticated.'
=> 'Usuario y/o contraseña no pudo ser autenticada.',

   'Please check the username and password.'
=> 'Por favor revise su usuario y contraseña.',

   'Try again'
=> 'Trate otra vez',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> 'La información necesaria para verificar su información de sesión está, extraviada, inaccesible o expirada.',

   'Sending'
=> 'Enviando',

   'Completed.'
=> 'Completado.',

   'Messages being sent.'
=> 'Mensajes están siendo enviados',

   'Assigning'
=> 'Asignando',

   'ending'
=> 'terminando',

   'Assistant Co-Author'
=> 'Asistente de Co-Autor',

   'Metadata for [_1]'
=> 'Metadatos para [_1]',

   'There are [_1] matches to your query.'
=> 'Hay [_1] coincidencias de su búsqueda.',

   'There were no results matching your query.'
=> 'No hubo resultados de coincidencia para su búsqueda.',

   'Revise search'
=> 'Revisar busqueda',

   'Internal Error - Bad view selected.'
=> 'Error interno - selecciono vista inválida',

   'Unable to save import results.'
=> 'No se pudo guardar resultados importados',

   'A MySQL error has occurred.'
=> 'A ocurrido un error MySQL.',

   'Number of accesses'
=> 'Número de accesos',

   'Ascending'
=> 'Ascendente',

   'Descending'
=> 'Desendente',

   'Students Attempting'
=> 'Cuantos Estudiantes Intentaron',

   'Average Number of Tries'
=> 'Número Promedio de intentos',

   'Mean Degree of Difficulty'
=> 'Media Grado del Dificultad',

   'Mean Degree of Discrimination'
=> 'Media Grado de Discriminación',

   'Evaluation: Clear'
=> 'Evaluación: Clara',

   'Evaluation: Technically Correct'
=> 'Evaluación: Técnicamente Corr.',

   'Evaluation: Material is Correct'
=> 'Evaluación: Mat. está Correcto',

   'Evaluation: Material is Helpful'
=> 'Evaluación: Material es Útil',

   'Evaluation: Material has Depth'
=> 'Evaluación: tiene Profundidad',

   'Prev'
=> 'Atrás',

   'Reload'
=> 'Actual', # need short word to keep format

   'Results [_1] to [_2] out of [_3]'
=> 'Resultados [_1] al [_2] de [_3]',

   'Unactionable Search Query'
=> 'Busqueda fallida',

   'Revise Search Request'
=> 'Revise su patrones de busqueda',

   'LON-CAPA Access Control'
=> 'Control de Acceso LON-CAPA',

   'Access  : '
=> 'Acceso  : ',

   'Resource: '
=> 'Recurso: ',

   'Action  : '
=> 'Acción   : ',

   'You have modified your course recently, [_1] may fix this access problem.'
=> 'Usted modificó su curso recientemente, [_1] puede arreglar este problema acceso.',

   'Published on ...'
=> 'Publicado en ...',

   'Currently published version'
=> 'Actualmente versión publicada',

   'Cleanup XML Document'
=> 'Limpiar Documento XML',

   'Select actions to attempt'
=> 'Selecionar acciones a intentar',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Saltos de Línea (LF), Saltos de forma y caracter de control (CR)',

   'Empty tags'
=> 'Etiquetas vacías',

   'Lower casing'
=> 'A minúsculas',

   'Symbol font'
=> 'Caracteres para Símbolos',

   'Back to Source File'
=> 'Volver al Archivo Fuente',

   'Original file'
=> 'Archivo Original',

   'Cleaned up file'
=> 'Archivo depurado',

   'Open (and edit) cleaned up file in new window'
=> 'Abrir (y editar) archivo depurado en ventana nueva',

   'Show diffs in new window'
=> 'Mostrar diferencias en nueva ventana',

   'Accepting changes'
=> 'Aceptando cambios',

   'Rejecting changes'
=> 'Rechazando cambios',

   'Hypertext Cascading Style Sheet'
=> 'Archivo Hipertexto CSS',

   'Online Survey'
=> 'Encuesta en Línea',

   'Unable to find [_1]'
=> 'No se pudo encontrar [_1] ',

   'Post Server Announcements'
=> 'Enviar Anuncios de Servicio',

   'Post announcements to the system login and roles screen'
=> 'Enviar anuncios al sistema de inicio de sesión y pantalla de funciones',

   '(leave blank to delete announcement)'
=> '(dejar en blanco para borrar anuncio)',

   'Check machines:'
=> 'Selecionar servidor:',

   'Current Announcement'
=> 'Anuncio Actual',

   'Calendar'
=> 'Calendario',

   'Download your Calendar as iCalendar File'
=> 'Descargar Calendario como archivo iCalendar',

   'No calendar available for this date.'
=> 'No hay calendario disponible para esta fecha',

   'Posting [_1]'
=> 'Enviando [_1]',

   'This LON-CAPA server is version [_1]'
=> 'Este servidor LON-CAPA es versión [_1]',

   'Only changes made from servers running LON-CAPA [_1] or later are displayed.'
=> 'Sólo cambios hechos desde servidores corriendo LON-CAPA [_1] o más recientes son mostrados.',

   'Edit Answer'
=> 'Editar Respuesta',

   'Date/Time'
=> 'Fecha/Hora',

   'Threshold Name'
=> 'Nombre de Umbral',

   'Current value'
=> 'Valor Actual',

   'Change?'
=> '¿Cambiar?',

   'Change thresholds'
=> 'Cambiar umbrales',

   'Picture Conversion Status'
=> 'Estado de la Conversión de Figura',

   'Removing error messages:'
=> 'Borrando mensajes de error:',

   'Invalid target directory, FAIL'
=> 'Directorio de destino Inválido, FALLÓ',

   'Creating old version [_1]'
=> 'Creando versión anterior [_1]',

   'Initial version'
=> 'Versión inicial',

   'Press "Generate Statistics" when you are ready.'
=> 'Presione "Generar Estadística", cuando esté listo.',

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'Puede tomar algun tiempo actualizar los datos del estudiante para el primer análisis. En futuros análisis esta sesión no tendrá este retraso.',

   'A course-wide error occurred.'
=> 'Ocurrió un error a nivel del curso',

   'none'
=> 'ninguno',

   'Prepare Report'
=> 'Preparar Reporte',

   'Show problem'
=> 'Mostrar problema',

   'Show correct answers'
=> 'Mostrar respuestas correctas',

   'Show all submissions'
=> 'Mostrar todos los envíos de respuesta',

   'Show problem grading'
=> 'Mostrar calificación del problema',

   'Computing correct answers greatly increases the amount of time required to prepare a report.'
=> 'Calcular respuestas correctas aumenta grandemente el tiempo requerido para preparar un reporte.',

   'Please select problems and use the [_1]Prepare Report[_2] button to continue.'
=> 'Por favor seleccione problemas y use el botón [_1]Preparar Reporte[_2] para continuar.',

   'Please select a Survey to analyze'
=> 'Por favor seleccione la Encuesta a analizar ',

   'There are no survey problems in this course.'
=> 'No hay problemas de encuesta en este curso.',

   'Generate Survey Report'
=> 'Generar Reporte de Encuesta',

   'Building text document.'
=> 'Generando documento de texto.',

   'Generated on [_1]'
=> 'Generado en [_1]',

   'Your text file'
=> 'Su archivo texto',

   'Done compiling text file. See link below to download.'
=> 'Hecho, archivo texto compilado. Ver enlace abajo para descargar.',

   'There is no essay or string response data to output for this survey.'
=> 'No hay ensayo o datos de respuesta concatenada que analizar para esta encuesta.',

   'Building spreadsheet.'
=> 'Construyendo hoja de cálculo.',

   '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.'
=> '[_1]:[_2] respuestas a [_3] podrían ser muy largas para encajar en una hoja de cálculo Excel.',

   'Done compiling spreadsheet. See link below to download.'
=> 'Hecho, hoja de cálculo compilada. Ver enlace abajo para descargar.',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Haga una selección del menú de "Secuencias y Carpetas" y presione el botón "Crear Gráfica" para empezar.',

   'Create Plot'
=> 'Crear Gráfica',

   'Start Time:'
=> 'Tiempo de Inicio:',

   'End Time:'
=> 'Tiempo de Finalización:',

   'Sender'
=> 'Remitente',

   'Number'
=> 'Número',

   'Upload Classlist'
=> 'Cargar Lista de Clase',

   'Semicolon separated values'
=> 'valores separados por punto y coma',

   'Show Log'
=> 'Mostar Bitácora',

   'Course Document Change Log'
=> 'Bitácora de Cambios en Documentos del Curso',

   'Records'
=> 'Registros',

   'Before'
=> 'Antes',

   'After'
=> 'Después',

   'Current folder/page'
=> 'Carpeta/Página actual',

   'Containing phrase'
=> 'Frases que contienen',

   'None'
=> 'Ninguna',

   'Users'
=> 'Usuarios',

   'Include parameter types'
=> 'Incluir tipos de parámetros',

   'Parameter Change Log'
=> 'Bitácora de Cambios en Parámetros',

   'Announce'
=> 'Anuncio',

   'Not active anymore'
=> 'Nunca más activo',

   'Add to Course Announcements'
=> 'Añadir a los Anuncios del Curso',

   'Username : Domain'
=> 'Usuario : Dominio',

   'Active'
=> 'Activo',

   'Expired'
=> 'Expiró',

   'Future'
=> 'Futuro',

   'Sort by realm first, then student (group/section)'
=> 'Organizar primero por Zonas, luego estudiante (grupo/sección)',

   'Sort by student (group/section) first, then realm'
=> 'Organizar primero por estudiante (grupo/sección), luego por Zonas',

   'Shift all dates based on this date'
=> 'Correr todas las fechas basadas en esta fecha',

   'Overview Mode'
=> 'Modo Panorámico',

   'Overview'
=> 'Panorama',

   'Set Parameters'
=> 'Establecer Parámetros',

   'Parts'
=> 'Partes',

   'Section(s)'
=> 'Seccion(es)',

   'Group(s)'
=> 'Grupo(s)',

   'Parameter Selection'
=> 'Selección de Parámetros',

   'Add Selection for...'
=> 'Añadir Selección para...',

   'Select Common Only'
=> 'Seleccionar Solo Comunes',

   'Problem Dates'
=> 'Fecha a Problemas',

   'Content Dates'
=> 'Fecha a Contenido',

   'Discussion Settings'
=> 'Configuración de Discusión',

   'Visibilities'
=> 'Visibilidad',

   'Part Parameters'
=> 'Parámetros a Partes',

   'For User [_1] or Student/Employee ID [_2] at Domain [_3]'
=> 'Para Usuario [_1] o ID de Estudiante/Empleado [_2] en el Dominio [_3]',

   'Group Portfolio'
=> 'Portafolio Grupal',

   "Enter user:domain for User's Personal Information Page"
=> "Entrar usuario:dominio para las página de información personal del Usuario",

   'No map selected.'
=> 'Sin mapa selecionado.',

   'Most Recent:'
=> 'Mas Reciente:',

   'In Course:'
=> 'En el Curso:',

   'Use:'
=> 'Usar:',

   'Search LON-CAPA help'
=> 'Buscar en ayuda LON-CAPA',

   'Before course enrollment start!'
=> 'Antes de empezar matrícula del curso!',

   'After course enrollment end!'
=> 'Después de terminar matrícula del curso!',

   'in the past'
=> 'en el pasado',

   'in the future'
=> 'en el futuro',

   'Choose'
=> 'Elija',

   'Title:'
=> 'Título:',

   'URL:'
=> 'URL:',

   'Course, Portfolio and Catalog Search'
=> 'Buscar en Curso, Portafolio y Catálogo',

   'ERROR:'
=> 'ERROR:',

   'occurred while running'
=> 'ocurrió mientras corría',

   '(click for example)'
=> '(pulsar para ejemplo)',

   'click for example'
=> 'pulsar para ejemplo',

   'Re-Enable'
=> 'Re-activar',

   'Script Functions'
=> 'Funciones de Script',

   'Image Options'
=> 'Opciones de Imagen',

   'left'
=> 'izquierda',

   'right'
=> 'derecha',

   'middle'
=> 'medio',

   'TeXwidth (mm):'
=> 'TeX-ancho (mm):',

   'TeXheight (mm):'
=> 'TeX-altura (mm):',

   'TeXwrap:'
=> 'TeX-envoltura',

   'Sorry!'
=> 'Lo siento!',

   'Resource not available.'
=> 'Recurso no disponible.',

   'File Type'
=> 'Tipo de archivo',

   'Decompress [_1]?'
=> '¿QDescomprimir [_1]?',

   'Output of decompress:'
=> 'Producto de descompresión:',

   'Decompress complete.'
=> 'Descompresión completa.',

   'Archive:'
=> 'Archivar:',

   'inflating:'
=> 'inflando:',

   'Incorrect:'
=> 'Incorrecto:',

   'Correct:'
=> 'Correcto:',

   'Correct'
=> 'Correcto',

   'Pick course first'
=> 'Escoja curso primero',

   'User Information Changed'
=> 'Cambió Informacion de Usario',

   'Previous Value:'
=> 'Valor Anterior:',

   'Changed To:'
=> 'Cambió a:',

   'disk space allocated to portfolio files'
=> 'espacio de disco asignado a archivos de portafolio',

   'You have new messages'
=> 'Tiene mensajes nuevos',

   'Destination folder'
=> 'Carpeta de Destino',

   'Mark Read'
=> 'Marcar Leído',

   'Move to Folder ->'
=> 'Mover a Carpeta ->',

   'Register Response Devices (&quot;Clickers&quot;)'
=> 'Registrar Aparatos de Respuesta (&quot;Clicker&quot;)',

   'Enter response device ("clicker") numbers'
=> 'Entrar números del aparato de respuesta ("Clicker")',

   'Locating your clicker ID'
=> 'Localizando el ID de su clicker',

   'Register Clicker'
=> 'Registrar Clicker',

   'Register'
=> 'Registrar',

   'New Link'
=> 'Nuevo Enlace Web',

   'Refresh'
=> 'Actualizar',

   'Custom metadata [_1]'
=> 'Personalizar metadatos [_1]',

   'Question/Comment/Feedback about course content'
=> 'Pregunta/Comentario/Reacción sobre el contenido del curso',

   'User modify/custom role edit'
=> 'editar función de Usuario para modificar/personalizar',

   'User Search'
=> 'Buscar Usuario',

   'to add/modify roles'
=> 'para añadir/modificar función',

   'is'
=> 'está',

   'contains'
=> 'contiene',

   'in this domain'
=> 'en este dominio',

   'in institutional directory'
=> 'en directorio institucional',

   'Domain/institution to search'
=> 'dominio/institución a buscar',

   'Directory search has not been configured for domain: [_1]'
=> 'Busqueda de directorio no ha sido configurado para dominio: [_1]',

   'permanent e-mail'
=> 'E-mail permanente',

   'Set user role'
=> 'Establecer función de usuario',

   'No exact match found for this username ([_1]) in this domain.'
=> 'No hay coincidencias exactas para este usuario [_1] en este dominio.',

   'No match found for this username ([_1]) in this domain.'
=> 'No se encontró coincidencias para este usuario [_1] en este dominio.',

   'Make new user "[_1]"'
=> 'Crear nuevo usario "[_1]"',

   'Course Editor'
=> 'Editar Curso',

   'Community Editor'
=> 'Editar Comunidad',

   'Choose which items you wish to export from your Course.'
=> 'Escoja que elementos desea exportar de su Curso.',

   'Content items'
=> 'Elementos de Contenido',

   'Discussion posts'
=> 'Mensajes de Discusión',

   'Download the zip file from'
=> 'Descargar el archivo zip de',

   'IMS course archive'
=> 'Archivo de curso IMS',

   'last name, first name'
=> 'Apellidos, Nombre',

   'Select a Template'
=> 'Seleccionar un Modelo',

   'Edit custom role'
=> 'Editar función de usuario personalizada',

   'Privilege'
=> 'Privilegio',

   'Showing users with a name starting with [_1]'
=> 'Mostrando usuarios con nombres que empiezan con [_1]',

   'Permanent e-mail address'
=> 'Dirección de E-mail permanente',

   'User [_1] in domain [_2]'
=> 'Usuario [_1] en dominio [_2]',

   'Result'
=> 'Resultado',

   'Directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Busqueda de directorio en dominio [_1] no está disponible para el tipo de busqueda solicitado: "[_2]"',

   "No match found for this username ([_1]) in your institution's directory."
=> "No se encontró coincidencias para este usuario ([_1]) en el directorio de su institución.",

   'Setting'
=> 'Configurando',

   'Directory search available?'
=> 'Busqueda de directorio disponible?',

   'Back to actions menu'
=> 'Volver al menú de acciones',

   'Edit action'
=> 'Editar acción',

   'Effect'
=> 'Efecto',

   'Course / User'
=> 'Curso / Usuario',

   'deny'
=> 'denegar',

   'allow'
=> 'permitir',

   'Delete this rule'
=> 'Borrar esta regla',

   'Insert rule above'
=> 'Insertar regla arriba',

   'Insert rule below'
=> 'Insertar regla abajo',

   'Move rule down'
=> 'Mover regla hacia abajo',

   'Move rule up'
=> 'Mover Regla hacia arriba',

   'Warning: It can take up to 1 hour for rights changes to fully propagate.'
=> 'Advertencia: Puede tomar hasta una hora para que los cambios a los derechos se propagen.',

   'Updated'
=> 'Actualizado',

   'The error occurred on host  [_1]'
=> 'El error se produjo en nodo [_1]',

   'This error occurred on machine [_1]'
=> 'Este error se produjo en la máquina [_1]',

   'Clear all Messages in Subdirectory'
=> 'Limpiar todos los mensajes en Subdirectorio',

   'Task information'
=> 'Información',

   'Automated adds/drops'
=> 'Adiciones/Exclusiones Automatizadas',

   'Change enrollment dates'
=> 'Cambiar fechas de matrícula',

   'Change access dates'
=> 'Cambiar fechas de acceso',

   'Notification of changes'
=> 'Notificación de cambios',

   'Change crosslistings'
=> 'Cambiar listas-cruzadas',

   'Section settings'
=> 'Configuración de Sección',

   'Student photo settings'
=> 'Configuración de Foto de Estudiantes',

   'Update roster now'
=> 'Actualizar lista de estudiantes ahora',

   'Update student photos'
=> 'Actualizar fotos de estudiantes',

   'View students and change type'
=> 'Ver estudiantes y cambiar tipo',

   'Changes to nightly automated enrollments'
=> 'Cambiar a matrícula automatizada nocturna',

   'Currently: Nightly adds: [_1], Nightly drops: [_2]'
=> 'Actualmente: addiciones nocturnas: [_1], exclusiones nocturnas: [_2]',

   'OFF'
=> 'APAGAR',

   'ON'
=> 'PRENDER',

   'Additions based on classlist changes:'
=> 'Adiciones basadas en cambios de la lista de clases:',

   'Removals based on classlist changes:'
=> 'Exclusiones basadas en cambios de la lista de clases:',

   'Enable'
=> 'Activar',

   'Disable'
=> 'Desactivae',

   'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.'
=> 'Nota: Cualquier estudiante añadido manualmente por el coordinador del curso usando el Control de Matrícula no será afectado por el proceso de exclusión nocturna en caso de estar activado.',

   'Changes to first and/or last automated enrollment dates'
=> 'Cambios a las fechas del primer y/o último día de matrícula automatizada',

   'Currently: First enrollment: [_1], Last enrollment: [_2]'
=> 'Actualmente: Iniciar Inscripciones: [_1], Terminar Inscripciones: [_2]',

   'Set date of first automated enrollment for registered students'
=> 'Establecer fecha de inicio de inscripción para estudiantes registrados',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools'
=> 'Si las adiciones y/o exclusiones automatizadas estan activadas, entonces su lista de clase será automráticamente actualizada cada noche, una vez la fecha de inicio de inscripciones sea alcanzada. Antes de esa fecha, la lista de clases solo tendrá estudiantes añadidos directamente usando las herramientas regulares de matrícula de LON-CAPA.',

   'Set date of last automated enrollment for registered students'
=> 'Establecer fecha de finalización de inscripción para estudiantes registrados',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.'
=> 'Si las adiciones y/o exclusiones automatizadas estan activadas, entonces su lista de clase será automráticamente actualizada cada noche, hasta alcanzar la fecha de término de inscripciones.',

   'Changes to default start and/or end dates for student access'
=> 'Cambios a las fechas preestablecidas de inicio y/o fin para acceso de estudiantes',

   'Currently: default first access:'
=> 'Actualmente: primer acceso preestablecido:',

   ', default last access:'
=> ', último acceso preestablecido:',

   'Set date of first access for registered students added via automated enrollment'
=> 'Establecer fecha del primer acceso para estudiantes registrados añadidos mediante inscripciones automatizadas',

   'Set date of last access for registered students added via automated enrollment'
=> 'Establecer fecha del último acceso para estudiantes registrados añadidos mediante inscripciones automatizadas',

   'Changes to section settings'
=> 'Cambios a la configuración de sección',

   'Currently no sections of'
=> 'Actualmente no hay secciones del curso',

   'are contributing enrollment to the LON-CAPA class roster.'
=> 'estan contribuyendo a inscripciones de la lista de clase LON-CAPA.',

   'Add enrollment from additional sections.'
=> 'Añadir inscripciones de secciones adicionales.',

   'Number of new sections to add:'
=> 'Número de secciones nuevas a añadir:',

   'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course'
=> 'Los estudiantes registrados en las secciones mostradas debajo serán añadidos a la lista de clases del curso LON-CAPA',

   'if you have chosen to enable a nightly automated enrollment update.'
=> 'si eligió activar el registro automatizado de actualización nocturna.',

   'Nightly additions based on classlist changes now'
=> 'Adiciones nocturnas basados en cambios en la lista de clase ahora',

   'Nightly additions based on classlist changes still'
=> 'Adiciones nocturnas basados en cambios en la lista de clase en proceso',

   'Nightly removals based on classlist changes now'
=> 'Remociones nocturnas basados en cambios en la lista de clase ahora',

   'Nightly removals based on classlist changes still'
=> 'Remociones nocturnas basados en cambios en la lista de clase en proceso',

   'enabled'
=> 'activado',

   'disabled'
=> 'desactivado',

   'The first date for automated enrollment has been changed'
=> 'Primer día para registro automatizado a cambiado',

   'The last date for automated enrollment has been changed'
=> 'Último día para registro automatizado a cambiado',

   'The first date for automated enrollment has been left unchanged as'
=> 'Primer día para registro automatizado a sido dejado sin cambio',

   'The last date for automated enrollment has been left unchanged as'
=> 'Último día para registro automatizado a sido dejado sin cambio',

   'Currently: Notification:'
=> 'Actualmente:Notificación:',

   'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?'
=> 'Notificación de cambios en la lista de clase como resultado del proceso de registro automatizado nocturno?',

   'The table below contains a list of Kurs-Koordinators in this course.'
=> 'La tabla mostrada contiene la lista de "Coordinadores de Curso" en este curso',

   'username:domain'
=> 'usuario:dominio',

   'Course Access'
=> 'Acceso al Curso',

   'Current notification status'
=> 'Estado actual de notificación',

   'Notification active'
=> 'Notificación activada',

   'Notification inactive'
=> 'Notificación desactivada',

   'Notification?'
=> '¿Notificación?',

   "The table below contains a list of Domänen-Koordinators from this course's domain who are not also Kurs-Koordinators."
=> "La tabla mostrada contiene una lista de Coordinadores de Dominio del dominio de este curso que no son Coordinadores del Curso.",

   'Notification of enrollment changes now'
=> 'Notificación de cambios de inscripción ahora',

   'Notification of enrollment changes still'
=> 'Notificación de cambios de inscripción todavía',

   'The following will receive notification if there are any changes in enrollment in LON-CAPA course:'
=> 'Los siguientes usuarios recibirán notificación si hay cambios en la inscripción del curso LON-CAPA',

   'as a result of the nightly enrollment check:'
=> 'como resultado de revisar la inscripción nocturna:',

   'View/Modify Course Settings'
=> 'Ver/Modificar Parámetros del Curso',

   'Course search'
=> 'Buscar en curso',

   'View/Modify Courses'
=> 'Ver/Modificar Cursos',

   'Course details'
=> 'Detalles del curso',

   'Detailed course information:'
=> 'Información detallada del curso:',

   'Default Access Dates for Students'
=> 'Fechas de Acceso para Estudiantes Predefinidas',

   'Student Counts'
=> 'Número de Estudiantes',

   'Auto-enrollment of[_1]registered students'
=> 'Auto-inscripciones de[_1]estudiantes registrados',

   'Details'
=> 'Detalles',

   'Not enabled'
=> 'No activado',

   'section:'
=> 'sección:',

   'Previous access'
=> 'Acceso Previo',

   'Current access'
=> 'Acceso Actual',

   'Future access'
=> 'Acceso Futuro',

   'Back to course listing'
=> 'Volver al listado de curso',

   'Immediate course roster update'
=> 'Actualizar inmediatamente lista de clase',

   'There were no new students to add to the course.'
=> 'No hubo estudiantes nuevos para añadir al curso.',

   'Back to options page'
=> 'Volver al menú de opciones',

   'View/Modify settings for: '
=> 'Ver/Modificar configuración para:',

   'Modify quota for group portfolio'
=> 'Modificar cuota para portafolio grupal',

   'Display current settings for automated enrollment'
=> 'Mostrar configuración actual de inscripción automatizada',

   'Modify institutional code, course owner and/or default authentication'
=> 'Modificar código institucional, dueño del curso y/o autenticación predefinida',

   'Modify course catalog settings for course'
=> 'Modificar configuración del catálogo de cursos para el curso',

   'Catalog settings'
=> 'Configuración del Catálogo',

   'Catalog Settings for Course'
=> 'Configuración del Catálogo para Curso',

   'Visibility in Course/Community Catalog'
=> 'Visibilidad en Catálogo de Cursos/Comunidades',

   "Unless excluded, a course/community is listed in this domain's publicly accessible Course/Community Catalog, if at least one of the following applies:"
=> "A menos que esté excluído, un curso o comunidad es listado en este Catálogo de Cursos/Comunidades con dominio de acceso público, si al menos uno de los siguiente aplica:", # "A menos que esté excluído, un curso es listado en este catálogo de curso de dominio públicamente accesible,  si al menos uno de los siguiente aplica:",

   'Auto-cataloging is enabled and the course is assigned an institutional code'
=> 'Auto-catalogar está activado y el curso es asignado un código institucional',

   'The course has been categorized into at least one of the course categories defined for the domain.'
=> 'El curso ha sido categorizado en al menos una de las categorias de curso definida para el dominio.',

   'Exclude from course catalog'
=> 'Excluir del catalogo del curso',

   'Categorize Course'
=> 'Categorizar Curso',

   'No categories defined for this domain'
=> 'No hay categorias definidas para este dominio',

   'Assign one or more categories to this course.'
=> 'Asignar una o más categorias a este curso.',

   'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).'
=> 'Si auto-catalogamiento basado en código institucional está activado en el dominio, un curso continuará listado en el catálogo de cursos oficiales, en adición a recibir cualquier categoria(s) manualmente asignada.',

   'Category settings'
=> 'Configuración de Categorias',

   'Show/Hide a course in the catalog'
=> 'Mostrar/Ocultar un curso en el catálogo',

   'Assign a category to a course'
=> 'Asignar una categoria al curso',

   'Set in "Modify Course" (Domain)'
=> 'Establecer en "Modificar Curso" (Dominio)',

   'Set in "Modify Parameters" (Course)'
=> 'Establecer en "Modificar Parámetros" (Curso)',

   'Categories'
=> 'Categorias',

   'Add category'
=> 'Añadir categoria',

   'Add category:'
=> 'Añadir categoria:',

   'Add subcategory:'
=> 'Añadir subcategoria:',

   'New:'
=> 'Nuevo:',

   'Choose a course'
=> 'Escoger un curso',

   'Pick action'
=> 'Escoger acción',

   'Display settings'
=> 'Visualizar configuración',

   'Course settings that control automated enrollment in this LON-CAPA course are currently:'
=> 'Parámetros del Curso que controlan inscripción automatizada de este curso LON-CAPA actualmente son:',

   'Course setting'
=> 'Parámetros del Curso',

   'Modifiable by DC only'
=> 'Modificable sólo por Coor. Dom.',

   'Default authentication parameter'
=> 'Parámetro de autenticación predeterminado',

   'Default authentication method'
=> 'Método de autentificación predeterminado',

   'Date of last automated enrollment'
=> 'Último día de inscripción automatizada',

   'Date of first automated enrollment'
=> 'Primer día de inscripción automatizada',

   'Official course code'
=> 'Código oficial del curso',

   'Username:domain of course owner'
=> 'Usuario:dominio del dueño del curso',

   'Date of last student access'
=> 'Último día de acceso de estudiantes',

   'Date of first student access'
=> 'Primer día de acceso de estudiantes',

   'Course section number(:LON-CAPA section)'
=> 'Número de sección del curso(:Sección LON-CAPA)',

   'Show more details'
=> 'más detalles',

   'Public RSS/podcast (subscribe to):'
=> 'RSS-Feed/Podcast público (suscribirse a):',

   'Course Owner:'
=> 'Dueño del Curso:',

   'Default Authentication method'
=> 'Método de Autenticación predeterminado',

   'Automated Enrollment'
=> 'Inscripción Automatizada',

   'Use the menu on the left to choose an enrollment management task.'
=> 'Usar el menú de la izquierda para elegir una tarea de inscripción',

   'Result of Changes to Automated Enrollment Settings.'
=> 'Resultado de Cambios a la configuración de Inscripción Automatizada',

   'The following automated enrollment parameters have been changed:'
=> 'Los siguientes parámetros de Inscripción Automatizada fueron cambiados:',

   'now set to'
=> 'es ahora',

   'still set to'
=> 'sigue siendo',

   'The following automated enrollment parameters remain unchanged:'
=> 'Los siguientes parámetros de Inscripción Automatizada permanecen sin cambiar:',

   'Change settings'
=> 'Cambiar configuración',

   "Student's agreement needed for listing in student-viewable roster"
=> "Consentimiento de estudiante es necesario para incluirlo en la lista visible de clase",

   'Include link to accessible portfolio files'
=> 'Incluir enlace-web a los archivos de portafolio accesibles',

   'Print header format'
=> 'Formato de cabezera de impresión',

   'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.'
=> 'Sustituciones:<br />[_1]: Nombre de Estudiante, [_2]: Id del curso, [_3]: Nota Asignada. Números después de <tt>%</tt> limitan el tamaño del campo.',

   'Force all students in the course to use a specific math rendering engine.'
=> 'Forzar a todos los estudiantes del curso a usar una herramienta específica de renderizado de ecuaciones.',

   "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference"
=> "[_1], [_2] (Convertir a Imágenes), [_3] (TeX a HTML) o blanco para preferencia de estudiantes",

   'Bridge Task Grading'
=> 'Calificación de "Bridge Tasks"',

   'Classlist Manager'
=> 'Organizar Lista de clase', # !?!

   'Note for students:'
=> 'Nota a estudiantes:',

   'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.'
=> 'Si está oficialmente registrado en el curso pero el curso no está listado en sus cursos LON-CAPA, pulse en el enlace "más detalles" del curso específico y revise las fechas de acceso predeterminadas y/o la configuración de inscripción automatizada.',

   'Please [_1]log in again[_2].'
=> 'Por favor [_1]ingresar de nuevo[_2].',

   'Switching Server ...'
=> 'Intercambiando Servidor...',

   'Already logged in'
=> 'Ya ingresó',

   'Apply style file: '
=> 'Usar Archivo de Estilo: ',

   'The problem '
=> 'El problema ',

   'Search criteria'
=> 'Criterio de búsqueda',

   'begins with'
=> 'empieza con',

   'in selected LON-CAPA domain'
=> 'en dominio seleccionado LON-CAPA',

   'in institutional directory for selected domain'
=> 'en directorio institucional para dominio seleccionado',

   'No exact match found for the username ([_1]) in LON-CAPA domain: [_2]'
=> 'No se encontró concordancia exacta para el usuario "[_1]" en dominio LON-CAPA: [_2]',

   'Creating new account.'
=> 'Creando cuenta nueva.',

   'Report a documentation bug'
=> 'Reportar errores en documentación (Inglés)',

   'You must specify a valid username. Only the following are allowed: letters numbers - . @'
=> 'Debe especificar un usuario válido. Sólo se permiten los siguentes: letras, números, "-", "." y "@"',

   'The following need to be corrected before the search can be run:'
=> 'Lo siguiente necesita ser corregido antes the hacer la búsqueda:',

   'You must include some text to search for.'
=> 'Debe incluir algún texto para buscar.',

   "The text you are searching for must contain at least two characters when using a 'begins' type search."
=> "El texto que está buscando debe contener al menos dos caracteres cuando usa el tipo de búsqueda 'empieza con'.",

   "The text you are searching for must contain at least three characters when using a 'contains' type search."
=> "El texto que está buscando debe contener al menos tres caracteres cuando usa el tipo de búsqueda 'contiene'.",

   'You must choose a domain when using an institutional directory search.'
=> 'Debe elegir un dominio cuando hace una búsqueda en directorio institucional.',

   'You must choose a domain when using a domain search.'
=> 'Debe elegir un dominio cuando hace una búsqueda en dominio.',

   "When using searching by last,first you must include a comma as separator between last name and first name."
=> "Cuando hace búsqueda por Apellidos,Nombre debe incluir una coma como separador entre Apellidos y Nombre.",

   "When searching by last,first you must include at least one character in the first name."
=> "Cuando hace búsqueda por Apellidos,Nombre debe incluir al menos un caracter en el Nombre.",

   'Revoking [_1] in [_2]: [_3]'
=> 'Revocando [_1] en [_2]: [_3]',

   'Revoking custom role:'
=> 'Revocando función personalizada:',

   'Deleting [_1] in [_2]: [_3]'
=> 'Borrando [_1] en [_2]: [_3]',

   'Deleting custom role [_1] by [_2] in [_3]'
=> 'Borrando función personalizada [_1] por [_2] en [_3]',

   'Add to classlist'
=> 'Añadir a lista de clase',

   'Re-enabling [_1] in [_2]: [_3]'
=> 'Re-activando  [_1] en [_2]: [_3]',

   'Re-enabling custom role [_1] by [_2]:[_3] in [_4] : [_5]'
=> 'Re-activando función personalizada [_1] por [_2]:[_3] en [_4] : [_5]',

   'Unknown command'
=> 'Comando Desconocido',

   '[_1] may not be used as the name for a section, as it is a reserved word.'
=> '[_1] podría no ser usado como nombre para una sección, pues es una palabra reservada.',

   '[_1] may not be used as the name for a section, as it is the name of a course group.'
=> '[_1] podría no ser usado como nombre para una sección, pues es el nombre de un grupo del curso.',

   'Please [_1]go back[_2] and choose a different section name.'
=> 'Por favor [_1]volver[_2] y escoja un nombre de sección diferente.',

   'Drop from classlist: [_1]'
=> 'Excluir de la lista de clase: [_1]',

   'Existing Role'
=> 'Función existente',

   'Assigning Role to Self'
=> 'Asignando función a uno mismo', # ???

   'Invalid search.'
=> 'Búsqueda inválida.',

   'You must enter a search term.'
=> 'Debe entrar un término de búsqueda.',

   'You must specify a valid domain when searching in a domain or institutional directory.'
=> 'Debe especificar un dominio válido cuando busca en un dominio o directorio institucional.',

   'You may want to search in the LON-CAPA domain instead of the institutional directory.'
=> 'Tal vez quiera buscar en el dominio LON-CAPA en lugar del directorio institucional.',

   'New users can only be created in the domain to which your current role belongs - [_1].'
=> 'Usuarios nuevos pueden ser creados en el dominio que pertenece su función de usuario, - [_1].',

   'Institutional directory search is not available in domain: [_1]'
=> 'Búsqueda de directorio institucional no está disponible en dominio: [_1]',

   'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.'
=> 'Búsqueda de directorio institucional en domino: [_1] está disponible sólo a usuarios con función actual en el dominio.',

   'Institutional directory search in domain: [_1] is not available to your user type: '
=> 'Búsqueda de directorio institucional en domino: [_1] no está disponible para su tipo de usuario: ',

   'Institutional directory search has not been configured for domain: [_1]'
=> 'Búsqueda de directorio institucional no fue configurado para su dominio: [_1]',

   'Institutional directory search in domain: [_1] is not available for searching by "[_2]"'
=> 'Búsqueda de directorio institucional en domino: [_1] no está disponible para búsqueda por "[_2]"',

   'Institutional directory search in domain: [_1] is not available.'
=> 'Búsqueda de directorio institucional en domino: [_1] no está disponible.',

   'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Búsqueda de directorio institucional en domino [_1] no está disponible para el tipo de búsqueda solicitado "[_2]"',

   'You may want to broaden your search to a search of the institutional directory for the domain.'
=> 'Tal vez quiera ampliar su búsqueda a una búsqueda de directorio institucional para el dominio.',

   'You may want to broaden your search to the selected LON-CAPA domain.'
=> 'Tal vez quiera ampliar su búsqueda al dominio seleccionado LON-CAPA.',

   'Pick group first'
=> 'Primero elegir grupo',

   'No login name specified'
=> 'Nombre de usuario no especificado',

   'Invalid login name.'
=> 'Nombre de usuario inválido.',

   'Only letters, numbers, periods, dashes, @, and underscores are valid.'
=> 'Solo letras, números, puntos, guiones, "@", y subrayas son válidos.',

   'For this user, the default quota would be [_1] Mb.'
=> 'Para este usuario, la cuota predeterminada será [_1] Mb.',

   "For this user, the default quota would be [_1] Mb, as determined by the user's institutional affiliation ([_2])."
=> "Para este usuario, la cuota predeterminada será [_1] Mb, tal como se fija para la afiliación institucional del usuario ([_2]).",

   'For this user, the default quota is [_1] Mb.'
=> 'Para este usuario, la cuota predeterminada es [_1] Mb.',

   "For this user, the default quota of [_1] Mb, is determined by the user's institutional affiliation ([_2])."
=> "Para este usuario, la cuota predetermina de [_1] Mb, es fijada por la afiliación institucional del usuario ([_2]).",

   'in all LON-CAPA domains.'
=> 'en todos los dominios LON-CAPA.',

   'in LON-CAPA domains:'
=> 'en dominios LON-CAPA:',

   'in LON-CAPA domain '
=> 'en dominio LON-CAPA ',

   'Course settings modifiable by [_1] only.'
=> 'Parámetros del curso modificables por [_1] solamente.',

   'Course Owner'
=> 'Dueño del Curso',

   'Username:Domain'
=> 'Usuario:Dominio',

   'Course Activity'
=> 'Actividad del Curso',

   'Course Domain'
=> 'Dominio del Curso',

   'Course Institutional Code'
=> 'Código Institucional del Curso',

   "Course Owner's Username"
=> "Usuario Dueño del Curso",

   "Course Owner's Domain"
=> "Dominio del Dueño del Curso",

   'Course Type'
=> 'Tipo de Curso',

   'LON-CAPA course ID'
=> 'Id de curso LON-CAPA',

   'None found'
=> 'Ninguno encontrado',

   'Course settings which only a [_1] may modify.'
=> 'Parámetros del curso que solo un [_1] podría modificar.',

   "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain."
=> "Pulse el botón de 'Seleccionar' para ver o modificar parámetros para [_1] el cual puede ser cambiado por un [_2] en este dominio.",

   'Set enrollment'
=> 'Establecer inscripción',

   'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.'
=> 'Por favor revise la información en "Asistencia en Entrar" y la "Guía introductoria", si no puede ingresar.',

   'Please review the information in "Log-in help" if you are unable to log-in.'
=> 'Por favor revise la información en "Asistencia en Entrar", si no puede ingresar.',

   'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'Si su problema continúa sin resolverse, la forma mostrada puede usarse para enviar una pregunta al soporte técnico de LON-CAPA.',

   'Getting started guide'
=> 'Guía introductoria a LON-CAPA',

   '[_1] [_2] [_3] [_4] [_5]m [_6]s ' # "mm dd yyyy hh mi ss" (1:month, 2:day, 3:year, 4:hour, 5:minute, 6:second)
=> '[_2]. [_1] [_3], [_4]:[_5]m:[_6]s ', # "dd. mm yyyy, hh:mi:ss"

   '[_1]Select Date[_2]'
=> '[_1]Selecionar Fecha[_2]',

   '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.'
=> '[_1]: estudiantes pueden ver todas las secciones. [_2]: estudiantes pueden ver solo su propia sección. Blanco o [_3] previene vista de estudiantes.',

   '[_1] to require students to opt-in to listing in the roster (on the roster page).'
=> '[_1] para requerir a estudiantes optar aparecer en lista (en página del curso).',

   '[_1] for link to each a listing of each student\'s files.'
=> '[_1] para integrar a cada lista de enlace los archivos de cada estudiante',

   '[_1]: student, [_2]: TA, [_3]: instructor'
=> '[_1]: Estudiante, [_2]: Examinador, [_3]: Instructor',

   'role:section,role:section,...'
=> 'función:sección,unción:sección,...',

   'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.'
=> 'Ejemplo: "<tt>st:001,st:002,in,cc</tt>" permitirá a estudiantes en secciones 001 y 002 e instrucctores en cualquier sección, y coordinadores de curso, editar sus propios mensajes.',

   'supported types'
=> 'Formatos soportados',

   '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.'
=> '[_1], para enviar un mensaje solo a estudiante, [_2], para enviar mensaje a estudiante y añadir registro a la página de información para instructores. Deje en blanco para desabilitar.',

   'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.'
=> 'Instructores y Examinadores en secciones, cuando corrección de "Bridge tasks", sean permitidos corregir otras secciones.',

   '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.'
=> '[_1]: ellos son permitidos (por defecto). [_2]: no, ellos solo pueden corregir su propia sección.',

   'Calendar Announcement for '
=> 'Calendario de Anuncios para ',

   'Opening'
=> 'Apertura',

   'Closing'
=> 'Cierre',

   'To add a new user:'
=> 'Para añadir un nuevo usuario:',

   "(You can only create new users in your current role's domain - [_1])"
=> "(Solo puede crear usuarios nuevos en su funcióon actual de dominio - [_1])",

   "You are not authorized to create new users in your current role's domain - [_1]."
=> "No esta autorizado a crear nuevos usuarios en su funcióon actual de dominio - [_1].",

   "Set 'Domain/institution to search' to: [_1]"
=> "Establecer 'dominio/institución a buscar': [_1]",

   "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]"
=> "Establecer 'Criterio de búsqueda' : [_1]usuario está ..... en dominio selecionado LON-CAPA[_2]",

   'Provide the proposed username'
=> 'Escribir el nombre de usuario propuesto',

   'Select a user to add/modify roles'
=> 'Seleccionar usuario a quién añadir/modificar funciones',

   "Click 'Search'"
=> "Pulsar 'Buscar'",

   'User Search to add/modify roles'
=> 'Buscar usuario a quién añadir/modificar funciones',

# Feedback messages:

   'You have entered that answer before'
=> 'Ya has introducido esa respuesta antes',

   "Computer's answer now shown above."
=> "Ahora mostrando respuesta de la Computadora arriba.",

   'You are correct.'
=> '¡Correcto!',

   'You are partially correct.'
=> 'Está parcialmente correcto.',

   'Incorrect'
=> 'Incorrecto',

   'Your receipt no. is [_1]'
=> 'Su recibo es [_1]',

   'You are excused from the problem.'
=> 'Usted está exento de este problema.',

   'Some extra items were submitted.'
=> 'Se enviaron algunos artículos extra',

   'Some items were not submitted.'
=> 'Algunos artículos no fueron enviados.',

   'An error occurred while grading your answer.'
=> 'Ha ocurrido un error mientras se corregía su respuesta.',

   'The submitted answer was too long.'
=> 'Su respuesta es demasiado larga.',

   'This question expects a numeric answer.'
=> 'Esta pregunta espera una respuesta numérica',

   'You have provided an invalid ranking.'
=> 'La jerarquía provista es inválida.',

   'Please refer to [_1]'
=> 'Por favor verifique [_1]',

   'help on ranking problems'
=> 'ayuda clasificando problemas',

   'Submission won\'t be graded. The type of file submitted is not allowed.'
=> 'Respuesta no será corregida. El tipo de archivo enviado no está permitido.',

   'Submission not graded. Use fewer digits.'
=> 'Respuesta sin corregir. Use menos dígitos.',

   'Submission not graded. Use more digits.'
=> 'Respuesta sin corregir. Use más dígitos.',

   'Error in instructor specifed unit. This error has been reported to the instructor.'
=> 'Error en unidades especificadas por instructor. Este error fue reportado al instructor.',

   'Unable to interpret units. Computer reads units as "[_1]".'
=> 'No se pudo interpretar unidades. Computadora lee la unidades como "[_1]".',

   'Incompatible units. No conversion found between "[_1]" and the required units.'
=> 'Unidades incompatibles. No se encontró conversión entre "[_1]" y las unidades requeridas.',

   'Only a number required. Computer reads units of "[_1]".'
=> 'Sólo se requiere un número. Computadora lee la unidades de "[_1]".',

   'Proper comma separation is required'
=> 'Se requiere separación usando coma.',

   'Unable to understand formula'
=> 'No se pudo entender la fórmula',

   'Your submission has been recorded.'
=> 'Su acción se ha guardado.',

   'A draft copy has been saved.'
=> 'Una copia de borrador se ha guardado.',

   'Nothing submitted.'
=> 'No se envió respuesta alguna.',

   'Unknown message'
=> 'Mensaje desconocido',

   'Returned file(s): [_1]'
=> 'Archivo(s) devuelto(s): [_1]',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Respuesta Enviada: Su última respuesta enviada será corregida después de la fecha límite.',
#=> 'Respuesta Enviada: Su respuesta final se calificará después de la fecha de entrega.',

# --/

   ' The last submission was after the Due Date '
=> ' La última respuesta enviada fue después de la fecha límite ',

   'Submit a file: (only one file can be uploaded)'
=> 'Enviar archivo: (solo un archivo puede ser cargado)',

   'OR:'
=> 'O:',

   'Select Portfolio Files'
=> 'Seleccionar Archivos de portafolio',

   'Portfolio files previously selected: [_1]'
=> 'Archivos de Portafolio previamente seleccionados: [_1]',

   "These file(s) don't exist: [_1]"
=> "Tal(es) archivo(s) no existe(n): [_1]",

   'Previously published version'
=> 'Versión previamente publicada',

   'You do not have privileges to modify the authentication configuration for this user.'
=> 'No tiene privilegios para modificar la configuración de autenticación de este usuario.',

   'You do not have privileges to modify the portfolio quota for this user.'
=> 'No tiene privilegios para modificar la cuota de portafolio de este usuario.',

   'If a change is required, contact a domain coordinator for the domain'
=> 'Si requiere un cambio, contacte al coordinador de dominio de ese dominio',

   'with submissions'
=> 'con respuestas',

   'in grading queue'
=> 'en lista para ser corregido',

   'with ungraded submissions'
=> 'con respuestas sin corregir',

   'with incorrect submissions'
=> 'con respuestas incorrectas',

   'with any status'
=> 'con cualquier estado',

   'Default value or none'
=> 'Valor Predefinido o ninguno',

   'Floating Point between 1 and 0'
=> 'Punto Flotante entre 0 y 1',

   'Floating point number between zero and one'
=> 'Número punto flotante entre cero y uno',

   'Positive Floating Point'
=> 'Punto Flotante Positivo',

   'Positive floating point number or zero'
=> 'Número punto flotante positivo o cero',

   'Floating Point'
=> 'Punto Flotante',

   'Floating point number'
=> 'Número punto flotante',

   'Configuration setting'
=> 'Parámetros de configuración',

   'Value(s)'
=> 'Valor(es)',

   'Auto-enrollment active?'
=> '¿Activar auto-inscripcción?',

   'Access to other pages will be prevented until you have moved the message to your inbox.'
=> 'Acceso a otras páginas estan detenidas hasta mover el mensaje a su BANDEJA de ENTRADA.',

   'Access to other pages will be prevented until you have moved all critical messages to your inbox.'
=> 'Acceso a otras páginas estan detenidas hasta mover todos los mensajes críticos a su BANDEJA de ENTRADA.',

   'Move to Inbox'
=> 'Mover a su BANDEJA de ENTRADA',

   'Move to Inbox/Compose reply'
=> 'Mover a su BANDEJA de ENTRADA/Componer respuesta',

   'Confirm Receipt'
=> 'Confirmar recibo',

   'Confirm Receipt and Reply'
=> 'Confirmar recibo y Contestar',

   'Displaying Critical Messages'
=> 'Mostrando mensajes círticos',

   'Confirming Receipt'
=> 'Confirmando recepción',

   'Confirmed Receipt'
=> 'Recepción confirmada',

   'Communicate'
=> 'Comunicar',

   'Replying to a Critical Message'
=> 'Respondiendo a Mensaje crítico',

   'Answer Available'
=> 'Respuesta disponible',

   ' to '
=> ' hasta ', # ???

   'Event from [_1] to [_2]'
=> 'Evento desde [_1] hasta [_2]',

   '[_1]: [_2] from domain [_3]'
=> '[_1]: [_2] desde dominio [_3]',

   'The following problems occurred:'
=> 'Ocurrieron los siguiente problemas:',

   'Could not initialize [_1] at this time.'
=> 'No se pudo iniciar [_1] en este momento.',

   'Please try again.'
=> 'Por favor trate otra vez.',

   'Please try again'
=> 'Por favor trate otra vez',

   'in this course'
=> 'en este curso',

   'Remove Checked Entries'
=> 'Eliminar entradas seleccionadas',

   'Modify Student Data'
=> 'Modificar Datos del Estudiante',

   'First name'
=> 'Nombre',

   'Middle name'
=> '2do nombre',

   'Last name'
=> 'Apellidos',

   'ID'
=> 'ID/Num. Est.',

   'Sending critical message'
=> 'Enviando mensaje círtico',

   'Replying to'
=> 'Respondiendo a',

   'All messages:'
=> 'Todos los mensajes:',

   'Unread messages:'
=> 'Mensajes NO leídos:',

   'Read messages:'
=> 'Mensajes leídos:',

   'Replied to messages:'
=> 'Mensajes respondidos:',

   'Forwarded messages:'
=> 'Mensajes Reenviados:',

   'showing messages [_1] through [_2] of [_3].'
=> 'mostrando mensajes [_1] hasta [_2] del total de [_3]',

   'Broadcast Message'
=> 'Emitir Mensaje',

   'randomly pick [quant,_1,resource]'
=> 'elegir al azar [quant,_1,recurso,recursos]',

   'contents hidden'
=> 'contenido oculto',

   'URLs hidden'
=> 'ocultar URLs',

   'random order'
=> 'ordenar al azar',

   'Resources in course with version changes since yesterday'
=> 'Recursos del curso con cambios de versión desde ayer',

   'Version changes since Yesterday'
=> 'Cambios de versión desde ayer',

   'Resources in course with version changes since last week'
=> 'Recursos del curso con cambios de versión desde la última semana',

   'Version changes since last Week'
=> 'Cambios de versión desde la última semana',

   'Resources in course with version changes since last month'
=> 'Recursos del curso con cambios de versión desde el último mes',

   'Version changes since last Month'
=> 'Cambios de versión desde el último mes',

   'Resources in course with version changes seit start of course'
=> 'Recursos del curso con cambios de versión desde el inicio del curso',

   'Version changes since start of Course'
=> 'Cambios de versión desde el inicio del Curso',

   'No version changes since yesterday'
=> 'Sin cambios de versión desde ayer',

   'No version changes since last week'
=> 'Sin cambios de versión desde la última semana',

   'No version changes since last month'
=> 'Sin cambios de versión desde el último mes',

   'No version changes since start of course'
=> 'Sin cambios de versión desde el inicio del curso',

   'version changes since yesterday'
=> 'cambios de versión desde ayer',

   'version changes since last week'
=> 'cambios de versión desde la última semana',

   'version changes since last month'
=> 'cambios de versión desde el último mes',

   'version changes since start of course'
=> 'cambios de versión desde el inicio del curso',

   'Roles for which access to course has expired since yesterday'
=> 'Funciones para los cuales el acceso al curso expiró desde ayer',

   'Roles for which access to course has expired since last week'
=> 'Funciones para los cuales el acceso al curso expiró desde la última semana',

   'Roles for which access to course has expired since last month'
=> 'Funciones para los cuales el acceso al curso expiró desde el último mes',

   'Roles for which access to course has expired since start of course'
=> 'Funciones para los cuales el acceso al curso expiró desde el inicio del curso',

   'There are no roles which expired since yesterday'
=> 'No hay funciones que expiraran desde ayer',

   'There are no roles which expired since last week'
=> 'No hay funciones que expiraran desde la última semana',

   'There are no roles which expired since last month'
=> 'No hay funciones que expiraran desde el último mes',

   'There are no roles which expired since start of course'
=> 'No hay funciones que expiraran desde el inicio del curso',

   'roles which expired since yesterday'
=> 'funciones que expiraron desde ayer',

   'roles which expired since last week'
=> 'funciones que expiraron desde la última semana',

   'roles which expired since last month'
=> 'funciones que expiraron desde el último mes',

   'roles which expired since start of course'
=> 'funciones que expiraron desde el inicio del curso',

   'Roles for which access to course has become available since yesterday'
=> 'Funciones para los cuales el acceso al curso sido disponible desde ayer',

   'Roles for which access to course has become available since last week'
=> 'Funciones para los cuales el acceso al curso sido disponible desde la última semana',

   'Roles for which access to course has become available since last month'
=> 'Funciones para los cuales el acceso al curso sido disponible desde el último mes',

   'Roles for which access to course has become available since start of course'
=> 'Funciones para los cuales el acceso al curso sido disponible desde el inicio del curso',

   'There are no roles which have become active since yesterday'
=> 'No hay funciones que se hayan activado desde ayer',

   'There are no roles which have become active since last week'
=> 'No hay funciones que se hayan activado desde la última semana',

   'There are no roles which have become active since last month'
=> 'No hay funciones que se hayan activado desde el último mes',

   'There are no roles which have become active since start of course'
=> 'No hay funciones que se hayan activado desde el inicio del curso',

   'roles which have become active since yesterday'
=> 'funciones que se han activado desde ayer',

   'roles which have become active since last week'
=> 'funciones que se han activado desde la última semana',

   'roles which have become active since last month'
=> 'funciones que se han activado desde el último mes',

   'roles which have become active since start of course'
=> 'funciones que se han activado desde el inicio del curso',

   'Show all posts'
=> 'Ver todos los mensajes de discusión',

#   'to display'
#=> 'mostrar', # ???

#   'posts previously marked read'
#=> 'mensajes de discusión marcados previamente como leídos',

#   'previously viewed posts'
#=> 'mensajes de discusión previamente vistos',

   'NEW'
=> 'NUEVO',

   'Preferences on what is marked as NEW'
=> 'Preferecias en lo que está marcado como NUEVO',

   'Mark NEW posts no longer new'
=> 'Marcar mensajes NUEVOs como no nuevos',

   'Sorting/Filtering options'
=> 'opciones de clasificación/filtración',

   'Export'
=> 'Exportar',

   'Attachments'
=> 'Adjuntos',

   'Download the zip file from [_1]Discussion Posting Archive'
=> 'Descargar archivo zip de [_1]Archivo de mensajes de discusión',

   'The following errors occurred during export - [_1]'
=> 'Los siguientes errores ocurrieron mientras se exportaba - [_1]',

   'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.'
=> 'Desafortunadamente no podrá recuperar un archivo de mensajes de discusión en este momento, por que hubo un problema creando un archivo de manifiesto.',

   'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.'
=> 'Desafortunadamente no podrá recuperar un archivo IMS de este foro de discusión en este momento, por que hubo un problema creando un archivo de manifiesto.',

   'Make Visible'
=> 'Hacerlo visible',

   'Reply'
=> 'Responder',

   'Mark unread'
=> 'Marcar como no leído',

   'Mark read'
=> 'Marcar como leído',

   'This post has been edited by the author.'
=> 'Este mensaje fue editado por el autor.',

   'Display all versions'
=> 'Ver todas las versiones',

   'Earlier version(s) were posted on: '
=> 'Version(es) anterior(es) fue(ron) pública(s) el: ',

   'You do not have privileges to view all versions of posts.'
=> 'No tiene privilegios para ver todas las versiones de los mensajes.',

   'Please select a different role.'
=> 'Por favor seleccione otra función de usuario.',

   'Error copying file attachment - [_1] to IMS package'
=> 'Error copiando archivo adjunto - [_1] a paquete IMS',

   'Error copying file attachment - [_1] to IMS package: '
=> 'Error copiando archivo adjunto - [_1] a paquete IMS: ',

   'Re: '
=> 'Re: ',

   'Please select a feedback type.'
=> 'Por favor seleccione un tipo de reacción.',

   'Sorry, no feedback possible on this resource ...'
=> 'Lo siento, no se puede hacer comentarios de reacción a este recurso ...',

   'Error sending message to [_1], no user specified.'
=> 'Error enviando mensaje a [_1]. usuario no especificado.',

   'Error sending message to [_1], no domain specified.'
=> 'Error enviando mensaje a [_1]. dominio no especificado.',

   'Error sending message to'
=> 'Error enviando mensaje a',

   'Not registered'
=> 'No registrado', # ???

   'Editing not permitted'
=> 'Edición no permitido',

   'Marked postings read/unread'
=> 'Mensajes marcacados como leído/no leído',

   'Changed sort/filter'
=> 'Cambió orden/filtro',

   'Changed display status'
=> 'Cambió estado de visualización',

   'Deletion not permitted'
=> 'No es permitido Borrar',

   'Changed discussion status'
=> 'Cambió estado de discusión',

   'Changed discussion view mode'
=> 'Cambió modo de ver discusión',

   'Added to my course blog'
=> 'Añadido al Blog de mi curso',

   'Back to previous page'
=> 'Volver a página anterior',

   'Return to previous page'
=> 'Retornar a página anterior',

   'Untitled resource'
=> 'Recurso sin título',

   'Discussion display options'
=> 'Opciones de visualización de discusión',

   'Preferences can be set for this discussion that determine ....'
=> 'Preferencias que pueden establecerse para esta discusión ....',

   'Which posts are displayed when you display this discussion board or resource, and'
=> '¿Qué mensajes son mostrados? cuando visualiza este foro de discusión o recurso, y',

   'Under what circumstances posts are identified as "NEW", and'
=> 'Bajo que circunstancias los mensajes son identificados como "NUEVO", y ',

   'Whether individual posts can be marked as read/unread'
=> 'Si los mensajes individuales se pueden marcar como leído/no leído',

   'Posts not marked read'
=> 'Mensajes no marcados como leídos',

   'New posts cease to be identified as "New"?'
=> 'Nuevas contribuciones ¿dejan de ser identificadas como "Nuevo"?',

   'New posts cease to be identified as "NEW"?'
=> 'Nuevas contribuciones ¿dejan de ser identificadas como "NUEVO"?',

   'Option to mark each post as read/unread?'
=> '¿Opción a marcar cada mensaje como leído/no leído?',

   'Shown'
=> 'Mostrar',

   'Not shown'
=> 'Sin mostrar',

   'Discussion options'
=> 'Opciones de Discusión',

   'Set options that control the sort order of posts, and/or which posts are displayed.'
=> 'Establecer opciones que controlan el orden de los mensajes, y qué mensajes son mostrados.',

   'Sort order'
=> 'Ordenar',

   'Date order - oldest first'
=> 'Por fecha - más antiguo primero',

   'Date order - newest first'
=> 'Por fecha - más nuevo primero',

   'Threaded'
=> 'Enlazados', # ???

   'By subject'
=> 'Por tema',

   'By domain and username'
=> 'Por dominio y usuario',

   'By last name, first name'
=> 'Por apellidos, nombre',

   'Specific role status'
=> 'Estado de función de usuario',

   'Roles of any status'
=> 'Funciones de cualquier estado',

   'Only active roles'
=> 'Solo funciones de usuario activos',

   'Only past roles'
=> 'Solo funciones de usuario anteriores',

   'Only future roles'
=> 'Solo futuras funciones de usuario',

   'Specific user roles'
=> 'Funciones de usuario específicas',

   'All roles'
=> 'Todas las funciones de usuario',

   'Students'
=> 'Estudiantes',

   'Course Coordinators'
=> 'Coordinadores de Curso',

   'Instructors'
=> 'Instructores',

   'TAs'
=> 'Examinadores',

   'Exam proctors'
=> 'Supervisor de Exámen',

   'Custom role'
=> 'Función de usuario personalizado',

   'Custom roles'
=> 'Funciones de usuario personalizados',

   'Specific sections'
=> 'Secciones específicas',

   'Specific groups'
=> 'Grupos específicos',

   'Pick specific users (by name)'
=> 'Elija usuario específico (por nombre)',

   'Show a list of current posters'
=> 'Mostrar lista de carteles actuales',

   'So far, no data has been returned for your request'
=> 'Hasta el momento, no hay datos obtenidos para su solicitud.',

   'Select a user'
=> 'Seleccionar un usuario',

   'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.'
=> 'Ocurrió un error mientras se procesó este recurso. El personal del curso ([_1]) y el autor fueron notificados.',

   'photo'
=> 'Foto',

   'Critical Message'
=> 'Mensaje Crítico',

   'Display a Message'
=> 'Ver un Mensaje',

   'Back to Folder Display'
=> 'Volver a Ver Carpeta',

   'Currently available actions (will open extra window)'
=> 'Acciones disponibles actualmente (abrirá una ventana extra)',

   'There are no unread messages in this folder.'
=> 'No hay mensajes no leídos en esta carpeta.',

   'There are no read messages in this folder.'
=> 'No hay mensajes leídos en esta carpeta.',
# => 'No hay mensajes ... en esta carpeta.',

   'There are no forwarded messages in this folder.'
=> 'No hay mensajes reenviados en esta carpeta.',
# => 'No hay mensajes ... en esta carpeta.',

   'You have not replied to any messages in this folder.'
=> 'No ha respondido a ningún mensaje en esta carpeta.',

   'There are no messages in this folder.'
=> 'Carpeta Vacía', # Empty Folder

   'To:'
=> 'A:',

   'Cc:'
=> 'CC:',

   'Bcc:'
=> 'BCC:',

   'Retrieve discussion and message records'
=> 'Recuperar registros de discusión y mensajes',

   'New Record (record is visible to course faculty and staff)'
=> 'Nuevo Registro (registro es visible a los profesores y personal del curso):',

   'Post this Record'
=> 'Publicar este Registro',

   'Revise your search criteria for this domain'
=> 'Revisar su criterio de búsqueda para este dominio',

   'Metadata Modified'
=> 'Meta-datos Modificado',

   'Use of LON-CAPA requires Javascript to be enabled in your web browser.'
=> 'Uso de LON-CAPA require activar Javascript en su navegador de internet.',

   'As this is not the case, most functionality in the system will be unavailable.'
=> 'Como este no es el caso, la mayoría de las funciones del sistema no estarán disponibles.',

   'You have requested to create file in directory [_1] which doesn\'t exist. The requested directory path has been removed from the requested file name.'
=> 'A pedido crear archivo en directorio [_1], el cual no existe. Por tanto, la ruta correspondiente al directorio fue eliminada del nombre del archivo.',

   'Directory'
=> 'Directorio',

   'Only empty directories may be deleted.'
=> 'Solo directorios vacíos pueden ser borrados.',

   'You must delete the contents of the directory first.'
=> 'Primero debe borrar el contenido del directorio.',

   'Cannot delete non-obsolete published file.'
=> 'No puede borrar archivos publicados no obsoletos.',

   'Must not include'
=> 'No debe incluir',

   'Name of new file is the same as name of old file'
=> 'Nombre del nuevo archivo es el mismo que el nombre anterior',

   'no action taken'
=> 'no se tomó acción',

   'copy metadata error'
=> 'copiar error de meta-datos',

   'No New filename specified'
=> 'No se especificó nombre de archivo nuevo',

   'Warning: a published problem of this name exists.'
=> 'Advertencia: un problema publicado con este nombre existe.',

   'Warning: a published library of this name exists.'
=> 'Advertencia: una biblioteca publicada con este nombre existe.',

   'Bad filename [_1]'
=> 'Mal Nombre de archivo [_1]',

   '[_1](name).(number).(extension)[_2] not allowed.'
=> '[_1](nombre).(número).(extensión)[_2] no permitido.',

   'Removing the [_1].number.[_2] from requested filename.'
=> 'Eliminando [_1].número.[_2] del nombre.',

   'Cannot change MIME type of a directory.'
=> 'No puede cambiar tipo MIME de un directorio.',

   'Cannot rename or move non-obsolete published file.'
=> 'No puede renombrar o mover archivo publicado no obsoleto.',

   'Change discussion display'
=> 'Cambiar visualización de discusión',

   'Choose whether or not to display a count of the number of new posts for each resource or discussion board which has unread posts.'
=> 'Escoger si mostrar o no la cuenta de número de mensajes nuevos por cada recurso o foro de discusión que tiene mensajes no leídos.',

   "This can increase the time taken to gather data for the [_1]What's New Page[_2] by a few seconds."
=> "Esto puede aumentar el tiempo que se tarda en conseguir los datos para [_1]página ¿Qué hay de Nuevo?[_2] por pocos segundos.",

   'Currently set to [_1].'
=> 'Actualmente establecido en [_1].',

   'Change to [_1]'
=> 'Cambiar a [_1]',

   'No change'
=> 'Sin cambio',

   'Count unread posts in discussions display set to [_1]'
=> 'Visualización del número de mensajes no leídos en discusión configurado en [_1]',

   'Groups Manager'
=> 'Control de Grupos',

   'Group access start and end dates'
=> 'Fechas de inicio y término de acceso grupal',

   'None available'
=> 'No disponible',

   'There are no active, future or previous group members to modify.'
=> 'No hay miembros de grupo, activos, futuros o anteriores que modificar.',

   'Members to delete or expire'
=> 'Miembros a eliminar o expirar',

   'To be deleted'
=> 'A ser eliminados',

   'To be expired'
=> 'A ser expirados',

   'No members to be deleted or expired from the group.'
=> 'No hay miembros a ser eliminados o expirados de este grupo.',

   'Files: [_1]'
=> 'Archivos: [_1]',

   'Folders: [_1]'
=> 'Carpetas: [_1]',

   'Choose Task'
=> 'Escoger Acción',

   'Modify default group settings'
=> 'Modificar configuración del grupo defecto',

   'Modify access, tools and/or privileges for previous, future, or current members'
=> 'Modificar acceso, herramientas y/o privilegios para miembros previos, futuros o actuales',

   'Add member(s) to the group'
=> 'Añadir miembro(s) al grupo',

   'Group Settings'
=> 'Parámetros del Grupo',

   'Modify/Delete Members'
=> 'Modificar/Eliminar Miembros',

   'Current Tool Set'
=> 'Conjunto actual de herramientas',

   'Change Privileges'
=> 'Cambiar Privilegios',

   'Membership Mapping'
=> 'Mapeo de Membresía',

   'Group name, title and available collaborative tools'
=> 'Nombre, título y herramientas colaborativas disponibles del grupo',

   'Letters, numbers and underscore only'
=> 'Letras, números y subrayas solamente',

   'E-mail'
=> 'E-Mail',

   'Group home page'
=> 'Página del Grupo',

   'Membership Roster'
=> 'Lista de Participantes',

   'Granularity:'
=> 'Granularidad:',

   'Different subsets of the chosen collaborative tools for different group members?'
=> '¿Diferentes subgrupos de las herramientas escogidas para diferentes miembros del grupo?',

   'Disk Quota'
=> 'Cuota en Disco',

   'If you enable the group portfolio for the group, allocate a disk quota.'
=> 'Si activa el repositorio de portafolio grupal, asigne una cuota de disco.',

   '[_1] Mb'
=> '[_1] Mb',

   'A total of [_1] Mb can be divided amongst all groups in the course, and [_2] Mb are currently unallocated.'
=> 'Un total de [_1] Mb puede ser dividido entre todos los grupos en el curso, y [_2] Mb están sin asignar.',

   'Default start and end dates for group access'
=> 'Fechas de inicio y término para accesar grupo',

   'Start:'
=> 'Inicia:',

   'End:'
=> 'Termina:',

   'Error: invalid course domain or number - group folder creation failed.'
=> 'Error: dominio o número de curso inválido - falló creación de carpeta grupal.',

   'Course Groups'
=> 'Grupos del Curso',

   'Non-standard course - folder for all groups not added.'
=> 'Curso no estándar - carpeta para todos los grupos no añadido.',

   'Build a list of users for selection of group members'
=> 'Construir una lista de usuarios para selección de miembros del grupo',

   'Group membership selection list criteria:'
=> 'Criterio de selección de miembros del grupo:',

   'Pick the criteria to use to build a list of course users from which you will select '
=> 'Elegir el critero a usar para construir la lista de usuarios del curso de quienes se seleccionará ',

   'members of the new group.'
=> 'miembros del nuevo grupo.',

   'If you do not wish to add members when you first create the group, there is no need to pick any criteria.'
=> 'Si no desea añadir miembros cuando crea el grupo, no hay necesidad de elegir un criterio.',

   'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section <i>changes</i> in the course.'
=> 'Un siguiente paso le permitirá especificar inscribir/retirar automáticamente miembros del grupo, al detectar <i>cambios</i> en la función de usuario y sección del curso.',

   'Access types'
=> 'Tipos de Acceso',

   'Currently has access'
=> 'Actualmente tiene acceso',

   'Will have future access'
=> 'Tendrá acceso futuro',

   'Previously had access'
=> 'Tuvo acceso anteriormente',

   'Course roles'
=> 'Funciones del curso',

   'Course sections'
=> 'Seciones del curso',

   'all sections'
=> 'todas las secciones',

   'no section'
=> 'sin sección',

   'Invalid group name'
=> 'Nombre de grupo inválido',

   'The group name entered '
=> 'El nombre de grupo escogido ',

   'is not a valid name.'
=> 'no es un nombre válido.',

   'can not be used as it is the name of '
=> 'no puede ser usado porque es el nombre de ',

   'an existing [_1]',
=> 'un [_1]',

   ' in this Course'
=> 'existente  en este curso',

   'Group names and section names used in a Course must be unique.'
=> 'Nombres de grupo y sección usados en el curso deben ser únicos.',

   'Group names may only contain letters, numbers or underscores.'
=> 'Nombres de grupo solo pueden contener letras, números o "_".',

   'Previous'
=> 'Anterior',

   'Select Members'
=> 'Seleccionar Miembros',

   'Your group selections - '
=> 'Su selecciones para el grupo - ',

   'The following settings will apply to the group:'
=> 'La siguiente configuración se usará para el grupo:',

   'Granularity'
=> 'Granularidad',

   'File quota'
=> 'Cuota en Archivos',

   'Default access dates'
=> 'Fechas de acceso por defecto',

   'Different collaborative tools<br />for different members:'
=> 'Diferente herramientas collaborativas<br />para los diferentes miembros:',

   'Start date'
=> 'Fecha de inicio',

   'Start date:'
=> 'Fecha de inicio:',

   'End date'
=> 'Fecha de término',

   'End date:'
=> 'Fecha de término:',

   'Available for assignment to members:'
=> 'Disponible para asignar a los miembros:',

   'Unavailable for assignment:'
=> 'No disponible para asignar:',

   'User privileges for collaborative tools'
=> 'Privilegios de usuario para herramientas colaborativas',

   'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.'
=> 'Para cada herramienta colaborativa que a elegido incluir, hay un conjunto de privilegios fundamentales que todos los miembros del grupo asignados a usar las herramientas recibirán.',

   'For some tools there are also additional optional privileges which can be set.'
=> 'Para algunas herramientas hay también privilegios opcionales adicionales que pueden ser establecidos.',

   'Choose one of the following:'
=> 'Elija uno de los siguientes:',

   'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.'
=> 'Para las herramientas colaborativas que ha elegido incluir solo privilegios fundamentales son disponibles, por tanto no hay privilegios opcionales a asignar.',

   'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.'
=> 'Como escogió no incluir ninguna herramienta colaborativa en el grupo, no necesita establecer privilegios opcionales.',

   'Group membership'
=> 'Membresía Grupal',

   'Add members'
=> 'Añadir miembros',

   'Assign collaborative tools'
=> 'Asignar herramientas colaborativas',

   'Tools'
=> 'Herramientas',

   'Add Members'
=> 'Añadir Miembros',

   'Add?'
=> '¿Añadir?',

   'All:'
=> 'Todos:',

   'You have indicated that the group portfolio should be enabled, but you have set the respository quota to 0 Mb.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.'
=> 'Usted indicó que se activará el portafolio grupal, pero ha configurado la cuota respositoria a 0 Mb.\nEsto evitará subir cualquier archivo.\nPor favor establezca un valor o desactive la herramienta repositaria.',

   '[_1] [_2] was created.<br />'
=> '[_1] [_2] fue creado.<br />',

   'Group membership list updated.'
=> 'Lista de membresía grupal actualizada.',

   'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.'
=> 'Cualquier usuario conectado que sea afectado por los cambios hechos a la membresía del grupo o privilegios para el grupo [_1] necesita desconectarse y volverse a conectar su sesión LON-CAPA para que los cambios tomen efecto.',

   'An error occurred while updating the group membership list:'
=> 'Ocurrió un error mientras se actualizaba la lista de membresía grupal:',

   'Choose Privileges'
=> 'Escoger Privilegios',

   'Setting Changes Complete'
=> 'Cambios de Configuración completos',

   'Modifications Complete'
=> 'Modificaciones completas',

   'Creation Complete'
=> 'Creación Completa',

   'Additions Complete'
=> 'Adiciones Completadas',

   'Verify deletion'
=> 'Verificar eliminación',

   'Deletion Complete'
=> 'Eliminación completa',

   'Create Group'
=> 'Crear Grupo',

   'discussion'
=> 'discusión',

   'homepage'
=> 'Página Web',

   'roster'
=> 'lista',

   'Edit Group Homepage'
=> 'Editar Página Web del Grupo',

   'Edit Group Settings'
=> 'Editar Configuración del Grupo',

   'Available Group Tools'
=> 'Herramientas disponibles al Grupo',

   'Group Chat Room'
=> 'Chat del Grupo',

   'Group Chat Room:'
=> 'Chat del Grupo:',

   'Group page - [_1]'
=> 'Página del Grupo - [_1]',

   '[_1] discussion boards - [_2]'
=> '[_1] foro de discusión - [_2]',

   'New Discussion Board'
=> 'Nuevo Foro de Discusión',

   'There are currently no discussion boards in this course.'
=> 'Actualmente no hay foros de discusión en este curso.',

   'There are currently no discussion boards in this group.'
=> 'Actualmente no hay foros de discusión en este grupo.',

   'Discussion Board Title'
=> 'Título del Foro de discusión',

   'discussion board'
=> 'foro de discusión',

   'The new discussion board was added successfully.<br />'
=> 'El nuevo foro de discusión fue añadido exitosamente.<br />',

   'Edit [_1] board'
=> 'Editar foro [_1]',

   'View all group discussion boards'
=> 'Ver todos los  foros de discusión grupales',

   'Show Student View'
=> 'Mostrar Vista de Estudiante',

   'Note: in anonymous discussion, your name is visible only to course faculty'
=> 'Nota: en discusiones anónimas, su nombre es visible solo al profesor del curso',

   'Send a Message in a Group'
=> 'Enviar Mensaje dentro de un Grupo',

   'As this group has no members, there are no recipients to select.'
=> 'Como este grupo no tiene miembros, no hay destinatarios para seleccionar.',

   'Allow replies'
=> 'Permitir responder',

   'Reply to'
=> 'Responder a',

   '[_1] portfolio files - [_2]'
=> '[_1] archivos de portafolio - [_2]',

   'There are no membership data to display for this [_1]'
=> 'No hay datos de membresía que mostrar para este [_1]',

   'Group Membership'
=> 'Membresía al Grupo',

   '[_1] membership status - [_2]'
=> '[_1] estado de la membresía - [_2]',

   'Group Message'
=> 'Mensaje Grupal',

   'Compose Group Message'
=> 'Componer Mensaje Grupal',

   'Course Discussion Boards'
=> 'Foros de Discusión del Curso',

   'Post Discussion'
=> 'Enviar Mensaje de Discusión',


   'Post Anonymous Discussion'
=> 'Enviar Mensaje anónimo',

   'Content'
=> 'Contenido',

   'You do not currently have rights to view this group.'
=> 'Actualmente, no tiene autorización de ver este grupo',

   'No page information provided.'
=> 'No hay información de la Página.',

   'Available functions'
=> 'Funciones disponibles',

   'No group functionality.'
=> 'Sin funciones de grupo.',

   'No group functionality (e.g., e-mail, discussion, chat room or file upload) is currently available to you in this group: [_1].'
=> 'No hay funciones de grupo (p.e. E-Mail, Foro de Discusión, Chat o Cargar Archivos) disponibles actualmente para este grupo: [_1].',

   'Simple Group Page'
=> 'Página Grupal Simple',

   'Quota allocated to group portfolio:'
=> 'Cuota asignada al portafolio grupal:',

   'The quota is currently [_1] Mb'
=> 'La cuota es actualmente [_1] Mb',

   'The quota can be increased to [_1] Mb, by adding all unallocated space for groups in the course.'
=> 'La cuota puede aumentarse a [_1] Mb, añadiendo todo el espacio sin asignar para grupos en el curso.',

   'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.'
=> 'Cada herramienta de colaboración, incluye un núcleo de privilegios asignado a todos los miembros con acceso a tal herramienta. Algunas herramientas podrían presentar también privilegios que pueden ser establecidos para miembros en específico.',

   'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.'
=> 'Todos los miembros del grupo recibirán los mismos privilegios para cualquier herramienta asignada a ellos, incluyendo el conjunto de privilegios opcionales por defecto.',

   'Different group members may receive different privileges from others for the tools they have been assigned.'
=> 'Miembros diferentes del grupo podrían recibir privilegios diferentes de los otros para las herramientas que fueron asignadas.',

   'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.'
=> 'Indicar que privilegios <i>optionales</i> recibirán los miembros por defecto para una herramienta en específico.',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course '
=> 'Estos serán los privilegios dados a miembros asignados en el futuro a través de la asignación automática grupal para usuarios que reciben secciones/funciones en el curso ',

   'if enabled on the next page'
=> 'Si se activó en la siguiente página',

   'if enabled below'
=> 'Si se activó ver debajo',

   'Additional privileges'
=> 'Privilegios adicionales',

   'Fixed privileges'
=> 'Privilegios fijos',

   'Optional privileges'
=> 'Privilegios opcionales',

   'Collaborative Tool'
=> 'Herramienta Colaborativa',

   'Fixed'
=> 'Fijo',

   'Optional'
=> 'Opcional',

   'Additional Tools'
=> 'Herramientas Adicionales',

   'Core privileges'
=> 'Privilegios Fundamentales',

   'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.'
=> 'Para las herramientas colaborativas incluídas a los miembros del grupo que esta siendo añadido o modificados, no hay privilegios opcionales que establecer.',

   'All new group members will receive the same privileges.'
=> 'Todos los nuevos miembros del grupo recibirán los mismos privilegios.',

   'If previously expired members are being re-enabled, or if access for future members is being activated now, previously set privileges will be preserved.'
=> 'Si miembros previamente expirados estan siendo reactivados, o si el acceso a miembros futuros esta siendo activado ahora, privilegios previamente establecidos serán preservados.',

   'As no group members are being added, there are no specific user privileges to set.'
=> 'Como no se estan añadiendo miembros al grupo, no hay que establecer privilegios de usuario.',

   'No group member privileges to display or set, as you have not indicated that you will be activating, re-enabling, changing privileges, or adding/removing tools for any current members.'
=> 'Sin mostrar o establecer privilegios a miembros de grupo, porque no indicó que estará activando, reactivando, cambiando privilegios o añadiendo/eliminando herramientas para cualquiera de los miembros actuales.',

   'Currently the group is configured '
=> 'Actualmente el grupo está configurado ',

   'so different members can receive different optional privileges for a particular tool.'
=> 'tal que miembros diferentes pueden recibir diferentes privilegios opcionales para una herramienta en particular.',

   'so all members will receive the same optional privileges for a particular tool.'
=> 'tal que todos los miembros recibirán los mismos privilegios opcionales para una herramienta en particular.',

   'Settings for automatic group enrollment'
=> 'Configuración para inscripción grupal automática',

   'Group membership mapping to specific sections/roles'
=> 'Mapa de asociación de membresía grupal a secciones/funciones específicas',

   'Enable/disable automatic group enrollment for users in specified roles and sections'
=> 'Activar/Desactivar suscripción grupal automática para usuarios en funciones específicas y secciones',

   'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.'
=> 'Si la suscripción grupal automática está activada, cuando un usuario es asignado un curso nuevo o función específica de sección, el/ella será añadido/a como miembro del grupo, con las fechas de inicio y término de acceso definidas en la configuración del grupo, a menos que el/ella sea ya miembro del grupo, con fechas de acceso que permiten acceso grupal actual o futuro.',

   "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group."
=> "Si la desafiliación grupal automática está activada, cuando la función de usuario a expirado, el acceso al grupo será terminado a menos que el usuario tenga otro curso o sección específica activa o una función de usuario futura que haría recibir membresía automática al grupo.",

   'Automatically enable group membership when roles are added?'
=> 'Automáticamente activar membresía grupal, ¿cuando se añaden funciones?',

   'Automatically expire group membership when roles are removed?'
=> 'Automáticamente expirar membresía grupal, ¿cuando se eliminan funciones?',

   'Currently set to'
=> 'Actualmente establecido en',

   'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.'
=> 'Mapa de asociación de funciones y secciones afectadas por suscripción/desafiliación grupal automática sigue los esquemas escogidos abajo.',

   'Pick roles and sections for automatic group enrollment'
=> 'Selecionar funciones y secciones para suscripción grupal automática',

   'Active?'
=> '¿Activar?',

   'Send group message'
=> 'Enviar mensaje grupal',

   'Create boards'
=> 'Crear foros',

   'Edit own posts'
=> 'Editar mis mensajes',

   'Hide/Delete any post'
=> 'Ocultar/Borrar cualquier mensaje',

   'View boards'
=> 'Ver foros',

   'Control Access'
=> 'Control de acceso',

   'Basic Display'
=> 'Visualización Básica',

   'Detailed Display'
=> 'Visualización Detallada',

   'View page'
=> 'Ver página',

   'Modify page'
=> 'Modificar página',

   'communication'
=> 'comunicación',

   'Broadcast message'
=> 'Emitir mensaje',

   'files'
=> 'archivos',

   'Foils without names exist. This can cause problems to malfunction.'
=> 'Hay opciones sin nombre que pueden causar problemas de funcionamiento defectuoso.',

   'Unknown area style [_1]'
=> 'Area de estilo desconocido [_1]',

   "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name."
=> "El mensaje mismo empezará con la primera línea <i>'Mensaje reenviado de'</i> seguido por el nombre del remitente original.",

   'Forwarded message from '
=> 'Mensaje reenviado de ',

   'You received a critical message from [_1] in LON-CAPA.'
=> 'Recibió un mensaje crítico de [_1] en LON-CAPA.',

   'You received a message from [_1] in LON-CAPA.'
=> 'Recibió un mensaje de [_1] en LON-CAPA.',

   "'New'  critical message from "
=> "Mensaje crítico 'Nuevo' de ",

   "'New'  message from "
=> "Mensaje 'Nuevo' de ",

   'Refers to'
=> 'Referir a',

   'Previous attempts of student (if applicable)'
=> 'Intentos anteriores del estudiante (si está disponible)',

   'Original screen output (if applicable)'
=> 'Pantalla de salida original (si está disponible)',

   'Correct Answer(s) (if applicable)'
=> 'Respuesta(s) Correcta(s) (si está disponible)',

   'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.'
=> 'Mensajes LON-CAPA enviados a usted entre [_1] y [_2] estarán sin acceder hasta el final de este periodo de tiempo, porque es un estudiante en el curso con el bloqueo de comunicaciones activo.',

   'The subject is 

 [_1]

'
=> 'El asunto es 

 [_1]

',

   'Excerpt'
=> 'Extracto',

   'Use 

 [_1]

to access the full message.'
=> 'Usar

 [_1]

para acceder al mensaje completo.',

   'You can reply to this e-mail'
=> 'Puede responder a este E-Mail.',

   'Please do not reply to this address.'
=> 'Por favor no responda a esta dirección.',

   'A reply will not be received by the recipient!'
=> 'La contestación no será recibida por el destinatario!',

   "Include in course's 'User records' for recipient(s)"
=> "Incluir en 'Registro del Usuario' del curso del(os) destinatario(s)",

   'No replies to sender'
=> 'No responder al remitente',

   'Display Message'
=> 'Mostrar Mensaje',

   'Replying to a Message'
=> 'Contestando a Mensaje',

   'Forwarding a Message'
=> 'Reenviando un Mensaje',

   'Forwarding Multiple Messages'
=> 'Reenviando Multiple Mensajes',

   'At end of file some tags were still left unclosed, '
=> 'Al final del archivo algunas etiquetas quedaron aún sin cerrar, ',

   'Upload and Send'
=> 'Cargar y Enviar',

   'Choose which course(s) to list.'
=> 'Escoger que curso(s) listar.',

   'Display courses'
=> 'Mostrar cursos',

   'Public'
=> 'Público',

   'Answer [_1]'
=> 'Respuesta [_1]',

   'EditXML [_1]'
=> 'Editar XML [_1]',

   'Not authorized'
=> 'Sin autorización',

   'An error occurred while processing this resource. The author has been notified.'
=> 'Ocurrió un error mientras se procesaba este recurso. El autor fue notificado.',

   'Code ran too long. It ran for more than'
=> 'La ejecución del código tomó mucho tiempo. Corrió por más de',

   'seconds occurred while running &lt;while&gt; on line'
=> 'segundos, ocurrió mientras se ejecutaba &lt;while&gt; en línea',

   'Student View'
=> 'Vista de Estudiante',

   'Correct answer'
=> 'Respuesta correcta',

   'Could not identify problem.'
=> 'No se pudo identificar problema.',

   'Chart'
=> 'Cuadro',

   'Student Data'
=> 'Datos de Estudiante',

   'HTML, with links'
=> 'HTML, con enlaces',

   'HTML, with all links'
=> 'HTML, todos enlaces',

   'HTML, without links'
=> 'HTML, sin enlaces',

   'Output Data'
=> 'Datos de Salida',

   'Scores Summary'
=> 'Resumen de Puntos',

   'Scores Per Problem'
=> 'Puntos por problema',

   'Parts Correct'
=> 'Parte Correcta',

   'fullname'
=> 'Nombre',

   'id'
=> 'ID/Num.Std.',

   'Generate Chart'
=> 'Generar Cuadro',

   'Generate Graph'
=> 'Generar Gráfica',

   'Select One Student'
=> 'Seleccionar Estudiante',

   'All sections.'
=> 'Secciones Todas.',

   'Section [_1].'
=> 'Sección [_1].',

   'Section [_1]'
=> 'Sección [_1]',

   'Sections [_1] and [_2].'
=> 'Secciones [_1] y [_2].',

   'All groups.'
=> 'Grupos Todos.',

   'Group [_1].'
=> 'Grupo [_1].',

   'Groups [_1] and [_2].'
=> 'Grupos [_1] y [_2].',

   'Active access status.'
=> 'Estado de acceso Activo.',

   'Future access status.'
=> 'Estado de acceso futuro.',

   'Expired access status.'
=> 'Estado de acceso expirado.',

   'Any access status.'
=> 'Cualquier estado de acceso.',

   'Show links in new window:'
=> 'Mostrar enlaces en nueva ventana:',

   'Summary Table'
=> 'Cuadros Sinóptico',

   'Summary Tables'
=> 'Cuadros Sinópticos',

   'Summary table for [_1] ([_2])'
=> 'Cuadros Sinóptico para [_1] ([_2])',

   'Average'
=> 'Promedio',

   'maximum'
=> 'máximo',

   'Maximum'
=> 'Máximo',

   'Max. Total'
=> 'Máx. Total',

   'Median'
=> 'Mediana',

   'Std Dev'
=> 'Des Est',

   'sum'
=> 'suma',

   'maximum possible'
=> 'máximo posible',

   'parts correct'
=> 'partes correctas',

   'Return to the chart'
=> 'Volver al cuadro',

   'Compiled on [_1]'
=> 'Compilado en [_1]',

   "Click on a student's name or username to view their chart"
=> "Pulse en el nombre del estudiante o usuario para ver su desempeño",

   'status'
=> 'estado',

   'groups'
=> 'grupos',

   'Click on a students name or username to view their chart'
=> 'Pulse en el nombre del estudiante o usuario para ver su desempeño',

   'Essay will be hand graded.'
=> 'Ensayos serán corregidos manualmente.',

   'Text you want to appear by default:'
=> 'Texto que desea aparezca por defecto:',

   'Check as many files as you wish in response to the problem:'
=> 'Marque tantos archivos como desee en respuesta al problema:',

   'Select portfolio files'
=> 'Selecionar archivos de portafolio',

   'Select checked files, and continue selecting'
=> 'Selecionar archivos marcados y continuar selección',

   'Select checked files, and close window'
=> 'Selecionar archivos marcados y cerrar ventana',

   'Copy of'
=> 'Copia de',

   'Overall result: [_1]'
=> 'Puntaje Total: [_1]',

   'Dimension: [_1], status [_2] '
=> 'Dimensión: [_1], Estado [_2] ',

   'Queue Status'
=> 'Estado de Cola',

   'Check Mark'
=> 'Selecionar Marcas',

   'Return commented version of [_1] to student.'
=> 'Regresar versión comentada de [_1] a estudiante.',

   'Download All Submitted Documents'
=> 'Descargar Todos los Documentos Enviados',

   'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])'
=> 'Ensayo es [_1]% similar al ensayo por [_2] en curso [_3] (curso ID [_4]:[_5])',

   'Compose message to student'
=> 'Redactar mensaje a estudiante',

   'incl. grades'
=> 'incluir calificación',

   'Message will be sent when you click on Save &amp; Next below.'
=> 'Mensaje será enviado cuando pulse en Guardar &amp; Siguiente debajo.',

   'Set/Change parameters'
=> 'Establecer/Cambiar parámetros',

   'Grading Feedback'
=> 'Evaluando Reacciones',

   'Sending message to [_1]'
=> 'Enviando mensaje a [_1]',

   'Not allowed to modify grades for [_1]'
=> 'No permitido de modificar notas de [_1].',

   'You need to specify the username or the student/employee ID'
=> 'Necesita especificar el usuario o ID/Num.Std.',

   'You need to specify at least one grading field'
=> 'Necesita especificar al menos un campo de evaluación',

   'Specify a file containing the class scores for current resource.'
=> 'Especificar un archivo que contenga las puntuaciones de la clase para el recurso actual.',

   'Upload Scores'
=> 'Cargar Puntuaciones',

   'Some point values were assigned for problems with a weight of zero. These values were ignored.'
=> 'Algunos puntos fueron asignados a problemas con peso ponderado cero. Por tanto, esos puntos fueron ignorados.',

   'Use CODE:'
=> 'Usar CODE:',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Algunos recursos en la secuencia actualmente no están configurados en modo exámen. Calificar esos recursos actualmente podrían no funcionar bien.',

   'scores from file' # Upload scores from file
=> 'puntos de archivo',

   'Process'
=> 'Procesar',

   'clicker file' # Process clicker file
=> 'archivo de clicker',

   'Grade'
=> 'Calificar',

   'bubblesheet forms' # Grade scantron forms
=> 'hoja de respuestas',

   'Verifying Receipt No. [_1]'
=> 'Verificando Recibo No. [_1]',

   'receipt no.'
=> 'recibo Nr..',

   'Manage'
=> 'Administrar',

   'saved CODEs' # View saved CODEs
=> 'CODEs guardados',

   'Specify a file containing the clicker information for this resource.'
=> 'Especificar el archivo con la información de clicker de este recurso.',

   'Upload File'
=> 'Cargar Archivo',

   'Award points just for participation'
=> 'Puntos Extra solo por participación',

   'Correctness determined from response by course personnel'
=> 'Corrección determinada por la respuesta del personal del curso',

   'Correctness determined from response with clicker ID(s)'
=> 'Corrección determinada por la respuesta con ID de Clicker(s)',

   'Correctness determined from given list of answers'
=> 'Corrección determinada por lista de respuestas dadas',

   "Provide comma-separated list. Use '*' for any answer correct, '-' for skip"
=> "Proporcione lista separada por coma. Use '*' para cualquier respuesta correcta, '-' para omitir",

   'Percentage points for correct solution'
=> 'Porcentaje de punto por solución correcta',

   'Percentage points for incorrect solution'
=> 'Porcentaje de punto por solución incorrecta',

   'You need to specify a clicker ID for the correct answer'
=> 'Necesita especificar el ID del Clicker para la respuesta correcta',

   'Score based on attendance only'
=> 'Puntos basados sólo asistencia',

   'Correctness determined by the following IDs'
=> 'Corrección determinada por los siguientes IDs',

   'specified'
=> 'indicó',

   'No IDs found to determine correct answer'
=> 'No se encontró IDs para determinar la respuesta correcta',

   '[_1] Error: [_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.'
=> '[_1] Error: [_2] El archivo que intentó cargar, [_3] no tiene información. Por favor revise que haya entrado el nombre del archivo correcto.',

   'Scanning clicker file'
=> 'Escaneando archivo de clicker',

   'Found [_1] question(s)'
=> 'Se encontró [_1] Pregunta(s)',

   'Awarding [_1] percent for correct and [_2] percent for incorrect responses'
=> 'Adjudicando [_1] porciento por respuesta correcta y [_2] porciento por incorrecta',

   'Clicker registered more than once'
=> 'Clicker registrado más de una vez',

   'Unregistered Clicker'
=> 'Clicker Sin registrar',

   'Found [_1] registered and [_2] unregistered clickers.'
=> 'Clicker encontrados: [_1] registrados y [_2] sin registrar.',

   'Found no correct answers answers for grading!'
=> 'No se encontró respuesta correcta en calificación de respuesta!',

   'Found [_1] entries for grading!'
=> 'Se encontró [_1] entradas a calificar!',

   'Found no questions.'
=> 'No se encontró preguntas.',

   'Finalize Grading'
=> 'Terminar Calificación',

   'Question [_1]'
=> 'Pregunta [_1]',

   'Assigning grades based on clicker file'
=> 'Asignando notas basado en archivo de clicker',

   'More than one correct result given for question "[_1]": [_2] versus [_3].'
=> 'Más de un resultado correcto dado a pregunta "[_1]": [_2] contra [_3].',

   'No correct result given for question "[_1]"!'
=> 'No hay resultado correcto para pregunta "[_1]"!',

   'Correct answer: [_1]'
=> 'Respuesta correcta: [_1]',

   'Successfully stored grades for [quant,_1,student].'
=> 'Se guardó exitósamente las notas para [quant,_1,estudiante,estudiantes].',

   'Grading Menu'
=> 'Menu de Calificación',

   'Missing tags, unable to properly run file.'
=> 'Faltan etiquetas(tags), no es posible ejecutar archivo apropiadamente.',

   'Using tag [_1] on line [_2] as end tag to [_3]'
=> 'Usando etiqueta [_1] en línea [_2] asi como terminar etiqueta en [_3]',

   'Found tag [_1] on line [_2] when looking for [_3] in file.'
=> 'Se encontró etiqueta [_1] en línea [_2] cuando se buscaba por [_3] en archivo.',

   'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -'
=> 'ID/Num.Std. [_1] contiene caracteres inválidos, los IDs/Num.Std. solo pueden tener letras, números, espacios y -',

   'File not found: [_1]'
=> 'Archivo no encontrado: [_1]',

   'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.'
=> 'Este archivo parece ser una prestación de un recurso LON-CAPA. Si esto es cierto, este recurso respoderá muy extraña e incorrectamente.',

   'An error occurred while processing this resource. The instructor has been notified.'
=> 'Ocurrió un error mientras se procesaba este recurso. El instructor fue notificado.',

   'CourseID'
=> 'Curso-ID',

   'DocID'
=> 'Documento-ID',

   'Username, password and domain need to be specified.'
=> 'Usuario, contraseña y dominio debe ser especificados.',

   'Untitled Resource'
=> 'Recurso sin título',

   'Not Available'
=> 'No Disponible',

   'Clear'
=> 'Limpiar',

   'There are no parameters.'
=> 'No hay parámetros.',

   'enroll type/action'
=> 'registro tipo/acción',

   '<br />Map not loaded: The file <tt>[_1]</tt> does not exist.'
=> '<br />Mapa no cargado: El archivo <tt>[_1]</tt> no existe.',

   'Saved.'
=> 'Guardado.',

   'An error occurred while saving.'
=> 'Ocurrió un error mientras se guardaba.',

   'Reverted.'
=> 'Revertido.',

   'Title in map'
=> 'Título en mapa',

   'Filename of resource'
=> 'Nombre del recurso',

   'Link to published resource'
=> 'Enlace a recurso publicado',

   'Link to resource in Construction Space'
=> 'Enlace al recurso en Zona de construción',

   'Resource space'
=> 'Zona de Recurso',

   'Construction space'
=> 'Zona de Construcción',

   'No such directory: [_1]'
=> 'No hay tal directorio: [_1]',

   'discard'
=> 'desechar',

   'Change Order'
=> 'Cambiar el Orden',

   'Sort Imported Resources'
=> 'Ordenar los Recursos importados',

   'Finalize order of resources'
=> 'Finalizar orden de recursos',

   'Recover Deleted'
=> 'Recuperar Borrado',

   'Recover Removed Resources'
=> 'Recuperar Recursos Eliminados',

   'Recover Checked'
=> 'Recuperar Marcados',

   'Import Resources from Bookmarks'
=> 'Importar Recursos desde Marcadores',

   'There are no resources in your bookmarks to import.'
=> 'No hay recursos en sus marcadores (favoritos) para importar.',

   'Import Checked'
=> 'Importar Marcados',

   'Recent Detailed Assessment Statistical Data'
=> 'Datos Recientes de Evaluación Estadística Detallada',

   'No information available'
=> 'No hay información disponible',

   'Creating new file [_1]'
=> 'Creando archivo nuevo [_1]',

   'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".'
=> 'Si quiesiera asociar este recurso ([_1]) con un curso actual o anterior, por favor seleccionar uno de la lista de abajo, sino seleccionar, "Ninguno".',

   'Associate Resource With Selected Course'
=> 'Asociar Recurso con Curso Seleccionado',

   'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.'
=> 'Este curso es actualmente asociado con el curso ([_1]) el cual incluye campos adicionales de metadatos específicos al curso.',

   'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.'
=> 'Puede elegir transferir datos de los campos adicionales a  los campos de "Notas" si esta planeado cambiar la asociación del curso.',

   'not available'
=> 'no disponible',

   'most recent version'
=> 'versión más reciente',

   'information not available'
=> 'información no disponible',

   'Num Student'
=> 'Num. Estudiante',

   'Num Students'
=> 'Num. Estudiantes',

   'Degree of Difficulty'
=> 'Grado de Dificultad',

   'Degree of Discrimination'
=> 'Grado de Discriminación',

   'Time of computation'
=> 'Tiempo de computo',

   'Messages deleted.'
=> 'Mensajes borrados.',

   'Error deleting messages'
=> 'Error borrando mensajes',

   'Messages cleared.'
=> 'Mensajes eliminados.',

   'Error clearing messages'
=> 'Error eliminado mensajes',

   'Delete Messages for this Resource'
=> 'Borrar Mensajes para este Recurso',

   'Back To Directory'
=> 'Volver al Directorio',

   'Associated with course [_1]'
=> 'Asociado con curso [_1]',

   'This resource is not associated with a course.'
=> 'Este recurso no esta asociado con un curso.',

   'Discard Edits and Return to Portfolio'
=> 'Descartar cambios y Volver al Portafolio',

   'Could not transfer data in added fields to notes'
=> 'No se pudo transferir datos in campos adicionales a  "Notas"',

   'Transferred data in added fields to notes'
=> 'Datos de campos adicionales transferidos a "Notas"',

   'Home'
=> 'Dir. Local',

   'Usage Statistics'
=> 'Estadísticas de Uso',

   'Courses/Network Hits'
=> 'Cursos/Red Número de visitas',

   'Already in this course:<br />[_1] in folder/map [_2].<br />'
=> 'Ya está en este curso:<br />[_1] en folder/mapa [_2].<br />',

   'External Resource, preview not enabled'
=> 'Recurso Externo, vista previa no activada',

   'Somewhere something went wrong'
=> 'En alguna parte algo esta mal',

   'Please help us to find out what.'
=> 'Por favor ayudanos a encontrar resolverlo.',

   'Please take a moment to fill out the form below.'
=> 'Por favor, tome un momento para llenar la forma de abajo.',

   'Your information, together with internal debugging information, will be e-mailed to the system and server administrators.'
=> 'Su información, junto a la información de depuración interna, será enviada a los administradores del sistema y servidor.',

   'Send Information'
=> 'Información enviada',

   'Please describe what you did just before this screen came up'
=> 'Por favor describa que hizo momentos antes que esta pantalla apareciera.',

   'Is this problem reproducible?'
=> '¿Es este problema reproducible?',

   'Yes!'
=> 'Si!',

   'Do you have any guesses why this might have happened?'
=> 'Tiene alguna idea de ¿por que esto pudo ocurrir?',

   'Thank you for your help!'
=> 'Gracias por su asistencia!',

   'Internal info:'
=> 'Info  Interna:',

   'Report submitted'
=> 'Reporte enviado',

   'Sending Error Report'
=> 'Enviando Reporte de Error',

   'Thank you!'
=> 'Gracias!',

   'Warning: Report not submitted'
=> 'Advertencia, Reporte no enviado.',

   'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.'
=> 'Los adminstradores del dominio [_1] no establecieron una dirección de e-mail para recibir su reporte de error.',

   'The document contains errors and cannot be published.'
=> 'El documento contiene errores y no puede se publicado.',

   'error(s)'
=> 'error(es)',

   'Please fill out all fields below.'
=> 'Por favor llene todos los campos de abajo.',

   'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.'
=> 'Atención: esta carpeta está configurada para seleccionar al azar un subconjunto de recursos. Añadiendo o eliminando recursos de esta carpeta cambiará el conjunto de recursos que los estudiantes verán, resultando en extra o falta de crédito para problemas completados, not limitados a aquellos que modificó el contenido de esta carpeta. No modifique el contenido de esta carpeta si esta activada para usarse por los estudiantes.',

   'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.'
=> 'Atención: esta carpeta está configurada para ordenar al azar su contenido. Añadiendo o eliminando recursos de esta carpeta cambiará el orden de recursos mostrados.',

   'Parameters'
=> 'Parámetros',

   'Parameters:'
=> 'Parámetros:',

   'Total Score and Maximum Possible for each Sequence or Folder'
=> 'Puntaje Total y Máximo posible para cada Secuencia o Carpeta',

   'Score on each Problem Part'
=> 'Puntaje en cada Parte del Problema',

   'Number of Tries before success on each Problem Part'
=> 'Número de Intentos antes de acertar en cada Parte del Problema',

   'Number of Problem Parts completed successfully'
=> 'Número de Partes del Problema completadas exitosamente',

   'Unable to retrieve course information.'
=> 'No se pudo recuperar información del curso',

   'Please select an action to perform using the new filename'
=> 'Por favor seleccione una acción a ejecutar usando el archivo nuevo',

   'View or modify a course'
=> 'Ver o modificar un curso',

   'Enter the course with the role of [_1]'
=> 'Entrar el curso con función de usuario de [_1].',

   'Enter the course with the role of [_1].'
=> 'Entrar el curso con función de usuario de [_1].',

   'View or modify course settings which only a [_1] may modify.'
=> 'Ver o modificar parámetros del curso que solo un [_1] puede cambiar.',

   'Manage course users'
=> 'Control de usuarios del curso',

   'Upload a File of Course Users'
=> 'Cargar un Archivo con usuarios para el Curso',

   'Add/Modify a Course User'
=> 'Añadir/Modificar un (1) usuario del Curso',

   'Edit Custom Roles'
=> 'Editar Función de Usuario Personalizado',

   'Enroll a Single Student'
=> 'Registar un Solo Estudiante',

   'Enroll a student'
=> 'Registar un Estudiante',

   'Automated Enrollment Manager'
=> 'Control de Registro Automatizado',

   'Manage Course Groups'
=> 'Control de Grupos del Curso',

   'This error occurred while processing response [_1] in part [_2]'
=> 'Este error ocurrió mientras se procesaba respuesta [_1] en parte [_2]',

   'This error occurred while processing part [_1]'
=> 'Este error ocurrió mientras se procesaba parte [_1]',

   'Unable to find section for this student'
=> 'No se pudo encontrar la sección de este estudiante',

   'Classlist update for "[_1]" in "[_2]".'
=> 'Actualizar lista de clase para "[_1]" en "[_2]".',

   'Error: "[_1]" during classlist update for "[_2]" in "[_3]".'
=> 'Error: "[_1]" durante actualización de lista de clase para "[_2]" en "[_3]".',

   'Role: '
=> 'Función de usuario: ',

   'Identify fields in uploaded list'
=> 'Identificar campos en lista cargada',

   'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.'
=> 'Entrar tantos campos como pueda.<br /> El sistema le informará y lo regresará a esta página,<br /> si los datos seleccionados son insuficientes para añadir usuarios.',

   'Default domain'
=> 'Dominio Asignado',

   'Change authentication for existing users in domain "[_1]" to these settings?'
=> 'Cambiar autenticación para usuarios existentes en dominio "[_1]" a estos parámetros?',

   'LON-CAPA Home Server for New Users'
=> 'Servidor de Origen LON-CAPA para usuarios nuevos',

   'LON-CAPA domain: [_1] with home server:'
=> 'LON-CAPA dominio: [_1] con servidor de origen:',

   'Settings for assigning roles'
=> 'Parámetros para asignar funciones de usuario',

   'Pick the action to take on roles for these users:'
=> 'Elija la acción a tomar en la funciones para estos usuarios:',

   'No role changes'
=> 'Sin cambios en las funciones',

   'Add a domain role'
=> 'Añadir un dominio para función de usuario',

   'Add a course role'
=> 'Añadir un curso para función de usuario',

   'Default role'
=> 'Función de usuario asignado',

   'Choose the role to assign to users without a value specified in the uploaded file.'
=> 'Elija la función a asignar a usuarios sin un valor específico en el archivo cargado.',

   'Default role and section'
=> 'Función de usuario y sección asignado',

   'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.'
=> 'Elija la función y/o sección(es) a asignar a usuarios sin un valor específico en el archivo cargado.',

   'Default role and/or section(s)'
=> 'Función de usuario y/o sección(es) asignados',

   'Role and/or section(s) for users without values specified in the uploaded file.'
=> 'Función y/o sección(es) para usuarios sin un valor específico en el archivo cargado.',

   'Display students with current/future access who are not in the uploaded file.'
=> 'Visualizar estudiantes con acceso actual/futuro que no estan en el archivo cargado.',

   'Students selected from this list can be dropped.'
=> 'Estudiantes seleccionados de esta lista pueden ser retirados.',

   'Update student/employee ID in courses in which user is active/future student,[_1](if forcing change).'
=> 'Actualizar ID Estudiante/Empleado en cursos en los cuales el usuario es estudiante actual/futuro,[_1] (si fuerza el cambio).',

   'make these dates the default access dates for future student enrollment'
=> 'hacer estas fechas las fechas por defecto de acceso para registro de estudiantes futuros.',

   'Set default start and end access dates for course.'
=> 'Establecer las fechas de inicio y término de acceso del curso',

   'Unable to set default access dates for course.'
=> 'No se pudo establecer fechas de acceso del curso',

   'Please select'
=> 'Por favor seleccionar',

   'User Status: [_1]'
=> 'Estatus Usuario: [_1]',

   'Role Type: [_1]'
=> 'Tipo de Función de usuario: [_1]',

   'Any role'
=> 'Cualquier función de usuario',

   'Role: [_1]'
=> 'Función de usuario: [_1]',

   'Select Course(s)'
=> 'Seleccionar Curso(s)',

   'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.'
=> 'Advertencia: la recuperaación de datos para cursos multiples puede llevar algún tiempo, ya que esta operación no está actualmente optimizada.',

   'There are no co-authors to display.'
=> 'No hay co-autores que mostrar.',

   'There are no users with domain roles to display.'
=> 'No hay usuarios con funciones de dominio que mostrar.',

   'There are no authors or co-authors to display.'
=> 'No hay autores o co-autores que mostrar.',

   'There are no course users to display'
=> 'No hay usuarios de curso que mostrar',

   'There are no course users to display.'
=> 'No hay usuarios de curso que mostrar.',

   'There are no users matching the search criteria.'
=> 'No hay usuarios que coincidan con el criterio de búsqueda.',

   "You must select at least one user by checking a user's 'Select' checkbox"
=> "Debe seleccionar al menos un usuario marcando 'Seleccionar' en la caja de seleccion del usuario.",

   'You need to select an action to take for the user(s) you have selected'
=> 'Necesita seleccionar una acción a tomar para el(o los) usuario(s) que ha seleccionado',

   ' for a single user?'
=> ' para un usuario?',

   ' for multiple users?'
=> ' para varios usuarios?',

   'Proceed'
=> 'Proceda',

   'Action to take for selected users'
=> 'Acción a tomar para los usuarios seleccionados',

   'Behavior of clickable username link for each user'
=> 'Respuesta al pulsar el enlace web del usuario',

   "Display a user's personal information page"
=> "Mostrar la página de información personal del usuario",

   "Modify a user's information"
=> "Modificar la información del usuario",

   'Course(s): description, section(s), status'
=> 'Curso(s): descripción, sección(es), estatus',

   "Click on a username to view the user's personal information page."
=> "Pulsar en el usuario para ver la página de información personal del usuario.",

   'auto'
=> 'automático',

   'manual'
=> 'manual',

   'Unlock'
=> 'Desbloquear',

   'Lock'
=> 'Bloquear',

   'Domain Roles'
=> 'Funciones de Dominio',

   'Co-Author Roles'
=> 'Función de Coautor',

   'Course Roles'
=> 'Funciones de Curso',

   'Date and Section selector'
=> 'Selector de Fecha y Sección',

   'Date selector'
=> 'Selector de Fecha',

   "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'"
=> "Selecciones todos los usuarios a quienes se les revocará las funciones de usuario, y pulse 'Proceda'",

   "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'"
=> "Selecciones todos los usuarios a quienes se borrarán las funciones de usuario, y pulse 'Proceda' ",

   'Choose an action to take for selected users'
=> 'Elija una acción a tomar para los usuarios seleccionados',

   'New section to assign'
=> 'Sección Nueva a asignar',

   'Use "Save" to update the main window with your selections.'
=> 'Usar "Guardar" para actualizar la ventana pricipal con sus selecciones.',

   'New section'
=> 'Sección Nueva',

   'Course - [_1]:'
=> 'Curso - [_1]:',

   'Domain - [_1]:'
=> 'Dominio - [_1]:',

   'Users in course with expired [_1] roles'
=> 'Usuarios del curso con funciones de usuario [_1] expiradas',

   'Users in course with future [_1] roles'
=> 'Usuarios del curso con funciones de usuario [_1] futuras',

   'Users in course with active [_1] roles'
=> 'Usuarios del curso con funciones de usuario [_1] activas',

   'All users in course'
=> 'Todos los usuarios del curso',

   'All users in course with [_1] roles'
=> 'Todos los usuarios del curso con funciones de usuario [_1]',

   'only users in section "[_1]"'
=> 'solo usuarios en sección "[_1]"',

   'only users affiliated with no section or section "[_1]"'
=> 'solo usuarios afiliados sin sección o sección "[_1]"',

   ' and not in any group'
=> ' y sin grupo',

   ' and members of group: "[_1]"'
=> ' y miembros del grupo "[_1]"',

   'only users affiliated with no section'
=> 'solo usuarios afiliados sin sección',

   'only users affiliated with section "[_1]"'
=> 'solo usuarios afiliados sin sección "[_1]"',

   'only users not in any group'
=> 'solo usuarios sin grupo',

   ' and also not in any group'
=> ' y también sin grupo',

   'only members of group: "[_1]"'
=> 'solo miembros del grupo: "[_1]"',

   ' and also members of group: "[_1]"'
=> ' y también miembros del grupo: "[_1]"',

   'Author space for [_1]'
=> 'Zona de autor para [_1]',

   'Co-authors with expired [_1] roles'
=> 'Co-autores con funciones de usuario "[_1]" expirado',

   'Co-authors with future [_1] roles'
=> 'Co-autores con funciones de usuario "[_1]" futuro',

   'Co-authors with active [_1] roles'
=> 'Co-autores con funciones de usuario "[_1]" activo',

   'All co-authors'
=> 'Todos los co-autores',

   'All co-authors with [_1] roles'
=> 'Todos los co-autores con funciones de usuario "[_1]"',

   'Users in domain with expired [_1] roles'
=> 'Usuarios en dominio con funciones de usuario "[_1]" expirados',

   'Users in domain with future [_1] roles'
=> 'Usuarios en dominio con funciones de usuario "[_1]" futuros',

   'Users in domain with active [_1] roles'
=> 'Usuarios en dominio con funciones de usuario "[_1] activos"',

   'All users in domain'
=> 'Todos los usuarios del dominio',

   'All users in domain with [_1] roles'
=> 'Todos los usuarios del dominio con funciones de usuario "[_1]"',

   'Co-authors in domain with expired [_1] roles'
=> 'Co-autores del dominio con funciones de usuario "[_1]" expirados',

   'Co-authors in domain with future [_1] roles'
=> 'Co-autores del dominio con funciones de usuario "[_1]" futuros',

   'Co-authors in domain with active [_1] roles'
=> 'Co-autores del dominio con funciones de usuario "[_1]" activos',

   'All users with co-author roles in domain'
=> 'Todos los usuarios con funciones de co-autor del dominio ',

   'All co-authors in domain  with [_1] roles'
=> 'Todos los co-autores del dominio con funciones del usuario "[_1]"',

   'Courses in domain with institutional code: [_1]'
=> 'Cursos del dominio con código institucional "[_1]"',

   'Selected courses in domain'
=> 'Cursos seleccionados del dominio',

   'All courses in domain'
=> 'Todos los cursos del dominio',

   'users with expired [_1] roles'
=> 'usuarios con funciones de usuario "[_1]" expirado',

   'users with future [_1] roles'
=> 'usuarios con funciones de usuario "[_1]" futuro',

   'users with active [_1] roles'
=> 'usuarios con funciones de usuario "[_1]" activo',

   'all users'
=> 'todos los usuarios',

   'users with [_1] roles'
=> 'usuarios con funciones de usuario "[_1]"',

   'There are no students to drop.'
=> 'No hay estudiantes para retirar.',

   'Upload a file containing information about users'
=> 'Cargar archivo con información sobre los usuarios',

   'Please upload an UTF8 encoded file to ensure a correct character encoding in your classlist.'
=> 'Por favor cargar un archivo codificado UTF8 para asegurar una codificación de caracteres adecuada para su lista de clase.',

   'Upload file of users'
=> 'Cargar archivo de usuarios',

   'How do I create a users list from a spreadsheet'
=> '¿Cómo creo una lista de usuarios a partir de una hoja de cálculo?',

   'Unable to enroll users'
=> 'No se pudo registrar usuarios',

   'No Kerberos domain was specified.'
=> 'El dominio Kerberos no fue especificado',

   'Enrolling Users'
=> 'Registrando Usuarios',

   'Updating Co-authors'
=> 'Actualizando Co-autores',

   'Adding/Modifying Users'
=> 'Añadiendo/Modificando Usuarios',

   'Default section name [_1] could not be used as it is a reserved word.'
=> 'El nombre definido de la sección [_1] no puede usarse por ser una palabra reservada.',

   'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.'
=> 'El nombre predefinido de la sección [_1] es el nombre de un grupo del curso. Nombres de secciones y grupos deben ser diferentes.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.'
=> '[_1]: No se pudo registar usuario [_2] [_3] [_4] [_5] en la sección "[_6]" - esta es una palabra reservada.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.'
=> '[_1]: No se pudo registar usuario [_2] [_3] [_4] [_5] en la sección "[_6]" - esta es un grupo del curso.',

   'Section names and group names must be distinct.'
=> 'Nombres de sección y nombres de grupo deben ser distintos.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".'
=> '[_1]: No se pudo registar usuario [_2] [_3] [_4] [_5] en la sección "[_6]".',

   'This user already has an active/future student role in the course, unaffiliated to any section.'
=> 'Este usuario actualmente tiene una función de estudiante activa/futura en el curso, si afiliación a sección alguna.',

   'This user already has an active/future role in section "[_1]" of the course.'
=> 'Este usuario actualmente tiene una función activa/futura en la sección "[_1]" del curso.',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.'
=> 'A pesar que su función actual tiene privilegios para añadir estudiantes a la sección "[_1]", Usted no tiene privilegios para modificar registros existentes en otras secciones.',

   '[_1]: You do not have permission to add the requested role [_2] for the user.'
=> '[_1]: No tiene permiso de añadir la función solicitada "[_2]" para el usuario.',

   'Allowable role(s) is/are: [_1].'
=> 'Funcion(es) permitida(s) es(son): [_1]',

   '[_1]: Unable to enroll. No password specified.'
=> '[_1]: No se pudo inscribir. Contraseña sin especificar.',

   '[_1]: Unable to add co-author. No password specified.'
=> '[_1]: No se pudo añadir co-autor. Contraseña sin especificar.',

   '[_1]: Unable to add user. No password specified.'
=> '[_1]: No se pudo añadir usuario. Contraseña sin especificar.',

   'Processed [quant,_1,user].'
=> 'Procesado [quant,_1,usuario].',

   'Roles added for [quant,_1,user].'
=> 'Funciones añadidas para [quant,_1,usuario,usuarios].',

   'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.'
=> 'Si un usuario esta actualmente conectado a LON-CAPA, cualquier función nueva que se active estará disponible la próxima vez que se conecte.',

   'No roles added'
=> 'No se añadieron funciones',

   'Authentication changed for [_1] existing users.'
=> 'Autenticación cambiada para [_1] usuarios existentes.',

   'Students to Drop'
=> 'Estudiantes a Retirar',

   'There are no students with current/future access to the course.'
=> 'No hay estudiantes con acceso actual/futuro al curso.',

   '[_1]: Unable to add/modify: [_2]'
=> '[_1]: No se pudo añadir/modificar: [_2]',

   '[_1]: Unable to modify authentication: [_2]'
=> '[_1]: No se pudo modificar autenticación: [_2]',

   '[_1]: Unable to add role: [_2]'
=> '[_1]: No se pudo añadir función: [_2]',

   'No change in section assignment (none)'
=> 'Sin cambios la asignación de sección (ninguno)',

   "Revoked role of '[_1]' in [_2] for [_3]"
=> "Función de '[_1]' Revocada en [_2] para [_3]",

   "Deleted role of '[_1]' in [_2] for [_3]"
=> "Función de '[_1]' Borrada en [_2] para [_3]",

   "Re-enabled role of '[_1]' in [_2] for [_3]"
=> "Función de '[_1]' Reactivada en [_2] para [_3]",

   "Activated role of '[_1]' in [_2] for [_3]"
=> "Función de '[_1]' activada en [_2] para [_3]",

   "Changed Access Dates for role of '[_1]' in [_2] for [_3]"
=> "Fechas de Acceso Cambiados para funciones de '[_1]' en [_2] para [_3]",

   "Changed section for role of '[_1]' in [_2] for [_3]"
=> "Sección Cambiada para función de '[_1]' en [_2] para [_3]",

   "Dropped role of '[_1]' in [_2] for [_3]"
=> "Función de '[_1]' Retirada en [_2] para [_3]",

   'Error revoking [_1] in [_2] for [_3]: [_4].'
=> 'Error revocando [_1] en [_2] para [_3]: [_4].',

   'Error deleting [_1] in [_2] for [_3]: [_4].'
=> 'Error eliminando [_1] en [_2] para [_3]: [_4].',

   'Error re-enabling [_1] in [_2] for [_3]: [_4].'
=> 'Error re-activando [_1] en [_2] para [_3]: [_4].',

   'Error activating [_1] in [_2] for [_3]: [_4].'
=> 'Error activando [_1] en [_2] para [_3]: [_4].',

   'Error changing access dates for [_1] in [_2] for [_3]: [_4].'
=> 'Error cambiando fechas de acceso para [_1] en [_2] para [_3]: [_4].',

   'Error changing section for [_1] in [_2] for [_3]: [_4].'
=> 'Error cambiando sección para [_1] en [_2] para [_3]: [_4].',

   'Error dropping [_1] in [_2] for [_3]: [_4].'
=> 'Error retirando [_1] en [_2] para [_3]: [_4].',

   'Revoked role(s) for [quant,_1,user,users,no users].'
=> 'Funcion(es) revocada(s) para [quant,_1,usuario,usuarios,sin usuarios].',

   'Deleted role(s) for [quant,_1,user,users,no users].'
=> 'Funcion(es) eliminada(s) para [quant,_1,usuario,usuarios,sin usuarios].',

   'Re-enabled role(s) for [quant,_1,user,users,no users].'
=> 'Funcion(es) re-activada(s) para [quant,_1,usuario,usuarios,sin usuarios].',

   'Activated role(s) for [quant,_1,user,users,no users].'
=> 'Funcion(es) activada(s) para [quant,_1,usuario,usuarios,sin usuarios].',

   'Changed Access Dates for role(s) for [quant,_1,user,users,no users].'
=> 'Fechas de Acceso Cambiada para funcion(es) de [quant,_1,usuario,usuarios,sin usuarios].',

   'Changed section for role(s) for [quant,_1,user,users,no users].'
=> 'Secciones cambiadas para funcion(es) de [quant,_1,usuario,usuarios,sin usuarios].',

   'Dropped role(s) for [quant,_1,user,users,no users].'
=> 'Funcion(es) retirada(s) de [quant,_1,usuario,usuarios,sin usuarios].',

   'Re-enabling will re-activate data for the role.'
=> 'Re-activando también reactivará los datos para la función.',

   'Display User Lists'
=> 'Mostrar Lista de Usuarios',

   'Display current class roster'
=> 'Mostrar lista actual de clase',

   'No section'
=> 'Sin sección',

   'List Users'
=> 'Lista de Usuarios',

   'Pick custom role'
=> 'Elija función personalizada',

   'Advanced Role'
=> 'Función Avanzada',

   "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages"
=> "Crear Notas de Usuario, Mostrar todas la notas de usuario, Cara a Cara, Mensajes Críticos, Mensajes Emitidos",

   'Evade communication blocking'
=> 'Evadir bloqueo de comunicación',

   'Generate anonymous statistics'
=> 'Generar estadísticas anónimas',

   'Modify grade queue'
=> 'Modificar lista de notas',

   'Grade items in grading queue'
=> 'Calificar artículos en lista de notas',

   'Set assessment parameters'
=> 'Establecer parámetros de desempeño',

   'Advanced printing options (with answers, discussions, all foils, ...)'
=> 'Opciones de impresión avanzada(con respuesta, discusiones, todas la variantes, ...)',

   'Print for other users and entire course'
=> 'Imprimir para otro usuario y curso entero',

   'Get identity behind anonymous postings'
=> 'Obtener identidad detrás de mensajes anónimos',

   'View grades'
=> 'Ver Notas',

   "Access to What's New Page"
=> "Acceso a página ¿Qué hay de Nuevo?",

   'Upload Users List'
=> 'Cargar lista de usuarios',

   'Update Users'
=> 'Actualizar Usuarios',

   'Create/modify a user'
=> 'Crear/modificar un usuario',

   'Search for a user and modify/add user information or roles'
=> 'Buscar un usuario y modificar/añadir información del usuario o funciones',

   'Add/modify a single user'
=> 'Añadir/modificar un usuario',

   'Create users or modify the roles and privileges of users'
=> 'Crear usuarios o modificar las funciones y privilegios de usuarios',

   'Upload a File of Users'
=> 'Cargar un archivo de usuarios',

   'Add/Modify a User'
=> 'Añadir/Modificar un usuario',

   'create new user if required'
=> 'crear nuevo usuario si es necesario',

   'Manage Users'
=> 'Control de Usuarios',

   'Create/Modify user'
=> 'Crear/Modificar usuario',

   'Visible input'
=> 'Entrada visible',

   'Currently in use'
=> 'Actualmente en uso',

   'Modify this user: [_1]'
=> 'Modificar este usuario: [_1]',

   'Blank Problem'
=> 'Problema en Blanco',

   'Chemical Reaction Response'
=> 'Respuesta Reacción Química',

   'Chemical Reaction Response with Hints'
=> 'Respuesta Reacción Química con sugerencias',

   'Click-On-Image Problem'
=> 'Problema Pulse-en-Imagen',

   'Curve Plot with Numerical Response'
=> 'Gráfica dinámica con Respuesta Numérica',

   'Custom Response with Partial Credit'
=> 'Personalizar Respuesta con Créditos Parciales',

   'Custom Response'
=> 'Personalizar Respuesta',

   'Data Plot with Numerical Response'
=> 'Gráfica de Datos con Respuesta Numérica',

   'Drop Box'
=> 'Caja de Respuesta',

   'Essay Response'
=> 'Respuesta tipo Ensayo',

   'Exam Upload Resource'
=> 'Recurso para Cargas Examen',

   'Formula Response using Computer Algebra System'
=> 'Respuesta tipo Fórmula usando el Sistema de Algebra de Computadora',

   'Formula Response using Computer Algebra System and Hints'
=> 'Respuesta tipo Fórmula usando el Sistema de Algebra de Computadora con sugerencias',

   'Formula Response using Computer Algebra System R and Data Plot'
=> 'Respuesta tipo Fórmula usando el Sistema de Algebra de Computadora R y Datos Graficados',

   'Formula Response with Samples'
=> 'Respuesta tipo Fórmula con ejemplos',

   'Unordered Multi-Answer Formula Response Problem'
=> 'Problema de respuesta tipo Fórmula Multi-respuesta sin ordenar',

   'Math Response using Computer Algebra System MAXIMA'
=> 'Respuesta Matemática usando el Sistema de Algebra de Computadora MAXIMA (mathresponse)',

   'Math Response using Computer Algebra System R'
=> 'Respuesta Matemática usando el Sistema de Algebra de Computadora R (mathresponse)',

   'Math Response using Computer Algebra System and Hints'
=> 'Respuesta Matemática usando el Sistema de Algebra de Computadora con sugerencias (mathresponse)',

   'Numerical Response'
=> 'Respuesta Numérica',

   'One of Multiple Answers Numerical Problem'
=> 'Problema Numérico Uno de Multiple respuestas',

   'Option Response - Matching'
=> 'Respuesta de Opción - Coincidencias (Option Response - Matching)',

   'Option Response - Concept Groups'
=> 'Respuesta de Opción - Grupos de Concepto  (Option Response - Concept Groups)',

   'Matching Response'
=> 'Respuesta de Pareo (Matching Response)',

   'Option Response - True/False'
=> 'Respuesta de Opción - Cierto/Falso (Option Response - True/False)',

   'Organic Material Response'
=> 'Respuesta Material Orgánico',

   'Organic Material Response with Hint'
=> 'Respuesta Material Orgánico con sugerencias',

   'Radio Button Response'
=> 'Respuesta de Selección (radiobutton)',

   'Randomly Labelled Image with Option Response'
=> 'Imagen con etiquetas aleatorias con Respuesta de Opción (Randomly Labelled Image)',

   'Rank Response'
=> 'Respuesta Ordenada (Rank Response)',

   'String Response'
=> 'Respuesta Concatenada (String Response)',

   'Display catalog of courses and communities'
=> 'Ver catálogo de cursos y comunidades', # 'Ver catálogo de cursos',

   'Manage co-authors'
=> 'Control de co-autores',

   'Upload a File of Co-authors'
=> 'Cargar un Archivo de Co-autores',

   'Add/Modify a Co-author'
=> 'Añadir/Modificar un Co-autor',

   'Manage Co-authors'
=> 'Control de Co-autores',

   'No courses match the criteria you selected.'
=> 'No hay cursos que coincidan con el criteria que seleccionó.',

   'Key authority (<tt>id@domain</tt>) if other than course'
=> 'Llave de autoridad (<tt>id@dominio</tt>), si no es el curso',

   'New bridgetask file'
=> 'Nuevo archivo "Bridgetask"',

   'Create problem'
=> 'Crear problema',

   'Create library'
=> 'Crear biblioteca',

   'Create survey'
=> 'Crear encuesta',

   'Create task'
=> 'Crear "Bridgetask"',

   'Problem Testing'
=> 'Problema de Prueba',

   "Don't Show Incorect/Correct Feedback"
=> "No mostrar reacción Incorrecto/Correcto",

   "Don't Show Any Feedback"
=> "No mostrar reacción alguna",

   'Change View'
=> 'Cambiar Vista',

   'Show Default View'
=> 'Mostrar Vista Estandar',

   '[_1] for [_2] versions.'
=> '[_1] a [_2] versiones.',

   'Set new screenname to '
=> 'Establecer nuevo nombre de pantalla ',

   'Reset screenname.'
=> 'Reiniciar nombre de ventana de chat.',

   'Set new nickname to '
=> 'Establecer apodo a',

   'Reset nickname.'
=> 'Reiniciar apodo.',

   'Reset '
=> 'Reiniciar',

   'Set message forwarding to '
=> 'Establecer reenvío de mensaje a',

   "Set message forwarding to 'off'."
=> "Establecer reenvío de mensaje a 'apagado'.",

   'Set non-critical message notification address(es) to '
=> 'Establecer direccion(es) de notificación de mensajes no-crítico a',

   "Set non-critical message notification to 'off'."
=> "Establecer direccion(es) de notificación de mensajes no-crítico a 'apagado'.",

   'Set critical message notification address(es) to '
=> 'Establecer direccion(es) de notificación de mensajes crítico a ',

   "Set critical message notification to 'off'."
=> "Establecer direccion(es) de notificación de mensajes crítico a 'apagado'.",

   'Set address(es) to receive excerpts with html retained '
=> 'Establecer direccion(es) para recibir extractos con html retenido ',

   'Set notification address to receive excerpts with html stripped.'
=> 'Establecer dirección para recibir extractos con html removido.',

   'Set all notification addresses to receive excerpts with html stripped.'
=> 'Establecer todas las direcciones de notificación para recibir extractos con html removido.',

   'Freezing Role: [_1]'
=> 'Congelando Función: [_1]',

   'Unfreezing Role: [_1]'
=> 'Descongelando Función: [_1]',

   'No such user: '
=> 'No hay tal usuario: ',

   'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Lo siento, el URL provisto para completar el reinicio de su contraseña fue inválido. O el recibo incluído en el URL se a borrado o el URL provisto era inválido. Por favor envie una [_1]nueva solicitud[_2] para reiniciar su contraseña, y siga el enlace web al nuevo URL incluído en el e-mail que le será enviado, para permitirle entrar una nueva contraseña.',

   'Sorry, the token generated when you requested a password reset has expired.'
=> 'Lo siento, el recibo generado cuando solicitó reiniciar su contraseña ha expirado.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information.'
=> 'Lo siento, el URL generado cuando solicitó reiniciar su contraseña contiene información incompleta.',

   'Page requested in unexpected context'
=> 'Página solicitada en contexto inesperado',

   'Invalid username and/or domain'
=> 'Usuario inválido y/o dominio',

   'Username and domain were blank'
=> 'Usuario y dominio estaban en blanco',

   'Authentication type for this user can not be changed by this mechanism'
=> 'Tipo de autenticación para este usuario no puede cambiarse por este mecanismo',

   'One or more password fields were blank'
=> 'Uno o más campos de la contraseña estaban en blanco',

   'Please log out and try again.'
=> 'Por favor desconectese y trate otra vez.',

   'Please try again later.'
=> 'Por favor trate otra vez más tarde.',

   'Unable to retrieve saved token for password decryption'
=> 'No se puede recuperar recibo guardado para decifrado de contraseña',

   'Could not verify current authentication.'
=> 'No se pudo verificar autenticación actual',

   'The new passwords you entered do not match.'
=> 'La nueva contraseña que entró no coincide.',

   'Passwords must be a minimum of 7 characters long.'
=> 'Contraseñas deben tener un mínimo de 7 caracteres de largo.',

   'The password you entered contained illegal characters.'
=> 'La contraseña que entró tenía caracteres ilegales',

   'Valid characters are'
=> 'Caracteres válidos son',

   'The password for user [_1] was successfully changed.'
=> 'La contraseña para usuario [_1] fue cambiada exitosamente',

   'The password for user [_1] was not changed.'
=> 'La contraseña para usuario [_1] no fue cambiada',

   'Please make sure your old password was entered correctly.'
=> 'Por favor asegurese que su contraseña anterior ha sido entrada correctamente.',

   'In discussions: only new posts will be displayed.'
=> 'En discusiones: sólo mensajes nuevos serán mostrados.',

   'In discussions: all posts will be displayed.'
=> 'En discusiones: todos los mensajes serán mostrados.',

   'In discussions: new posts will be cease to be identified as "NEW" after display.'
=> 'En discusiones: nuevos mensajes dejarán de ser identificados como "NUEVO" después de mostrados.',

   'In discussions: posts will be identified as "NEW" until marked as read by the reader.'
=> 'En discusiones: los mensajes serán identidicados como "NUEVO" hasta ser marcados como leído por el usuario.',

   'The e-mail address entered in row '
=> 'La dirección E-Mail entrada en filas ',

   'The e-mail address you entered'
=> 'La dirección E-Mail que entró',

   'is not a valid e-mail address'
=> 'no es una dirección E-Mail válida',

   'Title for the Uploaded Score'
=> 'Título para las notas cargadas',

   'Name of Simple Course Page'
=> 'Nombre de la Página Simple del Curso',

   'Title for the Problem'
=> 'Título para el Problema',

   'Title for the Drop Box'
=> 'Título para la Caja de Respuesta',

   'Title for the Discussion Board'
=> 'Título para el Foro de Discusión',

   'Not a valid user:domain'
=> 'usuario:dominio No válido',

   'Please enter both user and domain in the format user:domain'
=> 'Por favor entre ambos usuario y dominio en el formato usuario:dominio',

   'Personal Information Page of '
=> 'Página de Información Personal de ',

   'No info'
=> 'Sin información',

   'No user information available'
=> 'Informacion de usuario NO disponible',

   'The new directory name was changed from [_1] to [_2].'
=> 'El nombre del directorio fue cambiado de [_1] a [_2].',

   'Unable to create a directory named'
=> 'No se puede crear un directorio con nombre',

   'A file or directory by that name already exists.'
=> 'Un archivo o directorio con ese nombre ya existe.',

   'Allowing others to retrieve file: [_1]'
=> 'Permitiendo a otros accesar archivo: [_1]',

   'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.'
=> 'Acceso a este archivo por otros puede ser establecido a uno o más de los siguientes tipos: público, frase-protegido o condicional.',

   'Public files are available to anyone without the need for login.'
=> 'Archivos Públicos estan disponibles a cualquiera sin necesidad de conectarse.',

   'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.'
=> 'Archivos frase-protegidos no requieren conectarse, pero requerirá al interesado que entre la frase que usted establezca.',

   'A listing of files viewable without log-in is available at: '
=> 'Una lista de archivos visible sin conectarse está disponible en: ',

   "For logged in users a 'Display file listing' link will also appear (when there are Viewable files) on your personal information page:"
=> "Para usuarios conectados un enlace web 'Mostrar lista de archivos' también aparecerá (cuando hay archivos visibles) en su página de información personal: ",

   "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS"
=> "Usuarios con privilegios para ediatar contenidos del curso pueden añadir una página de información del curso usando el botón de 'Info Curso' en DOCS",

   'Conditional access controls for file: [_1]'
=> 'Controles de acceso condicional para archivo: [_1]',

   'Help on setting up share access'
=> 'Asistencia en configurar acceso compartido',

   'Help on changing settings'
=> 'Asistencia en cambiando configuración',

   'Help on removing share access'
=> 'Asistencia en eliminar acceso compartido',

   'Public access: [_1]'
=> 'Acceso público: [_1]',

   'Dates available'
=> 'Fechas disponibles',

   'Passphrase-protected access: [_1]'
=> 'Acceso frase-protegida: [_1]',

   'Passphrase'
=> 'Frase',

   'Conditional access: [_1]'
=> 'Acceso condicional: [_1]',

   'You have previously set [_1] conditional access controls.'
=> 'Previamente estableció [_1] controles de acceso condicional.',

   'Change Conditions'
=> 'Cambiar condiciones',

   'Add conditional access'
=> 'añadir acceso condicional',

   'based on domain, username, or course affiliation.'
=> 'basado en dominio, usuario o afiliación a curso',

   '[_1]-based conditional access: '
=> 'acceso condicional basado en [_1]: ',

   'conditions'
=> 'condiciones',

   'condition'
=> 'condición',

   'Action?'
=> '¿Acción?',

   'Allowed [_1] member affiliations'
=> 'Afiliación de miembros permitida [_1]',

   'No [_1]-based conditions defined.'
=> 'Sin definir condiciones basadas en [_1].',

   'Type of change'
=> 'Tipo de cambio',

   'Access control'
=> 'Control de acceso',

   'Access Denied ([_1])'
=> 'Acceso Denegado ([_1])',

   'Additional information'
=> 'Información adicional',

   'A problem occurred deleting access controls: [_1]'
=> 'Ocurrió un problema eliminando controles de acceso: [_1]',

   'A problem occurred saving access control settings: [_1]'
=> 'Ocurrió un problema guardando configuración de control de acceso: [_1]',

   'opened folder'
=> 'carpeta abierta',

   'closed folder'
=> 'carpeta cerrada',

   'Passphrase-protected'
=> 'Frase-protegida',

   'Conditional'
=> 'Condicional',

   'An error occurred ([_1]) while trying to delete [_2].'
=> 'Ocurrió un error ([_1]) mientras trataba de eliminar [_2].',

   'File: [_1] deleted.'
=> 'Archivo: [_1] eliminado.',

   'An error occurred ([_1]) while trying to delete access controls for the file.'
=> 'Ocurrió un error ([_1]) mientras trataba de eliminar el control de acceso para el archivo.',

   'Access controls also deleted for the file.'
=> 'Control de acceso también eliminado para el archivo.',

   'Error: no valid filename was provided to rename to.'
=> 'Error: nombre no válido fue provisto para renombrar archivo.',

   'An error occurred ([_1]) while trying to rename [_2] to [_3]'
=> 'Ocurrió un error ([_1]) mientras trataba de renombrar [_2] a [_3]',

   'The new file name was changed from:<br />[_1] to [_2]'
=> 'El nombre del archivo fue cambiado de :<br />[_1] a [_2]',

   'An error occurred ([_1]) while trying to delete access control records for the old name.'
=> 'Ocurrió un error ([_1]) mientras trataba de eliminar el registro de control de acceso para el nombre anterior.',

   'An error occurred ([_1]) while trying to upload [_2].'
=> 'Ocurrió un error ([_1]) mientras trataba de cargar [_2].',

   'An error occurred (dir) ([_1]) while trying to delete [_2].'
=> 'Ocurrió un error (dir) ([_1]) mientras trataba de eliminar [_2].',

   'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].'
=> 'Ocurrió un error ([_1]) mientras trataba de cargar [_2] para elemento incrustado [_3].',

   'An error occurred ([_1]) while trying to create a new directory [_2].'
=> 'Ocurrió un error ([_1]) mientras trataba de crear un nuevo directorio [_2].',

   'Access controls updated to reflect the name change.'
=> 'Controles de acceso actualizados para reflejar en cambio de nombre.',

   'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.'
=> 'Archivos condicionales son accesibles a usuarios conectados con cuentas en la red LON-CAPA, que satisfagan la condiciones que imponga.',

   'The conditions can include affiliation with a particular course, or a user account in a specific domain.'
=> 'Las condiciones pueden incluir afiliaciones con un curso particular, o una cuenta de usuario en un dominio específico.',

   'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.'
=> 'Accesos alternos pueden ser autorizado a personas con usuario y dominio LON-CAPA específico.',

   'Current access controls defined for this file:'
=> 'Control de acceso actual definido para este archivo:',

   'No access control settings currently exist for this file.'
=> 'No hay control de acceso establecido actualmente para este archivo.',

   'Deleted'
=> 'Eliminado',

   'No end date'
=> 'Sin término',

   'Start: '
=> 'Empieza: ',

   'End: '
=> 'Termina: ',

   'Domains: '
=> 'Dominios: ',

   'Users: '
=> 'Usuarios: ',

   'New control(s) added'
=> 'Nuevo control añadido',

   'Existing control(s) deleted'
=> 'Control(es) existente(s) eliminado(s)',

   'Existing control(s) modified'
=> 'Control(es) existente(s) modificado(s)',

   'Add new <b>[_1]-based</b> access control for portfolio file: <b>[_2]</b>'
=> 'Añadir control de acceso basado en <b>[_1]</b> para archivo de portafolio: <b>[_2]</b>',

   'Display all access settings for this file'
=> 'Mostrar todas las configuraciones de acceso para este archivo',

   'Add a roles-based condition'
=> 'Añadir una condición basada en funciones',

   'New role-based condition'
=> 'Nueva condición basada en funciones',

   "Format for users' username:domain information:"
=> "Formato para información de usuarios usuario:dominio  :",

   'Add new [_1] condition(s)?'
=> '¿Añadir condición nueva [_1]?',

   'Number to add: '
=> 'Número a añadir:',

   'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Seleccionar funciones, estatus del curso, seccion(es) y grupo(s) para usuarios que podrán accesar el archivo del portafolio.',

   'Course status'
=> 'Estado de Curso',

   'Files selected from other directories:'
=> 'Archivos seleccionados de otros directorios:',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.'
=> 'No se puede cargar [_1]. (tamaño =[_2] Kb). Excederá su cuota de disco.',

   'Unable to upload [_1]. A locked file by that name was found in [_2].'
=> 'No se puede cargar [_1]. Un archivo protegido con ese nombre fue encontrado [_2].',

   'You will be able to rename or delete existing [_1] after a grade has been assigned.'
=> 'Usted puede renombrar o eliminar [_1] después que se haya asignado una calificación.',

   'Unable to upload [_1]. A file by that name was found in [_2].'
=> 'No se puede cargar [_1]. Un archivo con ese nombre fue encontrado en [_2].',

   'To upload, rename or delete existing [_1] in [_2].'
=> 'Para cargar, renombrar o eliminar [_1] en [_2].',

   'Rename [_1] to [_2]?'
=> '¿Renombrar [_1] a [_2]?',

   'Move [_1] to [_2]?'
=> '¿Mover [_1] a [_2]?',

   'Copy [_1] to [_2]?'
=> '¿Copiar [_1] a [_2]?',

   'Reference Warning'
=> 'Advertencia sobre Referencia',

   'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.'
=> 'Carga de archivo completo. Este archivo contiene referencias a otros archivos. Debe cargar los archivos referenciados o el archivo cargado podría no ejecutar apropiadamente.',

   'Please select the locations from which the referenced files are to be uploaded.'
=> 'Por favor seleccione los lugares de donde los archivos referenciados serán cargados.',

   'Delete [_1]?'
=> '¿Eliminar [_1]?',

   'Edit Portfolio File Metadata'
=> 'Editar Metadatos del archivo de portafolio',

   'Edit Group Portfolio File Metadata'
=> 'Editar Metadatos del archivo de portafolio grupal',

   'Update'
=> 'Actualizar',

   'domains'
=> 'dominios',

   'users'
=> 'usuarios',

   'Access'
=> 'Acceso',

   'Conditional: domain-based'
=> 'Condicional: basado en dominio',

   'Conditional: user-based'
=> 'Condicional: basado en usuario',

   'Conditional: course-based'
=> 'Condicional: basado en curso',

   '[_1] was submitted in response to problem: [_2]'
=> '[_1] fue enviado en respuesta al problema: [_2]',

   '[_1] was handed back in response to problem: [_2]'
=> '[_1] fue devuelto en respuesta al problema: [_2]',

   'In the course:'
=> 'En el curso',

   'Back'
=> 'Volver',

   'Error: no directory name was provided.'
=> 'Error: falta nombre del directorio.',

   'Unable to create a directory named [_1].'
=> 'No se puede crear un directorio nombrado [_1].',

   'Action disallowed'
=> 'Acción no permitida',

   'You do not have sufficient privileges to [_1]'
=> 'No tiene suficientes privilegios para [_1]',

   'upload files'
=> 'cargar archivos',

   'delete files'
=> 'eliminar archivos',

   'rename files'
=> 'renombrar archivos',

   'set access controls for files'
=> 'establecer controles de acceso a archivos',

   "in the group's group portfolio."
=> "en el portafolio grupal del grupo.",

   'in this portfolio.'
=> 'en este portafolio.',

   'You do not have the privileges required to access the shared files space for this group.'
=> 'No tiene los privilegios requeridos para acceder el espacio de archivos compartidos para este grupo.',

   'Not a valid group for this course'
=> 'No es un grupo válido para este curso',

   'Group portfolio for [_1]'
=> 'Portafolio grupal para [_1]',

   'Invalid group'
=> 'Grupo NO válido',

   'No file was selected to upload.'
=> 'No se seleccionó archivo para cargar.',

   'To upload a file, click <strong>Browse...</strong> and select a file, then click <strong>Upload</strong>.'
=> 'Para cargar un archivo, pulse <strong>Navegar...</strong> y seleccione un archivo,entonces pulse <strong>Cargar</strong>.',

   'Edit the meta data'
=> 'Editar el meta dato',

   'Pick functionality'
=> 'Elija funcionalidad',

   'Functionality to display/modify'
=> 'Funcionalidad para mostrar/modificar',

   'You must select at least one functionality type to display.'
=> 'Debe seleccionar al menos un tipo de funcionalidad a mostrar.',

   'Default color schemes'
=> 'Esquema de colores predeterminado',

   'Log-in page options'
=> 'Opciones para página de entrada',

   'Default authentication/language/timezone'
=> 'Predeterminación autenticación/idioma/zona_de_tiempo',

   'Default quotas for user portfolios'
=> 'Cuotas para usuarios de portafolio predeterminada',

   'Auto-enrollment settings'
=> 'Configuración de Auto-inscripción',

   'Auto-update settings'
=> 'Configuración de auto actualización',

   'Institutional directory searches'
=> 'Directorio de búsqueda institucional',

   'Contact Information'
=> 'Información de contacto',

   'User creation'
=> 'Creación de usuario',

   'User modification'
=> 'Modificación de usuario',

   'Bubblesheet format file'
=> 'Archivo de formato Hoja de Respuesta',

   'Cataloging of courses'
=> 'Catalogación de cursos',

   'Display options'
=> 'Opciones de visualización',

   'Display using: '
=> 'Mostrar usando: ',

   'one column'
=> 'una columna',

   'two columns'
=> 'dos columnas',

   'Changes made:'
=> 'Cambios hechos:',

   'Back to configuration display'
=> 'Volver a mostrar configuración',

   'No changes made to log-in page settings'
=> 'Sin cambios la configuración de la página de inicio de sesión.',

   'Support Request'
=> 'Solicitar Asistencia',

   'Do <b>not</b> use this form to ask questions about course content.'
=> '<b>NO</b> use esta forma para preguntas sobre el contenido del curso.',

   'Contact your instructor instead.'
=> 'Sino contacte su instructor.',

   'Cc'
=> 'Cc',

   'Your e-mail address'
=> 'Su dirección de E-mail',

   'Search and Enroll'
=> 'Buscar e Incribirse',

   'Search or Add New User'
=> 'Buscar o añadir Usuario Nuevo',

   'No username and/or domain provided.'
=> 'Sin usuario y/o dominio provisto.',

   'No match was found for the username ([_1]) in LON-CAPA domain: [_2]'
=> 'No se encontró coincidiencias para usuario ([_1]) en dominio LON-CAPA: [_2]',

   'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.'
=> 'Enviar solicitud a LON-CAPA [_1]Helpdesk[_2] para [_3] si necesita asistencia.',

   'Problems occurred in creating the new Excel file.'
=> 'Ocurrieron problemas en crear el nuevo archivo de Excel.',

   'Problems occurred in creating the output file.'
=> 'Ocurrieron problemas en crear el archivo de salida.',

   'Problems occurred in writing the CSV file.'
=> 'Ocurrieron problemas escribiendo el archivo CSV.',

   'This error has been logged.'
=> 'Este Error ha sido registrado.',

   'Please alert your LON-CAPA administrator.'
=> 'Por favor, avise a su administrador LON-CAPA.',

   'Records [_1]'
=> 'Registros [_1]',

   'Filter [_1]'
=> 'Filtro [_1]',

   'Under you current role you are not permitted to change login settings for this user'
=> 'Bajo su función actual no esta permitido de cambiar la configuración de entrada a este usuario.',

   'History'
=> 'Historia',

   'Part '
=> 'Parte',

   'Transaction [_1]'
=> 'Transacción [_1]',

   'Nothing submitted - no attempts.'
=> 'Nada enviado - sin intentos.',

   'No data.'
=> 'No hay datos.',

   'Open in a new window'
=> 'Abrir en una nueva ventana',

   'Revoke user roles'
=> 'Revocar funciones de usuario',

   'Delete user roles'
=> 'Eliminar funciones de usuario',

   'Re-enable expired user roles'
=> 'Re-activar funciones de usuario expiradas',

   'Make future user roles active now'
=> 'Hacer activas funciones de usuario futuras ahora',

   'Change starting/ending dates'
=> 'Cambiar fechas de inicio/término',

   'Change section associated with user roles'
=> 'Cambiar sección asociada con funciones de usuario',

   'Modify existing user: '
=> 'Modificar usuario existente: ',

   'Enroll one student'
=> 'Inscribir un estudiante',

   'Enroll one student: '
=> 'Inscribir un estudiante: ',

   'Existing Roles'
=> 'Funciones Existentes',

   'Existing Roles in this Course'
=> 'Funciones Existentes en este Curso',

   'Existing Co-Author Roles in your Construction Space'
=> 'Funciones Existentes de Co-actor en su Zona de Construcción',

   'Existing Roles in this Domain'
=> 'Funciones Existentes en este Dominio',

   'You are already logged in!'
=> 'Está conectado actualmente!',

   'You are already logged in'
=> 'Está conectado actualmente',

   'Please either [_1]continue the current session[_2] or [_3]log out[_4].'
=> 'Por favor o [_1]continúa la sesión actual[_2] o [_3]se desconecta[_4].',

   'Login problems?'
=> 'Problemas para iniciar sesión?',

   'Reset password'
=> 'Reiniciar contraseña',

   'Reset forgotten LON-CAPA password'
=> 'Reiniciar contraseña olvidada LON-CAPA',

   'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password. However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.'
=> 'Si usa la misma cuenta para otros servicios de la institución aparte de LON-CAPA (p.e. E-Mail, matrícula, etc.), posiblemente exista un mecanismo separado operado centralmente para reiniciar su contraseña. Sin embargo, si su cuenta es usada sólo para accesar LON-CAPA probablemente podrá reiniciar su contraseña desde esta página.',

   'Three conditions must be met:'
=> 'Debe cumplir tres condiciones:',

   'An e-mail address must have previously been associated with your LON-CAPA username.'
=> 'Una dirección de E-Mail debe heber sido asociada con su usuario LON-CAPA.',

   'You must be able to access e-mail sent to that address.'
=> 'Debe poder accesar el E-Mail enviado a esa dirección.',

   'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.'
=> 'Su cuenta LON-CAPA debe ser del tipo para el cual LON-CAPA puede reiniciar una contraseña.',

   'Thank you for your request to reset the password for your LON-CAPA account.'
=> 'Gracias por su solicitud para reiniciar la contraseña de su cuenta LON-CAPA.',

   'E-mail address in LON-CAPA'
=> 'Dirección de E-Mail en LON-CAPA',

   'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.'
=> 'El usuario provisto no fue verificado como un usuario válido en el sistema LON-CAPA el dominio [_1].',

   'Please [_1]go back[_2] and try again.'
=> 'Por favor [_1]regrese[_2] y trate otra vez.',

   'The e-mail address you provided does not appear to be a valid address.'
=> 'La dirección de E-Mail provista parece ser una dirección inválida.',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'La dirección de E-Mail provista no coincide con la dirección registrada en el sistema LON-CAPA para el usuario y dominio proveído.',

   'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.'
=> 'No se encontró una dirección válida de E-Mail en el sistema LON-CAPA para el usuario y dominio proveído.',

   'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.'
=> 'El usuario dado usa un tipo de autenticación que no puede reiniciarse directamente vía LON-CAPA.',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].'
=> 'Tal vez quiera contactar [_1]LON-CAPA Helpdesk[_2] para [_3].',

   'You may wish to send an e-mail to the server administrator: [_1] for [_2].' # 1: e-mail, 2: domain
=> 'Tal vez quiera enviar un E-Mail al Administrador del Servidor: [_1] para [_2].',

   'Assigning yourself a co-author or assistant co-author role in your own author area in Construction Space is not permitted'
=> 'Asignandose usted mismo una función co-autor o co-autor asistente en su propia zona de construcción de autor no esta permitido.',

   'Owner(s)'
=> 'Dueño(s)',

   'Practice Problem'
=> 'Problema de Práctica',

   'Submissions are not permanently recorded'
=> 'Envíos no fueron registrados permanentemente.',

   'Submissions to practice problems are not permanently recorded.'
=> 'Envíos a problemas de práctica no son registrados permanentemente.',

   'not graded'
=> 'sin calificar',

   'Course initialization preference'
=> 'Preferencia de inicialización de Curso',

   'Choose which page will be displayed when you enter this course after selecting a role.'
=> 'Elija que página será mostrada cuando ingrese a este curso después de seleccionar una función.',

   'Current value is determined by'
=> 'Valor actual está determinado por',

   'and is set to display'
=> 'y está configurado para ser mostrado',

   'Page display controlled by'
=> 'Visualización de página controlado por',

   'If'
=> 'Si',

   'Choose course entry'
=> 'Elija entrada al curso',

   'Modify course entry'
=> 'Modifique entrada al curso',

   'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).'
=> 'No hay miembros que añadir en este momento, asi como no hay usuario que coincida con el(los) tipo(s) de funcion(es) y seccion(es).',

   'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.'
=> 'No hay usuarios que añadir como miembros nuevos, asi como todos los usuarios que coinciden con el(los) tipo(s) de funcion(es) y seccion(es) especificado, ya se encuentran afiliados con este grupo.',

   "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members."
=> "Podría necesitar usar la página 'modificar miembros existentes, pasados o futuros' si necesita re-activar o activar acceso a miembros previos o futuros.",

   'Setting optional privileges for specific group members'
=> 'Estableciendo privilegios opcionales a miembros grupales específicos',

   'As no group tools will be made available to users, there are no specific user privileges to set.'
=> 'Como las herramientas grupales no estarán disponibles a los usuarios, no hay privilegios específicos de usuario que configurar.',

   'Create group'
=> 'Crear grupo',

   'The value you entered for the quota for the group portfolio in this group contained invalid characters, so it has been set to 0 Mb. You can change this by modifying the group settings.'
=> 'El valor que entró para la cuota del portafolio grupal en este grupo contenía caracteres inválidos, por tanto ha sido fijado a 0 Mb. Usted puede cambiar esto modificando la configuración grupal.',

   'The value you entered for the quota for the group portfolio in this group exceeded the maximum possible value, so it has been set to [_1] Mb (the maximum possible value).'
=> 'El valor que entró para la cuota del portafolio grupal en este grupo excedió el valor máximo posible, por tanto ha sido fijado a [_1] Mb (el valor máximo posible ).',

   'A problem occurred when creating folders for the new group [_1]:'
=> 'Ocurrió un problema cuando creaba carpetas para el grupo nuevo [_1]:',

   'Group [_1] was created.'
=> 'Grupo [_1] fue creado.',

   'E-mail Address'
=> 'Dirección E-Mail',

   'Closes '
=> 'Cierra ',

   'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".'
=> 'Los recursos en "[_1]" están abiertos por tiempo limitado. Una vez pulse el botón "Mostrar Recurso" abajo tiene [_2] para completar todos los recursos "[_1]".',

   'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".'
=> 'Este recurso "[_1]" está abierto por tiempo limitado. Una vez pulse el botón "Mostrar Recurso" abajo tiene [_2] para completar este recurso "[_1]".',

   '[quant,_1,hour]'
=> '[quant,_1,hora,horas]',

   '[quant,_1,minute]'
=> '[quant,_1,minuto,minutos]',

   '[quant,_1,second]'
=> '[quant,_1,segundo,segundos]',

   'Start Timer?'
=> 'Empezar Tiempo?',

   'Sign up for time to work.'
=> 'Registrarse para un tiempo de trabajo',

   'Requesting Another Worktime'
=> 'Solicitando otro tiempo de trabajo',

   'No available times.'
=> 'No tiempos de trabajo disponible.',

   'Return to last resource'
=> 'Volver al último recurso',

   'My Courses'
=> 'Mis Cursos',

   '[_1] parts'
=> '[_1] partes',

   'Part: [_1]'
=> 'Parte: [_1]',

   'New Discussion'
=> 'Nueva Discusión',

   'New E-mail'
=> 'Nuevo E-Mail',

   'New Error'
=> 'Nuevo Error',

   '(randomly select [_1])'
=> '(seleccione al azar [_1])',

   '(randomly ordered)'
=> '(ordenado al azar)',

   'No course selected'
=> 'Curso no seleccionado',

   'Open '
=> 'Abrir ',

   'Having technical difficulties; please check status later'
=> 'Tenemos dificultades técnicas; por favor revise estatus más tarde',

   'Answer open'
=> 'Mostrar respuesta',

   'Yes, and show correct answer if they exceed the maximum number of tries.'
=> 'Si, y muestre respuesta correcta si estos exceden el número máximo de intentos.',

   "No, don't show correct/incorrect feedback."
=> "No, no muestre reacción correcto/incorrecto.",

   'No, show no feedback at all.'
=> 'No, no muestre ninguna reacción.',

   'single part'
=> 'parte única',

   'Unable to set "number unread posts display" to [_1] due to [_2].'
=> 'No se pudo establecer "ver número de mensajes no leídos" a [_1] debido a [_2]:',

   'Current value is [_1].'
=> 'Valor actual es [_1].',

   'Unable to set interval to [_1] due to [_2].'
=> 'No se pudo establecer intérvalo a [_1] debido a [_2].',

   'Changes to threshold(s) for problem tracking:'
=> 'Cambios a umbral(es) para seguimiento de problema(s):',

   'Set threshold for [_1] to [_2]'
=> 'Establecer umbral de [_1] a [_2]',

   'Set the default page to be displayed when you select a course role'
=> 'Establecer la pPágina a ser mostrada cuando seleccione una función del curso',

   '(Currently: [_1])'
=> '(Actualmente: [_1])',

   "The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New Page[_2] in the course."
=> "La preferencia global de usuario que establezca para su curso puede ser reemplazada en un curso individual estableciendo una configuración específica en el curso vía la [_1]página ¿Que hay de Nuevo?[_2].",

   'Display the [_1]first resource[_2] in the course.'
=> 'Mostrar el [_1]primer recurso[_2] en el curso',

   "Display the [_1]What's New Page[_2] - a summary of items in the course which require attention."
=> "Mostrar la [_1]Página ¿Que hay de Nuevo?[_2] - Un resumen de los elementos que requieren atención.",

   'Default now set'
=> 'Valor estándar es ahora',

   'when you select a course role from the roles screen'
=> 'cuando seleccione una función de curso de la ventana de funciones',

   'you will be taken to the start of the course.'
=> 'usted será llevado al inicio del curso.',

   'a page will be displayed that lists items in the course that may require action from you.'
=> 'una página mostrará la lista de elementos en el curso que podrían requerir su atención.',

   "Display the What's New Page"
=> "Mostrar la página ¿Que hay de nuevo?",

   'Go to the start of the course'
=> 'Ir al inicio del curso',

   'now'
=> 'ahora',

   'No official courses to display for [_1].'
=> 'No hay cursos oficiales que mostrar para [_1].',

   '(Month - Day - Year)'
=> '(Mes - Día - Año)',

   'Month[_1]Day[_2]Year'
=> 'Mes[_1]Día[_2]Año',

   'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.'
=> 'Copyright/distribución opción "Privado" no tiene soporte. Seleccione otra opción abajo. Cosidere "Derechos Personalizados" para máximo control sobre el uso de su recurso.',

   'Skipping'
=> 'Omitido',

   'Notifying host'
=> 'Notificando al anfitrión',

   'Back to Metadata'
=> 'Volver al Metadatos',

   'Metadata Publication'
=> 'Publicación de Metadatos',

   ' at '
=> ' en ',

   "Computer's answer is incorrect ([_1])."
=> "Respuesta de computadora es incorrecta ([_1]).",

   'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.'
=> 'Es posible que el rango de tolerancia [_1] o las cifras significativas [_2] necesitan cambiarse.',

   'It is likely that the tolerance range [_1] needs to be adjusted.'
=> 'Es posible que el rango de tolerancia [_1] necesita cambiarse.',

   'Submission Record'
=> 'Registro de Envío',

   'Set/Change grades'
=> 'Establecer/Cambiar calificación',

   'View of the problem'
=> 'Vista del problema',

   'Assign Grades'
=> 'Asignar calificación',

   'Save &amp; Next'
=> 'Guardar &amp; Siguiente',

   '[quant,_1,student]'
=> '[quant,_1,estudiante,estudiantes]',

   '(Next and Previous (student) do not save the scores.)'
=> '("Próximo" y "Anterior" (estudiante) no guarda las puntuaciones)',

   'LON-CAPA User Message'
=> 'Mensaje de Usuario LON-CAPA',

   '<b>Message: </b> No more students for this section or class.'
=> '<b>Mensaje:</b> No hay más estudiantes para esta sección o clase.',

   'Click on the button below to return to the grading menu.'
=> 'Pulse en el botón de abajo para volver al menú de calificación.',

   'Group portfolio'
=> 'Portafolio Grupal',

   'One group portfolio file is available.'
=> 'Un archivo de portafolio grupal está disponible.',

   'One portfolio file owned by [_1] is available.'
=> 'Un archivo de portafolio perteneciente a [_1] está disponible.',

   'A total of [_1] group portfolio files are available.'
=> 'Un total de [_1] archivos de portafolio grupal esán disponibles.',

   'A total of [_1] portfolio files owned by [_2] are available'
=> 'Un total de [_1] archivos de portafolio perteneciente a [_2] esán disponibles.',

   '[quant,_1,file is,files are] publicly accessible.'
=> '[quant,_1,archivo es,archivos son] públicamente accesible(s).',

   '[quant,_1,file requires,files require] a passphrase for access.'
=> '[quant,_1,archivo requiere,archivos requieren] una frase para acceso.',

   'Group Portfolio files'
=> 'Archivos Grupales de Portafolio',

   'Viewable portfolio files.'
=> 'Archivos visibles de portafolio.',

   'Viewable portfolio files'
=> 'Archivos visibles de portafolio',

   'Viewable group portfolio files'
=> 'Archivos grupales visibles de portafolio',

   'Display file listing'
=> 'Mostrar lista de archivos',

   'Portfolio files for [_1]'
=> 'Archivos de portafolio para [_1]',

   'File access type: '
=> 'Tipo de acceso al archivo: ',

   'Update display'
=> 'Actualizar visualización',

   'Course Information page'
=> 'Página de Información del curso',

   'Information about [_1]'
=> 'Información sobre [_1]',

   'There are no available files of the specified access type: [_1]'
=> 'No hay archivos disponibles del tipo del acceso especificado: [_1]',

   'File Type Displayed: [_1]'
=> 'Tipo de Archivo mostrado: [_1]',

   'All file types'
=> 'Todos los tipos de archivo',

   'The resource depends on another resource with variable filename, i.e., [_1].'
=> 'El recurso depende de otro recurso con nombre variable, p.e. [_1].',

   'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.'
=> 'Posiblemente necesita permitir explícitamente acceso a todas las posibles dependencias usando la etiqueta [_1].',

   'Add Selection for:'
=> 'Añadir selección para:',

   'Selected Parameters:'
=> 'Parómetros Selecionados:',

   'Show detailed Parameter Selection'
=> 'Mostrar selección detallada de Parómetros',

# Resource Parameters - Start

   'Problem Opening Date (opendate)'
=> 'Fecha de Apertura de Problema (opendate)',

   'Problem Opening Date'
=> 'Fecha de Apertura de Problema',

   'Problem Due Date (duedate)'
=> 'Fecha de Cierre de Problema (duedate)',

   'Problem Due Date'
=> 'Fecha de Cierre de Problema',

   'Problem Answer Date (answerdate)'
=> 'Fecha de Respuesta disponible de Problema (answerdate)',

   'Problem Answer Date'
=> 'Fecha de Respuesta disponible de Problema',

   'Time-Limit (interval)'
=> 'Límite de Tiempo (interval)',

   'Time-Limit'
=> 'Límite de Tiempo',

   'Weight (weight)'
=> 'ponderación (weight)',

   'Weight'
=> 'Ponderación',

   'Maximum Number of Tries (maxtries)'
=> 'Número Máximo de intentos (maxtries)',

   'Maximum Number of Tries'
=> 'Número Máximo de Intentos',

   'Number of Tries before hints appear (hinttries)'
=> 'Número de Intentos antes de mostrar sugerencias (hinttries)',

   'Number of Tries before hints appear'
=> 'Número de Intentos antes de mostrar sugerencias',

   'Content Opening Date (contentopen)'
=> 'Fecha de Apertura Contenido (contentopen)',

   'Content Opening Date'
=> 'Fecha de Apertura Contenido',

   'Content Due Date (contentclose)'
=> 'Fecha de Término de Contenido (contentclose)',

   'Content Due Date'
=> 'Fecha de Término de Contenido',

   'Content Close Date (contentclose)'
=> 'Fecha de Cierre Contenido (contentclose)',

   'Content Close Date'
=> 'Fecha de Cierre Contenido',

   'Question Type (type)'
=> 'Tipo de Pregunta (type)',

   'Question Type'
=> 'Tipo de Pregunta',

   'Show Problem Status (problemstatus)'
=> 'Mostrar Estado del Problema (problemstatus)',

   'Show Problem Status'
=> 'Mostrar Estado del Problema',

   'Resource Hidden from Students (hiddenresource)'
=> 'Recursos Ocultos a Estudiantes (hiddenresource)',

   'Resource hidden from students'
=> 'Recursos ocultos a estudiantes',

   'Resource hidden from students (hiddenresource)'
=> 'Recursos ocultos a estudiantes (hiddenresource)',

   'Resource Hidden from Students'
=> 'Recursos Ocultos a Estudiantes',

   'List of hidden parts (hiddenparts)'
=> 'Listar partes ocultas (hiddenparts)',

   'List of hidden parts'
=> 'Listar partes ocultas',

   'Part Description (display)'
=> 'Descripción de Parte (display)',

   'Part Description'
=> 'Descripción de Parte',

   'Show Parts One-at-a-Time (ordered)'
=> 'Mostrar Partes Uno-a-la-vez (ordered)',

   'Show Parts One-at-a-Time'
=> 'Mostrar Partes Uno-a-la-vez',

   'Numerical Tolerance (tol)'
=> 'Tolerancia numérica (tol)',

   'Numerical Tolerance'
=> 'Tolerancia numérica',

   'Significant Digits (sig)'
=> 'Cifras Significativas (sig)',

   'Significant Digits'
=> 'Cifras Significativas',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Mostrar Unidades - Disabilitar Entrada (turnoffunit)',

   'Show Units - Disable Entry'
=> 'Mostrar Unidades - Disabilitar Entrada',

   'Discussion End Time (discussend)'
=> 'Fecha de Término de Discusión (discussend)',

   'Discussion End Time'
=> 'Fecha de Término de Discusión',

   'Hide Closed Discussion (discusshide)'
=> 'Ocultar Discusión Cerrada (discusshide)',

   'Hide Closed Discussion'
=> 'Ocultar Discusión Cerrada',

   'Randomly Order Resources (randomorder)'
=> 'Ordenar Recursos Aleatoriamente (randomorder)',

   'Randomly Order Resources'
=> 'Ordenar Recursos Aleatoriamente',

   'Randomly pick number of resources (randompick)'
=> 'Generar Aleatoriamente número de recursos (randompick)',

   'Randomly pick number of resources'
=> 'Elegir Aleatoriamente número de recursos',

   'Do not show plain URL (encrypturl)'
=> 'No muestre URL (encrypturl)',

   'Do not show plain URL'
=> 'No muestre URL',

   'Slots of availability (available)'
=> 'Franjas de disponibilidad (available)',

   'Slots of availability'
=> 'Franjas de disponibilidad',

   'CSS file to link (cssfile)'
=> 'Archivo CSS a enlazar (cssfile)',

   'CSS file to link'
=> 'Archivo CSS a enlazar',

   'Use slot based access controls (useslots)'
=> 'Usar controles basado en acceso de franjas (useslots)',

   'Use slot based access controls'
=> 'Usar controles basado en acceso de franjas',

   'Client IP/Name Access Control (acc)'
=> 'Control de acceso IP/Nombre de Cliente (acc)',

   'Client IP/Name Access Control'
=> 'Control de acceso IP/Nombre de Cliente',

   'Resource alias name for conditions (mapalias)'
=> 'Alias del Recurso para condiciones (mapalias)',

   'Resource alias name for conditions'
=> 'Alias del Recurso para condiciones',

   'Slots of availability selected by student (availablestudent)'
=> 'Franjas de disponilidad seleccionada por el estudiante (availablestudent)',

   'Slots of availability selected by student'
=> 'Franjas de disponilidad seleccionada por el estudiante',

   'Hide buttons from students (buttonshide)'
=> 'Ocultar botones a estudiantes (buttonshide)',

   'Hide buttons from students'
=> 'Ocultar botones a estudiantes',

   'Hide DragMath-Editor (turnoffeditor)'
=> 'Ocultar Editor DragMath (turnoffeditor)',

   'Hide DragMath-Editor'
=> 'Ocultar Editor DragMath',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Número Máximo de colaboradores (maxcollaborators)',

   'Maximum Number of Collaborators'
=> 'Número Máximo de Colaboradores',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Extensiones de Archivo Permitidas para Archivos Cargados (uploadedfiletypes)',

   'Allowed File Extensions for Uploaded Files'
=> 'Extensiones de Archivo Permitidas para Archivos Cargados',

   'Hand Graded (handgrade)'
=> 'Corregido Manualmente (handgrade)',

   'Hand Graded'
=> 'Corregido Manualmente',

   'Number of bubbles in exam mode (numbubbles)'
=> 'Número de alternativas en modo de examen (numbubbles)',

   'Number of bubbles in exam mode'
=> 'Número de alternativas en modo de examen',

   'Format for display of score (scoreformat)'
=> 'Formato para ver Puntuación (scoreformat)',

   'Format for display of score'
=> 'Formato para ver Puntuación',

   'Max. Cumulative Size (MB) for Submitted Files (maxfilesize)'
=> 'Tamaño Max. Acumulado (Mb) para Archivos Enviados (maxfilesize)',

   'Max. Cumulative Size (MB) for Submitted Files'
=> 'Tamaño Max. Acumulado (Mb) para Archivos Enviados',

   'Max. cumulative size (MB) for submitted files (maxfilesize)'
=> 'Tamaño Max. Acumulado (Mb) para archivos enviados (maxfilesize)',

   'Max. cumulative size (MB) for submitted files'
=> 'Tamaño Max. Acumulado (Mb) para archivos enviados',
# Resource Parameters - End

# Resource Parameter Categories - Start
   'Problem Appearance'
=> 'Apariencia del Problema',

   'Time Settings'
=> 'Configuración del Tiempo',

   'High Level Randomization'
=> 'Alto Nivel de Aleatorización',

   'Hiding'
=> 'Ocultar',

   'Behaviour of Input Fields'
=> 'Comportamiento de los campos de entrada',

   'Slots'
=> 'Espacios', #sitios?

   'File Submission'
=> 'Envío de Archivo',
# Resource Parameters Categories - End

   'New LON-CAPA [_1] ID: [_2]'
=> 'Nuevo LON-CAPA [_1] ID: [_2]',

   'Not available'
=> 'No disponible',

   'Post Announcement'
=> 'Enviar Anuncio',

   'The folder name: "[_1]" is already in use for an existing folder.'
=> 'El nombre de carpeta "[_1]" esta ya en uso por una carpeta existente.',

   'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.'
=> 'El nombre de carpeta "[_1]" esta siendo usado por una de las carpetas generadas automaticamente por el sistema.',

   'Error - could not obtain lock on message folders record.'
=> 'Error- no se pudo bloquear el registro de carpetas de mensaje.',

   'The folder "[_1]" may not be deleted'
=> 'La carpeta "[_1]" podría no estar borrada',

   'The folder "[_1]" does not exist so deletion is not required.'
=> 'La carpeta "[_1]" no existe por tanto eliminación no es necesario.',

   'The folder "[_1]" contains messages so it may not be deleted.'
=> 'La carpeta "[_1]" contiene mensajes por tanto podría no ser borrada.',

   'Delete or move the messages to a different folder first.'
=> 'Primero borrar o mover los mensajes a una carpeta diferente.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.'
=> 'La carpeta "[_1]" podría no ser renombrada a "[_2]" porque el nuevo nombre solicitado es inválido.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.'
=> 'La carpeta "[_1]" podría no ser renombrada a "[_2]" porque el nuevo nombre solicitado está reservado para carpetas proveídas automáticamente por el sistema.',

   'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.'
=> 'La carpeta "[_1]" podría no ser renombrada a "[_2]" porque el nuevo nombre solicitado está siendo usado por una carpeta existente.',

   'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.'
=> 'La carpeta "[_1]" no pudo ser renombrada a "[_2]" porque la carpeta no existe.',

   'Warning: failed to release lock for counter'
=> 'Advertencia: fallió levantar bloqueo para el contador.',

   'Warning: failed to release lock for folder: [_1].'
=> 'Advertencia: fallió levantar bloqueo para carpeta: [_1].',

   'Error uploading new folder.'
=> 'Error cargando carpeta nueva.',

   'Error reading contents of parent folder.'
=> 'Error leyendo contenido de carpeta superior.',

   'Error saving updated parent folder.'
=> 'Error guardando carpeta superior actualizada.',

   'Parameters not set for [_1] because the resource was not recognized as part of the course.'
=> 'Parámetros no establecidos para [_1] porque el recurso no fue reconocido como parte del curso.',

   'Message not moved, Attempted to move message to the same folder as it already is in.'
=> 'Mensaje no movido, Intentó mover mensaje a la misma carpeta en la que se ya se encontraba.',

   'Message not moved, A network error occurred.'
=> 'Mensaje no movido, Ocurrió un error de red.',

   'Message not moved as the message is no longer in the source folder.'
=> 'Mensaje no movido porque el mensaje no se encuentra en la carpeta fuente.',

   'Message copied to new folder but status was not, A network error occurred.'
=> 'Mensaje copiado a la nueva carpeta pero no el estatus. Ocurrió un error de red.',

   'Message copied, but unable to delete the original from the source folder.'
=> 'Mensaje copiado, pero no se puede borrar el original de la carpeta fuente.',

   'Message copied, but unable to delete the original status from the source folder.'
=> 'Mensaje copiado, pero no se puede borrar estatus original de la carpeta fuente.',

   'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.'
=> 'Error: debe tener una función de curso seleccionado para poder emitir un mensaje a un grupo en el curso.',

   'Error: could not determine domain or number of course'
=> 'Error: no se pudo determinar dominio o número de curso',

   'Select message recipients from the group members listed below.'
=> 'Selecionar recipientes del mensaje desde un listado de miembros de grupo abajo.',

   'Send another e-mail'
=> 'Enviar otro E-mail',

   'Send another group message'
=> 'Enviar otro mensaje grupal',

   'Return to group page'
=> 'Volver a la página grupal',

   'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox'
=> 'Tiene que confirmar que ha recibido este mensaje antes de poder ver otras páginas. Después de confirmado, este mensaje será movido a su bandeja de entrada.',

   '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.'
=> '[quant,_1,mensaje es, mensajes son] no visible(s) porque visualización de mensajes LON-CAPA eviados a usted por otros estudiantes entre [_2] y [_3] están siendo bloqueados por los exámenes en línea.',

   'Each of the[_1] [quant,_2,message] [_3]you checked will be forwarded to the recipient(s) you select below.'
=> 'Cada uno de[_1] [quant,_2,mensaje,mensajes] [_3]marcados será reenviado al destinatario(s) que seleccione abajo.',

   'The message you checked will be forwarded to the recipient(s) you select below.'
=> 'El mensaje que revisó será reenviado al destinatario(s) que seleccione abajo.',

   'Send Reply to Messages'
=> 'Enviar Contestación a Mensajes',

   'Send Reply to Message'
=> 'Enviar Contestación a Mensaje',

   'Forward Messages'
=> 'Reenviar Mensajes',

   'Forward Message'
=> 'Reenviar Mensaje',

   'Save message for re-use'
=> 'Guardar mensaje para reusar',

   'Show re-usable messages'
=> 'Mostrar mensajes reusables',

   'This message was designated by the sender not to allow replies.'
=> 'Este mensaje fue designado por el remitente para no permitir responder.',

   'The sender did not designate a reply to address for this message.'
=> 'El remitente no designó una dirección para responder a este mensaje.',

   'Reply to other recipients'
=> 'Responder a otros destinatarios',

   'Unless you choose otherwise:'
=> 'A menos que elija lo contrario:',

   "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject."
=> "El asunto en cada mensaje reenviado será <i>'Reenviando:'</i> seguido del asunto original.",

   'original subject'
=> 'asunto original',

   "sender's name"
=> "Nombre del destinatario",

   'Message begins with:'
=> 'Mensaje empieza con:',

   'Any new text to display before the text of the original messages:'
=> 'Cualquier texto nuevo a mostrar antes del texto del mensaje original:',

   'username1:domain1: text'
=> 'usuario1:dominio1: texto',

   'username2:domain2: text'
=> 'usuario2:dominio2: texto',

   'username3:domain3: text'
=> 'usuario3:dominio3: texto',

   "The messages will be assembled from all lines with the respective\n<tt>username:domain</tt>, and appended to the general message text."
=> "Los mensajes serán armados de todas las líneas con el respectivo\n<tt>usuario:dominio</tt>, y pegadas al texto del mensaje general.",

   'Not allowed'
=> 'No permitido',

   'Archived Message'
=> 'Mensaje Archivado',

   '[quant,_1,communication blocking period was,communication blocking periods were] removed.'
=> '[quant,_1,periodo de bloqueo de comunicación fue borrado,periodos de bloqueo de comunicación fueron borrados] .',

   '[quant,_1,communication blocking period was,communication blocking periods were] modified.'
=> '[quant,_1,periodo de bloqueo de comunicación fue modificado,periodos de bloqueo de comunicación fueron modificados].',

   '[quant,_1,communication blocking period was,communication blocking periods were] added.'
=> '[quant,_1,periodo de bloqueo de comunicación fue añadido,periodos de bloqueo de comunicación fueron añadidos].',

   'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.'
=> 'Intentió mostrar un mensaje que está actualmente bloqueado porque esta registrado en uno o más cursos por el cual hay un exámen en línea ahora mismo.',

   'Reply To'
=> 'Responder a',

   'Current attempts of student (if applicable)'
=> 'Intentos actuales de estudiante  (si aplica)',

   'Current screen output (if applicable)'
=> 'Ventana actual de salida (si aplica)',

   'No saved comments yet.'
=> 'Comentarios aún no guardados.',

   'No saved comments yet for this resource.'
=> 'Comentarios aún no guardados para este recurso.',

   'Could not deliver message'
=> 'No se pudo enviar mensaje',

   'Please use the browser "Back" button and correct the recipient addresses ([_1]).'
=> 'Por favor use el botón "Volver" del navegador y corrija la dirección del destinatario ([_1]).',

   'Failed to delete the message.'
=> 'Falló borrar el mensaje.',

   'Marked [quant,_1,message] read'
=> '[quant,_1,mensaje marcado,mensajes marcados]  como leído',

   'Marked [quant,_1,message] unread'
=> '[quant,_1,mensaje marcado,mensajes marcados] como No-leído',

   'Destination folder [_1] is not a valid folder'
=> 'Carpeta de destino [_1] no es una carpeta válida',

   'Failed to move [quant,_1,message]'
=> 'Falló en moverse [quant,_1,mensaje,mensajes]',

   'Moved [quant,_1,message]'
=> '[quant,_1,mensaje movido,mensajes movidos]',

   'Failed to delete [quant,_1,message]'
=> 'Falló en eliminarse [quant,_1,mensaje,mensajes]',

   'Deleted [quant,_1,message]'
=> '[quant,_1,mensaje eliminado,mensajes eliminados]',

   '[quant,_1,message] forwarded.'
=> '[quant,_1,mensaje reenviado,mensajes reenviados].',

   'Could not forward [quant,_1,message].'
=> 'No se pudo reenviar [quant,_1,mensaje,mensajes].',

   'Could not deliver forwarded message.'
=> 'No se pudo entregar mensaje reenviado.',

   'The recipient addresses may need to be corrected'
=> 'La dirección del destinatario necesita ser corregida',

   'Folder "[_1]" created.'
=> 'Carpeta "[_1]" creada.',

   'Creation failed.'
=> 'Falló creación.',

   'Folder "[_1]" deleted.'
=> 'Carpeta "[_1]" eliminada.',

   'Deletion failed.'
=> 'Falló eliminación',

   'Folder "[_1]" renamed to "[_2]".'
=> 'Carpeta "[_1]" renombrada a "[_2]".',

   'Renaming failed.'
=> 'Falló renombración.',

   'Messages'
=> 'Mensajes',

   'Distribute from Uploaded File'
=> 'Distribuir desde archivo cargado',

   'Communication Blocking'
=> 'Bloqueo de Comunición',

   'Communication blocking during scheduled exams'
=> 'Bloqueo de Comunición durante exámenes programados',

   'You can use communication blocking to prevent students enrolled in this course from displaying LON-CAPA messages sent by other students during an online exam. As blocking of communication could potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course, please be careful that you select the correct start and end times for your scheduled exam when setting or modifying these parameters.'
=> 'Puede usar Bloqueo de Comunición para prevenir que estudiantes registrados en este curso vean mensajes LON-CAPA enviados por otros estudiantes durante un examen en líena. Como el Bloqueo de Comunición puede potencialmente interrumpir comunicación legítima entre estudiantes que estan tambien registrados ambos en un curso LON-CAPA diferente, por favor tenga cuidado de seleccionar los tiempos de inicio y fin de su examen programado cuando configure o modifique estos parámetros.',

   'Modify existing communication blocking periods'
=> 'Modificar periodos de Bloqueo de Comunición existentes',

   'No communication blocks currently saved'
=> 'No hay Bloqueo de Comunición guardado actualmente',

   'Duration'
=> 'Duración',

   'Event'
=> 'Evento',

   'Blocked?'
=> '¿Bloqueado?',

   'Add block'
=> 'Añadir bloqueo',

   'e.g., Exam 1'
=> '(p.e. Examen 1)',

   'Discussion'
=> 'Discusión',

   'The following changes were made'
=> 'Los siguientes cambios fueron realizados',

   'Add new communication blocking periods'
=> 'Añadir nuevo periodo de Bloqueo de Comunicación',

   'Set by'
=> 'Establecido por',

   'Deleted Message'
=> 'Mensaje Eliminado',

   'Marked Messages Read'
=> 'Mensajes Marcados Leídos',

   'Marked Messages Unread'
=> 'Mensajes Marcados No-leídos',

   'Moved Messages'
=> 'Mensajes Movidos',

   'Deleted Messages'
=> 'Mensajes Eliminados',

   'Marked Message as Unread'
=> 'Mensaje Marcado como No-leído',

   'Deleted Folder'
=> 'Carpeta Eliminada',

   'Renamed Folder'
=> 'Carpeta Renombrada',

   'username:domain,username:domain,...'
=> 'usuario:dominio,usuario:dominio,...',

   'All courses'
=> 'Todos los cursos',

   'Pick specific course(s):'
=> 'Escoger curso(s) específico(s):',

   'Search for a course in the [_1] domain'
=> 'Buscar por un curso en el dominio [_1]',

   'Actions available after searching for a course:'
=> 'Acciones disponibles después de buscar por un curso:',

   'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:'
=> 'Aunque casi toda la configuración puede ser modificada por un [_1], un número de configuraciones existentes pueden solo cambiarse por un [_2]:',

   "Certain settings which control auto-enrollment of students from your institution's student information system."
=> "Cierta configuración que controla la auto-incripción de estudiantes desde el sistema de información de su institución.",

   'The total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'El espacio del disco total asignado para almacenamiento de archivos de portafolio en todos los grupos en un curso.',

   'No existing sections'
=> 'Secciones no existentes',

   'Broadcast e-mail to users'
=> 'Emitir e-mail a usuarios',

   'Broadcast E-mail'
=> 'Emitir e-mail',

   'Broadcast e-mail to Domain'
=> 'Emitir e-mail al Dominio',

   'Send a new e-mail to selected users from this domain'
=> 'Enviar un nuevo e-mail a usuarios selecionados de este dominio',

   'Display e-mail sent by Domain Coordinators in this domain'
=> 'Mostrar e-mail enviado por Coordinadores de Dominio en este dominio',

   'Select Audience'
=> 'Selecionar audiencia',

   'Choose e-mail audience'
=> 'Elija audiencia de e-mail',

   'Roles:'
=> 'Funciones de Usuario:',

   'Courses:'
=> 'Cursos:',

   '[_1] selected.'
=> '[_1] seleccionado',

   'Access status:'
=> 'Estado de Acceso:',

   'Username -> E-mail conversion:'
=> 'Conversión Usuario -> E-Mail:',

   'Building valid e-mail address from username, if missing from preferences:'
=> 'Construyendo una dirección de e-mail válida usando el nombre de usuario, sino de las preferencias:',

   'Kerberos: enter default for each realm used in the domain, with comma separation of entries'
=> 'Kerberos: entrar cada realm por defecto usado en el dominio, con separación de coma cada entrada',

   '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).'
=> '(p.e. MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).',

   'Internal, Filesystem and Local authentication: enter single default.'
=> 'Autenticación Interna, Sistema, y Local: Entrar un único valor predeterminado.',

   'Authentication Method'
=> 'Método de Autenticación',

   'Username -> e-mail conversion'
=> 'Conversión Usuario -> e-mail',

   'Internal (LON-CAPA)'
=> 'Interno (LON-CAPA)',

   'username@'
=> 'usuario@',

   'Local/Customized'
=> 'Local/Personalizado',

   'Filesystem (UNIX)'
=> 'Sistema (UNIX)',

   'Compose E-mail'
=> 'Redactar E-Mail',

   'No recipients identified'
=> 'Destinatarios sin identificar',

   'Broadcast e-mail display options'
=> 'mostrar opciones de emisión de e-mail',

   'Date range:'
=> 'Rango de Fechas:',

   'Earliest to display:'
=> 'Primera a mostrar:',

   'Latest to display:'
=> 'Última a mostrar:',

   'Choose sender(s):'
=> 'Elegir remitente(s):',

   'Display e-mail'
=> 'Mostrar e-mail',

   'E-mail display'
=> 'E-mail a mostrar',

   'Display Broadcast e-mail'
=> 'Mostrar Emisión de e-mail',

   'No mail sent matching supplied criteria'
=> 'No hay E-mail enviado que coincida con criterios de búsqueda',

   'Customrole'
=> 'Personalizar Función',

   'Defined by [_1] at [_2].'
=> 'Definido por [_1] en [_2].',

   'No students found.'
=> 'No se encontró Estudiantes.',

   'Spreadsheet'
=> 'Hoja de Cálculo',

   'Spreadsheet Help'
=> 'Asistecia con Hoja de Cálculo',

   'Editing Help'
=> 'Asistencia en Edición',

   'Help on printing'
=> 'Asistencia en impresión',

   'Metadata Diffs'
=> 'Diferencias en Metadatos',

   'Retrieve Metadata'
=> 'Recuperar Metadatos',

   'Enter course'
=> 'Entrar curso',

   'Enter Course'
=> 'Entrar Curso',

   'Enter Access Key to Unlock this Course'
=> 'Entrar llave de acceso para desbloquear este Curso',

   'Verifying Access Key to Unlock this Course'
=> 'Verificando llave de acceso para desbloquear este Curso',

   'Successfully registered key'
=> 'Llave registrada exitosamente',

   'Re-Enter Key'
=> 'Re-entrar llave',

   'Assigned from [_1] at [_2] for [_3]'
=> 'Asignado desde [_1] a [_2] por [_3]',

   'Total Matches'
=> 'Coincidencias totales',

   'Time Remaining'
=> 'Tiempo Restante',

   'IMPORT'
=> 'IMPORTAR',

   'Help on slots'
=> 'Asistencia con franjas horarias',

   'New user accounts in [_1]'
=> 'Cuentas nuevas de usuario en [_1]',

   'Student enrollment changes in [_1]'
=> 'Cambios en registro de estudiantes en [_1]',

   'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:'
=> '[quant,_1,El siguiente cambio ocurrió,Los siguientes cambios ocurrieron] en [_2] - [_3] como resultado de la actualización automática de la lista de clase:',

   'No institutional classlist data could be retrieved for [_1]'
=> 'No pudo ser recuperada lista de clase institucional para [_1]',

   'Not within time window for auto-enrollment in [_1]'
=> 'No está dentro de ventana de tiempo para registro automatizado en [_1]',

   'Auto-enrollment not currently enabled for [_1]'
=> 'Registro automatizado actualmente sin activar para [_1]',

   'The courseID provided does not match a course in this domain.'
=> 'El curso ID provisto no coincide con algún curso en este dominio.',

   'Not Open'
=> 'Sin Abrir',

   "This resource currently isn't open. It will be available at [_1]."
=> "Este recurso actualmente no está abierto. Estará disponible el [_1]",

   'Could not handle ambiguous resource reference'
=> 'No se puede procesar referencia ambigua del recurso',

   'The nature of the problem is unclear'
=> 'La naturaleza del problema no esta claro',

   'Course Roster'
=> 'Lista de Curso',

   'Classlist'
=> 'Lista de Curso',

   'Display of a student-viewable course roster is not currently enabled.'
=> 'Visualización de Lista de Curso visible al estudiante está desactivada.',

   'Student-viewable course roster'
=> 'Lista de curso visible al estudiante',

   'Students with no section'
=> 'Estudiantes sin sección',

   'Students in section "[_1]"'
=> 'Estudiantes en sección "[_1]"',

   'Students in any section'
=> 'Estudiantes en cualquier sección',

   'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.'
=> 'Solo estudiantes que optaron por ser mostrados en la lista ([_1] de [_2] estudiantes) son visibles.',

   'The single student without a section[_1] has opted not to be listed in the roster.'
=> 'El estudiante sin sección[_1] ha optado no ser mostrado en la lista en la clase.',

   'The single student in the section[_1] has opted not to be listed in the roster.'
=> 'El estudiante en la sección[_1] ha optado no ser mostrado en la lista en la clase.',

   'The single student in the course[_1] has opted not to be listed in the roster.'
=> 'El estudiante en el curso[_1] ha optado no ser mostrado en la lista en la clase.',

   'None of the [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Ninguno de los [_1] estudiantes sin sección[_2] ha optado ser mostrado en la lista en la clase.',

   'None of the [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Ninguno de los [_1] estudiantes en la sección[_2] ha optado ser mostrado en la lista en la clase.',

   'None of the [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Ninguno de los [_1] estudiantes en el curso[_2] ha optado ser mostrado en la lista en la clase.',

   'All [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Todos los [_1] estudiantes sin sección[_2] ha optado ser mostrado en la lista en la clase.',

   'All [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Todos los [_1] estudiantes en la sección[_2] ha optado ser mostrado en la lista en la clase.',

   'All [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Todos los [_1] estudiantes en el curso[_2] ha optado ser mostrado en la lista en la clase.',

   'The single student without a section[_1] has opted to be listed in the roster.'
=> 'El estudiante sin sección[_1] ha optado ser mostrado en la lista en la clase.',

   'The single student in the section[_1] has opted to be listed in the roster.'
=> 'El estudiante en la sección[_1] ha optado ser mostrado en la lista en la clase.',

   'The single student in the course[_1] has opted to be listed in the roster.'
=> 'El estudiante en el curso[_1] ha optado ser mostrado en la lista en la clase.',

   'All [_1] students without a section[_2] are listed in the roster.'
=> 'Todos los [_1] estudiantes sin sección[_2] están mostrados en la lista.',

   'All [_1] students in the section[_2] are listed in the roster.'
=> 'Todos los [_1] estudiantes en la sección[_2] están mostrados en la lista.',

   'All [_1] students in the course[_2] are listed in the roster.'
=> 'Todos los [_1] estudiantes en el curso[_2] están mostrados en la lista.',

   'There is only a single student without a section[_1]'
=> 'Solo hay un estudiante sin sección[_1].',

   'There is only a single student in the section[_1]'
=> 'Solo hay un estudiante en la sección[_1].',

   'There is only a single student in the course[_1]'
=> 'Solo hay un estudiante en el curso[_1].',

   'There are currently no students to display.'
=> 'No hay actualmente estudiantes que mostrar.',

   'Available Portfolio files'
=> 'Archivos de Portafolio disponibles',

   'Name not given'
=> 'Nombre no dado',

   '[quant,_1,file,files,No files]'
=> '[quant,_1,Archivo,Archivos,Sin archivos]',

   'Error retrieving file information.'
=> 'Error recuperando archivo de información',

   'Your roster setting'
=> 'Su configuración de su lista',

   'You are currently listed in the student-viewable roster.'
=> 'Usted está actualmente mostrado en la lista visible de estudiantes.',

   'You are currently <b>not</b> listed in the student-viewable roster.'
=> 'Usted <b>no</b> está actualmente mostrado en la lista visible de estudiantes.',

   'Include yourself in the roster?'
=> '¿Se incluye usted mismo en la lista?',

   'Display of your name in the student-viewable roster set to <b>[_1]</b>.'
=> 'Visualización de su nombre en la lista visible de estudiantes configurado a <b>[_1]</b>.',

   'Error occurred saving display setting.'
=> 'Ocurrió un error guardando configuración de visualización.',

   'Display of your name in the student-viewable roster unchanged (set to <b>[_1]</b>).'
=> 'Visualización de su nombre en la lista visible de estudiantes sin cambios (configurado a <b>[_1]</b>).',

   'View course roster'
=> 'Ver lista del curso',

   'Change Course Page Preferences'
=> 'Cambiar Página de Preferencias del Curso',

   'Change Course Page Pref'
=> 'Cambiar Página de Pref. del Curso',

   'No context.'
=> 'Sin contexto.',

   'unable to verify variable URL'
=> 'No se pudo verificar URL',

   'Receipt'
=> 'Recibo',

   'Problems during Course Initialization'
=> 'Problemas durante Inicialización del Curso',

   'Try Selecting Again'
=> 'Seleccione otra vez',

   '<br />Invalid map: <tt>[_1]</tt>'
=> '<br />Mapa inválido: <tt>[_1]</tt>',

   'Please either [_1]close this window[_2] or [_3]log in again[_4].'
=> 'Por favor [_1]cierre esta ventana[_2] o [_3]ingrese otra vez[_4].',

   'Thank you for using LON-CAPA.'
=> 'Gracias por usar LON-CAPA.',

   'You have been successfully logged out.'
=> 'Se desconectó exitosamente.',

   'You can [_1]close this window[_2] now.'
=> 'Ahora puede [_1]cerrar esta ventana[_2].',

   '[_1]Log in again[_2]'
=> '[_1]Conectarse otra vez[_2]',

   'No matches found in resources.'
=> 'No se encontró coincidencias en recursos.',

   'No matches found in postings.'
=> 'No se encontró coincidencias en mensajes de foro.',

   'Unable to understand the search phrase [_1]. Please modify your search.'
=> 'Sin poder entender la frase de búsqueda [_1]. Por favor modifique su búsqueda.',

   'Unable to understand the search phrase [_1]: [_2]'
=> 'Sin poder entender la frase de búsqueda [_1]: [_2]',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> 'No llenó la informació suficiente para empezar la búsqueda. Necesita llenar los campos relevantes en la página de búsqueda para que se pueda procesar su solicitud.',

   'conditionally hidden'
=> 'condicionalmente oculto',

   'Problem Parameters'
=> 'Parámetros de Problemas',

   'No group name provided.'
=> 'Falta nombre de grupo',

   'Invalid group name provided.'
=> 'Nombre de grupo provisto inválido',

   'Invalid [_1]'
=> 'Inválido [_1]',

   '"[_1]" is not the name of a valid group in this [_2].'
=> '"[_1]" no es el nombre de un grupo válido en esta [_2].',

   'You do not have privileges to view the membership roster in this group.'
=> 'No tiene privilegios para ver la lista de membresía en este grupo.',

   'Group membership status - [_1]'
=> 'Estado de membresía grupal - [_1]',

   'group membership status - [_1]'
=> 'estado de membresía grupal - [_1]',

   'There are no membership data to display for this group.'
=> 'No hay datos de membresía que mostrar para este grupo.',

   'Membership status: '
=> 'Estado de membresía: ',

   'There are no groups to display in this [_1].'
=> 'No hay grupos que mostrar en esta [_1].',

   'Start Date'
=> 'Fecha Inicial',

   'End Date'
=> 'Fecha Final',

   'Functionality'
=> 'Funcionalidad',

   'Privileges'
=> 'Provilegios',

   'Any Membership status'
=> 'Estado de cualquier membresía',

   'Active Member'
=> 'Miembro Activo',

   'Former Member'
=> 'Ex-miembro',

   'Future Member'
=> 'Miembro Futuro',

   'Group Folder - [_1]'
=> 'Carpeta Grupal - [_1]',

   'Group homepage - [_1]'
=> 'Página Web Grupal - [_1]',

   'A support request has been sent to'
=> 'Una solicitud de asistencia ha sido enviada a',

   'Your support request contained the following information'
=> 'Su solicitud de asistencia contiene la siguiente información',

   'The following Cc e-mail address is invalid: '
=> 'La siguente dirección CC e-mail es inválida: ',

   'The following Cc e-mail addresses are invalid: '
=> 'Las siguentes direcciones CC e-mail son inválidas: ',

   'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.'
=> 'Como la dirección e-mail provista para este servidor LON-CAPA ([_1]) parece no ser una dirección e-mail válida, su solicitud de asistencia <b>no</b> se envió al equipo de apoyo o administrador LON-CAPA de su institución.',

   'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.'
=> 'En cambio, una copia fue enviada al equipo de apoyo LON-CAPA de Michigan State University.',

   'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.'
=> 'El archivo de captura de pantalla cargado ([_1] bytes) incluído con su solicitud, excedió el tamaño máximo permitido - 128Kb, y por tanto fue rechazado.',

   'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].'
=> 'Un archivo de captura de pantalla cargado [_1] ([_2] bytes) fue incluído en la solicitud enviada por [_3].',

   'File does not have [_1] or [_2] starting tag'
=> 'Archivo no tiene [_1] o [_2] etiqueta de inicio',

   'File does not have [_1] or [_2] ending tag'
=> 'Archivo no tiene [_1] o [_2] etiqueta final',

   'File does not have [_1] ending tag'
=> 'Archivo no tiene [_1] etiqueta final',

   'Example'
=> 'Ejemplo',

   'Algebraic Response Problems'
=> 'Problemas de Respuesta Algebraica',

   'Chemistry Problems'
=> 'Problemas de Química',

   'Free Form Problems'
=> 'Problemas de diseño libre',

   'Handgraded Problems'
=> 'Problemas de calificación manual',

   'Miscellaneous'
=> 'Misceláneos',

   'Multiple Choice Problems'
=> 'Problemas de Opción Multiple',

   'Numerical Problems'
=> 'Problemas Numéricos',

   'Language:'
=> 'Idioma:',

   'Math Rendering:'
=> 'Representación de Fórmulas:',

   'Restrict Domain Coordinator Access'
=> 'Restringir acceso a Coordinador de Dominio',

   'By default, the Domain Coordinator can enter your construction space.'
=> 'Por defecto, el Coordinador de Dominio puede entrar en su zona de construcción',

   'Block access to construction space'
=> 'Bloquear acceso a zona de construcción',

   'jsMath'
=> 'jsMath',

   'tth (TeX to HTML)'
=> 'tth (TeX a HTML)',

   'mimetex (Convert to Images)'
=> 'mimetex (Convertir a Imágenes)',

   "It looks like you don't have the TeX math fonts installed."
=> 'Parece que no tiene los caracteres de matemática (math fonts) TeX instalados.',

   'The jsMath example on this page may not look right without them. The [_1]jsMath Home Page[_2] has information on how to download the needed fonts. In the meantime, jsMath will do the best it can with the fonts you have, but it may not be pretty and some equations may not be rendered correctly.'
=> 'El ejemplo jsMath en esta página podría no verse bien si ellas. La [_1]Página Web jsMath[_2] tiene información en como descargar los caracteres ("fonts") necesarios. Mientras tanto, jsMath hará lo mejor que pueda con los caracteres que tiene, pero puede no estar correcto y algunas ecuaciones podrían no ser representadas correctamente.',

   'jsMath:'
=> 'jsMath:',

   'tth (TeX to HTML):'
=> 'tth (TeX a HTML):',

   'mimetex (Convert to Images):'
=> 'mimetex (Convertir a Imágenes):',

   '[_1], [_2], or [_3]'
=> '[_1], [_2] o [_3]',

   'internal, optional'
=> 'interno, opcional',

   'user:domain,user:domain,...'
=> 'usuario:dominio,usuario:dominio,...',

   'user:domain,user:domain(section;section;...;*;...),...'
=> 'usuario:dominio,usuario:dominio(seccion;seccion;...;*;...),...',

   'user:domain,user:domain,*:domain'
=> 'usuario:dominio,usuario:dominio,*:dominio',

   'Course members with current access'
=> 'Miembros de Curso actualmente con acceso',

   'Course members with expired access'
=> 'Miembros del Curso con acceso expirado',

   'Course members with future access'
=> 'Miembros del Curso con acceso futuro',

   'Other Roles'
=> 'Otras Funciones',

   'Select Author'
=> 'Seleccionar Autor',

   'Non-standard Course'
=> 'Curso No Estándar',

   'Switch course role to...'
=> 'Cambiar función a...',

   'Message'
=> 'Mensaje',

   'Message (new)'
=> 'Mensaje (nuevo)',

   'Time of change'
=> 'Cambiar Hora', # not sure here ed?

   'active'
=> 'activo',

   'previous'
=> 'previo',

   'Access dates to apply for selected users'
=> 'Fechas de acceso a aplicarse para usuarios seleccionados',

   'Changes in section affiliation to apply to selected users'
=> 'Cambios en afiliación de sección a aplicarse a usuarios seleccionados',

   'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.'
=> 'Para funciones de estudiante, el cambio de sección resultará en un intercambio de sección por que los estudiantes pueden solo estar en una sección del curso a la vez.',

   'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.'
=> 'Para una función en un curso que no sea la de estudiante, un usuario puede tener funciones en más de una sección del curso a la vez.',

   "Retain each user's current section affiliations?"
=> "Retener la afiliación a la sección actual de cada usuario?",

   '(Does not apply to student roles).'
=> '(No aplica a función de estudiante).',

   '[_1]Show[_2] clicker id'
=> '[_1]Mostrar[_2] Clicker ID ',

   '[_1]Hide[_2] clicker id'
=> '[_1]Ocultar[_2] Clicker ID ',

   'Catalog:'
=> 'Catálogo:',

   'Main Categories'
=> 'Categorías Principales',

   'Show subcategories'
=> 'Mostrar subcategorías',

   'Pick main category'
=> 'Escoger categoría principal',

   'Pick subcategory'
=> 'Escoger subcategoría',

   '(No subcategories)'
=> '(Sin subcategorías)',

   'Official courses (with institutional codes)'
=> 'Cursos oficiales (con códigos institucionales)',

   'Official courses'
=> 'Cursos oficiales',

   'with institutional codes'
=> 'con códigos institucionales',

   'Self-enroll (if permitted)'
=> 'Auto-inscripción (si es permitido)',

   'No ending date'
=> 'Sin fecha de término',

   'From:[_1]'
=> 'De:[_1]',

   'To:[_1]'
=> 'A:[_1]',

   'Starts: [_1]'
=> 'Empieza: [_1]',

   'Ends: [_1]'
=> 'Termina: [_1]',

   'Ended: [_1]'
=> 'Terminó: [_1]',

   'Currently enabled'
=> 'Actualmente activado',

   '[quant,_1,section:,sections:,No sections]'
=> '[quant,_1,sección:,secciones:,sin secciones]',

   'No information available for [_1].'
=> 'Sin información disponible para [_1].',

   'Self-enrollers:'
=> 'Auto-inscritos:',

   'Choices:'
=> 'Opciones:',

   'Configure User Self-enrollment'
=> 'Configurar Auto-inscripción de usuarios',

   'View Change Logs'
=> 'Ver Cambios en Registros',

   'View Log-in History'
=> 'Ver Historial de Entradas',

   'Configure Self-enrollment'
=> 'Configurar Auto-inscripción',

   'Self-enrollment with a student role'
=> 'Auto-registro con función de estudiante',

   'Users allowed to self-enroll in this course'
=> 'Usuarios permitidos a auto-inscribirse en este curso',

   'Any user in any domain:'
=> 'Cualquier usuario en cualquier dominio:',

   'User types:'
=> 'Tipos de Usuario:',

   'any'
=> 'cualquiera',

   'Any Users'
=> 'Cualquier Usuario',

   'Any users'
=> 'Cualquier usuario',

   'Others'
=> 'Otros',

   'Additional domain:'
=> 'Dominio adicional:',

   'Users in additional domain:'
=> 'Usuarios en dominio adicional:',

   'Specific domain:'
=> 'Dominio específico:',

   'Users in specific domain:'
=> 'Usuarios en dominio específico:',

   'Other domain:'
=> 'Otro dominio:',

   'Users in other domain:'
=> 'Usuarios en otro dominio:',

   'Restrict self-enrollment to students officially registered for the course'
=> 'Restringir auto-inscripción a estudiantes oficialmente registrados para el curso',

   'Dates self-enrollment available'
=> 'Fechas de auto-inscripción disponible',

   'Starts'
=> 'Empieza',

   'Ends'
=> 'Termina',

   'Course access dates assigned to self-enrolling users'
=> 'Fechas de acceso al curso asignados para auto-inscripción de usuarios',

   'Section assigned to self-enrolling users'
=> 'Sección asignada para auto-inscripción de usuarios',

   'The following changes were made to self-enrollment settings:'
=> 'Los siguientes cambios fueron hechis a la configuración de auto-inscripción:',

   '[_1]: "[_2]" set to "[_3]".'
=> '[_1]: "[_2]" configurado a: "[_3]".',

   '"[_1]" set to "[_2]".'
=> '"[_1]" configurado a: "[_2]".',

   'No changes were made to the existing self-enrollment settings in this course.'
=> 'Sin cambios la configuración existente de auto-inscripción en este curso.',

   'Self-enrollment result'
=> 'Resultado de auto-inscripción',

   'Enroll in course'
=> 'Inscribir en curso',

   'Sections:'
=> 'Secciones:',

   'Self-enroll in course'
=> 'Auto-inscribir en curso',

   'Self-enroll in a LON-CAPA course'
=> 'Auto-inscribir en curso LON-CAPA',

   'Self-enroll'
=> 'Auto-inscribir',

   'Self-enroll in [_1]'
=> 'Auto-inscribir en [_1]',

   'Self-enrollment error'
=> 'Error en Auto-inscripción',

   'Invalid domain or course number'
=> 'Dominio o número de curso inválido',

   'Self-enrollment unavailable'
=> 'Auto-inscripción no disponible',

   'Self-enrollment is restricted to students officially registered for this course.'
=> 'Auto-inscripción está restringida a estudiantes oficialmente registrados para este curso.',

   'Self-enrollment is not currently available for this course.'
=> 'Auto-inscripción no está disponible actualmente para este curso.',

   'Self-enrollment is not currently available in this course'
=> 'Auto-inscripción no está disponible actualmente para este curso',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.'
=> 'Auto-inscripción estará disponible empezando [_1] y estará disponible a todos los usuarios LON-CAPA.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).'
=> 'Auto-inscripción estará disponible empezando [_1] y estará disponible a todos los usuarios LON-CAPA en su institución ([_2]).',

   'Self-enrollment will become available starting [_1]; please enroll at that time.'
=> 'Auto-inscripción estará disponible empezando [_1]; por favor inscribase hasta esa fecha.',

   'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.'
=> 'Aunque auto-inscripción estará disponible empezando [_1], usted es inelegible para inscripción.',

   'Self-enrollment will become available starting [_1].'
=> 'Auto-inscripción estará disponible empezando [_1].',

   'The link to the requested page could not be followed.'
=> 'El enlace a la página solicitada no pudo seguirse.',

   'The placeholder for the courseID is absent.'
=> 'El marcador de posición para el ID del curso está ausente.',

   'LON-CAPA account required'
=> 'Requiere cuenta LON-CAPA',

   'You need to be logged into LON-CAPA to self-enroll in a course.'
=> 'Necesita estar conectado en LON-CAPA para auto-incribirse en un curso.',

   'If you have an account in LON-CAPA, [_1]log-in[_2].'
=> 'Si tiene una cuenta en LON-CAPA [_1]entrar[_2].',

   'Otherwise:'
=> 'De otro modo:',

   "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account"
=> "si tiene una entrada institucional, use su [_1]Página-de-inicio-de-sesión-única[_2] de su institución para entrar, luego crear una cuenta",

   'if you have an institutional login, [_1]create an account[_2]'
=> 'si tiene una página de entrada institucional, [_1]crear una cuenta[_2]',

   'you can use an e-mail address to [_1]create an account[_2]'
=> 'puede usar su dirección de e-mail para [_1]crear una cuenta[_2]',

   'Otherwise, if you have an institutional login, [_1]create an account[_2].'
=> 'Sino, si tiene una página de entrada institucional, [_1]crear una cuenta[_2].',

   'Otherwise, you will use an e-mail address to [_1]create an account[_2].'
=> 'Sino, puede usar su dirección de e-mail para [_1]crear una cuenta[_2].',

   "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account."
=> "Sino, use su [_1]Página-de-inicio-de-sesión-única[_2] de su institución para entrar, luego crear una cuenta.",

   'You will be able to self enroll in this course once the account has been created.'
=> 'Usted podrá auto inscribirse en este curso una vez que la cuenta a sido creada.',

   'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.'
=> 'Usted podrá auto-inscribirse en este curso que seleccionó ([_1]) después que se haya conectado exitosamente.',

   'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.'
=> 'Usted debe [_1]entrar[_2] a LON-CAPA con una cuenta existente para poder inscribirse en este curso, pues la creación de cuentas en esta institución ([_3]) no está permitido cuando se auto-inscribe.',

   'You already have an active student role (section: "[_1]") in this course.'
=> 'Ya tiene una función de estudiante activa (sección "[_1]") en este curso.',

   'You have a student role (section: "[_1]") in this course which will become active [_2].'
=> 'Tiene una función de estudiante (sección "[_1]") en este curso que se activará [_2].',

   'Self-enrollment is restricted to officially registered students.'
=> 'Auto-inscripción está restringida a estudiantes oficialmente matriculados.',

   'As you are not currently registered for this course, self-enrollment is unavailable.'
=> 'Con no está actualmente matriculado en este curso, auto-inscripción no está disponible.',

   'The end date for access to this course for users who self-enroll has passed.'
=> 'La fecha final para acceso a este curso a usuarios que se auto-registran a pasado.',

   'Self-enrollment in this course was successful.'
=> 'Auto-inscripción en este curso fue exitoso.',

   'The start date for access to this course for users who self-enroll has yet to be reached.'
=> 'La fecha inicial para acceso a este curso a usuarios que se auto-registran aun no ha llegado.',

   'Your new role is available immediately, and will provide access to the course until [_1].'
=> 'Su nueva función está disponible immediatamente y le dará acceso al curso hasta [_1].',

   'Enrollment process complete'
=> 'Proceso de inscripción completo',

   'Enrollment incomplete'
=> 'Inscripción incompleta',

   'Self-enrollment in this course failed.'
=> 'Auto-inscripción en este curso falló.',

   'You are not permitted to enroll yourself in this course.'
=> 'No está permitido inscribirse usted mismo en este curso.',

   'Enter course now'
=> 'Entrar curso ahora',

   'other'
=> 'otro',

   'Self-enrollment in this course is available to any user affiliated with [_1].'
=> 'Auto-inscripción en este curso está disponible a cualquier usuario afiliado con [_1].',

   'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".'
=> 'Auto-inscripción en este curso está solo disponible a usuarios afiliados con "[_1]" que tienen el siguiente estado: "[_2]".',

   'Self-enrollment is not currently available for this course for users affiliated with [_1].'
=> 'Auto-inscripción no está actualmente disponible para este curso a usuarios afiliados con [_1].',

   'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:'
=> 'Auto-inscripción en este curso está solo disponible a usuarios afiliados con las siguientes instituciones y que tienen el estado requerido:',

   'Your registration status could not be verified.'
=> 'Su estado de matrícula no pudo ser verificado.',

   'Your registration status could not determined, because a problem occurred retrieving data.'
=> 'Su estado de matrícula no pudo ser determinado, porque ocurrió un problema accesando los datos.',

   'As no institutional course sections are currently associated with this course, your registration status is undetermined.'
=> 'Como no hay secciones de curso institucional asociado actualmente con este curso, su estado de matrícula está indeterminado.',

   '[_1]Ad hoc[_2] roles in domain [_3] --'
=> 'Funciones [_1]ad-hoc[_2] en dominio [_3] --',

   'Assemble resources'
=> 'Ensamblar recursos',

   'Create, edit, modify and publish resources'
=> 'Crear, editar, modificar y publicar recursos',

   'Create, modify and delete course groups'
=> 'Crear, modificar y eliminar grupos del curso',

   'View course groups'
=> 'Ver grupos del curso',

   'View student activity'
=> 'Ver actividad de estudiante',

   'Show full details for each course ([_1] only)'
=> 'Mostrar todos los detalles de cada curso (solo [_1])',

   'Include courses set to be hidden from catalog ([_1] only)'
=> 'Incluir cursos no listados en catálogo  (solo [_1])',

   'Include subcategories within "[_1]"'
=> 'Incluir subcategorias dentro de "[_1]" ',

   'Only show courses which allow self-enrollment'
=> 'Solo mostrar curso que permiten auto-inscripción',

   'include subdirectories'
=> 'incluir subdirectorios',

   'force republication of previously published files'
=> 'forzar republicación de archivos previamente publicados',

   'make file(s) obsolete'
=> 'hacer archivo(s) obsoleto(s)',

   'force directory level metadata over existing'
=> 'forzar metadatos en niveles de directorio sobre el existente',

   'Session could not be opened.'
=> 'Sessión no pudo ser abierta.',

   'The domain you provided is not a valid LON-CAPA domain.'
=> 'El dominio que dió no es dominio LON-CAPA válido.',

   'Student Settings'
=> 'Configuracion de estudiantes',

   'Coordinator Settings'
=> 'Configuracion de Coordinadore',

   'Author Settings'
=> 'Configuracion de autores',

   'Administrator Settings'
=> 'Configuracion de Administradores',

   'Item'
=> 'Elemento',

   'Found [_1] without responses. This resource cannot be published.'
=> 'Se encontró [_1] sin respuestas. Este recurso no puede ser publicado.',

   'LON-CAPA helpdesk'
=> 'LON-CAPA Helpdesk',

   'Create a user account in LON-CAPA'
=> 'Crear una cuenta de usuario LON-CAPA',

   'Account creation unavailable'
=> 'creación de cuenta no disponible',

   'Error creating token.'
=> 'Error creando vale.',

   'Account creation'
=> 'Creación de cuenta',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).'
=> 'Creación de una cuenta nueva de usuario usando una dirección de e-mail o un ID de entrada institucional como usuario no está permitido en esta institución: ([_1]).',

   'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].'
=> 'Creación de una cuenta nueva de usuario LON-CAPA usando una dirección de e-mail o o un ID de entrada institucional como usuario no está permitido en [_1].',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain."
=> "Aunque su usuario y contraseña fueron autenticados por el sistema de página-de-inicio-de-sesión-única de su institución, actualmente no tiene una cuenta LON-CAPA en este dominio.",

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one."
=> "Aunque su usuario y contraseña fueron autenticados por el sistema de página-de-inicio-de-sesión-única de su institución, actualmente no tiene una cuenta LON-CAPA en esta institución y no está permitido de crear una.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution."
=> "Aunque su usuario y contraseña fueron autenticados, actualmente no tiene una cuenta LON-CAPA en esta institución.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one."
=> "Aunque su usuario y contraseña fueron autenticados, actualmente no tiene una cuenta LON-CAPA en esta dominio y no está permitido de crear una.",

   'A LON-CAPA account may not be created with the username you use.'
=> 'Una cuenta LON-CAPA podría no crearse con el usuario que está usando.',

   'User Information'
=> 'Información de Usuario',

   'User information'
=> 'Información de usuario',

   'Review user information'
=> 'Revisar información de usuario',

   'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.'
=> 'Para crear una, usar la tabla de abajo para proveer su información (si procede), luego pulse el botón de "Crear cuenta LON-CAPA".',

   'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.'
=> 'Para crear una, usar la tabla de abajo para proveer su información, luego pulse el botón de [_1]Crear cuenta LON-CAPA[_2].',

   'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.'
=> 'Una cuenta de usuario será creada con la información mostrada en la tabla de abajo, cuando pulse el botón [_1]Crear cuenta LON-CAPA[_2].',

   'Confirmation'
=> 'Confirmación',

   'Confirm that you wish to create an account.'
=> 'Confirme que desea crear una cuenta.',

   'New username'
=> 'Nuevo usuario',

   'Create account'
=> 'Crear cuenta',

   'You must enter a password'
=> 'Debe entrar una contraseña.',

   'The passwords you entered did not match.'
=> 'Las contraseñas que entró no coinciden.',

   'Create account with a username provided by this institution'
=> 'Crear cuenta con nombre de usuario dado por esta institución',

   'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.'
=> 'Si tiene un ID de entrada de esta institución,[_1] podría usarlo para LON-CAPA.',

   'Type in your log-in ID and password to find out.'
=> 'Ingrese su ID de entrada y contraseña para averiguarlo.',

   'Log-in ID'
=> 'ID de entrada',

   'Create account with an e-mail address as your username'
=> 'Crear cuenta con una dirección de e-mail como su usuario',

   'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.'
=> 'De su dirección de e-mail para solicitar una cuenta LON-CAPA,[_1] Si no tiene un ID de entrada en su institución.',

   'Request LON-CAPA account'
=> 'Solicitar cuenta LON-CAPA',

   'Validation'
=> 'Validación',

   'Thank you for your request to create a new LON-CAPA account.'
=> 'Gracias por su solicitud de crear una cuenta nueva LON-CAPA.',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].'
=> 'Una solicitud fue enviada el [_1] para creación de una cuenta LON-CAPA en la siguiente institución:[_2].',

   'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]'
=> 'Para completar este proceso, por favor abrir un navegador web y entrar el siguiente URL en el marco de dirección/ubicación: [_1]',

   'A message has been sent to the e-mail address you provided.'
=> 'Un mensaje fue enviado a la dirección e-mail que dió.',

   'The message includes the web address for the link you will use to complete the account creation process.'
=> 'El mensaje incluye la dirección web para el enlace que usará para completar el proceso de creación de cuenta.',

   'The link included in the message will be valid for the next [_1]two[_2] hours.'
=> 'El enlace incluído en el mensaje será válido por las siguientes [_1]dos[_2] horas.',

   'An e-mail sent to the e-mail address associated with your LON-CAPA account includes the web address for the link you should use to complete the reset process.<br /><br />The link included in the message will be valid for the next <b>two</b> hours.'
=> 'Un E-Mail enviado a la dirección E-Mail asociada con su cuenta LON-CAPA incluye la dirección web para el enlace que debe usar para completar el proceso de reinicio.<br /><br />El enlace incluído en el mensaje será válido por las siguientes <b>dos<b> horas.',

   'An error occurred when sending a message to the e-mail address you provided.'
=> 'Ocurrió un error cuando enviaba un mensaje a la dirección e-mail que dió.',

   'An error occurred creating a token required for the account creation process.'
=> 'Ocurrió un error creando un vale requerido por el proceso de creación de cuenta.',

   'Please contact the [_1] ([_2]) for assistance.'
=> 'Por favor contacte [_1] ([_2]) para asistencia.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Lo siento, el URL provisto para completar la creación de una cuenta nueva LON-CAPA fue inválido. Puede ser que o el vale incluído en el URL fue borrado o el URL que presentó fue inválido.',

   'Sorry, the token generated when you requested creation of an account has expired.'
=> 'Lo siento, el vale generado cuando solicitó la creación de una cuenta ha expirado.',

   'Sorry, the URL generated when you requested creation of an account contained incomplete information.'
=> 'Lo siento, el URL generado cuando solicitó la creación de una cuenta contine información incompleta.',

   'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.'
=> 'Por favor envíe una [_1]nueva solicitud[_2] para creación de cuenta y siga el nuevo enlace incluído en el e-mail que se le enviará.',

   'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3]. If you did not perform this action or authorize it, please contact the [_4] ([_5]).'
=> 'Una cuenta LON-CAPA para la institución: [_1] ha sido creada [_2] desde la dirección IP: [_3]. Si no realizó esta acción ni la autorizó, por favor contacte [_4] ([_5]).',

   'A LON-CAPA account already exists for username [_1] at this institution ([_2]).'
=> 'Una cuenta LON-CAPA ya existe para el usuario [_1] en esta institución ([_2]).',

   'The password entered was also correct so you have been logged in.'
=> 'La contraseña entrada también fue correcta y ahora está conectado.',

   'Authentication failed'
=> 'Autenticación falló',

   'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].'
=> 'Un e-mail confirmando la creación de su nueva cuenta LON-CAPA fue enviado a [_1].',

   'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.'
=> 'Ocurrió un error cuando enviaba e-mail a [_1] confirmando la creación de su nueva cuenta LON-CAPA.',

   'A problem occurred when attempting to create your new LON-CAPA account.'
=> 'Ocurrió un problema cuando intentaba crear su nueva cuenta LON-CAPA.',

   'Please provide user information and a password for your new account.'
=> 'Por favor provea la información de usuario y contraseña para su cuenta nueva.',

   'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.'
=> 'Su contraseña, que debe contener al menos siete caracteres, será enviada al servidor LON-CAPA en forma encriptada.',

   'Create LON-CAPA account'
=> 'Crear cuenta LON-CAPA',

   'Could not load javascript file [_1]'
=> 'No se pudo cargar archivo javascript [_1]',

   'Invalid ID format'
=> 'Formato de ID inválido',

   'An error occurred when storing a token'
=> 'Ocurrió un error cuando guardaba un vale.',

   'You will not be able to proceed to the next stage of account creation'
=> 'No podrá continuar a la siguiente parte de la creación de cuentas.',

   'A LON-CAPA account has been created for username: [_1] in domain: [_2].'
=> 'Una cuenta LON-CAPA fue creada para el usuario: [_1] en el dominio: [_2].',

   'Account creation failed for username: [_1] in domain: [_2].'
=> 'Falló creación de cuenta para el usuario: [_1] en el dominio: [_2].',

   'User account creation is not available for the current default authentication type.'
=> 'La creación de cuenta no está para el tipo actual de autenticación.',

   'The e-mail address you provided is already in use as a username at this institution.'
=> 'La dirección de e-mail que dió ya está en uso como un usuario de esta institución.',

   'Username rules at this institution do not allow the e-mail address you provided to be used as a username.'
=> 'Las reglas de usuario de esta institución no permiten la dirección de e-mail que dió para ser usado como usuario.',

   'The e-mail address you provided may not be used as a username at this LON-CAPA institution.'
=> 'La dirección de e-mail que dió no puede ser usado como usuario en esta institución LON-CAPA.',

   'Validation of the code your entered failed.'
=> 'Validación del código que entró falló.',

   'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.'
=> 'La creación de una nueva cuenta de usuario usando una dirección de e-mail como usuario no está permitido en esta institución LON-CAPA.',

   'Type in the letters/numbers shown below'
=> 'Escriba las letras/números que aparecen a continuación',

   'You may need to reload the previous page to obtain a new token.'
=> 'Podría necesitar recargar la página anterior para obtener un nuevo vale.',

   'Unable to retrieve your log-in information - unexpected context'
=> 'No se pudo recobrar su información de entrada - contexto inesperado',

   "Your e-mail address uses the same internet domain as your institution's LON-CAPA service."
=> "Su dirección de e-mail usa el mismo dominio de internet que su institución de servicio LON-CAPA.",

   'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.'
=> 'Creación de una cuenta LON-CAPA con este tipo de dirección de e-mail como usuario no está permitido.',

   'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.'
=> 'Debería solicitar la creación de una cuenta LON-CAPA para el ID de entrada "[_1]" en su institución.',

   'Changes/page:'
=> 'Cambios/página:',

   'Window during which changes occurred:'
=> 'Período en el que se han producido cambios:',

   'This page is either empty or it only contains resources that are currently hidden'
=> 'Esta página está vacía o solo contiene recursos que actualmente estan ocultos',

   'Please use the LON-CAPA navigation arrows to move to another item in the course'
=> 'Por favor use las flechas de navegación LON-CAPA para moverse a otro elemento del curso',

   'Unable to modify requested student ([_1])'
=> 'No se pudo modificar estudiante solicitado ([_1])',

   'Unable to grade requested sequence ([_1]).'
=> 'No se pudo calificar secuencia solicitada ([_1]).',

   'No score was changed or updated.'
=> 'No se ha cambiado ni actualizado puntuación.',

   'The scores were changed for [quant,_1,problem].'
=> 'La puntuación a cambiado para [quant,_1,problema,problemas].',

   '[_1]Visit the [_2]Course/Community Catalog[_3] to view all [_4] LON-CAPA courses and communities.' # _1: <b>, _2: <a>, _3: </a> </b>, _4: domain
=> '[_1]Visite el [_2]Catálogo de Cursos/Comunidades[_3], para ver todos los cursos y comunidades LON-CAPA del dominio [_4].', # '[_1]Visite el [_2]Catálogo de Cursos[_3], para ver todos los cursos LON-CAPA del dominio [_4].',

   'If a course or community is [_1]not[_2] in your list of current courses and communities below, you may be able to enroll if self-enrollment is permitted.'
=> 'Si un curso o comunidad [_1]no[_2] está en su lista actual de cursos y comunidades, usted podría registrarse si la auto-inscripción es permitida.', # 'Si un curso [_1]no[_2] está en su lista actual de cursos, usted podría registrarse si la auto-inscripción es permitida.',

#SD begin 2008-07-02
   'When'
=> 'Cuando',

   'Who made the change'
=> 'Quien hizo el cambio',

   'Changed User'
=> 'Usuario Modificado',

   'Context'
=> 'Contexto',

   'Context:'
=> 'Contexto:',

   'After:'
=> 'Después:',

   'Before:'
=> 'Antes:',

   'User Changes'
=> 'Cambios de Usuario',

   'For this user, the default quota would be [_1]'
=> 'Para este usuario la cuota predeterminada será [_1]',

   'Search for a user and enroll as a student'
=> 'Buscar por un usuario y inscribirlo como un estudiante',

   'username is known'
=> 'usuario es conocido',

   'Create a new user'
=> 'Crear un nuevo usuario',

   'Enroll'
=> 'Inscribir',

   'User Search to enroll student'
=> 'Buscar Usuario para inscribir estudiante',

   'Select a user to enroll as a student'
=> 'Seleccionar un usuario para inscribirlo como estudiante',

   'modify' #Kontext? breadcrumb_text
=> 'modificar',

#   'userpicked' #Kontext?
#=> '',

   'as a student'
=> 'como un estudiante',

   'Set section/dates'
=> 'Establecer sección/fechas',

   'Unknown'
=> 'Desconocido',

   'You do not have privileges to assign co-author roles.'
=> 'No tiene privilegios de asignar funciones de co-autor.',

   'This user has an unrecognized authentication scheme'
=> 'Este usuario tiene un esquema de autenticación no reconocido',

   'Please alert a domain coordinator of this situation'
=> 'Por favor alertar al coordinador de dominio de esta situación',

   'Please specify login data below'
=> 'Por favor especificar datos de entrada abajo',

   'No domain specified'
=> 'Dominio sin especificar',

   'Invalid domain name'
=> 'Nombre de dominio inválido',

   'Only letters, numbers, periods, dashes, and underscores are valid.'
=> 'Solo letras, números, puntos, guiones y subrayas son válidos.',

   'You do not have the authority to modify this users authentification information'
=> 'No tiene la autoridad de modificar esta información de autenticación de usuarios',

   'New student/employee ID does not match existing ID for this user.'
=> 'Nuevo ID estudiante/empleado no coincide con ID existente para este usuario.',

   "Change is not permitted without checking the 'Force ID change' checkbox on the previous page."
=> "Cambio no está permitido sin marcar 'Forzar cambio ID' en la página anterior.",

   'Unable to successfully change environment for'
=> 'No se pudo cambiar exitosamente entorno para',

   'No roles'
=> 'Sin funciones',

   'The following fields were not updated: '
=> 'Los siguientes campos no fueron actualizados: ',

   "You do not have the authority to change this field given the user's current set of active/future [_1] roles:"
=> 'No tiene autoridad de cambiar este campo dado el conjunto actual de funciones activas/futuras [_1]:',

   "You do not have the authority to change these fields given the user's current set of active/future [_1] roles:"
=> 'No tiene autoridad de cambiar estos campos dado el conjunto actual de funciones activas/futuras [_1]:',

   'Please contact your [_1]helpdesk[_2] for more information.'
=> 'Por favor contacte su [_1]centro de asistencia(Helpdesk)[_2] para mas información.',

   '<b>[_1]</b> enrolled'
=> '<b>[_1]</b> inscrito',

   'in section [_1]'
=> 'in sección [_1]',

   'Access starts immediately'
=> 'Acceso empieza inmediatamente',

   'Access starts: '
=> 'Acceso empieza: ',

   'ends: no ending date'
=> 'termina: sin término',

   'ends: '
=> 'termina: ',

   'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.'
=> 'Si el estudiante está actualmente conectado a LON-CAPA, la nueva función estará disponible cuando el estudiante entre otra vez.',

   '(default)'
=> '(predeterminado)',

   '(default for [_1])'
=> '(predeterminado para [_1])',

   'You are not authorized to make bulk changes to user roles'
=> 'No está autorizado a hacer cambios globales a funciones de usuario',

   'You do not have permission to modify dates or sections for users'
=> 'No tiene permiso de modificar fechas o secciones de usuarios',

   'deleted'
=> 'eliminado',

   'No start date'
=> 'Sin fecha de inicio',

   'Previous [_1] changes'
=> 'Previos [_1] cambios',

   'Next [_1] changes'
=> 'Siguiente [_1] cambios',

   'There are no records to display.'
=> 'No hay registros que mostrar.',

   'There are no transactions to display.'
=> 'No hay transacciones que mostrar.',

   'Automated enrollment'
=> 'Inscripción automatizada',

   'Roster Update'
=> 'Actualizar Lista de Clase',

   'Course Creation'
=> 'Creación de Curso',

   'User Management in course'
=> 'Control de usuario en curso',

   'User Management in domain'
=> 'Control de usuario en dominio',

   'Self-enrolled'
=> 'Auto-inscrito',

   'Your search term must contain more than just spaces.'
=> 'Su término de búsqueda debe contener más que solo espacios.',

   'this course'
=> 'este curso',

   'LON-CAPA domain: '
=> 'dominio LON-CAPA:',

   'the institutional directory for domain: '
=> 'el directorio institucional para el dominio: ',

   'Please contact the [_1]helpdesk[_2] if you need to create a new user.'
=> 'Por favor, contacte [_1]Helpdesk[_2] si necesita crear un nuevo usuario.',

   'Section for self-enrolled users unchanged as the proposed section is a group'
=> 'Sección para usuarios auto-inscritos sin cambios porque la sección propuesta es un grupo',

   'Group names and section names must be distinct'
=> 'Nombres de grupo y nombres de sección deben ser distintos',

   'Section for self-enrolled users unchanged, as "all" is a reserved section name.'
=> 'Sección para usuarios auto-inscritos sin cambios porque "todos" es un nombre reservado de sección.',

   'An error occurred when saving changes to self-enrollment settings in this course.'
=> 'Ocurrió un error cuando guardaba cambios en la configuración de auto-inscripción en este curso.',

#SD end 2008-07-02

   'Server Switch Required'
=> 'Cambio de Servidor requerido',

   'Construction Space access is only available from the home server of the corresponding Author.'
=> 'Acceso a zona de construcción esta solo disponible desde el servidor local (home) del correspondiente autor.',

   "Click the 'Switch Server' link to go there."
=> "Pulsar el enlace 'Cambiar Servidor' para ir alla.",

   'Default in use:'
=> 'Predeterminado en uso:',

   'Self-creation of account by users with status: [_1]'
=> 'Auto-creación de cuenta por usuarios con estado: [_1]',

   'modifiable fields (if institutional data blank): '
=> 'campos modificables (si datos institucionales en blanco): ',

# domainprefs.pm
#   'Formats disallowed for $text{$type}: '
#=> 'Formats disallowed for $text{$type}: ',
#
#   'Format rules to check for $text{$type}: '
#=> 'Format rules to check for $text{$type}: ',

# loncommon.pm
#   "You must either choose $text{'action'} with a different format --  $text{'one'} that will not conflict with 'official' institutional $text{'items'}, or leave the ID field blank."
# => "You must either choose $text{'action'} with a different format --  $text{'one'} that will not conflict with 'official' institutional $text{'items'}, or leave the ID field blank."

   'Source Code'
=> 'Código Fuente',

   'Copy Problem Source Code to Construction Space'
=> 'Copiar código fuente del problema a zona de contrucción',

   'Please enter the directory that you would like the source code to go into.'
=> 'Por favor entre el directorio donde quiere que vaya el código fuente.',

   'Note: the path is in reference to the root of your construction space, and new directories will be automatically created.'
=> 'Nota: la ruta está en referencia al inicio de su zona de construcción, y nuevos directorios serán creados automáticamente.',

   'shared_source'
=> 'documento compartido',

   'Copy to Construction Space'
=> 'Copiar a Zona de Construcción',

   '[_1]W[_2]ARNING' # Highlight first char
=> '[_1]A[_2]DVERTENCIA',

   'At end of file some tags were still left unclosed:'
=> 'Al final del archivo algunas etiquetas quedaron aun sin cerrar:',

   'Unable to save file [_1]'
=> 'No se pudo guardar archivo: [_1]',

   'Warnings and Errors'
=> 'Advertencias y Errores',

   '[quant,_1,error]'
=> '[quant,_1,error,errores]',

   '[quant,_1,warning]'
=> '[quant,_1,advertencia,advertencias]',

   'Edit Math'
=> 'Editar Ecuación',

   'DragMath LaTeX Equation Editor'
=> 'Editor de Ecuación LaTeX DragMath',

   '[_1]Return[_2] to editing resource.'
=> '[_1]Volver[_2] a editar el recurso.',

   'Counting pages for student: [_1]'
=> 'Contando páginas a estudiante [_1]',

   'Class Print Status'
=> 'Estado de Impresión',

   'LaTeX could not successfully parse your TeX file.'
=> 'LaTeX no pudo analizar correctamente su archivo TeX.',

   'It probably has errors in it.'
=> 'Probablemente hay errores en esto.',

   'Here are the error messages in the LaTeX log file:'
=> 'Estos son los mensajes de error del archivo de registro LaTeX:',

   'There are errors in [_1].'
=> 'Hay errores en [_1].',

   'There are errors.'
=> 'Hay errores.',

   'These errors prevent this resource from printing correctly.'
=> 'Esos errores evitan que este recurso imprima correctamente.',

   'A message has been sent to the instructor describing this failure.'
=> 'Un mensaje fue enviado al instructor describiendo esta falla.',

   'You are running LaTeX in [_1]batch mode[_2].'
=> 'Está ejecutando LaTeX en [_1]modo batch[_2].',

   'It has found an error in [_1][_2]and corrected it.'
=> 'Se encontró un error en [_1][_2] y se corrigió.',

   'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.'
=> 'Usualmente esta corrección es válida pero probablemente necesita verificar el recurso indicado una vez más e implementar las correciones necesarias usted mismo.',

   'The link to [_1]Your log file[_2]'
=> 'Enlace web a [_1]Su archivo de registro[_2]',

   'The link to [_1]Your original LaTeX file[_2]'
=> 'Enlace web a [_1]Su archivo LaTeX original[_2]',

   'bomb'
=> 'Bomba',

   'Output Tags'
=> 'Etiquetas de Salida',

   'WARNING: Cannot connect to database!'
=> 'ADVERTENCIA: No se puede conectar a la base de datos!',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'ADVERTENCIA: La tabla de metadatos no existe en la base de datos LON-CAPA.',

   'Error occurred saving new values in metadata table in LON-CAPA database!'
=> 'Ocurrió un error guardando valores nuevos en la tabla de metadatos en la base de datos LON-CAPA!',

   'Your course/community currently appears in the Course/Community Catalog for this domain.'
=> 'Su curso o comunidad actualmente aparece en el Catálogo de Cursos/Comunidades para este dominio.', # 'Su curso actualmente aparece en el Catálogo de Cursos para este dominio.',

   'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.'
=> 'Cursos pueden ser ambos auto-catalogados, basados en un código institucional (p.e. fisi3172f08), o pueden asignarse categorías desde una jerarquía definida para el dominio.',

   'Your course/community does not currently appear in the Course/Community Catalog for this domain.'
=> 'Su curso o comunidad, actualmente, no aparece en el Catálogo del Cursos/Comunidades para este dominio.', # 'Su curso, actualmente, no aparece en el Catálogo del curso para este dominio.',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.'
=> 'Debe remediar esto si planea permitir auto-incripción, sino los estudiantes tendrán dificultad encontrando su curso.',

   'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.'
=> 'Cursos pueden estar suprimidos del Catálogo, porque ellos no tienen un código institucional, no tienen asignado una categoría o fueron específicamente excluídos.',

   'Make any changes to self-enrollment settings below, click "Save", then take action to include the course in the Catalog:'
=> 'Haga cualquier cambio a los parámetros de auto-inscripción, pulse "Guardar", tome acción de incluir el curso en el Catálogo:',

   'Take the following action to ensure the course appears in the Catalog:'
=> 'Tomar las siguientes acciones para asegurar que el curso aparece en el Catálogo:',

   'Ask a domain coordinator to change the "Exclude from course catalog" setting.'
=> 'Solicite al coordinador de dominio cambiar la configuración de "Excluir del católogo de cursos".',

   'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".'
=> 'Solicite al coordinador de dominio activar ver el catálogo de "Cursos oficiales (con códigos institucionales)".',

   'Ask a domain coordinator to assign an institutional code (if this is an official course).'
=> 'Solicite al coordinador de dominio asignar un código instucional (si este es un curso oficial).',

   'Ask a domain coordinator to enable or create at least one course category in the domain.'
=> 'Solicite a un coordinador de dominio activar o crear al menos una categoría de curso en el dominio.',

   'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.'
=> 'Solicite a un coordinador de dominio crear una jerarquía de categorías y subcategorías para cursos en el dominio.',

   'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain'
=> 'Solicite a un coordinador de dominio cambiar la categoria asignada para el curso, puesto que el actualmente asignado ya no es usado en el dominio',

   'Ask a domain coordinator to assign a category to the course.'
=> 'Solicite a un coordinador de dominio que le asigne una categoría a este curso.',

   'Use [_1]Set course environment[_2] to change the "Exclude from course catalog" setting.'
=> 'Usar [_1]Establecer entorno del curso[_2] para cambiar la configuración "Excluir del catálogo del curso".',

   'Use [_1]Set course environment[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.'
=> 'Usar [_1]Establecer entorno del curso[_2] para cambiar la categoría asignada al curso, como uno actualmente asignado que no esta siendo usado en el dominio.',

   'Use [_1]Set course environment[_2] to assign a category to the course.'
=> 'Usar [_1]Establecer entorno del curso[_2], para asignar una categoría al curso.',

   'You are able to both assign a course category and choose to exclude this course from the catalog.'
=> 'Usted puede asignar una categoría del curso y escoger excluir este curso del catálogo.',

   'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.'
=> 'Usted puede escoger o excluir este curso del catálogo, pero solo un Coordinador de Dominio puede asignar una categoría del curso.',

   'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.'
=> 'Usted puede asignar una categoría del curso, pero solo un Coordinador de dominio puede escoger excluir este curso del catálogo.',

   'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.'
=> 'Solo un Coordinador de dominio puede asignar una categoría del curso o escoger excluir este curso del catálogo.',

   "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter"
=> "Por favor usar el enlace web 'Seleccionar Curso' para abrir una ventana separada de selección de cursos de donde escogerá el curso que desea entrar",

   'You can only use this screen to select courses in the current domain.'
=> 'Solo puede usar esta pantalla para seleccionar cursos in el dominio actual.',

   '[_1]Your Excel spreadsheet[_2] is ready for download.'
=> '[_1]Su hoja de cálculo Excel[_2] está lista para ser descargada.',

   '[_1]Your CSV file[_2] is ready for download.'
=> '[_1]Su archivo CSV[_2] está listo para ser descargado.',

   'Name (username)'
=> 'Nombre (usuario)',

   'Grades Assigned'
=> 'Calificación Asignada',

   'Comments'
=> 'Comentarios',

   'No Course Data'
=> 'Sin Datos del Curso',

   'Error getting student data ([_1])'
=> 'Error obteniendo datos de estudiante ([_1])',

   'Score'
=> 'Puntuación',

   'score'
=> 'puntuación',

   'Display Options'
=> 'Mostrar Opciones',

   'This role has section(s) associated with it.'
=> 'Esta función tiene seccion(es) asociada(s) a esta.',

   'Enter a specific section.'
=> 'Entrar una sección específica.',

   'Enter a specific section, or leave blank for no section.'
=> 'Entrar una sección específica o deje en blanco si no hay sección',

   'Available sections are:'
=> 'Son secciones disponibles:',

   'You entered an invalid section choice:'
=> 'Entró un elección inválida de sección:',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3] domain.'
=> 'Podría querer contactar la oficina de asistencia [_1]LON-CAPA Helpdesk[_2] para el dominio [_3].',

   '([_1] time zone)'
=> '(Uso horario [_1])',

   'Selecting an Author'
=> 'Escogiendo un Autor',

   'Invalid domain.'
=> 'Dominio inválido.',

   'There are no library servers containing Construction spaces currently in domain: [_1], so you can not assume a co-author role.'
=> 'No hay servidores "library" que contengan zonas de construcción en dominio:[_1], por tanto no puede usar una función de co-autor.',

   'You do not have a domain coordinator role in domain: [_1], so you cannot choose a Construction space for which you can assume a co-author role.'
=> 'No tiene función de coordinador de dominio en dominio: [_1], por tanto no puede elegir una zona de construcción para asumir una función de co-autor.',

   'You do not have a domain coordinator role, so you cannot choose a Construction space for which you can assume a co-author role.'
=> 'No tiene función de coordinador de dominio, por tanto no puede elegir una zona de construcción para asumir una función de co-autor.',

   'There are no author roles currently in domain: [_1], so there are no Construction spaces for which you can assume a co-author role.'
=> 'No hay funciones de autor actualmente en dominio: [_1], por tanto no hay zonas de construcción para que pueda asumir una función de co-autor.',

   'As your session file for the course or community has expired, you will need to re-select it.'
=> 'Como su archivo de sesión para el curso o comunidad ha expirado, necesitará re-seleccionarlo.', # 'Como su archivo de sesión para el curso ha expirado, necesitará re-seleccionar el curso.',

   '[quant,_1,yr]'
=> '[quant,_1,Año,Años]',

   '[quant,_1,mth]'
=> '[quant,_1,Mes,Meses]',

   '[quant,_1,day]'
=> '[quant,_1,día,días]',

   '[quant,_1,hr]'
=> '[quant,_1,h,h]',

   '[quant,_1,min]'
=> '[quant,_1,min,min]',

   '[quant,_1,sec]'
=> '[quant,_1,s,s]',

   'Loading student data...'
=> 'Cargando datos de estudiante...',

   'Options'
=> 'Opciones',

   'Time Period'
=> 'Periodo de tiempo',

   'Rsource is undefined.'
=> 'Recurso no definido.',

   'Plot Graph'
=> 'Graficar',

   'Download'
=> 'Descargar',

   'PDF File'
=> 'Archivo PDF',

   'Zip File'
=> 'Archivo Zip',

   'File Size (Bytes)'
=> 'Tamaño de Archivo (Bytes)',

   'Contents'
=> 'Contenidos',

   'Problem Type'
=> 'Problema Tipo',

   'not in this course'
=> 'no en este curso',
#Start: redesigned menus
#lonparmset.pm
   'Edit environment settings for this course.'
=> 'Editar configuración de entorno para este curso',

   'Portfolio Metadata'
=> 'Portafolio Metadatos',

   'Settings for this Course'
=> 'Configuración para este curso',

   'New and Existing Parameter Settings for Resources'
=> 'Configuración de Parámetros Nuevos y Existentes para este Recurso',

   'Edit Resource Parameters - Helper Mode'
=> 'Editar Parámetros de Recurso - Modo Asistente',

   'Edit Resource Parameters - Overview Mode'
=> 'Editar Parámetros de Recurso - Modo Panorámico',

   'Edit Resource Parameters - Table Mode'
=> 'Editar Parámetros de Recurso - Modo Tabla',

   'Existing Parameter Settings for Resources'
=> 'Configuración Existente de Parámetros para este Recurso',

   'Change Log'
=> 'Cambiar Bitácora',

   'Restrict metadata for this course.'
=> 'Limitar Metadatos para este curso.',

   'Manage slots for this course.'
=> 'Control de franjas de tiempo para este curso',

   'Reset access times for folders/maps, resources or the course.'
=> 'Reiniciar tiempos de acceso para carpetas/mapas, recursos o el curso',

   'Set default actions for parameters.'
=> 'Establecer acciones predeteminadas para parámetros.',

   'Set/Modify resource parameters in helper mode.'
=> 'Establecer/Modificar parámetros de recurso en modo asistente.',

   'Set/Modify resource parameters in table mode.'
=> 'Establecer/Modificar parámetros de recurso en modo tabla.',

   'Set/Modify resource parameters in overview mode.'
=> 'Establecer/Modificar parámetros de recurso en modo panorámico.',

   'Set/Modify existing resource parameters in overview mode.'
=> 'Establecer/Modificar parámetros existentes de recurso en modo panorámico.',

   'View parameter and course blog posting/user notification change log.'
=> 'Ver registro de cambios de parámetro y mensajes blog del curso/notificación de usuario.',
#lonpreferences.pm
   'Screen Name'
=> 'Nombre de Ventana',

   'Messages &amp; Notifications'
=> 'Mensajes y Notificaciones',

   'Discussion Display'
=> 'Visualización de Discusión',

   'Page Display Settings'
=> 'Página de Visualización de Configuración',

   'Color Scheme'
=> 'Esquema de Colores',

   'Menu Display'
=> 'Visualizar Menú',

   'Content Display Settings'
=> 'Configuración de Visualización de Contenidos',

   'WYSIWYG Editor'
=> 'Editor WYSIWYG',

   'Roles Page'
=> 'Página de Funciones',

   'Display of Scientific Equations'
=> 'Visualización de Ecuaciones Científicas',

   'Edit information about yourself that should be displayed on your public profile.'
=> 'Editar información acerca de usted que debería mostrarse en su perfil público.',

   'Change the name that is displayed in your posts.'
=> 'Cambiar el nombre que es mostrado en sus mensajes de foro.',

   'Change LON-CAPA default colors.'
=> 'Cambiar colores predefinidos de LON-CAPA.',

   'Change messageforwarding or notifications settings.'
=> 'Cambiar configuración de reenvío de mensajes o notificaciones.',

   'Choose the default language for this user.'
=> 'Escoger el idioma predefinido para este usuario.',

   'Enable or disable the WYSIWYG-Editor.'
=> 'Activar o desactivar el Editor WYSIWYG.',

   'Configure the roles hotlist.'
=> 'Configurar la lista de funciones más usadas.',

   'Change how Scientific Equations are displayed.'
=> 'Cambiar como las Ecuaciones Científcas son vistas.',

   'Register your clicker.'
=> 'Registrar su Clicker.',

   'Change your password.'
=> 'Cambiar su contraseña.',

   'Launch the remote control for LON-CAPA.'
=> 'Lanzar el control remoto para LON-CAPA.',

   'Collapse the remote control for LON-CAPA.'
=> 'Desactivar el control remoto para LON-CAPA.',

   'Restrict domain coordinator access.'
=> 'Restringir acceso del coordinador de dominio.',

   'Set the default page to be displayed when you select a course role.'
=> 'Predefinir la página a ser mostrada cuando seleccione su función del curso.',

   'Toggle Debug Messages.'
=> 'Decidir activar los Mensajes de Depuración',

   'Change whether the menus are displayed with buttons, icons or icons and text.'
=> 'Decidir cambiar si los menús son mostrados con botones, iconos o iconos y texto.',

   'Course Initialization'
=> 'Inicialización de Curso',

#loncreateuser.pm
   'Single Users'
=> 'Usuarios individuales',

   'Upload a CSV or a text file containing users.'
=> 'Cargar un archivo CSV o texto con usuarios.',

   'Single Course User'
=> 'Un Usuario del Curso',

   'Add a user with a certain role to this course.'
=> 'Añadir un usuario con cierta función en este curso.',

   'Add/Modify a Student'
=> 'Añadir/Modificar un Estudiante',

   'Add a user with the role student to this course.'
=> 'Añadir un usuario con función de estudiante en este curso.',

   'Configuration'
=> 'Configuración',

   'Automated enrollment manager.'
=> 'Control de inscripción Automatizada.',

   'Self-Enrollment'
=> 'Auto Inscripción',

   'User Self-Enrollment'
=> 'Auto inscripción de Usuario',

   'Configure user self-enrollment.'
=> 'Configurar auto inscripción de usuario.',

   'Manage course groups.'
=> 'Control de grupos del curso.',

   'Change Logs'
=> 'Cambiar Registros.',

   'View change log.'
=> 'Ver cambios en registros.',

   'Administration'
=> 'Administración',

   'Manage Course Users'
=> 'Control de Usuarios del Curso',

   'Show and manage users of this course.'
=> 'Mostrar y Control de usuarios de este curso.',

   'Remove a student from this course.'
=> 'Eliminar un estudiante de este curso.',

   'Custom Roles'
=> 'Personalizar Funciones',

   'Configure a custom role.'
=> 'Configurar una función personalizada.',

   'Enrollment Requests'
=> 'Solicitudes de Inscripción',

   'Approve or reject enrollment requests.'
=> 'Aprobar or rechazar solicitud de inscripción',

   'Multiple Users'
=> 'Usuarios multiples',

#lonstatistics.pm
   'Statistics and Analyses'
=> 'Estadística y Análisis',

   'Plots'
=> 'Gráficas',

   'Reports'
=> 'Reportes',

   'Paste failed: an error occurred saving the composite page'
=> 'Pegar falló: ocurrió un error guardando la página compuesta.',

   'Paste failed: an error occurred saving the folder'
=> 'Pegar falló: ocurrió un error guardando la carpeta.',

   'Paste failed: an error occurred creating a unique URL for the composite page'
=> 'Pegar falló: ocurrió un error creando un URL único para la página compuesta.',

   'Paste failed: an error occurred creating a unique URL for the folder'
=> 'Pegar falló: ocurrió un error creando un URL único para la carpeta.',

#grades.pm

   'Manual Grading/View Submissions'
=> 'Calificación Manual/Ver Envíos',

   'This problem has been graded correct by the computer. Do you want to change the score?'
=> "Este problema fue calificado 'correcto' por la computadora. ¿Quiere cambiar la calificación?",

   'Process Clicker'
=> 'Procesar Clicker',

   'Grade/Manage/Review Bubblesheets'
=> 'Calificar/Control de/Revisar hoja de respuestas(bubblesheet)',

   'Start the process of hand grading submissions.'
=> 'Empezar el proceso de calificar manualmente los envíos.',

   'Grade bubblesheet exams, upload/download bubblesheet data files, and review previously graded bubblesheet exams.'
=> 'Calificar hoja de respuestas de exámenes, cargar/descargar archivo de datos de hojas de respuesta, y revisar hoja de respuesta de exámenes anteriores.',

   'Grade all selected students in a grading table.'
=> 'Calificar todos los estudiantes seleccionados de tabla.',

   'Select individual students to grade and view submissions.'
=> 'Seleccionar estudiantes individuales a calificar y ver envíos.',

   'Course Grading'
=> 'Calificación del Curso',

   'Grade Complete Folder for One Student'
=> 'Calificar Carpeta Completa para Un estudiante',

   'The <b>complete</b> page/sequence/folder: For one student'
=> 'La página/secuencia/carpeta <b>completa</b>:. Para un estudiante',

   'Revert to Default'
=> 'Restaurar a valores predeterminados',

   'Fullname'
=> 'Nombre Completo',

   '(problem weight)'
=> '(peso del problema)',

   'No.'
=> 'Nr.',

   '<b>Current Resource: </b>[_1]'
=> '<b>Recurso Actual: </b>[_1]',

   'Grade Current Resource'
=> 'Calificar Recurso Actual',

   'Submission Status'
=> 'Estado de Envíos',

   'last submission only'
=> 'solo último envío',

   'last submission &amp; parts info'
=> 'último envío e informe de partes',

   'by dates and submissions'
=> 'por fechas y envíos',

   'all details'
=> 'todos los detalles',

   'one student'
=> 'un estudiante',

   'all students'
=> 'todos los estudiantes',

   'View Problem Text'
=> 'Ver Texto de Problema',

   'View Answer'
=> 'Ver Respuesta',

   'Grading Increments'
=> 'Incrementos en Puntuación',

   'Whole Points'
=> 'Puntos Enteros',

   'Half Points'
=> 'Medios Puntos',

   'Quarter Points'
=> 'Cuarto de Puntos',

   'Tenths of a Point'
=> 'Décimo de Punto',

   'View Submissions for a Student or a Group of Students'
=> 'Ver envíos para un estudiante o un grupo de estudiantes',

   'View/Grade/Regrade Submissions for a Student or a Group of Students'
=> 'Ver/Calificar/Recalificar envíos para un estudiante o un grupo de estudiantes',

   "To view a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button."
=> "Para ver un envío o un grupo de envíos, pulse en la(s) caja(s) que sigue(n) al nombre de l(os) estudiante(s). Luego pulse en el botón Siguiente.",

   "To view/grade/regrade a submission or a group of submissions, click on the check box(es) next to the student's name(s). Then click on the Next button."
=> "Para ver/calificar/recalificar un envío o un grupo de envíos, pulse en la(s) caja(s) que sigue(n) al nombre de l(os) estudiante(s). Luego pulse en el botón Siguiente.",

   'Check Section/Group'
=> 'Elija Sección/Grupo',

   'Check For Plagiarism'
=> 'Revise por Plagio',

   'Please select the student before clicking on the Next button.'
=> 'Por favor, seleccione el estudiante antes de pulsar el botón Siguiente.',

   'Please select a student or group of students before clicking on the Next button.'
=> 'Por favor, seleccione un estudiante o grupo de estudiantes antes de pulsar el botón Siguiente.',

   'Select a student you wish to grade and then click on the Next button.'
=> 'Seleccione un estudiante que desea calificar y luego pulsar el botón Siguiente.',

   'Verify Receipt No.'
=> 'Verificar Recibo Nr.',

   'Please enter a receipt number given by a student in the receipt box.'
=> 'Por favor entrar un número de recibo dado por un estudiante en la recepción.',

   'No match found for the above receipt number.'
=> 'No hay registros para el número de recibo mostrado.',

   'The above receipt number matches the following [quant,_1,student].'
=> 'El número de recibo mostrado coincide con [quant,_1,el siguiente estudiante,los siguientes estudiantes].',

   'Problems from'
=> 'Problemas desde',

   'Grade Status'
=> 'Estado de Calificación',

   'Override "Correct"'
=> 'Sobreescribir "Correcto"',

   'reset status'
=> 'reiniciar estado',

   'excused'
=> 'escusado',

   '<b>Note:</b> Problems graded correct by the computer are marked with a [_1] symbol.'
=> '<b>Nota:</b> Problemas calificados correcto por la computadora son marcados con un símbolo [_1].',

   'Problems graded correct by the computer are marked with a [_1] symbol.'
=> 'Problemas calificados correcto por la computadora están marcados con un símbolo [_1].',

   'Part(s) graded correct by the computer is marked with a [_1] symbol.'
=> 'Parte(s) calificada(s) correcto por la computadora está marcado con un símbolo [_1].',

   'Add Records'
=> 'Añadir Registros',

   'Require return receipt?'
=> '¿Requerir acuso de recibo?',

   'Self-enrollment requests need approval?'
=> 'Solicitud de auto-inscripción ¿Necesita aprobación?',

   'Enrollment limit'
=> 'Límite de Incripción',

   'Personnel to be notified when an enrollment request needs approval, or has been approved:'
=> 'Personal a se notificado cuando una solicitud de inscripción necesita aprobación, o ha sido aprobado:',

   'No limit'
=> 'Sin límite',

   'Limit by total students'
=> 'Límite por el total de estudiantes',

   'Limit by total self-enrolled students'
=> 'Límite por el total de estudiantes auto inscritos',

   'Maximum number allowed: '
=> 'Máximo número permitido: ',

   'Maximum enrollment setting unchanged.'
=> 'Configuración de incripción máxima sin cambio.',

   'The value provided was invalid - it must be a positive integer if enrollment is being limited.'
=> 'El valor dado fue inválido - debe ser un entero positivo si inscripción esta siendo limitada.',

   'New self-enrollment no longer allowed when total (all students) reaches [_1].'
=> 'Nuevas auto-inscripciones ya no son permitidas cuando se alcanza el total (todos los estudiantes) [_1].',

   'New self-enrollment no longer allowed when total number of self-enrolled students reaches [_1].'
=> 'Nuevas auto-inscripciones ya no son permitidas cuando número total de estdiantes auto-inscritos alcanza [_1].',

   'The following will be notified when an enrollment request needs approval, or has been approved: [_1].'
=> 'Lo siguiente será notificado cuando una solicitud de inscripción necesita aprobación, o ha sido aprobado: [_1]',

   'No notifications sent when an enrollment request needs approval, or has been approved.'
=> 'No se enviará notificaciones cuando una solitud de inscripción necesita aprobación, o ha sido aprobado.',

   'Enrollment requests'
=> 'Solicitudes de inscripción',

   'Pending enrollment requests'
=> 'Solicitudes de inscripción pendientes',

   'Enrollment request processing'
=> 'procesando solicitud de inscripción',

   'Requestor'
=> 'Solicitante',

   'Date requested'
=> 'Fecha solicitada',

   'Approve'
=> 'Aprobar',

   'Reject'
=> 'Rechazar',

   'There are currently no enrollment requests.'
=> 'Actualmente no hay solicitudes de inscripción',

   'The following were enrolled in the course:'
=> 'Los siguientes fueron inscritos en el curso:',

   'The following were enrolled in the community:'
=> 'Los siguientes fueron inscritos en la comunidad:',

   'The following enrollment requests were rejected:'
=> 'Las siguientes solicitudes de inscripción fueron rechazadas:',

   'Action was taken on the following course and community requests by [_1].'
=> 'Se tomó acción en las solicitudes de curso y comunidad por [_1].',

   'The following enrollment requests were deleted because the user is already enrolled in the course:'
=> 'Las siguientes solicitudes de inscripción fueron eliminadas porque el usuario ya está inscrito en el curso:',

   'The following enrollment requests were ignored because the request is no longer in the enrollment queue:'
=> 'Las siguientes solicitudes de inscripción fueron ignoradas porque el solicitante ya no está en lista de inscripción:',

   'The following enrollment requests were deleted because the requestor does not have a LON-CAPA account:'
=> 'Las siguientes solicitudes de inscripción fueron eliminadas porque el solicitante no tiene una cuenta LON-CAPA:',

   'The following enrollment requests were skipped because the enrollment limit has been reached for the course:'
=> 'Las siguientes solicitudes de inscripción fueron omitidas porque el límite de inscripción fue alcanzado para el curso:',

   'The following enrollment requests could not be processed because an error occurred:'
=> 'Las siguientes solicitudes de inscripción no pudieron ser procesadas porque ocurrió un error:',

   'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].'
=> 'En consecuencia, aunque una nueva función fue creada para usted en el curso, no podrá seleccionar esta función hasta [_1].',

   'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.'
=> 'En consecuencia, aunque una nueva función fue creada para usted en el curso, esta es una función inactiva que no le da acceso al curso.',

   'The enrollment limit of [quant,_1,student] has been reached.'
=> 'El límite de inscripción de [quant,_1,estudiante,estudiantes] fue alcanzado.',

   'The enrollment limit of [quant,_1,self-enrolled student] has been reached.'
=> 'El límite de inscripción de [quant,_1,estudiante auto-inscrito,estudiantes auto-inscritos] fue alcanzado.',

   'A self-enrollment request already exists for you for this course.'
=> 'Una solicitud de auto-inscripción para usted ya existe en este curso.',

   'Your earlier request was submitted: [_1] and remains in a queue awaiting action by a Course Coordinator.'
=> 'Su solicitud anterior fue enviada: [_1] y permanece en lista esperando acción por el Coordinador del Curso.',

   'Your request for self-enrollment has been recorded.'
=> 'Su solicitud de auto-inscripción ha sido registrada.',

   'A message will be sent to your LON-CAPA account when the course coordinator takes action on your request.'
=> 'Un mensaje será enviado a su cuenta LON-CAPA cuando el coordinador del curso tome acción en su solicitud.',

   'A message will be sent to your LON-CAPA account when a domain coordinator takes action on your request.'
=> 'Un mensaje será enviado a su cuenta LON-CAPA cuando un coordinador de dominio tome acción en su solicitud.',

   'An e-mail will also be sent to: [_1] when this occurs.'
=> 'Un E-Mail también será enviado a: [_1] cuando esto ocurre.',

   'An error occurred when recording your request.'
=> 'Ocurrió un error cuando se registraba su solicitud.',

   'Self-enrollment requests processed'
=> 'Solicitudes de auto-inscripción procesadas',

   'Enrollment requests in the following course: [_1] have been processed.'
=> 'Solicitudes de inscripción en el siguiente curso: [_1] ha sido procesado.',

   'Your request for enrollment in the following course: [_1], requested on [_2], has been reviewed by a Course Coordinator.'
=> 'Su solicitud de inscripción en el siguiente curso: [_1], solicitado en [_2], ha sido revisado por el Coordinador del Curso.',

   'Your request for enrollment in the following community: [_1]requested on [_2]has been reviewed by a Coordinator.'
=> 'Su solicitud de inscripción en la siguiente comunidad: [_1], solicitado en [_2], ha sido revisado por el Coordinador.',

   'Self-enrollment request'
=> 'Solicitar auto-inscripción',

   'Your request for enrollment has been approved.'
=> 'Su solicitud de inscripción fue aprobada.',

   'As Course Coordinator, use [_1]Main Menu -> Manage Course Users -> "Enrollment Requests"[_1] to display a list of pending enrollment requests which you can either approve or reject.'
=> 'Como Coordinador de Curso, usar [_1]Menú Principal -> Control de Usuarios del Curso -> "Solicitud de Inscripción"[_1] para mostrar una lista de solicitud de inscraripción pendiente que puede ser aprobada o rechazada.',

   'Visit [_1], to log-in and access the course'
=> 'Visitar [_1], para conectarse y accesar el curso.',

   'Your request for enrollment has not been approved.'
=> 'Su solicitud de inscripción no fue aprobada.',

   'Enrollment in the following course: [_1] was requested by [_2] on [_3].'
=> 'Inscripción en el siguiente curso: [_1] fue solicitado por [_2] en [_3].',

   'Approved enrollments:'
=> 'Inscripciones aprobadas:',

   'Rejected enrollments:'
=> 'Inscripciones rechazadas:',

   'Approved course requests:'
=> 'Solicitudes de curso aprobadas:',

   'Rejected course requests:'
=> 'Solicitudes de curso rechazadas:',

   'An error occurred generating the validation code[_1] required for an e-mail address to be used as username.'
=> 'Ocurrió un error generando el código de validación[_1], requerido para que una dirección e-Mail sea usada como usuario.',

   '[_1]Contact the helpdesk[_2] or [_3]reload[_2] the page and try again.'
=> '[_1]Contactar Helpdesk[_2] o [_3]recargar[_2] la página de tratar otra vez.',

   'An error occurred saving a personal record of your request.'
=> 'Ocurrió un error guardando un registro personal que solició.',

   'An error occurred saving a record of the details of your request: [_1].'
=> 'Ocurrió un error guardando un registro de los detalles de su solicitud: [_1].',

   'An error occurred saving a record of the status of your request: [_1].'
=> 'Ocurrió un error guardando un registro del estado de su solicitud: [_1].',

   'Enrollment requests pending Course Coordinator approval'
=> 'Solicitud de inscripción pendiente de aprobación del Coordinador del Curso',

   ' not allowed to participate in chat room.'
=> ' no permitido de participar en chats.',

   'Everyone can participate in chat room.'
=> 'Todos pueden participar en chats.',

   'Chat Room will be unavailable to you until [_1] because communication is blocked in one or more of your courses:'
=> 'La sala de Chat no estará disponible a usted hasta [_1] porque la comunicación esta bloqueada en uno o más de sus cursos:',

   'Branch'
=> 'Rama',

   'Can Request Official Courses'
=> 'Puede solicitar Cursos Oficiales',

   'Can Request Unofficial Courses'
=> 'Puede solicitar Cursos NO Oficiales',

   'Disk space allocated to portfolio files'
=> 'Espacio de disco asignado a archivos portafolio',

   'Personal Information Page Availability'
=> 'Disponibilidad de Páginade Información Personal',

   'Blog Availability'
=> 'Disponibilidad de Blog',

   'Portfolio Availability'
=> 'Disponibilidad de Portafolio',

   'Tools:'
=> 'Herramientas:',

   'Upload PDF Form'
=> 'Cargar Formulario PDF',

   'Upload a PDF Form with filled Form Fields'
=> 'Cargar un Formulario PDF con los campos llenos',

   'Please choose a PDF-File.'
=> 'Por favor escoja un archivo PDF.',

   "Can't find any valid PDF formfields."
=> 'No se encontró ningún campo válido PDF',

   'Results of PDF Form problems'
=> 'Resultados de problemas de Formulario PDF',

   'Request creation of a course or community'
=> 'Solicitar creación de un curso o comunidad',

   'You have rights to request the creation of courses and/or communities in the following domain(s):'
=> 'Tiene derechos de solicitar la creación de curso y/o comunidades en los siguientes dominios:',

   '[_1]Official course[_2] in domain: [_3]'
=> '[_1]Curso oficial[_2] en dominio: [_3]',

   '[_1]Unofficial course[_2] in domain: [_3]'
=> '[_1]Curso no oficial[_2] en dominio: [_3]',

   '[_1]Community[_2] in domain: [_3]'
=> '[_1]Comunidad[_2] en dominio: [_3]',

   'Use the [_1]request form[_2] to submit a request for creation of a new course or community.'
=> 'Use la  [_1]solicitud[_2] para someter un pedido de creación de un curso nuevo o comunidad.',

   'A number equal or greater than 0 is expected. Entered value = '
=> 'Se espera un número igual o mayor que 0. Valor entrado = ',

   'A role with no section will be added'
=> 'Una función de usuario sin sección será añadido',

   'Access will be set to continue indefinitely'
=> 'Se establecerá acceso para continuar indefinidamente',

   'Access will be set to start immediately'
=> 'Se establecerá acceso para empezar inmediatamente',

   'Add a user with a co- or assistant author role.'
=> 'Añadir un usuario con función de co- o asistente de autor.',

   'Add a user with the role of student to this course'
=> 'Añadir un usuario con función de estudiante a este curso',

   'Recipients'
=> 'Destinatarios',

   'Additional recipient:'
=> 'Destinatarios adicionales:',

   'Allow limited HTML in discussion'
=> 'Permitir HTML limitado en discusión',

   'Although your current role has privileges to view any existing groups in this course, you do not have privileges to create new groups.'
=> 'Aunque su función actual tiene privilegios de ver cualquier grupo existente en este curso, no tiene privilegios de crear grupos nuevos.',

   'An error occurred opening the export file for posting'
=> 'Ocurrió un error abriendo el archivo exportado para foro',

   'An error occurred opening the manifest file.'
=> 'Ocurrió un error abriendo el archivo de manifiesto.',

   'Announcements and my calendar'
=> 'Anuncios y mi calendario',

   'Course anouncements and my calendar'
=> 'Anuncios del curso y mi calendario',

   'Are you sure you want to delete this post?'
=> '¿Está seguro de borrar este mensaje de discusión?',

   'Deleted posts will no longer be visible to you and other students'
=> 'Mensajes borrados no serán visibles a usted ni a otros estudiantes',

   'but will continue to be visible to your instructor'
=> 'pero continuarán visibles a su instructor.',

   'Deleted posts will no longer be visible to you or anyone else.'
=> 'Mensajes borrados no serán visibles a usted ni a nadie mán.',

   'Category'
=> 'Categoria',

   'Choose a category to display'
=> 'Escoja una categoría a mostrar',

   'Choose a subcategory to display'
=> 'Escoja una subcategoría a mostrar',

   'Change Parameter Selection'
=> 'Cambiar Parámetro de Selección',

   'No messages have been selected to apply this action to.'
=> 'No hubo mensajes seleccionados a quién aplicar esta acción.',

   'Check the checkbox for at least one message.'
=> 'Marque la casilla de al menos un mensaje.',

   'Classlist of all students'
=> 'Lista de clase de todos los estudiantes',

   'Classlists and Staff Listing'
=> 'Listas de clase y personal',

   'Clone From'
=> 'Clonar de',

   'Clone content and settings from an existing course?'
=> '¿Clonar contenido y configuración de un curso existente?',

   'Clone content and settings from an existing community?'
=> '¿Clonar contenido y configuración de una comunidad existente?',

   'Course Configuration'
=> 'Configuración de Curso',

   'Course Contents'
=> 'Contenido de Curso',

   'Community Content'
=> 'Contenido de Comunidad',

   'Community Contents'
=> 'Contenido de Comunidad',

   'Course Policy'
=> 'Política del Curso',

   'Course Requests'
=> 'Solicitudes de Cursos',

   'Course Request'
=> 'Solicitud de Curso',

   'Community Request'
=> 'Solicitud de Comunidad',

   'Course Request Details'
=> 'Destalles de Solicitud de Curso',

   'Community Request Details'
=> 'Detalles de Solicitud de Comunidad',

   'Course/Community Request Details'
=> 'Detalles de Solicitud de Curso/Comunidad',

   'Course/Community Requests'
=> 'Solicitudes de Curso/Comunidad',

   'Course/Community requests'
=> 'Solicitudes de curso/comunidad',

   'Create a New Slot'
=> 'Crear Franja Horaria nueva',

   'Current recipient:'
=> 'Destinatario actual:',

   'Current recipients:'
=> 'Destinatarios actuales:',

   'Date Submitted:'
=> 'Fecha Enviada:',

   'Disallowed:'
=> 'Prohibido:',

   'disallowed'
=> 'prohibido',

   'allowed'
=> 'permitido',

   'Discussion and Chat'
=> 'Discusión y Chat',

   'Discussion for'
=> 'Discusión para',

   'Display Categories'
=> 'Mostrar Categorías',

   'Display Groups'
=> 'Mostrar Grupos',

   'Display List of Users'
=> 'Mostrar Lista de Usuarios',

   'Display of resources '
=> 'Mostrar los recursos ',

   'Display/Edit Settings'
=> 'Mostrar/Editar Configuración',

   'Back to display/edit settings'
=> 'Volver a "Mostrar/Editar Configuración"',

   'Drop Members'
=> 'Retirar Miembros',

   'Edit Course Configuration'
=> 'Editar Configuración del Curso',

   'Enroll one member'
=> 'Registrar un miembro',

   'Enroll Another Member'
=> 'Registrar otro miembro',

   'Enroll Member'
=> 'Registrar Miembro',

   'Enroll one member: '
=> 'Registrar un miembro: ',

   'Feedback Settings'
=> 'Configuración de Reacción',

   'Feedback messages'
=> 'Mensajes de Reacción',

   'Feedback sent'
=> 'Feedback wurde gesendet',

   'Filters'
=> 'Filtros',

   'Force use of a specific math rendering engine'
=> 'Forzar uso de represención de matemóticas específico',

   'General course settings'
=> 'Configuración general del curso',

   'General message text'
=> 'Mensaje general de texto',

   "Go to group's home page"
=> 'Ir a página grupal',

   'Hide detailed Parameter Selection'
=> 'Ocultar Selección de Parámetro detallada',

   'Import Document'
=> 'Importar Documento',

   'Import Documents'
=> 'Importar Documentos',

   'Language and Time Localization'
=> 'Idioma y Huso horario',

   'Math display settings'
=> 'Configuración de Visulización de Fórmulas',

   'Messages & Notifications'
=> 'Mensajes y Notificaciones',

   'Min Tries'
=> 'Min num. Intentos',

   'Modify course configuration'
=> 'Modificar configuración del curso',

   'More Options'
=> 'Más opciones',

   'Neutral'
=> 'Neutral',

   'New Name for Folder'
=> 'Nombre Nuevo de Carpeta',

   'New posts marked as read'
=> 'Mensajes Nuevos marcados como leídos',

   'New request'
=> 'Solicitud Nueva',

   'No Chat room use'
=> 'Sin canal de Chat',

   'No Resource Discussion'
=> 'Sin Recurso de Discusión',

   'No message or record in user notes'
=> 'Sin mensajes ni registros en notas de usuario',

   'No slots have been created in this course.'
=> 'Sin franjas horarias creadas en este curso.',

   'No slots have been created in this community.'
=> 'Sin franjas horarias creadas en esta comunidad.',

   'No user personal information page available'
=> 'Sin página personal de usuario disponible',

   'No viewable classlist'
=> 'Sin lista de clase visible',

   'No viewable membership list'
=> 'Sin lista de membresía visible',

   'Official course'
=> 'Curso Oficial',

   'Other settings'
=> 'Otras Configuraciones',

   'Page Title'
=> 'Título de Página',

   'Parameter Specification'
=> 'Especificación de Parámetro',

   'Resource Specification'
=> 'Especificación de Recurso',

   'User Specification (optional)'
=> 'Especificación de usuario (opcional)',

   'Pick the criteria to use to build a list of course users from which you will select additional members of the group.'
=> 'Elija el criterio a usar para construir una lista de usuarios del curso de donde seleccionará miembros adicionales del grupo.',

   'Pick the criteria to use to build a list of course users from which you will select members of the new group.'
=> 'Elija el criterio a usar para construir una lista de usuarios del curso de donde seleccionará miembros del nuevo grupo.',

   'Points'
=> 'Puntos',

   'Privileged users (Domain Coordinators) in staff listing'
=> 'Usuarios Privilegiados (Coordinadores de Dominio) en lista de personal',

   'Questions about:'
=> 'Preguntas acerca de:',

   'Registering'
=> 'Registrando',

   'Request creation of a new course, or review your pending course requests.'
=> 'Solicitar creación de un curso nuevo, o revisar su solicitud de curso pendiente.',

   'Request creation of a new course, or review your pending requests.'
=> 'Solicitar creación de un curso nuevo, o revisar su solicitud pendiente.',

   'Request creation of a new course or community, or review your pending requests.'
=> 'Solicitar creación de un curso nuevo o comunidad, o revisar su solicitud pendiente.',

   'Resource Content'
=> 'Contenido del Recurso',

   'Roles will be added for section(s):'
=> 'Funciones serán añadidas para seccion(es):',

   'Table of course contents'
=> 'Tabla de contenido del curso',

   'Manage Reservations'
=> 'Control de Reservas',

   'Manage reservations'
=> 'Control de reservas',

   'Manage Slots'
=> 'Control de Franjas Horarias',

   'Manage slots'
=> 'Control de franjas horarias',

   'Search for a user and enroll as a member'
=> 'Buscar por un usuario y registrarlo como un miembro',

   "Sections will be switched to 'No section'"
=> "Secciones serán cambiadas a 'Sin sección'",

   'Sections will be switched to:'
=> 'Secciones serán cambiadas a:',

   'Select a destination folder to which the messages will be moved.'
=> 'Selecionar una carpeta de destino adonde los mensajes serán movidos.',

   'Show Source'
=> 'Mostrar Fuente',

   'Show and manage co- or assistant authors.'
=> 'Mostrar y Control de co-autores y asistentes de autor.',

   'Show and manage users in this course.'
=> 'Mostrar y Control de usuarios en este curso.',

   'Spreadsheet: (with link to detailed scores)'
=> 'Hoja de Cálculo: (con enlace a puntaje detallado)',

   'Standard: shows points'
=> 'Estándar: mostrar puntos',

   'Statistics Main Page'
=> 'Página principal de Estadística',

   'Published Map'
=> 'Mapa Publicado',

   'Size limit'
=> 'Tamaño límite',

   'String to display for answer:'
=> 'Expresión a mostrar por respuesta:',

   'Student agreement needed to be listed'
=> 'Consentimiento del estudiante requerido para ser listado',

   'Student-viewable classlist options'
=> 'Opciones de lista de clase visible a estudiantes',

   'The administrator of this domain has disabled personal information page functionality for this specific user.'
=> 'El administrador de este dominio ha desabilitado la funcionalidad de la página de información personal para este usuario específico.',

   'The default privileges new members will receive are:'
=> 'Los privilegios predefinidos que los nuevos miembros recibirán son:',

   'The domain has been configured to disable, by default, personal information page functionality for all users in the domain.'
=> 'El dominio ha sido configurado para desabilitar, por defecto, la funcionalidad de la página de información personal de todos los usuarios de este dominio.',

   'The file format for the uploaded portion of the message is'
=> 'El formato de archivo para la parte cargada del mensaje es',

   'The folder may not be renamed'
=> 'La carpeta no pudo ser renombrada',

   'The new folder may not be named'
=> 'La nueva carpeta no pudo ser nombrada',

   'There are currently no resources or discussion boards with unread discussion postings.'
=> 'Actualmente no hay recursos o foros de discusión con mensajes de discusión sin leer.',

   'This is a result of one of the following:'
=> 'Esto es el resultado de uno de los siguientes:',

   'Timezone in which the course takes place'
=> 'Huso horario en el cual el curso toma lugar',

   "To enter multiple addresses, enter one address at a time, click 'Change' and then add the next one"
=> "Para entrar direcciones multiples, entre una a la vez, pulse 'Cambiar' y entonces añada la siguiente",

   'To replace the standard title for a course role, enter a title, otherwise leave blank'
=> 'Para reemplazar el título predefinido para una función de curso, entre un título, sino deje en blanco',

   'Tries Statistics'
=> 'Estadística de Intentos',

   'URL of Syllabus'
=> 'URL del Plan de Estudios',

   'Unable to determine section, groups and access status'
=> 'No se pudo determinar sección, grupos ni estado de acceso',

   'Upload Slot List'
=> 'Cargar Lista de Franjas Horarias',

   'Users can edit/delete own discussion posts'
=> 'Usuarios pueden editar/borrar sus propios mensajes de discusión',

   'Users can print problems as PDF forms and upload later for grading'
=> 'Usuarios pueden imprimir problemas como archivos PDF y cargarlos después para calificación',

   "View a user's recent activity"
=> 'Ver actividad reciente de usuario',

   'View class lists'
=> 'Ver lista de clase',

   'View recent activity of this student'
=> 'Ver actividad reciente de este estudiante',

   'View/Modify/Cancel pending requests'
=> 'Ver/Modificar/Cancelar solicitudes pendientes',

   'You are not permitted to request creation of a community this domain.'
=> 'No tiene permiso de solicitar creación de una comunidad en este dominio.',

   'You are not permitted to request creation of an official course in this domain.'
=> 'No tiene permiso de solicitar creación de un curso oficial en este dominio.',

   'You are not permitted to request creation of an unofficial course in this domain.'
=> 'No tiene permiso de solicitar creación de un curso no oficial en este dominio.',

   'You must provide a (brief) community description.'
=> 'Debe proveer una (breve) descripción de la comunidad.',

   'You must provide a (brief) course description.'
=> 'Debe proveer una (breve) descripción del curso.',

   'member name'
=> 'nombre del miembro',

   'role name'
=> 'nombre de la función',

   "Classlist of viewer's section"
=> 'Lista de clase de la sección del observador',

   "Membership of viewer's section"
=> "Membresía de la sección del observador",

   'Default dates for student access'
=> 'Fechas predefinidas para acceso de estudiantes',

   'Replacement titles for standard course roles'
=> 'Reemplazo de títulos para funciones estándar del curso',

   'not using syllabus template)'
=> 'Sin usar plantilla de Plan de Estudios)',

   '(applies when current role is student)'
=> '(aplica cuando función actual es estudiante)',

   '(overrides individual user preference)'
=> '(reemplaza la preferencia de usuario individual)',

   '(role-based)'
=> '(basado-función)',

   '- does not correspond to the name of an existing group'
=> '- no corresponde al nombre de un grupo existente',

   'Currently using [_1] of the [_2] available.'
=> 'Actualmente usando [_1] de [_2] disponibles.',

   '#Wrng'
=> '#Advertencia',

   'Assign Grade'
=> 'Asignar Calificación',

   'Reset times on a single folder/map, resource or the course for a section or the whole class.'
=> 'Reiniciar tiempos a una Carpeta/un Mapa, un recurso o el curso para una sección o toda la clase.',

   'Reset times on one or more folders/maps, resources or the course for a single student.'
=> 'Reiniciar tiempos a una o más Carpetas/Mapas, recursos o el curso para un sólo estudiante.',

   '(specific user(s))'
=> '(usuario(s) específico(s))',

   'Owner and Coordinators included automatically'
=> 'Dueño y Coordinadores incluídos automáticamente',

   'A Community title is required'
=> 'Un título de la Comunidad es necesario',

   'A coordinator role will be added with access to all sections'
=> 'Una función de coordinador será añadido con acceso a todas las secciones',

   'A course coordinator role will be added with access to all sections.'
=> 'Una función de coordinador de curso será añadido con acceso a todas las secciones.',

   "A group folder is added to the 'Community Groups' folder which contains folders for all groups in the community."
=> "Una Carpeta grupal es añadido a la carpeta 'Grupos de Comunidad' el cual contiene carpetas de todos los grupos en la comunidad.",

   "A group folder is added to the 'Course Groups' folder which contains folders for all groups in the course."
=> "Una Carpeta grupal es añadido a la carpeta 'Grupos del Curso' el cual contiene carpetas de todos los grupos en el curso.",

   'A problem occurred when attempting to reset the password for your account. Please contact the [_1] - ([_2]) for assistance.'
=> 'Ocurrió un problema cuando intentaba reiniciar la contraseña de su cuenta. Por favor contacte el [_1] - ([_2]) para asistencia.',

   'A problem occurred when attempting to reset the password for your account. Please try again from your [_1]home server[_2].'
=> 'Ocurrió un problema cuando intentaba reiniciar la contraseña de su cuenta.  Por favor trate de nuevo desde su [_1]servidor local[_2].',

   '(Less ...)'
=> '(Menos ...)',

   '(More ...)'
=> '(Mas ...)',

   '(in [_1])'
=> '(en [_1])',

   'A request was submitted on [_1] for reset of the password for your LON-CAPA account.'
=> 'Se envió una solicitud el [_1], para reiniciar la contraseña de su cuenta LON-CAPA.',

   'Add registered students automatically'
=> 'Añadir estudiantes registrados automáticamente',

   'Additional Display Specification (optional)'
=> 'Especificación adicional de visualización (opcional)',

   'Additional Personnel'
=> 'Personal adicional',

   'Additional language:'
=> 'Idioma adicional:',

   'Additional options'
=> 'opciones adicionales',

   'Affected User'
=> 'Usuarios afectados',

   'All types'
=> 'Todos los tipos',

   'Although almost all community settings can be modified by a Coordinator, the following may only be set or modified by a Domain Coordinator:'
=> 'Aunque casi toda la configuración de la comunidad puede ser modificada por un Coordinador, lo siguiente solo puede ser establecido o modificado por un Coordinador de Dominio:',

   'Although almost all course settings can be modified by a Course Coordinator, the following may only be set or modified by a Domain Coordinator:'
=> 'Aunque casi toda la configuración del curso puede ser modificada por un Coordinador de Curso, lo siguiente solo puede ser establecido o modificado por un Coordinador de Dominio:',

   'An error occurred retrieving information about resources in the course.'
=> 'Ocurrió un error recuperando información sobre recursos in en curso.',

   'An error occurred retrieving the link to this problem.'
=> 'Ocurrió un error recuperando el enlace a este problema.',

   'An error occurred saving your request in the pending requests queue.'
=> 'Ocurrió un error guardando su solicitud en la lista de solicitudes pendientes.',

   'An error occurred storing the quota for group portfolio files: '
=> 'Ocurrió un error estableciendo la cuota para los archivos de portafolio grupal: ',

   'An error occurred when processing your community request.'
=> 'Ocurrió un error cuando procesaba su solicitud de comunidad.',

   'An error occurred when processing your course request.'
=> 'Ocurrió un error cuando procesaba su solicitud de curso.',

   'An error occurred when removing community settings which are no longer in use.'
=> 'Ocurrió un error cuando se eliminaba configuración de la comunidad que no esta en uso.',

   'An error occurred when removing course settings which are no longer in use.'
=> 'Ocurrió un error cuando se eliminaba configuración del curso que no esta en uso.',

   'An error occurred when saving changes to community settings, which remain unchanged.'
=> 'Ocurrió un error cuando se guardaba los cambios a la configuración de la comunidad, que permanecieron sin cambios.',

   'An error occurred when saving changes to course settings, which remain unchanged.'
=> 'Ocurrió un error cuando se guardaba los cambios a la configuración del curso, que permanecieron sin cambios.',

   'An error occurred when updating the pending requests queue: [_1]'
=> 'Ocurrió un error cuando se actualizaba la lista de solicitudes pendientes: [_1]',

   'Approval by Dom. Coord.'
=> 'Aprobación por Coord. Dom.',

   'Approve or reject requests'
=> 'Aprobar o rechazar solicitudes',

   'Are you sure you want to cancel this request?\\n'
=> '¿Está seguro de querer cancelar su solicitud?\\n',

   'Assign one or more categories and/or subcategories to this course.'
=> 'Asignar una o más categorías y/o subcategorías a este curso.',

   'Assign one or more subcategories to this community.'
=> 'Asignar una o más subcategorías a esta comunidad.',

   'Authentication mechanism'
=> 'Mecanismo de autenticación',

   'Bcc: community participants with current access'
=> 'BCC: participantes de comunidad con acceso actual',

   'Bcc: community participants with expired access'
=> 'BCC: participantes de comunidad con acceso expirado',

   'Bcc: community participants with future access'
=> 'BCC: participantes de comunidad con acceso futuro',

   'Because of this student/employee ID conflict, the new username - [_1] - has not been added to the LON-CAPA classlist'
=> 'Porque hay conflicto de este ID de estudiante/empleado, el nuevo usuario - [_1] - no ha sido añadido a la lista de clase LON-CAPA',

   'Bubblesheet'
=> 'Hoja de Respuesta',

   'Cancel Request'
=> 'Cancelar Solicitud',

   'Cancel community request'
=> 'Cancelar solicitud de comunidad',

   'Cancel course request'
=> 'Cancelar solicitud de curso',

   'Cancelling the request will remove it from the queue of pending community requests'
=> 'La cancelación de la solicitud la removerá de la lista de solicitud de comunidades pendientes',

   'Cancelling the request will remove it from the queue of pending course requests'
=> 'La cancelación de la solicitud la removerá de la lista de solicitud de cursos pendientes',

   'Check username'
=> 'Verificar usuario',

   'Choose another server.'
=> 'Seleccione otro servidor.',

   'Communities: description, section(s), status'
=> 'Comunidades: descripción, seccion(es), estado',

   'Community Blog'
=> 'Blog de Comunidad',

   'Community owner (permitted to assign Coordinator roles in the community).'
=> 'Dueño de Comunidad (con permiso de asignar funciones de Coordinador en la comunidad).',

   'Course owner (permitted to assign Course Coordinator roles in the course).'
=> 'Dueño de Curso (con permiso de asignar funciones de Coordinador de Curso en el curso).',

   'Confirm Cancellation'
=> 'Confirmar Cancelación',

   'Copy saved but not submitted.'
=> 'Copia guardada pero no enviada.',

   'Current settings are:'
=> 'Configuración actual es:',

   'Custom text for '
=> 'Texto personalizado para ',

   'Define new user'
=> 'Definir nuevo usuario',

   'Deleted setting for [_1]'
=> 'Configuración borrada de [_1]',

   'Display Actions'
=> 'Mostrar Acciones',

   'Display Course/Community Catalog link?'
=> '¿Mostrar enlace de Catálogo de Curso/Comunidad?',

   'View creation log'
=> 'Ver bitácora de creación',

   'Display information about when, how and by whom courses and communities were created in this domain.'
=> 'Mostrar información sobre cuándo, cómo y por quién fuerun creados los cursos y comunidades en este dominio.',

   'Domain does not exist'
=> 'Dominio no existe',

   'Drop unregistered students automatically'
=> 'Retirar estudiantes sin registrar automáticamente',

   'Enrollment'
=> 'Inscripción',

   'Enrollment Ends'
=> 'Inscripción Termina',

   'Enrollment Starts'
=> 'Inscripción Empieza',

   'Enter a file name: '
=> 'Entrar nombre de archivo: ',

   'Font Size'
=> 'Tamaño de Caracter',

   'Format'
=> 'Formato',

   'Go to Automated Enrollment Manager for course'
=> 'Ir a Control de Inscripción automática del curso',

   'Go to the login page'
=> 'Ir a la Página de entrada',

   'Home Server for Course'
=> 'Sevidor Local para el Curso',

   'ID/Student Number'
=> 'ID/Número de Estudiante',

   'IMS Export Failed'
=> 'Exportar IMS falló',

   'If automated enrollment at your institution requires validation of course owners, automated enrollment will fail.'
=> 'Si la incripción automática en su institución requiere validación de dueño de curso, la incripción automática fallará.',

   'If the member is currently logged-in to LON-CAPA, the new role will be available when the member next logs in.'
=> 'Si el miembro tiene sesión activa en LON-CAPA, la nueva función estará disponible cuando el miembro vuelva a entrar.',

   'If unexpected discrepancies were detected, it is recommended that you inspect the original bubblesheets.'
=> 'Si discrepancias inesperadas fueron detectadas, se recomienda que revise las Hojas de respuesta originales.',

   'Include other personnel?'
=> '¿Incluir otro personal?',

   'Intended course owner does not exist'
=> 'Supuesto dueño del curso no existe',

   'Invalid LON-CAPA course number for the new course'
=> 'Número de curso LON-CAPA inválido para el curso nuevo',

   'Invalid course ID'
=> 'ID del curso inválido',

   'Invalid filename: '
=> 'Nombre de archivo inválido: ',

   'Invalid format'
=> 'Formato inválido',

   'Invalid slot name: [_1]'
=> 'Nombre de franja horaria inválido: [_1]',

   'LON-CAPA user(s) do(es) not exist.'
=> 'Usuario(s) LON-CAPA no existe(n).',

   'LON-CAPA will automatically scale your uploaded file so the image will not exceed a width of 400px and a height of 500px.'
=> 'LON-CAPA escalará automaticamente su archivo cargado tal que la imagen no exceda un ancho de 400px y un alto de 500px.',

   'List of all members'
=> 'Lista de todos los miembros',

   'Modifiable only by Domain Coordinator'
=> 'Modificable solo por el Coordinador de dominio',

   'Name already used as a standard role name'
=> 'Nombre ya usado como nombre de función estándar',

   'Name already used as the name of a custom role'
=> 'Nombre ya usado como nombre de función personalizada',

   'Name already used to replace a different standard role name'
=> 'Name wird bereits verwendet, um einen anderen Standard-Rollennamen zu ersetzen',

   'Next Item'
=> 'Siguiente Elemento',

   'No Domain Coordinators have community roles'
=> 'No hay Coordinadores de dominio que tienen funciones de comunidad',

   'No Domain Coordinators have course roles'
=> 'No hay Coordinadores de dominio que tienen funciones de curso',

   'No categories defined in this domain'
=> 'No hay categorías definidas en este dominio',

   'No categories defined in this domain.'
=> 'No hay categorías definidas en este dominio.',

   'No course was found matching your choice of institutional course category.'
=> 'No se encontró curso que coincida su elección de categoría de curso institucional.',

   'No information was found for this community request.'
=> 'No se encontró información para esta solicitud de comunidad.',

   'No information was found for this course request.'
=> 'No se encontró información para esta solicitud de curso.',

   'No record exists for the course ID'
=> 'No existe registro para el ID del curso',

   'No settings chosen'
=> 'No elegió configurar',

   'No suitable categories defined for this course type in this domain.'
=> 'No hay categorías apropiadas definidas para este tipo de curso en este dominio.',

   "None specified - use member's choice"
=> 'No especificado - usar elección de miembro',

   "None specified - use student's choice"
=> 'No especificado - usar elección de estudiante',

   'Not permitted'
=> 'No permitido',

   'Note: this will not take effect if the user already exists'
=> 'Nota: esto no será efectivo si el usuario ya existe',

   'OK'
=> 'OK',

   'ok'
=> 'ok',

   'Official'
=> 'Oficial',

   'Official course:'
=> 'Curso oficial:',

   'Only courses and communities created from servers running LON-CAPA [_1] or later are displayed.'
=> 'Solo curso y comunidades creados desde servidores corriendo LON-CAPA versión [_1] o superior son mostrados.',

   'Pending community requests'
=> 'Solicitudes de comunidad pendientes',

   'Pending course/community requests'
=> 'Solicitudes de curso/comunidad pendientes',

   'Pending requests for official courses'
=> 'Solicitudes de cursos oficiales pendientes',

   'Pending requests for unofficial courses'
=> 'Solicitudes de cursos no oficiales pendientes',

   'Personnel'
=> 'Personal',

   'Pick another action'
=> 'Elija otra acción',

   'Problem is available at a different location.'
=> 'El problema está disponible en diferente lugar.',

   'Problem is currently available.'
=> 'El problema está disponible actualmente.',

   'Problem is unavailable.'
=> 'El problema no está disponible.',

   'Problem will be available later.'
=> 'El problema estará disponible mas tarde.',

   'Quit Grading'
=> 'Terminar de Calificar',

   'Recipients of '
=> 'Destinatarios ',

   'Records/page:'
=> 'Registros/página:',

   'Redo'
=> 'Repetir',

   'Requested'
=> 'Solicitado',

   'Requestor is automatically assigned Coordinator role.'
=> 'Solicitante es automáticamente asignado Coordinador.',

   'Requestor is automatically assigned Course Coordinator role.'
=> 'Solicitante es automáticamente asignado Coordinador de curso.',

   'Required'
=> 'Requerido',

   'Return to Community Editor'
=> 'Volver al Editor de Comunidad',

   'Return to reservations'
=> 'Volver a reservaciones',

   'Role(s) for [_1]'
=> 'Funcion(es) para [_1]',

   'Save Selected'
=> 'Guardar seleccionadas',

   'Save map'
=> 'Guardar mapa',

   'Save map and layout'
=> 'Guardar mapa y diseño',

   'Search for a user to add to course personnel'
=> 'Buscar por usuario a añadir al personal del curso',

   'Select a user to enroll as a member'
=> 'Seleccionar usuario a registrar como un miembro',

   'Search for user'
=> 'Buscar por usuario',

   'LON-CAPA Section(s)'
=> 'Seccion(es) LON-CAPA',

   'LON-CAPA Sections'
=> 'Secciones LON-CAPA',

   'LON-CAPA section'
=> 'Sección LON-CAPA',

   'Section names may only contain letters or numbers.'
=> 'Los nombres de sección sólo pueden contener letras o números',

   'Sections for auto-enrollment'
=> 'Secciones para auto-inscripción',

   'See course contents for further information.'
=> 'Ver contenido de curso para más información',

   'Select all that are <b>[_1]</b>.'
=> 'Seleccionar todos los que son <b>[_1]</b>',

   'Selected [_1]Problems[_2] from page [_3]'
=> '[_1]Problemas[_2] selecionados desde página [_3]',

   'Selected [_1]Resources[_2] from page [_3]'
=> '[_1]Recursos[_2] seleccionados desde página [_3]',

   'Separate multiple sections with a comma.'
=> 'Separar secciones multiples con una coma.',

   'Settings for this community have been left unchanged.'
=> 'Configuración de esta comunidad ha quedado sin cambio.',

   'Settings for this course have been left unchanged.'
=> 'Configuración de este curso ha quedado sin cambio.',

   'Skip hidden resources'
=> 'Saltar recursos ocultos',

   'Subcategory ...'
=> 'Subcategoría ...',

   'Submit Grades'
=> 'Enviar Calificaciones',

   'Submit community request'
=> 'Enviar solicitud de comunidad',

   'Submit course request'
=> 'Enviar solicitud de curso',

   'TeX error message: [_1]'
=> 'mensaje de error TeX: [_1]',

   'The chosen course category [_1] is valid.'
=> 'La categoría de curso escogida [_1] es válida.',

   'The community you selected is not a valid community in this domain'
=> 'La comunidad seleccionada no es una comunidad válida en este dominio',

   'The course roster is not up to date'
=> 'La lista del curso no está actualizada',

   'The disk space allocated for group portfolio files in this community is the default quota for this domain: [_1] Mb.'
=> 'El espacio de disco asignado para archivos de portafolio grupal en esta comunidad es la cuota predeterminada para este dominio: [_1] Mb.',

   'The disk space allocated for group portfolio files in this course is the default quota for this domain: [_1] Mb.'
=> 'El espacio de disco asignado para archivos de portafolio grupal en este curso es la cuota predeterminada para este dominio: [_1] Mb.',

   'The disk space allocated for group portfolio files is now: [_1] Mb.'
=> 'El espacio de disco asignado para archivos de portafolio grupal es ahora: [_1] Mb.',

   'The disk space allocated for group portfolio files remains unchanged as [_1] Mb.'
=> 'El espacio de disco asignado para archivos de portafolio grupal permanece sin cambio [_1] Mb.',

   'The file was uploaded to the wrong course'
=> 'El archivo fue cargado al curso incorrecto',

   'The following changes occurred:'
=> 'Los siguientes cambios ocurrieron:',

   'The following course/community creation request rejections could not be fully processed because an error occurred:'
=> 'Las siguientes solicitudes de creación de curso/comunidad rechazadas no pudieron ser completamente procesadas porque ocurrió un error:',

   'The following course/community creation requests could not be processed because an error occurred:'
=> 'Las siguientes solicitudes de creación de curso/comunidad no pudieron ser procesadas porque ocurrió un error:',

   'The following course/community creation requests could not be processed because the owner does not have rights to create this type of course:'
=> 'Las siguientes solicitudes de creación de curso/comunidad no pudieron ser procesadas porque el dueño no tiene derechos de crear este tipo de curso:',

   'The following course/community creation requests were deleted because the course or community has already been created:'
=> 'Las siguientes solicitudes de creación de curso/comunidad fueron eliminados porque el curso o comunidad ha sido ya creado:',

   'The following course/community creation requests were ignored because the request is no longer in the queue:'
=> 'Las siguientes solicitudes de creación de curso/comunidad fueron ignorados porque la solicitud ya no está en lista:',

   'The following courses/communities were created:'
=> 'Los siguientes cursos/comunidades fueron creados:',

   'The following requested role: [_1] is unavailable.'
=> 'La siguiente función solicitada [_1] no está disponible.',

   'The following requested roles are unavailable:'
=> 'Las siguientes funciones no están disponibles:',

   'The following requests were rejected:'
=> 'Las siguientes solicitudes fueron rechazadas:',

   'The following settings have been changed:<br/><ul>'
=> 'La siguiente configuraciones han sido cambiadas:<br/><ul>',

   'The following settings remain unchanged:<br/><ul>'
=> 'La siguiente configuraciones permanecen sin cambios:<br/><ul>',

   "The group folder is removed from the folder containing it - normally this is the 'Community Groups' folder which contains folders for all groups in the community."
=> "La carpeta grupal es eliminada de la carpeta que lo contiene, normalmente esta es la carpeta 'Grupos de Comunidad' la cual contiene carpetas de todos los grupos de la comunidad.",

   "The group folder is removed from the folder containing it - normally this is the 'Course Groups' folder which contains folders for all groups in the course."
=> "La carpeta grupal es eliminada de la carpeta que lo contiene, normalmente esta es la carpeta 'Grupos del Curso' la cual contiene carpetas de todos los grupos en el curso.",

   'The name of the new file needs to end with an appropriate file extension to indicate the type of file to create.'
=> 'El nombre del archivo nuevo necesita terminar con una extensión apropiada para indicar el tipo de archivo a crear.',

   'The username of the Coordinator is required'
=> 'Se requiere el usuario del Coordinador',

   'There are no active Domain Coordinators'
=> 'No hay Coordinadores de Dominio activo.',

   'There are no members currently enrolled.'
=> 'No hay miembros actualmente registrados.',

   'There is currently no owner set for this community.'
=> 'Actualmente no hay dueño asignado para esta comunidad.',

   'There is currently no owner set for this course.'
=> 'Actualmente no hay dueño asignado para este curso.',

   'There is no owner associated with this LON-CAPA course.'
=> 'No hay dueño asociado con este curso LON-CAPA.',

   'There was a problem processing your requested changes.'
=> 'Hubo un problema procesando los cambios solicitados.',

   'There was a problem with your course selection'
=> 'Hubo un problema con su selección del curso',

   'There was a problem with your community selection'
=> 'Hubo un problema con su selección de comunidad',

   'This request has already been cancelled.'
=> 'Esta solicitud ya fue cancelada.',

   'This request has already been processed, and a course created.'
=> 'Esta solicitud ya fue procesada, y un curso creado.',

   'To access your LON-CAPA message, go to the Main Menu and click on "Send and Receive Messages".'
=> 'Para acceder a su mensaje LON-CAPA, ir al Menú Principal y pulsar en  "Enviar y Recibir mensajes".',

   'Tolerance'
=> 'Tolerancia',

   'Unable to determine status due to network problems.'
=> 'No se pudo determinar el estado debido a problemas en la red.',

   'Unable to retrieve information about community contents'
=> 'No se pudo recuperar la información sobre el contenido de la comunidad',

   'Unable to retrieve information about course contents'
=> 'No se pudo recuperar la información sobre el contenido del curso',

   'Unit'
=> 'Unidad',

   'Unknown type'
=> 'Tipo desconocido',

   'Unofficial'
=> 'No oficial',

   'unofficial'
=> 'no oficial',

   'official'
=> 'oficial',

   'Unofficial course'
=> 'Curso no oficial',

   'Unofficial courses'
=> 'Cursos no oficiales',

   'Unrecognized course type: [_1]'
=> 'Tipo de curso desconocido: [_1]',

   'Unsupported IMS format: [_1]'
=> 'Formato IMS incompatible: [_1]',

   'Upload IMS package'
=> 'Cargar paquete IMS',

   'Upload a courses or communities attributes file'
=> 'Cargar un archivo de atributo de cursos o comunidades',

   'Upload Course/Community Attributes File'
=> 'Cargar Archivo de Atributos de Curso/Comunidad',

   'Create Courses/Communities'
=> 'Crear Cursos/Comunidades',

   'Upload an attributes file containing specifications for one or more courses or communities in XML format.'
=> 'Cargar un archivo de atributos con especificaciones para uno o más cursos o comunidades en formato XML.',

   'Uploaded file contained no data'
=> 'Archivo Cargado estaba sin datos',

   "Use 'Save' in the main window to save community categories"
=> "Usar 'Guardar' en la ventana principal para guardar categorías de comunidad",

   "Use 'Save' in the main window to save course categories"
=> "Usar 'Guardar' en la ventana principal para guardar categorías de cursos",

   'Use the following link to enter the community:'
=> 'Usar el siguiente enlace para entrar a la comunidad:',

   'Use the following link to enter the course:'
=> 'Usar el siguiente enlace para entrar al curso:',

   'Use the following links to your new roles to enter the community:'
=> 'Usar los siguientes enlaces a sus funciones para entrar a la comunidad:',

   'Use the following links to your new roles to enter the course:'
=> 'Usar los siguientes enlaces a sus funciones para entrar al curso:',

   'User Search to enroll member'
=> 'Buscar Usuario para inscribir miembro',

   'User does not exist - username: [_1], domain: [_2].'
=> 'Usuario no existe - usuario: [_1], dominio: [_2].',

   'You are not permitted to create a LON-CAPA account.'
=> 'No tiene permiso de crear una cuenta LON-CAPA.',

   'You do not have privileges to request creation of courses or communities.'
=> 'No tiene privilegios de solicitar creación de cursos o comunidades.',

   'You do not have rights to request creation of courses in this domain; please choose a different domain.'
=> 'No está autorizado a solicitar creación de cursos en este dominio; por favor elija un dominio diferente.',

   'You do not have privileges to modify Portfolio, Blog or Personal Information Page settings for this user.'
=> 'No tiene privilegios de modificar Portafolio, Blog o la configuración de la Página de Información Personal para este usuario.',

   'You may also add users later, once the community has been created, by using the "Manage community users" link, accessible from the "Main Menu".'
=> 'Puede añadir usuarios después, una vez la comunidad ha sido creada, usando el enlace "Control de usuarios de comunidad", accesible desde el "Menú Principal".',

   'You may also add users later, once the course has been created, by using the "Manage course users" link, accessible from the "Main Menu".'
=> 'Puede añadir usuarios después, una vez el curso ha sido creado, usando el enlace "Control de usuarios del curso", accesible desde el "Menú Principal".',

   'You must select a course or community in the current domain'
=> 'Debe seleccionar un curso o comunidad en el dominio actual',

   'You need to change one or more LON-CAPA section names - names may only contain letters or numbers.'
=> 'Necesita cambiar nombres de una o más secciones LON-CAPA - los nombres sólo pueden tener letras o números.',

   'You need to change one or more LON-CAPA section names - none is a reserved word in the system, and may not be used.'
=> 'Necesita cambiar nombres de una o más secciones LON-CAPA - "ninguno" es una palabra reservada en el sistema y no puede ser usada.',

   'You need to re-initialize the community.'
=> 'Necesita re-iniciar la comunidad.',

   'You need to reinitialize the community.'
=> 'Necesita reiniciar la comunidad.',

   'Your community request has been cancelled.'
=> 'Su solicitud de comunidad ha sido cancelada.',

   'Your community request has been recorded.'
=> 'Su solicitud de comunidad ha sido registrada.',

   'Your community request has been updated'
=> 'Su solicitud de comunidad ha sido actualizada.',

   'Your community request was rejected.'
=> 'Su solicitud de comunidad ha sido rechazada.',

   'Your course request has been cancelled.'
=> 'Su solicitud de curso ha sido cancelada.',

   'Your course request has been recorded.'
=> 'Su solicitud de curso ha sido registrada.',

   'Your course request has been updated'
=> 'Su solicitud de curso ha sido actualizada.',

   'Your course request was rejected.'
=> 'Su solicitud de curso ha sido rechazada.',

   'Your community request has been processed and the community has been created.'
=> 'Su solicitud de comunidad ha sido procesada y la comunidad ha sido creada.',

   'Your course request has been processed and the course has been created.'
=> 'Su solicitud de curso ha sido procesada y el curso ha sido creado.',

   'Your file - [_1] - was uploaded successfully.'
=> 'Su archivo - [_1] - fue cargado exitósamente.',

   'Your import is complete.'
=> 'Su importación está completa.',

   'Your limit is [_1].'
=> 'Su límite es [_1].',

   'Your request has not been processed because you have reached the limit for the number of communities.'
=> 'Su solicitud no ha sido procesada, porque llegó al límite para el número de comunidades.',

   'Your request has not been processed because you have reached the limit for the number of courses of this type.'
=> 'Su solicitud no ha sido procesada, porque llegó al límite para el número de cursos de este tipo.',

   'Your request status is: [_1].'
=> 'El estado de su solicitud es: [_1].',

   'Zoom in'
=> 'Acercar',

   'Zoom out'
=> 'Alejar',

   '[_1] Display Creation History'
=> '[_1] Mostrar historial de creación',

   '[_1] now set to: [_2]'
=> '[_1] ahora configurado a: [_2]',

   '[_1] set to [_2]'
=> '[_1] configurado a [_2]',

   '[_1] was excluded because new users need be from the course domain'
=> '[_1] fue excluído porque usuarios nuevos necesitan ser del dominio del curso',

   '[_1] was excluded because the domain is invalid'
=> '[_1] fue excluído porque el dominio es inválido',

   '[_1] was excluded because the username or domain is invalid.'
=> '[_1] fue excluído porque el usuario o dominio es inválido.',

   '[_1] was excluded because the username violated format rules for the domain'
=> '[_1] fue excluído porque el usuario violó las reglas de formato para el dominio',

   '[_1]Error:[_2] An error ([_3]) occurred when attempting to upload the file, [_4]'
=> '[_1]Error:[_2] Un error ([_3]) ocurrió cuando intentaba cargar el archivo, [_4]',

   '[_1]Error:[_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.'
=> '[_1]Error:[_2] El archivo que intentó cargar, [_3] estaba sin información. Por favor revise que entró el nombre correcto del archivo.',

   'clicker id'
=> 'Clicker ID',

   'passphrase not required'
=> 'frase no requerida',

   'passphrase protected'
=> 'protegida por frase',

   ''
=> '',




#SYNC Thu Sep  9 16:06:10 2010
   'Download a scoring office file'
=> 'Descargar un archivo de la oficina de evaluaciones',

   'Filename of scoring office file:'
=> 'Nombre del archivo de la oficina de evaluaciones:',

   'Filename of scoring office file: [_1]'
=> 'Nombre del archivo de la oficina de evaluaciones: [_1]',

   'Download: Show List of Associated Files'
=> 'Descargar: Lista de archivos asociados',

   'Finished!'
=> 'Terminado!',

   'Format of data file:'
=> 'Formato de archivo de datos:',

   'Graded folder/sequence:'
=> 'Carpeta/Secuencia Calificada:',

   'Graphics'
=> 'Gráficos',

   'History of student-reservable slots for: [_1]'
=> 'Historia de franjas horarias reservadas para los estudiantes: [_1]',

   'Manual Grading by Page or Sequence'
=> 'Calificación Manual por Página o Secuencia',

   'No recorded submission for this problem.'
=> 'No hay registro de entrada para este problema.',

   'No subject'
=> 'Sin asunto',

   'Parsing results'
=> 'Resultados del Parser',

   'Please select the student you wish to grade.'
=> 'Por favor seleccione el estudiante que desea calificar.',

   'Please use the browse button to select a file from your local directory.'
=> 'Por favor use el boton de su navegador para seleccionar un archivo de su directorio local.',

   'Problem Text'
=> 'Texto del Problema',

   'Removed by '
=> 'Eliminado por ',

   'Review Bubblesheet Data and Submission Records'
=> 'Revisar Registros de Hojas de Respuesta y Entradas',

   'Review bubblesheet data and submissions for a previously graded folder/sequence'
=> 'Revisar datos de Hoja de Respuesta y entradas para una carpeta/secuencia previamente calificada',

   'Specify a bubblesheet data file to upload.'
=> 'Indicar el archivo de Hoja de Respuestas a cargar.',

   'SelectProblem(s) to print'
=> 'Selección de Problema(s) a imprimir',

   'Sequence to grade:'
=> 'Secuencia a calificar:',

   'Show all parts'
=> 'Mostrar todas las partes',

   'Slot reservation history'
=> 'Historia de reserva de franjas horarias',

   'Specific Resource: [_1] ([_2])'
=> 'Recursos Específicos: [_1] ([_2])',

   'Specify file and which Folder/Sequence to grade'
=> 'Indicar archivo y cual Carpeta/Secuencia a calificar',

   'Student Activity Retrieval'
=> 'Actividad de Recuperación del Estudiante',

   'View more activity by this student'
=> 'Ver más actividad por este estudiante',

   'View slot reservation history of this student'
=> 'Ver historia de reserva de espacios de este estudiante',

   'Waiting for results'
=> 'Esperando por resultados',

   'Student: [_1]'
=> 'Estudiante: [_1]',

   'Via Parameter Manager'
=> 'Por Administrador de Parámetros',

   'Via Slot Manager'
=> 'Por Administrador de Franjas Horarias',

   ' Display Request Queue'
=> ' Mostrar Fila de Solicitudes',



 


#SYNCMARKER
);

1;
