# The LearningOnline Network with CAPA
# Farsi Localization Lexicon
#
# $Id: fa.pm,v 1.14 2009/05/07 12:42:17 bisitz Exp $
#
# Copyright i-Learning Limited Partnership Company
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::fa;
use base qw(Apache::localize);
%Lexicon=('_AUTO' => 1,
'language_code' => 'fa',
'char_encoding' => 'UTF-8',
'date_locale'  => 
      '$weekday, $day.$month.$year, $twentyfour:$minutes:$seconds',
'date_months'  => ' ژانويه,فوريه,مارس,آوريل,مى,ژوئن,جولاى,آگوست,سپتامبر,اكتبر,نوامبر,دسامبر',
'date_days'    => 'يكشنبه,دوشنبه,سه شنبه,چهارشنبه,پنجشنبه,جمعه,شنبه',
'date_am' => 'قبل از ظهر',
'date_pm' => 'بعد از ظهر',
'textual_remote_display' => 'on',


   'Arabic - UTF'
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'German - UTF'
=> 'Deutsch - UTF', # 'UTF زبان آلمانى'

   'English - UTF'
=> 'English - UTF', # 'UTF - انگليسى '

   'Spanish (Castellan) - UTF'
=> 'español (castellano) - UTF',

   'Persian - UTF'
=> 'ﺍیﺭﺎﻧی - UTF',

   'French - UTF'
=> 'français - UTF',

   'Hebrew - UTF'
=> 'עברית - UTF',

   'Japanese - UTF'
=> '日本語 - UTF', # 'UTF - ژاپنى'

   'Portuguese - UTF'
=> 'Português - UTF', # 'UTF - زبان پرتغالى'

   'Russian - UTF'
=> 'Русский - UTF', # 'UTF - زبان روسى'

   'Turkish - UTF'
=> 'türkçe - UTF', # 'UTF - تركى'

   'Chinese Simplified - UTF'
=> '简体中文 - UTF',

   'Swedish Chef - UTF'
=> 'Swedish Chef - UTF',

   'Domain'
=> 'دامنه',

   'Server'
=> 'سرور',

   'Load'
=> 'بارگذارى',

   'User Load'
=> 'بارگذارى كاربر',

   'Help'
=> 'راهنما',

   'Log in'
=> 'برقرارى ارتباط',

   'Username'
=> 'نام كاربرى',

   'Password'
=> 'رمز عبور',

   'choose'
=> 'انتخاب',

   'enter'
=> 'ورود',

   'view'
=> 'ملاحظه',

   'calendar'
=> 'تقويم',

   'prefer-'
=> 'تنظيمات',

   'ences'
=> 'تنظيمات',

   'role'
=> 'نقش',

   'course'
=> 'دوره',

   'create'
=> 'ايجاد',

   'grades'
=> 'نمرات',

   'commu-'
=> 'ارتباطات',

   'nication'
=> 'ارتباطات',

   'enroll'
=> 'ثبت نام كردن',

   'navigate'
=> 'سير در پيوندها',

   'Announcements and Calendar'
=> 'اعلانات و تقويمها',

   'Author'
=> 'نويسنده',

   'Change Your Preferences'
=> 'تغيير تنظيمات',

   'Choose the user role'
=> 'انتخاب نقش كاربر',

   'Co-Author'
=> 'همكار نويسنده',

   'Communication and Messages'
=> 'ارتباطات و پيامها',

   'Course Coordinator'
=> 'هماهنگ كننده دوره',

   'Course Statistics and Charts'
=> 'آمار و نمودارهاى دوره',

   'Course announcements and my calendar'
=> 'اعلانات دوره و تقويم',

   'Create Users, Change User Privileges'
=> 'ايجاد كاربران و تغيير',

   'Domain Coordinator'
=> 'هماهنگ كننده دامنه',

   'Enrollment Manager'
=> 'مدير ثبت نام',

   'Enter grades from check-out assessment resources'
=> 'وارد كردن نمرات از روى فهرست منابع ارزشيابى',

   'Exam Proctor'
=> 'مراقب امتحان',

   'Exit LON-CAPA'
=> '(LON-CAPA)خروج از لون كاپا',

   'Grades Spreadsheet'
=> 'صفحه گسترده نمرات',

   'Grading'
=> 'در حال تصحيح',

   'Instructor'
=> 'مدرس',

   'Launch Remote Control'
=> 'راه اندازى كنترل از راه دور',

   'Main Menu'
=> 'منوى اصلى',

   'Navigate Course Contents'
=> 'سير در محتواى دوره',

   'No Role, Cumulative Privileges'
=> 'بدون نقش، با اختيارات افزوده',

   'Return to Last Location'
=> 'بازگشت به موقعيت قبلى',

   'Send and receive messages'
=> 'ارسال و دريافت پيام',

   'Set my user preferences'
=> 'تنظيم اختيارات كاربر',

   'Student'
=> 'دانشجو',

   'Switch to another user role'
=> 'انتقال به نقش كاربرى',

   'Teaching Assistant'
=> 'دستيار مدرس',

   'Use or edit my bookmark collection'
=> 'استفاده يا ويرايش مجموعه برگزيده‏هاى اينجانب',

   'User Roles'
=> 'نقشهاى كاربرى',

   'Calculate course grades (Spreadsheet)'
=> 'محاسبه نمرات دوره-صفحه گسترده',

   'Enter the chatroom for the course'
=> ' به اتاق گپ زنى دوره وارد شويد',

   'Navigate the table of contents for this course'
=> 'سير در فهرست محتويات اين دوره',

   'Syllabus'
=> 'برنامه درسى',

   'View the course assessment progress chart'
=> 'ملاحظه نمودار ارزشيابى پيشرفت دوره',

   'Class Hours'
=> 'ساعات برگزارى كلاس',

   'Course Description'
=> 'شرح دوره',

   'Coursepack'
=> 'بسته دوره',

   'Current Month'
=> 'ماه جارى',

   'Deadlines'
=> 'مهلتها',

   'Fri'
=> 'جمعه',

   'Grading Information'
=> 'اطلاعات مربوط به تصحيح',

   'Helproom Hours'
=> 'ساعات كار اتاق مشاوره',

   'Instructor Information'
=> 'اطلاعات مدرس',

   'Mon'
=> 'دوشنبه',

   'Next Month'
=> 'ماه آينده',

   'Office Hours'
=> 'ساعات ادارى',

   'Prerequisites'
=> 'پيش نيازها',

   'Previous Month'
=> 'ماه گذشته',

   'Readings'
=> 'مطالب خواندنى',

   'Sat'
=> 'شنبه',

   'January'
=> 'ژانويه',

   'February'
=> 'فوريه',

   'March'
=> 'مارس',

   'April'
=> 'آوريل',

   'May'
=> 'مى',

   'June'
=> 'ژوئن',

   'August'
=> 'آگوست',

   'September'
=> 'سپتامبر',

   'October'
=> 'اكتبر',

   'November'
=> 'نوامبر',

   'December'
=> 'دسامبر',

   'Sun'
=> 'يكشنبه',

   'Textbook'
=> 'كتاب درسى',

   'Thu'
=> 'پنجشنبه',

   'Tue'
=> 'سه شنبه',

   'Web Links'
=> 'پيوندهاى شبكه',

   'Wed'
=> 'چهارشنبه',

   'Drop/Add students in this course'
=> 'حذف يا افزودن دانشجو',

   'You have entered that answer before'
=> 'قبلاً اين پاسخ را وارد كرده بوديد',

   'A score has been assigned.'
=> '採点されました。',

   'You are correct.'
=> 'حق با شماست',

   'Your receipt is'
=> 'دريافت شما اين است',

   'You are excused from the problem.'
=> 'از پاسخ به اين مسأله معاف هستيد ',

   'Incorrect'
=> 'نادرست',

   'Some parts were not submitted.'
=> 'بعضى از قسمتها تحويل داده نشده است',

   'An error occurred while grading your answer.'
=> 'هنگام تصحيح پاسخ شما خطايى رخ داد',

   'The submitted answer was too long.'
=> 'پاسخ ارائه شده خيلى طولانى است',

   'This question expects a numeric answer.'
=> 'اين پرسش يك پاسخ عددى مى‏طلبد',

   'You have provided an invalid ranking'
=> 'رتبه‏اى كه كسب كرده‏ايد معتبر نيست',

   'please refer to'
=> 'لطفاً اشاره كنيد به',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'نوع پسوند فايلى كه آپ لود كرد',

   'Please adjust significant figures.'
=> 'لطفاً اعداد قابل توجه را انتخاب كنيد',

   'Units incorrect.'
=> 'واحدها نادرست است',

   'Only a number required.'
=> 'در اين قسمت تنها يك عدد نياز است',

   'Units required'
=> 'واحدها مورد نياز است',

   'Unable to understand formula'
=> 'فرمول مفهوم نيست',

   'Your submission has been recorded.'
=> 'ارسال شما ثبت شده است',

   'Unknown message'
=> 'پيام ناشناخته',

   'Answer Submitted'
=> 'پاسخ تحويل شد',

   'Tries'
=> 'تلاشها',

   'Submit Answer'
=> 'تحويل پاسخ',

   'Prepare a printable document'
=> 'يك سند قابل چاپ عرضه كنيد',

   'Go To My First Homework Problem'
=> 'انتقال به اولين مسأله تكاليف خود ',

   'Discussions'
=> 'مباحثات',

   'New discussion since'
=> ' بحث جديد از ',

   'Goodbye'
=> 'خداحافظ',

   ', and answers will be available on'
=> ', و پاسخها  در دسترس خواهد بود',

   ', or the next time you log in.'
=> ', يا دفعه بعدى كه متصل شويد',

   ', select a template from the pull-down menu below'
=> ', از منوى كركره‏اى زير نمونه‏اى انتخاب كنيد',

   'Abstract'
=> 'چكيده',

   'Access and Usage Statistics'
=> 'آمارهاى مراجعه و استفاده',

   'Actions'
=> 'اعمال',

   'All homework is currently completed'
=> 'در حال حاضر كليه تكاليف انجام شده است',

   'Analyze Progress'
=> 'تحليل پيشرفت',

   'Analyzing a problem'
=> 'تحليل يك مسأله',

   'Answer'
=> 'پاسخ',

   'Answer available'
=> 'پاسخ در دسترس است',

   'Answer submitted'
=> 'پاسخ تحويل شد',

   'Answer submitted, not yet graded'
=> 'پاسخ تحويل داده شده ولى هنوز تصحيح نشده است',

   'Back to Directory'
=> 'بازگشت به فهرست راهنما',

   'Bulletin Board'
=> 'تابلوى اعلانات',

   'Cancel'
=> 'انصراف',

   'Changes will become active for your current session after'
=> 'تغييرات براى جلسه فعلى شما فعال خواهد شد بعد از اين كه',

   'Construction Space Directory'
=> 'فهرست راهنماى فضا طرح',

   'Contact'
=> 'تماس',

   'Copying file'
=> 'در حال كپى كردن فايل',

   'Course'
=> 'دوره',

   'Create'
=> 'ايجاد',

   'Create a user or modify the roles and privileges of a user'
=> ' ايجاد كاربر يا تغيير نقشها و اختيارات او',

   'Currently not available'
=> 'در حال حاضر در دسترس نيست',

   'Currently selected. '
=> 'در حال حاضر انتخاب شده است',

   'Date'
=> 'تاريخ',

   'Discard Edits and View'
=> 'حذف ويرايش و ملاحظه',

   'Display'
=> 'نمايش',

   'Done'
=> 'انجام شد',

   'Edit'
=> 'ويرايش',

   'EditXML'
=> ' XML ويرايش',

   'Empty'
=> 'خالى',

   'End'
=> 'پايان',

   'Evaluation Comments'
=> 'ملاحظات ارزشيابى',

   'Evaluation Data'
=> 'داده‏هاى ارزشيابى',

   'Excused by instructor'
=> 'از سوى مدرس اغماض شد',

   'Extent'
=> 'حد',

   'File'
=> 'فايل',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'در خصوص اين مسأله بخش قابل تحليلى يافت نشد در حال حاضر تنها پاسخهاى عددى، فرمولى، و رشته‏اى پشتيبانى مى‏شود',

   'Frequency'
=> 'بسامد',

   'Getting Problem Variants'
=> 'دريافت گونه‏هاى مسأله',

   'Go Back'
=> 'بازگشت',

   'Import'
=> 'وارد كردن',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'توصيه مى‏شود پيش از استفاده از اين فايل از يك ويروس ياب روز آمد استفاده كنيد',

   'July'
=> 'جولاى',

   'Language'
=> 'زبان',

   'Last Modified'
=> 'آخرين بارى كه اين فايل تغيير كرده',

   'List of possible answers'
=> 'فهرست پاسخهاى محتمل',

   'Main Course Documents'
=> 'اسناد اصلى دوره',

   'Map'
=> 'نقشه',

   'Map contents are not shown in order.'
=> 'محتواى نقشه به ترتيب نمايش داده نمى‏شود',

   'Name'
=> 'نام',

   'Navigate Contents'
=> 'سير در محتويات',

   'New Folder'
=> 'پوشه جديد',

   'New Messages'
=> 'پيامهاى جديد',

   'New Search'
=> 'جستجوى جديد',

   'No content modifications yet.'
=> 'هنوز تغييرى در محتويات اعمال نشده است',

   'No due date'
=> 'بدون تاريخ مقرر',

   'No role specified'
=> 'هيچ نقشى تعريف نشده است',

   'No upload file specified.'
=> 'فايلى براى آپ لود مشخص نشده است',

   'No write permission to user directory, FAIL'
=> 'دستكارى فهرست راهنماى كاربر مجاز نيست',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> 'توجه: 10 ثانيه طول مى‏كشد تا تغييرات براى همه كاربران اعمال شود',

   'Notes'
=> 'يادداشتها',

   'Open, no due date'
=> 'باز كردن، بدون تاريخ مقرر',

   'Page'
=> 'صفحه',

   'Part'
=> 'بخش',

   'Part is not open to be viewed. It'
=> 'اين بخش باز نيست كه بتوان آن را ملاحظه كرد',

   'Path'
=> 'مسير',

   'Please use browser "Back" button and pick a filename'
=> 'لطفاً از دكمه بازگشت مرورگر استفاده كنيد و نام يك فايل را برگزينيد',

   'Processing'
=> 'در حال پردازش',

   'Re-Initialize'
=> 'از سر گيرى',

   'Remark'
=> 'اظهار نظر',

   'Rename'
=> 'تغيير نام',

   'Save'
=> 'ذخيره', # 'ذخيره كردن',

   'Saving Modifications to'
=> 'ذخيره تغييرات در',

   'Search'
=> 'جستجو',

   'Searching'
=> 'در حال جستجو',

   'Section/Group'
=> 'قسمت / گروه',

   'Select'
=> 'انتخاب',

   'Select Course'
=> 'انتخاب دوره',

   'Select User'
=> 'انتخاب كاربر',

   'Select a'
=> 'انتخاب يك',

   'Select the Construction Space'
=> 'انتخاب فضاى طرح',

   'Sequence'
=> 'توالى',

   'Server Administration'
=> 'مديريت سرور',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> 'تعيين مهلتها و پارامترهاى ديگر ارزيابى و نيز تغيير محيط دوره',

   'Show Only Uncompleted Homework'
=> 'فقط تكاليف ناتمام را نشان بده',

   'Simple Page'
=> 'صفحه ساده',

   'Simple Problem'
=> 'مسأله ساده',

   'Special Documents'
=> 'اسناد ويژه',

   'Start'
=> 'شروع',

   'Status'
=> 'وضعيت',

   'Save uploaded file as '
=> 'ذخيره فايل آپ لود شده به عنوان',

   'Submit'
=> 'تحويل',

   'Submit Changes'
=> 'تحويل تغييرات',

   'Submit Changes and View'
=> 'تحويل تغييرات و ملاحظه',

   'Supplemental Course Documents'
=> 'اسناد تكميلى دوره',

   'Switch Server'
=> 'تغيير سرور',

   'System'
=> 'سيستم',

   'System Administration'
=> 'مديريت  سيستم',

   'The target is an existing directory.'
=> 'مقصد يك فهرست راهنماى موجود است ',

   'Then'
=> 'سپس',

   'Title'
=> 'عنوان',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'به خاطر مشكلات موجود در شبكه نمى‏توان معين كرد كه آيا اين منبع باز است يا نه، لطفاً بعداً امتحان كنيد',

   'Unable to find'
=> 'نايافتنى است',

   'Unable to make backup'
=> 'تهيه پشتيبان ممكن نيست',

   'Unable to undo, unable to switch'
=> 'بى اثر كردن تغييرات و سوئيچ كردن امكان‏پذير نيست',

   'Unable to write to'
=> ' امكان نوشتن  وجود ندارد ',

   'Uncompleted Homework'
=> 'تكاليف ناتمام',

   'Undid changes, Switched'
=> 'تغييرات بى اثر گرديد، سوئيچ انجام شد',

   'Upload Document'
=> 'آپ لود كردن سند',

   'Uploaded Document'
=> 'سند آپ لود شده',

   'User Role'
=> 'نقش كاربر',

   'View All Messages'
=> 'ملاحظه تمام پيامها',

   'View course assessment statistics'
=> 'ملاحظه آمار ارزيابى دوره',

   'Was due'
=> 'مقرر بود',

   'Yes'
=> 'بلى',

   'You did not select a template.'
=> 'نمونه‏اى انتخاب نكرديد',

   'You do not have authoring privileges for this resource'
=> 'شما اختيارات لازم براى تغيير محتويات اين منبع را نداريد',

   'You have no unread messages'
=> 'نامه خوانده نشده نداريد',

   'an indeterminate date'
=> 'تاريخ نامشخص',

   'an unknown date'
=> 'تاريخ غير قابل شناسايى',

   'could not be copied.'
=> 'كپى نشد',

   'is closed but you are allowed to view it'
=> 'بسته مى‏شود ولى مجاز هستيد آن را ببينيد',

   'is due at'
=> 'مقرر است در',

   'is in under construction'
=> 'در حال آماده سازى است',

   'is not analyzable at this time'
=> 'فعلاً قابل تحليل نيست',

   'last month'
=> 'ماه قبل',

   'last problem'
=> 'آخرين مسأله',

   'last six months'
=> 'شش ماه گذشته',

   'last three months'
=> 'سه ماه گذشته',

   'last week'
=> 'هفته گذشته',

   'last year'
=> 'سال گذشته',

   'may open later.'
=> 'ممكن است بعداً باز شود',

   'never'
=> 'هرگز',

   'not displayed'
=> 'نمايش داده نشد',

   're-initializing course'
=> 'از سرگيرى دوره',

   'system wide'
=> 'سيستم گسترده است ',

   'today'
=> 'امروز',

   'undo'
=> 'بى اثر كردن',

   'was due on'
=> 'مقرر بود در',

   'will open on'
=> 'در این تاريخ باز خواهد شد',

   ', is reserved internally by LON-CAPA.'
=> ', در درون توسط لون كاپا ذخيره مى‏شود',

   'Back to'
=> 'بازگشت به',

   'Back to Source'
=> 'بازگشت به منبع',

   'Back to Source Directory'
=> 'بازگشت به فهرست راهنماى منبع',

   'Became this version on ...'
=> ' در این تاريخ به اين نسخه  تبديل شد',

   'Browse published resources'
=> 'مرور منابع منتشره',

   'Choose the course to work on'
=> 'درسی را انتخاب نماييد تا روى آن كار كنيد',

   'Create a new course'
=> 'ايجاد يك درس جديد',

   'Customized right of use ...	'
=> 'حق سفارشى استفاده',

   'Delete messages from bulletin boards'
=> 'حذف نامه‏ها از تابلوى اعلانات',

   'Domain only - use limited to courses in the domain'
=> 'تنها دامنه - كاربرد محدود به دوره‏ها در دامنه است',

   'Dynamic Metadata'
=> 'فراداده پويا',

   'Edit and view documents included in this course'
=> 'ويرايش و ملاحظه اسناد گنجانده در اين دوره',

   'Edit/Modify DOCS'
=> ' DOC ويرايش يا تغيير فايلهاى با پسوند',

   'Enter my resource construction space'
=> 'ورود به فضاى طرح منبع من',

   'FAIL'
=> 'ناكامى',

   'Failed to copy source'
=> 'منبع كپى نشد',

   'Failed to write metadata copy'
=> 'ناكامى در نوشتن كپى فراداده',

   'File copied.'
=> 'فايل كپى شد',

   'Finalize Publication'
=> 'نهايى كردن انتشار',

   'Grant/revoke role of Co-Author'
=> 'اعطا يا لغو نقش همكار نويسنده',

   'Grant/revoke role of Domain Coordinator'
=> 'اعطا يا لغو نقش هماهنگ كننده دامنه',

   'Grant/revoke role of Exam Proctor'
=> 'اعطا يا لغو نقش مراقب امتحان',

   'Grant/revoke role of Instructor'
=> 'اعطا يا لغو نقش مدرس',

   'Grant/revoke role of Student'
=> 'اعطا يا لغو نقش دانشجو',

   'Grant/revoke role of Superuser'
=> 'اعطا يا لغو نقش كاربر برتر',

   'Illegal filename.'
=> 'نام فايل غير معتبر است',

   'Name starting with'
=> 'نامى كه آغاز مى‏شود با',

   'No previous versions published.'
=> 'هيچ يك از نسخه‏هاى قبلى منتشر نشده است',

   'No write permission to'
=> 'مجاز به نوشتن  نيستيد در',

   'Please pick a version to retrieve'
=> 'لطفاً نسخه‏اى را انتخاب كنيد تا بازيابى شود',

   'Private - visible to author only for testing purposes'
=> 'خصوصى - دسترسى به فايل فقط براى نويسنده به قصد آزمودن امكان‏پذير است',

   'Private Publication - did not synchronize database'
=> 'انتشار خصوصى - با پايگاه داده‏ها همزمانى برقرار نشد',

   'Public - no authentication or authorization required for use'
=> 'عمومى - براى استفاده نيازى به تأييد و اجازه نيست',

   'Retrieval of an old version will overwrite the file currently in construction space'
=> 'بازيابى نسخه قديمى مستلزم رونويسى بر فايلى است كه هم اكنون در فضاى طرح است',

   'Retrieve previous versions of'
=> 'بازيابى نسخه‏هاى قبلىِ',

   'Retrieve version'
=> 'بازيابى نسخه',

   'Rule'
=> 'قانون',

   'Search the contents of this course'
=> 'جستجوى محتويات اين دوره',

   'Search the database of published resources'
=> 'جستجوى پايگاه اطلاعاتى منابع منتشره',

   'Send broadcast and receipt-required email'
=> 'ارسال راديويى و دريافت نامه الكترونيكى نيازمند اعلام وصول',

   'Show Problem Completeness'
=> 'نمايش فرآيند تكميل مسأله',

   'Switch to another course'
=> 'انتقال به دوره ديگر',

   'System wide - can be used for any courses system wide'
=> 'سيستم گسترده است - قابل استفاده براى همه',

   'System wide - open source to all authors'
=> 'سيستم گسترده است - باز كردن منبع براى همه',

   'The extension on this file'
=> 'پسوند/بسط روى اين فايل',

   'This resource has been marked obsolete by the author(s)'
=> 'اين منبع توسط نويسنده يا نويسندگان، كهنه اعلام شده است',

   'Unsupported character combination'
=> 'اين تركيب كاراكتر پشتيبانى نمى‏شود',

   'Uploaded'
=> 'آپ لود شد',

   'Users with Roles Assigned by'
=> 'كاربران با نقشهايى واگذار شده',

   'View documents included in this course'
=> 'ملاحظه پرونده‏هاى گنجانده در اين دوره',

   'View file'
=> 'ملاحظه فايل',

   'untitled'
=> 'بى نام',

#SYNC Sun Sep 28 12:06:11 2003
   'Additional Keywords'
=> 'كليد واژه‏هاى اضافى',

   'Additional Metadata (non-standard, parameters, exports)'
=> ' فراداده اضافى -غير استاندارد، پارامترها، صادرات',

   'All versions'
=> 'همه نسخه‏ها',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> 'نقش نويسنده و همكار نويسنده  بر روى سرورى به غير از سرور ميزبان در دسترس نيست',

   'Author(s)'
=> 'نويسنده / نويسندگان',

   'Average number of tries till solved'
=> 'ميانگين دفعات تلاش كاربر براى حل اين مسأله',

   'Browse Resources'
=> 'مرور منابع',

   'Catalog Information'
=> 'اطلاعات كاتالوگ',

   'Collapse Remote Control'
=> 'بر هم زدن كنترل از راه دور',

   'Construction Space'
=> 'فضاى طرح',

   'Content changed'
=> 'محتوا تغيير كرد',

   'Copied metadata'
=> 'فراداده كپى شد',

   'Copied source file'
=> 'فايل منبع كپى شد',

   'Copyright/Distribution'
=> 'كپى رايت / توزيع',

   'Could not write metadata'
=> 'نوشتن فراداه ميسر نشد',

   'Course Documents'
=> 'اسناد دوره',

   'Creation Date'
=> 'تاريخ ايجاد',

   'Custom Distribution File'
=> 'فايل توزيع سفارشى',

   'Default Cataloging Information for Directory'
=> 'اطلاعات فهرست بردارى',

   'Degree of difficulty'
=> 'ميزان دشوارى',

   'Differences'
=> 'تفاوتها',

   'Dump Course DOCS to Construction Space'
=> '(doc) دور ريختن فايلهاى  موجود در فضاى طرح',

   'Entering course ...'
=> ' ... در حال ورود به دوره',

   'Error Messages'
=> 'پيامهاى خطا',

   'Exam Information'
=> 'اطلاعات امتحان',

   'External Resource'
=> 'منبع خارجى',

   'Generate new role ...'
=> '...ايجاد نقش جديد',

   'Go to the next resource in the course sequence'
=> 'انتقال به منبع بعدى در توالى دوره',

   'Go to the previous resource in the course sequence'
=> 'انتقال به منبع قبلى در توالى دوره',

   'Import a published document'
=> 'وارد كردن سند منتشره',

   'Keyword(s)'
=> 'كليد واژه ها',

   'Last Week'
=> 'هفته گذشته',

   'Load Map'
=> 'بارگذارى نقشه',

   'Logged Out'
=> 'ارتباط قطع شد',

   'MIME Type'
=> '  MIME نوع ',

   'Make notes and annotations about this resource'
=> 'نوشتن حاشيه و شرح بر اين منبع',

   'Material appears to be correct'
=> 'مطالبى كه صحيح به نظر مى‏رسد',

   'Material covered with sufficient depth'
=> 'مطالبى كه از عمق كافى برخوردار است',

   'Material is helpful'
=> 'مطالب مفيد است',

   'Material presented in clear way'
=> 'مطالبى كه به صورت واضح ارائه شده',

   'Metadata Information'
=> 'اطلاعات فراداده',

   'Modification Date'
=> 'تاريخ تغيير',

   'My Personal Info'
=> 'اطلاعات شخصى اينجانب',

   'Network-wide number of accesses (hits)'
=> 'شبكه گسترده - تعداد مراجعات-دسترسى‏ها',

   'Network-wide number of courses using resource'
=> 'شبكه گسترده - تعداد دوره‏هايى كه از اين منبع استفاده مى‏كنند',

   'Number of resources that follow this resource in maps'
=> 'تعداد منابعى كه در نقشه‏ها به دنبال اين منبع مى‏آيد',

   'Number of resources that lead up to this resource in maps'
=> 'تعداد منابعى كه در نقشه‏ها به اين منبع منتهى مى‏شود',

   'Number of resources using or importing resource'
=> 'تعداد منابعى كه از اين منبع استفاده يا آن را وارد مى‏كنند',

   'Obsolete'
=> 'كهنه',

   'Parent Directory'
=> 'فهرست راهنماى اصلى',

   'Please either'
=> 'لطفاً يا',

   'Project Information'
=> 'اطلاعات پروژه',

   'Publisher/Owner'
=> 'ناشر يا مالك',

   'Publishing'
=> 'انتشارات',

   'Resource Publication'
=> 'انتشار منبع',

   'Resource is technically correct'
=> 'منبع از نظر فنى صحيح است',

   'Score Upload Form'
=> 'نمره دادن به فرم آپ لود',

   'Select Map'
=> 'انتخاب نقشه',

   'Set a bookmark for this resource'
=> 'گذاشتن چوب الف در اين منبع',

   'Show all roles'
=> 'نمايش تمام نقشها',

   'Since Start of Course'
=> 'از زمان شروع دوره',

   'Since Yesterday'
=> 'از ديروز',

   'Special documents'
=> 'اسناد ويژه',

   'Save Catalog Information'
=> 'ذخيره اطلاعات كاتالوگ',

   'Subject'
=> 'موضوع',

   'Successful Login'
=> 'ارتباط با موفقيت برقرار شد',

   'Suggested Replacement for Obsolete File'
=> 'جايگزينى پيشنهادى براى فايل كهنه',

   'Switching Role'
=> 'تغيير نقش',

   'Target'
=> 'هدف',

   'This syllabus can be publicly viewed at'
=> 'همگان مى‏توانند اين برنامه درسى را مشاهده كنند',

   'Total number of students who have worked on this problem'
=> 'تعداد كل دانشجويانى كه روى اين مسأله كار كرده اند',

   'URLs To Include in Syllabus'
=> 'نشانى چند پايگاه براى گنجاندن در اين برنامه درسى',

   'Update Display'
=> 'روزآمد سازى نمايش',

   'Upload a new main course document'
=> 'آپ لود سند اصلى جديد دوره',

   'Upload a new supplemental course document'
=> 'آپ لود سند تكميلى جديد دوره',

   'User'
=> 'كاربر',

   'Verify Course Documents'
=> 'تأييد صحت اسناد دوره',

   'Version'
=> 'نسخه',

   'Wrote Metadata'
=> 'فراداده نوشته شد',

   'Your home server is '
=> 'سرور ميزبان شما',

   'access denied'
=> 'دسترسى ميسر نشد',

   'anno-'
=> 'اعلام كردن',

   'announce'
=> 'اعلام كردن',

   'backward'
=> 'به عقب',

   'bookmark'
=> 'چوب الف',

   'chart'
=> 'نمودار',

   'chat'
=> 'گپ',

   'close this window'
=> 'بستن اين پنجره',

   'con-'
=> 'con-',

   'connection down'
=> 'عدم ارتباط',

   'docs'
=> 'اسناد',

   'during the last'
=> 'در گذشته',

   'edit crs'
=> 'crs ويرايش',

   'exit'
=> 'خروج',

   'fas'
=> 'fas',

   'forward'
=> 'به جلو',

   'library'
=> 'كتابخانه',

   'log in again'
=> 'اتصال مجدد',

   'my'
=> 'مال من',

   'not found'
=> 'يافت نشد',

   'or'
=> 'يا',

   'parms'
=> 'پارامترها',

   'prepare'
=> 'مهيا كردن',

   'printout'
=> 'نسخه چاپى',

   'resource'
=> 'منبع',

   'roles'
=> 'نقشها',

   'search'
=> 'جستجو',

   'set'
=> 'تنظيم كردن',

   'space'
=> 'فضا',

   'stats'
=> 'آمار',

   'struct'
=> 'ساختار',

   'switch'
=> 'تغيير',

   'tations'
=> '',

   'updated periodically'
=> 'به صورت دوره‏اى روزآمد مى‏شود',

   'user'
=> 'كاربر',

   'visible to author and co-authors only'
=> 'تنها براى نويسنده و همكار او قابل رؤيت است',

   'warning(s)'
=> 'هشدار',

   "Click to download or use your browser's Save Link function"
=> "براى دان‏لود كردن فايل اينجا را كليك يا از گزينه ذخیره مرورگر خود استفاده كنيد",


#SYNC Thu Nov 27 21:01:54 2003
   '#Stdnts'
=> '#دانشجو',

   '#YES'
=> '#پاسخ صحیح',
# #はい
   '%Wrng'
=> '%نادرست',

   '&nbsp;Show&nbsp;All&nbsp;Foils'
=> '&nbsp;نمايش&nbsp;همه&nbsp;وجوه تقابل',

   '. . . for a particular section'
=> '. . . براى يك قسمت خاص',

   '. . . for all students in the course'
=> '. . . براى همه دانشجويان دوره',

   '. . . for an individual student'
=> '. . . براى يك دانشجو',

   '1 am'
=> ' 1 بامداد',

   '1 out of N multiple choice (radio button)'
=> 'يكى از  تعداد انتخاب چند گزينه‏اى',

   '1 pm'
=> '1 بعد از ظهر',

   '10 am'
=> '10 بامداد',

   '10 pm'
=> '10 شب',

   '11 am'
=> '11 بامداد',

   '11 pm'
=> 'شب  11',

   '12 am'
=> '12 پيش از ظهر',

   '12 noon'
=> '12 ظهر',

   '2 am'
=> '2 بامداد',

   '2 pm'
=> '2 بعد از ظهر',

   '3 am'
=> '3 بامداد',

   '3 pm'
=> '3 بعد از ظهر',

   '4 am'
=> '4 بامداد',

   '4 pm'
=> '4 بعد از ظهر',

   '5 am'
=> '5 بامداد',

   '5 pm'
=> '5 بعد از ظهر',

   '6 am'
=> '6 بامداد ',

   '6 pm'
=> '6 بعد از ظهر',

   '7 am'
=> '7 بامداد',

   '7 pm'
=> '7 بعد از ظهر',

   '8 am'
=> '8 بامداد',

   '8 pm'
=> '8 بعد از ظهر',

   '9 am'
=> '9 بامداد',

   '9 pm'
=> '9 بعد از ظهر',

   '<- Previous'
=> '<- قبلى',

   '<b>[_1]</b>:  Unable to enroll: [_2]'
=> '<b>[_1]</b>:  ثبت نام ميسر نشد[l: [_2] ',

   '<b>[_1]</b>: Unable to enroll.  No password specified.'
=> '<b>[_1]</b>: ثبت نام ميسر نشد. رمز عبور مشخص نشده ا',

   '<b>[_1]</b>: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '<b>[_1]</b>: نام كاربرى براى اين كاربر غير قابل قبول استr [_2] [_3] [_4] [_5]',

   'ALL'
=> 'همه',

   'About Me'
=> 'درباره من',

   'Access Key Management'
=> 'دستيابى مديريت اصلى',

   'Add new option'
=> 'افزودن گزينه جديد',

   'Additional Recipients'
=> 'دريافت كنندگان اضافى',

   'Administrator'
=> 'مدير',

   'Advanced Catalog Search'
=> 'جستجوى پيشرفته كاتالو',

   'Advanced Search'
=> 'جستجوى پيشرفته',

   'All Documents in Course'
=> 'كليه اسناد در دوره',

   'All Maps or Folders'
=> 'همه نقشه‏ها و پوشه‏ها',

   'All Resources (possibly large output)'
=> 'همه منابع -احتمال خروجى زياد',

   'Analyze Over '
=> 'بررسى  بيشتر',

   'Analyze Problem'
=> 'بررسى مسأله',

   'Analyze Problem Again'
=> 'بررسى مجدد مسأله',

   'Analyze as '
=> 'بررسى به عنوان',

   'Anonymous'
=> 'ناشناس',

   'Anonymous contribution to course discussion of resource'
=> 'مساعدت ناشناخته نسبت به بحث دوره از منبع',

   'Answer:'
=> 'پاسخ',

   'Any Language'
=> 'هر زبانى',

   'Any User'
=> 'هر كاربرى',

   'Any category'
=> 'هر مقوله‏اى',

   'Any copyright/distribution'
=> 'هر نوع كپى رايت',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'على القاعده فقط نويسندگان و همكارانشان مجاز به دسترسى به فايل سيستم -كه اجازه دسترسى به فايل سيستم سرور را مى‏دهد- مى‏باشند',

   'Assessment'
=> 'ارزيابى',

   'Assessment URL and Title'
=> 'ارزيابى نشانى پايگاه و عنوان',

   'Assigned User Roles'
=> 'نقشهاى واگذار شده به كاربران',

   'Associate columns with student attributes.'
=> 'ايجاد ارتباط بين ستونها و مشخصات دانشجويان',

   'Attachment'
=> 'پيوست',

   'Attribute'
=> 'مشخصات',

   'Brief view of each students performance in course.'
=> 'نگاه اجمالى به عملكرد هر يك از دانشجويان در اين دوره',

   'Broadcast Message to Course'
=> 'ارسال راديويى پيام به دوره',

   'Browse resources'
=> 'مرور منابع',

   'Browsing resource, all submissions are temporary.'
=> 'در حال مرور منبع، كليه تقاضاها موقتى هستند',

   'Bulletin Board/Discussion'
=> 'تابلوى اعلانات / مباحثه',

   'By'
=> 'به وسيله',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (صفحه گسترده با ويرگول جدا شده)',

   'Calculate answers'
=> 'محاسبه پاسخها',

   'Calculations'
=> 'محاسبات',

   'Change'
=> 'تغيير',

   'Change Random Seed To:'
=> 'تبديل مقدار اوليه مورد استفاده به',

   'Change Your Language Preferences'
=> 'تغيير تنظيمات زبانى شما',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'حداكثر 10 دقيقه وقت لازم است تا تغييرات براى همه دانشجويان اعمال شود',

   'Check All'
=> 'بررسى همه موارد',

   'Check Course Document Versions'
=> 'بررسى نسخه‏هاى سند دوره',

   'Check for All'
=> 'بررسى همه موارد',

   'Check for None'
=> 'بررسى هيچ يك از موارد',

   'Check for Section/Group'
=> 'بررسى قسمت / گروه',

   'Check/Set Resource Versions'
=> 'بررسى يا تنظيم نسخه‏هاى مرجع',

   'Choose a different resource'
=> 'انتخاب يك منبع متفاوت',

   'Chronological View'
=> 'ديدگاه مبتنى بر ترتيب زمانى',

   'Clear All'
=> 'پاك كردن همه موارد',

   'Clear Caches'
=> 'پاك كردن حافظه پنهان',

   'Close'
=> 'بستن',

   'Close All Folders'
=> 'بستن تمام پوشه‏ها',

   'Column'
=> 'ستون',

   'Column&nbsp;[_1]'
=> 'ستون&nbsp;[_1]',

   'Comma Separated Values'
=> 'صفحه گسترده با ويرگول جدا شده',

   'Compact View'
=> 'بررسى فشرده',

   'Concept:'
=> 'مفهوم',

   'Concepts'
=> 'مفاهيم',

   'Construction Space File Operation'
=> 'عمليات فايل طرح فضا',

   'Contact Information'
=> 'اطلاعات تماس',

   'Continue enrollment?'
=> 'آيا ثبت نام ادامه يابد؟',

   'Contribution to course discussion of resource'
=> 'مساعدت به بحث منابع دوره',

   'Copied old metadata'
=> 'فراداده قديمى كپى شده',

   'Copied old target file'
=> 'فايل قديمى مقصد كپى شد',

   'Copyright'
=> 'كپى رايت',

   'Correct Option:'
=> 'گزينه صحيح',

   'Could Not Process Request'
=> 'پردازش تقاضا ميسر نشد',

   'Course Assessment Parameter - Helper Mode'
=> 'پارامتر ارزيابى دوره - حالت كمك رسان',

   'Course Assessment Parameters - Overview Mode'
=> 'پارامترهاى ارزيابى دوره - حالت نماى كلى ',

   'Course Assessments Parameters - Table Mode'
=> 'پارامتر ارزيابى دوره - حالت جدولى',

   'Course Environment Parameters'
=> 'پارامترهاى محيطى دوره',

   'Course ID'
=> 'شناسنامه دوره',

   'Course Parameter Helper'
=> 'كمك رسان پارامتر دوره',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'آمار نمودارهاى مربوط به دوره تا راه اندازى مجدد پايگاه اطلاعاتى قابل بازيابى نيست. اطلاعات شما كامل است ولى فعلاً نمى‏توان آن را نمايش داد',

   'Course level sheet'
=> 'برگه سطح دوره',

   'Create New Environment Variable'
=> 'ايجاد متغير محيطى جديد',

   'Create a New Course'
=> 'ايجاد دوره جديد',

   'Critical Messages'
=> 'پيامهاى بحرانی',

   'Current'
=> 'جارى',

   'Current Session Value'
=> 'ارز يابى جلسه جارى',

   'Default'
=> 'پيش فرض',

   'Default Value'
=> 'مقدار پيش فرض',

   'Delete'
=> 'حذف',

   'Delete Checked'
=> 'حذف موارد بررسى شده',

   'Delete a role'
=> 'حذف يك نقش',

   'Delete an option'
=> 'حذف يك گزينه',

   'Delete:'
=> 'حذف',

   'Detailed Citation View'
=> 'بررسى جزئيات استناد',

   'Detailed Problem Analysis'
=> 'بررسى جزئيات مسأله',

   'Detailed statistics and graphs of student performance on problems.'
=> 'آمار و نمودارهاى مشروح در خصوص عملكرد دانشجو در مورد مسأله‏ها',

   'Diffs'
=> 'اختلافات',

   'Diffs with Current Version'
=> 'اختلافات با نسخه جارى',

   'Diffs with Version'
=> 'اختلافات با نسخه ',

   'Diffs with current Version'
=> 'اختلافات با نسخه جارى',

   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
=> 'غير فعال كردن شماره دانشجويي و تحميل تفيير شماره های همانند',

   'Disable all communication among students'
=> 'غير فعال كردن كليه ارتباطات بين دانشجويان',

   'Discard Selected'
=> 'الغاى گرفتن موارد انتخاب شده',

   'Discussion Contributions'
=> 'مساعدتهاى مباحثه‏اى',

   'Display All Messages'
=> 'نمايش همه پيامها',

   'Display all Messages'
=> 'نمايش همه پيامها',

   'Display and analysis of submission times on assessments.'
=> 'نمايش و بررسى دفعات درخواست ارزيابى ',

   'Display foils in order given'
=> 'نمايش وجوه تقابل به ترتيب معين',

   'Display foils in random order'
=> 'نمايش وجوه تقابل به ترتيب تصادفى',

   'Distribute Messages from Uploaded File to Course'
=> 'توزيع پيامها از فايل آپ‏لود شده به دوره',

   'DoDiff'
=> 'درجه سختی',

   'Domain Guest'
=> 'دامنه مهمان',

   'Drop Students'
=> 'حذف دانشجويان',

   'Dropped [_1]'
=> 'حذف شد',

   'Dropped [_1] student(s).'
=> 'دانشجويان حذف شده',

   'Dropping Students'
=> 'در حال حذف دانشجويان',

   'Due'
=> 'موعد',

   'Dump Course DOCS'
=> 'روبرداری اسناد دوره',

   'EMail Address'
=> 'نشانى پست الكترونيكى',

   'EMail and Messages'
=> 'نشانى پست الكترونيكى و پيامها ',

   'Edit Catalog Information'
=> 'ويرايش اطلاعات كاتالوگ',

   'Edit Content of a Map'
=> 'ويرايش محتواى نقشه',

   'Edit Directory Catalog Information'
=> 'ويرايش كاتالوگ فهرست راهنما',

   'Edit this resource'
=> 'ويرايش اين منبع',

   'Enclosing Map or Folder'
=> 'ضميمه كردن نقشه يا پوشه',

   'End Helper'
=> 'پايان دادن به كمك رسان',

   'Enroll a single student'
=> 'ثبت نام يك دانشجو',

   'Enrolling Students'
=> 'در حال ثبت نام دانشجويان',

   'Enrollment Status'
=> 'وضعيت ثبت نام',

   'Enter construction space as a co-author'
=> 'ورود به فضاى طرح به عنوان همكار نويسنده',

   'Error'
=> 'خطا',

   'Error dropping [_1]:[_2]'
=> 'از قلم انداختن خطا',

   'Essay, open end'
=> 'مقاله، باز',

   'Evaluate Resource'
=> 'ارزيابى منبع',

   'Excel'
=> 'اكسل',

   'Failed Access to Construction Space'
=> 'دسترسى به فضاى طرح ميسر نشد',

   'False'
=> 'نادرست',

   'Field'
=> 'فيلد',

   'Fielded Format'
=> 'فرمت فيلد',

   'File Category'
=> 'مقوله فايل',

   'Filenames in Construction Space'
=> 'نام فايل در فضاى طرح',

   'Finish Course Initialization'
=> 'اتمام مقدار دهى اوليه دوره',

   'First Name'
=> 'نام',

   'Foil'
=> 'وجه تقابل',

   'Foils'
=> 'وجوه تقابل',

   'Folder'
=> 'پوشه',

   'Folder in Construction Space'
=> 'پوشه در فضاى طرح',

   'For User'
=> 'براى كاربر',

   'Force publication of unmodified files'
=> 'انتشار اجبارى فايلهاى تغيير نايافته',

   'Format:'
=> 'فرمت',

   'Forward'
=> 'ارسال پيام دريافتى به گيرنده‏اى ديگر',

   'Forwarded message from'
=> 'از سوى گيرنده ارسال شد',

   'Forwarding'
=> 'در حال ارسال پيام دريافتى به گيرنده‏اى ديگر',

   'From'
=> 'از',

   'Full Update'
=> 'روزآمد سازى كامل',

   'Full update (also print list of users not enrolled anymore)'
=> 'روزآمد سازى كامل-همچنين چاپ ليست كاربرانى كه هنوز ثبت نام نكرده‏اند',

   'Functions'
=> 'كاركردها',

   'Generate Spreadsheet'
=> 'توليد برنامه صفحه گسترده',

   'Generate Statistics'
=> 'تهيه آمارها',

   'Generation'
=> 'توليد',

   'Grant/revoke Course Custom Role'
=> 'اعطا يا لغو نقش سفارشى دوره',

   'Grant/revoke role of Administrator'
=> 'اعطا يا لغو نقش مدير',

   'Grant/revoke role of Author'
=> 'اعطا يا لغو نقش نويسنده',

   'Grant/revoke role of Course Coordinator'
=> 'اعطا يا لغو نقش گرداننده دوره',

   'Grant/revoke role of Domain Guest'
=> 'اعطا يا لغو نقش مهمان دامنه',

   'Grant/revoke role of Librarian'
=> 'اعطا يا لغو نقش كتابدار',

   'Grant/revoke role of Scantron Operator'
=> 'اعطا يا لغو نقش اپراتور اسكانترون',

   'Grant/revoke role of Teaching Assistant'
=> 'اعطا يا لغو نقش دستيار مدرس',

   'Group/Section'
=> 'گروه / قسمت',

   'HTML'
=> 'HTML',

   'HTML/XML'
=> 'HTML/XML',

   'Height(pixel):'
=> 'ارتفاع -به پيكسل',

   'Hide'
=> 'مخفى كردن',

   'Hint Text'
=> 'متن با توضيحات اشاره‏اى',

   'Host'
=> 'ميزبان',

   'ID/Student Number'
=> 'كارت شناسايى / شماره دانشجويى',

   'Identify fields'
=> 'شناسايى زمينه‏ها',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'در صورت فعال بودن، دفعه بعدى كه دانشجويان با لون كاپا ارتباط برقرار مى‏كنند، نقش جديد در دسترس خواهد بود',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'اگر اين منبع به طور فعال مورد استفاده قرار گيرد، داده‏هاى عملكرد دانشجو از نسخه قبل ممكن است غير قابل دستيابى گردد',

   'Ignore First Line'
=> 'سطر اول را ناديده بگير',

   'Image:'
=> 'تصوير',

   'Incorrect Answers:'
=> 'پاسخهاى نادرست',

   'Initial Password'
=> 'رمز عبور آغازين',

   'Internal Filename'
=> 'نام فايل داخلى',

   'Internally authenticated'
=> 'از نظر محتوايى تأييد شد',

   'Invalid date entry'
=> 'تاريخ ورود، غير معتبر است',

   'Invalid home server specified'
=> 'سرور ميزبانى كه تعيين شده، معتبر نيست',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'روزآمد نگاه داشتن كليه منابع با جديدترين نسخه‏ها -حالت پيش فرض',

   'Kerberos authenticated'
=> 'كروبرها تأييد شدند',

   'Keywords'
=> 'كليد واژه‏ها',

   'LON-CAPA Domain for Students'
=> 'دامنه لون كاپا ويژه دانشجويان',

   'LON-CAPA Enrollment Manager'
=> 'مدير ثبت نام لون كاپا',

   'LON-CAPA Helper:'
=> 'كمك رسان لون كاپا',

   'LON-CAPA domain: [_1]'
=> 'دامنه لون كاپا',

   'Last Name'
=> 'نام خانوادگى',

   'Last Name, First Names'
=> 'نام خانوادگى، نام',

   'Last access'
=> 'آخرين  دسترسى',

   'Last accessed'
=> 'آخرين دفعه مراجعه',

   'Last modified'
=> 'آخرين بارى كه اين فايل تغيير كرده',

   'Last updated'
=> 'آخرين بارى كه اين فايل روزآمد شده',

   'Librarian'
=> 'كتابدار',

   'Limit by copyright/distribution'
=> 'محدود كردن بر اساس كپى رايت / توزيع',

   'Limit by language'
=> 'محدود كردن بر اساس زبان',

   'Load:'
=> 'بارگذارى',

   'Lock and unlock assessments'
=> 'قفل كردن و گشودن قفل ارزيابيها',

   'Login Type'
=> 'نوع اتصال',

   'Mail'
=> 'نامه',

   'Making Backup to'
=> 'ايجاد پشتيبان در',

   'Manage Access Keys'
=> 'مديريت كليدهاى دستيابى',

   'Manage access keys'
=> 'مديريت كليدهاى دستيابى',

   'Mark Unread'
=> 'به عنوان خوانده نشده علامت بزن',

   'Max Number Of Shown Foils:'
=> 'حد اكثر تعداد وجوه تقابل',

   'Max Possible To Date'
=> 'حد اكثر موارد ممكن بر اساس تاريخ',

   'Max Tries'
=> 'حد اكثر دفعات تلاش',

   'Max number of foils displayed'
=> 'حد اكثر تعداد وجوه تقابل نمايش داده شده',

   'Mean Tries'
=> 'ميانگين دفعات تلاش',

   'Metadata'
=> 'فراداده',

   'Metadata Version'
=> 'نسخه فراداده',

   'Metadata current version'
=> 'نسخه جارى فراداده',

   'Middle Names/Initials'
=> 'اسمهاى ميانى / حروف اول اسم',

   'Mime type'
=> 'Mime نوع',

   'Modified'
=> 'تغيير يافته',

   'Modify Course Assessment Parameters'
=> 'تغيير دادن پارامترهاى ارزيابى دوره',

   'Modify Parameters'
=> 'تغيير دادن پارامترها',

   'Modify authentication mechanism and data for a user'
=> 'تغيير مكانيزم و اطلاعات مربوط به تأييد كاربر ',

   'Modify deadlines, etc, for this assessment resource'
=> 'تغيير تاريخ سررسيدها و موارد ديگر مربوط به اين منبع ارزيابى',

   'Modify grades'
=> 'تغيير نمرات',

   'Modify student data'
=> 'تغيير دادن اطلاعات مربوط به دانشجو',

   'Modify user grades for this assessment resource'
=> 'تغيير دادن نمرات مربوط به اين منبع ارزيابى كاربر',

   'Most recently published Version'
=> 'آخرين نسخه منتشره',

   'Move Down'
=> 'حركت به پايين',

   'Move Up'
=> 'حركت به بالا',

   'Name:'
=> ': نام',

   'New Problem Variation'
=> 'نوع جديد مسأله',

   'New Randomization'
=> 'تصادفى سازى جديد',

   'New Title'
=> 'عنوان جديد',

   'New parameters or saved values'
=> 'پارامترهاى جديد يا ضوابط ذخيره شده',

   'Next'
=> 'بعدى',

   'Next ->'
=> 'بعدى ->',

   'No Kerberos domain was specified.'
=> 'هيچ دامنه كربويى مشخص نشده است',

   'No changes were made to the current settings.'
=> 'نسبت به تنظيمات جارى هيچ تغييرى اعمال نشد',

   'No language preference'
=> 'هيچ اولويت زبانى در كار نيست',

   'None Found'
=> 'هيچكدام يافت نشد',

   'Not shown, not used'
=> 'نشان داده نشد، به كار نرفت',

   'Note: for large courses, this operation may be time consuming'
=> 'ملاحظه: ممكن است اين عمليات براى دوره‏هاى بزرگ زمان‏بر باشد',

   'Note: this will not take effect if the user already exists'
=> 'ملاحظه: اگر كاربر از قبل موجود است، اين اثر نخواهد كرد',

   'Number of Plots:'
=> 'تعداد plot ها',

   'Obsolete parameters or saved values'
=> 'پارامترهاى كهنه يا ارزشهاى ذخيره شده',

   'Open'
=> 'باز كردن',

   'Open All Folders'
=> 'باز كردن تمام پوشه‏ها',

   'Option Response Problem Analysis'
=> 'بررسى امكان پاسخ ِ مسأله',

   'Option response'
=> 'پاسخ انتخاب',

   'Output'
=> 'خروجى',

   'Output Format'
=> 'فرمتِ خروجى',

   'Overall Problem Statistics'
=> 'آمارهاى كلى مسأله',

   'Owner/Publisher'
=> 'مالك/ناشر',

   'Parameter Name'
=> 'نام پارامتر',

   'Parameter Type'
=> 'نوع پارامتر',

   'Parameter in Effect'
=> 'پارامتر در حالت واقعى',

   'Per Page'
=> 'در هر صفحه',

   'Personal Information'
=> 'اطلاعات شخصى',

   'Please do not reply to this address.'
=> 'لطفاً به اين نشانى پاسخ ندهيد',

   'Please notify the server administrator '
=> 'لطفاً به مدير سرور اطلاع دهيد',

   'Please select a problem to analyze'
=> 'لطفاً براى بررسى مسأله‏اى انتخاب كنيد',

   'Please select a report to generate'
=> 'لطفاً يك گزارش انتخاب كنيد تا توليد شود',

   'Please select a report to generate.'
=> 'لطفاً يك گزارش انتخاب كنيد تا توليد شود',

   'Position'
=> 'موقعيت',

   'Post anonymously'
=> 'ارسال بدون نام نويسنده',

   'Post discussion on course resources'
=> 'ارسال بحث در مورد منابع دوره',

   'Post system frontpage announcements'
=> 'ارسال اعلانات فرانْت پيْج سيستم',

   'Post to live chatrooms'
=> 'ارسال به اتاقهاى گپ زنده',

   'Preferred language'
=> 'زبان ترجيح داده شده',

   'Preparing Excel Spreadsheet'
=> 'آماده سازى برنامه صفحه گسترده اِكسِل',

   'Previous'
=> 'پيشين',

   'Printing Helper'
=> 'كمك رسان چاپ',

   'Privacy Note'
=> 'يادداشت مربوط به امور شخصى',

   'Problem Status Chart'
=> 'نمودار وضع مسأله',

   'Problems'
=> 'مسائل',

   'Problems Not Contained In A Folder'
=> 'مسائل در يك پوشه جا داده نشده اند',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'مسائل ايجاد كننده فايل اكسل جديد. اين خطا ثبت شده است. لطفاً به مدير لون كاپا هشدار دهيد',

   'Processed [_1] student(s).'
=> 'پردازش شده [1_] دانشجويان',

   'Processing course structure'
=> 'در حال پردازش ساختار دوره',

   'Processing first student'
=> 'در حال پردازش نخستين دانشجو',

   'Produce Excel Output'
=> 'توليد خروجى اكسل',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> 'تهيه پيامهاى بازخوردى يا همكارى در بحث دوره پيرامون اين منبع',

   'Provide my evaluation of this resource'
=> 'تهيه ارزيابى خود از اين منبع',

   'Publish'
=> 'نشر',

   'Publish Directory'
=> 'فهرست راهنماى نشر',

   'Publish Directory and Sub Directories'
=> 'فهرست راهنماى نشر و زير مجموعه‏هاى آن',

   'Published'
=> 'منتشره',

   'Question Text'
=> 'متن سؤال',

   'Question Type'
=> 'نوع سؤال',

   'Quick Completed Problems Display'
=> 'نمايش سريع مسأله‏هاى تكميل شده',

   'Random position'
=> 'موقعيت تصادفى',

   'Re'
=> 'دوباره',

   'Re-enrollment will re-activate data.'
=> 'ثبت نام دوباره سبب فعال شدن مجدد اطلاعات مى‏شود',

   'Reading results from'
=> 'خواندن نتايج از',

   'Record'
=> 'گزارش  كردن',

   'Registering'
=> 'در حال ثبت كردن',

   'Related'
=> 'مربوط',

   'Reply'
=> 'پاسخ دادن',

   'Reset Submissions'
=> 'تنظيم مجدد درخواستها',

   'Resource Feedback and Discussion'
=> 'بازخورد و بحث مربوط به منبع',

   'Resource Level'
=> 'سطح منبع',

   'Retrieve'
=> 'بازيابى كردن',

   'Retrieve Published Resources'
=> 'بازيابى منابع منتشره',

   'Revert to Last Saved'
=> 'بازگشت به آخرين مورد ذخيره شده',

   'Revision Date'
=> 'تاريخ تجديد نظر',

   'Row'
=> 'رديف',

   'S.D. tries'
=> 'S.D. tries (347)',

   'Samples'
=> 'نمونه‏ها',

   'Save as'
=> 'ذخيره با نام',

   'Save as & Make This Sheet the Default'
=> 'ذخيره با نام و پيش گزيده كردن اين صفحه',

   'Save as ...'
=> '... ذخيره با نام',

   'Scantron Operator'
=> 'اپراتور اسكانترون',

   'Search Complete'
=> 'جستجو كامل است',

   'Section'
=> 'قسمت',

   'Sections'
=> 'قسمتها',

   'Select All'
=> 'انتخاب همه موارد',

   'Select All Students'
=> 'انتخاب همه دانشجويان',

   'Select Date'
=> 'انتخاب تاريخ',

   'Select Enclosing Map or Folder'
=> 'انتخاب نقشه يا پوشه ضميمه',

   'Select Parameter Level'
=> 'انتخاب سطح پارامتر',

   'Select Spreadsheet File'
=> 'انتخاب فايل صفحه گسترده',

   'Select a course'
=> 'يك دوره درسى انتخاب كنيد',

   'Selecting a User'
=> 'در حال انتخاب كاربر',

   'Send Message to User(s)'
=> 'ارسال پيام به كاربران',

   'Send New'
=> 'ارسال پيام جديد',

   'Send Reply'
=> 'ارسال پاسخ',

   'Send Scantron data to a course'
=> 'ارسال داده‏هاى اسكانترون به يك دوره',

   'Send as critical message'
=> 'ارسال به عنوان پيام نقادانه',

   'Send internal email'
=> 'ارسال نامه الكترونيكى داخلى',

   'Sequence or Folder'
=> 'توالى يا پوشه',

   'Sequences and Folders'
=> 'توالى‏ها و پوشه‏ها',

   'Set Course Environment Parameters'
=> 'تنظيم پارامترهاى محيطى دوره',

   'Set Date'
=> 'تنظيم تاريخ',

   'Set Defaults for All Resources in Course'
=> 'تنظيم پيش فرضها براى همه منابع در دوره',

   'Set Version to be used in Course'
=> 'تنظيم نسخه براى استفاده در دوره ',

   'Set Versions to be used in Course according to Selections below'
=> 'تنظيم نسخه براى استفاده در دوره طبق انتخابهاى زير',

   'Set a due date'
=> 'تعيين تاريخ مناسب',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'تنظيم همه نسخه‏هاى منبع طبق نسخه جارى -تعيين نسخه‏ها',

   'Set an answer open date'
=> 'تنظيم يك تاريخ اُپِن براى پاسخ',

   'Set an open date'
=> 'تنظيم يك تاريخ اُپِن',

   'Set opening datefor all problems in the course for. . .'
=> 'تعيين تاريخ شروع همه مسائل در دوره به منظور',

   'Set the number of tries'
=> 'تعيين تعداد دفعات آزمايش',

   'Set the problem weight'
=> 'تعيين اهميت مسأله',

   'Set/Modify Course Assessment Parameter'
=> 'تعيين / تغيير پارامتر ارزيابى دوره',

   'Set/Modify Course Assessment Parameters'
=> 'تعيين / تغيير پارامترهاى ارزيابى دوره',

   'Set/Modify Course Parameters'
=> 'تعيين / تغيير پارامترهاى دوره',

   'Shared by course faculty and staff'
=> 'مشترك بين اعضاى هيئت علمى و كاركنان',

   'Short string response'
=> 'پاسخ كوتاه رشته اى',

   'Show More Options'
=> 'نمايش امكانات بيشتر',

   'Show Preview'
=> 'پيش نمايش',

   'Show always at bottom position'
=> 'هميشه در قسمت پايين نمايش بده',

   'Show always at top position'
=> 'هميشه در قسمت بالا نمايش بده',

   'Show catalog information'
=> 'نمايش اطلاعات كاتالوگ',

   'Show resource'
=> 'نمايش منبع',

   'Significant figures are incorrect, submission was not graded.'
=> 'واحد ارقام صحيح نيست، تقاضا تصحيح نشد',

   'Simple Problem Editor'
=> 'ويرايشگر مسأله ساده',

   'Size'
=> 'اندازه',

   'Size:'
=> ':اندازه',

   'Skew Tries'
=> 'مخدوش كردن آزمايشها',

   'Space separated'
=> 'فضا جدا شد',

   'Spreadsheet Computation'
=> 'محاسبه برنامه صفحه گسترده',

   'Spreadsheet Computation Status'
=> 'وضعيت محاسبه برنامه صفحه گسترده',

   'Starting'
=> 'در حال شروع كردن',

   'Starting and Ending Dates'
=> 'تاريخ شروع و پايان',

   'Statistics'
=> 'آمار',

   'Statistics and Problem Analysis'
=> 'آمار و بررسى مسأله',

   'Save Changes'
=> 'ذخيره تغييرات',

   'Student Data Compilation Progress'
=> 'پيشرفت جمع آورى اطلاعات دانشجو',

   'Student Data Compilation Status'
=> 'وضع پيشرفت جمع آورى اطلاعات دانشجو',

   'Student Number'
=> 'شماره دانشجو',

   'Student level sheet'
=> 'برگه سطح دانشجو',

   'Student performance statistics on all problems.'
=> 'آمار عملكرد دانشجو در مورد كليه مسائل',

   'Students Affected'
=> 'دانشجويان تحت تأثير',

   'Submission Time Analysis'
=> 'بررسى زمان تحويل',

   'Submit Changes and Edit'
=> 'تحويل دادن تغييرات و ويرايش ',

   'Summary'
=> 'خلاصه',

   'Summary View'
=> 'ديدگاه  خلاصه اى',

   'Synchronized SQL metadata database'
=> 'SQL پايگاه اطلاعاتى همزمان شده فراداده',

   'Tabulator separated'
=> 'تعديل گر جدا شد',

   'Task'
=> 'كار',

   'TeXWidth(mm):'
=> 'پهنا به ميلى متر',

   'Template'
=> 'الگو',

   'Temporary Assembly Workspace'
=> 'فضاى كار موقتى براى سر هم كردن',

   'Text'
=> 'متن',

   'Text Block'
=> 'بلوك متن',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> 'اطلاعاتى كه تحويل مى‏دهيد مى‏تواند در معرض ديد هر كسى باشد كه به لون كاپا متصل شده است. اطلاعاتى را كه مايل نيستيد در دسترس همگان باشد، ارسال نكنيد',

   'The optional email address field was not specified.'
=> 'زمينه اختيارى نشانى پست الكترونيكى مشخص نشد',

   'The optional name field was not specified.'
=> 'زمينه اختيارى نام مشخص نشد',

   'The optional section or group field was not specified.'
=> 'زمينه اختيارى قسمت يا گروه مشخص نشد.',

   'The optional student number field was not specified.'
=> 'زمينه اختيارى شماره دانشجويى مشخص نشد',

   'There are currently no results'
=> 'فعلاً هيچ  نتيجه‏اى در كار نيست',

   'There are no students currently enrolled.'
=> 'فعلاً هيچ دانشجوى ثبت نام نكرده‏است',

   'There is no student data for this problem.'
=> 'اين مسأله فاقد هر گونه داده دانشجويى است',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'اين كمك رسان در تنظيم تاريخهاى اُپِن و مناسب براى اين مسائل يا تعداد دفعات آزمايش براى مسائل به شما مساعدت خواهد كرد. در مورد مسائلى كه مايل به تعيين پارامتر برايشان هستيد و نيز پارامترهايى را كه مايليد مدّ نظر قرار دهيد، از شما خواهند كرد. سپس شما اشخاصى را انتخاب خواهيد كرد كه اين تنظيمات بر آنها اثر كند. جاهايى را كه براى اعمال پارامترهاى خود سركشى كرده‏ايد بعد از پايان كار كمك رسان مى‏توانيد ملاحظه كنيد تا بتوانيد در آينده اين مرحله را مستقيماً طى كنيد. براى آغاز عمليات گزينه بعدى را فشار دهيد. براى بازگشت به صفحه پيشين گزينه پيشين را فشار دهيد',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'اين يك پيام خودكار است كه توسط نظام لون كاپا ايجاد شده است',

   'Threaded View'
=> 'Threaded View (437)',

   'Time'
=> 'زمان',

   'To'
=> 'به',

   'Topic'
=> 'موضوع',

   'Total'
=> 'مجموعاً',

   'Total Parts In Course'
=> 'بخشهاى كلى دوره',

   'Total number of records found in file: [_1].'
=> 'مجموعاً اين تعداد گزارش در فايل يافت شد',

   'True'
=> 'درست',

   'Type'
=> 'نوع',

   'Type-in value'
=> 'نوع در ارزش',

   'UNIX authenticated'
=> 'يونيكس تأييد شد',

   'URL'
=> 'نشانى اينترنتى',

   'USERS'
=> 'كاربران',

   'Unable to connect to database!'
=> 'اتصال به پايگاه داده‏ها ميسر نشد',

   'Unable to enroll students'
=> 'ثبت نام دانشجويان ميسر نشد',

   'Uncheck All'
=> 'ثبت',

   'Unit:'
=> 'واحد',

   'Unknown ID'
=> 'كارت شناسايى ناشناخته',

   'Unknown user'
=> 'كاربر ناشناس',

   'Unpublished'
=> 'منتشر نشده',

   'Unselect All'
=> 'لغو انتخاب همه',

   'Unselect All Students'
=> 'لغو انتخاب همه دانشجويان',

   'Unsuccessful Login'
=> 'برقرارى ارتباط موفقيت‏آميز نبود',

   'Up'
=> 'بالا',

   'Update Course Assessment Parameter Display'
=> 'زآمد سازى نمايش پارامتر ارزيابى دوره',

   'Update Section or Specific User'
=> 'روزآمد سازى كاربرِ قسمت يا كاربر خاص',

   'Update Student Data'
=> 'روزآمدسازى داده‏هاى دانشجو',

   'Updating discussion time'
=> 'در حال روزآمدسازى زمان بحث',

   'Upload Scantron data'
=> 'آپ‏لود كردن داده‏هاى اسكانترون',

   'Upload a Photo'
=> 'آپ‏لود كردن يك عكس',

   'Uploading Class List'
=> 'آپ‏لود كردن فهرست يك كلاس',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> 'يادداشتهاى كاربر، گزارشهاى بحثهاى رويارو و پيامهاى نقادانه در دوره',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> 'يادداشتهاى كاربر، گزارشهاى بحثهاى رويارو و پيامهاى نقادانه ',

   'Value'
=> 'مقدار',

   'Verify Content'
=> 'تأييد محتوا',

   'Verify Selection'
=> 'تأييد انتخاب',

   'Version Number'
=> 'شماره نسخه',

   'Version changes since Yesterday'
=> 'تغييرات نسخه از ديروز تاكنون',

   'Version changes since last Month'
=> 'تغييرات نسخه از ماه گذشته تاكنون',

   'Version changes since last Week'
=> 'تغييرات نسخه از هفته گذشته تاكنون',

   'Version changes since start of Course'
=> 'تغييرات نسخه از ابتداى دوره تاكنون',

   'Version used in Course'
=> 'نسخه مورد استفاده در دوره',

   'View'
=> 'ملاحظه',

   'View Class List'
=> 'ملاحظه فهرست كلاس',

   'View Critical Messages'
=> 'ملاحظه پيامهاى نقادانه',

   'View Published Version'
=> 'ملاحظه نسخه منتشره',

   'View user submissions for this assessment resource'
=> 'ملاحظه درخواستهاى كاربر براى اين منبع ارزيابى',

   'Warning!'
=> '! اخطار ',

   'Web References'
=> 'منابع وِب',

   'Welcome'
=> '! خوش آمديد',

   'Welcome to the Assignment Parameter Helper'
=> 'به كمك رسان واگذارى پارامتر خوش آمديد',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up'
=> 'به شبكه آن لايْنِ يادگيرى به وسيله كاپا خوش آمديد! لطفاً صبر كنيد تا جلسه شما تنظيم شود',

   'What parameter do you want to set for all problems in the course?'
=> 'چه پارامترى براى اعمال جهت همه مسائل دوره در نظر داريد؟',

   'What should the opening date be set to?'
=> 'تاريخ افتتاح روى چه چيزى تنظيم شود؟',

   'Which Problem or Problems?'
=> 'چه مسأله يا مسائلى؟',

   'Which problems do you wish to set a parameter for?'
=> 'براى كداميك از مسائل مى‏خواهيد پارامتر تعيين كنيد؟',

   'Width(pixel):'
=> 'پهنا به پيكسل',

   'Words'
=> 'واژه‏ها',

   'XML/SGML'
=> 'XML/SGML (497)',

   'You have no critical messages.'
=> 'شما هيچ پيام نقادانه‏اى نداريد',

   'You must choose an authentication type.'
=> 'شما بايد يك نوع تأييد انتخاب كنيد',

   'You must choose at least one student to continue.'
=> 'براى ادامه بايد حد اقل يك دانشجو انتخاب كنيد',

   'You must choose one or more choices to continue.'
=> 'براى ادامه بايد يك گزينه يا بيشتر انتخاب كنيد',

   'You need to choose another user role or enter a specific course for this function'
=> 'لازم است يك نقش كاربرى ديگر انتخاب كنيد يا دوره مشخصى را براى اين كاركرد وارد كنيد',

   'You need to specify the Kerberos domain.'
=> 'لازم است دامنه كربروها را تعيين كنيد',

   'You need to specify the initial password.'
=> 'لازم است كلمه عبور آغازين را تعيين كنيد',

   'You need to specify the username field.'
=> 'لازم است زمينه نام كاربرى را تعيين كنيد',

   'Your Excel Spreadsheet'
=> 'برنامه صفحه گسترده اِكسِلِ شما',

   'Your Version Settings have been Saved'
=> 'تنظيمات نسخه شما ذخيره شده است',

   '[_1] Do not change login data'
=> '[_1] داده‏هاى برقرارى ارتباط را تغيير ندهيد',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] سيستم فايل تأييد شد با رمز عبور آغازينd [_2])',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] از حيث محتوايى تأييد شد با رمز عبور آغازين d [_2])',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5'
=> '[_1] كربروها تأييد شدند با دامنه  n [_2] [_3]  4  نسخه c [_4] 5 نسخه v (511)',

   '[_1] Local Authentication with arguement [_2]'
=> '[_1] Local  argument تأييد t [_2]',

   'a.m.'
=> 'پيش از ظهر',

   'abstract'
=> 'چكيده',

   'acc keys'
=> 'acc- كليدهاى',

   'according to course preferences'
=> 'طبق اولويتهاى دوره',

   'according to resource settings'
=> 'طبق تنظيمات منبع',

   'according to user session state'
=> 'طبق حالت جلسه كاربر',

   'all'
=> 'همه',

   'and return receipt'
=> 'و رسيد را بازگردانيد',

   'anonymous'
=> 'ناشناس',

   'at'
=> 'در',

   'at Domain'
=> 'در دامنه',

   'at domain'
=> 'در دامنه',

   'audio'
=> 'صوتى',

   'author'
=> 'نويسنده',

   'bytes'
=> 'بايْت‏ها',

   'can not be accessed from your location.'
=> 'از موقعيت شما قابل دسترسى نيست',

   'catalog'
=> 'كاتالوگ',

   'co con-'
=> 'co con- (530)',

   'co res'
=> 'co res (531)',

   'contacting'
=> 'در حال تماس',

   'copyright'
=> 'كپى رايت',

   'customdistributionfile'
=> 'فايل توزيع سفارشى',

   'default'
=> 'پيش فرض',

   'directory'
=> 'فهرست راهنما',

   'discuss'
=> 'مباحثه',

   'edit'
=> 'ويرايش',

   'evaluate'
=> 'ارزيابى',

   'feedback'
=> 'بازخورد',

   'for Enclosing Map or Folder'
=> 'براى نقشه يا پوشه ضميمه',

   'for Resource'
=> 'براى منبع',

   'from Enclosing Map or Folder'
=> 'از نقشه يا پوشه ضميمه',

   'general'
=> 'عمومى',

   'in Course'
=> 'در دوره',

   'in Section/Group'
=> 'در قسمت / گروه',

   'info'
=> 'اطلاعات',

   'interface available'
=> 'رابط كاربر موجود است',

   'keywords'
=> 'كليد واژه‏ها',

   'language'
=> 'زبان',

   'last student'
=> 'آخرين دانشجو',

   'loginproblems.html'
=> 'loginproblems.html',

   'manage'
=> 'مديريت كردن',

   'midnight'
=> 'نيمه شب',

   'minutes'
=> 'دقيقه',

   'missions'
=> 'مأموريتها',

   'most recent'
=> 'تازه‏ترين',

   'movies'
=> 'فيلمها',

   'name only visible to course faculty'
=> 'نام تنها براى هيئت علمى دوره قابل رؤيت است',

   'noon'
=> 'ظهر',

   'notes'
=> 'يادداشتها',

   'num_override'
=> 'num_override',

   'obsolete'
=> 'كهنه',

   'obsoletereplacement'
=> 'جايگزينى كهنه',

   'of'
=> 'از',

   'or ID'
=> 'يا كارت شناسايى',

   'p.m.'
=> 'بعد از ظهر',

   'pages'
=> 'صفحات',

   'part'
=> 'بخش',

   'percent'
=> 'درصد',

   'pictures'
=> 'تصاوير',

   'problem'
=> 'مسأله',

   'problem statistics grouped by sequence'
=> 'آمار مسأله طبق توالى گروه بندى شد',

   'problem statistics ungrouped'
=> 'آمار مسأله گروه بندى نشده است',

   'problem statistics, Excel'
=> 'آمار مسأله، اِكسِل',

   'remaining'
=> 'باقيمانده',

   'resources'
=> 'منابع',

   'second'
=> 'ثانيه',

   'seconds'
=> 'ثانيه‏ها',

   'seconds for'
=> 'ثانيه‏ها براى',

   'sequence'
=> 'توالى',

   'subject'
=> 'موضوع',

   'this'
=> 'اين',

   'title'
=> 'عنوان',

   'unless locked'
=> 'مگر اينكه قفل شده باشد',

   'users in'
=> 'كاربران در',

   'versions of this problem'
=> 'نسخه‏هاى اين مسأله',

   'view sub-'
=> 'ملاحظه زير',

   'waiting on'
=> 'خدمت كردن به',


#SYNCMARKER
);

1;

