# The LearningOnline Network with CAPA
# Chinese Simplified Localization Lexicon
#
# $Id: zh.pm,v 1.75 2009/08/11 15:15:09 bisitz Exp $
#
# Copyright Michigan State University Board of Trustees
#
# This file is part of the LearningOnline Network with CAPA (LON-CAPA).
#
# LON-CAPA is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# LON-CAPA is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with LON-CAPA; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#
# /home/httpd/html/adm/gpl.txt
#
# http://www.lon-capa.org/
#
######################################################################
######################################################################


package Apache::localize::zh;
use base qw(Apache::localize);

%Lexicon=('_AUTO' => 1,
'char_encoding'=> 'UTF-8',
'language_code'=> 'zh',
'lang_locale' => 'zh-cn.utf8',
'date_locale'  => 
      '$weekday, $day. $month $year, $twentyfour:$minutes:$seconds',
'date_months'  => '一月,二月,三月,四月,五月,六月,七月,八月,九月,十月,十一月,十二月',
'date_days'    => '星期日,星期一,星期二,星期三,星期四,星期五,星期六',
'date_am' => '上午',
'date_pm' => '下午',
'textual_remote_display' => 'on',
'htmlarea_lang' => 'zh-cn',

   'Domain'
=> '领域',

   'Domain:'
=> '领域：',

   'Server'
=> '服务器',

   'Server Load'
=> '服务器负载',

   'User Load'
=> '用户负载',

   'Help'
=> '帮助',

   'Log in'
=> '登录',

   'Log-in to LON-CAPA'
=> '登录 LON-CAPA',

   'Username'
=> '用户名',

   'Password'
=> '密码',

   'choose'
=> '选择',

   'enter'
=> '进入',

   'view'
=> 'betrachten',

   'calendar'
=> '日历',

   'prefer-'
=> 'Präfe-',

   'ences'
=> 'renzen',

   'role'
=> '角色',

   'course'
=> '课程',

   'Course'
=> '课程',

   'Section/Group'
=> '科/组',

   'today'
=> '今日',

   'last week'
=> '上周',

   'last month'
=> '上个月',

   'last three months'
=> '过去3个月',

   'last six months'
=> '过去6个月',

   'last year'
=> '去年',

   'Submit'
=> '提交',

   'Rename'
=> '重命名',

   'Save'
=> '保存',

   'Save All'
=> '全部保存',

   'Done'
=> '完成',

   'Select User'
=> '选择用户',

   'Select Course'
=> '选择课程',

   'Changes will become active for your current session after'
=> 'Änderungen werden für Ihre derzeitige Sitzung aktiv, nachdem Sie',

   're-initializing course'
=> '课程重新初始化',

   ', or the next time you log in.'
=> '，或在您下次登录。',

   'Uploaded Document'
=> '上传文件',

   'No content modifications yet.'
=> '还没有修改任何内容。',

   'Part is not open to be viewed. It'
=> 'Aufgabenteil nicht verfügbar. Er',

   'Unable to determine if this resource is open due to network problems. Please try again later.'
=> 'Aufgrund von Netzwerkproblemen kann nicht festgestellt werden, ob diese Ressource verfügbar ist. Bitte versuchen Sie es später noch einmal.',

   'Note: it can take up to 10 minutes for changes to take effect for all users.'
=> '注意：所有用户更改生效可能需要10分钟。',

   'Language'
=> '语言',

   'Notes'
=> '注释',

   'Abstract'
=> '摘要',

   'Create a user or modify the roles and privileges of a user'
=> '创建或修改用户的角色和权限',

   'View course assessment statistics'
=> '查看课程评估统计',

   'Set deadlines and other assessment parameters, as well as modify course environment'
=> '设置最后期限和其他评估参数，以及修改课程环境',

   'New Folder'
=> '新建文件夹',

   'Simple Page'
=> '简单的页面',

   'Simple Problem'
=> '简单的问题',

   'Upload Document'
=> '上传文件',

   'Search'
=> '搜索',

   'Import'
=> '导入',

   'Main Course Documents'
=> '主要课程文件',

   'Supplemental Course Documents'
=> '附加的课程文件',

   'Bulletin Board'
=> '公告板',

   'Published Resources'
=> '发布的资源',

   'Special Documents'
=> '特别文件',

   'Special documents'
=> '特别文件',

   'Document'
=> '文件',

   'Settings'
=> '设置',

   'create'
=> '创建',

   'grades'
=> '评估',

   'commu-'
=> 'commu-',

   'nication'
=> 'nication',

   'enroll'
=> '记录',

   'navigate'
=> '目录',

   'contents'
=> '导航',

   'Navigate Contents'
=> '浏览目录',

   'Announcements and Calendar'
=> '注意事项和日历',

   'Author'
=> '作者',

   'Change Your Preferences'
=> '更改用户首选项',

   'Choose the user role'
=> '更换用户角色',

   'Co-Author'
=> '合著者',

   'Co-Author [_1]'
=> '合著者 [_1]',

   'Communication and Messages'
=> '通信与信息',

   'Course Coordinator'
=> '课程组织者',

   'Course Statistics and Charts'
=> '课程统计和图表',

   'Course announcements and my calendar'
=> '注意事项和日历',

   'Course Announcements'
=> '课程公告',

   'Create Users, Change User Privileges'
# => 'Erstellen neuer Benutzeraccounts, ändern von Benutzerprivilegien',
  => 'Benutzeraccounts und Rechte verwalten',

   'Domain Coordinator'
=> 'Domänen-Koordinator',

   'Enrollment Manager'
=> 'Kursbelegungs-Verwaltung',

   'Enter grades from check-out assessment resources'
=> 'Eingeben von Bewertungen für Beurteilungs-Ressourcen', #??? [SB 20.10.2006]

   'Exam Proctor'
=> '监考人员',

   'Exit LON-CAPA'
=> '退出',

   'Grades Spreadsheet'
=> '等级表',

   'Grading'
=> '评估',

   'Instructor'
=> '讲师',

   'Launch Remote Control'
=> '激活远程控制',

   'Main Menu'
=> '主菜单',

   'Navigate Course Contents'
=> '浏览目录',

   'No Role, Cumulative Privileges'
=> '没有角色，增加特权',

   'Return to Last Location'
=> '回到最后的位置',

   'Send and receive messages'
=>'发送和接收邮件',

   'Send and Receive Messages'
=>'发送和接收邮件',

   'Set my user preferences'
=> '用户设置',

   'Student'
=> '学生',

   'Student: '
=> '学生：',

   'Switch to another user role'
=> '更换用户角色',

   'Teaching Assistant'
=> '教学助理',

   'Use or edit my bookmark collection'
=> '书签收藏',

   'User Roles'
=> '用户角色',

   'Calculate course grades (Spreadsheet)'
=> 'Bewertungen berechnen (Beurteilungsbogen)',

   'Enter the chat room for the course'
=> '课程聊天室',

   'Navigate the table of contents for this course'
=> '课程目录',

   'Syllabus'
=> '课程表',

   'Course syllabus'
=> '课程教学大纲',

   'View the course assessment progress chart'
=> '察看课程评估进展图表',

   'Class Hours'
=> '课时',

   'Coursepack'
=> '课外书',

   'Current Month'
=> '这个月',

   'Deadlines'
=> '截止日期',

   'Grading Information'
=> '评估信息',

   'Helproom Hours'
=> '帮助',

   'Instructor Information'
=> '讲师信息',

   'Next Month'
=> '下个月',

   'Office Hours'
=> '办公时间',

   'Prerequisites'
=> '必要条件',

   'Previous Month'
=> '上个月',

   'Readings'
=> '材料',

   'Mon'
=> '星期一',

  'Tue'
=> '星期二',

   'Wed'
=> '星期三',

   'Thu'
=> '星期四',

   'Fri'
=> '星期五',

   'Sat'
=> '星期六',

   'Sun'
=> '星期日',

   'January'
=> '一月',

   'February'
=> '二月',

   'March'
=> '三月',

   'April'
=> '四月',

   'May'
=> '五月',

   'June'
=> '六月',

   'July'
=> '七月',

   'August'
=> '八月',

   'September'
=> '九月',

   'October'
=> '十月',

   'November'
=> '十一月',

   'December'
=> '十二月',

   'Textbook'
=> '教材',

    'Web Links'
=> '网站链接',

   'Drop/Add students in this course'
=> '在该课程移除/添加学生',

   'A score has been assigned.'
=> 'Bewertung wurde zugewiesen', # ???

   'Some parts were not submitted.'
=> 'Einige Aufgabenteile sind nicht bearbeitet worden.',

   'Due'
=> 'Fällig',

   'The filetype extension of the file you uploaded is not allowed.'
=> 'Die Endung der von Ihnen eingereichten Datei ist nicht erlaubt.',

   'Units incorrect.'
=> '单位不正确的。',

   'Only a number required.'
=> '只允许一个数字。Als Eingabe ist nur eine Zahl zulässig.',

   'Units required'
=> '要求单位',

   'Tries'
=> '尝试',

   'Submit Answer'
=> '提交答案',

   'Prepare a printable document'
=> '打印',

   'Go To My First Homework Problem'
=> '转到我的第一次作业问题',

   'Cancel'
=> '取消',

   'Discussions'
=> '讨论',

   'New discussion since'
=> 'Neue Diskussion seit',

   'New message (click to open)'
=> '新邮件 (点击查看)',

   'Close all folders'
=> '关闭所有文件夹',

   'Open all folders'
=> '打开所有文件夹',

   'Goodbye'
=> '再见',

   'Select'
=> '选择',

   'Re-Initialize'
=> '重新初始化',

   'Currently selected.'
=> '目前选定的。',

   'Switch Server'
=> '选择服务器',

   'system wide'
=> '全系统的', # 'systemweit'

   'Currently not available'
=> '目前无法使用',

   'No role specified'
=> '没有具体的角色',

   'Remark'
=> '注释',

   'Extent'
=> '领域',

   'Current Privileges'
=> '当前权限',

   'User Role'
=> '用户角色',

   'Start'
=> '开始',

   'End'
=> '结束',

   'System'
=> '系统',

   'Display'
=> '显示',

   'Display:'
=> '显示:',

   'Do not display'
=> '不显示',

   "an unknown date"
=> '日期不详', # !

   "an indeterminate date"
=> '无限期',

   "will open on"
=> "开放于",

   "is due at"
=> "ist fällig am",

   "was due on"
=> "war fällig am",

   'is closed but you are allowed to view it'
=> "ist geschlossen, kann aber von Ihnen betrachtet werden",

   "Undid changes, Switched [_1] and [_2]"
=> "Änderungen rückgängig gemacht. [_1] und [_2] wurden ausgetauscht.",

   "Unable to undo, unable to switch [_1] and [_2]"
=> "Änderungen konnten nicht rückgängig gemacht werden. [_1] und [_2] konnten nicht ausgetauscht werden.",

   "Unable to make backup [_1]"
=> "Konnte keine Sicherheitsdatei in [_1] erstellen!",

   "Saving Modifications to [_1]"
=> "Speichere Änderungen in [_1]",

   "Unable to write to [_1]"
=> "Konnte Änderungen nicht in [_1] speichern!",

   "Analyzing a problem"
=> "Analysiere Aufgabe",

   "EditXML"
=> "XML-Editor",

   'Discard Edits and View'
=> 'Änderungen verwerfen und betrachten',

   'Submit Changes'
=> 'Speichern und weiterbearbeiten', # 'Änderungen speichern',

   'Submit Changes and View'
=> 'Speichern und betrachten',

   'Edit'
=> '编辑',

   ', select a template from the pull-down menu below'
=> 'wählen Sie eine Vorlage aus dem unterstehenden Auswahlmenü',

   'undo'
=> 'Rückgängig machen',

   'Answer'
=> 'Antwort',

   'Frequency'
=> 'Häufigkeit',

   'You did not select a template.'
=> 'Sie haben keine Vorlage ausgewählt.',

   'Analyze Progress'
=> 'Fortschritt analysieren',

   'Getting Problem Variants'
=> 'Berechne Aufgabenvariationen',

   'last problem'
=> 'letzte Aufgabe',

   "may open later."
=> 'könnte zu einem späteren Zeitpunkt verfügbar werden.',

   ', and answers will be available on'
=> ', Antworten werden verfügbar sein am',

   "Select a"
=> "Wählen Sie",

   'Part'
=> '部分',

   "Then"
=> 'Dann',

   'is in under construction'
=> 'ist in Arbeit',

   'List of possible answers'
=> 'Liste von möglichen Antworten',

   'Found no analyzable parts in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren Aufgabenteile gefunden.  Derzeit werden nur numerische Ausdrücke, Formeln und Strings als Antworttypen unterstützt.',

   'Response [_1] is not analyzable at this time'  #    'is not analyzable at this time'
=> 'Antwort [_1] ist derzeit nicht analysierbar.', # => '目前没有可分析性',

   'Title'
=> '标题',

   'Path'
=> 'Pfad',

   'New Search'
=> '重新搜索',

   'Go Back'
=> '后退',

   'Go back'
=> '后退',

   'File'
=> '文件',

   'Date'
=> '日期',

   'You have no unread messages'
=> '您没有未读邮件',

   'New Message'
=> '新邮件',

   'New Messages'
=> '新邮件',

   'View All Messages'
=> '查看所有邮件',

   'Map'
=> '课程内容',

   'Page'
=> '页',

   'Sequence'
=> '顺序',

   'Map contents are not shown in order.'
=> '课程内容不排序显示。',

   'Empty'
=> '空的',

   'File [_1] could not be copied.'
=> '文件 [_1] 无法复制。',

   'Back to Directory'
=> '返回文件夹',

   'No upload file specified.'
=> '没有上传指定的文件。',

   'The target is an existing directory.'
=> '目标在一个现有的目录中。',

   'Please use browser "Back" button and pick a filename'
=> 'Bitte benutzen Sie "Zurück" in Ihrem Webbrowser und geben Sie einen Dateinamen an',

   "You do not have authoring privileges for this resource"
=> "Sie haben für diese Ressource keine Schreibberechtigung!",

   'Copying file'
=> '复制文件',

   'No write permission to user directory, FAIL'
=> '没有权限写入这个目录。中断',

   'Actions'
=> '动作', # '行动',

   'Name'
=> '名字',

   'Status'
=> '状态',

   'Last Modified'
=> '最后修改',

   'Yes'
=> '是',

   'Construction Space Directory'
=> '建设目录',

   'Contact [_1] for access.'
=> '获取 [_1] 联系。',

   'Please log into [_1] to edit.'
=> '请登入 [_1] 进行修改。',

   'Save uploaded file as [_1]'
=> '保存上传的文件为 [_1]',

   'Searching'
=> '搜索',

   'Searching ...'
=> '搜索...',

   'Owner:Domain'
=> '所有者：域',

   'Owner/Co-owner(s)'
=> '所有者/合伙人',

   'Select the Construction Space'
=> '选择建设领域',

   'It is recommended that you use an up-to-date virus scanner before handling this file.'
=> 'Es wird grundsätzlich empfohlen, einen aktuellen Virenscanner zu benutzen, bevor Sie diese Datei verwenden.',

   'not displayed'
=> '不显示',

   "Open, no due date"
=> "开放的，没有截止日期",

   "Uncompleted Homework"
=> "未完成家庭作业",

   "Show Only Uncompleted Homework"
=> "只显示未完成家庭作业",

   "All homework is currently completed."
=> "目前所有完成的功课。",

   'This course is empty.'
=> '这课程是空的。',

   'Coursemap undefined.'
=> '课程内容没有定义。',

   "Was due"
=> "截止于",

   "Answer available"
=> "答案可用",

   "Excused by instructor"
=> "由讲师通过",

   "Answer submitted, not yet graded"
=> "提交答案，尚未评分",

   "No due date"
=> "没有截止日期",

   'never'
=> '从来不',

   'Answer submitted'
=> '提交答案',

   '[_1] of [_2] tries used'
=> '[_1] 的 [_2] 尝试使用',

   'Processing'
=> '数据处理',

   'Access and Usage Statistics'
=> '访问和使用统计',

   'Evaluation Comments'
=> '评价评论',

   'Evaluation Data'
=> '评价数据',

   'Server Administration'
=> '服务器管理',

   'System Administration'
=> '系统管理',

   'Users with Roles Assigned by'
=> 'Benutzer, deren Rollen vergeben wurden von',

   'Name starting with'
=> '从开头',

   'This resource has been marked obsolete by the author(s)'
=> 'Dieses Ressource wurde vom Autor bzw. von den Autoren als überholt gekennzeichnet',

   'Upload'
=> '上传',

   'Uploaded'
=> '已上传',

   'Dynamic Metadata'
=> '动态数据',

   'View file'
=> '查看文件',

   'Illegal filename.'
=> '无效的文件名。',

   'Rule'
=> '规则',

   'Back to Source Directory'
=> '回到源目录',

   'Back to Source'
=> '回到源文件',

   'Back to Resource'
=> 'Zurück zur Ressource', # '回到资源',

   'File copied.'
=> '档案复制。',

   'FAIL'
=> '中断',

   'Back to [_1]'
=> '回到 [_1]',

   'untitled'
=> '无标题',

   'The extension on this file, [_1], is reserved internally by LON-CAPA.'
=> 'Die Dateiendung [_1] ist LON-CAPA-intern reserviert.',

   'The extension on this file is reserved internally by LON-CAPA.'
=> 'Die Dateiendung ist LON-CAPA-intern reserviert.',

   'The extension on this file, [_1], is not recognized by LON-CAPA.'
=> 'Die Dateiendung [_1] ist LON-CAPA unbekannt.',

   'The extension on this file is not recognized by LON-CAPA.'
=> 'Die Dateiendung [_1] ist LON-CAPA unbekannt.',

   'Please change the extension.'
=> 'Bitte ändern Sie die Dateiendung.',

   'Became this version on ...'
=> 'Wurde diese Version am...',

   'Browse published resources'
# => 'Veröffentlichte Dokumente betrachten',
=> '发布资源',

   'Choose the course to work on'
=> '选择您想要选的课程',

   'Create a new course'
=> '创建课程',

   'Customized right of use ...	'
=> 'Spezielle Nutzungsrechte...',

   'Delete messages from bulletin boards'
=> 'Lösche Nachrichten vom Schwarzen Brett',

   'Domain only - use limited to courses in the domain'
=> 'Beschränkt auf Domäne - Nutzung begrenzt auf Kurse innerhalb dieser Domäne',

   'Edit and view documents included in this course'
=> '布置课程内容',

   'Edit/Modify DOCS'
=> '布置课程内容',

   'Enter my construction space'
# => 'Konstruktionsbereich aufrufen',
=> 'Mein Konstruktionsbereich',

   'Failed to copy source'
=> 'Konnte Quelldatei nicht kopieren',

   'Failed to write metadata copy'
=> 'Konnte Metadaten nicht kopieren',

   'Finalize Publication'
=> 'Veröffentlichung abschließen',

   'Grant/revoke role of Co-Author'
=> 'Vergebe/entziehe Co-Autorenrollen',

   'Grant/revoke role of Domain Coordinator'
=> 'Vergebe/entziehe Domänen-Koordinator-Rolle',

   'Grant/revoke role of Exam Proctor'
=> 'Vergebe/entziehe Rolle des Klausuraufsichtspersonals',

   'Grant/revoke role of Instructor'
=> 'Vergebe/entziehe Rolle des Dozenten',

   'Grant/revoke role of Student'
=> 'Vergebe/entziehe Rolle von Studierenden',

   'Grant/revoke role of Superuser'
=> 'Vergebe/entziehe Rolle des Superusers',

   'No previous versions published.'
=> 'Es wurden keine vorhergehenden Versionen veröffentlicht.',

   'No write permission to'
=> 'Keine Schreibberechtigung für',

   'Please pick a version to retrieve:'
=> 'Bitte wählen Sie eine Version aus, die Sie wiederherstellen möchten:',

   'Private - visible to author only for testing purposes'
=> 'Privat - für den Autor nur zu Testzwecken sichtbar',

#   'Private Publication - did not synchronize database'
#=> 'Private Veröffentlichung - nicht mit Datenbank synchronisiert',

   'Public - no authentication or authorization required for use'
=> 'Öffentlich - keine LON-CAPA-Anmeldung zur Nutzung notwendig',

   'Retrieval of an old version will overwrite the file currently in construction space.'
=> 'Das Wiederherstellen einer alten Version überschreibt die derzeit im Konstruktionsbereich vorhandene Datei.',

   'Retrieve selected Version'
=> 'Ausgewählte Version wiederherstellen',

   'Retrieve previous version'
=> 'Vorherige Version wiederherstellen',

   'Retrieve previous versions of [_1]'
=> 'Wiederherstellen vorheriger Versionen von [_1]',

   'Search the contents of this course'
=> '课程内容搜索',

   'Search the database of published resources and accessible portfolio files'
=> '搜索数据库资源和文件夹',

   'Send broadcast and receipt-required email'
=> 'Sende Broadcast-E-Mail mit Empfangsbestätigung',

   'Show Problem Completeness'
=> 'Zeige Aufgabenvollständigkeit',

   'Switch to another course'
=> 'Zu einem anderen Kurs wechseln',

   'System wide - can be used for any courses system wide'
=> '全系统-可用于全系统任何课程',

   'The extension on this file'
=> 'Die Endung dieser Datei',

   'Unsupported character combination [_1] in filename, FAIL.'
=> 'Ungültige Zeichenkombination [_1] im Dateinamen. Abbruch!',

   'No valid extension found in filename, FAIL'
=> 'Ungültige Dateinamen-Erweiterung. Abbruch!',

   'Filename of resource contains internal version number. Cannot publish such resources, FAIL'
=> 'Der Dateiname der Ressource enthält eine interne Versionsnummer und kann daher nicht veröffentlicht werden. Abbruch!',

   'No valid custom distribution rights file specified, FAIL'
=> 'Keine gültige Rechtedatei für spezille Nutzungsrechte angegeben. Abbruch!',

   'Could not write metadata, FAIL'
=> 'Metadaten konnten nicht geschrieben werden. Abbruch!',

   'View documents included in this course'
=> '附加的课程文件',

   'Additional Keywords'
=> '其他关键字',

   'Additional Metadata (non-standard, parameters, exports)'
=> '其他元数据 (没有标准化，参数，导出)',

   'Author and Co-Author roles may not be available on servers other than your home server.'
=> '作者和共同作者的角色可能无法使用服务器上以外的其他家庭服务器。',

   'Author(s)'
=> '作者',

   'Average number of tries till solved'
=> '平均人数，尝试成功解答的',

   'Browse Resources'
=> '浏览资源',

   'Catalog Information'
=> '目录信息',

   'Collapse Remote Control'
=> '禁用远程控制',

   'Construction Space'
=> 'Konstruktionsbereich',

   'Copied metadata'
=> '复制元数据',

   'Copied source file'
=> '复制源文件',

   'Copyright/Distribution'
=> '版权/权限',

   'Copyright/Distribution:'
=> '版权/权限：',

   'Course Documents'
=> '课程文件',

   'Creation Date'
=> '创建日期',

   'Custom Distribution File'
=> '自定义文件访问权限',

   'Degree of difficulty'
=> '难度',

   'Dump Course DOCS to Construction Space'
=> 'Kursdokumente in Konstruktionsbereich übernehmen',

   'Dump Course DOCS to Construction Space: available on other servers'
=> 'Kursdokumente in Konstruktionsbereich übernehmen: verfügbar auf anderen Servern',

   'Entering course ...'
=> '进入课程...',

   'Exam Information'
=> '考试信息',

   'External Resource'
=> '外部资源',

   'Generate new role ...'
=> '创建新的角色...',

   'Go to the next resource in the course sequence'
=> '前进',

   'Go to the previous resource in the course sequence'
=> '后退',

   'Import a published document'
=> '导入出版文件',

   'Keyword(s)'
=> '密码',

   'Logged Out'
=> '登出',

   'MIME Type'
=> 'MIME类型',

   'Make notes and annotations about this resource'
=> '备忘录',

   'The material is covered with sufficient depth'
=> '这些主题包含有足够的难度',

   'Metadata Information'
=> '元数据信息',

   'My Personal Info'
=> '我的个人网页',

   'Network-wide number of accesses (hits)'
=> '网络的访问数量（“点击”）',

   'Network-wide number of courses using resource'
=> '使用该课程资源的访问数量',

   'Number of resources that follow this resource in maps'
=> '该资源目录汇编之后的访问数量',

   'Number of resources that lead up to this resource in maps'
=> '该资源目录汇编之前的访问数量',

   'Number of resources using or importing resource'
=> '资源数量的使用或导入',

   'Obsolete'
=> '过时的',

   'Parent Directory'
=> '父目录',

   'Project Information'
=> '项目信息',

   'Publisher/Owner'
=> '出版社/所有人',

   'Publishing'
=> '出版物:',

   'Publishing [_1]'
=> '出版物: [_1]',

   'Resource Details'
=> 'Details über Ressource',

   'Link to Resource'
=> 'Link zur Ressource',

   'Searching for your resource will be based on the following metadata. Please provide as much data as possible.'
=> 'Suche nach Ihrer Ressource wird auf den folgenden Metadaten beruhen. Bitte machen Sie so viele Angaben wie möglich.',

   'Resource Publication'
=> 'Veröffentlichung von Ressourcen',

   'Resource is technically correct'
=> 'Die Ressource ist technisch in Ordnung',

   'Score Upload Form'
=> '分数上传表单',

   'Select Map'
=> '选择内容列表',

   'Load Map'
=> '上传',

   'Set a bookmark for this resource'
=> '设定书签',

   'Show all roles'
=> '显示所有角色',

   'Subject'
=> '主题',

   'Successful Login'
=> '登录成功',

   'Suggested Replacement for Obsolete File'
=> '建议更换过时文件',

   'Switching Role'
=> '更换角色',

   'Target'
=> '目标',

   'This syllabus can be publicly viewed at [_1]'
=> '此课程可公开浏览： [_1]',

   'Instead of using this template you can specify an external URL as Syllabus in the [_1]Course Parameters[_2].'
=> '如果不使用此模板，您可以在[_1]课程参数[_2]指定外部网址作为课程摘要。',

   'Total number of students who have worked on this problem'
=> '回答该问题的学生总数',

   'URLs To Include in Syllabus'
=> '网址，包括教学大纲',

   'Upload a new main course document'
=> '外部文件',

   'Upload a new supplemental course document'
=> '附加的课程文件',

   'User'
=> '用户',

   'Wrote Metadata'
=> 'Metadaten wurden geschrieben',

   'Your home server is '
=> 'Ihr Heimatserver ist ',

   'anno-'
=> 'Bemerk-',

   'announce'
=> 'ankündigen',

   'backward'
=> 'backward',

   'bookmark'
=> 'Lesezeichen',

   'chart'
=> 'Chart',

   'chat'
=> '聊天室',

   'close this window'
=> 'dieses Fenster schließen',

   'con-'
=> 'con-',

   'docs'
=> 'Dokus',

   'edit crs'
=> 'Bearbeite crs',

   'exit'
=> '退出',
#=> 'abmelden',

   'fas'
=> 'fas',

   'forward'
=> 'forward',

   'library'
=> 'Bibliothek',

   'log in again'
=> 'erneut anmelden',

   'my'
=> 'mein',

   'or'
=> 'oder',

   'Or'
=> 'oder',

   'parms'
=> 'parms',

   'prepare'
=> 'Vorbereiten',

   'printout'
=> 'Ausdruck',

   'resource'
=> 'Ressource',

   'roles'
=> '角色',
#=> 'Rollen',

   'search'
=> '查找',
#=> 'suche',

   'set'
=> 'setze',

   'space'
=> '领域',

   'stats'
=> 'Statistiken',

   'struct'
=> 'Struktur',

   'switch'
=> 'wechsle',

   'tations'
=> 'ungen',

   'updated periodically'
=> '定期更新',

   'user'
=> '用户',

   'visible to author and co-authors only'
=> '只有作者和共同作者可见',

   'All versions'
=> '所有版本',

   'Default Metadata for Directory [_1]'
=> '默认元数据目录 [_1]',

   'Error Messages'
=> '错误信息',

   'Save Catalog Information'
=> '保存目录信息',

   'Update Display'
=> '更新显示',

   'Content changed'
=> '内容变化',

   'Differences'
=> '差异',

   'Last Week'
=> '上周',

   'Modification Date'
=> '修改日期',

   'Since Start of Course'
=> '从启动课程起',

   'Since Yesterday'
=> '从昨天起',

   'Verify Course Documents'
=> '验证课程文件',

   'Version'
=> '版本',

   'access denied'
=> '拒绝访问',

   'connection down'
=> 'Verbindung unterbrochen',

   'during the last'
=> 'während der letzten',

   'not found'
=> 'nicht gefunden',

   'warning(s)'
=> 'Warnung(en)',

   '[quant,_1,warning]'
=> '[quant,_1,Warnung,Warnungen]',

   'Advanced Catalog Search'
=> 'Erweiterte Katalog-Suche',

   'Advanced Search'
=> '高级搜索',

   'Any Language'
=> '任何语言',

   'Any category'
=> '任何类别',

   'Any copyright/distribution'
=> '任何版权/访问权限',

   'Broadcast Message to Course'
=> '发送广播消息', # 'Broadcast-Nachricht an gesamten Kurs senden',

   "Click to download or use your browser's Save Link function"
=> "Zum Speichern hier klicken oder 'Ziel speichern unter'-Funktion des Webbrowsers verwenden",

   'Close'
=> '关闭',

   'Compact View'
=> '简洁视图',

   'Detailed Citation View'
=> '查看详细引文',

   'Distribute Messages from Uploaded File to Course'
=> 'Aus Datei Nachrichten erzeugen', # 'Verteile Nachrichten der hochgeladenen Datei an den Kurs',

   'Edit Catalog Information'
=> '编辑目录信息',

   'Edit Content of a Map'
=> 'Inhalt der Inhaltszusammenstellung bearbeiten',

   'Edit Directory Catalog Information'
=> '编辑目录信息分类',

   'Evaluate Resource'
=> '评估此资源',

   'Failed Access to Construction Space'
=> 'Zugriff auf Konstruktionsbereich fehlgeschlagen',

   'Fielded Format'
=> '字段格式',

   'File Category'
=> '文件分类',

   'Force publication of unmodified files'
=> 'veröffentliche auch ungeänderte Dateien',

   'Keywords'
=> '关键词',

   'Last access'
=> '上次访问',

   'Last modified'
=> '最后修改',

   'Limit by copyright/distribution'
=> '受版权/访问权限限制',

   'Limit by language'
=> '受语言限制',

   'Open'
=> '打开',

   'Per Page'
=> '每页',

   'Printing Helper'
=> '打印助手',

   'Provide feedback messages or contribute to the course discussion about this resource'
=> '反馈意见或讨论', # long version: 'Feedback geben oder an der Kursdiskussion zu dieser Ressource teilnehmen',

   'Provide my evaluation of this resource'
=> '对此资源给出我的评价', # long version: 'Diese Ressource evaluieren',

   'Publish'
=> '发布',

   'Publish Directory'
=> '发布目录',

   'Publish Directory and Sub Directories'
=> '发布目录和子目录',

   'Related'
=> '相关的',

   'Resource Feedback and Discussion'
=> '资源的反馈和讨论',

   'Search Complete'
=> '搜索完成',

   'Send Message to User(s)'
=> '发送讯息到用户', # 'Nachricht an einzelne(n) Benutzer senden',

   'Show catalog information'
=> '查看目录信息', # long version: 'Katalogisierungsdaten anzeigen',

   'Show Metadata'
=> '查看元数据', # long version: 'Metadaten anzeigen',

   'Show resource'
=> '查看资源',

   'Statistics'
=> '统计',

   'Summary View'
=> '概要',

   'There are currently no results.'
=> '目前没有任何结果。',

   'Search: '
=> '搜索： ',

   'URL'
=> 'URL',

   'Unpublished'
=> '未发行的',

   'Up'
=> 'Hoch',

   'View'
=> '查看',

   'View Critical Messages'
=> '浏览重要讯息',

   'Words'
=> '词',

   'XML/SGML'
=> 'XML/SGML',

   'abstract'
=> 'Kurzbeschreibung',

   'audio'
=> '音频',

   'author'
=> '作者',

   'catalog'
=> '目录',

   'copyright'
=> '版权',

   'customdistributionfile'
=> 'customdistributionfile',

   'directory'
=> '文件夹',

   'discuss'
=> 'Diskutiere',

   'evaluate'
=> '评价',

   'feedback'
=> '反馈',

   'keywords'
=> '关键词',

   'language'
=> '语言',

   'movies'
=> '电影',

   'notes'
=> '注释',

   'obsolete'
=> '过时的',

   'obsoletereplacement'
=> 'obsoletereplacement',

   'pages'
=> '页',

   'pictures'
=> '图片',

   'problem'
=> '任务',

   'resources'
=> '资源',

   'sequence'
=> '顺序',

   'subject: '
=> '主题',

   'this'
=> '这个',

   'title'
=> '标题',

   'About Me'
=> '关于我',

   'Bulletin Board/Discussion'
=> 'Schwarzes Brett / Diskussionsforum',

   'Clear All'
=> '全部清除',

   'Close All Folders'
=> '关闭所有文件夹',

   'Construction Space File Operation'
=> 'Dateioperation im Konstruktionsbereich',

   'Contact Information'
=> '联系信息',

   'Contact'
=> '联系我',

   'Copied old metadata'
=> '复制旧数据',

   'Failed to write old metadata copy'
=> 'Kopie der alten Metadaten konnte nicht geschrieben werden',

   'Copied old target file'
=> '复制旧的目标文件',

   'Failed to copy old target'
=> 'Alte Zieldatei konnte nicht kopiert werden.',

   'Created directory [_1]'
=> 'Verzeichnis wurde angelegt: [_1]',

   'Copyright'
=> '版权',

   'Could Not Process Request'
=> '命令无法执行',

   'Default'
=> '默认设置',

   'Discard Selected'
=> 'Verwerfe ausgewählte',

   'EMail and Messages'
=> '电子邮件和信息',

   'Edit this resource'
=> '编辑此资源', # long version: 'Bearbeite diese Ressource',

   'Enter construction space as co-author'
=> 'Konstruktionsbereich (als Co-Autor)',

   'Enter construction space as a co-author'
=> 'Konstruktionsbereich (als Co-Autor)',

   'Enter construction space as assistant co-author'
=> 'Konstruktionsbereich (als Co-Autor-Assistent)',

   'Host'
=> '计算',

   'Last updated'
=> '最后更新',

   'Mime type'
=> 'MIME 类型',

   'Modified'
=> '修改过的',

   'Modify deadlines, etc, for this assessment resource'
=> '为这项评估资源修改期限等',

   'Modify user grades for this assessment resource'
=> '手动评估', # 'Bearbeite die Noten des Benutzers für diese Beurteilungs-Ressource',

   'View user submissions for this assessment resource'
=> 'Einreichungen betrachten', # 'Betrachte Benutzer-Einreichungen für diese Beurteilungs-Ressource',

   'Move Down'
=> '下移',

   'Move Up'
=> '上移',

   'New Title'
=> '新标题',

   'Open All Folders'
=> '打开所有文件夹',

   'Owner/Publisher'
=> '所有者/出版社',

   'Personal Information Page'
=> '个人资料页面',

   'Personal Information'
=> '个人信息',

   'Privacy Note:'
=> '注意隐私:',

   'Published'
=> '出版的',

   'Reading results from'
=> 'Lese Ergebnisse von',

   'Retrieve'
=> '恢复',

   'Revert to Last Saved'
=> 'Gehe zur letzten gespeicherten Version',

   'Revision Date'
=> 'Änderungsdatum',

   'Shared by course faculty and staff'
=> '共同管理人员和工作人员',

   'Synchronized SQL metadata database'
=> 'SQL Metadaten-Datenbank synchronisiert',

   'Task'
=> 'Aufgabe',

   'Temporary Assembly Workspace'
=> 'Temporärer Arbeitsbereich',

   'The information you submit can be viewed by anybody who is logged into LON-CAPA. Do not provide information that you are not ready to share publicly.'
=> '任何登录LON-CAPA的人都能看到您提供的数据，如果不想公开就不要上传任何数据。',

   'Topic'
=> '主题',

   'Upload a Photo'
=> '上传相片',

   'Add Records'
=> '添加记录',

   'User Notes, Face-to-Face, Critical Messages, Broadcast Messages, Archived Messages'
=> '用户注释， 个人讨论， 重要信息， 小区广播，存档信息',

   'User Notes, Records of Face-to-Face Discussions, and Critical Messages'
=> '用户注释，记录用户的讨论和重要信息',

   'User Notes, Records of Face-To-Face Discussions, and Critical Messages in Course'
=> '用户注释，记录面对面的讨论，课程重要讯息',

   'User Notes, Records of Face-To-Face Discussions, Critical Messages, Broadcast Messages and Archived Messages in Course'
=> '用户注释，记录面对面讨论，重要的信息，广播信息，课程存档',

   'No notes, face-to-face discussion records, critical messages, or broadcast messages in this [_1].'
=> '对于 [_1] 没有用户注释, 记录用户的讨论, 重要信息, 或者广播信息。',

   'Version Number'
=> '版本号',

   'View Published Version'
=> '查看发布的版本',

   'Web References'
=> 'Web 引用',

   'co con-'
=> 'Co-Kon-',

   'co res'
=> 'co-res',

   'contacting'
=> '建立联系',

   'edit'
=> '编辑',

   'interface available'
=> 'Oberflächensprache verfügbar',

   'missions'
=> '任务',

   'view sub-'
=> 'Betrachte Unter-',

   'waiting on'
=> 'warte auf',

   '#Stdnts'
=> 'Anzahl Stud.',

   '#YES'
=> 'Anzahl Ja',

   '%Wrng'
=> '%Wrng',

   'Brief view of each students performance in course.'
=> 'Kurze Übersicht der Leistungen eines jeden Studenten im Kurs.',

   'Clear Caches'
=> '清除缓存',

   'Course Statistics and Charts cannot be retrieved until the database is restarted.  Your data is intact but cannot be displayed at this time.'
=> 'Kurs-Statistiken und -Diagramme können solange nicht empfangen werden, bis die Datenbank neu gestartet wurde. Ihre Daten sind vorhanden, können aber zu diesem Zeitpunkt nicht angezeigt werden.',

   'Detailed statistics and graphs of student performance on problems.'
=> 'Ausführliche Statistiken und Graphen der studentischen Leistung hinsichtlich der Aufgaben',

   'DoDiff'
=> 'Verwende diff',

   'Enrollment Status'
=> 'Kursbelegungs-Status',

   'Generate Statistics'
=> '建立统计资料',

   'Max Tries'
=> 'Max. Anz. an Vers.',

   'Mean Tries'
=> 'Mittl. Anz. Vers.',

   'Output'
=> 'Ausgabe',

   'Overall Problem Statistics'
=> 'Insgesamte Aufgabenstatistik',

   'Please notify the server administrator [_1]'
=> 'Benachrichtigen Sie bitte den Server-Administrator [_1]',

   'Please select a report to generate.'
=> 'Wählen Sie bitte einen Bericht, den Sie erstellen möchten.',

   'Preparing Excel Spreadsheet'
=> 'Erstelle Excel-Tabelle',

   'Problem Status Chart'
=> 'Aufgabenstatus-Diagramm',

   'Problems creating new Excel file.  This error has been logged.  Please alert your LON-CAPA administrator.'
=> 'Es traten Probleme beim Erstellen der neuen Excel-Datei auf. Dieser Fehler wurde mitgeloggt. Bitte benachrichtigen Sie Ihren LON-CAPA-Administrator.',

   'S.D. tries'
=> 'S.D. Versuche',

   'Sections'
=> 'Sektionen',

   'Sequence or Folder'
=> 'Sequenz oder Verzeichnis',

   'Sequences and Folders'
=> 'Sequenzen und Verzeichnisse',

   'Skew Tries'
=> 'Schiefe d. Vers.',

   'Statistics and Problem Analysis'
=> 'Statistiken und Aufgabenanalysen',

   'Student performance statistics on all problems.'
=> 'Statistik studentischer Leistungen hinsichtlich aller Aufgaben',

   'Unable to connect to database!'
=> 'Verbindungsaufbau zur Datenbank nicht möglich!',

   'Your Excel Spreadsheet'
=> 'Ihre Excel-Tabelle',

   'Your Excel spreadsheet.'
=> 'Ihre Exceldatei',

   'Your Excel spreadsheet'
=> 'Ihre Exceldatei',

   'Your CSV file.'
=> 'Ihre CSV-Datei',

   'Your CSV file'
=> 'Ihre CSV-Datei',

   'part'
=> '部分',

   'part - '
=> '部分 ',

   'problem statistics grouped by sequence'
=> 'Aufgabenstatistiken, gruppiert nach Sequenz',

   'problem statistics ungrouped'
=> 'Aufgabenstatistiken, nicht gruppiert',

   'problem statistics, Excel'
=> 'Aufgabenstatistiken, Excel',

   'Significant figures are incorrect, submission was not graded.'
=> 'Die Anzahl der signifikanten Stellen ist inkorrekt. Dieser Versuch wurde nicht gezählt.',

   '. . . for a particular section'
=> '. . . für eine bestimmte Sektion',

   '. . . for all students in the course'
=> '. . . für alle Studenten im Kurs',

   '. . . for an individual student'
=> '. . . für einen bestimmten Studenten',

   '1 am'
=> '1',

   '1 pm'
=> '13',

   '10 am'
=> '10',

   '10 pm'
=> '22',

   '11 am'
=> '11',

   '11 pm'
=> '23',

   '12 am'
=> '00',

   '12 noon'
=> '12',

   '2 am'
=> '2',

   '2 pm'
=> '14',

   '3 am'
=> '3',

   '3 pm'
=> '15',

   '4 am'
=> '4',

   '4 pm'
=> '16',

   '5 am'
=> '5',

   '5 pm'
=> '17',

   '6 am'
=> '6',

   '6 pm'
=> '18',

   '7 am'
=> '7',

   '7 pm'
=> '19',

   '8 am'
=> '8',

   '8 pm'
=> '20',

   '9 am'
=> '9',

   '9 pm'
=> '21',

   '<- Previous'
=> '<- Zurück',

   'ALL'
=> 'ALLE',

   'All Maps or Folders'
=> 'Alle Inhaltszusammenstellungen oder Verzeichnisse',

   'Any User'
=> '任何用户',

   'Assessment URL and Title'
=> '评估网址和标题',

   'Assigned User Roles'
=> '用户角色分配',

   'Browse resources'
=> '搜索资源',

   'Changes can take up to 10 minutes before being active for all students.'
=> 'Es kann bis zu 10 Minuten dauern, bis diese Änderungen für alle Studierenden aktiviert worden sind.',

   'Course Assessment Parameter - Helper Mode'
=> '课程评估参数 - 助手模式',

   'Course Assessment Parameters - Overview Mode'
=> '课程评估参数 - 摘要模式',

   'Course Assessments Parameters - Table Mode'
=> '课程评估参数 - 表模式',

   'Course Environment Parameters'
=> '课程环境参数',

   'Course Parameter Helper'
=> '课程参数实用工具',

   'Create New Environment Variable'
=> '创造新的环境变量',

   'Current Session Value'
=> '当前会话的值',

   'Default Value'
=> '缺省值',

   'Delete a role'
=> '删除角色',

   'Disable all communication among students'
=> 'Unterbinden jeglicher Kommunikation zwischen Studenten',

   'Enclosing Map or Folder'
=> '附有目录或文件夹',

   'Every problem in a particular folder'
=> '每一个问题在一个特定的文件夹',

   'Every problem in the course'
=> '课程的中每一个问题',

   'Folder'
=> '文件夹',

   'Grant/revoke Course Custom Role'
=> 'Vergebe/entziehe benutzerdefinierte Kursrolle',

   'Grant/revoke role of Administrator'
=> 'Vergebe/entziehe Rolle des Administrators',

   'Grant/revoke role of Author'
=> 'Vergebe/entziehe Rolle des Autors',

   'Grant/revoke role of Course Coordinator'
=> 'Vergebe/entziehe Rolle des Kurs-Koordinators',

   'Grant/revoke role of Domain Guest'
=> 'Vergebe/entziehe Rolle des Domänengasts',

   'Grant/revoke role of Librarian'
=> 'Vergebe/entziehe Rolle des Bibliothekars',

   'Grant/revoke role of Teaching Assistant'
=> 'Vergebe/entziehe Rolle des Tutors',

   'Internally authenticated'
=> 'Intern authentifiziert',

   'Kerberos authenticated'
=> 'Kerberos-authentifiziert',

   'LON-CAPA Helper:'
=> 'LON-CAPA-Hilfsprogramm:',

   'Lock and unlock assessments'
=> 'Sperren und Entsperren von Beurteilungen',

   'Manage Access Keys'
=> 'Zugriffsschlüssel verwalten',

   'Manage access keys'
=> 'Zugriffsschlüssel verwalten',

   'Max Possible To Date'
=> '到现在为止，最高可达到',

   'Modify Course Assessment Parameters'
=> 'Bearbeite Parameter für die Kursbeurteilung',

   'Modify authentication mechanism and data for a user'
=> 'Bearbeite Authentifizierungs-Methode und Daten für einen Benutzer',

   'Modify grades'
=> 'Bewertungen ändern',

   'Next ->'
=> '下一步 ->',

   'One particular problem'
=> 'Eine bestimmte Aufgabe',

   'Parameter Name'
=> '参数名',

   'Parameter Type'
=> '参数类型',

   'Parameter in Effect'
=> '有效参数',

   'Please select a problem to analyze'
=> '请选择问题进行分析',

   'Post anonymously'
=> '匿名发送',

   'Post discussion on course resources'
=> '发送该课程资源的讨论',

   'Post system frontpage announcements'
=> '给系统主页发送通知',

   'Post to live chatrooms'
=> '发送到在线聊天室',

   'Post to chatrooms'
=> '发送到聊天室',

   'Problems Not Contained In A Folder'
=> '问题不包含在一个文件夹中',

   'Section'
=> '章节',

   'Section:'
=> '章节:',

   'Select Date'
=> '请选择日期',

   'Select Enclosing Map or Folder'
=> 'Eingeschlossene(s) Inhaltszusammenstellung oder Verzeichnis',

   'Select Parameter Level'
=> 'Parameter-Ebene',

   'Send internal email'
=> '发送内部电子邮件',

   'Set Course Environment Parameters'
=> 'Setze Kursumgebungs-Parameter',

   'Set Date'
=> '设定日期',

   'Set Defaults for All Resources in [_1]Specifically for [_2][_3]'
=> 'Setze voreingestellte Werte für alle Ressourcen im [_1]speziell für [_2][_3]',

   'Set a due date'
=> '设定一个截止日期',

   'Set an answer open date'
=> 'Setze Antwort-Verfügbarkeits-Datum',

   'Set an open date'
=> 'Setze eine Bearbeitungsbeginn-Datum',

   'Set opening datefor all problems in the course for. . .'
=> 'Setze Öffnungsdatum für alle Aufgaben im Kurs auf. . .',

   'Set the number of tries'
=> '设置尝试次数',

   'Set the problem weight'
=> '设置问题难度',

   'Set/Modify Course Assessment Parameter'
=> '设置/修改课程评估参数',

   'Set/Modify Course Assessment Parameters'
=> '设置/修改课程评估参数',

   'Set/Modify Course Parameters'
=> '设置/修改课程参数',

   'Show More Options'
=> '显示更多选项',

   'Students Affected'
=> '受影响的学生',

   'This helper will assist you in setting the open, due, and answer dates for problems, or in setting the number of tries for problems. You will be asked to select which problems you wish to set the parameters for, then what parameter you wish to set, then you will select whom the setting affects. After the helper is done, you will be shown where in the advanced interface you would have gone to set the parameter you have chosen, so in the future you can do it directly. Press Next -&gt; to begin, or select &lt;- Previous to go back to the previous screen.'
=> 'Dieses Hilfsprogramm wird Ihnen dabei helfen, das Datum für den Bearbeitungsbeginn, die Fälligkeit und die Antwort-Verfügbarkeit für Aufgaben zu setzen und die Anzahl der Versuche für Aufgaben festzulegen. Sie werden gefragt, für welche Aufgaben Sie die Parameter zu setzen wünschen, dann, welche Parameter Sie setzen möchten. Schließlich wählen Sie aus, wen diese Einstellungen betreffen. Nach Abschluss dieser Hilfeunterstützung wird Ihnen gezeigt, wo Sie in dem erweiterten Interface die Parameter setzen können, die Sie ausgewählt haben, damit Sie dies in Zukunft direkt erledigen können. Klicken Sie auf Weiter -&gt; um zu beginnen oder wählen Sie &lt;- Zurück, um zur vorherigen Seite zurückzukehren.',

   'Total'
=> '总共',

   'Total Parts In Course'
=> 'Gesamtanzahl an Aufgabenteilen in dem Kurs',

   'Type'
=> '型号',

   'UNIX authenticated'
=> 'UNIX 认证',

   'USERS'
=> '用户',

   'Unknown ID'
=> '未知 ID',

   'Unknown user'
=> '未知用户',

   'Update Course Assessment Parameter Display'
=> 'Aktualisiere die Anzeige der Parameter zur Kursbeurteilung',

   'Update Section or Specific User'
=> 'Aktualisiere Sektion oder bestimmten Benutzer',

   'Verify Selection'
=> '确认选择',

   'Welcome to the Assignment Parameter Helper'
=> 'Willkommen zum Hilfsprogramm für Übungs-Parameter',

   'What parameter do you want to set for all problems in the course?'
=> 'Welche Parameter möchten Sie für alle Aufgaben in dem Kurs setzen?',

   'What should the opening date be set to?'
=> 'Auf wann soll das Öffnungsdatum gesetzt werden?',

   'Which Problem or Problems?'
=> 'Welche Aufgabe oder Aufgaben?',

   'Which problems do you wish to set a parameter for?'
=> 'Für welche Aufgaben möchten Sie die Parameter setzen?',

   'You need to choose another user role or enter a specific course for this function'
=> '对于此功能您需要选择另一个用户角色，或者输入特定的课程。',

   'a.m.'
=> '上午',

   'acc keys'
=> 'Zugr.-Schlüssel',

   'according to course preferences'
=> '根据课程设置',

   'according to resource settings'
=> '根据资源设置',

   'according to user session state'
=> '根据用户会话状态',

   'all'
=> '所有的',

   'at'
=> '在',

   'at Domain'
=> '在域',

   'at domain'
=> '在域',

   'default'
=> '默认',

   'for Enclosing Map or Folder'
=> '对于附有目录或文件夹', #??? [SB 18.10.2006]

   'for Resource'
=> '资源',

   'from Enclosing Map or Folder'
=> '从附有目录或文件夹', #??? [SB 18.10.2006]

   'general'
=> '一般的',

   'in Course'
=> '在课程',

   'in Section/Group'
=> '在科/组',

   'manage'
=> '管理',

   'midnight'
=> '午夜',

   'noon'
=> '中午',

   'num_override'
=> 'num_override',

   'of'
=> 'von',

   'or ID'
=> '或者 ID',

   'p.m.'
=> '下午',

   'percent'
=> '百分比',

   'unless locked'
=> '除非锁定',

   'users in'
=> 'Benutzer in',

   'Access Key Management'
=> 'Zugriffsschlüssel-Verwaltung',

   'Assessment'
=> '评价',

   'Calculations'
=> 'Berechnungen',

   'Comma Separated Values'
=> 'CSV (kommaseparierte Liste)',

   'Course ID'
=> '课程 ID',

   'Course level sheet'
=> 'Kurs-Level-Bogen', # ??? [SB 2007-07-02]

   'Detailed Problem Analysis'
=> 'Detaillierte Aufgabenanalyse',

   'End Helper'
=> 'Hilfsprogramm beenden',

   'Excel'
=> 'Excel',

   'Text (essays only)'
=> 'Text (nur bei Essays)',

   'Finish Course Initialization'
=> 'Beende Kursinitialisierung',

   'Generate Spreadsheet'
=> '生成报告表',

   'Grant/revoke role of Scantron Operator'
=> 'Vergebe/entziehe Rolle des Scantron-Operators',

   'HTML'
=> 'HTML',

   'Invalid date entry'
=> 'Ungültiger Datumseintrag',

   'Load:'
=> '加载:',

   'No changes were made to the current settings.'
=> 'An den derzeitigen Einstellungen wurden keine Veränderungen vorgenommen.',

   'Output Format'
=> '输出格式',

   'Processing course structure'
=> 'Kursstruktur verarbeiten',

   'Processing first student'
=> 'Für ersten Studierenden berechnen',

   'Row'
=> '排列',

   'Save as'
=> '另存为',

   'Save as &amp; Make This Sheet the Default'
=> '另存为 ＆ 使此工作表作为一个默认使用',

   'Scantron Operator'
=> 'Scantron-Operator',

   'Select All'
=> '全选',

   'Select All Students'
=> '选择所有学生',

   'Select Spreadsheet File'
=> '选择电子表格文件',

   'Send Scantron data to a course'
=> 'Scantron-Daten an einen Kurs senden',

   'Spreadsheet Computation'
=> 'Beurteilungsbogen berechnen',

   'Spreadsheet Computation Status'
=> 'Status der Beurteilungsbogen-Berechnungen',

   'Student level sheet'
=> 'Studierdenden-Level-Bogen',

   'Summary'
=> 'Zusammenfassung',

   'Template'
=> 'Vorlage',

   'Unselect All'
=> 'Auswahl komplett aufheben', # 'Alle deselektieren',

   'Unselect All Students'
=> 'Alle Studenten deselektieren',

   'Upload Scantron data'
=> 'Scantron-Daten hochladen',

   'You must choose at least one student to continue.'
=> 'Zum Fortfahren müssen Sie mindestens einen Studierenden auswählen.',

   'You must choose one or more choices to continue.'
=> 'Zum Fortfahren müssen Sie mindestens eine oder mehrere Auswahlen treffen.',

   'last student'
=> 'letzten Studierenden',

   'may be open from a different computer.'
=> 'könnte von einem anderen Computer aus geöffnet sein.',

   'minutes'
=> 'Minuten',

   'remaining'
=> 'übrig',

   'second'
=> 'Sekunde',

   'seconds'
=> 'Sekunden',

   'seconds for'
=> 'Sekunden für',

   'Additional Recipients'
=> '其他收件人',

   'Analyze Over [_1] [_2]'
=> 'Analysieren: [_1] [_2]',

   'Analyze Problem'
=> 'Analysiere Aufgabe',

   'Analyze Problem Again'
=> 'Aufgabe erneut analysieren',

   'Analyze as '
=> 'Analysiere als ',

   'Browsing resource, all submissions are temporary.'
=> 'Eingereichte Antworten werden nicht gespeichert.',

   'By'
=> 'Von',

   'Check All'
=> '全选',

   'Check for All'
=> '检查所有',

   'Check for None'
=> '检查无',

   'Check for Section/Group'
=> '检查科/组',

   'Choose a different resource'
=> '选择不同的资源',

   'Concepts'
=> '草稿',

   'Critical Messages'
=> '重要讯息',

   'Delete'
=> '删除',

   'Delete Checked'
=> '删除选中',

   'Display All Messages'
=> '显示所有邮件',

   'Display all Messages'
=> '显示所有邮件',

   'Foils'
=> '选择',

   'Forward'
=> '转发',

   'Forwarded message from'
=> '转发邮件从',

   'Forwarding'
=> '转发',

   'From'
=> '从',

   'Functions'
=> '功能',

   'Mail'
=> '邮件',

   'Mark Unread'
=> '标记为未读',

   'New Problem Variation'
=> 'Neue Aufgabenvariation',

   'New Randomization'
=> '新的变化',

   'Next'
=> '下一步',

   'Number of Plots [_1]'
=> 'Anzahl an Graphen [_1]',

   'Option Response Problem Analysis'
=> 'Analyse von option response-Aufgabe',

   'Previous'
=> '以前的',

   'Re'
=> '回复',

   'Record'
=> '记录',

   'Reply'
=> '回复',

   'Reset Submissions'
=> 'Einreichungen zurücksetzen',

   'Select a course'
=> '选择课程',

   'Selecting a User'
=> '选择用户',

   'Send New'
=> 'Sende neue',

   'Send Reply'
=> '发送回复',

   'Send as critical message'
=> '发出一个重要信息',

   'Simple Problem Editor'
=> '简单的问题编辑器',

   'Starting'
=> '开始',

   'Student Data Compilation Progress'
=> '学生资料汇编进展',

   'Student Data Compilation Status'
=> '学生资料汇编状态',

   'There is no student data for this problem.'
=> '对于这个问题，没有任何学生的数据。',

   'Time'
=> '时间',

   'To:'
=> '收件人：',

   'Uncheck All'
=> '全部取消',

   'Unsuccessful Login'
=> '登录失败',

   'Update Student Data'
=> '更新学生资料',

   'You have no critical messages.'
=> '您没有任何重要讯息。',

   'and return receipt'
=> 'mit Empfangsbestätigung',

   'can not be accessed from your location.'
=> 'kann von Ihrer Position aus nicht aufgerufen werden.',

   '[_1]: Unacceptable username for user [_2] [_3] [_4] [_5]'
=> '[_1]: Unzulässige Benutzerkennung für den Benutzer [_2] [_3] [_4] [_5]',

   'All Documents in Course'
=> 'Alle Ressourcen im Kurs',

   'All Resources (possibly large output)'
=> 'Alle Ressourcen (möglicherweise lange Ausgabe)',

   'Anonymous'
=> '匿名',

   'Anonymous contribution to course discussion of resource'
=> '匿名参加这个资源的讨论',

   'As a general rule, only authors or co-authors should be filesystem authenticated (which allows access to the server filesystem).'
=> 'Generell sollten nur Autoren und Co-Autoren über das Dateisystem authentifiziert sein (erlaubt Zugriff auf das Server-Dateisystem).',

   'Associate columns with student attributes.'
=> 'Verknüpfung der Spalten aus der Datei mit den studentischen Eigenschaftsfeldern',

   'Attribute'
=> 'Eigenschaft',

   'CSV (comma separated values, spreadsheet)'
=> 'CSV (逗号分隔值, 表格)',

   'Check Course Document Versions'
=> 'Überprüfe Versionen der Kursdokumente',

   'Check/Set Resource Versions'
=> '检查/设置源版本',

   'Chronological View'
=> '顺序查看',

   'Column'
=> 'Spalte',

   'Column [_1]'
=> 'Spalte [_1]',

   'Continue enrollment?'
=> 'Trotzdem mit der Kursbelegung fortfahren?',

   'Contribution to course discussion of resource'
=> '正常参加这个资源的讨论',

   'Diffs'
=> '区别',

#   'Disable ID/Student Number Safeguard and Force Change of Conflicting IDs (only do if you know what you are doing)'
#=> 'Deaktiviere ID-/Matrikelnummer-Safeguard und erzwinge Änderung von in Konflikt stehenden IDs (Machen Sie dies nur, wenn Sie wirklich wissen, was Sie tun).',


   'Disable Student/Employee ID Safeguard and force change of conflicting IDs'
=> '禁用学生/员工编号，维护和强制改变不一致的IDs',

   '(only do if you know what you are doing.)'
=> '(只有这样做，如果你知道自己在做什么。)',

   'Discussion Contributions'
=> '参加讨论',

   'Drop Students'
=> '从该课程删除学生',

   'Dropped [_1]'
=> '[_1] ausgeschlossen',

   'Dropped [_1] student(s).'
=> '[_1] Student(en) ausgeschlossen.',

   'Dropping Students'
=> 'Schließe Studenten aus',

   'Dump Course DOCS'
=> 'Kursdokumente übernehmen',

   'EMail Address'
=> 'E-Mail 地址',

   'Enroll a single student'
=> '注册一个学生',

   'Enrolling Students'
=> '注册学生',

   'Error'
=> 'Fehler',

   'Error: '
=> 'Fehler: ',

   'Error: [_1]'
=> 'Fehler: [_1]',

   'Field'
=> 'Feld',

   'Filenames in Construction Space'
=> 'Dateinamen im Konstruktionsbereich',

   'First Name'
=> '名',

   'Folder in Construction Space'
=> 'Verzeichnis im Konstruktionsbereich',

   'Full Update'
=> '全面更新',

   'Full update (also print list of users not enrolled anymore)'
=> '全面更新 (auch Liste von Benutzern ausgeben, die den Kurs nicht mehr belegt haben)',

   'Generation'
=> '生成',

   'Group/Section'
=> '组/科',

   'HTML/XML'
=> 'HTML/XML',

   'Hide'
=> '隐藏',

   'Student/Employee ID'
=> '学生/员工 ID',

   'Identify fields'
=> 'Identifiziere Felder',

   'If active, the new role will be available when the students next log in to LON-CAPA.'
=> 'Falls aktiv, dann wird die neue Rolle verfügbar sein, wenn sich die Studenten das nächste Mal in LON-CAPA anmelden.',

   'Ignore First Line'
=> '忽略第一行',

   'Initial Password'
=> '初始密码',

   'Internal Filename'
=> '内部文件名',

   'Invalid home server specified'
=> 'Ungültiger Heimatserver angegeben',

   'Keep all Resources up-to-date with most recent Versions (default)'
=> 'Alle Ressourcen immer mit den neuesten Versionen aktuell halten (voreingestellt)',

   'LON-CAPA Domain for Students'
=> 'LON-CAPA-Domäne für Studierende',

   'LON-CAPA Enrollment Manager'
=> 'LON-CAPA-Kursbelegungs-Verwaltung',

   'LON-CAPA domain: [_1]'
=> 'LON-CAPA 域： [_1]',

   'Last Name'
=> '姓',

   'Last Name, First Names'
=> '姓，名',

   'Login Type'
=> '登录类型',

   'Middle Names/Initials'
=> '中名/缩写',

   'Modify Parameters'
=> '修改参数',

   'Modify student data'
=> '修改学生资料',

   'Most recently published Version'
=> '最近发布的版本',

   'No Kerberos domain was specified.'
=> 'Es wurde keine Kerberos-Domäne angegeben.',

   'None Found'
=> '没有找到',

   'Note: For large courses, this operation may be time consuming.'
=> 'Beachten Sie, dass die Ausführung für große Kurse lange dauern könnte.',

   'This will not take effect if the user already exists.'
=> 'Diese Einstellung bleibt ohne Wirkung, falls der Benutzer bereits existiert.',

   'Processed [_1] student(s).'
=> '[_1] Studierende bearbeitet.',

   'Re-enrollment will re-activate data.'
=> 'Eine erneute Kursbelegung würde die Daten reaktivieren.',

   'Registering'
=> 'Registriere',

   'Samples'
=> '例如',

   'Save as ...'
=> '另存为...',

   'Set Version to be used in Course'
=> 'Setze Version als die im Kurs genutzte',

   'Set Versions to be used in Course according to Selections below'
=> 'Versionen gemäß der unten getroffenen Auswahlen einstellen',

   'Set all Resource Versions to current Version (Fix Versions)'
=> 'Alle Ressourcen auf die derzeitige Version festsetzen',

   'Show Preview'
=> 'Zeige Vorschau',

   'Space separated'
=> '以空格分隔',

   'Starting and Ending Dates'
=> '起始和结束日期',

   'Student Number'
=> '学生证号码',

   'Tabulator separated'
=> '以制表符分隔',

   'The optional email address field was not specified.'
=> 'Das optionale E-Mail-Adress-Feld wurde nicht ausgefüllt.',

   'The optional name field was not specified.'
=> 'Das optionale Namensfeld wurde nicht ausgefüllt.',

   'The optional ID number field was not specified.'
=> 'Das optionale Matrikelnummer-Feld wurde nicht ausgefüllt.',

   'The optional section or group field was not specified.'
=> 'Das optionale Sektions- oder Gruppenfeld wurde nicht ausgefüllt.',

   'The optional student number field was not specified.'
=> 'Das optionale Matrikelnummer-Feld wurde nicht ausgefüllt.',

   'The optional section field was not specified.'
=> 'Das optionale Sektionsfeld wurde nicht ausgefüllt.',

   'The optional role field was not specified.'
=> 'Das optionale Rollenfeld wurde nicht ausgefüllt.',

   'The optional domain field was not specified.'
=> 'Das optionale Domänenfeld wurde nicht ausgefüllt.',

   'There are no students currently enrolled.'
=> 'Derzeit haben keine Studierenden den Kurs belegt.',

   'Continue adding users?'
=> 'Mit dem Hinzufügen von Benutzern fortfahren?',

   'Threaded View'
=> '线程查看',

   'Total number of records found in file: [_1]'
=> 'Gesamtanzahl an Datensätzen, die in der Datei gefunden wurden: [_1]',

   'Unable to enroll students'
=> 'Konnte Studenten nicht eintragen.',

   'Updating discussion time'
=> 'Aktualisiere Diskussionszeit',

   'Uploading Class List'
=> 'Lade Kursteilnehmerliste hoch',

   'Verify Content'
=> '检查内容',

   'Version used in Course'
=> 'Version, die im Kurs verwendet wird',

   'View Class List'
=> 'Zeige Kursteilnehmerliste',

   'View Class list'
=> 'Kursteilnehmerliste anzeigen',

   'Welcome'
=> '欢迎',

   'Welcome to the Learning<i>Online</i> Network with CAPA. Please wait while your session is being set up.'
=> '欢迎您到在线网络 LON-CAPA 学习。请稍候，您的会话正在建立。',

   'You must choose an authentication type.'
=> '你必须选择一个身份验证类型。',

   'You need to specify the Kerberos domain.'
=> 'Sie müssen eine Kerberos-Domäne auswählen.',

   'You need to specify the initial password.'
=> 'Sie müssen ein initiales Passwort auswählen.',

   'You need to specify the username field.'
=> 'Sie müssen das Benutzerkennung-Feld ausfüllen.',

   'Your Version Settings have been Saved'
=> 'Ihre Versionseinstellungen wurden gespeichert',

   '[_1] Do not change login data'
=> '[_1] 不要更改登录数据',

   '[_1] Kerberos authenticated with domain [_2] [_3] Version 4 [_4] Version 5 [_5]'
=> '[_1] Kerberos身份验证域 [_2] [_3] 版本 4 [_4] 版本 5 [_5]',

   'Currently Kerberos authenticated with domain [_1] Version [_2].'
=> '目前的Kerberos身份验证域 [_1] 版本 [_2]。',

   'Currently Kerberos authenticated, Version [_1].'
=> '目前Kerberos身份验证，版本 [_1]。',

   'most recent'
=> '最新的',

   'name only visible to course faculty'
=> '只有课程管理者能看见',

   'Calculate answers'
=> '计算的答案',

  'Show All Foils'
=> '显示全部选项',

   'Show All Instances'
=> '显示全部选项',

   '1 out of N multiple choice (radio button)'
=> '单选',

   'Add new option'
=> '添加新的选择',

   'Administrator'
=> '管理员',

   'Answer:'
=> '回复:',

   'Attachment'
=> '附件',

   '(128 KB max size)'
=> '(最大 128 KB)',

   'Change'
=> '改变',

   'Change Random Seed To:'
=> '随机数的基础上：',

   'Change Your Language Preferences'
=> '变更您的语言偏好',

   'Concept:'
=> '概念：',

   'Correct Option:'
=> '正确的选择:',

   'Create a New Course'
=> '创建一个新的课程',

   'Create a New Course or Group Space'
=> '创建一个新的课程或组空间',

   'Current'
=> '现在的',

   'Delete an option'
=> '删除一个选项',

   'Delete:'
=> '删除:',

   'Diffs with Current Version'
=> '与当前版本的区别',

   'Diffs with Version'
=> '不同版本之间的区别',

   'Diffs with current Version'
=> '与当前版本的区别',

   'Display and analysis of submission times on assessments.'
=> 'Anzeige und Analyse der Einreichungszeiten in Beurteilungen',

   'Display foils in order given'
=> '在给定的分类里显示选项',

   'Display foils in random order'
=> '在一个随机序列里显示选项',

   'Domain Guest'
=> '网上邻居',

   'Essay, open end'
=> '尝试，没有时间限制',

   'False'
=> '错误的',

   'Foil'
=> '选项',

   'Format:'
=> '格式:',

   'Height(pixel):'
=> '高 (Pixel):',

   'Hint Text'
=> '提示文字',

   'If this resource is in active use, student performance data from the previous version may become inaccessible.'
=> 'Wenn diese Ressource in Benutzung ist, ist es möglich, dass auf Leistungsdaten der Studenten von vorhergehenden Versionen nicht mehr zugegriffen werden kann.',

   'Image:'
=> '图片:',

   'Incorrect Answers:'
=> '错误的答案:',

   'Last accessed'
=> '上次访问',

   'Librarian'
=> 'Bibliothekar',

   'Making Backup to [_1]'
=> 'Erstelle Sicherungsdatei in [_1]',

   'Max Number Of Shown Foils:'
=> '显示选项的最大数量：',

   'Max number of foils displayed'
=> '显示选项的最大数量',

   'Metadata'
=> '元数据',

   'metadata'
=> '元数据',

   'Metadata Version'
=> '元数据版本',

   'Metadata current version'
=> '元数据的最新版本',

   'Save Metadata'
=> '保存元数据',

   'Name:'
=> '姓氏:',

   'New parameters or saved values'
=> '新的参数或保存价值',

   'No language preference'
=> '没有语言偏好',

   'Not shown, not used'
=> '没有显示，没有使用',

   'Obsolete parameters or saved values'
=> '过时的参数或保存价值',

   'Option response'
=> '答案选项',

   'Please do not reply to this address.'
=> 'Bitte antworten Sie nicht an die Absender-E-Mail-Adresse.',

   'Please select a report to generate'
=> 'Bitte wählen Sie einen Bericht zum Erstellen aus',

   'Position'
=> 'Position',

   'Preferred language'
=> '首选语言',

   'Problems'
=> 'Probleme',

   'Produce Excel Output'
=> 'Erstelle Excel-Ausgabe',

   'Question Text'
=> '文字问题',

   'Random position'
=> '随机位置',

   'Retrieve Published Resources'
=> '恢复发布的资源',

   'Short string response'
=> '简短的文字回答',

   'Show always at bottom position'
=> '总是在最后显示',

   'Show always at top position'
=> '总是在最开始显示',

   'Size:'
=> '大小：',

   'Save Changes'
=> '保存更改',

   'Submission Time Analysis'
=> '提交时间分析',

   'Submit Changes and Edit'
=> '保存并继续编辑',

   'TeXWidth(mm):'
=> 'TeX-宽 (mm):',

   'Text'
=> '文本',

   'Text Block'
=> '文本块',

   'This is an automatic message generated by the LON-CAPA system.'
=> 'Dies ist eine durch LON-CAPA automatisch erstellte Nachricht.',

   'True'
=> '正确的',

   'unused'
=> '未用过的',

   'Type-in value'
=> 'eingebbarer Wert',

   'Unit:'
=> '单位：',

   'Value'
=> '值',

   'Warning!'
=> '警告！',

   'Width(pixel):'
=> '宽 (Pixel):',

   'anonymous'
=> '匿名',

   'bytes'
=> 'Bytes',

   'loginproblems.html'
=> 'loginproblems.html',

   'versions of this problem'
=> '这个问题的版本',


#=====================
# Begin remote control (mydesk.tab)
# 2x8 chars, only lower case
# Same order as in mydesk.tab!
   'choose[_1]'
=> '选择',
   'course[_1]'
=> '课程',

   'switch[_1]'
=> '转换',
   'course[_2]'
=> '课程',

   'switch[_2]'
=> '转换',
   'role[_1]'
=> '角色',

   'choose[_2]'
=> '选择',
   'role[_2]'
=> '角色',

   'course[_3]'
=> '课程',
   'docs[_1]'
=> '内容',

   'edit crs[_1]'
=> '编辑',
   'docs[_2]'
=> '课程文档',

   'navigate[_1]'
=> '课程',
   'contents[_1]'
=> '目录',

   'request-[_1]'
=> 'Kurs',
   'course[_16]'
=> 'anfordern',

   'my[_1]'
=> '我的',
   'grades[_1]'
=> '得分',

   'course[_4]'
=> '课程',
   'grades[_2]'
=> '等级',

   'course[_5]'
=> 'kurs-',
   'chart[_1]'
=> 'fortschr',

   'course[_6]'
=> '课程',
   'stats[_1]'
=> '统计',

   'manage[_1]'
=> 'verwalte',
   'acc keys[_1]'
=> 'z-schl',

   'course[_12]'
=> '课程参加者',
   'roster[_1]'
=> '名单',

   'user[_1]'
=> '用户',
   'roles[_1]'
=> '角色',

   'create[_1]'
=> '创建',
   'course[_8]'
=> '课程',

   'course[_9]'
=> '课程',
   'parms[_1]'
=> '参数',

   'con-[_1]'
=> 'konstr-',
   'struct[_1]'
=> 'bereich',

   'co con-[_1]'
=> 'Konstruk',
   'struct[_2]'
=> 'Co-Autor',

   'domain[_1]'
=> '域',
   'config[_1]'
=> '配置',

   'resource[_1]'
=> '发布', # '资源',
   'space[_1]'
=> '资源',

   'co res[_1]'
=> 'co-res-',
   'space[_2]'
=> 'bereich',

   'what is[_1]'
=> '有什么',
   'new[_1]'
=> '新内容',

   'enter[_1]'
=> 'eingeben',
   'grades[_3]'
=> 'bewert', # '评估',

   'send[_1]'
=> '发送',
   'scantron[_1]'
=> 'scantron',

   'course[_13]'
=> '课程',
   'catalog[_1]'
=> '目录',

   'view[_1]'
=> '查看',
   'bookmark[_1]'
=> '书签',

   'calendar[_1]'
=> '日历',
   'announce[_1]'
=> '通告',

   'commu-[_1]'
=> '发送和接收',
   'nication[_1]'
=> '邮件',

   'course[_10]'
=> '课程-',
   'chatroom[_1]'
=> '聊天室',

   'course[_14]'
=> '课程-',
   'groups[_1]'
=> '组',

   'port-[_1]'
=> '文件夹',
   'folio[_1]'
=> '空间',

   'edit[_1]'
=> '编辑',
   'blogs[_1]'
=> '博客',

   'search[_3]'
=> 'suche in',
   'prtfolio[_1]'
=> 'prtfolio',

   'search[_1]'
=> '在课程中',
   'course[_11]'
=> '搜索',

   'search[_2]'
=> '搜索',
   'library[_1]'
=> '资源',

   'prefer-[_1]'
=> '用户',
   'ences[_1]'
=> '设置',

   'exit[_1]'
=> '注销',
   ' [_1]'
=> ' ',

#=====================
# Remote control entries which occur only in lonmenu.pm

   'problem[_1]'
=> 'Aufgaben', # '问题',
   'grades[_4]'
=> 'Bewert',

   'sub-[_1]'
=> 'Einrei-',
   'missions[_1]'
=> 'chungen',

   'problem[_2]'
=> 'Aufgaben', # '问题',
   'parms[_2]'
=> 'Param',

   'retrieve[_1]'
=> 'Version', # '恢复',
   'version[_1]'
=> 'wiederherstellen', # '版本',

   'publish[_1]'
=> 'Ressourc', # '发行',
   'resource[_3]'
=> 'veröffen', # '资源',

   'delete[_1]'
=> 'Ressourc', # '删除',
   'resource[_2]'
=> 'löschen', # '资源',

   'prepare[_1]'
=> 'Drucken',
   'printout[_1]'
=> '', # !

   'backward[_1]'
=> 'zurück',

   'forward[_1]'
=> 'Weiter',

   'set[_1]'
=> 'Lesez',
   'bookmark[_2]'
=> 'setzen',

   'anno-[_1]'
=> 'Bemerk-',
   'tations[_1]'
=> 'ungen',

   'catalog[_2]'
=> 'Katalog-',
   'info[_1]'
=> 'info', # '信息',

   'evaluate[_1]'
=> 'Aufgabe',
   'this[_1]'
=> 'evaluier',

   'feedback[_1]'
=> 'Feedback',
   'discuss[_1]'
=> 'Diskuss',

# End remote control
#=====================

   '(Enter maximum [_1] collaborators using username or username@domain, e.g. smithje or smithje@[_2].)'
=> '(输入最大[_1]同事的用户名或用户名@域名，例如：smithje or smithje@[_2]。)',

   '(Hand in a file you have prepared on your computer)'
=> '(Reichen Sie eine Datei ein, die Sie auf Ihrem Computer vorbereitet haben)',

   ', select a template from the pull-down menu below.'
=> ', wählen Sie eine Vorlage aus dem folgenden Auswahlmenü aus.',

   '<*response>s are both inside of <part> and outside of <part>, this is not a valid problem, errors in grading may occur.'
=> '<*response>-Tags sind zugleich innerhalb und außerhalb eines <part>-Tags. Dies ist keine gültige Aufgabe. Beim Bewerten können Fehler auftreten.',

   'ABSTRACT'
=> '摘要',

   'Access Control'
=> '访问控制',

   'Activate'
=> '激活',

   'Add Roles'
=> '添加角色',

   "Add one empty page/column after each student's assignment"
=> "Füge eine leere Seite/Spalte nach jeder studentischen Übung ein",

   "Add three empty pages/column after each student's assignment"
=> "Füge drei leere Seiten/Spalten nach jeder studentischen Übung ein",

   "Add two empty pages/column after each student's assignment"
=> "Füge zwei leere Seiten/Spalten nach jeder studentischen Übung ein",

   'Date Shift'
=> 'Datumsverschiebung',

   'Do not clone date parameters'
=> 'Datumswerte nicht klonen',

   'Clone date parameters as-is'
=> 'Datumswerte unverändert übernehmen',

   'Shift date parameters by number of days'
=> 'Datumswerte um bestimmte Anzahl an Tagen verschieben',

   'Additional settings, if specified below, will override cloned settings'
=> 'Weitere Einstellungen, falls unten angegeben, werden erzeugte Einstellungen überschreiben',

   'Advanced Edit'
=> 'Erweiterter Editor',

   'All Resources'
=> 'Alle Ressourcen',

   'All Students'
=> '所有学生',

   'Allowed filetypes: [_1]'
=> 'Akzeptierte Dateitypen: [_1]',

   'An error occurred during the attempt to change the section for this student.'
=> 'Beim Ändern der Sektion für diesen Studenten trat ein Fehler auf.',

   'An error occurred during the attempt to change the role information for this student.'
=> 'Beim Ändern der Rolleninformationen für diesen Studenten trat ein Fehler auf.',

   'Analyzing Results'
=> 'Ergebnisse der Analyse',

   'Answerable'
=> 'Beantwortbar',

   'Assessment Parameters'
=> 'Parameter zur Beurteilung',

   'Automated Enrollment Manager'
=> 'Verwaltung der automatischen Kursbelegung',

   'Automated adds'
=> 'Automatische Hinzufügungen',

   'Automated drops'
=> 'Automatische Ausschließungen',

   'Automated enrollment settings'
=> 'Einstellungen für automatische Kursbelegung',

   'Bad Filename'
=> 'Ungültiger Dateiname',

   'Begin Enrollment'
=> 'Kursbelegung beginnen',

   'Binary File'
=> 'Binärdatei',

   'Blank'
=> 'Leer',

   'Browse'
=> 'Durchblättern',

   'CSV format'
=> 'CSV Format',

   'Cannot publish directory'
=> 'Kann Verzeichnis nicht veröffentlichen',

   'Cannot retrieve directory'
=> 'Kann Verzeichnis nicht wiederherstellen',

   'Catalog Search'
=> 'Katalog-Suche',

   'Change User Privileges'
=> 'Benutzerrechte ändern',

   'Changed discussion view mode'
=> '改变讨论视图模式',

   'Click here for FAQ'
=> 'Häufig gestellte Fragen',

   'Click here for help'
=> 'Hilfe',

   'Click here to report bugs'
=> 'Hier zum Melden von Fehlern klicken',

   'Click-On Texts (comma sep):'
=> 'Antwortvorgabetexte zum Anklicken (durch Kommata getrennt):',

   'Clone an existing course'
=> 'Einen bestehenden Kurs clonen',

   'Close This Window'
=> 'Dieses Fenster schließen',

   'Closed'
=> 'Geschlossen',

   'Communication'
=> '通讯',
#=> 'Kommunikation',

   'Compare versions of'
=> 'Vergleiche Versionen von',

   'No differences found'
=> 'Keine Unterschiede gefunden',

   'Completely new course'
=> 'Komplett neuer Kurs',

   'Construction Space Version'
=> 'Version des Konstruktionsbreichs',

   'Continue'
=> '下一步',

   'Copy current file to'
=> 'Kopiere derzeitige Datei nach',

   'Copy selected'
=> 'Kopiere ausgewählte',

   'Course Code'
=> 'Kurscode',

   'Course Content'
=> '课程内容',

   'Course Data'
=> '课程数据',

   'Course Home Server'
=> 'Heimatserver des Kurses',

   'Course ID/Number'
=> '课程-ID/编号',

   'Course Information'
=> '课程资料',

   'Resource Level'
=> '资源等级',

   'Map/Folder Level'
=> 'Inhaltszus./Verzeichnis', # 'Inhaltszus.-/Verzeichnis-Ebene',

   'Course Level'
=> '课程等级',

   'Course Search'
=> '课程搜寻',

   'Course Title'
=> '课程名称',

   'Create New User'
=> '创建新用户',

   'Create User'
=> '创建用户',

   'Crosslisted courses'
=> 'Fachbereichsübergreifene Kurse',

   'Current Class List'
=> '目前的学生名单',

   'Current Ending Date: [_1]'
=> '目前结束日期： [_1]',

   'Current Ending Date: not set'
=> '目前结束日期： 未设置',

   'Current Resource'
=> '现有资源',

   'Current Starting Date: [_1]'
=> '目前开始日期： [_1]',

   'Current Starting Date: not set'
=> '目前开始日期： 未设置',

   'Current Version'
=> '当前版本',

   'Currently no active roles or courses'
=> '目前没有任何活动的角色或课程',

   'Currently no additional roles or courses'
=> '目前还没有更多的角色或课程',

   'The following [quant,_1,role,roles] will become active in the future:'
=> 'Die [quant,_1,folgende Rolle wird,folgenden Rollen werden] zukünftig aktiv:',

   'Currently submitted: [_1]'
=> '目前提交：[_1]',

   'Custom Role Editor'
=> '自订角色编辑器',

   'Cut selected'
=> 'Auswahl ausschneiden',

   'Decompress'
=> '解压缩',

   'Default Assessment Spreadsheet'
=> 'Standard-Beurteilungsbogen',

   'Default Course Spreadsheet'
=> 'Standard-Kurs-Beurteilungsbogen',

   'Default Student Spreadsheet'
=> 'Standard-Studenten-Beurteilungsbogen',

   'Default XML Style File'
=> 'Standard-XML-Style-Datei',

   'Default for new courses is'
=> 'Standard für neue Kurse ist',

   'Default:'
=> 'Voreingestellt:',

   'Define Role'
=> 'Rolle erstellen',

   'Dependencies'
=> 'Abhängigkeiten',

   'Description:'
=> '描述:',

   'Disable student resource discussion'
=> 'Ressourcendiskussion für Studenten deaktivieren',

   'Disable student use of chatrooms'
=> 'Chatroom-Nutzungsmöglichkeit für Studenten deaktivieren',

   'Display file attributes'
=> 'Zeige Dateiattribute',

   'Do NOT generate as standard course'
=> 'NICHT als Standard-Kurs erstellen',

   'Domain Level'
=> 'Domänenebene',

   "Don't Show Feedback"
=> "Kein Feedback anzeigen",

   'Duration of automated classlist updates'
=> 'Dauer der automatischen Aktualisierung der Kursteilnehmerlisten',

   'Dynamic Metadata (updated periodically)'
=> '动态数据 (定期更新)',

   'ERROR'
=> '错误',

   'Edit Custom Role Privileges'
=> '编辑自定义角色权限',

   'Editor Errors - these errors might not effect the running of the problem, but they will likely cause problems with further use of the Edit mode. Please use the EditXML mode to fix these errors.'
=> '编辑错误-这些错误可能不会影响正在运行的问题，但他们很可能会导致问题进一步使用编辑模式。请使用XML模式来解决这些错误。',

   'End Time'
=> '结束时间',

   'Ending Date'
=> '结束日期',

   'Ending date'
=> '结束日期',

   'Enroll One Student'
=> '登记一名学生',

   'Enroll as student'
=> '登记学生',

   'Enrolling'
=> '登记',

   'Enrolling Student'
=> '登记学生',

   'Enter as many fields as you can. The system will inform you and bring you back to this page if the data selected is insufficient to enroll students in your class.'
=> 'Füllen Sie so viele Felder wie möglich aus. Das System wird Sie informieren und zu dieser Seite zurückbringen, falls die Daten nicht ausreichen, Studierende in Ihren Kurs einzuschreiben.',

   'Enter as many fields as you can.<br /> The system will inform you and bring you back to this page, <br /> if the data selected are insufficient to add users.'
=> 'Füllen Sie so viele Felder wie möglich aus.<br /> Das System wird Sie informieren und zu dieser Seite zurückbringen,<br /> falls die Daten nicht ausreichen, Benutzer in Ihren Kurs einzuschreiben.',

   'Enter terms or phrases separated by AND, OR, or NOT then press SEARCH below'
=> '在搜索栏里输入关键字或词组用  AND, OR, 或 NOT 间隔，然后点击下面的 搜索 ',

   'Enter terms or phrases separated by search operators such as AND, OR, or NOT'
=> '在搜索栏里输入关键字或词组，如 AND，OR，或 NOT 间隔。',

   'Entering Construction Space'
=> 'Betrete Konstruktionsbereich...',

   'Error: Directory Non Empty'
=> 'Fehler: Verzeichnis nicht leer',

   'Error: destination for operation is an existing directory.'
=> 'Fehler: Das Ziel der Operation ist ein existierendes Verzeichnis.',

   'Evaluation Error '
=> 'Auswertungsfehler',

   'Homework Problem'
=> 'Übungsaufgabe',

   'Exam Problem'
=> 'Prüfungsaufgabe',

   'Excel format'
=> 'Excel-Format',

   'Feedback Addresses for Course Content Comments'
=> 'Feedback-Adressen für Kommentare zu Kursinhalten',

   'Feedback Addresses for Course Policy'
=> 'Feedback-Adressen für Kursrichtlinien',

   'Feedback Addresses for Resource Content Question'
=> 'Feedback-Adressen für Fragen zum Inhalt der Ressourcen',

   'First'
=> 'Erste',

   'First Resource'
=> 'Erste Ressource',

   'Foil name [_1] appears more than once. Foil names need to be unique.'
=> 'Die Auswahlmöglichkeits-Bezeichnung [_1] tritt mehr als einmal auf. Bezeichnungen für Auswahlmöglichkeiten müssen jedoch eindeutig sein.',

   'Folder/Map'
=> '文件夹/课程内容',

   'For one or more students'
=> 'Für einen oder mehrere Studierende',

   'Found a <*response> outside of a <part> in a <part>ed problem'
=> 'Es wurde ein <*response>-Tag außerhalb eines <part>-Bereichs einer Aufgabe gefunden, die aber Aufgabenteile (parts) verwendet.',

   'Found no analyzable respones in this problem, currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren korrekten Antworten in dieser Aufgabe gefunden. Derzeit werden nur numerische Ausdrücke, Formeln und Strings als Antworttypen unterstützt.',

   'Generate messages from a file'
=> '从一个文件生成邮件',

   'Arabic - UTF'
=> 'ﺎﻠﻋﺮﺒﻳﺓ - UTF',

   'German - UTF'
=> 'Deutsch - UTF',

   'English - UTF'
=> 'English - UTF',

   'Spanish (Castellan) - UTF'
=> 'español (castellano) - UTF',

   'Persian - UTF'
=> 'ﺍیﺭﺎﻧی - UTF',

   'French - UTF'
=> 'français - UTF',

   'Hebrew - UTF'
=> 'עברית - UTF',

   'Japanese - UTF'
=> '日本語 - UTF',

   'Portuguese - UTF'
=> 'Português - UTF',

   'Russian - UTF'
=> 'Русский - UTF',

   'Turkish - UTF'
=> 'türkçe - UTF',

   'Chinese Simplified - UTF'
=> '简体中文 - UTF',

   'Swedish Chef - UTF'
=> 'Dänischer Koch - UTF',

   'Undetermined - ISO'
=> 'Undetermined - ISO',

   'Interlingua (International Auxiliary Language Association) - ISO'
=> 'Interlingua (International Auxiliary Language Association) - ISO',

   'Go'
=> 'Go',

   'go'
=> 'Go',

   'Go to ...'
=> '转到...',

   'Help on Creating Courses'
=> 'Hilfe bei der Kurserstellung',

   'Home Server'
=> 'Heimatserver',

   'Homework problem'
=> 'Übungsaufgabe',

   'How do I create a CSV file from a spreadsheet'
=> '我如何从Excel表创建一个CSV文件',

   'How do I create a class list from a spreadsheet'
=> 'Wie erstelle ich eine Kursteilnehmerliste von einem Beurteilungsbogen?',

   'How should the results be printed?'
=> 'Wie sollten die Resultate ausgedruckt werden?',

   'Immediately expire own role as Course Coordinator'
=> 'Eigene Rolle als Kurs-Koordinator mit sofortiger Wirkung verfallen lassen',

   'Import and Paste Area'
=> 'Feld zum Importieren und Einfügen',

   'Include retrieval of student photographs?'
=> 'Abrufen der Studentenfotos einbinden?',

   'Institutional Information'
=> 'Institutionelle Information',

   'Invalid Significant figures detected'
=> 'Ungültige signifikante Stellen entdeckt',

   'Invalid characters in requested name have been removed.'
=> 'Aus dem gewünschten Dateinamen wurden ungültige Zeichen entfernt.',

   'Invalid login mode or password.'
=> 'Falscher Login-Modus oder Passwort.',

   'Invalid username or domain'
=> '无效的用户名或域',

   'KEYWORDS'
=> 'SCHLÜSSELWÖRTER',

   'LaTeX batchmode'
=> 'LaTeX-Batchmode',

   'LaTeX mode'
=> 'LaTeX 模式',

   'Languages used'
=> '所用语言',

   'Last'
=> 'Letzte',

   'Leave blank on scoring form'
=> 'Im Bewertungsformular leer lassen',

   'List Directory'
=> '目录列表',

   'Location'
=> '地点',

   'Login Data'
=> '登录数据',

   'Logout'
=> '退出',

   'Make new directory'
=> '创建新目录',

   'Make new file'
=> '创建新文件',

   'Manual Grading'
=> '手动评分',

   'Map has branchings. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Verzweigungen. Verwenden Sie den erweiterten Editor.',

   'Map has conditions. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Bedingungen. Verwenden Sie den erweiterten Editor.',

   'Map has resource parameters. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat Ressourcen-Parameter. Verwenden Sie den erweiterten Editor.',

   'Map has unconnected resources. Use advanced editor.'
=> 'Die Inhaltszusammenstellung hat unverknüpfte Ressourcen. Verwenden Sie den erweiterten Editor.',

   'Messaging'
=> '发送邮件',

   'first'
=> '名', # !

   'last'
=> '姓', # !

   'middle'
=> '中名', # !

   'Middle Name'
=> '中名',

   'Missing Kerberos domain information.'
=> '丢失的Kerberos域信息。',

   'Modification may make assessment data inaccessible!'
=> '修改可能使评估数据无法访问！',

   'Modify Enrollment for'
=> '修改注册为',

   'Modify User'
=> '修改用户',

   'Modify another students data'
=> '修改另一个学生的数据',

   'Modify deadlines, etc, for this resource'
=> '修改此资源的截止日期等',

   'Modifying data for user'
=> '修改用户的数据',

   'Modifying this will make problems have different numbers and answers!'
=> '修改这将使问题有不同的号码和答案！',

   'Move current file to'
=> '目前文件移动到',

   'Must create new subdirectory inside a directory'
=> '必须在目录里面创造新的子目录',

   'Name of Role'
=> '角色名字',

   'New Directory'
=> '新目录',

   'New HTML file'
=> '新的HTML文件',

   'New Resource'
=> '新资源',

   'New Role'
=> '新角色',

   'New User'
=> '新用户',

   'New Value'
=> '新的价值',

   'New assembled page'
=> '新组合页面',

   'New assembled sequence'
=> '新的组合序列',

   'New custom rights file'
=> '新文件的访问控制',

   'New file'
=> '新文件',

   'New problem'
=> '新问题',

   'New style file'
=> '新的风格文件',

   'New subdirectory'
=> '新的子目录',

   'Next    '
=> '下一步    ',

   'No'
=> '否',

   'No Access or Usages Statistics are available for this resource.'
=> '没有访问或使用的统计数据可用于该资源。',

   'No Assessment Statistical Data is available for this resource'
=> '没有任何评估统计数据可用于该资源。',

   'No Evaluation Data is available for this resource.'
=> '没有任何评价数据可用于该资源。',

   'No new filename specified.'
=> '没有指定新的文件名。',

   'No such file'
=> '文件未找到',

   'Not Allowed'
=> '不允许',

   'Not applicable -'
=> 'Nicht anwendbar -',

   'Not open to be viewed'
=> 'Ressource darf nicht betrachtet werden',

   'Not set -'
=> 'Nicht gesetzt -',

   'Notification of enrollment changes'
=> 'Benachrichtigung über Änderungen der Kursbelegung',

   'Notification to course coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den <b>Kurs-Koordinator</b> benachrichtigen, wenn während der automatischen Aktualisierung Änderungen an der Kursbelegung auftreten?',

   'Number of columns'
=> 'Anzahl an Spalten',

   'Old Value'
=> 'Alter Wert',

   'One particular problem (overrides folder and course defaults)'
=> 'Eine bestimmte Aufgabe (überschreibt Verzeichnis- und Kurs-Voreinstellungen)',

   'Online Help'
=> '联机帮助',

   'Help: [_1]'
=> '帮助: [_1]',

   'Only domain coordinators can change a users password.'
=> '只有域协调员可以更改用户的密码。',

   'Open Course'
=> '创建课程',

   'Open all assessments'
=> '所有评估访问',

   'Open and correct'
=> '公开和正确',

   'Open with full tries'
=> '向所有人开放的尝试',

   'Output Format: [_1]'
=> '输出格式： [_1]',

   'Layout Options'
=> '布局选项',

   'Page layout'
=> '页面布局',

   'Paper type'
=> '纸张类型',

   'PDF-Formfields'
=> 'PDF格式字段',

   'with Formfields'
=> '带有格式字段',

   'without Formfields'
=> '不带有格式字段',

   'Parameter'
=> '参数',

   'Paste after selected'
=> 'In Auswahl einfügen',

   'Personal Data'
=> '个人资料',

   'Please choose the default authentication method to be used by new users added to this LON-CAPA domain by the automated enrollment process'
=> 'Wählen Sie hier die voreingestellte Authentifizierungs-Methode aus, die bei neuen Benutzern in dieser LON-CAPA-Domäne verwendet werden soll, die durch den automatischen Kursbelegungs-Prozess hinzugefügt wurden',

   'No such user [_1] at domain [_2].' # 1: user, 2: domain
=> 'In der Domäne [_2] existiert der Benutzer [_1] nicht.',

   'Please click Back on your browser and select another user, or [_1]Create User[_2]'
=> 'Bitte klicken Sie in Ihrem Webbrowser auf Zurück und wählen Sie einen anderen Benutzer aus oder wählen Sie [_1]Benutzer erstellen[_2]',

   'Invalid home server for course: [_1]'
=> 'Ungültiger Heimatserver für Kurs [_1]',

   'Please contact your LON-CAPA administrator regarding this situation.'
=> 'Bitte kontaktieren Sie zu dieser Angelegenheit Ihren LON-CAPA-Administrator.',

   'Please select an authentication mechanism'
=> 'Wählen Sie bitte eine Authentifizierungs-Methode aus',

   'Please select the Authentication mechanism'
=> 'Auswahl der Authentifizierungs-Methode',

   'Please stand by.'
=> 'Bitte warten.',

   "Please use browser 'Back' button and pick a filename"
=> "Benutzen Sie bitte den Zurück-Button des Webbrowsers und wählen Sie einen Dateinamen aus",

   'Preparing Printout'
=> 'Bereite Ausdruck vor',

   'Print'
=> 'Drucken',

   'Print Index'
=> 'Index drucken',

   'Print Discussions'
=> 'Diskussionsbeiträge drucken',

   'Print Annotations'
=> 'Notizen drucken',

   'Print Table of Contents'
=> 'Inhaltsverzeichnis drucken',

   'Print:'
=> 'Drucke:',

   'Problems from entire course'
=> 'Aufgaben des gesamten Kurses',

   'Processed file: [_1]'
=> 'Verarbeitete Datei: [_1]',

   'Publish this Resource'
=> 'Diese Ressource veröffentlichen',

   'Randomization algorithm used'
=> 'Verwendeter Randomisierungs-Algorithmus',

   'Recent'
=> '最新的',

   'Rename current file to'
=> '当前文件重命名为',

   'Report a Bug'
=> '报告错误',

   'Resource'
=> '资源',

   'Resource Differences'
=> '资源的差异',

   'Resources from selected sequence in course'
=> 'Ressourcen von ausgewählten Sequenzen im Kurs',

   'Response'
=> '回答',

   'Retrieve Old Version'
=> 'Alte Version wiederherstellen',

   'Retrieving current (most recent) version'
=> 'Aktuelleste Version wiederherstellen',

   'Retrieving old version'
=> 'Alte Version wiederherstellen',

   'Return to DOCS'
=> '回到课程内容',

   'Reverse Association'
=> 'Umgekehrte Assoziierung',

   'Revoke'
=> '撤销',

   'Revoke Existing Roles'
=> '撤销现有的角色',

   'Role'
=> '角色',

   'Role:'
=> '角色：',

   'Role Information'
=> '角色信息',

   'Sample Points:'
=> 'Abtastpunkte:',

   'Save entries below as a draft answer (not submitting them for credit yet)'
=> 'Die untenstehenden Eintragungen als Entwurf speichern (aber noch nicht endgültig einreichen)',

   'Select Action'
=> '选择行动',

   'Select All Resources'
=> '选择所有资源',

   'Select Printing Options:'
=> '选择打印选项：',

   'Select Problem(s) to print'
=> '选择要打印任务',

   'Select Resource(s) to print'
=> '选择要打印的资源',

   'Select Resources To Print'
=> '选择要打印的资源',

   'Select Section'
=> '选择章节',

   'Select Sequence To Print From'
=> '选择打印顺序',

   'Select Students and Resources'
=> '选择学生和资源',

   'Select Style File'
=> '选择文件风格',

   "Select a user name to modify the student's information"
=> "选择一个用户名来修改学生的信息",

   'Select a user name to view the users personal page.'
=> '选择一个用户名，以查看用户的个人页面。',

   'Select resources for the assignment'
=> 'Wählen Sie Ressourcen für die Übung aus',

   'Set'
=> '设置',

   'Set?'
=> '设置？',

   'Set Course Environment'
=> '设置课程环境',

   'Set End Date'
=> '设置结束日期',

   'Set Individual User Roles'
=> '设定用户角色和权限',

   'Set Start Date'
=> '设置开始日期',

   'Set content feedback to Course Coordinator'
=> 'Inhaltsbezogenes Feedback soll Kurs-Koordinator erhalten',

   'Set course policy feedback to Course Coordinator'
=> 'Feedback zu Kursrichtlinien soll Kurs-Koordinator erhalten',

   'Set opening date for all problems in the course for. . .'
=> 'Setze Öffnungstermin für alle Aufgaben in dem Kurs auf. . .',

   'Set to ...'
=> 'Setze auf...',

   'Show Answer'
=> 'Zeige Antwort',

   'Show Feedback'
=> 'Zeige Feedback',

   'Simple Edit'
=> 'Einfacher Editor',

   'Start Time'
=> 'Startzeit',

   "Start each student's assignment on a new page/column (add a pagefeed after each assignment)"
=> "Beginne jede studentische Übung auf einer neuen Seite/Spalte (füge einen Seitenvorschub nach jeder Übung ein)",

   'Starting Date'
=> '开始日期',

   'Starting date'
=> '开始日期',

   'Student ID'
=> '学生证',

   'Student Information'
=> '学生信息',

   'Student Sheet Links'
=> '学生表链接',

   'Student Status'
=> '学生状态',

   'Student Status: [_1]'
=> '学生状态： [_1]',

   'Student information updated successfully.'
=> '学生信息已成功更新。',

   'Students need access key to enter course'
=> 'Die Studierenden benötigen zum Betreten des Kurses einen Zugangsschlüssel',

   'Students with expired roles'
=> 'Studierende mit abgelaufenen Rollen',

   'Subject:'
=> '标题：',

   'Submissions'
=> 'Einreichungen',

   'Submit Modifications'
=> '提交更改',

   'Submit entries below as answer to receive credit'
=> 'Die untenstehenden Eintragungen einreichen',

   'Survey Question'
=> 'Frage einer Umfrage',

   'Survey question'
=> 'Frage einer Umfrage',

   'System Level'
=> 'Systemebene',

   'Target Edit Map'
=> 'Ziel Editor Inhaltszusammenstellung', #??? [SB 18.10.2006]

   'TeX unconverted due to errors'
=> 'TeX wegen Fehlern nicht konvertiert',

   'TeX unconverted due to previous errors'
=> 'TeX aufgrund vorheriger Fehler nicht konvertiert',

   'The error reported was'
=> 'Der genannte Fehler war',

   'The following entries will be used to identify the course according to the naming scheme adopted by your institution. Your choices will be used to map an internal LON-CAPA course ID to the corresponding course section ID(s) used by the office responsible for providing official class lists for courses at your institution. This mapping is required if you choose to employ automatic population of class lists.'
=> 'Die folgenden Einträge werden benutzt, um den Kurs gemäß des Namensschemas Ihrer Institution zu identifizieren. Ihre Auswahl wird benutzt werden, um eine interne LON-CAPA-Kurs-ID mit der/den zugehörigen Kurs-Sektion-ID(s) zu verbinden. Diese ID(s) werden von der Einrichtung verwendet, die für das zur Verfügungstellen der offiziellen Kurslisten an Ihrer Institution zuständig ist (z.B. Prüfungsamt). Diese Zuordnung is notwendig, wenn Sie die automatische Ergänzung von Kurslisten wählen.',

   "The following settings control automatic enrollment of students in this class based on information available for this specific course from your institution's official classlists."
=> "Die folgenden Einstellungen kontrollieren die automatische Kursbelegung von Studierenden in diesen Kurs anhand der verfügbaren Informationen für diesen Kurs von der offiziellen Kursteilnehmerliste Ihrer Institution.",

   'The requested file'
=> 'Die angeforderte Datei',

   'The student must log out and log in again to see these changes.'
=> 'Der Studierende muss sich ausloggen und neu einloggen, um diese Änderungen zu sehen.',

   'There are currently no Error Messages for this resource.'
=> 'Momentan liegen keine Fehlermeldungen zu dieser Ressource vor.',

   'There are no Evaluation Comments on this resource.'
=> 'Zu dieser Ressource liegen keine Evaluierungskommentare vor.',

   'There was an error determining the environment values for'
=> 'Es trat ein Fehler auf bei der Bestimmung der Umgebungswerte für',

   'Top Level Map'
=> 'Hauptebenen-Inhaltszusammenstellung',

   'Type Name Here'
=> 'Hier Name eingeben',

   'Type in value'
=> 'Wert eingeben',

   'Type:'
=> 'Typ:',

   'UNDISPLAYABLE'
=> 'NICHT DARSTELLBAR',

   'Unable to enroll'
=> 'Kursbelegung nicht möglich',

   'Unable to publish file, it contains duplicated ID(s), ID(s) need to be unique. The duplicated ID(s) are'
=> 'Die Datei kann nicht veröffentlicht werden, da Sie doppelte IDs enthält. IDs müssen jedoch eindeutig sein. Die doppelten IDs sind',

   'Unable to retrieve environment data for'
=> 'Konnte die Umgebungsdaten nicht wiederherstellen für',

   'Unable to set default dates for course'
=> 'Konnte die Defaulttermine des Kurses nicht setzen für',

   'Unavailable course'
=> 'Nicht verfügbarer Kurs',

   'Unknown Action'
=> 'Unbekannte Aktion',

   'Upload file'
=> 'Datei hochladen',

   'Upload file to Construction Space'
=> 'Datei in den Konstruktionsbereich hochladen',

   'VIEW'
=> 'ANSICHT',

   'View the FAQ'
=> 'Zeige die FAQ',

   'Visibly Separate Items on Pages'
=> 'Sichtbar unterschiedliche Einzelteile auf Seiten',

   'WARNING: The metadata table does not exist in the LON-CAPA database.'
=> 'ACHTUNG: Die Metadaten-Tabelle existiert nicht in der LON-CAPA-Datenbank.',

   'Warning: change of MIME type!'
=> 'Achtung: Änderung des MIME-Typs!',

   'Warning: target file exists!'
=> 'Achtung: Zieldatei existiert bereits!',

   'Warning: target file exists, and has been published!'
=> 'Achtung: Zieldatei existiert und wurde bereits veröffentlicht!',

   'Width'
=> 'Breite',

   'Print Options'
=> '打印选项',

   'Print Answers'
=> '打印回答',

   'Only Answers'
=> '只有回答',

   'With Answers'
=> '带答案',

   'Without Answers'
=> '没有答案',

   'You are working with an unsaved version of your map.'
=> 'Sie arbeiten momentan an einer nicht gespeicherten Version Ihrer Inhaltszusammenstellung.',

   'You changed the students id but did not disable the ID change safeguard. The students id will not be changed.'
=> 'Sie haben die ID/Matrikelnummer geändert, aber nicht den ID-/Matrikelnummer-Safeguard deaktiviert. Die ID/Matrikelnummer wird daher nicht geändert.',

   'Your request to change the role information for this student was refused. You do not appear to have sufficient authority to change student information.'
=> 'Ihre Versuch zur Änderung der Rolleninformationen für diesen Studenten wurde abgelehnt. Sie haben offensichtlich nicht genügend Rechte zum Ändern der Studenten-Daten.',

   '[_1] (what you just saw on the screen)'
=> '[_1] (what you just saw on the screen)',

   '[_1] Local Authentication with argument [_2]'
=> '[_1] 局部认证带 [_2]',

   'Currently using local (institutional) authentication.'
=> '目前使用的地方（机构）的认证。Derzeit lokal (institutionell) authentifiziert.',

   'a comma separated list of course sections crosslisted with the current course, with each entry including the institutional course section name followed by a colon and then the (optional) sectionID to be used in LON-CAPA, e.g., fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2'
=> 'Eine komma-separierte Liste von Kurs-Sektionen zusammen mit dem derzeitigen Kurs, wobei jeder Eintrag den institutionellen Kurssektionsnamen beinhaltet, gefolgt von einem Doppelpunkt und dann der (optionalen) Sektions-ID zur Verwendung in LON-CAPA, z.B. fs03ent231001:ent1,fs03bot231001:bot1,fs03zol231002:zol2',

   'a comma separated list of institutional section numbers, each separated by a colon from the (optional) corresponding section ID to be used in LON-CAPA e.g., 001:1,002:2'
=> 'Eine komma-separierte Liste institutioneller Sektionsnummern, jeweils getrennt durch einen Doppelpunkt von der in LON-CAPA verwendeten entsprechenden (optionalen) Sektions-ID, z.B. 001:1,002:2',

   'after selected'
=> '选定后',

   'and'
=> 'und',

   'between'
=> 'zwischen',

   'button'
=> 'Button',

   'by'
=> 'durch',

   'check all'
=> '全选',

   'chmod error'
=> '属性错误',

   'click on the'
=> 'klicken Sie bitte auf',

   'copy Error'
=> '复制错误',

   'currently does not exist'
=> 'existiert z.Z. nicht',

   'custom'
=> "自定义", # 'anpassbar', # individuell ???

   'custom distribution file'
=> '自定义文件', # ???

   'domain'
=> '域',

   'expired or revoked'
=> 'abgelaufen oder entzogen',

   'extension'
=> 'Endung',

   'external'
=> 'extern',

   'file<br />extension'
=> 'Datei-<br />Endung',

   'first name'
=> '名',

   'generation'
=> '生成',

   'in domain'
=> '在域',

   'internal'
=> '内部的',

   'is in this state by royal decree.'
=> 'hat die Erlaubnis aufgrund eines königlichen Erlasses.',

   'last name'
=> '姓',

   'make these dates the default for future enrollment'
=> 'Diese Datumswerte als voreingestellte Werte für zukünftige Kursbelegungen verwenden',

   'middle name'
=> '中名',

   'name'
=> '姓',

   'no ending date'
=> '无结束日期',

   'number'
=> 'Nummer',

   'obsolete replacement'
=> 'veraltete Ersetzung',

   'only check if you know what you are doing'
=> 'nur auswählen, wenn Sie wissen, was Sie tun',

   '[_1] only search domain [_2]' # 1: checkbox, 2: domain
=> '[_1] 只在该域 [_2] 搜索',

   'optional'
=> '可选的',

   'or any other value'
=> '或任何其他的值',

   'private'
=> '私人的',

   'public'
=> '公开的',

   'publisher<br />owner'
=> 'Herausgeber<br />Besitzer',

   'section'
=> 'Sektion',

   'standard'
=> '标准的',

   'standard LaTeX mode'
=> '标准的 LaTeX 模式',

   'standard courses only'
=> '只标准课程',

   'student name'
=> '学生姓名',

   'template'
=> '模板',

   'to interface with institutional data, e.g., fs03glg231 for Fall 2003 Geology 231'
=> 'Zur Kopplung mit institutionellen Daten, z.B. <tt>ss08inf345</tt> für <i>Sommersemester 2008 Informatik 345</i>',

   'unable to enroll'
=> '无法注册',

   'uncheck all'
=> '全部取消',

   'use related words'
=> '使用相关的关键词',

   '[_1] use related words'
=> '[_1] 使用相关的关键词',

   'username'
=> '用户名',

   'versus'
=> 'gegen',

   'with server'
=> 'mit Server',

   'yes'
=> '是',

   'Swedish Chef'
=> 'Dänischer Koch',

   '[_1] for default hiding'
=> '[_1] für voreingestelltes Verbergen',

   '[_1] for visible separation.'
=> '[_1] für sichtbare Trennung.',

   'Changes will not show until next login.'
=> 'Änderungen werden beim nächsten Login aktiv.',

   '[_1] if allowed, anything else if not'
=> '[_1], um zu erlauben. Alles andere, um nicht zu erlauben.',

   '"[_1]" to disable, anything else if not'
=> '"[_1]", um zu deaktivieren. Alles andere, um zu aktivieren.',

   '[_1] to suppress, anything else to not suppress'
=> '[_1], um zu unterdrücken. Alles andere, um nicht zu unterdrücken.',

   'Set value to [_1] to allow all roles.'
=> '[_1], um für alle Rollen zu erlauben.',

   '[_1] is not an acceptable number of tries. Tries must be a positive number with no decimal point.'
=> '[_1] ist kein zulässiger Wert für die Anzahl von Versuchen. Der Wert muss eine positive, ganze Zahl (ohne Dezimaltrennzeichen) sein.',

   '[_1] is not an acceptable weight. Weight must be a positive number.'
=> '[_1] ist kein zulässiger Wert für die Gewichtung. Der Wert muss eine positive Zahl sein.',

   '1 minute'
=> '1 Minute',

   '<b>HTML allowed</b>: Discussion participants can use limited HTML in their postings.'
=> '<b>HTML zugelassen</b>: Diskussionsteilnehmer können in ihren Beiträgen eingeschränkten HTML-Befehlssatz verwenden.',

   '<b>HTML banned</b>: HTML will not be allowed in discussion postings.'
=> '<b>HTML verboten</b>: HTML wird in Diskussionen nicht zugelassen.',

   '<b>Instructor</b> - instructors will not be able to participate in discussions'
=> '<b>Dozent</b> - Dozenten werden nicht an den Diskussionen teilnehmen können.',

   '<b>Instructor</b> - instructors will not be able to use or view the chat room'
=> '<b>Dozent</b> - Dozenten werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<b>Students</b> - students will not be able to participate in discussions'
=> '<b>Studierende</b> - Studenten werden nicht an Diskussionen teilnehmen können',

   '<b>Students</b> - students will not be able to use or view the chat room.'
=> '<b>Studierende</b> - Studenten werden den Chatroom weder betreten noch die Inhalte einsehen können',

   '<b>Teaching Assistants</b> - teaching assistants will not be able to participate in discussions'
=> '<b>Tutor</b> - Tutoren werden nicht an den Diskussionen teilnehmen können',

   '<b>Teaching Assistants</b> - teaching assistants will not be able use or view the chat room'
=> '<b>Tutor</b> - Tutoren werden den Chatroom weder betreten noch die Inhalte einsehen können',

   'Your current LON-CAPA domain is [_1].'
=> 'Ihre derzeitige LON-CAPA-Domäne ist [_1].',

   'Advanced: You can send the feedback from different sections to different people, by doing the following: Separate each entry with a comma. To send feedback to a certain address for different sections, append the section name or names (separated by semi-colons) in a parenthesized list after the user:domain. For example, john102:msu(001;002;003),bob293:msu(004;005;006),madeupname:here(007;008;009) will route course feedback to &quot;john102&quot; for sections 1, 2, and 3, to &quot;bob293&quot; for 4, 5, and 6, and to &quot;madeupname:here&quot; for 7, 8, and 9. Note there is no requirement that the addresses be in any particular domain.'
=> 'Fortgeschritten: Sie können Feedback von unterschiedlichen Sektionen aus an unterschiedliche Personen senden. Hierzu ist jeder Eintrag mit einem Komma zu trennen. Um Feedback an eine bestimmte Adresse für unterschiedliche Sektionen zu senden, hängen Sie die die Sektionsbezeichnung(en) (getrennt durch Semicola) in einer Klammerliste nach benutzer:domäne an. Beispiel: john102:msu(001;002;003), bob293:msu(004;005;006), irgendwer:irgendwo(007;008;009) würde Feedback an &quot; john102&quot; für Sektionen 1, 2 und 3, an &quot;bob293&quot; für Sektionen 4, 5 und 6 und an &quot;irgendwer:irgendwo&quot; für Sektionen 7, 8 und 9 senden. Beachten Sie, dass es nicht erforderlich ist, dass die Adressen in einer bestimmten Domäne liegen.',

   'Granting permission to clone course'
=> 'Erlaubnis zum Klonen des Kurses erteilen',

   'Existing courses can be cloned when creating new courses. Cloning will copy the course structure, contents, and most parameters (automatically advancing any date parameters by six months). Usernames of owners of other courses permitted to clone this course:'
=> 'Beim Erstellen neuer Kurse können bestehende Kurse geklont werden. Das Klonen kopiert die Kursstruktur, die Inhalte und die meisten der Parameter (Datumswerte werden automatisch um sechs Monate nach vorne geschoben). Benutzerkennungen von Eigentümern anderer Kurse, denen das Klonen erlaubt werden soll:',

   '(Course Coordinators automatically have the right to clone their own courses.) Format: user:domain, where &quot;user&quot; and &quot;domain&quot; are the LON-CAPA username and domain of the user.Separate different users with a comma.Use *:domain to allow course to be cloned by any course owner in the specified domain.Use * to allow unrestricted cloning by all course owners in all domains.'
=> '(Kurs-Koordinatoren haben automatisch die Berechtigung ihre eigenen Kurse zu klonen) Format: benutzerkennung:domäne, wobei &quot;benutzerkennung&quot; und &quot;domäne&quot; die LON-CAPA-Benutzerkennung und -Domäne des Benutzers sind. Trennen Sie mehrere Benutzer durch Kommata. Verwenden Sie *:domäne, um allen Benutzern der angegebenen Domäne das Klonen des Kurses zu erlauben. Verwenden Sie *, um allen Benutzern aller Domänen uneingeschränke Berechtigung zum Klonen zu erteilen.', # n.t.

   'All settings which you can change with this Helper can also be changed by going to the PARM screen and clicking on the &quot;Set course environment&quot; button. If you do not have experience coordinating LON-CAPA courses or if you prefer the Helper interface, please click &quot;Next&quot;.'
=> 'Alle Einstellungen, die mit diesem Hilfsprogramm änderbar sind, können auch über die Kurs- und Ressourcen-Parameter im Unterpunkt "Kursumgebung" geändert werden. Wenn Sie noch keine Erfahrung mit der Koordination von LON-CAPA-Kursen haben oder wenn Sie dieses Hilfsprogramm bevorzugen, klicken Sie bitte jetzt auf &quot;Weiter&quot;.',

   'Allow limited HTML in discussion posts'
=> 'Beschränkte Verwendung von HTML in den Diskussionsbeiträgen zulassen',

   'Allow problems to be split over pages'
=> 'Erlauben, dass sich Aufgaben auf mehrere Seiten aufteilen dürfen',

   'Answer Date (answerdate)'
=> 'Antwort-Verfügbarkeits-Datum (answerdate)',

   'Chat Room Participation'
=> 'Teilnahme am Chatroom',

   'Chat Participation'
=> 'Teilnahme am Chat',

   'Click here to return to the chart.'
=> 'Klicken Sie hier, um zum Chart zurückzukehren.',

   'Completed'
=> 'Ausgeführt',

   'Confirm that this information is correct, then click &quot;Save&quot; to complete setting the parameter.'
=> 'Bestätigen Sie, dass diese Informationen richtig sind. Klicken Sie dann auf &quot;Save&quot;, um das Einstellen der Parameter abzuschließen.',

   'Course ID or number'
=> 'Kurs-ID oder -Nummer',

   'Course Initialization Helper'
=> 'Hilfsprogramm zur Kurs-Einrichtung',

   'Course default for all problems'
=> 'Voreinstellungen des Kurses für alle Aufgaben',

   'Course members can provide feedback about the course. You can choose who will receive the feedback, such as a different instructor or a TA. Please enter their LON-CAPA address below, in the form user:domain, where &quot;user&quot; and &quot;domain&quot; are both the LON-CAPA username and LON-CAPA domain, not an e-mail address.'
=> 'Kursmitglieder können Feedback zum Kurs geben. Sie können hier auswählen, wer das Feedback empfangen soll, wie z.B. ein anderer Dozent oder Tutor. Bitte geben Sie deren LON-CAPA-Benutzer unten in der Form benutzer:domäne ein, wobei &quot;benutzer&quot; und &quot;domäne&quot; LON-CAPA-Benutzerkennung und LON-CAPA-Domäne sind. Verwenden Sie keine E-Mail-Adresse!',

   'Courses'
=> '课程',

   'Default beginning date when enrolling students'
=> 'Voreingestelltes Anfangsdatum für die studentische Kursbelegung',

   'Default ending date when enrolling students'
=> 'Voreingestelltes Endedatum für die studentische Kursbelegung',


   'Default set of options to pass to tth/m when converting tex'
=> 'Voreingestellte Optionen für tth/m für die Konvertierung von TeX',

   'Disable display of problem receipts'
=> 'Anzeige von Aufgaben-Nachweisnummern deaktivieren',

   'Disallow Resource Discussion for Roles'
=> 'Diskussion über Ressource für folgende Rollen nicht gestatten:',

   'Disallow Resource Discussion for Users'
=> 'Diskussion über Ressource für folgende Benutzer nicht gestatten:',

   'Disallow live chatroom use for Roles'
=> 'Nutzungsmöglichkeit des Live-Chatrooms für folgende Rollen nicht gestatten:',

   'Disallow live chatroom use for Users'
=> 'Besuchen des Live-Chatrooms für folgende Benutzer nicht gestatten:',

   'Discussion Participation'
=> 'Diskussionsteilnahme',

   'Due Date (contentclose)'
=> 'Fälligkeitsdatum (contentclose)',

   'Due Date (duedate)'
=> 'Fälligkeitsdatum (duedate)',

   'Every problem in a particular folder (overrides course default)'
=> 'Jede Aufgabe in einen bestimmten Verzeichnis (überschreibt Kurs-Voreinstellung)',

   'Exit'
=> '退出',

   'Feedback Addresses for Course Content'
=> '课程内容的信息反馈地址',

   'Finish Helper'
=> '结束帮助程序',

   'HTML can be allowed or banned inside of course discussion.'
=> 'HTML kann innerhalb von Kursdiskussionen erlaubt oder verboten werden.',

   'HTML in Discussions'
=> 'HTML in Diskussionen',

   'Hide Empty Rows in Spreadsheets'
=> 'Leere Zeilen in den Beurteilungsbögen verbergen',

   'How many tries should be set for all problems in the course?'
=> 'Wieviele Versuche sollten für alle Aufgaben im Kurs gesetzt werden?',

   'How many tries should be set for the selected folder?'
=> 'Wieviele Versuche sollten für alle gewählten Verzeichnisse gesetzt werden?',

   'How many tries should be set for the selected problem?'
=> 'Wieviele Versuche sollten für die ausgewählte Aufgabe gesetzt werden?',

   'LON-CAPA has chat room functionality. This course will receive its own chat room. You may deny students, TAs, or instructors the right to access the chat room.'
=> 'LON-CAPA bietet eine Live-Chat-Funktion an. Dieser Kurs wird seinen eigenen Chatroom erhalten. Sie können Studenten, Tutoren oder Dozenten das Recht verweigern, den Chatroom zu nutzen.',

   'LON-CAPA hosts discussions on all resources in a course. By default, all users are allowed to participate in these discussions. If you do not wish certain types of users to be able to use the discussion features, select those types below. Note your class may not have all of these roles; you may safely ignore roles you do not intend to use. (For instance, &quot;Exam Proctor&quot; is generally useful only for large courses.) Types of users not allowed to participate in discussion can still view any discussion that other users post.'
=> 'LON-CAPA bietet für alle Ressourcen des Kurses eine Diskussionsmöglichkeit an. In der Grundeinstellung dürfen allen Benutzer an diesen Diskussionen teilnehmen. Wenn Sie nicht wollen, dass bestimmte Arten von Benutzern an den Diskussionen teilnehmen sollen dürfen, wählen Sie diese unten aus. Beachten Sie, dass Ihr Kurs nicht jede Art von Benutzerrollen haben könnte. Sie können problemlos Rollen ignorieren, die Sie nicht verwenden wollen (Beispiel: Klausuraufsichtspersonal ist üblicherweise nur für sehr große Kurse hilfreich.) Benutzergruppen, die nicht an der Diskussion teilnehmen dürfen, können dennoch jede Diskussion der anderen Benutzer mitlesen.',

   'No section assigned'
=> 'Keiner Sektion zugewiesen',

   'Number of assignments printed at the same time:'
=> 'Anzahl von Übungen, die gleichzeitig gedruckt werden sollen:',

   'Opening Date (contentopen)'
=> 'Bearbeitungsbeginn-Datum (contentopen)',

   'Opening Date (opendate)'
=> 'Bearbeitungsbeginn-Datum (opendate)',

   'Please adjust significant figures.'
=> 'Bitte passen Sie die signifikanten Stellen an.',

   'Please select the section you wish to set the answer open date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the section you wish to set the due date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the section you wish to set the number of tries for:'
=> 'Bitte wählen Sie die Sektion, für die Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the section you wish to set the opening date for:'
=> 'Bitte wählen Sie die Sektion, für die Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the section you wish to set the problem weight for:'
=> 'Bitte wählen Sie die Sektion, für die Sie die Aufgabengewichtung festlegen wollen:',

   'Please select the student you wish to set the answer open date for:'
=> 'Bitte wählen Sie den Studenten, für den Sie das Antwort-Verfügbarkeits-Datum festlegen wollen:',

   'Please select the student you wish to set the due date for:'
=> 'Bitte wählen Sie den Studenten, für den Sie das Fälligkeitsdatum festlegen wollen:',

   'Please select the student you wish to set the number of tries for:'
=> 'Bitte wählen Sie den Studenten, für den Sie die Anzahl der Versuche festlegen wollen:',

   'Please select the student you wish to set the opening date for:'
=> 'Bitte wählen Sie den Studenten, für den Sie den Bearbeitungsbeginn festlegen wollen:',

   'Please select the student you wish to set the problem weight for:'
=> 'Bitte wählen Sie den Studenten, für den Sie die Aufgabengewichtung festlegen wollen:',

   'Privileged users that should not be hidden on staff listings'
=> 'Privilegierte Nutzer, die auf Personallisten nicht verborgen werden sollen',

   'Random seed for randomly picking number of resources (optional, only set if you know what you are doing) (randompickseed)'
=> 'Zufallszahlen-Basis für zufällige Wahl der Ressourcen-Anzahl (optional. Setzen Sie dies nur, wenn Sie die Funktionalität verstehen) (randompickseed)',

   'Reading results from [_1]'
=> 'Lese Ergebnisse von [_1]',

   'Receipt algorithm used'
=> 'Verwendetes Verfahren für Empfangsquittungen',

   'Receiving results from [_1]'
=> 'Erhalte Ergebnisse von [_1]',

   'Resources'
=> '资源',

   'Search Complete on Server [_1]'
=> 'Suche abgeschlossen für Server [_1]', # '搜索完成 [_1]',

   'Search: [_1]'
=> '搜索: [_1]',

   'Select All Files'
=> '选择所有文件',

   'Select All Published'
=> '选择所有发布的',

   'Select Folder'
=> '选择文件夹',

   'Select Only Current Students'
=> '只选择目前的学生',

   'Select Problem'
=> '选择任务',

   'Select Student'
=> '选择学生',

   'Select for Section/Group'
=> '选择科/组',

   'Select the folder you wish to set the parameter for:'
=> 'Wählen Sie das Verzeichnis, für den sie den Parameter einstellen wollen:',

   'Select the problem you wish to set the parameter for:'
=> 'Wählen Sie die Aufgabe, für die Sie den Parameter einstellen wollen:',

   'Set Problem Tries'
=> 'Aufgaben-Versuche einstellen',

   'Set Problem Weight'
=> 'Aufgaben-Gewichtung einstellen',

   'Set answer open date for all problems in the course for ...'
=> 'Setze Antwort-Verfügbarkeits-Datum aller Aufgaben des Kurses für...',

   'Set answer open date for the selected folder for ...'
=> 'Setze Antwort-Verfügbarkeits-Datum des ausgewählten Verzeichnisses für...',

   'Set answer open date for the selected problem for...'
=> 'Setze Antwort-Verfügbarkeits-Datum der ausgewählten Aufgabe für...',

   'Set due date for all problems in the course for ...'
=> 'Setze Fälligkeitsdatum aller Aufgaben des Kurses für...',

   'Set due date for the selected folder for ...'
=> 'Setze Fälligkeitsdatum des ausgewählten Verzeichnisses für...',

   'Set due date for the selected problem for ...'
=> 'Setze Fälligkeitsdatum der ausgewählten Aufgabe für...',

   'Set number of tries for all problems in the course for ...'
=> 'Setze Anzahl der Versuche aller Aufgaben des Kurses für...',

   'Set number of tries for the selected folder for ...'
=> 'Setze Anzahl der Versuche des ausgewählten Verzeichnisses für...',

   'Set number of tries for the selected problem for ...'
=> 'Setze Anzahl der Versuche der ausgewählten Aufgabe für...',

   'Set opening date for all problems in the course for ...'
=> 'Setze Bearbeitungsbeginn-Datum aller Aufgaben des Kurses für...',

   'Set opening date for the selected folder for ...'
=> 'Setzte Bearbeitsbeginn-Datum des ausgewählten Verzeichnisses für...',

   'Set opening date for the selected problem for ...'
=> 'Setze Bearbeitungsbeginn-Datum der ausgewählten Aufgabe für...',

   'Set problem weight for all problems in the course for ...'
=> 'Setze Aufgabengewichtung aller Aufgaben des Kurses für...',

   'Set problem weight for the selected folder for ...'
=> 'Setze Aufgabengewichtung des ausgewählten Verzeichnisses...',

   'Set problem weight for the selected problem for ...'
=> 'Setze Aufgabengewichtung der ausgewählten Aufgabe für...',

   'Set value to [_1] to allow.'
=> '[_1], um zu erlauben.',

   'Setting the [_1]'
=> 'Einstellung auf [_1] setzen',

   'Setting the [_1] to [_2]'
=> 'Einstellung ändern von [_1] auf [_2]',

   'Student Name'
=> '学生姓名',

   'The &quot;Course Title&quot; is the name of the course that will be seen by the students. You may now modify the description and hit &quot;Next&quot; to continue.'
=> 'Der &quot;Kurstitel&quot; ist der Name des Kurses, der von den Kursteilnehmern gesehen wird. Sie können diese Bezeichnung nun ändern und mit &quot;Weiter&quot; fortfahren',

   'The question can not be gotten correct, the following foils in the &lt;optionresponse&gt; have invalid correct options'
=> 'Die Antwort auf diese Frage kann niemals richtig werden. Die folgenden Auswahlmöglichkeiten im &lt;optionresponse&gt;-Tag beinhalten unzulässige richtige Optionen',

   'There are no currently enrolled students in the course.'
=> 'Derzeit gibt es keine Kursteilnehmer im Kurs.',

   'There are no currently enrolled students in the selected sections.'
=> 'Es gibt keine derzeit eingeschriebenen Kursteilnehmer in der ausgewählen Sektion.',

   'There are no previously enrolled students in the course.'
=> 'Es gibt keine in der Vergangenheit eingeschriebenen Kursteilnehmer im Kurs.',

   'There are no previously enrolled students in the selected sections.'
=> 'Es gibt keine in der Vergangenheit eingeschriebenen Kursteilnehmer in den ausgewählten Sektionen.',

   'There are no students with future access in the course.'
=> 'Es gibt keine Studenten mit zukünftigem Kurszugriff im Kurs.',

   'There are no students with future access in the selected sections.'
=> 'Es gibt keine Studenten mit zukünftigem Kurszugriff in den ausgewählten Sektionen.',

   'There are no students in the course.'
=> 'Es gibt keine Kursteilnehmer im Kurs.',

   'There are no students in the selected sections.'
=> 'Es gibt keine Kursteilnehmer in den ausgewählten Sektionen.',

   'This controls how receipt numbers are generated.'
=> 'Steuert die Erzeugung der Nachweisnummern.',

   'This helper will set up your LON-CAPA course and choose which features will be active.'
=> 'Dieses Hilfsprogramm unterstützt Sie dabei, Ihren LON-CAPA-Kurs einzurichten und zu wählen, welche Einstellungen aktiv sein werden.',

   'Unselect All Files'
=> 'Auswahl für alle Dateien aufheben',

   'Unselect All Published'
=> 'Auswahl für alle veröffentlichten Dokumente aufheben',

   'Unselect All Resources'
=> 'Auswahl für alle Ressourcen aufheben',

   'Unselect for Section/Group'
=> '取消选择科/组',

   'Welcome to Your New LON-CAPA Course'
=> '欢迎使用您的新 LON-CAPA 课程',

   'What parameter do you want to set for the selected folder?'
=> 'Welchen Parameter möchten Sie für das ausgewählte Verzeichnis setzen?',

   'What parameter do you want to set for the selected problem?'
=> 'Welchen Parameter möchten Sie für die ausgewählte Aufgabe setzen?',

   'What should the answer open date be set to?'
=> 'Auf welchen Wert soll das Antwort-Verfügbarkeits-Datum gesetzt werden?',

   'What should the due date be set to?'
=> 'Auf welchen Wert soll das Fälligkeitsdatum gesetzt werden?',

   'What weight should be set for all problems in the course?'
=> 'Auf welchen Wert soll die Gewichtung für alle Aufgaben im Kurs gesetzt werden?',

   'What weight should be set for the selected folder?'
=> 'Auf welchen Wert soll die Gewichtung für das ausgewählte Verzeichnis gesetzt werden?',

   'What weight should be set for the selected problem?'
=> 'Auf welchen Wert soll die Gewichtung der ausgewählten Aufgabe gesetzt werden?',

   'Your course is now set up. Please select the Save button to re-intialize the course with your chosen settings. Remember that all of these settings can be modified in the PARMS screen (Course Configuration).'
=> 'Ihr Kurs ist nun eingerichtet. Bitte klicken Sie auf "Speichern", um den Kurs mit den vorgenommenen Einstellungen neu zu initialisieren. All diese Einstellungen können im Menüpunkt "Kurs- und Ressourcen-Parameter", Unterpunkt "Kurs-Konfiguration" geändert werden.',

   '[_1] Filesystem Authenticated (with initial password [_2])'
=> '[_1] Authentifizierung über Dateisystem (mit Anfangspasswort [_2])',

   'Currently Filesystem Authenticated.'
=> 'Derzeit dateisystem-authentifiziert.',

   '[_1] Internally authenticated (with initial password [_2])'
=> '[_1] LON-CAPA 内部认证 (初始密码 [_2])',

   'Currently internally authenticated.'
=> '目前 LON-CAPA 内部认证。',

   'Records per Page:'
=> '每页显示结果：',

   '[_1] minutes'
=> '[_1] 分',

   '[_1] minutes, [_2] seconds'
=> '[_1] 分, [_2] 秒',

   '[_1] with value [_2]'
=> '[_1] 与价值 [_2]',

   '[_2] seconds'
=> '[_2] 秒',

   'all resources in the course'
=> '课程中的所有资源',

   'all students in course'
=> '在课程中的所有学生',

   'anonymous students'
=> '匿名学生',

   'answer date'
=> '回答日期',

   'contacting [_1]'
=> '联系 [_1]',

   'due date'
=> '截止日期',

   'for'
=> 'für',

   'for [_1]all resources in the course[_2]'
=> '为 [_1]课程中的所有资源 [_2]',

   'for [_1]all students in course[_2]'
=> '为 [_1]在课程中的所有学生 [_2]',

   'for [_1]'
=> '为 [_1]',

   'for section [_1]'
=> 'für den Sektion [_1]',

   'for the map named [_1]'
=> 'für die Inhaltszusammenstellung mit der Bezeichnung [_1]',

   'for the resource named [_1], part [_2]'
=> 'für die Ressource [_1], Aufgabenteil [_2]',

   'for the resource ID [_1] (name unavailable), part [_2]'
=> 'für die Ressource mit der ID [_1] (Name nicht verfügbar), Aufgabenteil [_2]',

   'from'
=> 'von',

   'from current subdirectory'
=> 'von derzeitigem Unterverzeichnis',

   'helper'
=> '辅助程序',

   'in'
=> 'in ',

   'instructor'
=> '讲师',

   'number of tries'
=> '尝试次数',

   'opening date'
=> '开始日期',

   'problem weight'
=> '问题难度',

   'role,role,...'
=> '角色，角色，...',

   'selected students'
=> '选定的学生',

   'student'
=> '学生',

   'to'
=> 'auf',

   'to [_1] ([_2])'
=> 'auf [_1] ([_2])',

   'waiting on [_1]'
=> '等待 [_1]',

   'what you just saw on the screen'
=> 'was Sie gerade auf dem Bildschirm gesehen haben',

   'Enter my portfolio space'
=> '文件夹空间',

   'No syllabus information provided.'
=> 'Kein Kursüberblick vorhanden.',

   'Sorry ...'
=> '对不起...',

   'This resource might be part of another course.'
=> 'Diese Ressource ist wahrscheinlich Bestandteil eines anderen Kurses.',

   'Agree'
=> 'Trifft eher zu',

   'Any comments?'
=> '评论：',

   'Copy this column'
=> 'Kopiere diese Spalte',

   'Disagree'
=> 'Trifft eher nicht zu',

   'General Intro'
=> 'Allgemeine Einführung',

   'Greek Symbols'
=> '希腊字母',

   'HTML character entities'
=> 'HTML-Zeichencode',

   'If you are viewing this online, copy and paste the text from any of the right columns into your text area to get the symbol on the left.'
=> 'Wenn Sie sich diesen Text online ansehen, kopieren Sie den Eintrag in der rechten Spalte und fügen sie ihn in den Texteingabebereich ein, um das entsprechende Symbol auf der linken Seite zu erhalten.',

   'LON-CAPA Help'
=> 'LON-CAPA-Hilfe',

   'Landscape'
=> 'Querformat',

   'Launch navigation window'
=> '启动导航窗口',

   'Grade Levels'
=> '级别',

   'Grade Level'
=> '级别',

   'Lowest Grade Level'
=> '最低级别',

   'Lowest Grade Level:'
=> '最低级别:',

   'Highest Grade Level'
=> '最高级别',

   'Highest Grade Level:'
=> '最高级别:',

   'Mark all posts read'
=> '将所有帖子标记为已阅读',

   'My question/comment/feedback:'
=> '我的问题/评论/反馈:',

   'Other Symbols'
=> '其他符号',

   'Please check at least one of the following feedback types:'
=> '请从以下选项：',

   'Please rank the following criteria:'
=> '请以以下标准评价：',

   'Portrait'
=> '竖排格式',

   'Question about resource content'
=> '关于此资源内容的问题',

   'Question/Comment/Feedback about course policy'
=> '关于课程规则的问题/评论/反馈',

   'Select a Course to Enter'
=> '选择一个课程',

   'Sending Messages'
=> '发送邮件',

   'Show Me My First Homework Problem'
=> 'Zeige erste Übungsaufgabe',

   'Standards'
=> '标准',

   'Strongly Agree'
=> 'Trifft völlig zu',

   'Strongly Disagree'
=> 'Trifft überhaupt nicht zu',

   'Symbol'
=> '符号',

   'The material appears to be correct'
=> '这些材料似乎是正确的',

   'The material is helpful'
=> '这些材料是有用的',

   'The material is presented in a clear way'
=> '这些材料中提出一个明确的方式',

   'The resource is technically correct (loads fast enough, does not produce errors, links work, etc)'
=> '资源在技术上是正确的(加载速度足够快, 不会产生错误, 链接页面可以访问, 等等)',

   'HTML character enties'
=> 'HTML 字符实体',

   '"Waiting for Remote Control window to load: "+[_1]'
=> '"等待加载远程控制窗口: "+[_1]',

   '[_1]Continue[_2] on in Inline Menu mode'
=> '[_1]继续[_2] 在内置菜单模式下',

   'All posts'
=> '所有的讨论',

   'Change Color Scheme'
=> '更改颜色方案',

   'Change Colors'
=> '改变颜色',

   'Change Discussion Display Preferences'
=> '改变讨论显示偏好',

   'Change How Math Equations Are Displayed'
=> '改变显示科学计算公式',

   'Change Language'
=> '语言',

   'Change Language Preferences'
=> '更改语言首选项',

   'Change Message Forwarding and Notification Email Addresses'
=> '更改邮件转发和通知的电子邮件地址',

   'Change Password'
=> '更改密码',

   'Change Preferences'
=> '改变参数',

   'Change Roles Page Preferences'
=> '改变角色页参数',

   'Change Screen Name'
=> '改变昵称',

   'Change Screenname'
=> '改变昵称',

   'Change WYSIWYG Editor Preferences'
=> 'WYSIWYG-编辑器',

   'Contact Helpdesk'
=> '联系求助',

   'Current discussion settings'
=> '目前讨论的设置',

   'Duedate' 
=> '截止日期',

   'Each post can be toggled read/unread'
=> 'Jeder Diskussionsbeitrag kann zwischen als gelesen und als ungelesen umgeschaltet werden',

   "Edit the 'About Me' Personal Information Screen"
=> "个人网页",

   'Enable WYSIWYG Editor'
=> '应用 WYSIWYG-编辑器',

   'End of Sequence'
=> '结束序列',

   'Entering Course'
=> '进入课程',

   'Get help'
=> '获得帮助',

   'Go to main menu'
=> '进入主菜单',

   'Has New Discussion'
=> '有新讨论',

   'Launching of the Remote Control menu will fail if pop-up window filters are active. To use the Remote Control, disable the filter for this site.'
=> '当弹出式窗口过滤器被激活，远程控制启动将会失败。 为了使用远程控制，在此网站请禁用这些过滤器。',

   'Navigate Course Content'
=> '浏览目录',

   'New posts only'
=> '只有新的讨论',

   'No Resource'
=> '没有资源',

   'No syllabus available'
=> '没有提供教学大纲',

   'Not currently assigned.'
=> '目前没有任务发布。',

   'Not new'
=> '不是新的',

   'Off'
=> '关',

   'On'
=> '开',

   'Once displayed'
=> '显示一次',

   'Once marked not NEW'
=> '一次后标记不是新的',

   'Please click on the the resource you intend to access'
=> 'Bitte klicken Sie auf die Ressource, auf die Sie zugreifen wollen',

   'Posts cease to be marked "NEW"'
=> 'Beiträge nicht mehr als "NEU" kennzeichnen',

   'Posts to be displayed'
=> 'Diskussionsbeiträge, die angezeigt werden sollen',

   'Role selected. Please stand by.'
=> '角色选定。请稍候。',

   'Send'
=> '发送',

   'Set User Preferences'
=> '设置用户参数',

   'Show Preview and Check Spelling'
=> '查看预览和拼写检查',

   'Sort by:'
=> '排序方式:',

   'The external menu (Remote Control) has been disabled, and you will be working with the smaller inline menu. You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser. To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> '外部菜单（远程控制）已被禁用，继续在内置菜单模式下工作。您可能已经关闭了远程控制的窗口，或被您的浏览器的弹出窗口过滤器阻止了。为了使用远程控制，在此网站禁用该过滤器，并在内置菜单重新启动远程控制。',

   'There are several possibilities of where to go next'
=> 'Es gibt mehrere Möglichkeite, wohin Sie als nächstes gehen können',

   'To use the Remote Control, disable the filter for this site, and re-launch the Remote Control from the inline menu.'
=> '为了使用远程控制，在此网站禁用弹出窗口过滤器，并在内置菜单重新启动远程控制。',

   'Toggle read/unread'
=> '切换已读/未读',

   'Unread only'
=> '只有未读',

   "View this user's personal page"
=> "显示这个用户的个人网页",

   'You have reached the end of the sequence of materials.'
=> '您已达到教材序列的最后。',

   'You may have either closed the Remote Control window, or it was blocked by a pop-up window filter in your browser.'
=> '您可能已经关闭了远程控制的窗口，或者被您的浏览器的弹出窗口过滤器拦截了。',

   'attachments'
=> '附件',

   'About User'
=> '个人网页',


   'All documents out of a published map into this folder'
=> '在这个目录里面发布的所有文件的内容列表',

   'Change Math Pref'
=> 'Darstellung wissenschaftl. Formeln',

   'Change Math Preferences'
=> '改变显示科学方程式偏好',

   'Comment'
=> '注解',

   'Communication/Messages'
=> '通信/邮件',

   'Configure blocking of student communication during exams'
=> 'Blockieren von studentischer Kommunikation während Prüfungen konfigurieren',

   'Convert to Images'
=> '转换为图像',

   'Course and Catalog Search'
=> '课程和目录搜索',

   'Create Subdirectory'
=> '创建子目录',

   'Upload file to current directory'
=> '上传文件到当前目录',

   'Create subdirectory in current directory'
=> '在当前目录下，创建一个新的子目录',

   'If HTML file, upload embedded images/multimedia/css/linked files'
=> '对于HTML文件:<br />上传嵌入式图像/多媒体文件/CSS/链接文件',

   'Delete Selected'
=> '删除所选',

   'Critical'
=> '重要的',

   'Currently no documents.'
=> '目前没有任何文件。',

   'Enter terms or phrases, then press "Search" below'
=> '在搜索栏里输入关键字或词组，然后点击下面的“搜索”。',

   'INBOX'
=> '收件箱',

   'If HTML file, upload embedded images/multimedia files'
=> '对于HTML文件:<br />上传嵌入式图像/多媒体文件',

   'IMS Import'
=> 'IMS-Import',

   'Import IMS package'
=> '导入 IMS-包',

   'IMS Export'
=> 'IMS-Export',

   'Export Course to IMS Package'
=> '导出-IMS-包',

   'Export content item?'
=> 'Inhaltselement exportieren?',

   'Export discussion posts?'
=> 'Diskussionsbeitrag exportieren?',

   'As you did not select any content items or discussions for export, an IMS package has not been created.'
=> 'Da Sie weder Inhaltselemente noch Diskussionsbeiträge zum Exportieren ausgewählt haben, wurde kein IMS-Paket erstellt.',

   'Please [_1]go back[_2] to select either content items or discussions for export.'
=> 'Bitte gehen Sie [_1]zurück[_2], um Inhaltselemente und Diskussionsbeiträge zum Exportieren auszuwählen.',

   '[_1]Your IMS package[_2] is ready for download.'
=> '[_1]Ihr IMS-Paket[_2] steht zum Download bereit.',

   'Import a document'
=> 'LON-CAPA-内部文件',

   'Make New Folder'
=> '新建文件夹',

   'New Composite Page'
=> '新组合页面',

   'New Messages Only'
=> '只有新邮件',

   'Portfolio Manager'
=> '组合管理',

   'Preferred method to display Math'
=> '首选的方法来显示科学方程式',

   'Published documents'
=> '发布文件',

   'Recover Deleted Resources'
=> '恢复已删除的资源',

   'Send a Message'
=> '发送邮件',

   'Sent Messages'
=> '已发送邮件',

   'Show'
=> '显示',

   'TRASH'
=> '已删除邮件',

   'TeX to HTML'
=> 'TeX to HTML',

   'View Folder'
=> '查看文件夹',

   'fulltext search (time consuming)'
=> '全文检索 (费时的)',

   'search discussion postings (resources and discussion boards)'
=> '搜索讨论帖子 (资源和布告栏)',

   'Roles'
=> '角色',

   'Select style file'
=> '选择档案风格',

   '(mark them then click "next" button)'
=> '(标记，然后点击“下一步”按钮)',

   '100 Level'
=> '1. 学年',

   '200 Level'
=> '2. 学年',

   '300 Level'
=> '3. 学年',

   '400 Level'
=> '4. 学年',

   'Action'
=> '动作',

   'Actions for current directory'
=> '此目录的行动',

   'Change Discussion Preferences'
=> '改变讨论偏好',

   'Change Message Forwarding/Notification'
=> '邮件转发和通知',

   'Change WYSIWYG Preferences'
=> 'WYSIWYG-编辑器',

   'Change to '
=> '变化为 ',

   'Clean Up'
=> '清理',

   'Closed - XML source is closed to everyone'
=> '锁定 - XML的源代码对手有人锁定',

   'Copy'
=> '复制',

   'Create a new directory or LON-CAPA document'
=> '创建一个新的目录或 LON-CAPA 文件',

   'Current setting '
=> '当前设置 ',

   'Delete Directory'
=> '删除文件夹',

   'Delete directory'
=> '删除文件夹',

   'Delete this resource'
=> '删除此资源', # long version: 'Lösche diese Ressource',

   'Disable WYSIWYG editor'
=> '不使用 WYSIWYG-编辑器',

   'Display Preference'
=> '显示偏好',

   'Edit catalog information'
=> '编辑目录信息',

   'Enable WYSIWYG editor'
=> '使用 WYSIWYG-编辑器',

   'Grade 1'
=> '1 级',

   'Grade 10'
=> '10 级',

   'Grade 11'
=> '11 级',

   'Grade 12'
=> '12 级',

   'Grade 13'
=> '13 级',

   'Grade 2'
=> '2 级',

   'Grade 3'
=> '3 级',

   'Grade 4'
=> '4 级',

   'Grade 5'
=> '5 级',

   'Grade 6'
=> '6 级',

   'Grade 7'
=> '7 级',

   'Grade 8'
=> '8 级',

   'Grade 9'
=> '9 级',

   'Graduate Level'
=> '研究生层次',

   'List current directory'
=> '文件夹', # long version: 'Aktuelles Verzeichnis anzeigen',

   'Mark obsolete'
=> '标记为过时的',

   'Move'
=> '移动',

   'New library file'
=> '新的库文件',

   'No file: [_1]'
=> '没有任何文件： [_1]',

   'No personal information provided'
=> '没有提供的个人资料',

   'Not specified'
=> '未指定',

   'Once marked as read'
=> '一旦标记为已读',

   'Open - XML source is open to people who want to use it'
=> '开放 - XML的源代码开放给想要使用它的人',

   'Points Display'
=> '分数显示',

   'Completed Problems Display'
=> '显示完成作业',

   'Points Scored'
=> '得分',

   'Attempted'
=> '尝试',

   'Posts displayed?'
=> '帖子显示？',

   'Preferences can be set that determine'
=> '预置可设置确定',

   'Print contents of directory'
=> '打印目录',

   'Print directory'
=> '打印目录',

   'Problem Document'
=> '任务文件', # '问题',

   'Publish this Directory'
=> '发布此目录',

   'Publish this resource'
=> '发布此资源', # long version: 'Diese Ressource veröffentlichen',

   'Re-publish'
=> '重新发布',

   'Retrieve old version'
=> '恢复旧版本',

   'Select action'
=> '选择行动',

   'Send message'
=> '发送消息',

    'Set display preferences for discussion posts for both discussion boards and individual resources in all your courses.'
=> '在这里，您可以设置您的讨论是否显示在所有的课程的布告栏和个人资源里。',

   'Source Distribution'
=> '源代码的访问权限',

   'The preferences you set here can be overridden within each individual discussion.'
=> '您的喜好设定这里可以适用在每个讨论。', # '您的喜好设定可以被每个讨论更改。',

   'Under what circumstances posts are identfied as "New"'
=> '在什么情况下讨论被设定为“新”',

   'Upload a new document'
=> '上传新文件',

   'Use random seed'
=> '使用随机种子',

   'Use style file'
=> '使用样式文件',

   'Which posts are displayed when you display a discussion board or resource, and'
=> '哪些讨论将将被显示，如果你有一个布告栏或资源，',

   'closed'
=> '锁定源代码', # !

   'dir[_1]'
=> 'dir[_1]',

   'list[_1]'
=> '列表[_1]',

   'open'
=> '公开源代码', # !

   '(mark desired resources then click "next" button)'
=> '(标记所需资源然后单击“下一步”按钮)',

   '[_1]Change[_2] for just [_3]this course[_4] or for all [_5]your courses[_6].'
=> '[_1]改变[_2] 只为 [_3]该课程[_4] 或者为所有 [_5]您的课程[_6].',

   "Page displayed after role selection in course now set by [_1]user's global preferences[_2]."
=> "Seite, die nach Betreten des Kurses angezeigt werden soll, wird nun durch Ihre [_1]allgemeinen Benutzereinstellungen[_2] gesteuert.",

   'Page displayed after role selection in this course set to [_1].'
=> 'Seite, die nach Betreten des Kurses angezeigt werden soll, wurde auf [_1] gesetzt.',

   'Unable to set control of page display to [_1] due to [_2].'
=> 'Setzen der Seitenanzeige-Einstellungen auf [_1] war nicht möglich aufgrund von [_2].',

   'Unable to set page display, after role selection, for this course to [_1] due to [_2].'
=> 'Setzen der Seitenanzeige-Einstellungen nach Rollenauswahl für diesen Kurs auf [_1] war nicht möglich aufgrund von [_2].',

   'Add or Edit Blog Entries'
=> '添加或修改博客条目',

   'Add to my public course blog'
=> '添加到我的公共课程博客',

   'Annotator'
=> '注释者',

   'Av. Attempts'
=> 'Mittlere Anzahl an Versuchen',

   'Available RSS Feeds and Blogs'
=> '可用的 RSS订阅和博客',

   'Average number of attempts'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Bookmarks'
=> '书签',

   'Change interval?'
=> '更改间隔？',

   'Change options?'
=> '更改选项？',

   'Change thresholds?'
=> '更改阈值？',

   'Clean up'
=> '清理',

   'Close Folder'
=> '关闭文件夹',

   'Configure Blocking of Student Communication during Exams'
=> 'Kommunikationssperre einrichten', # 'Blockieren studentischer Kommunikation während Prüfungen konfigurieren',

   'Course Action Items'
=> 'Kurs-Aktionselemente',

   'Creating PDF'
=> '创建PDF文件',

   'Currently: [_1].'
=> '现在： [_1].',

   'Deg. Diff'
=> '难度',

   'Description'
=> '描述',

   'Display Action Items'
=> 'Aktionselemente anzeigen',

   'Enter my groups in the course'
=> '我的课程组',

   'Entering [_1]'
=> '进入 [_1]',

   'Entering [_1] ...'
=> '进入 [_1]...',

   'First resource'
=> '第一资源',

   'Generated [_1] ([_2] bytes)'
=> '生成于 [_1] ([_2] bytes)',

   'Go to first resource'
=> '转到第一资源',

   'Group Documents'
=> '组文件',

   'Groups'
=> '组',

   'Help Menu'
=> '求助菜单',

   'Hide all'
=> '全部隐藏',

   'Hide this Feed'
=> '隐藏这个Feed',

   'LON-CAPA Feed "[_1]" for [_2]'
=> 'LON-CAPA-Feed "[_1]" 对于 [_2]',

   'Last Reset'
=> '最后重启',

   'Last revised'
=> '最近更改',

   'Link'
=> '连接',

   'Log In'
=> '登录',

   'Move Checked to Folder'
=> 'Verschiebe Auswahl in Verzeichnis',

   'Name for New Feed'
=> '新Feed的名字',

   'Name of this Feed'
=> '这个Feed的名字',

   'New course messages'
=> '新的课程信息',

   'New critical messages in course'
=> '新的课程重要信息',

   'New in course'
=> '新课程',

   'New version'
=> '新版本',

   'No messages sent.'
=> '没有寄出的邮件。',

   'No new course messages'
=> '没有新的课程信息',

   'No problems require handgrading'
=> '没有习题需要手动评分',

   'No problems satisfy threshold criteria'
=> '没有问题达到要求标准',

   'No problems with errors'
=> '没有错误的问题',

   'No unread critical messages in course'
=> '没有未读的重要邮件',

   'No unread posts in course discussions'
=> '没有未读的帖子在课程论坛里面',

   'No updated versions'
=> '没有更新版本',

   'Num. students'
=> '学生的数量',

   'Number of errors'
=> '错误的数量',

   'Number of new posts'
=> '新帖子的数量',

   'Number ungraded'
=> '未评分的数量',

   'Open Folder'
=> '打开文件夹',

#   'Open all folders'
#=> '打开所有文件夹',

   'Page set to be displayed after you have selected a role in this course'
=> '页面显示设置，在您选择了该课程中的角色后',

   'Please select the type of LON-CAPA entity - Course or Group - for which you wish to add/modify a user role'
=> 'Bitte wählen Sie den Typ der LON-CAPA-Entität - Kurs oder Gruppe - für den Sie die Benutzerrolle hinzufügen/ändern wollen.',

   'Please stand by while processing your print request, this may take some time ...'
=> 'Ihr Druckauftrag wird bearbeitet. Dies kann einige Zeit dauern. Bitte warten Sie...',

   'Problem'
=> '问题',

   'Problem Name'
=> '问题描述',

   'Problem is not open to be viewed. It'
=> 'Aufgabe nicht zur Betrachtung freigegeben. Es',

   'Problems requiring handgrading'
=> '必须手动评分的问题',

   '(Problems with av. attempts &ge; [_1] or deg. difficulty &ge; [_2]) [_3] and total number of students with submissions &ge; [_4]'
=> '(问题尝试的平均数目 &ge; [_1] 或者难度 &ge; [_2]) [_3] 和回答问题的学生总数 &ge; [_4]',

   'Problems with errors'
=> '错误的问题',

   'Recently generated printouts'
=> 'Zuletzt erzeugte Ausdrucke',

   'Recently generated printout zip files'
=> 'Zuletzt erzeugte ZIP-Dateien',

   'Reset Count?'
=> '计数器复位？',

   'Reset counters to 0'
=> '重置计数器为0',

   'Select [_1]'
=> '选择 [_1]',

   'Select the sequence to print resources from:'
=> '选择该资源的打印顺序：',

   'Selected [_1]Problems[_2] from folder [_3]'
=> '选定[_1]问题[_2]从文件夹[_3]',

   'Selected [_1]Resources[_2] from folder [_3]'
=> '选定[_1]资源[_2]从文件夹[_3]',

   'Selected <b>Problems</b> from <b>entire course</b>'
=> '选定<b>问题</b>从<b>整个课程</b>',

   'Selected <b>Resources</b> from <b>entire course</b>'
=> '选定<b>资源</b>从<b>整个课程</b>',

   'Selected <b>Problems</b> from <b>entire course</b> for <b>selected people</b>'
=> '选定<b>资源</b>从<b>整个课程</b>给<b>选定的人</b>',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]selected people[_5]'
=> '选定[_1]问题[_2]从文件夹[_3]给[_4]选定的人[_5]',

   'Selected [_1]Problems[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> '选定[_1]问题[_2]从文件夹[_3]给[_4]编码练习[_5]', # ???

   'Selected [_1]Resources[_2] from folder [_3] for [_4]selected people[_5]'
=> '选定[_1]资源[_2]从文件夹[_3]给[_4]选定的人[_5]',

   'Selected [_1]Resources[_2] from folder [_3] for [_4]CODEd assignments[_5]'
=> '选定[_1]资源[_2]从文件夹[_3]给[_4]编码练习[_5]', # ???

   'Selected [_1]Problems[_2] from current subdirectory [_3]'
=> '选定[_1]问题[_2]从当前的子文件夹[_3]',

   'Selected <b>Resources</b> from <b>selected folder</b> in course'
=> '选定<b>资源</b>从课程里的<b>选定的文件夹</b>',

   'Show all'
=> '全部显示',

   'Show my first due problem'
=> '查看我的首要问题来处理',

   'Show only uncompleted problems'
=> '只显示未完成的问题',

   'Show everything'
=> '查看所有',

   'Uncompleted Problems'
=> '没有完成问题',

   'All homework assignments have been completed.'
=> '所有的问题都已经完成。',

   'Speller Suggestions'
=> 'Speller Suggestions',

   'Start a New Feed'
=> '开始一个新的Feed',

   'Save Marked Changes'
=> '保存标记的更改',

   'Save changes'
=> '保存更改',

   'This action is currently not authorized.'
=> '这一行动目前是不被允许的。',

   'Time of last post'
=> '最后发表的帖子的时间', #??? [SB 20.10.2006]

   'Title of document goes here'
=> 'Dokumententitel hier eintragen',

   'Body of document goes here'
=> 'Hauptinhalt des Dokuments kommt hier hin',

   'Total number of students with submissions'
=> 'Gesamtzahl an Studierenden, die etwas eingereicht haben',

   'Unread course discussion posts'
=> '未读的课程讨论帖子',

   'Version used'
=> '使用版本',

   'Version[_1]'
=> '版本[_1]',

   'View current problem status and grading information'
=> '查看当前的问题的状态和等级评定信息',

   "What's New?"
=> "有什么新内容？",

   "What's New? page"
=> "有什么新页面",

   "What's New page"
=> "有什么新页面",

   'You are accessing an invalid course'
=> '您在试图访问无效的课程。',

   'course only'
=> 'nur Kurs',

   'delete'
=> '删除',

   'first resource in the course'
=> '第一期课程资源',

   'hidden'
=> '隐藏的',

   'new feed'
=> '新的feed',

   'since last month'
=> '自上个月以来',

   'since last week'
=> '自上周以来',

   'since start of course'
=> '从课程开始起',

   'since yesterday'
=> '从昨天起',

   'specific setting for this course'
=> '这门课程的具体设置',

   'test.problem'
=> 'test.problem',

   'user preference'
=> '用户偏好',

   "what's new? page"
=> "有什么新页面",

   'your general user preferences'
=> '您的一般使用者偏好',

   'Submitting as Comment'
=> '提交评论',

   'Submitting as Policy Feedback'
=> '提交课程指导方针反馈',

   'Submitting as Question'
=> '提交的问题',

   'Total Points In Course'
=> '课程总分',

   'the resource you just saw on the screen'
=> 'the resource you just saw on the screen',
#=> 'die zuletzt betrachtete Ressource',

   'Annotations'
=> '注释',

   'Close (no save)'
=> '关闭 (不保存)',

   'Save and Update'
=> '保存和更新',

   'Bookmark Tree Viewer/Editor'
=> '书签树浏览器/编辑器',

   'Chat'
=> '聊天',

   'Chat Room'
=> '聊天室',

   'Drop Box'
=> '收件箱',

   'Import Bookmarks'
=> '导入书签',

   'The LearningOnline Network with CAPA'
=> 'The LearningOnline Network with CAPA',

   'This LON-CAPA server is temporarily not available for login.'
=> '该 LON-CAPA 服务器目前无法登录。',

   'Please attempt to login to one of the following servers:'
=> '请尝试登录到下列其中一个服务器：',

   '(preferred)'
=> '(首选的)',

   'Although your current role has privileges to view any existing groups in this course, you do not have privilegesto create new groups.'
=> 'Obwohl Sie in Ihrer derzeitigen Rolle über das Recht verfügen alle Gruppen in diesem Kurs anzusehen, haben Sie nicht das Recht neue Gruppen zu erzeugen.',

   'Collaborative Tools'
=> '协作工具',

   'Course content'
=> '课程内容',

   'Create a new group'
=> '创建新组',

   'Created'
=> '生成',

   'Creator'
=> '创设者',

   'Discussion Boards'
=> '讨论板',

   'Disk Use (%)'
=> '使用的存贮空间 (%)',

   'Enable Recent Roles Hotlist:'
=> '启用最近的角色活动表：',

   'Erster Kurs'
=> 'Erster Kurs',

   'Files'
=> '文件',

   'Group Name'
=> '组名',

   'Group Title'
=> '组标题',

   'Members'
=> '成员',

   'Modify'
=> '修改',

   'Re-enable'
=> '修复',

   'Expire'
=> '失效',

   'Group settings'
=> '组设置',

   'Modify group membership'
=> '修改组成员',

   'No groups exist.'
=> '没有组存在。',

   'Number of roles in Hotlist:'
=> '角色的快速访问列表：',

   'Quota (Mb)'
=> '容量 (MB)',

   'Remote Control'
=> '遥控器',

   'Some LON-CAPA users have a long list of roles. The Recent Roles Hotlist feature keeps track of the last N roles which have been visited and places a table of these at the top of the roles page. People with very few roles should leave this feature disabled.'
=> '一些 LON-CAPA 用户有很多角色。在快速访问列表里面将显示最近使用过的角色的最后N角色访问过的地方，这些角色将显示在角色选择页面的上方。 用户如果只有很少的角色，应该禁用快速访问列表。',

   'Some LON-CAPA users have a long list of courses. The Recent Courses Hotlist feature keeps track of the last N courses which have been visited and places a table of these at the top of the courses page. People with very few courses should leave this feature disabled.'
=> '一些 LON-CAPA 用户有很多课程。在快速访问列表里面将显示最近使用过的课程的最后N课程访问过的地方，这些课程将显示在课程选择页面的上方。用户如果只有很少的角色，应该禁用快速访问列表。',

   'Switch to Inline Menu Mode'
=> '切换到内置菜单模式',

   'This list below can be used to <q>freeze</q> roles on your screen. Those marked as frozen will not be removed from the list, even if they have not been used recently.'
=> '这下面的列表可以用来<q>冻结</q>屏幕上的角色。这些标记为冻结的将不会从名单中删除，即便最近没有被使用过时。',

   'View Status'
=> '查看状态',

   'View/Change Status'
=> '查看/修改状态',

   'You are not currently a member of any active groups in this course.'
=> 'Sie sind zurzeit nicht Mitglied einer aktiven Gruppe in diesem Kurs.',

   'Group [_1] was updated.'
=> '组 [_1] 已更新。',

   'An error occurred while setting parameters for Discussion Boards folder: [_1]'
=> 'beim eim Einstellen der Parameter für das Diskussionsforums-Verzeichnis ist ein Fehler aufgetreten: [_1]',

   'Discussion Boards Folder created.'
=> '创建讨论板夹。',

   'You do not have group administration privileges in this course.'
=> 'Sie haben in diesem Kurs keine Gruppen-Administrationsrechte.',

   'An error occurred when [_1] the group. Please try again.'
=> 'Bei der Aktion "[_1]" für die Gruppe ist ein Fehler aufgetreten. Bitte versuchen Sie es erneut.',

   'You have requested deletion of the group [_1].'
=> 'Sie möchten die Gruppe [_1] löschen.',

#activated
#reenabled
#modified
#added
#deleted
#expired

   'The following users could not be activated, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht aktiviert werden, da ein Fehler aufgetreten ist:',

   'The following users could not be reenabled, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht wiederhergestellt werden, da ein Fehler aufgetreten ist:',

   'The following users could not be modified, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht geändert werden, da ein Fehler aufgetreten ist:',

   'The following users could not be added, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht hinzugefügt werden, da ein Fehler aufgetreten ist:',

   'The following users could not be deleted, because an error occurred:'
=> 'Die folgenden Benutzer konnten nicht entfernt werden, da ein Fehler aufgetreten ist:',

   'The following users could not be expired, because an error occurred:'
=> 'Die Mitgliedschaften der folgenden Benutzer konnten nicht entzogen werden, da ein Fehler aufgetreten ist:',

   'No change occurred for the following users:'
=> 'Folgende Benutzer bleiben unverändert:',

   'When a group is deleted the following occurs:'
=> 'Beim Löschen einer Gruppe passiert folgendes:',

   'All group membership is terminated.'
=> 'Alle Gruppen-Mitgliedschaften werden aufgelöst.',

   'The group ceases to be available either for viewing or for modification of group settings and membership.'
=> 'Betrachten und Ändern der Gruppen-Einstellungen und -Mitgliedschaften wird für die Gruppe nicht mehr möglich sein.',

   'The group folder is removed from the folder containing it - normally this is the "Course Groups" folder which contains folders for all groups in the course.'
=> 'Das Gruppenverzeichnis wird aus dem zugehörigen Verzeichnis entfernt - normalerweise ist dies das "Kursgruppen"-Verzeichnis, in dem die Verzeichnisse aller Gruppen für diesen Kurs enthalten sind.',

   'Although a deleted group is no longer accessible, the group name used for the group will be reserved, and will not be available for assignment to a new group in the same course in the future.'
=> 'Auch wenn die gelöschte Gruppe nicht länger verfügbar sein wird, so bleibt der Gruppenname dennoch reserviert und steht für neue Gruppen im selben Kurs zukünftig nicht zur Verfügung.',

   'Delete group'
=> '删除组',

   'Group deletion failed because deletion of [_1] out of [_2] members failed.'
=> '删除组失败，因为[_1]的[_2]成员不能被删除。',

   'Group successfully deleted.'
=> '该组已成功删除。',

   "Although the group was deleted, an error occurred when removing the group's folder from the 'Course Groups' folder: [_1]"
=> "该组已被删除，从课程组的文件夹删除组文件夹时发生错误：[_1]",

   'Group deletion failed.'
=> '组删除失败。',

   'Course Folder -[_1]'
=> '课程文件夹 [_1]',

   'An error occurred when reading contents of parent folder to group:'
=> 'Beim Lesen des übergeordneten Verzeichnisses für die Gruppe ist ein Fehler aufgetreten:',

   'An error occurred when saving updated parent folder to group:'
=> 'Beim Speichern des aktualisierten übergeordneten Verzeichnisses für die Gruppe ist ein Fehler aufgetreten:',

   'You have requested enabling the previously deleted group [_1].'
=> 'Sie möchten die gelöschte Gruppe [_1] wiederherstellen.',

   'When a deleted group is re-enabled the following occurs:'
=> 'Beim Wiederherstellen einer gelöschten Gruppe passiert folgendes:',

   'Group settings and membership at the time the group was deleted are reinstated.'
=> 'Gruppen-Einstellungen und -Mitgliedschaften, die zum Zeitpunkt des Löschens dieser Gruppe bestanden, werden wieder hergestellt.',

   'A group folder is added to the "Course Groups" folder which contains folders for all groups in the course.'
=> 'Ein Gruppenverzeichnis wird dem "Kursgruppen"-Verzeichnis hinzugefügt, das Verzeichnisse aller Gruppen für diesen Kurs enthält.',

   'Reenable group'
=> '组恢复',

   'The group [_1] was not re-enabled, because it is not a deleted group.[_2]Perhaps it has already been re-enabled?'
=> 'Die Gruppe [_1] wurde nicht wiederhergestellt, da es nicht um eine gelöschte Gruppe handelt.[_2]Möglicherweise wurde sie zwischenzeitlich schon wiederhergestellt.',

   'No end date set'
=> '没有设定结束日期',

   'Membership reinstated for [quant,_1,user], each with start and end dates for group access set to defaults: [_2] and [_3]'
=> 'Die Mitgliedschaft wurde für [_quant,_1,Benutzer] wiederhergestellt, jeweils mit den voreingestellten Start- und Endedatumswerten dieser Gruppe: [_2] und [_3].',

   "Although the group was re-enabled, an error occurred when adding the group's folder to the 'Course Groups' folder: [_1]"
=> "Die Gruppe wurde zwar wiederhergestellt, beim Hinzufügen des Gruppen-Verzeichnisses zu dem 'Kursgruppen'-Verzeichnis ist jedoch ein Fehler aufgetreten: [_1]",

   'Re-enabling group failed.'
=> '重新启用组失败。',

   'with related words'
=> '相关的关键词',

   'with no related words'
=> '没有相关的关键词',

   'Change Roles Preferences'
=> '改变角色偏好',

   'Display [_1] Most Recent Roles'
=> '显示 [_1] 个最近角色',

   'Freeze Role'
=> '冻结角色',

   'Recent Roles Hotlist is Disabled'
=> '禁用最近使用角色的快速访问列表',

   'Recent Roles Hotlist is Enabled'
=> '启用最近使用角色的快速访问列表',

   'Author Space'
=> '作者空间',

   'Degree of discrimination'
=> '分化程度',

   'Disable WYSIWYG Editor'
=> '禁用WYSIWYG编辑器',

   'Hypertext Document'
=> 'HTML 文件',

   'Last Modifying User'
=> '上次修改用户',

   'Last Revision Date'
=> '最近修订日期',

   'Linked/Related Resources'
=> '联系/相关资源',

   'Network-wide courses using resource'
=> '网络上使用该课程资源',

   'Never'
=> '从不',

   'Preview'
=> '预览',

   'Resources that follow this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Nachfolger dieser Ressource sind',

   'Resources that lead up to this resource in maps'
=> 'Ressourcen, die in einer Inhaltszusammenstellung Vorläufer dieser Ressource sind',

   'Resources used by this resource'
=> 'Ressourcen, die von dieser Ressource verwendet werden',

   'Resources using or importing resource'
=> '资源使用或导入', #??? [SB 18.10.2006]

   'Return'
=> '后退',

   'Setting WYSIWYG editor to:'
=> 'WYSIWYG-编辑器设置为：',

   'Source Available'
=> '源代码可用',

   'Source Custom Distribution File'
=> '源代码的访问权限',

   'Start new page<br />before selected'
=> 'Start new page<br />before selected',

   'on'
=> '开',

   '(on)'
=> '(on)',

   'off'
=> '关',

   '(off)'
=> '(off)',

   '(re-initialize course to access)'
=> '(re-initialize course to access)',

   'All Parts'
=> 'Alle Teile',

   'Changes will become active for your current session after [_1], or the next time you log in.'
# => 'Um die Änderungen für die aktuelle Sitzung zu übernehmen, klicken Sie [_1] oder melden Sie sich neu an.',
# => '[_1] Hier klicken, um die letzten Änderungen sofort zu übernehmen.'
=> '点击 [_1] 按钮来保存最后的更改。',

   'Cut'
=> '剪切',

   'Random Order'
=> '任意顺序',

   'Due and Answer Available'
=> 'Fällig, Antwort verfügbar',

   'Edit any group in the course'
=> '课程分组管理',

   'Editing the Table of Contents for your Course'
=> '如何修改课程内容',

   'Enter any group in the course'
=> 'Einer beliebigen Gruppe des Kurses beitreten',

   'Existing Parameter Settings for Your Resources'
=> 'Bestehende Parameter-Einstellungen für Ihre Ressourcen',

   'Group'
=> '组',

   'Group:'
=> '组：',

   'Hidden'
=> '隐藏',

   'List Symbs'
=> '内部标识',

   'Symb List'
=> '内部标识名单',

#   'Manage Course Slots'
#=> '管理课程插槽',

   'Manage Slots'
=> 'Manage Slots',

   'Manage student enrollment '
=> '招生管理 ',

   'Modify Resource Parameters - Overview Mode'
=> '修改资源参数 - 概况模式',

   'Modify parameter settings (due dates, etc) for resources and the course'
=> '修改课程和资源参数',

   'Modify parameter settings for this resource'
=> '参数设置', # long version: 'Parametereinstellungen für diese Ressource ändern',
#=> 'Parametereinstellungen', # long version: 'Parametereinstellungen für diese Ressource ändern',


   'New and Existing Parameter Settings for Your Resources'
=> '为您的资源设置新的和现有的参数',

   'Parameter Change Log and Course Blog Posting/User Notification'
=> '参数变更记录和课程博客/用户通知',

   'Parameter Manager'
=> '参数管理',

   'Randomly Pick: '
=> '随机挑选： ',

   'Remove'
=> '删除',

   'Rendering:'
=> '检查:',

   'Select Parameters to View'
=> '选择想要查看的参数',

   'Select Parts to View'
=> '选择想要查看的部分',

   'Set Parameter Setting Default Actions'
=> '设置默认操作的参数',

   'Set Portfolio Metadata'
=> '设置元数据-组合',

   'Set/Modify Resource Parameters - Helper Mode'
=> '设置/修改资源参数 - 辅助模式',

   'Set/Modify Resource Parameters - Overview Mode'
=> '设置/修改资源参数 - 概况模式',

   'Set/Modify Resource Parameters - Table Mode'
=> '设置/修改资源参数 - 表模式',

   'Settings for Your Course'
=> '课程设置',

   'Table Mode'
=> '表模式',

   'Table Mode Parameter Setting'
=> '表模式参数设定',

   'The resources in "[_1]" are open for a limited time. Once you click the "[_2]" button below you have [_3] to complete all resources in "[_1]".'
=> 'Die Ressourcen in "[_1]" können nur zeitlich begrenzt bearbeitet werden. Sobald Sie auf "[_2]" klicken, haben Sie [_3], um alle Ressourcen in "[_1]" zu bearbeiten.',

   'URL hidden'
=> '隐藏 URL',

   'Update Parameter Display'
=> '更新参数',

   'View calculated grades (Spreadsheet)'
=> '计算评分（Spreadsheet）',

   "What's new?"
=> "有什么新的？",

   're-initializing Course'
=> '重新初始化课程',

   'Show Resource'
=> '查看资源',

   'Feedback to resource author'
=> '反馈给此资源的作者',


#

   'Click to add/remove attachments'
=> '单击添加/删除附件',

   'New attachments'
=> '新附件',

   'Retained attachments'
=> '保留附件',

   'Add a new attachment to this post.'
=> '给这个信息添加新的附件：',

   'Discussion Post Attachments'
=> '讨论张贴附件',


#

   'Modify course settings'
=> 'Kurs-Einstellungen',

   'Send and display broadcast e-mail'
=> 'Broadcast-E-Mails',

   'Awarded Total Points'
=> '达到总分',

   'Total Parts Done'
=> 'Gesamtanzahl erledigter Aufgabenteile',

   'Create a single course'
=> 'Einen neuen, einzelnen Kurs erstellen',

   'Create a new course by completing an online form.'
=> 'Einen neuen Kurs durch Ausfüllen eines Formulars erstellen.',

   'Create a single collaborative group space'
=> 'Einzelnen, kollaborativen Gruppenbereich erstellen',

   'Create a new group space for non-course use by completing an online form.'
=> 'Einen Gruppenbereich für die Verwendung außerhalb von Kursen durch Ausfüllen eines Formulars erstellen.',

   'Create courses/groups by uploading an attributes file'
=> 'Kurse/Gruppen durch Hochladen einer Attributedatei erstellen',

   'Upload an attributes file containing specifications for one or more courses or groups in XML format.'
=> 'Hochladen einer Attributedatei, die Spezifikationen für einen oder mehrere Kurse oder Gruppen im XML-Format enthält.',

   'current'
=> '当前的',


#
   'Version changes'
=> 'Versionsänderungen',

   'Change interval'
=> 'Intervall ändern',

   'Student Submission Reports'
=> 'Berichte studentischer Einreichungen',

   'Prepare reports of student submissions.'
=> 'Berichte zu den studentischen Einreichungen erstellen',

   'Survey Reports'
=> 'Umfrage-Berichte',

   'Prepare reports on survey results.'
=> 'Berichte zu Umfrage-Ergebnissen erstellen',

   'View survey'
=> 'Umfrage betrachten',

   'Previous Survey'
=> 'Vorherige Umfrage',

   'Next Survey'
=> 'Nächste Umfrage',

   'Choose a different Survey'
=> 'Andere Umfrage wählen',

   'Generate Report'
=> 'Bericht erstellen',

   'Part [_1], Response [_2]'
=> '部份 [_1], 答案 [_2]',

   'Foil Name'
=> 'Name der Auswahlmöglichkeit',

   'Foil Text'
=> 'Text der Auswahlmöglichkeit',

   'Percent'
=> '百分比',

   'Correct Problems Plot'
=> 'Richtige-Antworten-Diagramme',

   'Display a histogram of student performance in the course.'
=> 'Histogramm studentischer Kursleistungen anzeigen',

   'Access Status'
=> '访问状态',

   '[_1] Limit by time'
=> '[_1] 限制时间',

   'Submission Time Plots'
=> 'Einreichungszeit-Diagramme',

   'Currently Has Access'
=> '目前访问',

   'Will Have Future Access'
=> '将来的访问',

   'Previously Had Access'
=> '此前的访问',

   'Any Access Status'
=> '任易的访问状态',

   'Previous Problem'
=> '前面的问题',

   'Next Problem'
=> '下一个问题',

   'Choose a different Problem'
=> 'Eine andere Aufgabe auswählen',

   'Update Caches'
=> 'Cache aktualisieren',

   'Begin'
=> 'Beginn',

   'There are no students in the sections selected.'
=> 'In den gewählten Sektionen sind keine Studenten.',

   'There are no students in the sections/groups selected.'
=> 'In den gewählten Sektionen/Gruppen sind keine Studenten.',

   'There is no submission data for this problem at all.'
=> 'Für diese Aufgabe existieren keinerlei studentische Einreichungsdaten.',

   'There is no submission data for this problem.'
=> 'Für diese Aufgabe existieren keine studentischen Einreichungsdaten.',

   'There is no submission data for this resource.'
=> 'Für diese Ressource existieren keine Einreichungsdaten.',

   'There is no data to plot.'
=> 'Es existieren keine Daten, die geplottet werden könnten.',

   'Analysis of [_1] is not supported.'
=> 'Die Analyse von Aufgaben des Typs "[_1]" wird nicht unterstützt.',

   'None of the selected students attempted the problem more than [_1] times.'
=> 'Keiner der ausgewählten Studenten hat für die Aufgabe mehr als [_1] Versuche benötigt.',

   'None of the selected students attempted the problem.'
=> 'Keiner der ausgewählten Studenten hat die Aufgabe bearbeitet.',

   'The analysis you have selected is not supported at this time.'
=> 'Die von Ihnen ausgewählte Analyse wird derzeit nicht angeboten.',

   'Graph Problem Submission Times'
=> 'Graph Aufgaben-Einreichungszeiten',


#
   'Return to Directory'
=> '返回目录',

   'Return to directory'
=> '返回目录',


# 2007-06-15

   'My Roles'
=> '我的角色',

   'My Space'
=> '我的空间',

   'Edit blogs, RSS feeds, and podcasts'
=> '博客, RSS-反馈 和 播客',

   'Content Library'
=> '内容',

   'Search the contents of this course or accessible portfolio files'
=> '搜索这门课程的内容，或可组合文件',

   'Grading and Statistics'
=> '审查和统计',

   'Other'
=> '其他',

   'group'
=> '组',

   'Size'
=> '大小',

   'Current Access Status'
=> '目前获得状态',

   'Delete Checked Files'
=> '删除选中的文件',

   'Using the portfolio file list'
=> '使用组合的文件列表',

   'Help on the portfolio'
=> '组帮助',

   'Private'
=> '私人的',

   'Change How Menus are Displayed'
=> '改变菜单显示',

   'Use icons and text'
=> '使用图标和文本',

   'Use buttons and text'
=> '使用按钮和文本',

   'Use icons only'
=> '只有图标',

   'Previous Tries'
=> '以前的尝试',

   'Change Main Menu'
=> '改变主菜单',

   'New screenname (shown if you post anonymously)'
=> '新昵称（显示在匿名讨论中）',

   'New nickname (shown if you post non-anonymously)'
=> '新昵称（显示在正常讨论中）',

   'Choose the time window to use to display roles for which access to the course expired.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die in diesem Kurs abgelaufen sind',

   'Choose the time window to use to display roles for which access to the course became available.'
=> 'Auswahl des Zeitfensters zur Anzeige von Rollen, die diesem Kurs zugeteilt sind',

   'Choose the time window to use to display resources in the course with version changes.'
=> '选择的时间窗口，显示课程资源与版本变化。',

   'User Management'
=> '用户管理',

   'Manage student enrollment'
=> '招生管理',

   'Modify an existing group'
=> '修改现有的组',

   'Delete an existing group'
=> '删除现有的组',

   'Re-enable a deleted group'
=> '还原已删除的组',

   'Enter an existing group'
=> '加入现有的组',

   'Course Management'
=> '课程管理',

   'Reset Student Access Times'
=> '重置学生的访问时间',

   'Submission #'
=> '回答次数',

   'Try'
=> '尝试',

   'Try [_1]'
=> '尝试 [_1]。',

   'Submitted Answer'
=> '提交答案',

   'Close Window'
=> '关闭窗口',

   'Close window'
=> '关闭窗口',

   'Portfolio Search'
=> '组合搜索',

   'Enter words and quoted phrases'
=> '输入字词和引用短语',

   'Portfolio and Course Search'
=> '组合及课程搜寻',

   'Message Status'
=> '邮件状态',

   'Any'
=> '任意的',

   'Unread'
=> '未阅读',

   'Read'
=> '已阅读',

   'Replied to'
=> '回复',

   'Forwarded'
=> '转发',

   'Rename Folder'
=> '重命名文件夹',

   'Delete Folder'
=> '删除文件夹',

   'Recent Roles'
=> '最近的角色',

   'Close navigation window'
=> '关闭导航窗口',

   'Post Anonymous'
=> '匿名发送',

   'Post'
=> '发送',

   'Back to preferences menu'
=> '后退',

   'Forwarding Address(es)'
=> '转发地址',

   'e.g. <tt>userA:domain1,userB:domain2,...</tt>'
=> '例如 <tt>用户A:领域1,用户B:领域2,...</tt>',

   'Notification E-mail Address(es)'
=> '通知 E-mail 地址',

   'E-mail Address(es) which should be notified about new LON-CAPA messages'
=> '关于 LON-CAPA 新消息被通知的 E-Mail 地址',

   'e.g. <tt>joe@doe.com</tt>'
=> '例如 <tt>xiaoming@sohu.com</tt>',

   'Notification address'
=> '通知地址',

   'Types of message for which notification is sent'
=> '发出应该被通知的信息',

   'Excerpt retains HTML tags in message'
=> '在邮件中保持 HTML',

   'All'
=> '所有的',

   'Critical only'
=> '只重要的',

   'Non-critical only'
=> '非重要的',

   'Add new address'
=> '添加新的地址',

   'What are forwarding and notification addresses?'
=> '什么是转发和通知地址?',

   'What are critical messages?'
=> '什么是重要的信息?',

   'Change Roles Page Pref'
=> '用户角色快速访问列表',

   'Number of Roles in Hotlist:'
=> '一些角色的快速访问列表:',

   'Current Password'
=> '当前密码',

   'New Password'
=> '新密码',

   'Confirm Password'
=> '新密码确认',

   'Passwords must be a minimum of 7 characters long. Please try again.'
=> '密码必须至少有7个字符长。请再试一次。',

   'The new passwords you entered do not match. Please try again.'
=> '新的密码输入不匹配。请再试一次。',

   'Please make sure your old password was entered correctly.'
=> '请确认您的旧密码输入正确。',

   'Send me a message'
=> '请给我发送邮件',

   'Show Public View'
=> '查看公众视野',

   'Delete Photo'
=> '删除照片',

   'Help with filling in text boxes'
=> '文本框输入帮助',

   'Examples'
=> '例子',

   'Summary Preview'
=> '摘要预览',

   'Send copy to permanent email address (if known)'
=> '发送副本到其它的电子邮件地址 (如果已知)',

   'Include in course RSS newsfeed'
=> '包括课程的 RSS-Feeds',

   'Allow replies:'
=> '允许答复:',

   'Reply to:'
=> '回复:',

   'Domain Management'
=> '域管理',

   'Course ID of Key Authority:'
=> 'Kurs-ID des Schlüsselmeisters:',

   'Set domain configuration'
=> '域配置',

   'Domain Configuration'
=> '域配置',

   'View/Modify Domain Settings'
=> '查看/修改域配置',

   'Menu'
=> '菜单',

   'Domain Settings'
=> '域配置',

   'Course Environment'
=> '课程环境',

   'Edit Course Environment'
=> '编辑课程环境',

   'Users allowed to clone course'
=> 'Benutzer, die berechtigt sein sollen, diesen Kurs zu klonen',

   'Users with active Course Coordinator role in this course are permitted to clone and need not be included.'
=> 'Benutzer mit aktiver Kurs-Koordinatoren-Rolle zu diesem Kurs haben automatisch das Recht zum Klonen und brauchen daher hier nicht eingetragen werden.',

   'Use [_1] to allow course to be cloned by anyone in the specified domain.'
=> '[_1] gestattet jedem in der angegebenen Domäne diesen Kurs zu klonen.',

   'Use [_1] to allow unrestricted cloning in all domains.'
=> '[_1] gestattet jedem aller Domänen diesen Kurs zu klonen.',

   'URL of Syllabus (not using internal handler)'
=> '教学大纲的网址 (URL)',

   'Custom Text for Resource Content Question Option in Feedback'
=> 'Eigener Text für Ressourcen-Inhaltsfragen-Option beim Feedback',

   'Custom Text for Course Content Option in Feedback'
=> 'Eigener Text für Kursinhalts-Option beim Feedback',

   'Custom Text for Course Policy Option in Feedback'
=> 'Eigener Text für Kursrichtlinien-Option beim Feedback',

   'Allow students to view classlist.'
=> 'Studenten erlauben, die Kursteilnehmerliste einzusehen',

   'Allow users with specified roles to edit/delete their own discussion posts'
=> 'Erlaube Benutzern mit folgenden Rollen, ihre eigenen Diskussionsbeiträge zu editieren/löschen',

   'Suppress number of tries in printing'
=> 'Beim Druck Angabe der Anzahl der Versuche auslassen',

   'Default paper type'
=> 'Standard-Papierformat',

   'Default beginning date for student access.'
=> '学生访问的默认开始日期',

   'Default ending date for student access.'
=> '学生访问的默认结束日期',

   'Disable checking of Significant Figures'
=> 'Überprüfung signifikanter Stellen deaktivieren',

   'Disable automatically printing point values onto exams.'
=> 'Automatisches Drucken von Punkten auf Prüfungen deaktivieren',

   'Send message to student when clicking Done on Tasks'
=> 'Nachricht an Studenten versenden, wenn diese auf "Erledigt" in ihren Übungen klicken', # ???

   'Restrict Metadata'
=> '限制数据',

   'Show to student'
=> 'dem Studenten zeigen',

   'Provide text area for students to type metadata'
=> 'dem Studenten Textfeld anbieten, um Metadaten eingeben zu können',

   'Provide choices for students to select from'
=> 'dem Studenten Auswahl anbieten, um wählen zu können aus',

   'Student may select multiple choices from list'
=> 'Mehrfachauswahl aus Liste erlauben',

   'Student may select only one choice from list'
=> 'Nur eine Auswahl aus der Liste erlauben',

   'Add a Metadata Field'
=> 'Ein Metadatenfeld hinzufügen',

   'Order Metadata Fields'
=> 'Order Metadata Fields',

   'Continue Import'
=> 'Import fortsetzen',

   'Continue Search'
=> 'Suche fortsetzen',

   'Finish Import'
=> 'Import abschließen',

   'Include'
=> 'Einbinden',

   'LON-CAPA Catalog Search'
=> 'LON-CAPA 目录搜索',

   '[_1] include external resources'
=> '[_1] externe Ressourcen mit einbeziehen',

   'Change Course Initialization Preference'
=> '课程初始化设置',

   'Change Course Init. Pref.'
=> '课程初始化设置',

   'Reset Access Times'
=> 'Studentische Zugriffszeiten zurücksetzen',

   'Select Scope'
=> 'Bereich wählen',

   'Reset times on one or more folders/maps for a single student.'
=> 'Zeiten in einem/r oder mehreren Verzeichnissen/Inhaltszusammenstellungen für einen einzelnen Studenten zurücksetzen',

   'Reset times on a single folder/map for a section or whole clase.'
=> 'Zeiten für ein(e) einzelne(s) Verzeichnis/Inhaltszusammenstellung für eine Sektion oder einen gesamten Kurs zurücksetzen',

   'Choose a student:'
=> '选择一个学生：',

   'Select Currently Enrolled Students and Active Course Personnel'
=> 'Wahl derzeit eingeschriebener Studenten oder aktiven Kurspersonals',

   'This is a list of first access times and what was accessed, please select those you want deleted.'
=> 'Hier ist eine Liste der Erstzugriffszeiten und das, auf was zugegriffen wurde. Bitte wählen Sie aus, welche gelöscht werden sollen.',

   'Select:'
=> '选择:',

   'All Course Personnel'
=> '所有课程人员',

   'No Section'
=> 'No Section',

   'Unselect'
=> '取消',

   'Select a folder/map'
=> '选择目录/内容列表',

   'Will remove access times for'
=> 'Werde Zugriffszeiten entfernen für',

   'from users'
=> 'von Benutzern',

   'No Access times found for student'
=> 'Keine Zugriffszeit gefunden für Student',

   'Finish'
=> 'Abschließen',

   'Name of New Folder'
=> '新建文件夹的名称',

   'Name of New Page'
=> '新组合页面的名称',

   'New Page'
=> '新组合页面',
#=> 'Neue zusammengesetzte Seite',

   'WARNING: Removing a resource makes associated grades and scores inaccessible!'
=> 'Achtung: Das Entfernen der Ressource macht die damit verknüpften Bewertungen und Punkte unerreichbar!',

   'Clipboard'
=> 'Zwischenablage',

   'Remove[_99]'
=> 'Soll[_99]',

   '?[_99]'
=> 'wirklich entfernt werden?',

   'WARNING: Cutting a resource makes associated grades and scores inaccessible!'
=> 'Achtung: Das Ausschneiden der Ressource macht die damit verknüpften Bewertungen und Punkte unerreichbar!',

   'Grades remain inaccessible if resource is pasted into another folder.'
=> 'Die Bewertungen bleiben unerreichbar, auch wenn die Ressource in einem anderen Verzeichnis eingefügt wird.',

   'Cut[_98]'
=> 'Soll[_98]',

   '?[_98]'
=> 'wirklich ausgeschnitten werden?[_98]',

   'Paste'
=> 'Einfügen',

   'This screen shows how many problems (or problem parts) you have completed, and how many you have not yet done. You can also look at [_1]a detailed score sheet[_2].'
=> 'Diese Seite zeigt Ihnen, wie viele Aufgaben (oder Aufgabenteile) Sie vollständig beantwortet und wie viele Sie noch nicht bearbeitet haben. Sie können sich auch eine [_1]detailierte Punktetabelle[_2] anzeigen lassen.',

   'This may take a few moments to display.'
=> '计算需要几分钟的时间。',

   'Detailed Citation Preview'
=> '详细引文预览',

   'related words'
=> '相关词',

   'Any domain'
=> '任何域',

   'Reset'
=> '重置',

   'MIME Type Category'
=> 'MIME 类型分类',

   'Domains'
=> '域',

   'Custom Metadata fields'
=> '自定义元数据字段',

   'Field Name'
=> '域名',

   'Field Value(s)'
=> '域值',

   'Another custom field/value pair?'
=> '其他自定义字段/值配对？',

   'Creation and Modification dates'
=> '建立与修改日期',

   'Created between'
=> '创建时间',

   'Last modified between'
=> '上次修改时间',

   'Standard Portfolio Metadata'
=> '标准的元数据组合',

   'Advanced Portfolio Search'
=> '高级组合搜索',

   'Standard Catalog Metadata'
=> '标准目录元数据',

   'Problem Statistics'
=> '问题统计',

   'Statistics calculated for number of students'
=> '统计计算出以下的学生人数',

   'Portfolio and Catalog Search'
=> '搜索文件夹和目录',

# 2007-06-22
   'Search the database of accessible portfolio files'
=> 'Datenbank der Portfolio-Dateien',

   'Construction Space:'
=> 'Konstruktionsbereich:',

   'Problem Status:'
=> '问题状态:',

   'Problem Type:'
=> '问题类型:',

   'Feedback Mode:'
=> '反馈模式:',

   'Answer for Part: [_1]'
=> 'Antwort für Teil [_1]',

   'Script Vars'
=> 'Skript-Variablen',

   'Regular file'
=> 'Reguläre Datei',

   'Testbank file'
=> 'Testbank-Datei',

   'IMS package'
=> 'IMS-软件包',

   'There are unsaved changes'
=> 'Es liegen ungespeicherte Änderungen vor!',

   'Found no analyzable responses in this problem. Currently only Numerical, Formula and String response styles are supported.'
=> 'Keine analysierbaren Antwortblöcke in der Aufgabe gefunden. Derzeit werden nur numericalresponse, formularesponse und stringresponse unterstützt.',

   'Active Link'
=> '活动链接',

   'Font'
=> '字体',

   'Un-Visited Link'
=> '未访问过的链接',

   'Page Background'
=> '网页背景',

   'Header Border'
=> '标题边框',

   'Header Background'
=> '标题背景',

   'Visited Link'
=> '访问过的链接',

   'Change Custom Colors'
=> '更改自定义颜色',

   'Reset All'
=> '所有颜色重置为默认颜色',

   'Save and Edit'
=> '保存并继续编辑',

   'Save and View'
=> '保存和查看',

   'Check Spelling'
=> '拼写检查',

   'Selecting a Course'
=> '选择课程',

   'Course Activity:'
=> 'Letzte Kursaktivität:',

   'Course Domain:'
=> 'Kurs-Domäne:',

   'Course Institutional Code:'
=> 'Kurs-Instituts-Code:',

   "Course Owner's Username:"
=> 'Benutzerkennung des Kurs-Eigentümers:',

   "Course Owner's Domain:"
=> 'Domäne des Kurs-Eigentümers:',

   'LON-CAPA course ID:'
=> 'LON-CAPA 课程 ID：',

   'Course Description'
=> '课程简介',

   'Resource Space Home'
=> '资源空间主页',

   'Default start and end dates for student access'
=> 'Voreingestelltes Anfangs- und Endedatum für studentischen Zugriff',

   'Notification to domain coordinator via LON-CAPA message when enrollment changes occur during the automated update?'
=> 'Soll LON-CAPA den <b>Domänen-Koordinator</b> benachrichtigen, wenn während der automatischen Aktualisierung Änderungen an der Kursbelegung auftreten?',

   'Course Group Settings'
=> '课程组设置',

   'Set a quota for the total disk space available for storage of course group
portfolio files.'
=> 'Verfügbarer Gesamtspeicherplatz für Portfolio-Dateien für alle Kursgruppen dieses Kurses:',

   'Creation Options'
=> '创建选项',

   ' Creation Settings'
=> ' 创建设置',

   'Creation Outcome'
=> '创作成果',

   'New LON-CAPA course ID:'
=> '新的 LON-CAPA 课程 ID:',

   'Created on'
=> '创建于',

   'Cloning course from'
=> 'Kurs geclont aus Domäne',

   'Setting environment'
=> 'Einstellung der Kursumgebung',

   'Opening all assignments'
=> 'Start aller Übungen',

   'Setting first resource'
=> 'Einstellung der ersten Ressource',

   'Assigning role of [_1] Coordinator to [_2] at [_3]: '
=> 'Zuweisung der Rolle des [_1]-Koordinators an [_2] in [_3]: ',

   'Roles will be active at next login'
=> 'Rollen werden ab dem nächsten Login aktiv sein',

   'Active at next login.'
=> 'Beim nächsten Login aktiv. ',

   'Expired after logout.'
=> 'Nach dem Abmelden abgelaufen.',

   'No new course created.'
=> 'Der Kurs wurde nicht erstellt.',

   'A new course could not be cloned from the specified original - [_1] - because it is a non-existent course.'
=> 'Ein neuer Kurs kann nicht von dem angebenen Originalkurs ([_1]) geklont werden, da dieser Kurs nicht existiert.',

   'The new course could not be cloned from the existing course because the new course owner ([_1]) does not have cloning rights in the existing course ([_2]).'
=> 'Der neue Kurs kann nicht von dem angebenenen Kurs geklont werden, da der neue Kurseigentümer ([_1]) nicht die Berechtigung erteilt bekommen hat, den existierenden Kurs ([_2]) zu klonen.',

   'Create Another [_1]'
=> 'Einen weiteren [_1] anlegen',

   'from domain'
=> 'aus der Domäne',

   'Submit Evaluation'
=> '提交评价',

   'Standard Problem'
=> '标准问题',

   'Practice'
=> 'Übung',

   'Exam'
=> 'Prüfung',

   'Survey'
=> '调查',

   'Library'
=> '图书馆',

   'Value:'
=> 'Wert:',

   'String Value'
=> 'Text-Wert',

   'practice'
=> 'Übung',

   'Loading Domain Coordinator Menu'
=> 'Lade Domänen-Koordinator-Menü...',

   "Disk space allocated to user's portfolio files"
=> "Speicherplatz für Portfolio-Dateien des Benutzers",

   'Current quota'
=> '目前的配额',

   'For this user, the default quota is [_1] Mb.'
=> '此用户的默认配额是 [_1] MB。',

   'Change quota'
=> '更改配额',

   'Custom quota'
=> '自定义配额',

   'Existing sections'
=> '现有的章节',

   'Define new section'
=> '创建新的章节',

   'Create/Modify Another User'
=> '创建/修改另一个用户',

   'Set Privileges for New User'
=> '设置新用户的权限',

   'Generating user'
=> '生成用户',

   'Generating user: [_1]'
=> '生成用户： [_1]',

   'Home server'
=> 'Heimatserver',

   'Home server: [_1]'
=> 'Heimatserver: [_1]',

   'Modifying Roles'
=> '修改角色',

   'No roles to modify'
=> '没有角色修改',

   'starting'
=> '开始',

   'Add to classlist:'
=> '添加到学生名册：',

   'Change Current Login Data'
=> 'Derzeitige Login-Einstellung ändern',

   'Enter New Login Data'
=> 'Neue Login-Einstellungen',

   'will override current values'
=> 'überschreibt derzeitigen Wert',

   'Set a quota for the total disk space available for storage of course group portfolio files.'
=> 'Verfügbarer Gesamtspeicherplatz für Portfolio-Dateien für alle Kursgruppen dieses Kurses:',

   'Section Numbers and corresponding LON-CAPA section IDs'
=> 'Sektionsnummern und korrespondierende LON-CAPA-Sektions-IDs',

   'Overall Assessment Statistical Data'
=> '总体评价统计数据',

   'No new dynamic data found.'
=> '没有发现新的动态数据。',

   'Current value is'
=> 'Aktuelle Einstellung ist',

   'Interval set to version changes [_1]'
=> 'Intervall auf Versionsänderungen [_1] gesetzt',

   'Creating a new problem resource.'
=> 'Neue Aufgabe erstellen',

   'Creating a new library resource.'
=> 'Neue Bibliothiek erstellen',

   'Creating a new survey resource.'
=> 'Neue Umfrage erstellen',

   'Creating a new task resource.'
=> 'Neue "bridgetask"-Datei erstellen',

   'The requested file [_1] currently does not exist.'
=> 'Die angeforderte Datei [_1] existiert momentan nicht.',

   'To create a new problem, select a template from the list below. Then click on the "Create problem" button.'
=> 'Um eine neue Aufgabe zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Aufgabe erstellen"-Button.',

   'To create a new library, select a template from the list below. Then click on the "Create library" button.'
=> 'Um eine neue Bibliothek zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Bibliothek erstellen"-Button.',

   'To create a new survey, select a template from the list below. Then click on the "Create survey" button.'
=> 'Um eine neue Umfrage zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "Umfrage erstellen"-Button.',

   'To create a new task, select a template from the list below. Then click on the "Create task" button.'
=> 'Um eine neue "bridgetask"-Datei zu erstellen, wählen Sie eine Vorlage aus der unten angebotenen Liste. Klicken Sie dann auf den "bridgetask-Datei erstellen"-Button.',

   'Accessibility Options'
=> 'Alternativ-Login',

   'About LON-CAPA'
=> '关于 LON-CAPA',
#=> 'Über LON-CAPA',

   'Course Catalog'
=> '课程目录',
#=> 'Kursübersicht',

   'If you were expecting to see an active role listed for a particular course in the [_1] domain, it may be missing for one of the following reasons:'
=> 'Falls Sie eine aktive Rolle für einen bestimmten Kurs in der Domäne "[_1]" erwartet haben, könnte es sein, dass diese aus einem der folgenden Gründe fehlt:',

   'The course has yet to be created.'
=> 'Der Kurs wurde noch nicht erstellt.',

   'Automatic enrollment of registered students has not been enabled for the course.'
=> 'Die automatische Kursbelegung registrierter Studenten wurde für diesen Kurs nicht aktiviert.',

   'You are in a section of course for which automatic enrollment in the corresponding LON-CAPA course is not active.'
=> 'Sie sind in einer Sektion des Kurses, für die die automatische Kursbelegung im zugehörigen LON-CAPA-Kurs nicht aktiviert ist.',

   'You registered for the course recently and there is a time lag between the time you register, and the time this information becomes available for the update of LON-CAPA course rosters.'
=> 'Sie haben sich kürzlich für den Kurs registriert und es gibt eine Zeitverzögerung zwischen der Zeit Ihrer Registrierung und dem Erscheinen dieser Information in der LON-CAPA-Kursteilnehmerliste.',

   'If you were expecting to see an active role listed for a particular course, that course may not have been created yet.'
=> 'Falls Sie eine aktive Rolle für einen bestimmten Kurs erwartet haben, könnte es sein, dass diese noch nicht erstellt wurde.',

   'The [_1]Course Catalog[_2] provides information about all [_3] classes for which LON-CAPA courses have been created.' # [_3]: domain
=> 'Die [_1]Kursübersicht[_2] enthält Informationen über alle Kurse der Domäne [_3], für die LON-CAPA-Kurse eingerichtet wurden.',

   'You can search the course catalog for courses which permit self-enrollment, if you would like to enroll in a course.'
=> 'Falls Sie einen Kurs belegen möchten, können Sie die Kursübersicht nach Kursen durchsuchen, die eine Selbsteintragung zulassen.',

   'User Authentication'
=> 'Benutzer-Authentifizierung',

   'Log-in Help'
=> '登录帮助',

   'Forgot password?'
=> '忘记密码？',

   'New User?'
=> '新用户？',

   'Crosslisted'
=> 'querverwiesen',

   'Owner'
=> 'Eigentümer',

   'Code'
=> 'Kurscode',

   'Course listing'
=> '课程目录',
#=> 'Kursübersicht',

   'Course Listing'
=> '课程目录',
#=> 'Kursübersicht',

   'Display information about official [_1] classes for which LON-CAPA courses have been created:'
=> 'Informationen zu offiziellen Kursen der [_1], für die LON-CAPA-Kurse eingerichtet wurden',

   'help/support'
=> 'Hilfe und Support',

   'Ask helpdesk'
=> 'Anfrage an Helpdesk abschicken',

   'Back to last location'
=> 'Zurück zum letzten Ort',

   'Note'
=> '注意',

   'Note:'
=> '注意：',

   'Student questions about course content should be directed to the course instructor'
=> 'Studentische Fragen zum Kursinhalt richten Sie bitte direkt an den Dozenten des Kurses',

   'Submit Request'
=> 'Anfrage abschicken',

   'E-mail address'
=> 'E-Mail 地址',

   'Enter the username you use to log-in to LON-CAPA, and your domain.'
=> 'Geben Sie Ihre LON-CAPA-Benutzerkennung ein und wählen Sie Ihre Domäne.',

   'URL of page'
=> '该页的网址',

   'Phone'
=> '电话',

   'Course Details'
=> 'Kursdetails',

   'Enter institutional course code'
=> 'Kurs-Instituts-Code',

   'Enter course title'
=> 'Kurstitel',

   'Section Number'
=> 'Sektionsnummer',

   'Detailed Description'
=> '详细说明',

   'Clear Form'
=> '重置表',

   'Material presented in clear way'
=> '这些材料中提出一个明确的方式',

   'Material covered with sufficient depth'
=> '这些材料包括有足够的深度',

   'Material is helpful'
=> '这些材料是有用的',

   'Material appears to be correct'
=> '这些材料似乎是正确的',

   'This will only retrieve the resource. If you want to retrieve the metadata, you will need to do that separately.'
=> 'Die Aktion wird lediglich die Ressource selbst wiederherstellen. Möchten Sie auch eine alte Version der Metadaten zu dieser Ressource wiederherstellen, müssen Sie dies extra tun.',

   'is in this state due to author settings.'
=> 'befindet sich aufgrund von Einstellungen des Autors temporär in diesem Zustand.',

   'User Data for'
=> 'Benutzerdaten von',

   'Email Address'
=> 'E-Mail地址',

   'Enroll Student'
=> '注册学生',

   'If active, the new role will be available when the student next logs in to LON-CAPA.'
=> 'Falls bereits aktiv, wird die Rolle ab dem nächsten Login für den Studenten verfügbar sein.',

   'Enroll another student'
=> '注册另一名学生',

   'Enroll Another Student'
=> '注册另一名学生',

   'start date'
=> '开始日期',

   'end date'
=> '结束日期',

   'active groups'
=> '活跃的组',

   'active group(s)'
=> '活跃的组',

   "Select a user name to view the user's personal page."
=> "选择一个用户名，以查看此用户的个人网页。",

   'View recent activity by this student'
=> '最后处于活动状态的人',

   'View recent activity'
=> '查看最近活动',

   'Recent activity of [_1]'
=> '最后处于活动状态的 [_1]',


   'Compiling student activity data can take a long time. Your request continues to be processed while results are displayed.'
=> 'Das Zusammenstellen der Aktivitätsdaten kann eine Weile dauern. Ihre Anfrage wird weiter verarbeitet, während die schon vorhandenen Ergebnisse bereits angezeigt werden.',

   'Composing Query'
=> 'Stelle Anfrage zusammen',

   'Student Activity'
=> 'Studentische Aktivitäten',

   'Waiting up to [_1] seconds for results'
=> 'Warte noch maximal [_1] Sekunden auf Ergebnisse',

   'Activity data compiled up to [_1]'
=> 'Aktivitätsdaten zusammengestellt bis [_1]',

   'While data is processed, periodically reload this page for more recent activity'
=> 'Während die Daten verarbeitet werden, können Sie gelegentlich die Seite aktualisieren, um aktuellere Aktivitätsdaten zu erhalten.',

   'Data'
=> 'Daten',

   'Resubmit last request to check for newer data'
=> 'Letzte Anfrage erneut abschicken, um auf aktuellere Daten zu prüfen',

   'View Classlist'
=> 'Kursteilnehmerliste anschauen',

   'Count'
=> 'Zähler',

   'Modifying authentication:'
=> 'Ändere Authentifizierung:',

   'Modify User Privileges'
=> 'Benutzerrechte anpassen',

   'Insert:'
=> 'Einfügen:',

   'Delete?'
=> 'Löschen?',

   'Randomize Foil Order:'
=> 'Reihenfolge der Auswahlmöglichkeiten randomisieren:',

   'Use template:'
=> 'Vorlage verwenden:',

   'Display Direction'
=> 'Anzeige-Richtung:',

   'vertical'
=> 'vertikal',

   'horizontal'
=> 'horizontal',

   'Script'
=> 'Skript-Block', # n.t.

   'Problem Editing'
=> '问题编辑',

   'Hint'
=> '提示', # n.t.

   'Show hint even if problem Correct:'
=> 'Hinweis auch zeigen, wenn Aufgabe richtig beantwortet wurde:',

   'Single Line Text Entry Area'
=> 'Zeile mit Texteingabefeld', # n.t.

   'Parameters for a response'
=> 'Parameter für Antworttyp', # n.t.

   'Problem Part'
=> '问题部分', # n.t.

   'Part ID:'
=> '问题部分编号：',

   'Displayed Part Description:'
=> 'Anzuzeigende Aufgabenteil-Beschreibung:',

   'Readonly:'
=> 'Nur lesbar:', # n.t.

   'Response: Numerical'
=> 'Antwortblock: numerisch', # n.t.

   'random'
=> 'zufällig',

   'top'
=> 'am Anfang',

   'bottom'
=> 'am Ende',

   'Add new Option:'
=> 'Option hinzufügen:',

   'Delete an Option:'
=> 'Option löschen:', # n.t.

   'Print options:'
=> 'Ausgabe der Optionen:',

   "Don't show option list"
=> "Optionsliste nicht anzeigen", # n.t.

   'Display of options when printed'
=> 'Anzeigeart der Optionen beim Druck',

   'Normal list'
=> 'Normale Liste',

   'Listed in vertical column'
=> 'In senkrechter Spalte aufgelistet',

   'Multiple Option Response Question'
=> 'Antwortblock: Optionsauswahl',

   'Select Options'
=> 'Wählbare Optionen', # n.t.

   'Image'
=> 'Bild', # n.t.

   'Image Url:'
=> 'URL des Bildes:',

   'width (pixel):'
=> 'Breite (Pixel):',

   'height (pixel):'
=> 'Höhe (Pixel):',

   'Alignment:'
=> 'Ausrichtung:', # n.t.

   'Encrypt URL:'
=> 'URL verschlüsseln:', # n.t.

   'no'
=> 'nein',

   'Location:'
=> 'Stelle:', # n.t.

   'Randomly labeled image'
=> 'Dynamisch beschriftetes Bild', # n.t.

   'Response: Click on Image'
=> 'Antwortblock: Klick-ins-Bild', # n.t.

   'Collection of Imageresponse foils'
=> 'Sammlung von Bildantwort-Auswahlmöglichkeiten', # n.t.

   'Image response foil'
=> 'Bildantwort-Auswahlmöglichkeit', # n.t.

   'Enter Coordinates' # n.t.
=> 'Koordinaten festlegen',

   'Rectangle'
=> 'Rechteck', # n.t.

   'Coordinate Pairs'
=> 'Koordinatenpaar',

   'Polygon'
=> 'Polygon',

   'Coordinate list'
=> 'Koordinatenliste', # n.t.

   'Create Polygon Data'
=> 'Polygon-Daten festlegen', # n.t.

   'Task Description'
=> '问题描述', # n.t.

   'Clickable Image'
=> 'Klickbares Bild', # n.t.

   'Image Source File'
=> 'Pfad und Name der Bilddatei', # n.t.

   'Select Position on Image'
=> 'Auswahl der Position im Bild',

   'Select First Coordinate on Image'
=> 'Klicken Sie an die Stelle der ersten Koordinate',

   'Select Second Coordinate on Image'
=> 'Klicken Sie an die Stelle der zweiten Koordinate',

   'Select Finish to save selection'
=> 'Klicken Sie auf Abschließen zum Abschließen der Aktion oder auf Abbrechen zum Abbrechen',

   'Enter Coordinate or click finish to close Polygon'
=> 'Klicken Sie in das Bild, um die Koordinaten für das Polygon festzulegen',

   'Click to select a Coordinate or click Finish to save current selection'
=> 'Klicken Sie in das Bild, um Koordinaten festzulegen',

   'New Name'
=> 'Neuer Dateiname',

   'Make Obsolete'
=> 'Als überholt markieren',

   'Set Margins'
=> 'Seitenränder festlegen',

   'How should each column be formatted?'
=> 'Wie soll jede Spalte formatiert werden?', # n.t.

   'Width:'
=> '宽：', # n.t.

   'Height:'
=> '高：', # n.t.

   'Left Margin:'
=> 'Linker Rand:', # n.t.

   'Username and/or password could not be authenticated.'
=> '用户名和（或）密码无法验证。',

   'Please check the username and password.'
=> '请检查您的用户名和密码。',

   'Try again'
=> '再试一次',

   'Information needed to verify your login information is missing, inaccessible or expired.'
=> '验证您的登录的信息丢失，无法进入或已经过期。',

   'Sending'
=> '发送中',

   'Completed.'
=> '邮件已发送。',

   'Messages being sent.'
=> '邮件被发送。',

   'showing messages'
=> '浏览邮件',

   'Assigning'
=> 'Zuweisung der Rolle',

   'ending'
=> 'Ende am',

   'Assistant Co-Author'
=> 'Co-Autor-Assistent',

   'Metadata for [_1]'
=> 'Metadaten für [_1]',

   'There are [_1] matches to your query.'
=> '有 [_1] 匹配您的查询。',

   'There were no results matching your query.'
=> 'Ihre Suche hat keine Treffer ergeben.',

   'Revise search'
=> '修改搜寻',

   'Internal Error - Bad view selected.'
=> 'Interner Fehler - ungültige Ansicht ausgewählt',

   'Unable to save import results.'
=> 'Eingelesene Ergebnisse konnten nicht gespeichert werden.',

   'A MySQL error has occurred.'
=> 'Ein MySQL-Fehler ist aufgetreten.',

   'Number of accesses'
=> 'Anzahl der Zugriffe',

   'Ascending'
=> '上升的',

   'Descending'
=> '下降的',

   'Students Attempting'
=> 'Studentische Versuche', # ??? [SB 2007-07-03]

   'Average Number of Tries'
=> 'Durchschnittliche Anzahl an Versuchen',

   'Mean Degree of Difficulty'
=> 'Durchschnittlicher Schwierigkeitsgrad',

   'Mean Degree of Discrimination'
=> 'Durchschnittlicher Grad der Abgrenzung',

   'Evaluation: Clear'
=> 'Evaluierung: Klar',

   'Evaluation: Technically Correct'
=> 'Evaluierung: Technisch korrekt',

   'Evaluation: Material is Correct'
=> 'Evaluierung: Material ist korrekt',

   'Evaluation: Material is Helpful'
=> 'Evaluierung: Material ist hilfreich',

   'Evaluation: Material has Depth'
=> 'Evaluierung: Tiefe des Themas',

   'Prev'
=> '上一个',

   'Reload'
=> '重新加载',

   'Results [_1] to [_2] out of [_3]'
=> '结果 [_1] 至 [_2] 的 [_3]',

   'Unactionable Search Queary'
=> '查询被否决',

   'Revise Search Request'
=> '修改搜索请求',

   'LON-CAPA Access Control'
=> 'LON-CAPA 访问控制',

   'Access  : '
=> '访问  ： ',

   'Resource: '
=> '资源： ',

   'Action  : '
=> 'Aktion   : ',

   'You have modified your course recently, [_1] may fix this access problem.'
=> 'Sie haben den Kurs kürzlich verändert. [_1] könnte das Zugriffsproblem beheben.',

   'Published on ...'
=> 'Veröffentlicht am...',

   'Currently published version'
=> 'Derzeit veröffentlichte Version',

   'Edit Metadata'
=> 'Metadaten ändern',

   'Cleanup XML Document'
=> 'XML-Code aufräumen',

   'Select actions to attempt:'
=> '选择所需的行动:',

   'Linefeeds, formfeeds, and carriage returns'
=> 'Zeilenumbrüche (LF), Seitenvorschübe und "Wagenrückläufe" (CR)',

   'Empty tags'
=> 'Leere Tags',

   'Lower casing'
=> 'Kleinschreibung',

   'Symbol font'
=> 'Symbolischer Zeichensatz', # ??? [SB 2007-07-03]

   'Cleanup'
=> 'Aufräumen',

   'Back to Source File'
=> 'Zurück zur Quelldatei',

   'Hypertext Cascading Style Sheet'
=> 'Stylesheet-Datei',

   'Online Survey'
=> 'Umfrage',

   'Unable to find [_1]'
=> 'Die Datei [_1] konnte nicht gefunden werden.',

   'Post Server Announcements'
=> 'Server-Bekanntmachungen',

   'Post announcements to the system login and roles screen'
=> 'Server-Bekanntmachungen für die Login-Seite und die Rollenauswahl',

   '(leave blank to delete announcement)'
=> '(leer lassen, um Bekanntmachung zu entfernen)',

   'Check machines:'
=> 'Server auswählen:',

   'Current Announcement'
=> 'Derzeitige Bekanntmachung',

   'Calendar'
=> '日历',

   'Download your Calendar as iCalendar File'
=> '下载您的日历',

   'No calendar available for this date.'
=> '没有日历用于此日期。',

   'Posting [_1]'
=> 'Sende an [_1]',

   'This LON-CAPA server is version [_1]'
=> '这里是 LON-CAPA [_1]',

   'Only changes made from servers running LON-CAPA [_1] or later are displayed.'
=> 'Es werden nur Änderungen angezeigt, die auf Servern mit der LON-CAPA-Version [_1] oder später vorgenommen wurden.',

   'Edit Answer'
=> 'Antwort editieren',

   'Date/Time'
=> '日期/时间',

   'Threshold Name'
=> 'Schwellenwert-Name',

   'Current value'
=> 'Aktueller Wert',

   'Change?'
=> '改变？',

   'Make changes'
=> '保存',

   'Change thresholds'
=> 'Schwellenwerte ändern',

   'Picture Conversion Status'
=> 'Bildkonvertierungs-Status',

   'Class Print Status'
=> 'Druckstatus',

   'Removing error messages:'
=> 'Entfernen von Fehlermeldungen:',

   'Invalid target directory, FAIL'
=> 'Ungültiges Zielverzeichnis. Abbruch!',

   'Creating old version [_1]'
=> 'Erstelle alte Version [_1]',

   'Initial version'
=> 'Urversion',

   'Press "Generate Statistics" when you are ready.'
=> 'Klicken Sie auf "Erzeuge Statistiken", wenn Sie die gewünschten Einstellungen vorgenommen haben.',

   'It may take some time to update the student data for the first analysis. Future analysis this session will not have this delay.'
=> 'Es kann einige Zeit dauern, um die studentischen Daten für die erste Analyse zu aktualisieren. Zukünftige Analysen werden nicht diese Verzögerung verursachen.',

   'A course-wide error occurred.'
=> 'Ein kursweiter Fehler ist aufgetreten.',

   'none'
=> '没有',

   'Prepare Report'
=> '编写报告',

   'Show problem'
=> '提示显示',

   'Show correct answers'
=> 'Korrekte Antworten anzeigen',

   'Show all submissions'
=> 'Alle Einreichungen anzeigen',

   'Show problem grading'
=> 'Aufgabenbewertung anzeigen',

   'Computing correct answers greatly increasese the amount of time required to prepare a report.'
=> 'Die Berechnung korrekter Antworten erhöht die benötigte Zeit erheblich, um den Bericht zu erstellen.',

   'Please select problems and use the [_1]Prepare Report[_2] button to continue.'
=> 'Wählen Sie die zu berücksichtigenden Aufgaben aus und klicken Sie anschließend auf den [_1]Bericht erstellen[_2]-Button.',

   'Please select a Survey to analyze'
=> 'Wählen Sie eine Umfrage, die analysiert werden soll:',

   'There are no survey problems in this course.'
=> 'In diesem Kurs sind keine Umfragen enthalten.',

   'Generate Survey Report'
=> 'Umfragebericht generieren',

   'Building text document.'
=> 'Erstelle Textdokument.',

   'Generated on [_1]'
=> 'Generiert am [_1]',

   'Your text file'
=> 'Ihre Textdatei',

   'Done compiling text file. See link below to download.'
=> 'Erstellung der Textdatei abgeschlossen. Verwenden Sie den unten angegebenen Link zum Herunterladen.',

   'There is no essay or string response data to output for this survey.'
=> 'In dieser Umfrage existieren keine Essay- oder Text-Antwortdaten (essayresponse, stringresponse), die ausgegeben werden könnten.',

   'Building spreadsheet.'
=> '生成电子表格。',

   '[_1]:[_2] responses to [_3] may be too long to fit Excel spreadsheet.'
=> '[_1]:[_2]-Antworten für [_3] könnten zu lang sein, um in eine Excel-Tabelle reinzupassen.',

   'Done compiling spreadsheet. See link below to download.'
=> 'Erstellung der Tabelle abgeschlossen. Verwenden Sie den unten angegebenen Link zum Herunterladen.',

   'Make a sequence selection from the "Sequences and Folders" menu and hit "Create Plot" to begin'
=> 'Wählen Sie eine Sequenz aus der "Sequenzen und Verzeichnisse"-Liste und klicken Sie auf "Diagramm erzeugen", um zu starten.',

   'Create Plot'
=> 'Diagramm erzeugen',

   'Start Time:'
=> 'Startzeit:',

   'End Time:'
=> 'Endezeit:',

   'Sender'
=> '寄件人',

   'Number'
=> 'Nummer',

   'Upload Classlist'
=> 'Kursteilnehmerliste hochladen',

   'Semicolon separated values'
=> '以分号分隔',

   ' with home server '
=> ' mit Heimatserver ', # n.t.

   'Show Log'
=> '查看日志',

   'Course Document Change Log'
=> 'Kursressourcen-Veränderungs-Protokoll',

   'Records'
=> 'Datensätze',

   'Before'
=> '以前',

   'After'
=> '以后',

   'Current folder/page'
=> '当前文件夹/页',

   'Containing phrase'
=> '含有短语',

   'None'
=> '没有',

   'Users'
=> '用户',

   'Include parameter types'
=> 'Parametertypen zeigen',

   'Parameter Change Log'
=> 'Parameteränderungs-Protokoll',

   'Announce'
=> 'Bekanntmachen',

   'Not active anymore'
=> 'nicht mehr aktiv',

   'Add to Course Announcements'
=> 'Den Kursbekanntmachungen hinzufügen',

   'Username : Domain'
=> '用户名：域',

   'Active'
=> '活跃的',

   'Expired'
=> 'Abgelaufen',

   'Future'
=> 'Zukünftig',

   'Sort by realm first, then student (group/section)'
=> 'Sortierung nach Bereich, dann nach Student (Gruppe/Sektion)',

   'Sort by student (group/section) first, then realm'
=> 'Sortierung nach Student (Gruppe/Sektion), dann nach Bereich',

   'Shift all dates based on this date'
=> 'Alle Datumseinträge anhand dieses Datums verschieben',

   'Overview Mode'
=> '概况模式',

   'Overview'
=> '概况',

   'Set Parameters'
=> '参数设置',

   'Parts'
=> '部分',

   'Section(s)'
=> '章节(en)',

   'Group(s)'
=> '组',

   'Parameter Selection'
=> '参数选择',

   'Add Selection for...'
=> 'Auswahl hinzufügen für...',

   'Select Common Only'
=> 'Übliche wählen',

   'Problem Dates'
=> 'Aufgabendatumsfelder',

   'Content Dates'
=> 'Inhaltsdatumsfelder',

   'Discussion Settings'
=> 'Diskussions-Einstellungen',

   'Visibilities'
=> '可见的',

   'Part Parameters'
=> '部分参数',

   'For User [_1] or Student/Employee ID [_2] at Domain [_3]'
=> '对于用户 [_1] 或学生/员工编号 [_2] 在域 [_3]',

   'Group Files'
=> '编组文件',

   "Enter user:domain for User's 'About Me' Page"
=> "Geben Sie Benutzerkennung:Domäne für die Über-mich-Seite des gewünschten Benutzers ein:",

   'No map selected.'
=> 'Keine Inhaltszusammenstellung gewählt!',

   'Most Recent:'
=> '最新：', # n.t.

   'In Course:'
=> '课程：', # n.t.

   'Use:'
=> '使用：', # n.t.

   'Search LON-CAPA help'
=> '搜索 LON-CAPA 帮助',

   'Before course enrollment start!'
=> 'Liegt VOR Kursbelegungs-Start!',

   'After course enrollment end!'
=> 'Liegt NACH Kursbelegungs-Ende!',

   'in the past'
=> '在过去',

   'in the future'
=> '在将来',

   'Choose'
=> 'Übernehmen',

   'Title:'
=> '标题：',

   'URL:'
=> 'URL:',

   'Course, Portfolio and Catalog Search'
=> '目录搜索，组合搜索和课程搜索',

   'ERROR:'
=> '错误：',

   'occurred while running'
=> 'trat auf während der Ausführung von', # n.t.

   '(click for example)'
=> '(Klicken für Beispiel)',

   'click for example'
=> 'Klicken für Beispiel',

   'Re-Enable'
=> '重新启用',

   'Script Functions'
=> 'Funktionen in Skripten',

   'Image Options'
=> '图像选项', # n.t.

   'left'
=> '左边',

   'right'
=> '右边',

   'TeXwidth (mm):'
=> 'TeX-宽 (mm)：',

   'TeXheight (mm):'
=> 'TeX-高 (mm)：',

   'TeXwrap:'
=> 'TeX-转变', # n.t., ??? [SB 2007-07-11]

   'Sorry!'
=> '对不起...',

   'Resource not available.'
=> 'Ressource nicht erreichbar.', # n.t.

   'Choose file type:'
=> 'Dateityp:',

   'Output of decompress:'
=> 'Ausgabe des Entpackvorgangs:',

   'Decompress complete.'
=> 'Entpackvorgang abgeschlossen.',

   'Archive:'
=> '存档：',

   'inflating:'
=> 'entpacke:',

   'Incorrect:'
=> '错误:',

   'Correct:'
=> '正确:',

   'Correct'
=> '正确',

   'Pick course first'
=> '只能选择课程',

   'User Information Changed'
=> '用户信息变更',

   'Changed To'
=> '改为',

   'disk space allocated to portfolio files'
=> 'Speicherplatz für Portfolio-Dateien',

   'You have new messages'
=> 'Sie haben neue Nachrichten',

   'Destination folder'
=> '目的文件夹',

   'Mark Read'
=> '标记为已读',

   'Move to Folder ->'
=> '移至文件夹 ->',

   'Register Response Devices (&quot;Clickers&quot;)'
=> '注册应答设备 (&quot;Clickers&quot;)',

   'Enter response device ("clicker") numbers'
=> '输入应答设备（&quot;Clickers&quot;）的号码',

   'Locating your clicker ID'
=> '定位您的应答设备编号',

   'Register Clicker'
=> '注册应答设备',

   'Register'
=> '注册',

   'New Link'
=> '新的书签', # n.t.

   'Refresh'
=> '更新', # n.t.

   'Custom metadata [_1]'
=> '自定义元数据 [_1]',

   'Question/Comment/Feedback about course content'
=> '课程内容的问题/评论/反馈',

   'User modify/custom role edit'
=> '用户帐户和权限管理',

   'User Search'
=> '用户搜索',

   'to add/modify roles'
=> ', 添加/修改角色',

   'is'
=> '是',

   'contains'
=> '包括',

   'in this domain'
=> '在该域',

   'in institutional directory'
=> '在研究所目录',

   'Domain/institution to search'
=> 'LON-CAPA-域/研究所中搜索',

   'Directory search has not been configured for domain: [_1]'
=> '目录搜索，在还没有被配置的域：[_1]',

   'permanent e-mail'
=> '永久电子邮件',

   'Set user role'
=> '设置用户角色',

   'No exact match found for this username ([_1]) in this domain.'
=> '对该用户名（[_1]）在这个领域中没有找到完全匹配的。',

   'No match found for this username ([_1]) in this domain.'
=> '对该用户名（[_1]）在这个领域中没有找到相应的。',

   'Make new user "[_1]"'
=> '新用户 "[_1]"',

   'Edit Course'
=> '编辑课程',

   'Choose which items you wish to export from your Course.'
=> '选择您要从课程中导出的项目。',

   'Content items'
=> '内容项目',

   'Discussion posts'
=> '讨论文章',

   'Download the zip file from'
=> '下载zip档案从：',

   'IMS course archive'
=> 'IMS课程存档',

   'last name, first name'
=> '姓氏，名字',

   'Select a Template'
=> 'Auswahl einer Vorlage',

   'Edit custom role'
=> 'Benutzerdefinierte Benutzerrolle einrichten',

   'Privilege'
=> 'Berechtigung',

   'Showing users with a name starting with [_1]'
=> '显示用户，起始是 [_1]',

   'Permanent e-mail address'
=> '永久的 E-Mail 地址',

   'Permanent e-mail'
=> '永久的 E-Mail 地址',

   'User [_1] in domain [_2]'
=> '用户 [_1] 在域 [_2]',

   'Result'
=> 'Ergebnis',

   'Directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Die Institussuche in der Domäne [_1] ist für den angeforderten Suchtyp "[_2]" nicht verfügbar.',

   "No match found for this username ([_1]) in your institution's directory."
=> "Kein Treffer im Institutsverzeichnis für den Benutzer [_1].",

   'Setting'
=> 'Einstellung',

   'Directory search available?'
=> 'Verzeichnissuche verfügbar machen?',

   'Back to actions menu'
=> 'Zurück zur Domänen-Konfiguration', # n.t.

   'Edit action'
=> 'Aktion',

   'Effect'
=> 'Effekt',

   'Course / User'
=> 'Kurs / Benutzer',

   'deny'
=> 'verweigern',

   'allow'
=> 'zulassen',

   'Delete this rule'
=> 'Diese Regel löschen',

   'Insert rule above'
=> 'Regel oberhalb einfügen',

   'Insert rule below'
=> 'Regel unterhalb einfügen',

   'Move rule down'
=> 'Regel nach unten verschieben',

   'Move rule up'
=> 'Regel nach oben verschieben',

   'Warning: It can take up to 1 hour for rights changes to fully propagate.'
=> 'Achtung: Es kann bis zu einer Stunde dauern, bis alle Rechte-Änderungen vollständig wirken.',

   'email address'
=> 'E-Mail地址',

   'Updated'
=> '已更新',

   'The error occurred on host  [_1]'
=> 'Der Fehler trat auf dem Host [_1] auf.',

   'This error occurred on machine [_1]'
=> 'Dieser Fehler trat auf Maschine [_1] auf.', # n.t.

   'Clear all Messages in Subdirectory'
=> 'Alle Nachrichten im Unterverzeichnis entfernen',

   'Task information'
=> 'Information',

   'Automated adds/drops'
=> 'Automatische Hinzufügungen/Ausschließungen',

   'Change enrollment dates'
=> 'Kursbelegungsdaten ändern',

   'Change access dates'
=> 'Zugriffszeiten ändern',

   'Notification of changes'
=> 'Benachrichtigung über Änderungen',

   'Change crosslistings'
=> 'Querverweise ändern',

   'Section settings'
=> 'Sektions-Einstellungen',

   'Student photo settings'
=> 'Einstellungen studentischer Fotos',

   'Update roster now'
=> 'Kursteilnehmerliste jetzt aktualisieren',

   'Update student photos'
=> 'Studentische Fotos aktualisieren',

   'View students and change type'
=> 'Studenten betrachten und Typ ändern',

   'Changes to nightly automated enrollments'
=> 'Die nächtlichen, automatischen Kursbelegungen ändern',

   'Currently: Nightly adds: [_1], Nightly drops: [_2]'
=> 'Derzeit: Nächtliche Hinzufügungen: [_1], nächtliche Ausschließungen: [_2]',

   'OFF'
=> 'AUS',

   'ON'
=> 'AN',

   'Additions based on classlist changes:'
=> 'Hinzufügungen aufgrund von Änderungen an der Kursteilnehmerliste:',

   'Removals based on classlist changes:'
=> 'Ausschließungen aufgrund von Änderungen an der Kursteilnehmerliste:',

   'Enable'
=> 'Aktivieren	',

   'Disable'
=> 'Deaktivieren',

   'Note: Any students added manually by course coordinators using the Enrollment Manager will be unaffected by the nightly removal process if you choose to enable it.'
=> 'Hinweis: Alle Studenten, die manuell durch den Kurs-Koordinator über die Kursbelegungs-Verwaltung hinzugefügt wurden, werden beim nächtlichen Ausschließungsprozess NICHT berücksichtigt, auch wenn die Ausschließungs-Option aktiviert ist.',

   'Changes to first and/or last automated enrollment dates'
=> 'Änderungen von Anfangs- und/oder Endedatum der automatischen Kursbelegung',

   'Currently: First enrollment: [_1], Last enrollment: [_2]'
=> 'Derzeit: Start der automatischen Kursbelegung: [_1], Ende der automatischen Kursbelegung: [_2]',

   'Set date of first automated enrollment for registered students'
=> 'Setzen des Anfangsdatums der automatischen Kursbelegung für registrierte Studenten',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, once the first enrollment date has been reached. Prior to this date, the class roster will only contain students you have added directly using the standard LON-CAPA enrollment tools'
=> 'Falls das automatische Hinzufügen und Ausschließen aktiviert ist, wird ab dem Anfangsdatum nächtlich die Kursteilnehmerliste automatisch aktualisiert. Vor diesem Zeitpunkt wird die Kursteilnehmerliste nur Studenten enthalten, die über die manuelle Kursbelegung in LON-CAPA eingetragen wurden.',

   'Set date of last automated enrollment for registered students'
=> 'Setzen des Endedatums der automatischen Kursbelegung für registrierte Studenten',

   'If automated adds and/or drops are enabled, then your class roster will be automatically updated nightly, until the last enrollment date has been reached.'
=> 'Falls das automatische Hinzufügen und Ausschließen aktiviert ist, wird bis zum Erreichen des Endedatums nächtlich die Kursteilnehmerliste automatisch aktualisiert.',

   'Changes to default start and/or end dates for student access'
=> 'Änderungen an dem voreingestellten Anfangs- und/oder Endedatum für studentischen Zugriff',

   'Currently: default first access:'
=> 'Derzeit: voreingesteller erste Zugriff:',

   ', default last access:'
=> ', voreingestellter letzter Zugriff:',

   'Set date of first access for registered students added via automated enrollment'
=> 'Einstellen des Datums für den ersten studentischen Zugriff registrierter Studierender, die über die automatische Kursbelegung hinzugefügt werden',

   'Set date of last access for registered students added via automated enrollment'
=> 'Einstellen des Datums für den letzten studentischen Zugriff registrierter Studierender, die über die automatische Kursbelegung hinzugefügt werden',

   'Changes to section settings'
=> 'Sektionseinstellungen',

   'Currently no sections of'
=> 'Derzeit ist für keine Sektionen des Kurses',

   'are contributing enrollment to the LON-CAPA class roster.'
=> 'eine Teilnahme an der Kursbelegung eingerichtet.',

   'Add enrollment from additional sections.'
=> 'Kursbelegung für weitere Sektionen hinzufügen',

   'Number of new sections to add:'
=> 'Anzahl hinzuzufügender Sektionen:',

   'Students enrolling in the sections listed below will be automatically added to the class roster for LON-CAPA course'
=> 'Studierende, die in die unten aufgelisteten Sektionen eingeschrieben werden, werden automatisch in die Kursteilnehmerliste des Kurses',

   'if you have chosen to enable a nightly automated enrollment update.'
=> 'aufgenommen, falls die nächtliche, automatische Kursbelegung aktiviert ist.',

   'Nightly additions based on classlist changes now'
=> 'Nächtliche Hinzufügungen aufgrund von Kursteilnehmerlisten-Änderungen sind jetzt',

   'Nightly additions based on classlist changes still'
=> 'Nächtliche Hinzufügungen aufgrund von Kursteilnehmerlisten-Änderungen bleiben weiterhin',

   'Nightly removals based on classlist changes now'
=> 'Nächtliche Ausschließungen aufgrund von Kursteilnehmerlisten-Änderungen sind jetzt',

   'Nightly removals based on classlist changes still'
=> 'Nächtliche Ausschließungen aufgrund von Kursteilnehmerlisten-Änderungen bleiben weiterhin',

   'enabled'
=> 'aktiviert',

   'disabled'
=> 'deaktiviert',

   'The first date for automated enrollment has been changed'
=> 'Das Anfangsdatum der automatischen Kursbelegung wurde geändert auf',

   'The last date for automated enrollment has been changed'
=> 'Das Endedatum der automatischen Kursbelegung wurde geändert auf',

   'The first date for automated enrollment has been left unchanged as'
=> 'Das Anfangsdatum der automatischen Kursbelegung bleibt weiterhin',

   'The last date for automated enrollment has been left unchanged as'
=> 'Das Endedatum der automatischen Kursbelegung bleibt weiterhin',

   'Currently: Notification:'
=> 'Derzeit: Benachrichtigung:',

   'Notification of LON-CAPA course roster changes resulting from nightly automated enrollment process?'
=> 'Benachrichtigung über Änderungen an der Kursteilnehmerliste durch die nächtliche, automatische Kursbelegung aktivieren?',

   'The table below contains a list of Kurs-Koordinators in this course.'
=> 'Liste der Kurs-Koordinatoren in diesem Kurs',

   'username:domain'
=> '用户名：域',

   'Course Access'
=> 'Kurs-Zugriff',

   'Current notification status'
=> 'Derzeitiger Benachrichtigungsstatus',

   'Notification active'
=> 'Benachrichtigung aktiv',

   'Notification inactive'
=> 'Benachrichtigung inaktiv',

   'Notification?'
=> 'Benachrichtigen?',

   "The table below contains a list of Domänen-Koordinators from this course's domain who are not also Kurs-Koordinators."
=> "Liste der Domänen-Koordinatoren, die in der Kurs-Domäne liegen, aber nicht zusätzlich Kurs-Koordinatoren sind",

   'Notification of enrollment changes now'
=> 'Benachtrichtigung über Kursbelegungsänderungen ist jetzt',

   'Notification of enrollment changes still'
=> 'Benachtrichtigung über Kursbelegungsänderungen bleibt weiterhin',

   'The following will receive notification if there are any changes in enrollment in LON-CAPA course:'
=> 'Die folgenden Benutzer erhalten eine Benachrichtigung im Falle von Änderungen der Kursteilnehmerliste durch die automatische Kursbelegung des Kurses',

   'as a result of the nightly enrollment check:'
=> 'aufgrund des nächtlichen Kursbelegungsabgleichs:',

   'View/Modify Course Settings'
=> 'Kurs-Einstellungen betrachten/ändern',

   'Course search'
=> 'Kurs-Suche',

   'View/Modify Courses'
=> 'Kurse betrachten/ändern',

   'Course details'
=> 'Kursdetails',

   'Detailed course information:'
=> 'Detailierte Kursinformationen:',

   'Default Access Dates for Students'
=> 'Voreingestellte Zugriffsdaten für Studierende',

   'Student Counts'
=> 'Anzahl Studierende',

   'Auto-enrollment of[_1]registered students'
=> 'Automatische Kursbelegung[_1]registrierter Studenten',

   'Details'
=> 'Details',

   'Not enabled'
=> 'Nicht aktiviert',

   'section:'
=> 'Sektion:', # n.t.

   'Previous access'
=> 'In der Vergangenheit liegender Zugriff',

   'Current access'
=> 'Aktueller Zugriff',

   'Future access'
=> 'Zukünftiger Zugriff',

   'Back to course listing'
=> '返回课程目录',

   'Immediate course roster update'
=> 'Sofortige Aktualisierung der Kursteilnehmerliste',

   'There were no new students to add to the course.'
=> 'Es existieren keine Studenten, die neu am Kurs teilnehmen sollen.',

   'Back to options page'
=> 'Zurück zum Funktionsauswahlmenü',

   'View/Modify settings for: '
=> 'Betrachten/Ändern der Einstellungen für ',

   'Modify quota for group portfolio files'
=> 'Ändern des Speicherplatzes für Gruppen-Portfolio-Dateien',

   'Display current settings for automated enrollment'
=> 'Anzeige der derzeitigen Einstellungen der automatischen Kursbelegung',

   'Modify institutional code, course owner and/or default authentication'
=> 'Ändern des Institutscodes, des Kurs-Eigentümers und/oder der voreingestellten Authentifizierung',

   'Modify course catalog settings for course'
=> 'Ändern der Kursübersicht-Einstellungen für diesen Kurs',

   'Catalog settings'
=> 'Katalog-Einstellungen',

   'Catalog Settings for Course'
=> 'Katalog-Einstellungen für den Kurs',

   'Visibility in Course Catalog'
=> 'Sichtbarkeit in der Kursübersicht',

   "Unless excluded, a course is listed in this domain's publicly accessible course catalog, if at least one of the following applies:"
=> "Sofern ein Kurs nicht aus der Anzeige in der in dieser Domäne öffentlich zugänglichen Kursübersicht ausgeschlossen wurde, wird er angezeigt, solange mindestens eine der folgenden Einstellungen zutrifft:",

   'Auto-cataloging is enabled and the course is assigned an institutional code'
=> 'Automatische Katalogisierung ist aktiviert und dem Kurs wurde ein institutioneller Code zugewiesen',

   'The course has been categorized into at least one of the course categories defined for the domain.'
=> 'Der Kurs wurde in mindestens eine der Kurskategorien, die für diese Domäne angelegt wurden, eingeordnet.',

   'Exclude from course catalog'
=> 'Kurs aus Kursübersicht ausschließen',

   'Categorize Course'
=> 'Kurs kategorisieren',

   'No categories defined for this domain'
=> 'In dieser Domäne wurden bisher keine Kategorien angelegt.',

   'Assign one or more categories to this course.'
=> 'Diesem Kurs eine oder mehrere Kategorien zuweisen:',

   'If auto-cataloging based on institutional code is enabled in the domain, a course will continue to be listed in the catalog of official courses, in addition to receiving a listing under any manually assigned categor(ies).'
=> 'Falls die automatische, auf den institutionellen Codes basierende Katalogisierung in dieser Domäne aktiviert ist, wird ein Kurs weiterhin in der Übersicht der offiziellen Kurse aufgelistet und zusätzlich in einer Liste mit allen manuell zugewiesenen Kategorien angezeigt.',

   'Category settings'
=> 'Kategorie-Einstellungen',

   'Show/Hide a course in the catalog'
=> 'Anzeigen/Verbergen von Kursen im Kursüberblick',

   'Assign a category to a course'
=> 'Einem Kurs eine Kategorie zuweisen',

   'Set in "Modify Course" (Domain)'
=> 'Einstellung in "Kurs einstellen" (Domäne)',

   'Set in "Modify Parameters" (Course)'
=> 'Einstellung in "Parameter ändern" (Kurs)',

   'Categories'
=> 'Kategorien',

   'Add category'
=> 'Kategorie hinzufügen',

   'Add category:'
=> 'Kategorie hinzufügen:',

   'Add subcategory:'
=> 'Unterkategorie hinzufügen:',

   'New:'
=> 'Neu:',

   'Choose a course'
=> 'Kurs auswählen',

   'Pick action'
=> 'Aktion auswählen',

   'Display settings'
=> 'Einstellungen anzeigen',

   'Course settings that control automated enrollment in this LON-CAPA course are currently:'
=> 'Derzeitige Einstellungen der automatischen Kursbelegung dieses Kurses:',

   'Course setting'
=> 'Kurs-Einstellung',

   'Modifiable by DC only'
=> 'Nur durch Dom.-Koord. änderbar',

   'Default authentication parameter'
=> 'Voreingestellter Authentifizierungsparamater',

   'Default authentication method'
=> 'Voreingestellte Authentifizierungsmetode',

   'Date of last automated enrollment'
=> 'Endedatum der automatischen Kursbelegung',

   'Date of first automated enrollment'
=> 'Anfangsdatum der automatischen Kursbelegung',

   'Official course code'
=> 'Offizieller Kurscode',

   'Username:domain of course owner'
=> 'Benutzerkennung:Domäne des Kurs-Eigentümers',

   'Date of last student access'
=> '学生访问的结束日期',

   'Date of first student access'
=> '学生访问的开始日期',

   'Course section number(:LON-CAPA section)'
=> 'Kurssektionsnummer(:LON-CAPA-Sektionsnummer)',

   'Show more details'
=> '查看更多详情',

   'Public RSS/podcast (subscribe to)'
=> '公共RSS /播客(订阅)',

   'Course Owner:'
=> '课程所有者:',

   'Default Authentication method'
=> 'Voreingestellte Authentifizierungsmethode',

   'Modify settings'
=> 'Einstellungen speichern',

   'Automated Enrollment'
=> 'Automatische Kursbelegung',

   'Use the menu on the left to choose an enrollment management task.'
=> 'Wählen Sie im Menü links die gewünschte Aktion zur automatischen Kursbelegung.',

   'Result of Changes to Automated Enrollment Settings.'
=> 'Ergebnis der Änderungen an den Einstellungen zur automatischen Kursbelegung',

   'The following automated enrollment parameters have been changed:'
=> 'Die folgenden Parameter der automatischen Kursbelegung wurden geändert:', # n.t.

   'now set to'
=> 'ist jetzt', # n.t.

   'still set to'
=> 'bleibt weiterhin', # n.t.

   'The following automated enrollment parameters remain unchanged:'
=> 'Die folgenden Parameter der automatischen Kursbelegung bleiben unverändert:', # n.t.

   'Change settings'
=> 'Einstellungen ändern',

   "Student's agreement needed for listing in student-viewable roster"
=> "Studentisches Einverständnis notwendig, um in der von Studenten einsehbaren Kursteilnehmerliste aufgelistet zu werden",

   'Include link to accessible portfolio files'
=> 'Link für erreichbare Portfolio-Dateien einbinden',

   'Print header format'
=> 'Kopfbereich beim Druck',

   'Substitutions:<br />[_1]: student name, [_2]: course id, [_3]: assignment note. Numbers after the <tt>%</tt> limit the field size.'
=> 'Platzhalter:<br />[_1]: Name des Studenten, [_2]: Kurs-ID, [_3]: Beurteilungsanmerkung. Eine Zahl hinter dem <tt>%</tt>-Zeichen begrenzt die Feldgröße.',

   'Force all students in the course to use a specific math rendering engine.'
=> 'Vorgabe für alle Studenten im Kurs, wie wissenschaftliche Formeln dargestellt werden sollen',

   "[_1], [_2] (Convert to Images), [_3] (TeX to HTML), or blank for student's preference"
=> "[_1], [_2] (in Grafik konvertieren), [_3] (TeX-nach-HTML) oder leer lassen für studentische Voreinstellung",

   'Bridge Task Grading'
=> 'Bewertung von "Bridge Tasks"',

   'Classlist Manager'
=> 'Automatische Kursbelegung', # !?!

   'Note for students:'
=> '注意事项：',

   'If you are officially enrolled in a course but the course is not listed in your LON-CAPA courses, click the "Show more details" link for the specific course and check the default access dates and/or automated enrollment settings.'
=> 'Falls Sie einen Kurs Ihrer Einrichtung regulär belegt haben, dieser aber nicht in Ihrer persönlichen LON-CAPA-Kursauswahl (Benutzerrollen) aufgelistet wird, klicken Sie in der unten stehenden Kursübersicht bei dem entsprechenden Kurs auf "Mehr Details". Überprüfen Sie dort die Angaben zum Kursstart und -ende und die Einstellungen der automatischen Kursbelegung.',

   'Please [_1]log in again[_2].'
=> '请[_1]重新登录[_2].',

   'Switching Server ...'
=> '更换服务器 ...',

   'Already logged in'
=> '已经登录',

   'Apply style file: '
=> 'Styledatei anwenden: ',

   'The problem '
=> '问题 ',

   'Search criteria'
=> '搜索条件',

   'begins with'
=> '始于',

   'in selected LON-CAPA domain'
=> '在选定的 LON-CAPA-域 ',

   'in institutional directory for selected domain'
=> '在选定的域中的研究所列表',

   'No exact match found for the username ([_1]) in LON-CAPA domain: [_2]'
=> '没有找到完全匹配的用户名（[_1] ）在LON-CAPA-域：', # n.t.

   'Creating new account.'
=> '创建新帐户。',

   'Report a documentation bug'
=> '报告文件错误 (Englisch)',

   'You must specify a valid username. Only the following are allowed: letters numbers - . @'
=> '您必须指定一个有效的用户名。只允许以下字符：字母，数字， "-"， "." 和 "@"',

   'The following need to be corrected before the search can be run:'
=> '在搜索可以开始之前，下面必须予以纠正：',

   'You must include some text to search for.'
=> '您必须包括一些要搜寻的文字。',

   "The text you are searching for must contain at least two characters when using a 'begins' type search."
=> "文本搜索必须包含至少有两个字符，当使用的是'开始'类型的搜索。",

   "The text you are searching for must contain at least three characters when using a 'contains' type search."
=> "文字要搜索必须包含至少3个字符时，当使用的是'包含'式的搜索。",

   'You must choose a domain when using an institutional directory search.'
=> '您必须选择一个域，当使用的是研究所目录搜索。',

   'You must choose a domain when using a domain search.'
=> '您必须选择一个域，当使用域搜索。',

   "When using searching by last,first you must include a comma as separator between last name and first name."
=> "Bei der Suche mit der Option 'Nachname, Vorname' muss zwischen Vor- und Nachname als Trennzeichen ein Komma stehen.",

   "When searching by last,first you must include at least one character in the first name."
=> "Bei der Suche mit der Option 'Nachname, Vorname' muss der Vorname mindestens ein Zeichen enthalten.",

   'Revoking [_1] in [_2]: [_3]'
=> 'Entziehe Rolle [_1] für [_2]: [_3]',

   'Revoking custom role:'
=> 'Entziehe benutzerdefinierte Rolle:',

   'Deleting [_1] in [_2]: [_3]'
=> 'Entferne Rolle [_1] für [_2]: [_3]',

   'Deleting custom role [_1] by [_2] in [_3]'
=> 'Entferne benutzerdefinierte Rolle [_1] von [_2] für [_3]',

   'Add to classlist'
=> 'Hinzufügen zur Kursteilnehmerliste',

   'Re-enabling [_1] in [_2]: [_3]'
=> 'Reaktivierung der Rolle [_1] für [_2]: [_3]',

   'Re-enabling custom role [_1] by [_2] in [_3]: [_4]'
=> 'Reaktivierung der benutzerdefinierten Rolle [_1] für [_2] in [_3]: [_4]',

   'Unknown command'
=> 'Unbekannter Befehl',

   '[_1] may not be used as the name for a section, as it is a reserved word.'
=> '[_1] ist nicht als Sektionsname zulässig, da es sich um ein systemintern-reserviertes Wort handelt.',

   '[_1] may not be used as the name for a section, as it is the name of a course group.'
=> '[_1] ist nicht als Sektionsname zulässig, da er bereits als Name einer bestehenden Kursgruppe verwendet wird.',

   'Please [_1]go back[_2] and choose a different section name.'
=> 'Bitte gehen Sie [_1]zurück[_2] und wählen Sie einen anderen Sektionsnamen.',

   'Drop from classlist: [_1]'
=> 'Aus Kursteilnehmerliste ausschließen: [_1]',

   'Existing Role'
=> 'Bestehende Rolle',

   'Assigning Role to Self'
=> 'Assigning Role to Self', # ???

   'Invalid search.'
=> 'Ungültige Suche.',

   'You must enter a search term.'
=> 'Sie müssen einen Suchbegriff eingeben.',

   'You must specify a valid domain when searching in a domain or institutional directory.'
=> 'Bei der Domänen- oder Institusverzeichnis-Suche müssen Sie eine gültige Domäne angeben.',

   'You may want to search in the LON-CAPA domain instead of the institutional directory.'
=> 'Anstatt im Institutsverzeichnis könnten Sie alternativ in den LON-CAPA-Domänen suchen.',

   'New users can only be created in the domain to which your current role belongs - [_1].'
=> 'Neue Benutzer können nur in der Domäne angelegt werden, in der auch Ihre derzeitige Rolle liegt - [_1].',

   'Institutional directory search is not available in domain: [_1]'
=> 'Eine Suche im Institutsverzeichnis ist in der Domäne [_1] nicht verfügbar.',

   'Institutional directory search in domain: [_1] is only allowed for users with a current role in the domain.'
=> 'Eine Suche im Institutsverzeichnis in der Domäne [_1] ist nur für Benutzer erlaubt, die eine aktive Rolle in dieser Domäne haben.',

   'Institutional directory search in domain: [_1] is not available to your user type: '
=> 'Eine Suche im Institutsverzeichnis in der Domäne [_1] ist nicht für Ihren Benutzertyp verfügbar: ',

   'Institutional directory search has not been configured for domain: [_1]'
=> 'Die Suchfunktion im Institutsverzeichnis in der Domäne [_1] ist nicht konfiguriert.',

   'Institutional directory search in domain: [_1] is not available for searching by "[_2]"'
=> 'Eine Suche im Institutsverzeichnis in der Domäne [_1] ist nicht verfügbar für eine Suche nach "[_2]"',

   'Institutional directory search in domain: [_1] is not available.'
=> 'Eine Suche im Institutsverzeichnis ist in der Domäne [_1] nicht verfügbar.',

   'Institutional directory search in domain [_1] is not available for the requested search type: "[_2]"'
=> 'Eine Suche im Institutsverzeichnis ist in der Domäne [_1] für den gewünschten Suchtyp "[_2]" nicht verfügbar.',

   'You may want to broaden your search to a search of the institutional directory for the domain.'
=> 'Sie können Ihre Suche auf eine Suche im Institutsverzeichnis der Domäne erweitern.',

   'You may want to broaden your search to the selected LON-CAPA domain.'
=> 'Sie können Ihre Suche auf eine Suche in der gewählten LON-CAPA-Domäne erweitern.',

   'Pick group first'
=> 'Erst Gruppe auswählen',

   'No login name specified'
=> 'Kein Loginname angegeben',

   'Invalid login name'
=> 'Ungültiger Loginname',

   'Only letters, numbers, periods, dashes, @, and underscores are valid'
=> 'Es sind nur erlaubt: Buchstaben, Ziffern, ".", "@", ,"-", "_"',

   'For this user, the default quota would be [_1] Mb.'
=> 'Für diesen Benutzer würde der voreingestellte Speicherplatz [_1] MB betragen.',

   "For this user, the default quota would be [_1] Mb, as determined by the user's institutional affiliation ([_2])."
=> "Für diesen Benutzer würde der voreingestellte Speicherplatz [_1] MB betragen, beschränkt durch die institutionelle Angliederung ([_2]).",

   "For this user, the default quota of [_1] Mb, is determined by the user's institutional affiliation ([_2])."
=> "Für diesen Benutzer beträgt der voreingestellte Speicherplatz [_1] MB, beschränkt durch die institutionelle Angliederung ([_2]).",

   'in all LON-CAPA domains.'
=> 'in allen LON-CAPA-Domänen.',

   'in LON-CAPA domains:'
=> 'in den LON-CAPA-Domänen:',

   'in LON-CAPA domain '
=> '在LON-CAPA域 ',

   'Course settings modifiable by [_1] only.'
=> 'Kurs-Einstellungen, die nur durch einen [_1] änderbar sind',

   'Course Owner'
=> 'Kurs-Eigentümer',

   'Username:Domain'
=> '用户名：域',

   'Course Activity'
=> 'Letzte Kursaktivität',

   'Course Domain'
=> 'Kurs-Domäne',

   'Course Institutional Code'
=> 'Kurs-Instituts-Code',

   "Course Owner's Username"
=> "Benutzerkennung des Kurs-Eigentümers",

   "Course Owner's Domain"
=> "Domäne des Kurs-Eigentümers",

   'Course Type'
=> 'Kurstyp',

   'LON-CAPA course ID'
=> 'LON-CAPA-Kurs-ID',

   'None found'
=> 'Keine Treffer',

   'Course settings which only a [_1] may modify.'
=> 'Kurs-Einstellungen, die nur ein [_1] ändern kann.',

   "Click a 'Select' button to view or modify settings for a [_1] which may only be modified by a [_2] in this domain."
=> "Klicken Sie auf den Auswahl-Button eines [_1], um die Einstellungen für diesen [_1] zu betrachten oder zu ändern, die nur durch einen [_2] in dieser Domäne geändert werden können.",

   'Single user search'
=> 'Suche einzelner Student',

   'Set enrollment'
=> 'Kursbelegung einstellen',

   'Please review the information in "Log-in help" and the "Getting started" guide if you are unable to log-in.'
=> 'Bitte schauen Sie zunächst in die "Login-Hilfe" und in die "Kurzeinleitung für Studierende", falls Sie sich nicht anmelden können.',

   'Please review the information in "Log-in help" if you are unable to log-in.'
=> 'Bitte schauen Sie zunächst in die "Login-Hilfe", falls Sie sich nicht anmelden können.',

   'If your problem is still unresolved, the form below can be used to send a question to the LON-CAPA helpdesk.'
=> 'Wenn sich damit die Probleme nicht lösen lassen, dann können Sie das Formular auf dieser Seite ausfüllen und eine Anfrage an das Helpdesk schicken.',

   'Getting started guide'
=> 'Kurzeinleitung für Studierende',

   '[_1] [_2] [_3] [_4] [_5]m [_6]s ' # "mm dd yyyy hh mi ss" (1:month, 2:day, 3:year, 4:hour, 5:minute, 6:second)
=> '[_2]. [_1] [_3], [_4]:[_5]:[_6] ', # "dd. mm yyyy, hh:mi:ss"

   '[_1]Select Date[_2]'
=> '[_1]请选择日期[_2]',

   '[_1]: students can view all sections. [_2]: students can only view their own section. blank or [_3] prevents student view.'
=> '[_1]: Studenten können alle Sektionen sehen. [_2]: Studenten können nur ihre eigene Sektion sehen. Leer lassen oder [_3]: keine Einsicht für Studenten.',

   '[_1] to require students to opt-in to listing in the roster (on the roster page).'
=> '[_1], um Notwendigkeit des studentischen Einverständnisses zu aktivieren.',

   "[_1] for link to each a listing of each student's files."
=> "[_1] zum Einbinden von Links zu jeder Liste mit den Dateien eines jeden Studenten.",

   '[_1]: student, [_2]: TA, [_3]: instructor'
=> '[_1]： 学生， [_2]： 导师， [_3]： 讲师',

   'role:section,role:section,...'
=> 'Rolle:Sektion,Rolle:Sektion,...',

   'Example: "<tt>st:001,st:002,in,cc</tt>" would permit students in sections 001 and 002 and instructors in any section, and course coordinators to edit their own posts.'
=> 'Beispiel: "<tt>st:001,st:002,in,cc</tt>" würde Studenten in den Sektionen 001 und 002, Dozenten und Kurs-Koordinatoren in beliebigen Sektionen erlauben, ihre Beiträge zu editieren.',

   'supported types'
=> 'Unterstützte Formate',

   '[_1] to send a message only to student, [_2] to send message to student and add record to user information page for instructors. Leave blank to disable.'
=> '[_1], um Nachricht nur an Studenten zu schicken. [_2], um Nachricht an Studenten zu schicken und Eintrag in die Seite der studentischen Benutzerdaten für Dozenten einzutragen. Leer lassen, um zu deaktivieren.',

   'Instructors and TAs in sections, when grading bridge tasks, should be allowed to grade other sections.'
=> 'Wenn Dozenten und Tutoren bestimmter Sektionen "Bridge tasks" bewerten, auch die Bewertung anderer Sektionen erlauben.',

   '[_1]: they are allowed (this is the default). [_2]: no, they can only grade their own section.'
=> '[_1]: erlauben (voreingestellt). [_2]: nur eigene Sektion.',

   'Calendar Announcement for '
=> 'Kalender-Ankündigung für den Kurs ',

   'Opening'
=> 'Start',

   'Closing'
=> 'Ende',

   'To add a new user:'
=> 'Um einen neuen Benutzer hinzuzufügen...:',

   "(You can only create new users in your current role's domain - [_1])"
=> "(Neue Benutzer können nur in der Domäne Ihrer derzeitigen Benutzerrolle erzeugt werden - [_1])",

   "You are not authorized to create new users in your current role's domain - [_1]."
=> "Sie sind nicht berechtigt, neue Benutzer in der Domäne Ihrer derzeitigen Benutzerrolle anzulegen - [_1].",

   "Set 'Domain/institution to search' to: [_1]"
=> "Setzen Sie die Domäne, in der gesucht werden soll, auf [_1]",

   "Set 'Search criteria' to: [_1]username is ..... in selected LON-CAPA domain[_2]"
=> "Setzen Sie 'Suchkriterien' auf [_1]Benutzerkennung ist ..... in ausgewählter LON-CAPA-Domäne[_2]",

   'Provide the proposed username'
=> 'Geben Sie die gewünschte Benutzerkennung ein',

   'Select a user to add/modify roles'
=> 'Wählen Sie einen Benutzer, für den Sie Rollen oder Berechtigungen ändern bzw. hinzufügen möchten',

   "Click 'Search'"
=> "Klicken Sie auf 'Suchen'",
#=> "Klicken Sie auf 'Suchen'",


   'User Search to add/modify roles'
=> 'Benutzersuche zum Hinzufügen/Ändern von Rollen oder Berechtigungen',


# Feedback messages:

   'You have entered that answer before'
=> '您已经输入了答案',

   "Computer's answer now shown above."
=> "上面显示的是正确答案。",

   'You are correct.'
=> '正确答案！',

   'You are partially correct.'
=> '部分正确。',

   'Incorrect'
=> '错误',

   'Your receipt no. is [_1]'
=> '您的证明编号是 [_1]',

   'You are excused from the problem.'
=> '你的作业已通过。',

   'Some extra items were submitted.'
=> 'Es wurden zuviele Antwortelemente angegeben.',

   'Some items were not submitted.'
=> 'Die Fragen wurden nicht vollständig beantwortet.',

   'An error occurred while grading your answer.'
=> 'Während der Bewertung Ihrer Antwort ist ein Fehler aufgetreten.',

   'The submitted answer was too long.'
=> 'Ihre Antwort ist zu lang.',

   'This question expects a numeric answer.'
=> 'Eine numerische Antwort ist gefragt.',

   'You have provided an invalid ranking.'
=> 'Die eingebene Rangordnung ist ungültig.',

   'Please refer to [_1]'
=> 'Hilfe erhalten Sie unter [_1]',

   'help on ranking problems'
=> 'Hilfe zu Rangordnungs-Aufgaben',

   "Submission won't be graded. The type of file submitted is not allowed."
=> "Ihre Einreichung wurde nicht gewertet. Der Dateityp ist nicht erlaubt.",

   'Submission not graded. Use fewer digits.'
=> 'Ihre Antwort wurde nicht gewertet. Verwenden Sie weniger Dezimalstellen.',

   'Submission not graded. Use more digits.'
=> 'Ihre Antwort wurde nicht gewertet. Verwenden Sie mehr Dezimalstellen.',

   'Error in instructor specifed unit. This error has been reported to the instructor.'
=> 'Es liegt ein Fehler in der vom Dozenten vorgegebenen Einheit vor. Der Fehler wurde an den Dozenten gemeldet.',

   'Unable to interpret units. Computer reads units as "[_1]".'
=> 'Einheiten können nicht ausgewertet werden. Computer versteht Einheiten als "[_1]".',

   'Incompatible units. No conversion found between "[_1]" and the required units.'
=> 'Inkompatible Einheiten. Keine Umrechnungsmöglichkeit zwischen "[_1]" und der benötigten Einheit gefunden.',

   'Only a number required. Computer reads units of "[_1]".'
=> 'Als Eingabe ist nur eine Zahl zulässig. Der Computer interpretiert Ihre Eingabe so, als wollten Sie die Einheit "[_1]" verwenden.',

   'Proper comma separation is required'
=> 'Eine ordentliche Trennung durch Kommata ist erforderlich.',

   'Unable to understand formula'
=> 'Der eingegebene Ausdruck kann nicht ausgewertet werden',

   'Your submission has been recorded.'
=> 'Ihre Antwort wurde gespeichert.',

   'A draft copy has been saved.'
=> 'Ihr Entwurf wurde gespeichert.',

   'Nothing submitted.'
=> 'Es wurde nichts eingereicht.',

   'Unknown message'
=> 'Unbekannte Meldung',

   'Returned file(s): [_1]'
=> 'Zurückgelieferte Datei(en): [_1]',

   'Answer Submitted: Your final submission will be graded after the due date.'
=> 'Antwort eingereicht. Die Daten werden nach dem Fälligkeitsdatum ausgewertet.',

# --/


   ' The last submission was after the Due Date '
=> ' Die letzte Einreichung erfolgte nach dem Fälligkeitsdatum ',

   'Submit a file: (only one file can be uploaded)'
=> '提交档案: (只允许上传一个文件)',

   'OR:'
=> '或者:',

   'Select Portfolio Files'
=> '选择组合文件',

   'Portfolio files previously selected: [_1]'
=> 'Zuvor ausgewählte Portfolio-Dateien: [_1]',

   "These file(s) don't exist: [_1]"
=> "Diese Datei(en) existieren nicht: [_1]",

   'Previously published version'
=> 'Zuvor veröffentlichte Version',

   'You do not have privileges to modify the authentication configuration for this user.'
=> 'Sie haben nicht die Berechtigung, die Authentifizierungs-Konfiguration dieses Benutzers zu ändern.',

   'You do not have privileges to modify the portfolio quota for this user.'
=> 'Sie haben nicht die Berechtigung, den Portfolio-Speicherplatz dieses Benutzers zu ändern.',

   'If a change is required, contact a domain coordinator for the domain'
=> 'Falls notwendig, kontaktieren Sie einen Domänen-Koordinator der Domäne',

   'with submissions'
=> '带答案',

   'in grading queue'
=> '在评估队列中',

   'with ungraded submissions'
=> '未评估的答案',

   'with incorrect submissions'
=> '错误的答案',

   'with any status'
=> '任何状态',

   'Default value or none'
=> '默认值或无',

   'Floating Point between 1 and 0'
=> '浮点运算的1和0',

   'Floating point number between zero and one'
=> 'Gleitkommazahl zwischen Null und Eins',

   'Positive Floating Point'
=> 'Positive Gleitkommazahl',

   'Positive floating point number or zero'
=> 'Positive Gleitkommazahl oder Null',

   'Floating Point'
=> 'Gleitkommazahl',

   'Floating point number'
=> 'Gleitkommazahl',

   'Auto-enrollment settings'
=> 'Einstellungen für automatische Kursbelegungen',

   'Configuration setting'
=> '配置设置', # n.t.

   'Value(s)'
=> 'Wert(e)', # n.t.

   'Auto-enrollment active?'
=> 'Automatische Kursbelegung aktivieren?',

   'Access to other pages will be prevented until you have moved the message to your inbox.'
=> '只有把该邮件移至收件箱才可以访问其他网页。',

   'Access to other pages will be prevented until you have moved all critical messages to your inbox.'
=> '只有把所有的重要邮件移至收件箱才可以访问其他网页。',

   'Move to Inbox'
=> '移至收件箱',

   'Move to Inbox/Compose reply'
=> '移至收件箱并回复',

   'Confirm Receipt'
=> '确认已收到',

   'Confirm Receipt and Reply'
=> '确认已收到并回复',

   'Displaying Critical Messages'
=> '显示重要邮件',

   'Confirming Receipt'
=> '确认已收到',

   'Confirmed Receipt'
=> '确认已收到',

   'Communicate'
=> '通讯',

   'Replying to a Critical Message'
=> '针对重要邮件',

   'Answer Available'
=> '答复可用',

   ' to '
=> ' 到 ', # ???

   'Event from [_1] to [_2]'
=> '活动由 [_1] 至 [_2]',

   '[_1]: [_2] from domain [_3]'
=> '[_1]: [_2] 从域 [_3]',

   'The following problems occurred:'
=> '发生下列问题：',

   'Could not initialize [_1] at this time.'
=> '目前无法初始化[_1]。',

   'Please try again.'
=> '请再试一次。',

   'Please try again'
=> '请再试一次',

   'in this course'
=> '在该课程中',

   'Remove Checked Entries'
=> '删除选中的条目',

   'Modify Student Data'
=> '修改学生资料',

   'First name'
=> '名字',

   'Middle name'
=> '第二个名字',

   'Last name'
=> '姓氏',

   'ID'
=> 'ID/学号',

   'Sending critical message'
=> '发送重要消息',

   'Replying to'
=> '回复',

   '<b>[_1] messages</b>: showing messages [_2] through [_3] of [_4].'
=> '<b>消息 ([_1])</b>：显示消息[_2]通过[_3]的[_4] 。',

   'Broadcast Message'
=> '广播消息',

   'randomly pick [quant,_1,resource]'
=> '随机挑选 [quant,_1,resource,resource]',

   'contents hidden'
=> '隐藏的内容',

   'URLs hidden'
=> '隐藏 URLs',

   'random order'
=> '随机顺序',

   'Resources in course with version changes since yesterday'
=> '课程中的资源，从昨天起版本的变化',

   'Version changes since Yesterday'
=> '从昨天起版本的变化',

   'Resources in course with version changes since last week'
=> '课程中的资源，从上周起版本的变化',

   'Version changes since last Week'
=> '从上周起版本的变化',

   'Resources in course with version changes since last month'
=> '课程中的资源，从上个月起版本的变化',

   'Version changes since last Month'
=> '从上个月起版本的变化',

   'Resources in course with version changes seit start of course'
=> '课程中的资源，从课程开始起版本的变化',

   'Version changes since start of Course'
=> '从课程开始起版本的变化',

   'No version changes since yesterday'
=> '从昨天起版本没有变化',

   'No version changes since last week'
=> '从上周起版本没有变化',

   'No version changes since last month'
=> '从上个月起版本没有变化',

   'No version changes since start of course'
=> '从课程开始起版本没有变化',

   'version changes since yesterday'
=> '从昨天起版本的变化',

   'version changes since last week'
=> '从上周起版本的变化',

   'version changes since last month'
=> '从上个月起版本的变化',

   'version changes since start of course'
=> '从课程开始起版本的变化',

   'Roles for which access to course has expired since yesterday'
=> '从昨天起该课程过期的角色',

   'Roles for which access to course has expired since last week'
=> '从上周起该课程过期的角色',

   'Roles for which access to course has expired since last month'
=> '从上个月起该课程过期的角色',

   'Roles for which access to course has expired since start of course'
=> '从课程开始起过期的角色',

   'There are no roles which expired since yesterday'
=> '没有角色从昨天起过期了',

   'There are no roles which expired since last week'
=> '没有角色从上周起过期了',

   'There are no roles which expired since last month'
=> '没有角色从上个月起过期了',

   'There are no roles which expired since start of course'
=> '没有角色从课程开始起过期了',

   'roles which expired since yesterday'
=> '从昨天起该课程过期的角色',

   'roles which expired since last week'
=> '从上周起该课程过期的角色',

   'roles which expired since last month'
=> '从上个月起该课程过期的角色',

   'roles which expired since start of course'
=> '从课程开始起过期的角色',

   'Roles for which access to course has become available since yesterday'
=> '从昨天起分配给该课程的角色',

   'Roles for which access to course has become available since last week'
=> '从上周起分配给该课程的角色',

   'Roles for which access to course has become available since last month'
=> '从上个月起分配给该课程的角色',

   'Roles for which access to course has become available since start of course'
=> '从课程开始起分配给该课程的角色',

   'There are no roles which have become active since yesterday'
=> '从昨天起没有角色分配给该课程',

   'There are no roles which have become active since last week'
=> '从上周起没有角色分配给该课程',

   'There are no roles which have become active since last month'
=> '从上个月起没有角色分配给该课程',

   'There are no roles which have become active since start of course'
=> '从课程开始起没有角色分配给该课程',

   'roles which have become active since yesterday'
=> '从昨天起分配给该课程的角色',

   'roles which have become active since last week'
=> '从上周起分配给该课程的角色',

   'roles which have become active since last month'
=> '从上个月起分配给该课程的角色',

   'roles which have become active since start of course'
=> '从课程开始起分配给该课程的角色',

   'Show all posts'
=> '查看所有帖子',

   'to display'
=> '显示', # ???

   'posts previously marked read'
=> '帖子先前标记为已读',

   'previously viewed posts'
=> '先前浏览的帖子',

   'NEW'
=> '新的',

   'Preferences on what is marked as NEW'
=> '偏好，什么将被标记为新',

   'Mark NEW posts no longer new'
=> '随着新的帖子将不再标记为新',

   'Sorting/Filtering options'
=> '排序/过滤选项',

   'Export'
=> '导出',

   'Attachments'
=> '附件',

   'Download the zip file from [_1]Discussion Posting Archive'
=> '下载zip档案由[_1]讨论发布档案',

   'The following errors occurred during export - [_1]'
=> 'Beim Exportieren sind folgende Fehler aufgetreten: [_1]',

   'Unfortunately you will not be able to retrieve an archive of the discussion posts at this time, because there was a problem creating a manifest file.'
=> 'Leider können Sie derzeit kein Archiv von Diskussionsbeiträgen erhalten, da es Probleme mit der Erstellung einer Manifest-Datei gab.',

   'Unfortunately you will not be able to retrieve an IMS archive of this posts at this time, because there was a problem creating a manifest file.'
=> 'Leider können Sie derzeit kein IMS-Archiv erhalten, da es Probleme mit der Erstellung einer Manifest-Datei gab.',

   'Make Visible'
=> '显示',

   'Mark unread'
=> 'Als ungelesen kennzeichnen',

   'Mark read'
=> 'Als gelesen kennzeichnen',

   'This post has been edited by the author.'
=> 'Dieser Beitrag wurde vom Autor überarbeitet.',

   'Display all versions'
=> 'Alle Versionen anzeigen',

   'Earlier version(s) were posted on: '
=> 'Frühere Versionen wurden gesendet am: ',

   'You do not have privileges to view all versions of posts.'
=> 'Sie sind nicht berechtigt, alle Versionen von Beiträgen anzuschauen.',

   'Please select a different role.'
=> 'Bitte wählen Sie eine andere Benutzerrolle.',

   'Error copying file attachment - [_1] to IMS package'
=> 'Fehler beim Kopieren des Datei-Anhangs - [_1] ins IMS-Paket',

   'Error copying file attachment - [_1] to IMS package: '
=> 'Fehler beim Kopieren des Datei-Anhangs - [_1] ins IMS-Paket: ',

   'Re: '
=> 'Re: ',

   'Please select a feedback type.'
=> 'Bitte wählen Sie einen Feedback-Typ aus.',

   'Sorry, no feedback possible on this resource  ...'
=> 'Sorry, für diese Ressource kann kein Feedback gesendet werden.',

   'Error sending message to [_1], no user specified.'
=> 'Fehler beim Senden der Nachricht an [_1]. Es wurde kein Benutzer angegeben.',

   'Error sending message to [_1], no domain specified.'
=> 'Fehler beim Senden der Nachricht an [_1]. Es wurde keine Domäne angegeben.',

   'Error sending message to'
=> 'Fehler beim Sender der Nachricht an',

   'Not registered'
=> '未注册', # ???

   'Editing not permitted'
=> '不允许编辑',

   'Marked postings read/unread'
=> '标记贴子为已读/未读',

   'Changed sort/filter'
=> '改变排序/过滤器',

   'Changed display status'
=> '改变显示状态',

   'Deletion not permitted'
=> '不允许删除',

   'Changed discussion status'
=> '讨论的状态已更改',

   'Added to my course blog'
=> '添加到我的课程博客',

   'Back to previous page'
=> '返回前一页',

   'Go to previous page'
=> '返回前一页',

   'Return to previous page'
=> '返回前一页',

   'Untitled resource'
=> '资源没有标题',

   'Discussion display options'
=> '讨论显示选项',

   'Preferences can be set for this discussion that determine ....'
=> '这个讨论可以设置使用偏好',

   'Which posts are displayed when you display this bulletin board or resource, and'
=> '哪些讨论将被显示在您的公告栏或资源里',

   'Under what circumstances posts are identified as "NEW", and'
=> '在什么情况下讨论被确定为“新”',

   'Whether individual posts can be marked as read/unread'
=> '个别帖子是否可以被标记为已读/未读',

   'Posts not marked read'
=> '讨论没有标记为已读',

   'New posts cease to be identified as "New"?'
=> '新的讨论不再被标识为“新”？',

   'New posts cease to be identified as "NEW"?'
=> '新的讨论不再被标识为“新”？',

   'Option to mark each post as read/unread?'
=> '选择帖子标记为已读/未读？',

   'Shown'
=> '显示',

   'Not shown'
=> '不显示',

   'Discussion options'
=> '论坛选项',

   'Set options that control the sort order of posts, and/or which posts are displayed.'
=> 'Einstellungen der Sortierungsreihenfolge von Beiträgen und welche Beiträge angezeigt werden',

   'Sort order'
=> '排序顺序',

   'Date order - oldest first'
=> '按日期顺序 - 最老的优先',

   'Date order - newest first'
=> '按日期顺序 - 最新的优先',

   'Threaded'
=> '按帖子', # ???

   'By subject'
=> '按主题',

   'By domain and username'
=> '按域名和用户名',

   'By last name, first name'
=> '按姓氏，名字',

   'Specific role status'
=> '具体角色的状态',

   'Roles of any status'
=> '任意的角色',

   'Only active roles'
=> '只有现在的角色',

   'Only past roles'
=> '只有过去的角色',

   'Only future roles'
=> '只有未来的角色',

   'Specific user roles'
=> '特定的用户角色',

   'All roles'
=> '所有角色',

   'Students'
=> '学生',

   'Course Coordinators'
=> '课程协调员',

   'Instructors'
=> '讲师',

   'TAs'
=> '辅导员',

   'Exam proctors'
=> '监考老师',

   'Custom role'
=> '自定义角色',

   'Custom roles'
=> '自定义角色',

   'Specific sections'
=> '具体章节',

   'Specific groups'
=> '特定组',

   'Pick specific users (by name)'
=> '选择特定的用户 (姓)',

   'Show a list of current posters'
=> 'Liste aktueller Beitragssender anzeigen',

   'So far, no data has been returned for your request'
=> '到现在为止，您的查询没有返回任何数据。',

   'Select a user'
=> '选择一个用户',

   'An error occurred while processing this resource. The course personnel ([_1]) and the author have been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Das Kurspersonal ([_1]) und der Autor wurden informiert.',

   'photo'
=> '图片',

   'Critical Message'
=> '重要邮件',

   'Display a Message'
=> '显示邮件',

   'Back to Folder Display'
=> '返回文件夹列表',

   'Currently available actions (will open extra window):'
=> '目前可采取的行动 (在新窗口中打开):',

   'There are no ungelesen messages in this folder.' # !
=> '在此文件夹中没有未阅读邮件。',

   'There are no gelesen messages in this folder' # !
=> '在此文件夹中没有已阅读邮件。',

   'There are no weitergeleitet messages in this folder.' # !
=> '在此文件夹中没有转发的邮件。',

   'You have not replied to any messages in this folder.'
=> '在此文件夹中您没有需要回答的邮件。',

   'Empty Folder'
=> '空文件夹',

   'Cc:'
=> '抄送：',

   'Bcc:'
=> '密送：',

   'Bcc'
=> '密送',

   'Retrieve discussion and message records'
=> '检索讨论和信息记录',

   'New Record (record is visible to course faculty and staff)'
=> '新记录 (只有课程管理者和工作人员可见)：',

   'Post this Record'
=> '保存',

   'Revise your search criteria for this domain'
=> 'Suchkriterien für die Suche in dieser Domäne ändern',

   'Metadata Modified'
=> 'Geänderte Metadaten',

   'Use of LON-CAPA requires Javascript to be enabled in your web browser.'
=> 'Zur Verwendung von LON-CAPA ist es notwendig, dass Sie Javascript in Ihrem Webbrowser aktiviert haben.',

   'As this is not the case, most functionality in the system will be unavailable.'
=> 'Da dies momentan nicht der Fall ist, werden die meisten Funktionen des Systems nicht zur Verfügung stehen.',

   "You have requested to create file in directory [_1] which doesn't exist. The requested directory path has been removed from the requested file name."
=> "Schreiben in das Verzeichnis [_1] ist nicht möglich, da es nicht existiert. Der entsprechende Verzeichnispfad wurde daher entfernt.",

   'Directory'
=> '目录',

   'Only empty directories may be deleted.'
=> '只有空的目录可以被删除。',

   'You must delete the contents of the directory first.'
=> '您必须首先删除目录中的内容。',

   'Cannot delete non-obsolete published file'
=> 'Veröffentlichte, aber nicht als überholt gekennzeichnete Dateien können nicht gelöscht werden.',

   'Must not include'
=> 'Darf nicht enthalten:',

   'Name of new file is the same as name of old file'
=> 'Name der neuen Datei ist der gleiche wie der der alten Datei',

   'no action taken'
=> 'keine Aktion ausgeführt',

   'copy metadata error'
=> 'Fehler beim Metadaten-Kopieren',

   'No New filename specified'
=> 'Kein neuer Dateiname angegeben',

   'Warning: a published problem of this name exists.'
=> 'Achtung: eine veröffentlichte Aufgabe mit diesem Namen existiert bereits.',

   'Warning: a published library of this name exists.'
=> 'Achtung: eine veröffentlichte Bibliothek mit diesem Namen existiert bereits.',

   'Bad filename [_1].<br /> <tt>(name).(number).(extension)</tt> not allowed. <br /> Removing the <tt>.number.</tt> from requested filename.'
=> 'Ungültiger Dateiname [_1].<br /> <tt>(Name).(Zahl).(Erweiterung)</tt> ist nicht zulässig. <br /> Entferne <tt>.Zahl.</tt> vom gewünschten Dateinamen.',

   'Cannot change MIME type of a directory'
=> 'Der MIME-Typ eines Verzeichnisses kann nicht geändert werden',

   'Cannot rename or move non-obsolete published file'
=> 'Veröffentlichte, aber nicht als überholt gekennzeichnete Dateien können nicht umbenannt oder verschoben werden',

   'Change discussion display'
=> 'Anzeige von Diskussionen ändern',

   'Choose whether or not to display a count of the number of new posts for each resource or bulletin board which has unread posts.'
=> 'Wahl, ob Anzahl neuer Beiträge in einzelnen Ressourcen oder Anzahl ungelesener Beiträge in Schwarzen Brettern angezeigt werden sollen.',

   "This can increase the time taken to gather data for the '<i>What's New?</i>' page by a few seconds."
=> "Dies kann die Dauer des Zusammenstellens der Daten für die '<i>Was-gibt's-Neues-Seite</i>' um ein paar Sekunden erhöhen.",

   'Currently set to [_1].'
=> '当前设置为 [_1].',

   'Change to [_1]'
=> '改变为 [_1]',

   'No change'
=> '无变化',

   'Count unread posts in discussions display set to [_1]'
=> '未读讨论计数显示设置为 [_1]',

   'Groups Manager'
=> '组管理',

   'Group access start and end dates'
=> '组访问开始和结束日期',

   'None available'
=> '无可用',

   'There are no active, future or previous group members to modify.'
=> 'Es existieren weder aktive, zukünftige noch in der Vergangenheit liegende Gruppen-Mitgliedschaften, die geändert werden könnten.',

   'Members to delete or expire'
=> '成员身份到期或将被删除',

   'To be deleted'
=> '将删除的',

   'To be expired'
=> '期满',

   'No members to be deleted or expired from the group.'
=> 'Es existieren keine Mitgliedschaften, die aus der Gruppe entfernt werden oder auslaufen könnten.',

   'Files: [_1]'
=> '文件： [_1]',

   'Folders: [_1]'
=> '文件夹： [_1]',

   'Choose Task'
=> '选择行动',

   'Modify default group settings'
=> '修改默认组设置',

   'Modify access, tools and/or privileges for previous, future, or current members'
=> '修改组成员访问，工具和权限',

   'Add member(s) to the group'
=> '添加组成员',

   'Group Settings'
=> '组设定',

   'Modify/Delete Members'
=> '修改/删除会员',

   'Current Tool Set'
=> '目前的工具集',

   'Change Privileges'
=> '更改权限',

   'Membership Mapping'
=> '会员推荐',

   'Group name, title and available collaborative tools'
=> '组名称，所有权和使用协作工具',

   'Letters, numbers and underscore only'
=> '只有字母，数字和下划线',

   'Discussion boards'
=> '论坛',

   'E-mail'
=> 'E-Mail',

   'File Repository'
=> '档案库',

   'Group home page'
=> '组首页',

   'Membership Roster'
=> '会员名册',

   'Granularity:'
=> '細微性：',

   'Different subsets of the chosen collaborative tools for different group members?'
=> '不同的组成员选择不同的协作工具？',

#   'Disk quota: '
#=> '磁盘配额： ',

   'Disk quota'
=> '磁盘配额',

   'If you enable the file repository for the group, allocate a disk quota.'
=> '如果您对组启用了文件存放，请分配磁盘配额：',

   '[_1] Mb'
=> '[_1] MB',

   'A total of [_1] Mb can be divided amongst all groups in the course, and [_2] Mb are currently unallocated.'
=> '该课的所有组共有 [_1] Mb 可分，[_2] MB 目前未被分配。',

   'Default start and end dates for group access'
=> '默认情况下组访问的开始和结束日期',

   'Start:'
=> '开始：',

   'End:'
=> '结束：',

   'Error: invalid course domain or number - group folder creation failed.'
=> '错误：无效的课程或域号码。建立了组列表失败。',

   'Course Groups'
=> '课程组',

   'Non-standard course - folder for all groups not added.'
=> '非标准课程 - 所有组的文件夹不会增加。',

   'Build a list of users for selection of group members'
=> '从组成员里选择来建立一个用户列表',

   'Group membership selection list criteria:'
=> '组成员名单选择标准：',

   'Pick the criteria to use to build a list of course users from which you will select '
=> '选择的标准的使用来建立一个名单，您将选择',

   'members of the new group.'
=> '新的组成员。',

   'If you do not wish to add members when you first create the group, there is no need to pick any criteria.'
=> '如果您创建的组不想立即要添加成员，就没有必要选择任何标准。',

   'A subsequent step will also allow you to specify automatic adding/dropping of group members triggered by specified user role and section <i>changes</i> in the course.'
=> '随后的步骤将自动添加/删除组成员，也可以让您指定所引发指定用户角色和第的过程中。这是通过指定的用户角色和在课程中章节<i>变化</i>被触发的。',

   'Access types'
=> '访问类型',

   'Currently has access'
=> '目前已获得',

   'Will have future access'
=> '今后将有机会',

   'Previously had access'
=> '曾获得',

   'Course roles'
=> '课程角色', # 'Benutzerrollen im Kurs',

   'Course sections'
=> '课程章节', # 'Sektionen im Kurs',

   'all sections'
=> '所有章节',

   'no section'
=> '无章节',

   'Go to next step'
=> '下一步',

   'Invalid group name'
=> '无效的组名称',

   'The group name entered '
=> '输入的组名称 ',

   'is not a valid name.'
=> '不是一个有效的名称。',

   'can not be used as it is the name of '
=> '不能使用，因为它的名字是 ',

   'an existing [_1]'
=> '现有的 [_1]',

   ' in this Course'
=> ' 在该课程里',

   'Group names and section names used in a Course must be unique.'
=> '组名称和章节名称在课程中必须是独一无二的。',

   'Group names may only contain letters, numbers or underscores.'
=> '组名称只能包含字母，数字或下划线。',

   'Go to previous step'
=> '返回',

   'Select Members'
=> '选择成员',

   'Your group selections - '
=> '您的组选择 - ',

   'The following settings will apply to the group:'
=> '下面的设置将适用于本组：',

   'Granularity'
=> '細微性',

   'File quota'
=> '文件共享',

   'Default access dates'
=> '默认访问日期',

   'Different collaborative tools<br />for different members:'
=> '不同的协作工具<br />对不同的成员组成：',

   'Start date'
=> '开始日期',

   'Start date:'
=> '开始日期：',

   'End date'
=> '结束日期',

   'End date:'
=> '结束日期：',

   'Available for assignment to members:'
=> '可供成员访问：',

   'Unavailable for assignment:'
=> '没有可能访问：',

   'User privileges for collaborative tools'
=> '协作工具的用户权限',

   'For each collaborative tool you have chosen to include, there is a set of core privileges which all group members assigned use of the tool will receive.'
=> 'Für jedes der kollaborativen Werkzeuge, das Sie zur Verwendung gewählt haben, existiert eine Reihe von Grundberechtigungen, die allen Gruppenmitgliedern, die dieses Werkzeug erhalten, zugewiesen werden.',

   'For some tools there are also additional optional privileges which can be set.'
=> 'Für manche Werkzeuge können auch weitere optionale Berechtigungen festgelegt werden.',

   'Choose one of the following:'
=> 'Wählen Sie eines der folgenden:',

   'For the collaborative tools you have chosen to include only core privileges are available, so there are no optional privileges to assign.'
=> 'Für die von Ihnen gewählten kollaborativen Werkzeuge sind nur Grundberechtigungen verfügbar. Daher können keine optionalen Berechtigungen zugewiesen werden.',

   'As you have chosen not to include any collaborative tools in the group, no default optional privileges need to be set.'
=> 'Da Sie keinerlei kollaborativen Werkzeuge für die Gruppe gewählt haben, die eingebunden werden sollen, brauchen keine voreingestellten optionalen Berechtigungen eingestellt werden.',

   'Group membership'
=> '组员',

   'Add members'
=> '添加成员',

   'Assign collaborative tools'
=> '转让协作工具',

   'Tools'
=> '工具',

   'Add Members'
=> '添加成员',

   'Add?'
=> '添加？',

   'All:'
=> '全部：',

   'You have indicated that the file repository should be enabled, but you have set the respository quota to 0 Mb.\nThis will prevent any upload of files.\nPlease set a value or disable the repository feature.'
=> 'Sie haben angegeben, dass die Dateisammlung aktiviert werden soll, jedoch einen Speicherplatz von 0 MB angegeben.\nDies verhindert jegliches Hochladen von Dateien.\nBitte geben Sie einen Wert größer 0 ein oder deaktivieren Sie die Dateisammlung.',

   '[_1] [_2] was created.<br />'
=> '[_1] [_2] 已创建。<br />',

   'Group membership list updated.'
=> '该组成员名单已经更新。',

   'Any currently logged in course users affected by the changes you made to group membership or privileges for the [_1] group will need to log out and log back in for their LON-CAPA sessions to reflect these changes.'
=> 'Sie haben Gruppen-Mitgliedschaften und/oder -berechtigungen für die Gruppe [_1] eingestellt bzw. geändert. Alle derzeit angemeldeten Benutzer, für die diese Einstellungen wirken, müssen sich aus- und wieder einloggen, damit für sie die Änderungen wirksam werden.',

   'An error occurred while updating the group membership list:'
=> 'Beim Aktualisieren der Gruppen-Teilnehmerliste ist ein Fehler aufgetreten:',

   'Choose Privileges'
=> 'Auswahl der Berechtigungen',

   'Setting Changes Complete'
=> 'Änderungen der Einstellungen abgeschlossen',

   'Modifications Complete'
=> 'Änderungen abgeschlossen',

   'Creation Complete'
=> 'Erstellung abgeschlossen',

   'Additions Complete'
=> 'Hinzufügungen abgeschlossen',

   'Verify deletion'
=> 'Entfernen-Bestätigung',

   'Deletion Complete'
=> 'Entfernen abgeschlossen',

   'Create Group'
=> '创建组',

   'discussion'
=> '论坛',

   'email files'
=> '电子邮件档案',

   'homepage'
=> '主页',

   'roster'
=> '花名册',

   'Edit Group Homepage'
=> '编辑组首页',

   'Edit Group Settings'
=> '编辑组设置',

   'Available Group Tools'
=> '可用的工具组',

   'Group Chat Room'
=> '组聊天室',

   'Group e-mail'
=> '组电子邮箱',

   'Group page - [_1]'
=> '组页 - [_1]',

   '[_1] discussion boards - [_2]'
=> '[_1] 论坛 - [_2]',

   'New Discussion Board'
=> '创建新论坛',

   'There are currently no discussion boards in this [_1].'
=> '在这 [_1] 里目前还没有论坛。',

   'Discussion Board Title'
=> '论坛讨论标题',

   'The new discussion board was added successfully.<br />'
=> '新的讨论论坛已成功创建。<br />',

   'Edit [_1] board'
=> '编辑 [_1] 论坛',

   'View all group discussion boards'
=> '查看各组讨论论坛',

   'Show Student View'
=> '以学生视角显示',

   'Note: in anonymous discussion, your name is visible only to course faculty'
=> '注意：在匿名的讨论中，你的名字只有课程教师看的见。',

   'Send a Message in a Group'
=> '组内发送邮件',

   'As this group has no members, there are no recipients to select.'
=> '由于这组没有成员，您无法选择收件人。',

   'Allow replies'
=> '允许回复',

   'Reply to'
=> '回复',

   'Group Portfolio'
=> '组档案',

   '[_1] portfolio files - [_2]'
=> '[_1] 组合文件 - [_2]',

   'There are no membership data to display for this [_1]'
=> 'Für diesen [_1] existieren keine anzeigbaren Mitgliedsdaten.',

   'Group Membership'
=> '组成员',

   '[_1] membership status - [_2]'
=> '[_1] 成员状态 - [_2]',

   'Group Message'
=> '组邮件',

   'Compose Group Message'
=> '撰写组邮件',

   'Course Discussion Boards'
=> '课程讨论区',

   'Post Discussion'
=> '提交讨论文件',

   'Post Anonymous Discussion'
=> '匿名提交讨论文件',

   'Content'
=> '内容',

   'You do not currently have rights to view this group.'
=> 'Sie haben derzeit keine Berechtigung diese Gruppe zu sehen.',

   'No page information provided.'
=> 'Keine Seiteninformationen angegeben.',

   '<p>No page information provided.</p>'
=> '<p>Keine Seiteninformationen angegeben.</p>',

   'Available functions'
=> '可用的功能',

   'No group functionality.'
=> 'Keine Gruppenfunktionen.',

   'No group functionality (e.g., e-mail, discussion, chat or file upload) is currently available to you in this group: [_1].'
=> 'Derzeit ist in der Gruppe [_1] keine Gruppenfunktion (z.B. E-Mail, Diskussion, Chat oder Dateien-Hochladen) verfügbar.',

   'Group Page'
=> '组页',

   'Quota allocated to group portfolio:'
=> '配额分配给组文件夹',


   'The quota is currently [_1] Mb'
=> '目前的配额： [_1] MB',

   'The quota can be increased to [_1] Mb, by adding all unallocated space for groups in the course.'
=> '配额可提高到 [_1] MB， 加上该课程的组中所有未分配的空间。',

   'Each collaborative tool includes core privileges assigned to all members with access to the tool. Some tools may also feature additional privileges which can be set for specific members.'
=> '每个协作工具，包括核心权限，分配给所有成员基本权限。某些工具可能会还具有额外的权限，即可以设置特定的成员。',

   'All group members will receive the same privileges for any tool assigned to them, including the default set of optional privileges.'
=> '所有组成员分配给他们的任何工具将得到相同的权限，包括默认设置可选特权。',

   'Different group members may receive different privileges from others for the tools they have been assigned.'
=> 'Unterschiedliche Gruppenmitglieder können unterschiedliche Berechtigungen für Werkzeuge von anderen erhalten, die diese zugewiesen bekommen haben.',

   'Indicate which <b>optional</b> privileges members will receive by default for a specific tool.'
=> 'Angabe, welche <i>optionalen</i> Berechtigungen für ein bestimmtes Werkzeug voreingestellt zugewiesen werden sollen.',

   'These will be the privileges given to members assigned in the future via automatic group assignment for users who receive specific sections/roles in the course '
=> 'Es handelt sich um die Berechtigungen, die Gruppenmitglieder durch das automatische Belegen von Gruppen zukünftig erhalten. Dies betrifft Benutzer, die bestimmte Sektionen/Rollen im Kurs erhalten ',

   'if enabled on the next page'
=> 'falls auf der nächsten Seite aktiviert',

   'if enabled below'
=> 'falls im Folgenden aktiviert',

   'Additional privileges'
=> 'Zusätzliche Berechtigungen',

   'Fixed privileges'
=> '固定权限',

   'Optional privileges'
=> '任择权限',

   'Collaborative Tool'
=> '协作工具',

   'Fixed'
=> '固定的',

   'Optional'
=> '可选的',

   'Additional Tools'
=> '其他工具',

   'Core privileges'
=> '基本权限',

   'For the collaborative tools included for group members being added or modified, there are no optional privileges to set for specific members.'
=> 'Für die kollaborativen Werkzeuge, die für Gruppenmitglieder hinzugefügt bzw. geändert werden, gibt es keine optionalen Berechtigungen, die für bestimmte Mitglieder einzustellen wären.',

   'All new group members will receive the same privileges.'
=> '所有新的小组成员将得到同样的权限。',

   'If previously expired members are being re-enabled, or if access for future members is being activated now, previously set privileges will be preserved.'
=> '如果以前到期的成员正在重新启用，或者未来进入的成员现在正在激活，先前的权限将被保留。',

   'As no group members are being added, there are no specific user privileges to set.'
=> '由于没有增加组成员，没有设置具体用户的权限。',

   'No group member privileges to display or set, as you have not indicated that you will be activating, re-enabling, changing privileges, or adding/removing tools for any current members'
=> '目前还没有任何组织成员的权限以显示或设置，因为您还没有表示，你将被激活，重新启用，改变权限，或添加/删除任何现有成员的工具。',

   'Currently the group is configured '
=> '目前该组的配置， ',

   'so different members can receive different optional privileges for a particular tool.'
=> '不同成员为特定的工具可以得到不同的可选权限。',

   'so all members will receive the same optional privileges for a particular tool.'
=> '所有成员为特定的工具可以得到相同的可选权限。',

   'Settings for automatic group enrollment'
=> '设置自动分配组',

   'Group membership mapping to specific sections/roles'
=> 'Verweis von Gruppen-Mitgliedschaften auf bestimmte Sektionen/Rollen',

   'Enable/disable automatic group enrollment for users in specified roles and sections'
=> 'Aktivierung/Deaktivierung der automatischen Belegung von Gruppen für Benutzer mit bestimmten Rollen und in bestimmten Sektionen',

   'If automatic group enrollment is enabled, when a user is newly assigned a course-wide or section-specific role, he/she will automatically be added as a member of the group, with start and end access dates defined by the default dates set for the group, unless he/she is already a group member, with access dates that permit either current or future group access.'
=> 'Falls die automatische Gruppenbelegung aktiviert ist: Wenn ein Benutzer eine kursweite oder sektionsspezifische Rolle neu zugewiesen bekommen hat, wird er automatisch als Mitglied der Gruppe hinzugefügt. Das Anfangs- und Endedatum für den Zugriff wird durch die Datumswerte vorgegeben, die für die Gruppe voreingestellt sind. Das allerdings nur, wenn der Benutzer nicht bereits Gruppenmitglied mit Zugriffsdaten ist, die aktuellen oder zukünftigen Gruppenzugriff verbieten.',

   "If automatic group disenrollment is enabled, when a user's role is expired, access to the group will be terminated unless the user continues to have other course-wide or section-specific active or future roles which receive automatic membership in the group."
=> "Falls das automatische Ausschließen aus Gruppen aktiviert ist: Wenn eine Benutzerrolle ausläuft, wird der Zugriff auf die Gruppe entzogen, sofern der Benutzer nicht andere kursweite oder sektionsspezifische aktive oder zukünftige Rollen hat, die automatischen Gruppenzugriff ermöglichen.",

   'Automatically enable group membership when roles are added?'
=> 'Automatisches Belegen von Gruppen, wenn Rollen hinzugefügt werden?',

   'Automatically expire group membership when roles are removed?'
=> 'Automatisches Ausschließen aus Gruppen, wenn Rollen entfernt werden?',

   'Currently set to'
=> '当前设置为',

   'Mapping of roles and sections affected by automatic group enrollment/disenrollment follows scheme chosen below.'
=> 'Das Verweisen von Rollen und Sektionen durch das automatische Belegen von/Ausschließen aus Gruppen folgt dem folgenden Schema.',

   'Pick roles and sections for automatic group enrollment'
=> 'Auswahl von Rollen und Sektionen für das automatische Belegen von Gruppen',

   'Active?'
=> '激活？',

   'Send group message'
=> '发送组邮件', # .n.t.

   'Create boards'
=> '创建论坛', # n.t.

   'Edit own posts'
=> '编辑自己的帖子', # .n.t.

   'Hide/Delete any post'
=> '隐藏/删除 任意帖子',

   'View boards'
=> '查看论坛', # .n.t.

   'Control Access'
=> '访问控制', # .n.t.

   'Basic Display'
=> '基本显示', # .n.t.

   'Detailed Display'
=> '详细显示', # .n.t.

   'View page'
=> '查看网页', # .n.t.

   'Modify page'
=> '修改网页', # .n.t.

   'email'
=> 'E-Mail',

   'Broadcast message'
=> '广播邮件',

   'files'
=> '文件',

   'Foils without names exist. This can cause problems to malfunction.'
=> 'Es existieren Auswahlmöglichkeiten ohne Namen. Das könnte eine fehlerhafte Funktionalität verursachen.',

   'Unknown area style [_1]'
=> 'Unbekannter Bereichstyp: [_1]',

   "The message itself will begin with a first line: <i>'Forwarded message from'</i> followed by the original sender's name."
=> "Die Nachricht wird in der ersten Zeile mit <i>Weitergeleitete Nachricht von'</i> starten, gefolgt vom Originalnamen des Absenders.",

   'Forwarded message from '
=> 'Weitergeleitete Nachricht von ',

   'You received a critical message from [_1] in LON-CAPA.'
=> 'Sie haben eine wichtige Nachricht von [_1] in LON-CAPA erhalten.',

   'You received a message from [_1] in LON-CAPA.'
=> 'Sie haben eine Nachricht von [_1] in LON-CAPA erhalten.',

   "'New'  critical message from "
=> "Neue wichtige Nachricht von ",

   "'New'  message from "
=> "Neue Nachricht von ",

   'Refers to'
=> 'Bezieht sich auf',

   'Previous attempts of student (if applicable)'
=> 'Bisherige Versuche des Studenten (falls verfügbar)',

   'Original screen output (if applicable)'
=> 'Original-Bildschirmausgabe (falls verfügbar)',

   'Correct Answer(s) (if applicable)'
=> 'Korrekte Antwort(en) (falls verfügbar)',

   'LON-CAPA messages sent to you between [_1] and [_2] will be inaccessible until the end of this time period, because you are a student in a course with an active communications block.'
=> 'Sie haben auf Ihnen zugesandte LON-CAPA-Nachrichten zwischen [_1] und [_2] bis zum Ende dieses Zeitbereichs keinen Zugriff, da Sie Student in einem Kurs mit aktiver Kommunikationssperre sind.',

   'The subject is 

 [_1]

'
=> 'Der Betreff lautet 

 [_1]

',

   'Excerpt'
=> 'Auszug',

   'Use 

 [_1]

to access the full message.'
=> 'Ueber 

 [_1]

erhalten Sie auf die gesamte Nachricht Zugriff.',

   'You can reply to this message'
=> 'Sie können auf diese Nachricht antworten.',

   'A reply will not be received by the recipient!'
=> 'Eine Antwort wuerde nicht beim vorgesehenen Empfaenger ankommen!',

   "Include in course's 'User records' for recipient(s)"
=> "包括课程中的'用户记录'给收信人",

   'No replies to sender'
=> '没有答复发件人',

   'Display Message'
=> '显示邮件',

   'Replying to a Message'
=> '回复邮件',

   'Forwarding a Message'
=> '转发邮件',

   'Forwarding Multiple Messages'
=> '转发多封邮件',

   'At end of file some tags were still left unclosed, '
=> 'Am Ende der Datei sind noch nicht geschlossene Tags übrig: ',

   'Upload and Send'
=> '上传和发送',

   'Select courses'
=> '选择课程',

   'Choose which course(s) to list.'
=> 'Auswahl der Kurse, die angezeigt werden sollen',

   'Display courses'
=> '显示课程',

   'Public'
=> '公开的',

   'Answer [_1]'
=> '答复 [_1]',

   'EditXML [_1]'
=> 'XML-编辑器 [_1]',

   'Not authorized'
=> '未授权',

   'An error occurred while processing this resource. The author has been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Der Autor wurde informiert.',

   'Code ran too long. It ran for more than'
=> 'Die Ausführung hat zu lange gedauert. Sie dauerte länger als',

   'seconds occurred while running &lt;while&gt; on line'
=> 'Sekunden, während &lt;while&gt; ausgeführt wurde in Zeile',

   'Student View'
=> '学生视野',

   'Correct answer'
=> '正确答案',

   'Could not identify problem.'
=> '无法确定的问题。', # ???

   'Chart'
=> '图表',

   'Student Data</b>'
=> '学生资料</b>', # !

   'HTML, with links'
=> 'HTML格式，链接',

   'HTML, with all links'
=> 'HTML格式，与所有链接',

   'HTML, without links'
=> 'HTML格式，没有链接',

   'Output Data'
=> '输出数据',

   'Scores Summary'
=> '总分',

   'Scores Per Problem'
=> '每题分数',

   'Parts Correct'
=> 'Richtige Teile',

   'fullname'
=> '全名',

   'id'
=> 'ID/学生证号',

   'Generate Chart'
=> '生成图表',

   'Generate Graph'
=> '生成图',

   'Select One Student'
=> '选择一个学生',

   'All sections.'
=> '所有科目。',

   'Section [_1].'
=> '章节 [_1]。',

   'Section [_1]'
=> '章节 [_1]',

   'Sections [_1] and [_2].'
=> '章节 [_1] 和 [_2]。',

   'All groups.'
=> '所有组。',

   'Group [_1].'
=> '组 [_1].',

   'Groups [_1] and [_2].'
=> '组 [_1] 和 [_2].',

   'Active access status.'
=> 'Aktiver Zugriffsstatus.',

   'Future access status.'
=> 'Zukünftiger Zugriffsstatus.',

   'Expired access status.'
=> 'Abgelaufener Zugriffsstatus.',

   'Any access status.'
=> 'Beliebiger Zugriffsstatus.',

   'Show links in new window:'
=> 'Links in neuem Fenster öffnen:',

   'Summary Tables'
=> 'Zusammenfassende Tabellen',

   'Summary table for [_1] ([_2]@[_3])'
=> 'Zusammenfassende Tabelle für [_1] ([_2]@[_3])',

   'Average'
=> 'Durchschnitt',

   'Maximum'
=> 'Maximum',

   'Return to the chart'
=> 'Zurück zum Chart',

   "Click on a student's name or username to view their chart"
=> "Klicken Sie auf den Namen oder die Benutzerkennung eines Studenten, um dessen Chart anzuzeigen",

   'status'
=> '状态',

   'groups'
=> '组',

   'Click on a students name or username to view their chart'
=> 'Klick auf Name/Benutzerkennung zeigt zugehöriges Chart',

   'Essay will be hand graded.'
=> 'Essay wird manuell bewertet.',

   'Text you want to appear by default:'
=> '文字在默认情况下显示：',

   'Check as many files as you wish in response to the problem:'
=> '选择所有的文件对于您想答复的问题：',

   'Select portfolio files'
=> '选择组合文件',

   'Select checked files, and continue selecting'
=> '选择文件并继续选择',

   'Select checked files, and close window'
=> '选择文件并关闭窗口',

   'Copy of'
=> 'Kopie von',

   'The e-mail address you provided does not match the address recorded in the LON-CAPA system for the username and domain you provided.'
=> 'Die von Ihnen angegebene E-Mail-Adresse stimmt nicht mit der in LON-CAPA hinterlegten E-Mail-Adresse des von Ihnen angegebenen Benutzers und Domäne überein.',

   'Overall result: [_1]'
=> '总分： [_1]',

   'Dimension: [_1], status [_2] '
=> 'Dimension: [_1], Status [_2] ',

   'Queue Status'
=> '队列状态',

   'Check Mark'
=> '核选标记',

   'Return commented version of [_1] to student.'
=> 'Rückgabe kommentierter Version von [_1] an Studenten.',

   'Download All Submitted Documents'
=> 'Alle eingereichten Dokumente herunterladen',

   'Essay is [_1]% similar to an essay by [_2] in course [_3] (course id [_4]:[_5])'
=> 'Das Essay stimmt zu [_1]% mit dem Essay von [_2] im Kurs [_3] (Kurs-ID [_4]:[_5]) überein',

   'Compose message to student'
=> 'Nachricht an Studenten erstellen',

   'incl. grades'
=> '包含评分',

   'Message will be sent when you click on Save &amp; Next below.'
=> 'Nachricht wird gesendet, sobald Sie auf Speichern und weiter klicken.',

   'Set/Change parameters'
=> 'Parameter setzen/ändern',

   'Grading Feedback'
=> '评估反馈',

   'Sending message to [_1]'
=> '发送邮件至 [_1]',

   'Not allowed to modify grades for [_1]'
=> 'Keine Berechtigung zur Änderung der Bewertungen für [_1].',

   'You need to specify the username or ID'
=> 'Sie müssen eine Benutzerkennung oder eine ID/Matrikelnummer angeben',

   'You need to specify at least one grading field'
=> 'Sie müssen mindestens ein Bewertungsfeld ausfüllen',

   'Specify a file containing the class scores for current resource'
=> 'Angabe einer Datei, die Kursbewertungen für diese Ressource enthält',

   'Upload Scores'
=> '上传分数',

   'Some point values were assigned for problems with a weight of zero. These values were ignored.'
=> 'In einigen Aufgaben wurden Punkte vergeben, in denen die Gewichtung Null ist. Daher wurden diese Werte ignoriert.',

   'Use CODE:'
=> 'verwende CODE:',

   'Some resources in the sequence currently are not set to exam mode. Grading these resources currently may not work correctly.'
=> 'Einige Ressourcen in der Sequenz sind derzeit nicht auf Examen-Modus gestellt. Eine Bewertung dieser Ressourcen könnte derzeit nicht korrekt funktionieren.',

   'scores from file' # Upload scores from file
=> 'von Bewertungen aus Datei',

   'Process'
=> 'Verarbeite',

   'clicker file' # Process clicker file
=> 'Clicker-Datei',

   'Grade'
=> 'Bewerte',

   'scantron forms' # Grade scantron forms
=> 'Scantron-Formulare',

   'Verify'
=> 'Überprüfen',

   'receipt'
=> 'Nachweis-Nr.',

   'Manage'
=> 'Verwalten',

   'access times' # Manage access times
=> 'der Zugriffszeiten', # n.t.

   'saved CODEs' # View saved CODEs
=> 'gespeicherte CODEs', # n.t.

   'Specify a file containing the clicker information for this resource'
=> 'Angabe einer Datei, die Clicker-Informationen für diese Ressource enthält',

   'Upload File'
=> '上传文件',

   'Award points just for participation'
=> 'Erreichte Punkte, lediglich für Teilnahme',

   'Correctness determined from response by course personnel'
=> 'Korrektheit, bestimmt durch Antwort durch Kurspersonal',

   'Correctness determined from response with clicker ID(s)'
=> 'Korrektheit, bestimmt durch Antwort mit Clicker-ID(s)',

   'Percentage points for correct solution'
=> 'Prozentuale Punkte für korrekte Lösung',

   'Percentage points for incorrect solution'
=> 'Prozentuale Punkte für inkorrekte Lösung',

   'You need to specify a clicker ID for the correct answer'
=> 'Sie müssen für die korrekte Antwort eine Clicker-ID angeben',

   'Score based on attendance only'
=> 'Punkte, die lediglich auf Anwesenheit beruhen',

   'Correctness determined by the following IDs'
=> 'Korrektheit, bestimmt durch folgende IDs',

   'specified'
=> 'angegeben',

   'No IDs found to determine correct answer'
=> 'Keine IDs gefunden, um korrekte Antwort bestimmen zu können',

   '[_1] Error: [_2] The file you attempted to upload, [_3] contained no information. Please check that you entered the correct filename.'
=> '[_1] Fehler: [_2] Die Datei, die Sie versucht haben hochzuladen, [_3] enthält keine Informationen. Bitte überprüfen Sie, ob Sie den richtigen Dateinamen angegeben haben.',

   'Scanning clicker file'
=> 'Scanne Clicker-Datei',

   'Found [_1] question(s)'
=> '[_1] Frage(n) gefunden',

   'Awarding [_1] percent for correct and [_2] percent for incorrect responses'
=> '[_1] Prozent für korrekte und [_2] Prozent für inkorrekte Antworten erhalten',

   'Clicker registered more than once'
=> 'Clicker ist mehr als einmal registriert',

   'Unregistered Clicker'
=> 'Nicht registrierter Clicker',

   'Found [_1] registered and [_2] unregistered clickers.'
=> '[_1] registrierte und [_2] nicht registrierte Clicker gefunden.',

   'Found no correct answers answers for grading!'
=> 'Keine korrekten Antworten zur Bewertung gefunden!',

   'Found [_1] entries for grading!'
=> '[_1] Einträge zur Bewertung gefunden!',

   'Found no questions.'
=> 'Keine Fragen gefunden.',

   'Finalize Grading'
=> 'Bewertung abschließen',

   'Question [_1]'
=> 'Frage [_1]',

   'Assigning grades based on clicker file'
=> 'Weise Bewertungen zu, die auf der Clicker-Datei basieren',

   'More than one correct result given for question "[_1]": [_2] versus [_3].'
=> 'Mehr als eine korrektes Ergebnis gegeben für Frage "[_1]": [_2] gegen [_3].',

   'No correct result given for question "[_1]"!'
=> 'Kein korrektes Ergebnis für Frage "[_1]" gegeben!',

   'Correct answer: [_1]'
=> '正确答案： [_1]',

   'Successfully stored grades for [_1] student(s).'
=> 'Erfolgreiche Speicherung der Bewertungen für [_1] Studenten.',

   'Grading Menu'
=> '评估菜单',

   'Missing tags, unable to properly run file.'
=> 'Fehlende Tags. Die Datei kann nicht ordnungsgemäß ausgeführt werden.',

   'Using tag [_1] on line [_2] as end tag to [_3]'
=> 'Using tag [_1] on line [_2] as end tag to [_3]', # ??? lonxml.pm [SB 2008-08-07]

   'Found tag [_1] on line [_2] when looking for [_3] in file.'
=> 'In der Datei wurde in Zeile [_2] das Tag [_1] gefunden, wo [_3] erwartet wurde.',

   'ID [_1] contains invalid characters. IDs are only allowed to contain letters, numbers, spaces and -'
=> 'ID [_1] enthält ungültige Zeichen. Gültige Zeichen für IDs sind nur Buchstaben, Ziffern, Leerzeichen und -',

   'File not found'
=> 'Datei nicht gefunden',

   'This file appears to be a rendering of a LON-CAPA resource. If this is correct, this resource will act very oddly and incorrectly.'
=> 'Diese Datei scheint eine Umwandlung einer LON-CAPA-Ressource zu sein. Falls dies zutrifft, wird sich diese Ressource sehr unpassend und inkorrekt verhalten.', # ??? [SB 2007-11-27]

   'An error occurred while processing this resource. The instructor has been notified.'
=> 'Während der Verarbeitung dieser Ressource ist ein Fehler aufgetreten. Der Dozent wurde informiert.',

   'CourseID'
=> '课程编号',

   'DocID'
=> '文件编号',

   'Username, password and domain need to be specified.'
=> '用户名，密码和域必须指定！',

   'Untitled Resource'
=> '无名资源',

   'Not Available'
=> 'Nicht verfügbar',

   'Clear'
=> 'Leeren',

   'There are no parameters.'
=> 'Derzeit existieren keine Parametereinstellungen.',

   'enroll type/action'
=> '注册类型/行动',

   '<br />Map not loaded: The file <tt>[_1]</tt> does not exist.'
=> '<br />Inhaltszusammenstellung nicht geladen: Die Datei <tt>[_1]</tt> existiert nicht.',

   'Saved.'
=> '保存的。',

   'An error occurred while saving.'
=> 'Beim Speichern ist ein Fehler aufgetreten.',

   'Reverted.'
=> 'Zurückgesetzt.',

   'Title in map'
=> 'Titel in Inhaltszusammenstellung',

   'Filename of resource'
=> 'Dateiname der Ressource',

   'Link to published resource'
=> 'Link auf veröffentlichte Ressource',

   'Link to resource in Construction Space'
=> 'Link auf Ressource im Konstruktionsbereich',

   'Resource space'
=> 'Ressourcenbereich',

   'Construction space'
=> 'Konstruktionsbereich',

   'discard'
=> 'verwerfen',

   'Change Order'
=> 'Reihenfolge ändern',

   'Sort Imported Resources'
=> 'Importierte Ressourcen sortieren',

   'Finalize order of resources'
=> 'Reihenfolge der Ressourcen festlegen',

   'Recover Deleted'
=> 'Gelöschtes wiederherstellen',

   'Recover Removed Resources'
=> 'Gelöschte Ressourcen wiederherstellen',

   'Recover Checked'
=> 'Ausgewählte wiederherstellen',

   'Recent Detailed Assessment Statistical Data'
=> 'Aktuelle detailierte statistische Beurteilungsdaten',

   'No information available'
=> 'Keine Information verfügbar',

   'Creating new file [_1]'
=> '创建新文件 [_1]',

   'If you would like to associate this resource ([_1]) with a current or previous course, please select one from the list below, otherwise select, "None".'
=> 'Falls Sie diese Ressource ([_1]) mit einem aktuellen oder alten Kurs verknüpfen wollen, wählen Sie bitte einen Kurs aus der unten angebotenen Liste. Ansonsten wählen Sie "nichts".',

    'Associate Resource With Selected Course'
=> 'Verknüpfte Ressource mit ausgewähltem Kurs',

   'This resource is currently associated with a course ([_1]) which includes added metadata fields specific to the course.'
=> 'Diese Ressource ist derzeit mit einem Kurs ([_1]) verknüpft, der zusätzliche kursspezifische Metadaten-Felder enthält.',

   'You can choose to transfer data from the added fields to the "Notes" field if you are planning to change the course association.'
=> 'Sie können die Daten der zusätzlichen Felder in das "Bemerkungen"-Feld transferieren lassen, falls Sie vorhaben, die Kursverknüpfung zu ändern.',

   'not available'
=> 'nicht verfügbar',

   'most recent version'
=> 'neueste Version',

   'information not available'
=> 'Information nicht verfügbar',

   'Num Student'
=> 'Anz. Studenten',

   'Degree of Difficulty'
=> 'Schwierigkeitsgrad',

   'Degree of Discrimination'
=> 'Grad der Abgrenzung',

   'Time of computation'
=> 'Zeit der Erstellung',

   'Messages deleted.'
=> '邮件已删除。',

   'Error deleting messages'
=> 'Fehler beim Löschen der Nachrichten',

   'Messages cleared.'
=> '邮件已删除。',

   'Error clearing messages'
=> '删除邮件时发生错误',

   'Delete Messages for this Resource'
=> 'Nachrichten für diese Ressource löschen',

   'Back To Directory'
=> '返回目录',

   'Associated with course [_1]'
=> 'Verknüpft mit Kurs [_1]',

   'This resource is not associated with a course.'
=> 'Diese Ressource ist mit keinem Kurs verknüpft.',

   'Discard Edits and Return to Portfolio'
=> 'Änderungen verwerfen und zurück zum Portfolio-Bereich',

   'Could not transfer data in added fields to notes'
=> 'Die Daten der zusätzlichen Felder konnten nicht in das "Bemerkungen"-Feld transferiert werden',

   'Transferred data in added fields to notes'
=> 'Die Daten der zusätzlichen Felder wurden in das "Bemerkungen"-Feld transferiert',

   'Home'
=> '根目录',

   'Usage Statistics'
=> '使用统计',

   'Courses/Network Hits'
=> '课程/网络访问次数',

   'Already in this course:<br />[_1] in folder/map [_2].<br />'
=> 'Bereits in diesem Kurs:<br />[_1] im Verzeichnis/Inhaltszusammenstellung [_2].<br />',

   'External Resource, preview not enabled'
=> 'Externe Ressource, Vorschau nicht aktiviert',

   'Somewhere something went wrong'
=> 'Irgendwo ist irgendwas schief gelaufen',

   'Please help us to find out what.'
=> 'Bitte helfen Sie uns herauszufinden, was passiert ist!',

   'Please take a moment to fill out the form below.'
=> 'Bitte nehmen Sie sich einen Moment Zeit, um das folgende Formular auszufüllen.',

   'Your information, together with internal debugging information, will be emailed to the system and server administrators.'
=> 'Ihre Informationen, zusammen mit internen Debugging-Daten, werden an die System- und Server-Administratoren per E-Mail weitergeleitet.',

   'Send Information'
=> '发送错误报告',

   'Please describe what you did just before this screen came up'
=> 'Bitte erläutern Sie, was Sie getan haben, unmittelbar bevor dieser Bildschirm erschien.',

   'Is this problem reproducible?'
=> 'Ist das Problem reproduzierbar?',

   'Yes!'
=> '是！',

   'Do you have any guesses why this might have happened?'
=> '你有任何猜测，为什么会发生？',

   'Thank you for your help!'
=> '谢谢您的支持！',

   'Internal info:'
=> '内部信息：',

   'Report submitted'
=> '提交的报告',

   'Sending Error Report'
=> '发送错误报告',

   'Thank you!'
=> '谢谢您！',

   'Warning: Report not submitted'
=> '警告：报告未提交',

   'The administrators of the domain [_1] have not set any e-mail addresses for receipt of your error report.'
=> 'Die Administratoren der Domäne [_1] haben keine E-Mail-Adresse hinterlegt, an die Ihr Fehlerbericht gesendet werden könnte.',

   'The document contains errors and cannot be published.'
=> 'Die Ressource enthält Fehler und kann daher nicht veröffentlicht werden.',

   'error(s)'
=> 'Fehler',

   '[quant,_1,error]'
=> '[quant,_1,Fehler,Fehler]',

   'Please fill out all fields below.'
=> '请填写以下所有问题。',

   'Caution: this folder is set to randomly pick a subset of resources. Adding or removing resources from this folder will change the set of resources that the students see, resulting in spurious or missing credit for completed problems, not limited to ones you modify. Do not modify the contents of this folder if it is in active student use.'
=> 'Achtung, dieses Verzeichnis ist so eingestellt, dass zufällig eine Teilmenge der Ressourcen gewählt wird. Hinzufügen oder Entfernen von Ressourcen zu/aus diesem Verzeichnis wird die Auswahl ändern, die die Studenten sehen. Dies kann falsche oder fehlende Bewertungen für abgeschlossene Aufgaben zur Folge haben, was nicht beschränkt auf die Ressourcen ist, die Sie ändern. Ändern Sie daher die Inhalte dieses Verzeichnisses nicht, wenn es in aktueller studentischer Verwendung ist.',

   'Caution: this folder is set to randomly order its contents. Adding or removing resources from this folder will change the order of resources shown.'
=> 'Achtung, dieses Verzeichnis ist so eingestellt, dass der Inhalt in zufälliger Reihenfolge angezeigt wird. Hinzufügen oder Entfernen von Ressourcen zu/aus diesem Verzeichnis wird die Reihenfolge ändern, in der die Ressourcen gezeigt werden.',

   'Parameters'
=> '参数',

   'Parameters:'
=> '参数：',

   'Total Score and Maximum Possible for each Sequence or Folder'
=> 'Gesamtpunkte und maximal mögliche für jede Sequenz oder jedes Verzeichnis',

   'Score on each Problem Part'
=> 'Punkte je Aufgabenteil',

   'Number of Tries before success on each Problem Part'
=> 'Anzahl notwendiger Versuche je Aufgabenteil',

   'Number of Problem Parts completed successfully.'
=> 'Anzahl erfolgreich bearbeiteter Aufgabenteile',

   'Unable to retrieve course information.'
=> 'Kursdaten konnten nicht abgerufen werden.',

   'Please select an action to perform using the new filename'
=> 'Bitte wählen Sie zuerst eine Aktion aus, was mit der neuen Datei geschehen soll!',

   'View or modify a course'
=> '查看或修改课程', # long version: 'Kurs-Einstellungen betrachten oder ändern',

   'Enter the course with the role of [_1]'
=> 'Den Kurs mit der Rolle [_1] betreten.',

   'Enter the course with the role of [_1].'
=> 'Den Kurs mit der Rolle [_1] betreten.',

   'View or modify course settings which only a [_1] may modify.'
=> 'Betrachten oder Ändern der Kurs-Einstellungen, die nur ein [_1] ändern darf.',

   'Manage course users'
=> '管理课程参加者',

   'Upload a File of Course Users'
=> '课程用户上传文件',

   'Add/Modify a Course User'
=> '添加/修改课程用户', 

   'Edit Custom Roles'
=> '编辑自定义角色',

   'Custom Role'
=> '自定义角色',

   'Enroll a Single Student'
=> '注册一名学生',

   'Enroll a student'
=> '注册学生',

   'Manage Course Groups'
=> '管理课程组',

   'This error occurred while processing response [_1] in part [_2]'
=> 'Dieser Fehler trat während der Verarbeitung von Antwortbereich [_1] in Aufgabenteil [_2] auf.',

   'This error occurred while processing part [_1]'
=> 'Dieser Fehler trat während der Verarbeitung von Aufgabenteil [_1] auf.',

   'Unable to find section for this student'
=> 'Konnte für diesen Studenten keine Sektion finden.',

   'Classlist update for "[_1]" in "[_2]".'
=> 'Kursteilnehmerlisten-Aktualisierung für "[_1]" in "[_2]".',

   'Error: "[_1]" during classlist update for "[_2]" in "[_3]".'
=> 'Fehler: "[_1]" während Kursteilnehmerlisten-Aktualisierung für "[_2]" in "[_3]".',

   'Role: '
=> '角色： ',

   'Identify fields in uploaded list'
=> 'Angabe der Felder in der hochgeladenen Liste',

   'Default domain'
=> '默认域',

   'Change authentication for existing users in domain "[_1]" to these settings?'
=> 'Soll die Authentifizierungsmethode für existierende Benutzer der Domäne "[_1]" geändert werden?',

   'LON-CAPA Home Server for New Users'
=> 'LON-CAPA 家庭服务器的新用户',

   'LON-CAPA domain: [_1] with home server:'
=> 'LON-CAPA 域 [_1] 与家庭服务器：',

   'Settings for assigning roles'
=> 'Einstellungen für Rollenzuweisungen',

   'Pick the action to take on roles for these users:'
=> 'Wählen Sie die Aktion aus, die bei neuen Rollen für diesen Benutzer ausgeführt werden soll:',

   'No role changes'
=> 'Keine Rollenänderungen',

   'Add a domain role'
=> 'Eine Domänenrolle hinzufügen',

   'Add a course role'
=> 'Eine Kursrolle hinzufügen',

   'Default role'
=> 'Voreingesstellte Rolle',

   'Choose the role to assign to users without a value specified in the uploaded file.'
=> 'Wählen Sie die Rolle, die Benutzern zugewiesen werden sollen, für die kein Wert in der hochgeladenen Datei angegeben ist.',

   'Default role and section'
=> 'Voreingestellte Rolle und Sektion',

   'Choose the role and/or section(s) to assign to users without values specified in the uploaded file.'
=> 'Wählen Sie die Rolle und/oder Sektion(en), die Benutzern zugewiesen werden sollen, für die keine Werte in der hochgeladenen Datei angegeben wurden.',

   'Default role and/or section(s)'
=> 'Voreingestellte Rolle und/oder Sektion(en)',

   'Role and/or section(s) for users without values specified in the uploaded file.'
=> 'Rolle und/oder Sektion(en) für Benutzer, für die keine Werte in der hochgeladenen Datei angegeben wurde',

   'Display students with current/future access who are not in the uploaded file.'
=> 'Anzeige von Studenten mit aktuellem/zukünftigem Zugriff, die nicht in der hochgeladenen Datei sind.',

   'Students selected from this list can be dropped.'
=> 'Studierende können von dieser Liste gewählt und aus dem Kurs ausgeschlossen werden.',

   'Update Student/Employee ID in courses in which user is active/future student,[_1](if forcing change).'
=> 'Aktualisierung der ID/Matrikelnummer in Kursen, in denen der Benutzer aktueller/zukünftiger Student ist<br />(falls Änderung erzwungen wird). ',

   'make these dates the default access dates for future student enrollment'
=> 'Diese Datumswerte als voreingestellte Zugriffszeiten für zukünftige studentische Kursbelegungen verwenden',

   'Set default start and end access dates for course.'
=> 'Setze voreingestellte Anfangs- und Endezeitpunkte für Kurs',

   'Unable to set default access dates for course.'
=> 'Konnte nicht die voreingestellten Zugriffszeitpunkte für den Kurs setzen!',

   'Please select'
=> 'Bitte wählen',

   'User Status: [_1]'
=> '用户状态： [_1]',

   'Role Type: [_1]'
=> '角色类别： [_1]',

   'Any role'
=> '任意角色',

   'Role: [_1]'
=> '角色： [_1]',

   'Select Course(s)'
=> '选择课程',

   'Warning: data retrieval for multiple courses can take considerable time, as this operation is not currently optimized.'
=> 'Achtung: Das Abrufen von Daten für mehrere Kurse kann einige Zeit in Anspruch nehmen, da diese Aktion derzeit noch nicht optimiert ist.',

   'There are no co-authors to display.'
=> 'Es gibt keine Co-Autoren, die angezeigt werden können.',

   'There are no users with domain roles to display.'
=> 'Es gibt keine Benutzer mit Domänenrollen, die angezeigt werden können.',

   'There are no authors or co-authors to display.'
=> 'Es gibt keine Autoren oder Co-Autoren, die angezeigt werden können.',

   'There are no course users to display'
=> 'Es gibt keine Kursteilnehmer, die angezeigt werden können.',

   'There are no course users to display.'
=> 'Es gibt keine Kursteilnehmer, die angezeigt werden können.',

   'There are no users matching the search criteria.'
=> 'Es gibt keine Benutzer, auf die die Suchkriterien zutreffen.',

   "You must select at least one user by checking a user's 'Select' checkbox"
=> "Sie müssen mindestens einen Benutzer auswählen, indem Sie die Checkboxen in der Spalte 'Auswählen' anklicken.",

   'You need to select an action to take for the user(s) you have selected'
=> 'Sie müssen eine Aktion auswählen, die für die ausgewählten Benutzer ausgeführt soll.',

   ' for a single user?'
=> '? (betrifft einen einzelnen Benutzer)',

   ' for multiple users?'
=> '? (betrifft mehrere Benutzer)',

   'Proceed'
=> '下一步',

   'Action to take for selected users'
=> 'Aktion für ausgewählte Benutzer',

   'Behavior of clickable username link for each user'
=> 'Verhalten der Benutzerkennung-Links', # long version: 'Verhalten der anklickbaren Benutzerkennung-Links eines jeden Benutzers',

   "Display a user's personal page"
=> "显示个人网页",

   "Modify a user's information"
=> "Benutzerdaten ändern",

   'Course(s): description, section(s), status'
=> 'Kurs(e): Beschreibung, Sektion(en), Status',

   "Click on a username to view the user's personal page."
=> "点击用户名，以查看用户的个人网页。",

   'auto'
=> '自动',

   'manual'
=> '手动',

   'Unlock'
=> 'Entsperren',

   'Lock'
=> 'Sperren',

   'Domain Roles'
=> '域角色',

   'Co-Author Roles'
=> '合著者角色',

   'Course Roles'
=> '课程角色',

   'Date and Section selector'
=> '日期和组选择',

   'Date selector'
=> '日期选择器',

   "Check the boxes for any users for whom roles are to be revoked, and click 'Proceed'"
=> "Wählen Sie all die Benutzer, für die Rollen entzogen werden sollen und klicken Sie dann auf 'Weiter'",

   "Check the boxes for any users for whom roles are to be deleted, and click 'Proceed'"
=> "Wählen Sie all die Benutzer, für die Rollen gelöscht werden sollen und klicken Sie dann auf 'Weiter'",

   'Choose an action to take for selected users'
=> 'Wählen Sie eine Aktion, die mit den ausgewählten Benutzern ausgeführt werden soll',

   'New section to assign'
=> 'Neue Sektion, die zugewiesen werden soll',

   'Use "Save" to update the main window with your selections.'
=> "Verwenden Sie 'Speichern', um im Hauptfenster Ihre Auswahl zu aktualisieren.",

   'New section'
=> '新的章节',

   'Course - [_1]:'
=> '课程 - [_1]：',

   'Domain - [_1]:'
=> '域 - [_1]：',

   'Users in course with expired [_1] roles'
=> 'Benutzer im Kurs mit abgelaufener Rolle "[_1]"',

   'Users in course with future [_1] roles'
=> 'Benutzer im Kurs mit zukünftiger Rolle "[_1]"',

   'Users in course with active [_1] roles'
=> 'Benutzer im Kurs mit aktiver Rolle "[_1]"',

   'All users in course'
=> 'Alle Benutzer im Kurs',

   'All users in course with [_1] roles'
=> 'Alle Benutzer im Kurs mit Rolle "[_1]"',

   'only users in section "[_1]"'
=> 'nur Benutzer in Sektion "[_1]"',

   'only users affiliated with no section or section "[_1]"'
=> 'nur Benutzer, die in keiner Sektion oder in der Sektion "[_1]" sind',

   ' and not in any group'
=> ' und in keiner Gruppe',

   ' and members of group: "[_1]"'
=> ' und Mitglieder der Gruppe "[_1]"',

   'only users affiliated with no section'
=> 'nur Benutzer, die in keiner Sektion sind',

   'only users affiliated with section "[_1]"'
=> 'nur Benutzer, die in der Sektion "[_1]" sind',

   'only users not in any group'
=> 'nur Benutzer, die in keiner Gruppe sind',

   ' and also not in any group'
=> ' und auch nicht in einer Gruppe sind',

   'only members of group: "[_1]"'
=> '只有该组成员 "[_1]"',

   ' and also members of group: "[_1]"'
=> ' und auch Mitglieder der Gruppe "[_1] sind',

   'Author space for [_1]'
=> 'Autorenbereich für [_1]',

   'Co-authors with expired [_1] roles'
=> 'Co-Autoren mit abgelaufender Rolle "[_1]"',

   'Co-authors with future [_1] roles'
=> 'Co-Autoren mit zukünftiger Rolle "[_1]"',

   'Co-authors with active [_1] roles'
=> 'Co-Autoren mit aktiver Rolle "[_1]"',

   'All co-authors'
=> '所有合著者',

   'All co-authors with [_1] roles'
=> 'Alle Co-Autoren mit Rolle "[_1]"',

   'Users in domain with expired [_1] roles'
=> 'Benutzer in Domäne mit abgelaufener Rolle "[_1]"',

   'Users in domain with future [_1] roles'
=> 'Benutzer in Domäne mit zukünftiger Rolle "[_1]"',

   'Users in domain with active [_1] roles'
=> 'Benutzer in Domäne mit aktiver Rolle "[_1]"',

   'All users in domain'
=> 'Alle Benutzer in der Domäne',

   'All users in domain with [_1] roles'
=> 'Alle Benutzer in der Domäne mit der Rolle "[_1]"',

   'Co-authors in domain with expired [_1] roles'
=> 'Co-Autoren in der Domäne mit abgelaufener Rolle "[_1]"',

   'Co-authors in domain with future [_1] roles'
=> 'Co-Autoren in der Domäne mit zukünftiger Rolle "[_1]"',

   'Co-authors in domain with active [_1] roles'
=> 'Co-Autoren in der Domäne mit aktiver Rolle "[_1]"',

   'All users with co-author roles in domain'
=> 'Alle Benutzer mit Co-Autoren-Rolle in der Domäne',

   'All co-authors in domain  with [_1] roles'
=> 'Alle Co-Autoren in der Domäne mit Rolle "[_1]"',

   'All courses in domain'
=> 'Alle Kurse in der Domäne',

   'Courses in domain with institutional code: [_1]'
=> 'Kurse in der Domäne mit Institutscode "[_1]"',

   'Selected courses in domain'
=> 'Ausgewählte Kurse in der Domäne',

   'users with expired [_1] roles'
=> 'Benutzer mit abgelaufener Rolle "[_1]"',

   'users with future [_1] roles'
=> 'Benutzer mit zukünftiger Rolle "[_1]"',

   'users with active [_1] roles'
=> 'Benutzer mit aktiver Rolle "[_1]"',

   'all users'
=> '所有用户',

   'users with [_1] roles'
=> '用户角色"[_1]"',

   'There are no students to drop.'
=> 'Es gibt keine Studenten, die ausgeschlossen werden könnten.',

   'Upload a file containing information about users'
=> '上传一个包含有用户信息的文件',

   'Upload file of users'
=> '上传用户文件',

   'How do I create a users list from a spreadsheet'
=> '如何从电子表格建立用户列表',

   'Unable to enroll users'
=> '无法注册用户',

   'Enrolling Users'
=> '注册用户',

   'Updating Co-authors'
=> '更新共同作者',

   'Adding/Modifying Users'
=> '添加/修改用户',

   'Default section name [_1] could not be used as it is a reserved word.'
=> 'Der voreingestellte Sektionsname "[_1]" ist nicht zulässig, da es sich um ein intern reserviertes Wort handelt.',

   'Default section name "[_1]" is the name of a course group. Section names and group names must be distinct.'
=> 'Der voreingestellte Sektionsname "[_1]" ist eine Name einer Kursgruppe. Sektionsnamen and Gruppennamen müssen sich jedoch unterscheiden.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a reserved word.'
=> '[_1]: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich - es handelt sich um ein intern reserviertes Wort.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]" - this is a course group.'
=> '[_1]: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich - es handelt sich um eine Kursgruppe.',

   'Section names and group names must be distinct.'
=> 'Sektionsnamen und Gruppennamen müssen sich unterscheiden.',

   '[_1]: Unable to enroll user [_2] [_3] [_4] [_5] in a section named "[_6]".'
=> '[_1]: Kursbelegung für Benutzer [_2] [_3] [_4] [_5] in der Sektion "[_6]" nicht möglich.',

   'This user already has an active/future student role in the course, unaffiliated to any section.'
=> 'Dieser Benutzer hat bereits eine aktive oder zukünftige Rolle in diesem Kurs, die nicht mit einer Sektion verbunden ist.',

   'This user already has an active/future role in section "[_1]" of the course.'
=> 'Dieser Benutzer hat in dem Kurs bereits eine aktive oder zukünftige Rolle in der Sektion "[_1]".',

   'Although your current role has privileges to add students to section "[_1]", you do not have privileges to modify existing enrollments in other sections.'
=> 'Auch wenn Ihre derzeitige Rolle das Hinzufügen von Studenten in die Sektion "[_1]" zulässt, haben Sie nicht die Berechtigung, bestehende Kursbelegungen in anderen Sektionen zu ändern.',

   '[_1]: You do not have permission to add the requested role [_2] for the user.'
=> '[_1]: Sie haben nicht die Berechtigung, dem Benutzer die gewünschte Rolle "[_2]" zuzuweisen.',

   'Allowable role(s) is/are: [_1].'
=> 'Zulässige Rollen: [_1]',

   '[_1]: Unable to enroll. No password specified.'
=> '[_1]: Kursbelegung nicht möglich. Kein Passwort angegeben!',

   '[_1]: Unable to add co-author. No password specified.'
=> '[_1]: Hinzufügen des Co-Autors nicht möglich. Kein Passwort angegeben!',

   '[_1]: Unable to add user. No password specified.'
=> '[_1]: Hinzufügen des Benutzers nicht möglich. Kein Passwort angegeben!',

   'Processed [quant,_1,user].'
=> '[quant,_1,Benutzer,Benutzer] verarbeitet.',

   'Roles added for [quant,_1,user].'
=> 'Rollen für [quant,_1,Benutzer,Benutzer] hinzugefügt.',

   'If a user is currently logged-in to LON-CAPA, any new roles which are active will be available when the user next logs in.'
=> 'Beim nächsten Anmelden des Benutzers werden alle neuen aktiven Rollen verfügbar sein.',

   'No roles added'
=> 'Keine Rollen hinzugefügt',

   'Authentication changed for [_1] existing users.'
=> 'Die Authentifizierungsmethode hat sich für [_1] existente(n) Benutzer geändert.',

   'Students to Drop'
=> 'Auszuschließende Studenten',

   'There are no students with current/future access to the course.'
=> 'Es existieren keine Studenten mit aktuellem oder zukünftigem Zugriff auf den Kurs.',

   '[_1]: Unable to add/modify: [_2]'
=> '[_1]: Hinzufügen/Ändern nicht möglich: [_2]',

   '[_1]: Unable to modify authentication: [_2]'
=> '[_1]: Ändern der Authentifizierungsmethode nicht möglich: [_2]',

   '[_1]: Unable to add role: [_2]'
=> '[_1]: Hinzufügen der Rolle nicht möglich: [_2]',

   'No change in section assignment (none)'
=> 'Keine Änderung in Sektionsbelegung (none)',

   "Revoked role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' entzogen in [_2] für [_3]",

   "Deleted role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' gelöscht in [_2] für [_3]",

   "Re-enabled role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' reaktiviert in [_2] für [_3]",

   "Activated role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' aktiviert in [_2] für [_3]",

   "Changed Access Dates for role of '[_1]' in [_2] for [_3]"
=> "Geänderte Zugriffszeiten für Rolle '[_1]' in [_2] für [_3]",

   "Changed section for role of '[_1]' in [_2] for [_3]"
=> "Geänderte Sektion für Rolle '[_1]' in [_2] für [_3]",

   "Dropped role of '[_1]' in [_2] for [_3]"
=> "Rolle '[_1]' entzogen in [_2] für [_3]",

   'Error revoking [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Entziehen für [_1] in [_2] für [_3]: [_4].',

   'Error deleting [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Löschen für [_1] in [_2] für [_3]: [_4].',

   'Error re-enabling [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Reaktivieren für [_1] in [_2] für [_3]: [_4].',

   'Error activating [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Aktivieren für [_1] in [_2] für [_3]: [_4].',

   'Error changing access dates for [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Ändern der Zugriffszeiten für [_1] in [_2] für [_3]: [_4].',

   'Error changing section for [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Ändern der Sektion für [_1] in [_2] für [_3]: [_4].',

   'Error dropping [_1] in [_2] for [_3]: [_4].'
=> 'Fehler beim Entziehen für [_1] in [_2] für [_3]: [_4].',

   'Revoked role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] entzogen.',

   'Deleted role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] gelöscht.',

   'Re-enabled role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] reaktiviert.',

   'Activated role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] aktiviert.',

   'Changed Access Dates for role(s) for [quant,_1,user,users,no users].'
=> 'Zugriffszeiten für Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] geändert.',

   'Changed section for role(s) for [quant,_1,user,users,no users].'
=> 'Sektionen für Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] geändert.',

   'Dropped role(s) for [quant,_1,user,users,no users].'
=> 'Rolle(n) für [quant,_1,Benutzer,Benutzer,keinen Benutzer] entzogen.',

   'Re-enabling will re-activate data for the role.'
=> 'Reaktivierung wird die Daten der Rolle reaktivieren.',

   'Display User Lists'
=> 'Teilnehmerliste anzeigen',

   'Display current class roster'
=> 'Aktuelle Kursteilnehmerliste anzeigen',

   'No section'
=> 'Keine Sektion',

   'List Users'
=> '用户列表',

   'Pick custom role'
=> '选择自定义角色',

   'Advanced Role'
=> '扩展的角色',

   "Create User Notes, Display all User's Notes, Face-to-Face, Critical Messages, Broadcast Messages"
=> "Erstellen von Benutzeranmerkungen, Anzeige aller Benutzeranmerkungen, persönlicher Diskussionsbeiträge, wichtiger Nachrichten, Broadcast-Nachrichten",

   'Evade communication blocking'
=> 'Umgehen der Kommunikationssperre',

   'Generate anonymous statistics'
=> 'Anonyme Statistiken erzeugen',

   'Modify grade queue'
=> 'Ändern der Bewertungs-Warteschlange',

   'Grade items in grading queue'
=> 'Bewerten von Elementen in der Bewertungs-Warteschlange',

   'Set assessment parameters'
=> 'Beurteilungs-Parameter setzen', # Ressourcenparameter setzen/ändern (???)

   'Advanced printing options (with answers, discussions, all foils, ...)'
=> 'Erweiterte Druckoptionen (mit Antworten, Diskussionen, allen Auswahlmöglichkeiten, ...)',

   'Print for other users and entire course'
=> 'Für andere Benutzer und für gesamten Kurs drucken',

   'Get identity behind anonymous postings'
=> 'Identität hinter anonymen Beiträgen erhalten können',

   'View grades'
=> 'Beurteilungen anzeigen',

   "Access to What's New page"
=> "进入新页",

   'Upload Users List'
=> '上传用户列表',

   'Update Users'
=> '用户更新',

   'Create/modify a user'
=> '创建/修改用户',

   'Search for a user and modify/add user information or roles'
=> '搜索用户和修改/添加用户资料或角色',

   'Add/modify a single user'
=> '添加/修改一个用户',

   'Create users or modify the roles and privileges of users'
=> '创建或修改用户的角色和权限',

   'Upload a File of Users'
=> '上传用户文件',

   'Add/Modify a User'
=> '添加/修改用户',

   'create new user if required'
=> '如有必要，创建新用户',

   'Manage Users'
=> '管理用户',

   'Create/Modify user'
=> '创建/修改用户',

   'Visible input'
=> '可见输入',

   'Currently in use'
=> '目前正在使用',

   'Modify this user: [_1]'
=> '改此用户名： [_1]',

   'Blank Problem'
=> '空白问题',

   'Chemical Reaction Response'
=> '化学反应',

   'Click-On-Image Problem'
=> '点击图片',

   'Curve Plot with Numerical Response'
=> 'Dynamischer Graph mit numerischer Antwort',

   'Custom Response'
=> 'Customresponse',

   'Data Plot with Numerical Response'
=> 'Datenplot mit numerischer Antwort',

   'Essay Response'
=> '尝试回答',

   'Exam Upload Resource'
=> 'Examen-Hochlade-Ressource',

   'Formula Response using Computer Algebra System'
=> 'Formel mit Computer-Algebra-System',

   'Formula Response using Computer Algebra System and Hints'
=> 'Formel mit Computer-Algebra-System und Hinweisen',

   'Formula Response with Samples'
=> 'Formel mit Abtastpunkten',

   'Unordered Multi-Answer Formula Response Problem'
=> 'Formel - mehrere Antworten, ungeordnet',

   'Math Response using Computer Algebra System'
=> 'Mathematische Antwort mit Computer-Algebra-System (mathresponse)',

   'Math Response using Computer Algebra System and Hints'
=> 'Mathematische Antwort mit Computer-Algebra-System und Hinweisen (mathresponse)',

   'Numerical Response'
=> 'Numerisch',

   'One of Multiple Answers Numerical Problem'
=> 'Numerisch - eine aus mehreren Antworten',

   'Option Response - Matching'
=> 'Zuordnung mit Optionen (Option Response - Matching)',

   'Option Response - Concept Groups'
=> 'Zuordnung mit Optionen - Konzeptgruppen (Option Response - Concept Groups)', # 'Optionsauswahl mit Konzeptgruppen',

   'Matching Response'
=> 'Zuordnung mit Optionen - indirekt (Matching Response)',

   'Option Response - True/False'
=> 'Zuordnung mit Optionen - wahr/falsch (Option Response - True/False)', # 'Optionen - wahr/falsch',

   'Organic Material Response'
=> 'Organisches Material',

   'Radio Button Response'
=> '单选',

   'Randomly Labelled Image with Option Response'
=> 'Dynamische Bildbeschriftung mit Optionsauswahl (Randomly Labelled Image)',

   'Rank Response'
=> '等级制度 (Rank Response)',

   'String Response'
=> '文本输入 (String Response)',

   'Display catalog of courses'
=> '课程目录', 

   'Manage co-authors'
=> '管理共同作者',

   'Upload a File of Co-authors'
=> '上传共同作者的文件',

   'Add/Modify a Co-author'
=> '添加/修改一个共同的作者', 

   'Manage Co-authors'
=> '管理共同作者', 

   'No courses match the criteria you selected.'
=> '没有选择相对应的课程。',

   'Key authority (<tt>id@domain</tt>) if other than course'
=> 'Schlüsselmeister (<tt>id@domäne</tt>), falls anderer als der des Kurses',

   'New bridgetask file'
=> 'Neue "bridgetask"-Datei',

   'Create problem'
=> '创建问题',

   'Create library'
=> '创建图书馆',

   'Create survey'
=> '创建调查',

   'Create task'
=> '创建任务',

   'Problem Testing'
=> '问题测试',

   "Don't Show Incorect/Correct Feedback"
=> "不显示不正确/正确的反馈",

   "Don't Show Any Feedback"
=> "不显示任何反馈",

   'Change View'
=> '更改视图',

   'Show Default View'
=> '查看默认视图',

   '[_1] for [_2] versions.'
=> '[_1] 的 [_2] 版本。',

   'Set new preferred languages to '
=> '首选语言设置为 ',

   'Reset preferred language.'
=> '重设的首选语言。',

   'Set new preferred math display to '
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen, gesetzt auf ',

   'Reset preferred math display.'
=> 'Bevorzugte Methode, um wissenschaftliche Formeln darzustellen, zurückgesetzt.',

   'Set new screenname to '
=> '在匿名讨论中新的昵称为 ',

   'Reset screenname.'
=> '重置昵称。',

   'Set new nickname to '
=> '设置新的昵称为 ',

   'Reset nickname.'
=> '重设昵称。',

   'Set menu mode to [_1].'
=> '设置菜单模式为 [_1]。',

   'Reset '
=> '重置',

   'Set message forwarding to '
=> '设置邮件转发到 ',

   "Set message forwarding to 'off'."
=> "设置邮件转发为'关闭'。",

   'Set non-critical message notification address(es) to '
=> '设置非重要的邮件通知地址为 ',

   "Set non-critical message notification to 'off'."
=> "设置非重要的邮件通知为'关闭'。",

   'Set critical message notification address(es) to '
=> '设置重要的邮件通知地址为 ',

   "Set critical message notification to 'off'."
=> "设置重要的邮件通知为'关闭'。",

   'Set address(es) to receive excerpts with html retained '
=> '设置保留HTML摘录的地址为 ',

   'Set notification address to receive excerpts with html stripped.'
=> '设置接收邮件地址为不保留的HTML摘录。',

   'Set all notification addresses to receive excerpts with html stripped.'
=> '设置所有的接收邮件地址为不保留的HTML摘录。',

   'Set Page Background to '
=> '设置页面的背景为 ',

   'Set Header Background to '
=> '设置页眉背景为 ',

   'Set Header Border to '
=> '设置页眉边界为 ',

   'Set Font to '
=> '设置字体为 ',

   'Set Un-Visited Link to '
=> '设置未访问链接颜色为 ',

   'Set Visited Link to '
=> '设置已访问链接颜色为 ',

   'Set Active Link to '
=> '设置活动链接颜色为 ',

   'Reset Page Background'
=> '重设网页背景',

   'Reset Header Background'
=> '重置页眉背景',

   'Reset Header Border'
=> '重置页眉边界',

   'Reset Font.'
=> '重置字体颜色。',

   'Reset Un-Visited Link.'
=> '重置未访问链接颜色。',

   'Reset Visited Link.'
=> '重置已访问链接颜色。',

   'Reset Active Link.'
=> '重置活动链接颜色。',

   'Freezing Role: [_1]'
=> '冻结的角色： [_1]',

   'Unfreezing Role: [_1]'
=> '解冻的角色： [_1] aufgehoben',

   'No such user: '
=> '此用户不存在： ',

   'Sorry, the URL you provided to complete the reset of your password was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid. Please submit a [_1]new request[_2] for a password reset, and follow the link to the new URL included in the e-mail that will be sent to you, to allow you to enter a new password.'
=> 'Tut mir leid, aber die von Ihnen angegebene URL zum Beenden des Zurücksetzens Ihres Passworts ist ungültig. Entweder wurde das in der URL eingebundene Merkzeichen gelöscht oder die von Ihnen angegebene URL ist nicht gültig. Bitte schicken Sie eine [_1]neue Anfrage[_2] zum Zurücksetzen des Passworts und folgen dem Link der neuen URL, die in der Ihnen zugesandten E-Mail angegeben ist, damit Sie ein neues Passwort eingeben dürfen.',

   'Sorry, the token generated when you requested a password reset has expired.'
=> 'Tut mir leid, das erzeugte Merkzeichen zum Zurücksetzen Ihres Passworts ist bereits abgelaufen und daher nicht mehr gültig.',

   'Sorry, the URL generated when you requested reset of your password contained incomplete information.'
=> 'Tut mir leid, die URL, die erzeugt wurde, als Sie das Zurücksetzen Ihres Passworts angefordert haben, enthält unvollständige Daten und ist daher ungültig.',

   'Page requested in unexpected context'
=> 'Die Seite wurde in unerwartetem Kontext aufgerufen',

   'Invalid username and/or domain'
=> 'Ungültige Benutzerkennung und/oder Domäne',

   'Username and domain were blank'
=> 'Benutzerkennung und Domäne waren leer',

   'Authentication type for this user can not be changed by this mechanism'
=> 'Die Authentifizierungsmethode kann für diesen Benutzer nicht auf die gewünschte Methode umgestellt werden',

   'One or more password fields were blank'
=> 'Ein oder mehrere Passwort-Felder waren leer',

   'Please log out and try again.'
=> 'Bitte loggen Sie sich aus und versuchen Sie es erneut.',

   'Please try again later.'
=> 'Bitte versuchen Sie es später noch einmal.',

   'Unable to retrieve saved token for password decryption'
=> 'Es ist nicht möglich, das gespeicherte Merkzeichen für die Passwortverschlüsselung abzurufen',

   'Could not verify current authentication.'
=> 'Die aktuelle Authentifizierung konnte nicht bestätigt werden',

   'The new passwords you entered do not match.'
=> 'Die Bestätigung des neuen Passworts stimmt nicht mit dem neuen Passwort überein.',

   'Passwords must be a minimum of 7 characters long.'
=> 'Das Passwort muss mindestens 7 Zeichen lang sein.',

   'The password you entered contained illegal characters.'
=> 'Das von Ihnen eingegebene Passwort enthält ungültige Zeichen.',

   'Valid characters are'
=> 'Gültige Zeichen sind',

   'The password for [_1] was successfully changed.'
=> '[_1] 的密码已成功更改。',

   'The password for [_1] was not changed.'
=> 'Das Passwort für [_1] wurde nicht geändert',

   'In discussions: only new posts will be displayed.'
=> 'In Diskussionen: Es werden nur neue Beiträge angezeigt.',

   'In discussions: all posts will be displayed.'
=> 'In Dikussionen: Es werden alle Beiträge angezeigt.',

   'In discussions: new posts will be cease to be identified as "NEW" after display.'
=> 'In Diskussionen: Es werden nach dem Anzeigen nicht mehr als "NEU" angezeigt.',

   'In discussions: posts will be identified as "NEW" until marked as read by the reader.'
=> 'In Diskussionen: Es werden Beiträge solange als "NEU" interpretiert, bis sie durch den Leser als gelesen markiert werden.',

   'The e-mail address entered in row '
=> '电子邮件地址输入行 ',

   'The e-mail address you entered'
=> '您输入的电子邮件地址',

   'is not a valid e-mail address'
=> '不是一个有效的电子邮件地址',

   'Title for the Uploaded Score'
=> 'Titel für Formular zum Hochladen von Noten',

   'Title for the Page'
=> '标题页',

   'Title for the Problem'
=> '问题的标题',

   'Title for the Drop Box'
=> 'Titel der Dropbox',

   'Title for the Bulletin Board'
=> '公告栏的标题',

   'Not a valid user:domain'
=> '不是有效的用户：域',

   'Please enter both user and domain in the format user:domain'
=> '请输入用户和域，格式为 用户：域',

   'Personal Information Page of '
=> 'Persönliche Seite von ',

   'No info'
=> 'Keine Information vorhanden',

   'No user information available'
=> 'Keine Benutzerdaten verfügbar',

   'The new directory name was changed from [_1] to [_2].'
=> 'Der Name des neuen Verzeichnisses wurde von [_1] in [_2] geändert.',

   'Unable to create a directory named'
=> 'Es war nicht möglich ein Verzeichnis anzulegen mit dem Namen',

   'A file or directory by that name already exists.'
=> 'Es existert bereits eine Datei oder ein Verzeichnis mit diesem Namen.',

   'Allowing others to retrieve file: [_1]'
=> 'Für andere Zugriff erlauben auf die Datei: [_1]',

   'Access to this file by others can be set to be one or more of the following types: public, passphrase-protected or conditional.'
=> 'Zugriff durch andere auf diese Datei kann auf folgende drei Typen eingestellt werden: öffentlich, passwortgeschützt oder bedingungsabhängig',

   'Public files are available to anyone without the need for login.'
=> 'Öffentliche Dateien sind für alle verfügbar, auch ohne Login.',

   'Passphrase-protected files do not require log-in, but will require the viewer to enter the passphrase you set.'
=> 'Passwortgeschützte Dateien erfordern keinen Login, aber es ist für den Zugriff notwendig, dass das von Ihnen hinterlegte Passwort eingegeben wird.',

   'A listing of files viewable without log-in is available at: '
=> 'Eine Liste von Dateien, die ohne Login verfügbar sind, gibt es unter: ',

   "For logged in users a 'Display file listing' link will also appear (when there are viewable files) on your personal information page:"
=> "Für eingeloggte Benutzer wird es auf Ihrer persönlichen Über-mich-Seite zusätzlich einen Link 'Anzeige Dateiliste' geben (falls anzeigbare Dateien vorhanden sind): ",

   "Users with privileges to edit course contents may add a course information page to a course using the 'Course Info' button in DOCS"
=> "Benutzer mit Berechtigung zum Ändern von Kursinhalten können dem Kurs eine Kursinformations-Seite hinzufügen. dies geschieht durch Verwendung des 'Kursinformationen'-Buttons im Bereich 'Kursinhalt einrichten'",

   'Conditional access controls for file: [_1]'
=> 'Bedingte Zugriffskontrolle für Datei: [_1]',

   'Help on setting up share access'
=> 'Hilfe zum Einstellen für gemeinsamen Zugriff',

   'Help on changing settings'
=> 'Hilfe zum Ändern der Einstellungen',

   'Help on removing share access'
=> 'Hilfe zum Entfernen des gemeinsamen Zugriffs',

   'Public access: [_1]'
=> 'Öffentlicher Zugriff: [_1]',

   'Dates available'
=> '能够使用的日期',

   'Passphrase-protected access: [_1]'
=> 'Passwortgeschützter Zugriff: [_1]',

   'Passphrase'
=> 'Passwort',

   'Conditional access: [_1]'
=> 'Bedingungsabhängiger Zugriff: [_1]',

   'You have previously set [_1] conditional access controls.'
=> 'Zuvor haben Sie [_1] bedingungsabhängige Zugriffskontrollen eingerichtet.',

   'Change Conditions'
=> 'Bedingungen ändern',

   'Add conditional access'
=> 'Bedingungsabhängigen Zugriff hinzufügen',

   'based on domain, username, or course affiliation.'
=> 'basierend auf Domäne, Benutzerkennung oder Kurszugehörigkeit',

   '[_1]-based conditional access: '
=> '[_1]-basierter bedingungsabhängiger Zugriff: ',

   'conditions'
=> 'Bedingungen',

   'condition'
=> 'Bedingung',

   'Action?'
=> 'Aktion?',

   'Allowed [_1] member affiliations'
=> 'Zugelassene [_1] Mitgliedszugehörigkeiten', # ???

   'No [_1]-based conditions defined.'
=> 'Keine [_1]-basierten Bedingungen definiert.',

   'Type of change'
=> 'Änderungsart',

   'Access control'
=> 'Zugriffskontrolle',

   'Additional information'
=> 'Zusätzliche Informationen',

   'A problem occurred deleting access controls: [_1]'
=> 'Beim Löschen der Zugriffkontrollen trat ein ein Problem auf: [_1]',

   'A problem occurred saving access control settings: [_1]'
=> 'Beim Speichern der Zugriffskontroll-Einstellungen trat ein Problem auf: [_1]',

   'opened folder'
=> 'geöffnetes Verzeichnis',

   'closed folder'
=> 'geschlossenes Verzeichnis',

   'Passphrase-protected'
=> '密码保护',

   'Conditional'
=> 'Bedingungsabhängig',

   'An error occurred ([_1]) while trying to delete [_2].'
=> 'Beim Versuch [_2] zu löschen ist ein Fehler aufgetreten: [_1]',

   'File: [_1] deleted.'
=> '文件 [_1] 已删除。',

   'An error occurred ([_1]) while trying to delete access controls for the file.'
=> 'Beim Versuch Zugriffkontrollen für die Datei zu löschen, ist ein Fehler aufgetreten: [_1]',

   'Access controls also deleted for the file.'
=> 'Auch die Zugriffskontrollen wurden für diese Datei gelöscht.',

   'Error: no valid filename was provided to rename to.'
=> 'Fehler: Das Umbenennen ist nicht möglich, da für den neuen Dateinamen kein gültiger Dateiname angegeben wurde.',

   'An error occurred ([_1]) while trying to rename [_2] to [_3]'
=> 'Beim Versuch [_2] nach [_3] umzubenennen ist ein Fehler aufgetreten: [_1]',

   'The new file name was changed from:<br />[_1] to [_2]'
=> 'Der neue Dateiname wurde geändert von:<br />[_1] nach [_2]',

   'An error occurred ([_1]) while trying to delete access control records for the old name.'
=> 'Beim Versuch Zugriffskontroll-Datensätze für den alten Namen zu löschen ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to upload [_2].'
=> 'Beim Versuch [_2] hochzuladen ist ein Fehler aufgetreten: [_1]',

   'An error occurred (dir) ([_1]) while trying to delete [_2].'
=> 'Beim Versuch das Verzeichnis [_2] zu löschen ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to upload [_2] for embedded element [_3].'
=> 'Beim Versuch [_2] für das eingebettete Element [_3] hochzuladen ist ein Fehler aufgetreten: [_1]',

   'An error occurred ([_1]) while trying to create a new directory [_2].'
=> 'Beim Versuch das Verzeichnis [_2] anzulegen, ist ein Fehler aufgetreten: [_1]',

   'Access controls updated to reflect the name change.'
=> 'Die Zugriffskontrolle wurde aufgrund der Namensänderung aktualisiert.',

   'Conditional files are accessible to logged-in users with accounts in the LON-CAPA network, who satisfy the conditions you set.'
=> 'Auf bedingungsabhängige Dateien können eingeloggte Benutzer zugreifen, die im LON-CAPA-Netzwerk einen Benutzeraccount haben und die die von Ihnen eingestellten Bedingungen erfüllen.',

   'The conditions can include affiliation with a particular course, or a user account in a specific domain.'
=> 'Die Bedingungen können eine Verbindung mit einem bestimmten Kurs oder Benutzeraccount in einer bestimmten Domäne beinhalten.',

   'Alternatively access can be granted to people with specific LON-CAPA usernames and domains.'
=> 'Alternativ kann Zugriff für Leute gewährt werden, die bestimmte LON-CAPA-Benutezrnamen oder -Domänen haben.',

   'Current access controls defined for this file:'
=> 'Derzeit eingestellte Zugriffskontrolle für diese Datei:',

   'No access control settings currently exist for this file.'
=> 'Für diese Datei existieren derzeit keine Zugriffskontroll-Einstellungen.',

   'Deleted'
=> 'Gelöscht',

   'No end date'
=> '无结束日期',

   'Start: '
=> '开始： ',

   'End: '
=> '结束： ',

   'Domains: '
=> '域： ',

   'Users: '
=> '用户： ',

   'New control(s) added'
=> 'Neue Zugriffskontrolle(n) hinzugefügt',

   'Existing control(s) deleted'
=> 'Bestehende Zugriffskontrolle(n) gelöscht',

   'Existing control(s) modified'
=> 'Bestehende Zugriffskontrolle(n) geändert',

   'Add new <b>[_1]-based</b> access control for portfolio file: <b>[_2]</b>'
=> 'Neue <b>[_1]-basierte</b> Zugriffskontrolle für Portfolio-Dateien hinzufügen: <b>[_2]</b>',

   'Display all access settings for this file'
=> 'Alle Einstellungen für diese Datei anzeigen',

   'Add a roles-based condition'
=> 'Rollen-basierte Bedingung hinzufügen',

   'New role-based condition'
=> 'Neue rollen-basierte Bedingung',

   "Format for users' username:domain information:"
=> "Format für Informationen des Benutzers username:domäne: ", # ??? -> portfolio.pm

   'Add new [_1] condition(s)?'
=> 'Neue [_1]-Bedingung(en) hinzufügen?',

   'Number to add: '
=> 'Anzahl: ', # 'Anzahl neu Hinzuzufügender: ',

   'Select roles, course status, section(s) and group(s) for users who will be able to access the portfolio file.'
=> 'Wählen Sie Rollen, Kurs-Status, Sektion(en) und Gruppe(n) für die Benutzer, die Zugriff auf die Portfolio-Dateien erhalten sollen.',

   '[_1] status'
=> '[_1] 状态', # ???

   'Files selected from other directories:'
=> 'Dateien, die aus anderen Verzeichnissen ausgewählt wurden:',

   'Unable to upload [_1]. (size = [_2] kilobytes). Disk quota will be exceeded.'
=> '[_1] konnte nicht hochgeladen werden (Größe: [_2] KB). Der verfügbare Speicherplatz wurde überschritten.',

   'Unable to upload [_1]. A locked file by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Eine gesperrte Datei mit diesem Namen wurde in [_2] gefunden.',

   'You will be able to rename or delete existing [_1] after a grade has been assigned.'
=> 'Sie können die Datei [_1] umbenennen oder löschen, nachdem eine Bewertung zugewiesen wurde.',

   'Unable to upload [_1]. A file by that name was found in [_2].'
=> '[_1] konnte nicht hochgeladen werden. Eine Datei mit diesem Namen wurde in [_2] gefunden.',

   'To upload, rename or delete existing [_1] in [_2].'
=> 'Um eine existierende Datei [_1] in [_2] hochzuladen, umzubenennen oder zu löschen.', # ???

   'Rename [_1] to [_2]?'
=> '[_1] in [_2] umbenennen?',

   'Reference Warning'
=> 'Verweiswarnung',

   'Completed upload of the file. This file contained references to other files. You must upload the referenced files or else the uploaded file may not work properly.'
=> 'Hochladen der Datei abgeschlossen. Diese Datei enthält Verweise auf andere Dateien. Sie müssen die Dateien, auf die verwiesen wird, auch hochladen oder die hochgeladene Datei wird nicht korrekt funktionieren.',

   'Please select the locations from which the referenced files are to be uploaded.'
=> 'Bitte wählen Sie die Orte aus, von denen die Dateien, auf die verwiesen wird, hochgeladen werden sollen.',

   'Delete [_1]?'
=> '删除 [_1]?',

   'Edit Portfolio File Catalog Information'
=> '编辑组合文件的目录信息',

   'Edit Group Portfolio File Catalog Information'
=> '编辑组组合文件的目录信息',

   'Update'
=> '更新',

   'domains'
=> '域',

   'users'
=> '用户',

   'Access'
=> 'Zugriff',

   'Conditional: domain-based'
=> 'Bedingungsabhängig: domänen-basiert',

   'Conditional: user-based'
=> 'Bedingungsabhängig: benutzer-basiert',

   'Conditional: course-based'
=> 'Bedingungsabhängig: kurs-basiert',

   '[_1] was submitted in response to problem: [_2]'
=> '[_1] wurde als Antwort auf die Aufgabe [_2] eingereicht.',

   '[_1] was handed back in response to problem: [_2]'
=> '[_1] wurde als antwort auf die Aufgabe [_2] zurückgegeben.',

   'In the course:'
=> 'Im Kurs',

   'Back'
=> '返回',

   'Error: no directory name was provided.'
=> '错误：没有输入目录名称。',

   'Unable to create a directory named [_1].'
=> '无法创建目录名 [_1]。',

   'Action disallowed'
=> '不允许行动',

   'You do not have sufficient privileges to [_1]'
=> '您没有足够权限 [_1]',

   'upload files'
=> '上传文件',

   'delete files'
=> '删除文件',

   'rename files'
=> '重命名文件',

   'set access controls for files'
=> '设置访问控制文件',

   "in the group's file repository."
=> "in der Dateisammlung der Gruppe.",

   'in this portfolio.'
=> '在这个组区。',

   'You do not have the privileges required to access the shared files space for this group.'
=> '您没有权限访问该组的共享文件。',

   'Not a valid group for this course'
=> '本课程里不是一个有效的组',

   'Group files for [_1]'
=> '[_1] 组的组文件 ',

   'Invalid group'
=> '无效组',

   'No file was selected to upload.'
=> '没有文件被选中上传。',

   'To upload a file, click <strong>Browse...</strong> and select a file, then click <strong>Upload</strong>.'
=> '要上传文件，请点击<strong>浏览... </strong>，并选择一个文件，然后点击<strong>上传</strong> 。',

   'Edit the meta data'
=> '编辑元数据',

   'Pick functionality'
=> '选择功能',

   'Functionality to display/modify'
=> '功能显示/修改',

   'You must select at least one functionality type to display.'
=> '您必须至少选择一个功能型。',

   'Default color schemes'
=> '默认颜色方案',

   'Log-in page options'
=> '登录页面选项',

   'Default authentication/language/timezone'
=> '默认的身份验证/语言/时区',

   'Default quotas for user portfolios'
=> 'Voreingestellter Speicherplatz für Portfoliobereiche der Benutzer',

   'Auto-update settings'
=> '设置自动更新',

   'Institutional directory searches'
=> 'Institutionelle Verzeichnissuche',

   'User creation'
=> '创建用户',

   'User modification'
=> '用户设置',

   'Scantron format file'
=> 'Scantron-Format-Datei',

   'Cataloging of courses'
=> '课程目录',

   'Display options'
=> '显示选项',

   'Display using: '
=> 'Anzeige verwendet: ',

   'one column'
=> '一列',

   'two columns'
=> '两列',

   'Changes made:'
=> 'Vorgenommene Änderungen:',

   'Back to configuration display'
=> 'Zurück zur Konfiguration',

   'No changes made to log-in page settings'
=> 'An den Optionen für die Login-Seite wurden keine Änderungen vorgenommen.',

   'Support Request'
=> 'Anfrage an Helpdesk',

   'Do <b>not</b> use this form to ask questions about course content.'
=> 'Verwenden Sie dieses Formular <b>nicht</b> für Fragen über Kursinhalte.',

   'Contact your instructor instead.'
=> 'Kontaktieren Sie dazu Ihren Dozenten.',

   'Cc'
=> '抄送',

   'Your e-mail address'
=> '您的E-Mail地址',

   'Search and Enroll'
=> '搜索和注册',

   'Search or Add New User'
=> '搜索或添加新用户',

   'No username and/or domain provided.'
=> 'Keine Benutzerkennung und/oder Domäne angegeben.',

   'No match was found for the username ([_1]) in LON-CAPA domain: [_2]'
=> 'Für die Benutzerkennung [_1] in der LON-CAPA-Domäne [_2] wurde kein Treffer gefunden.',

   'Submit a request to the LON-CAPA [_1]helpdesk[_2] for [_3] if you require assistance.'
=> 'Kontaktieren Sie das [_1]LON-CAPA-Helpdesk[_2] ([_3]), falls Sie Unterstützung benötigen.',

   'Unable to create new Excel file. This error has been logged. Please alert your LON-CAPA administrator.'
=> 'Die Excel-Datei konnte nicht angelegt werden. Dieser Fehler wurde protokolliert. Bitte informieren Sie Ihren LON-CAPA-Administrator.',

   'Problems occurred in creating the output file. This error has been logged. Please alert your LON-CAPA administrator.'
=> 'Bei der Erstellung der Ausgabedatei sind Schwierigkeiten aufgetreten. Dieser Fehler wurde protokolliert. Bitte informieren Sie Ihren LON-CAPA-Administrator.',

   'Problems occurred in writing the CSV file. This error has been logged. Please alert your LON-CAPA administrator.'
=> 'Beim Schreiben der CSV-Datei sind Schwierigkeiten aufgetreten. Dieser Fehler wurde protokolliert. Bitte informieren Sie Ihren LON-CAPA-Administrator.',

   'Records [_1]'
=> 'Datensätze [_1]', # ???

   'Filter [_1]'
=> 'Filter [_1]',

   'Under you current role you are not permitted to change login settings for this user'
=> 'Mit Ihrer derzeitigen Benutzerrolle sind Sie nicht berechtigt, die Login-Daten für diesen Benutzer zu ändern.',

   'History'
=> '历史',

   'Part '
=> '部分 ',

   'Transaction [_1]'
=> 'Transaktion [_1]', # ???

   'Nothing submitted - no attempts.'
=> 'Nichts eingereicht - keine Versuche.',

   'No data.'
=> 'Keine Daten vorhanden.',

   '[_1] will be inaccessible between [_2] and [_3] because communication is being blocked.'
=> 'Auf [_1] kann zwischen [_2] und [_3] nicht zugegriffen werden, da die Kommunikationsmöglichkeit für diese Zeit gesperrt wurde.',

   'Open in a new window'
=> 'In neuem Fenster öffnen',

   'Revoke user roles'
=> 'Benutzerrollen entziehen',

   'Delete user roles'
=> 'Benutzerrollen löschen',

   'Re-enable expired user roles'
=> 'Abgelaufene Benutzerrollen reaktivieren',

   'Make future user roles active now'
=> 'Zukünftige Benutzterrollen für jetzt aktivieren',

   'Change starting/ending dates'
=> 'Anfangs-/Endezeiten ändern',

   'Change section associated with user roles'
=> 'Mit Benutzerrollen verknüpfte Sektionen ändern',

   'Modify existing user: '
=> '修改现有的用户： ',

   'Enroll one student'
=> '注册一名学生',

   'Enroll one student: '
=> '注册一名学生： ',

   'Existing Roles'
=> '现有的角色',

   'Existing Roles in this Course'
=> '课程中现有的角色',

   'Existing Co-Author Roles in your Construction Space'
=> 'Bestehende Co-Autoren-Rollen in Ihrem Konstruktionsbereich',

   'Existing Roles in this Domain'
=> '在该域中现有的角色',

   'Text-based Interface Login'
=> 'Anmeldung für textbasierte Oberfläche',

   'Select Accessibility Options'
=> 'Auswahl der Anmeldeoptionen',

   'Suppress rendering of images'
=> 'Anzeige von Bildern unterbinden',

   'Suppress Java applets'
=> '禁止Java小程序',

   'Suppress rendering of embedded multimedia'
=> 'Eingebettete Multimedia-Objekte unterbinden',

   'Increase font size'
=> '放大字体',

   'Switch to black and white mode'
=> '切换到黑白模式',

   'Remember these settings for next login'
=> '下次登录时记住这些设置',

   'You are already logged in!'
=> '您已经登录！',

   'You are already logged in'
=> '您已经登录！',

   'Please either [_1]continue the current session[_2] or [_3]logout[_4].'
=> '您的选择：[_1]继续当前的会话[_2]或者[_3]退出[_4]。',

   'Login problems?'
=> '无法登录？',

   'Reset password'
=> '重设密码',

   'Reset forgotten LON-CAPA password'
=> '重置 LON-CAPA 密码',

   'If you use the same account for other campus services besides LON-CAPA, (e.g., e-mail, course registration, etc.), a separate centrally managed mechanism likely exists to reset a password.  However, if your account is used for just LON-CAPA access you will probably be able to reset a password from this page.'
=> '如果您使用相同的帐户的其他校园服务除了LON-CAPA， （例如，电子邮件，课程注册等） ，一个单独的中央管理机制可以重置密码。然而，如果您的帐户只是用于LON-CAPA访问，您可以从这个网页重置密码。',

   'Three conditions must be met:'
=> '三个条件必须满足：',

   'An e-mail address must have previously been associated with your LON-CAPA username.'
=> '必须有一个电子邮件地址与您的LON-CAPA用户联系在一起的。',

   'You must be able to access e-mail sent to that address.'
=> '您必须能访问即将发送的电子邮件地址。',

   'Your LON-CAPA account must be of a type for which LON-CAPA can reset a password.'
=> '您 LON-CAPA 帐户必须是一个类型为 LON-CAPA 可以重置密码。',

   'Thank you for your request to reset the password for your LON-CAPA account.'
=> '感谢您要求重设 LON-CAPA 帐户的密码 。',

   'Email address in LON-CAPA'
=> 'LON-CAPA 里 E-Mail 地址',

   'E-mail address in LON-CAPA'
=> 'LON-CAPA 里 E-Mail 地址',

   'The username you provided was not verified as a valid username in the LON-CAPA system for the [_1] domain.'
=> '您提供的用户名不是有效的用户名在 LON-CAPA 系统在该[_1]域。',

   'Please [_1]go back[_2] and try again.'
=> '请[_1]返回[_2] ，然后再试一次。',

   'The e-mail address you provided does not appear to be a valid address.'
=> '您提供的电子邮件地址不是一个有效的地址。',

   'A valid e-mail address was not located in the LON-CAPA system for the username and domain you provided.'
=> '您提供的用户名和域在 LON-CAPA 系统中没有找到一个有效的电子邮件地址。',

   'The username you provided uses an authentication type which can not be reset directly via LON-CAPA.'
=> '您提供的用户名使用的身份验证类型，不能直接通过 LON-CAPA 重置密码。',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3].'
=> '您不妨联系[_2]的[_3]的[_1] LON-CAPA 求助。',

   'You may wish to send an e-mail to the server administrator: [_1] for [_2].' # 1: e-mail, 2: domain
=> '您不妨给服务器管理员发送电子邮件： [_1]的[_2] 。Sie können an den Server-Administrator [_1] der Einrichtung [_2] eine E-Mail schicken.',

   'Assigning yourself a co-author or assistant co-author role in your own author area in Construction Space is not permitted'
=> 'Es ist nicht möglich, sich selbst für den eigenen Autorenbereich/Konstruktionsbereich Co-Autoren- oder Co-Autor-Assistenten-Rechte zu vergeben.',

   'Owner(s)'
=> 'Eigentümer',

   'Practice Problem'
=> '练习题',

   'Submissions are not permanently recorded'
=> 'Die Antworten werden nicht dauerhaft gespeichert.',

   'Submissions to practice problems are not permanently recorded.'
=> 'Antworten von Übungsaufgaben werden nicht dauerhaft gespeichert.',

   'not graded'
=> 'keine Punktewertung',

   'Course initialization preference'
=> 'Kurs-Initialisierungs-Präferenz',

   'Choose which page will be displayed when you enter this course after selecting a role.'
=> 'Festlegung, welche Seite beim Betreten dieses Kurses angezeigt werden soll.',

   'Current value is determined by'
=> 'Derzeitiger Wert ist bestimmt durch',

   'and is set to display'
=> 'und ist so eingestellt, dass folgende Seite gezeigt wird:',

   'Page display controlled by'
=> 'Seitenanzeige wird bestimmt durch',

   'If'
=> 'Falls',

   'Choose course entry'
=> 'Auswahl des Kurs-Eintrags',

   'Modify course entry'
=> 'Kurs-Eintrag ändern',

   'No members to add at this time, as there are no users matching the specified type(s), role(s) and section(s).'
=> 'Derzeit gibt es keine Mitglieder, die hinzuzufügen wären, da es keine Benutzer gibt, auf die die Typen, Rollen und Sektionen zutreffen.',

   'There are no users to add as new members, as all users matching the specified type(s), role(s), and section(s) are already affiliated with this group.'
=> 'Derzeit gibt es keine Benutzer, die als neue Mitglieder hinzuzufügen wären, da alle Benutzer, auf die die Typen, Rollen und Sektionen zutreffen, bereits mit der Gruppe verknüpft sind.',

   "You may need to use the 'modify existing, past or future members' page if you need to re-enable or activate access for previous or future members."
=> "Sie müssen ggf. die 'Bestehende, in der Vergangenheit liegende oder zukünftige Mitgliedschaften'-Seite verwenden, um Zugriff für in der Vergangenheit liegende oder zukünftige Mitgliedschaften wiederherzustellen oder zu aktivieren.",

   'Setting optional privileges for specific group members'
=> '对具体组成员设置可选的权限',

   'As no group tools will be made available to users, there are no specific user privileges to set.'
=> 'Da keine Gruppenwerkzeuge für Benutzer zugänglich gemacht werden, können auch keine Berechtigungen für bestimmte Benutzer eingerichtet werden.',

   'Create group'
=> '创建组',

   'The value you entered for the quota for the file repository in this group contained invalid characters, so it has been set to 0 Mb. You can change this by modifying the group settings.'
=> 'Der von Ihnen eingegebene Wert des Speicherplatzes für die Dateisammlung in dieser Gruppe enthält ungültige Zeichen. Der Wert wurde deshalb auf 0 MB gesetzt. Sie können dies in den Gruppen-Einstellungen ändern.',

   'The value you entered for the quota for the file repository in this group exceeded the maximum possible value, so it has been set to [_1] Mb (the maximum possible value).'
=> 'Der von Ihnen eingegebene Wert des Speicherplatzes für die Dateisammlung in dieser Gruppe hat die maximal zulässige Größe überschritten. Der Wert wurde deshalb auf [_1] MB gesetzt (die maximal mögliche Größe).',

   'A problem occurred when creating folders for the new group [_1]:'
=> 'Bei Erstellen von Verzeichnissen für die neue Gruppe [_1] ist ein Fehler aufgetreten:',

   'Group [_1] was created.'
=> '组 [_1] 已创建。',

   'E-mail Address'
=> 'E-Mail地址',

   'Closes '
=> 'Schließt am ',

   'The resources in "[_1]" are open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete all resources "[_1]".'
=> 'Die Ressourcen in "[_1]" sind nur für eine begrenzte Zeit verfügbar. Sobald Sie auf "Zeige Ressource" klicken, haben Sie [_2] Zeit, um alle Ressourcen in "[_1]" zu bearbeiten.',

   'This resource "[_1]" is open for a limited time. Once you click the "Show Resource" button below you have [_2] to complete this resource "[_1]".'
=> 'Diese Ressource "[_1]" ist nur für eine begrenzte Zeit verfügbar. Sobald Sie auf "Zeige Ressource" klicken, haben Sie [_2] Zeit, um diese Ressource zu bearbeiten.',

   '[quant,_1,day]'
=> '[quant,_1,Tag,Tage]',

   '[quant,_1,hour]'
=> '[quant,_1,Stunde,Stunden]',

   '[quant,_1,minute]'
=> '[quant,_1,Minute,Minuten]',

   '[quant,_1,second]'
=> '[quant,_1,Sekunde,Sekunden]',

   'Start Timer?'
=> 'Timer starten?',

   'Sign up for time to work.'
=> 'Für Zeiten zur Bearbeitung eintragen',

   'Requesting Another Worktime'
=> 'Anforderung von Zeiten zur Bearbeitung',

   'No available times.'
=> 'Keine Zeiten verfügbar.',

   'Return to last resource'
=> 'Zur letzten Ressource zurückkehren',

   'My Courses'
=> '我的课程',

   '[_1] parts'
=> '[_1] Teile',

   'Part: [_1]'
=> '部分： [_1]',

   'New Discussion'
=> '新的讨论',

   'New Email'
=> '新的 E-Mail',

   'New Error'
=> '新的错误',

   '(randomly select [_1])'
=> '(zufällig [_1] ausgewählt)',

   '(randomly ordered)'
=> '(in zufälliger Reihenfolge)',

   'No course selected'
=> 'Kein Kurs gewählt',

   'Open '
=> 'Öffnet am ',

   'Having technical difficulties; please check status later'
=> 'Technische Probleme - bitte später nochmal probieren',

   'Answer open'
=> 'Antwort verfügbar am',

   'Yes, and show correct answer if they exceed the maximum number of tries.'
=> 'Ja, und korrekte Antwort anzeigen, nachdem alle Versuche aufgebraucht sind.',

   "No, don't show correct/incorrect feedback."
=> "Nein, kein Korrekt-/Inkorrekt-Feedback anzeigen",

   'No, show no feedback at all.'
=> 'Nein, keinerlei Feedback anzeigen.',

   'single part'
=> 'einteilig',

   'Course Page'
=> '课程页面',

   'Unable to set "number unread posts display" to [_1] due to [_2].'
=> '"Anzeige der Anzahl ungelesener Beiträge" konnte nicht auf [_1] gesetzt werden. Ursache: [_2]',

   'Current value is [_1].'
=> '当前的值是 [_1].',

   'Unable to set interval to [_1] due to [_2].'
=> 'Intervall konnte nicht auf [_1] gesetzt werden. Ursache: [_2]',

   'Changes to threshold(s) for problem tracking:'
=> 'Vorgenommene Änderungen der Schwellenwerte:',

   'Set threshold for [_1] to [_2]'
=> '对于 [_1] 到 [_2] 的临界值',

   'Set the default page to be displayed when you select a course role'
=> '设置默认页， 显示您选择的课程的角色',

   '(Currently: [_1])'
=> '(现在: [_1])',

   "The global user preference you set for your courses can be overridden in an individual course by setting a course specific setting via the [_1]What's New page[_2] in the course."
=> "在课程中为您的课程的全局的用户首选项设置可以覆盖个别的课程设置，通过特定的课程设置[_1]What's New page[_2]。",

   'Display the [_1]first resource[_2] in the course.'
=> '显示课程中的[_1]第一资源[_2]。',

   "Display the [_1]What's New page[_2] - a summary of items in the course which require attention."
=> "显示 [_1]What's New page[_2] - 课程中的内容概述需要被注意。",

   'Default now set'
=> 'Voreinstellung ist ab sofort',

   'when you select a course role from the roles screen'
=> 'Wenn Sie einen Kurs von der Benutzerrollen-Seite wählen',

   'you will be taken to the start of the course.'
=> 'werden Sie zum Anfang des Kurses geleitet.',

   'a page will be displayed that lists items in the course that may require action from you.'
=> 'wird eine Seite angezeigt, die Elemente auflistet, die von Ihnen beachtet werden sollten.',

   "Display the What's New page listing course action items"
=> "Anzeige der Was-gibt's-Neues-Seite, die die Kurs-Aktionselemente auflistet",

   'Go to the start of the course'
=> 'Zum Anfang des Kurses gehen, und zwar ',

   'now'
=> 'jetzt',

   'No official courses to display for [_1].'
=> 'Es existieren keine offiziellen Kurse für [_1], die angezeigt werden könnten.',

   '(Month - Day - Year)'
=> '(月 - 日 - 年)',

   'Month[_1]Day[_2]Year'
=> '月[_1]日[_2]年',

   'Copyright/distribution option "Private" is no longer supported. Select another option from below. Consider "Custom Rights" for maximum control over the usage of your resource.'
=> 'Copyright/Zugriffsrechte unterstützt ab sofort nicht mehr die Option "Private Veröffentlichung". Deshalb wählen Sie bitte unten eine andere Option aus. Sie können "Spezielle Nutzungsrechte" wählen, um maximale Kontrolle über den Zugriff auf Ihre Ressource zu erhalten.',

   'Skipping'
=> 'Ausgelassen:',

   'Notifying host'
=> 'Benachrichtigung des Hosts', # ???

   'Back to Catalog Information'
=> '返回到目录信息',

   ' at '
=> ' in ',

   "Computer's answer is incorrect ([_1])."
=> "Die hinterlegte Antwort ist falsch ([_1]).",

   'It is likely that the tolerance range [_1] or significant figures [_2] need to be adjusted.'
=> 'Wahrscheinlich müssen der Toleranzbereich [_1] oder die signifikanten Stellen [_2] angepasst werden.',

   'It is likely that the tolerance range [_1] needs to be adjusted.'
=> 'Wahrscheinlich muss der Toleranzbereich [_1] angepasst werden.',

   'Submission Record'
=> 'Einreichungs-Aufzeichnungen',

   'Set/Change grades'
=> 'Bewertungen eingeben/ändern',

   'View of the problem'
=> 'Anzeige der Aufgabe',

   'Assign Grades'
=> 'Bewertungen zuweisen',

   'Save &amp; Next'
=> '保存并继续',

   '[_1]student(s)'
=> '[_1]学生',

   '(Next and Previous (student) do not save the scores.)'
=> '("Vorherige" und "Weiter" speichert nicht die Bewertungsdaten dieser Seite)',

   'LON-CAPA User Message'
=> 'LON-CAPA 用户邮件',

   '<b>Message: </b> No more students for this section or class.'
=> '<b>Nachricht:</b> Keine weiteren Studenten für diese Sektion oder diesen Kurs.',

   'Click on the button below to return to the grading menu.'
=> 'Klicken Sie auf den Button, um zum Bewertungsmenü zurückzugelangen.',

   'Group files'
=> '组文件',

   'One group portfolio file is available.'
=> 'Eine Gruppen-Portfolio-Datei ist verfügbar.',

   'One portfolio file owned by [_1] is available.'
=> 'Eine Gruppen-Portfolio-Datei von [_1] ist verfügbar.',

   'A total of [_1] group portfolio files are available.'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien verfügbar.',

   'A total of [_1] portfolio files owned by [_2] are available'
=> 'Insgesamt sind [_1] Gruppen-Portfolio-Dateien von [_2] verfügbar.',

   '[quant,_1,file is,files are] publicly accessible.'
=> 'Auf [quant,_1,Datei,Dateien] kann öffentlich zugegriffen werden.',

   '[quant,_1,file requires,files require] a passphrase for access.'
=> '[quant,_1,Datei benötigt,Dateien benötigen] für den Zugriff ein Passwort.',

   'Group Portfolio files'
=> '组组合文件',

   'Viewable portfolio files.'
=> '可见组合文件。',

   'Viewable portfolio files'
=> '可见组合文件',

   'Viewable group portfolio files'
=> '可见组组合文件',

   'Display file listing'
=> '显示文件列表',

   'Portfolio files for [_1]'
=> '[_1] 的组合文件',

   'File access type: '
=> '文件访问类型： ',

   'Update display'
=> '更新显示',

   'Course Information page'
=> '课程资料页',

   'Information about [_1]'
=> '关于 [_1] 的消息',

   'There are no available files of the specified access type: [_1]'
=> '没有提供文件的指定访问类型： [_1]',

   'File Type Displayed: [_1]'
=> '显示文件类型： [_1]',

   'All file types'
=> '所有文件类型',

   'The resource depends on another resource with variable filename, i.e., [_1].'
=> 'Die Ressource hängt von einer anderen Ressource ab, die einen variablen Dateinamen hat, z.B. [_1].',

   'You likely need to explicitly allow access to all possible dependencies using the [_1]-tag.'
=> 'Sie müssen explizit Zugriff auf alle möglichen Abhängigkeiten erlauben, indem Sie das [_1]-Tag verwenden.',

   'Add Selection for:'
=> 'Auswahl hinzufügen für:',

   'Selected Parameters:'
=> 'Ausgewählte Parameter:',

   'Show detailed Parameter Selection'
=> 'Detailierte Parameterauswahl anzeigen',

# Resource Parameters - Start

   'Problem Opening Date (opendate)'
=> '问题开始日期 (opendate)',

   'Problem Opening Date'
=> '问题开始日期',

   'Problem Due Date (duedate)'
=> '问题截止日期 (duedate)',

   'Problem Due Date'
=> '问题截止日期',

   'Problem Answer Date (answerdate)'
=> '问题答案日期 (answerdate)',

   'Problem Answer Date'
=> '问题答案日期',

   'Time-Limit (interval)'
=> '期限 (interval)',

   'Time-Limit'
=> '期限',

   'Weight (weight)'
=> 'Gewichtung (weight)',

   'Weight'
=> 'Aufgaben-Gewichtung',

   'Maximum Number of Tries (maxtries)'
=> 'Maximale Anzahl an Versuchen (maxtries)',

   'Maximum Number of Tries'
=> 'Maximale Anzahl an Versuchen',

   'Number of Tries before hints appear (hinttries)'
=> 'Anzahl der Versuche, bevor Hinweise erscheinen (hinttries)',

   'Number of Tries before hints appear'
=> 'Anzahl Versuche, bevor Hinweise angezeigt werden',

   'Content Opening Date (contentopen)'
=> '内容开放日期 (contentopen)',

   'Content Due Date (contentclose)'
=> '内容关闭日期 (contentclose)',

   'Content Opening Date'
=> '内容开放日期',

   'Content Close Date'
=> '内容关闭日期',

   'Question Type (type)'
=> '问题类型 (type)',

   'Question Type'
=> '问题类型',

   'Show Problem Status (problemstatus)'
=> 'Aufgabenstatus anzeigen (problemstatus)',

   'Show Problem Status'
=> '查看问题状态',

   'Resource Hidden from Students (hiddenresource)'
=> 'Ressource für Studierende verborgen (hiddenresource)',

   'Resource Hidden from Students'
=> 'Ressource für Studierende verborgen',

   'Resource hidden from students (hiddenresource)'
=> 'Ressource für Studierende verborgen (hiddenresource)',

   'Resource hidden from students'
=> 'Ressource für Studierende verborgen',

   'List of hidden parts (hiddenparts)'
=> 'Liste der versteckten Aufgabenteile (hiddenparts)',

   'List of hidden parts'
=> 'Liste der versteckten Aufgabenteile', # ???

   'Part Description (display)'
=> 'Aufgabenteil-Beschreibung (display)',

   'Part Description'
=> 'Aufgabenteil-Beschreibung',

   'Show Parts One-at-a-Time (ordered)'
=> 'Aufgabenteile alle zur gleichen Zeit zeigen (ordered)',

   'Show Parts One-at-a-Time'
=> 'Aufgabenteile alle zur gleichen Zeit zeigen',

   'Numerical Tolerance (tol)'
=> 'Numerische Toleranz (tol)',

   'Numerical Tolerance'
=> 'Numerische Toleranz',

   'Significant Digits (sig)'
=> 'Signifikante Stellen (sig)',

   'Significant Digits'
=> 'Signifikante Stellen',

   'Show Units - Disable Entry (turnoffunit)'
=> 'Einheiten anzeigen - Eintrag deaktivieren (turnoffunit)',

   'Show Units - Disable Entry'
=> 'Einheiten anzeigen - Eintrag deaktivieren', # ???

   'Discussion End Time (discussend)'
=> 'Diskussions-Endezeit (discussend)',

   'Discussion End Time'
=> 'Diskussions-Endezeit',

   'Hide Closed Discussion (discusshide)'
=> 'Geschlossene Diskussion verbergen (discusshide)',

   'Hide Closed Discussion'
=> 'Geschlossene Diskussion verbergen',

   'Randomly Order Resources (randomorder)'
=> 'Zufällige Reihenfolge der Ressourcen (randomorder)',

   'Randomly Order Resources'
=> 'Zufällige Reihenfolge der Ressourcen',

   'Randomly pick number of resources (randompick)'
=> 'Ressourcenanzahl zufällig wählen (randompick)',

   'Do not show plain URL (encrypturl)'
=> 'URL nicht im Klartext zeigen (encrypturl)',

   'Do not show plain URL'
=> 'URL nicht im Klartext zeigen',

   'Slots of availability (available)'
=> 'Verfügbarkeits-Slots (available)',

   'Slots of availability'
=> 'Verfügbarkeits-Slots',

   'CSS file to link (cssfile)'
=> 'Zu verlinkende CSS-Datei (cssfile)',

   'CSS file to link'
=> 'Zu verlinkende CSS-Datei',

   'Use slot based access controls (useslots)'
=> 'Slot-basierte Zugriffskontrolle verwenden (useslots)',

   'Use slot based access controls'
=> 'Slot-basierte Zugriffskontrolle verwenden',

  'Client IP/Name Access Control (acc)'
=> 'Client IP/Namen-Zugriffssteuerung (acc)',

   'Client IP/Name Access Control'
=> 'Zugriffskontrolle durch Client-IP-Adresse/-Name',

   'Resource alias name for conditions (mapalias)'
=> 'Ressourcen-Aliasname für Bedingungen (mapalias)',

   'Resource alias name for conditions'
=> 'Ressourcen-Aliasname für Bedingungen',

   'Slots of availability selected by student (availablestudent)'
=> 'Verfügbarkeits-Slots durch Student/in gewählt (availablestudent)',

   'Slots of availability selected by student'
=> 'Verfügbarkeits-Slots durch Student/in gewählt',

   'Hide buttons from students (buttonshide)'
=> 'Buttons für Studierende verbergen (buttonshide)',

   'Hide buttons from students'
=> 'Buttons für Studierende verbergen', # ???

   'Hide DragMath-Editor (turnoffeditor)'
=> 'DragMath-Editor verbergen (turnoffeditor)',

   'Hide DragMath-Editor'
=> 'DragMath-Editor verbergen',

   'Maximum Number of Collaborators (maxcollaborators)'
=> 'Maximale Anzahl an Mitarbeitern (maxcollaborators)',

   'Maximum Number of Collaborators'
=> 'Maximale Anzahl an Mitarbeitern',

   'Allowed File Extensions for Uploaded Files (uploadedfiletypes)'
=> 'Dateiendungen für hochgeladene Dateien erlauben (uploadedfiletypes)',

   'Allowed File Extensions for Uploaded Files'
=> 'Dateiendungen für hochgeladene Dateien erlauben',

   'Hand Graded (handgrade)'
=> 'Manuell bewertet (handgrade)',

   'Hand Graded'
=> 'Manuell bewertet',

   'Number of bubbles in exam mode (numbubbles)'
=> '考试模式中的一些复选框 (numbubbles)',

   'Number of bubbles in exam mode'
=> '考试模式中的一些复选框',

   'Format for display of score (scoreformat)'
=> '评分显示格式 (scoreformat)',

   'Format for display of score'
=> '评分显示格式',

   'Max. Cumulative Size (MB) for Submitted Files (maxfilesize)'
=> '最大(MB)累积提交文件 (maxfilesize)',

   'Max. Cumulative Size (MB) for Submitted Files'
=> '最大(MB)累积提交文件',

   'Max. cumulative size (MB) for submitted files (maxfilesize)'
=> '最大(MB)累积提交文件 (maxfilesize)',

   'Max. cumulative size (MB) for submitted files'
=> '最大(MB)累积提交文件',
# Resource Parameters - End

# Resource Parameter Categories - Start
   'Problem Appearance'
=> 'Erscheinung der Aufgaben',

   'Time Settings'
=> 'Zeitfenster',

   'High Level Randomization'
=> 'Übergreifende Randomisierung',

   'Hiding'
=> 'Verbergen',

   'Behaviour of Input Fields'
=> 'Verhalten der Eingabefelder',

   'Slots'
=> 'Slots',

   'File Submission'
=> 'Datei-Einreichungen',
# Resource Parameters Categories - End

   'New LON-CAPA [_1] ID: [_2]'
=> '新的 LON-CAPA-[_1]-ID: [_2]',

   'Not available'
=> '不详',

   'Post Announcement'
=> '提交通知',

   'The folder name: "[_1]" is already in use for an existing folder.'
=> '文件夹名称： "[_1]" 已经在现有的文件夹中。',

   'The folder name: "[_1]" is already used for one of the folders automatically generated by the system.'
=> '文件夹名称： "[_1]" 已经用于一个文件夹自动生成系统。',

   'Error - could not obtain lock on email folders record.'
=> 'Fehler: Sperrung des Nachrichtenverzeichnis-Datensatzes war nicht möglich.',

   'The folder "[_1]" may not be deleted'
=> 'Das Verzeichnis "[_1]" kann nicht gelöscht werden',

   'The folder "[_1]" does not exist so deletion is not required.'
=> 'Das Verzeichnis "[_1]" existiert nicht und braucht daher nicht gelöscht zu werden.',

   'The folder "[_1]" contains messages so it may not be deleted.'
=> '该文件夹“[_1]”包含有信息，因此不能删除。',

   'Delete or move the messages to a different folder first.'
=> 'Löschen oder verschieben Sie die Nachrichten zunächst in ein anderes Verzeichnis.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is an invalid name.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name ungültig ist.',

   'The folder "[_1]" may not be renamed to "[_2]" as the new name you requested is reserved for folders provided automatically by the system.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name für Verzeichnisse reserviert ist, die automatisch vom System angeboten werden.',

   'The folder "[_1]" may not be renamed to "[_2]" because the new name you requested is already being used for an existing folder.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da der neue Name bereits für ein bestehendes Verzeichnis verwendet wird.',

   'The folder "[_1]" could not be renamed to "[_2]" because the folder does not exist.'
=> 'Das Verzeichnis "[_1]" kann nicht in "[_2]" umbenannt werden, da das Verzeichnis "[_1]" nicht existiert.',

   'Warning: failed to release lock for counter'
=> 'Warnung: Die Sperre für den Zähler konnte nicht freigegeben werden.',

   'Warning: failed to release lock for folder: [_1].'
=> 'Warnung: Die Sperre für das Verzeichnis [_1] konnte nicht freigegeben werden.',

   'Error uploading new folder.'
=> 'Fehler beim Hochladen des neuen Verzeichnisses.',

   'Error reading contents of parent folder.'
=> 'Fehler beim Lesen der Inhalte des übergeordneten Verzeichnisses.',

   'Error saving updated parent folder.'
=> 'Fehler beim Speichern des aktualisierten übergeordneten Verzeichnisses.',

   'Parameters not set for [_1] because the resource was not recognized as part of the course.'
=> '',

   'Message not moved, Attempted to move message to the same folder as it already is in.'
=> 'Die Nachricht wurde nicht verschoben, da sie in das gleiche Verzeichnis verschoben werden sollte, in dem sie sich bereits befindet.',

   'Message not moved, A network error occurred.'
=> 'Die Nachricht wurde nicht verschoben, da ein Netzwerkfehler aufgetreten ist.',

   'Message not moved as the message is no longer in the source folder.'
=> 'Die Nachricht wurde nicht verschoben, da sie sich nicht mehr im Quellverzeichnis befindet.',

   'Message copied to new folder but status was not, A network error occurred.'
=> 'Die Nachricht wurde in das neue Verzeichnis kopiert, deren Status allerdings nicht, da ein Netzwerkproblem aufgetreten ist.',

   'Message copied, but unable to delete the original from the source folder.'
=> 'Die Nachricht wurde kopiert, allerdings konnte das Original im Quellverzeichnis nicht entfernt werden.',

   'Message copied, but unable to delete the original status from the source folder.'
=> 'Die Nachricht wurde kopiert, allerdings konnte der Originalstatus im Quellverzeichnis nicht entfernt werden.',

   'Error: you must have a course role selected to be able to send a broadcast message to a group in the course.'
=> 'Fehler: Sie müssen zunächst eine Kursrolle auswählen, um Broadcast-Nachrichten an eine Kursgruppe senden zu können.',

   'Error: could not determine domain or number of course'
=> 'Fehler: Weder die Domäne noch die Nummer des Kurses konnte ermittelt werden',

   'Select message recipients from the group members listed below.'
=> 'Wählen Sie Nachrichtenempfänger von der unten angegebenen Liste der Gruppenmitglieder.',

   'Send another e-mail'
=> '发送另一个电子邮件',

   'Send another group message'
=> '给其他组发送邮件',

   'Return to group page'
=> '返回到组网页',

   'You have to confirm that you have received this message before you can view other pages. After confirmation, this message will be moved to your regular inbox'
=> '您必须确认您已经收到此邮件，然后才能访问其他页面。确认后，此邮件将移至您的收件箱。',

   '[quant,_1,message is, messages are] not viewable because display of LON-CAPA messages sent to you by other students between [_2] and [_3] is currently being blocked because of online exams.'
=> '[quant,_1,Nachricht ist, Nachrichten sind] nicht sichtbar, da die Anzeige von an Sie von anderen Studenten gesendeten LON-CAPA-Nachrichten zwischen [_2] und [_3] derzeit aufgrund von Online-Prüfungen gesperrt ist.',

   'Each of the <b>[quant,_1,message]</b> you checked will be forwarded to the recipient(s) you select below.'
=> 'Jede der <b>[quant,_1,Nachricht,Nachrichten]</b>, die Sie ausgewählt haben, wird an die Empfänger weitergeleitet, die Sie unten auswählen.',

   'The message you checked will be forwarded to the recipient(s) you select below.'
=> 'Die Nachricht, die Sie ausgewählt haben, wird an die Empfänger weitergeleitet, die Sie unten auswählen.',

   'Send Messages'
=> '发送邮件',

   'Send Message'
=> '发送邮件', # '发送讯息',

   'Send Reply to Messages'
=> '发送回复邮件',

   'Send Reply to Message'
=> '发送回复邮件',

   'Forward Messages'
=> '转发邮件',

   'Forward Message'
=> '转发邮件',

   'Save message for re-use'
=> '邮件重新保存',

   'Show re-usable messages'
=> '显示保存的邮件',

   'This message was designated by the sender not to allow replies.'
=> 'Der Absender dieser Nachricht hat festgelegt, dass auf diese Nachricht nicht geantwortet werden kann.',

   'The sender did not designate a reply to address for this message.'
=> 'Der Absender hat keine Antwortadresse für diese Nachricht festgelegt.',

   'Reply to other recipients'
=> 'Antwort an weitere Empfänger',

   'Unless you choose otherwise:'
=> 'Sofern Sie nichts anderes auswählen, werden folgende Einstellungen verwendet:',

   "The subject in each forwarded message will be <i>'Forwarding:'</i> followed by the original subject."
=> "Der Betreff in jeder weitergeleiteten Nachricht wird <i>'Weiterleitung:'</i> sein, gefolgt vom ursprünglichen Betreff.",

   'original subject'
=> 'ursprünglicher Betreff',

   "sender's name"
=> "Name des Absenders",

   'Message begins with:'
=> 'Nachricht beginnt mit:',

   'Any new text to display before the text of the original messages:'
=> 'Beliebiger neuer Text, der vor dem Text der Originalnachricht angezeigt werden soll:',

   'username1:domain1: text'
=> '用户名1：域名1： 文本',

   'username2:domain2: text'
=> '用户名2：域名2： 文本',

   'username3:domain1: text'
=> '用户名3：域名3： 文本',

   "The messages will be assembled from all lines with the respective\n<tt>username:domain</tt>, and appended to the general message text."
=> "邮件从相应用户的所有行<tt>用户名：域</tt>收集并附加到一般消息文本。", # ???

   'Not allowed'
=> '不允许',

   'Archived Message'
=> '存档的邮件',

   '[quant,_1,communication blocking period was,communication blocking periods were] removed.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] entfernt.',

   '[quant,_1,communication blocking period was,communication blocking periods were] modified.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] geändert.',

   '[quant,_1,communication blocking period was,communication blocking periods were] added.'
=> '[quant,_1,Kommunikationssperr-Zeitraum wurde,Kommunikationssperr-Zeiträume wurden] hinzugefügt.',

   'You attempted to display a message that is currently blocked because you are enrolled in one or more courses for which there is an ongoing online exam.'
=> 'Sie haben versucht eine Nachricht anzuzeigen, die momentan gesperrt ist, da Sie einen oder mehre Kurse belegen, in denen eine Online-Prüfung stattfindet.',

   'Reply To'
=> 'Antwort an',

   'Current attempts of student (if applicable)'
=> 'Derzeitige Versuche des Studenten (falls verfügbar)',

   'Current screen output (if applicable)'
=> 'Derzeitige Bildschirmausgabe (falls verfügbar)',

   'No saved comments yet.'
=> 'Bisher keine gespeicherten Kommentare.',

   'No saved comments yet for this resource.'
=> 'Bisher keine gespeicherten Kommentare für diese Ressource.',

   'Could not deliver message'
=> 'Nachricht konnte nicht zugestellt werden.',

   'Please use the browser "Back" button and correct the recipient addresses ([_1]).'
=> 'Bitte verwenden Sie den Zurück-Button des Webbrowsers und korrigieren Sie die Empfängeradressen ([_1]).',

   'Failed to delete the message.'
=> 'Löschen der Nachricht ist fehlgeschlagen.',

   'Marked [_1] message(s) read'
=> '[_1] Nachricht(en) als gelesen markiert',

   'Marked [_1] message(s) Unread'
=> '[_1] Nachricht(en) als ungelesen markiert',

   'Destination folder [_1] is not a valid folder'
=> 'Bei dem Zielverzeichnis [_1] handelt es sich um kein gültiges Verzeichnis.',

   'Failed to move [_1] message(s)'
=> '[_1] Nachricht(en) konnte(n) nicht verschoben werden.',

   'Moved [_1] message(s)'
=> '[_1] Nachricht(en) wurde(n) verschoben.',

   'Failed to delete [_1] message(s)'
=> '[_1] Nachricht(en) konnte(n) nicht gelöscht werden.',

   'Deleted [_1] message(s)'
=> '[_1] Nachricht(en) wurde(n) gelöscht.',

   '[quant,_1,message] forwarded.'
=> '[quant,_1,Nachricht,Nachrichten] weitergeleitet.',

   'Could not forward [quant,_1,message].'
=> '[quant,_1,Nachricht,Nachrichten] konnte nicht nicht weitergeleitet werden.',

   'Could not deliver forwarded message.'
=> 'Weitergeleitetet Nachricht konnte nicht zugestellt werden.',

   'The recipient addresses may need to be corrected'
=> 'Die Empfängeradressesn mussen korrigiert werden',

   'Mail folder "[_1]" created.'
=> '邮件文件夹 "[_1]" 已创建。',

   'Creation failed.'
=> '创建失败。',

   'Mail folder "[_1]" deleted.'
=> '邮件文件夹 "[_1]" 已删除。',

   'Deletion failed.'
=> '删除失败。',

   'Mail folder "[_1]" renamed "[_2]".'
=> '邮件文件夹 "[_1]" 更名为 "[_2]".',

   'Renaming failed.'
=> '重命名失败。',

   'Messages'
=> '邮件',

   'Distribute from Uploaded File'
=> '从上传的文件分发', # ???

   'Communication Blocking'
=> '通讯阻塞',

   'Communication blocking during scheduled exams'
=> '有时限的通讯阻塞',

   'You can use communication blocking to prevent students enrolled in this course from displaying LON-CAPA messages sent by other students during an online exam. As blocking of communication could potentially interrupt legitimate communication between students who are also both enrolled in a different LON-CAPA course, please be careful that you select the correct start and end times for your scheduled exam when setting or modifying these parameters.'
=> '您可以在网上考试期间使用通信阻断，以防止该课程的学生接收其他学生的LON-CAPA信息。作为阻止的通信可能会中断参加了其他的LON-CAPA课程的学生之间的沟通，请您在在设置和更改安排考试时间时注意选择正确的开始和结束时间。',

   'Modify existing communication blocking periods'
=> '修改现有的通信阻断时间',

   'No communication blocks currently saved'
=> '目前任何通信被锁定。',

   'Duration'
=> '持续',

   'Event'
=> '事件',

   'Blocked?'
=> '被锁定？',

   'Add block'
=> '新增锁定',

   'e.g., Exam 1'
=> '(例如：考试1)',

   'Discussion'
=> '论坛',

   'The following changes were made'
=> '进行了以下更改：',

   'Add new communication blocking periods'
=> '添加新的的通信阻断时间',

   'Set by'
=> 'Ersteller',

   'Deleted Message'
=> '删除的邮件',

   'Marked Messages Read'
=> '邮件标记为已读',

   'Marked Messages Unread'
=> '邮件标记为未读',

   'Moved Messages'
=> '移动邮件',

   'Deleted Messages'
=> '删除邮件',

   'Marked Message as Unread'
=> '邮件标记为未读',

   'Deleted Folder'
=> '删除文件夹',

   'Renamed Folder'
=> '重命名文件夹',

   'username:domain,username:domain,...'
=> '用户名：域，用户名：域...',

   'All courses'
=> '所有课程',

   'Pick specific course(s):'
=> 'Bestimmte(n) Kurs(e) verwenden:',

   'Search for a course in the [_1] domain'
=> 'Kurs-Suche in der Domäne der [_1]',

   'Actions available after searching for a course:'
=> 'Verfügbare Aktionen nach der Suche eines Kurses:',

   'Although almost all course settings can be modified by a [_1], a number of settings exist which only a [_2] may change:'
=> 'Der [_1] kann beinahe alle Kurs-Einstellungen vornehmen. Einige Einstellungen darf jedoch nur ein [_2] ändern:',

   "Certain settings which control auto-enrollment of students from your institution's student information system."
=> "Bestimmte Einstellungen, die die automatische Kursbelegung für Studierende steuern",

   'The total disk space allocated for storage of portfolio files in all groups in a course.'
=> 'Der Gesamtspeicherplatz für die Portfolio-Dateien aller Gruppen im Kurs',

   'No existing sections'
=> '(Keine Sektionen vorhanden)', # n.t.

   'Broadcast e-mail to users'
=> 'Broadcast-E-Mail an Benutzer',

   'Broadcast E-mail'
=> 'Broadcast-E-Mail',

   'Broadcast e-mail to Domain'
=> 'Broadcast-E-Mail an Domäne',

   'Send a new e-mail message to selected users from this domain'
=> 'Senden einer neuen E-Mail an ausgewählte Benutzer dieser Domäne',

   'Send a new e-mail to selected users from this domain'
=> 'Senden einer neuen E-Mail an ausgewählte Benutzer dieser Domäne',

   'Display e-mail sent by Domain Coordinators in this domain'
=> 'Anzeige von Domänen-Koordinatoren gesendeter E-Mails in dieser Domäne',

   'Select Audience'
=> 'Empfängerkreis auswählen',

   'Choose e-mail audience'
=> 'Empfängerkreis auswählen',

   'Roles:'
=> '角色：',

   'Courses:'
=> '课程：',

   '[_1] selected.' # n.t.
=> '[_1] 选择的。',

   'Access status:'
=> 'Zugriffsstatus:',

   'Username -> Email conversion:'
=> '用户名 -> E-Mail 转换:',

   'Building valid e-mail address from username, if missing from preferences:'
=> 'Erstellung einer gültigen E-Mail-Adresse aus der Benutzerkennung, falls Voreinstellungen fehlen:',

   'Kerberos: enter default for each realm used in the domain, with comma separation of entries'
=> 'Kerberos: Geben Sie die Voreinstellung für jeden Bereich in der Domäne ein, getrennt durch Kommata',

   '(e.g., MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).'
=> '(z.B. MSU.EDU=msu.edu, MSUE.EDU=msue.msu.edu).',

   'Internal, Filesystem and Local authentication: enter single default.'
=> 'LON-CAPA-interne, Dateisystem- oder lokale Authentifizierung: Geben Sie eine einzelne Voreinstellung ein.',

   'Authentication Method'
=> 'Authentifizierungsmethode',

   'Username -> e-mail conversion'
=> 'Benutzerkennung -> E-Mail-Konvertierung',

   'Internal (LON-CAPA)'
=> 'LON-CAPA-intern',

   'username@'
=> '用户名@',
#=> 'Benutzerkennung@',

   'Local/Customized'
=> 'Lokal/benutzerdefiniert',

   'Filesystem (UNIX)'
=> 'Dateisystem (UNIX)',

   'Compose E-mail'
=> 'E-Mail erstellen',

   'No recipients identified'
=> 'Keine Empfänger gefunden',

   'Broadcast e-mail display options'
=> 'Anzeigeoptionen für Broadcast-E-Mail',

   'Date range:'
=> 'Zeitraum:',

   'Earliest to display:'
=> 'Frühester Zeitpunkt:',

   'Latest to display:'
=> 'Spätester Zeitpunkt:',

   'Choose sender(s):'
=> 'Auswahl des/der Sender:',

   'Display e-mail'
=> '显示 E-Mail',

   'E-mail display'
=> '显示 E-Mail',

   'Display Broadcast e-mail'
=> '显示广播 E-Mail',

   'No mail sent matching supplied criteria'
=> 'Es wurde keine Nachricht gesendet, auf die die Suchkriterien zutreffen.',

   'Customrole'
=> 'Benutzerdefinierte Rolle',

   'Defined by [_1] at [_2].'
=> 'Festgelegt durch [_1] in [_2].',

   'No students found.'
=> 'Keine Studenten gefunden.',

   'Spreadsheet'
=> 'Beurteilungsbogen',

   'Spreadsheet Help'
=> 'Hilfe zu Beurteilungsbögen',

   'Editing Help'
=> 'Eingabehilfe',

   'Help on printing'
=> 'Hilfe zum Drucken',

   'Metadata Diffs'
=> 'Metadaten-Unterschiede',

   'Retrieve Metadata'
=> 'Alte Metadaten wiederherstellen',

   'Enter course'
=> 'Kurs betreten',

   'Enter Course'
=> 'Kurs betreten',

   'Enter Access Key to Unlock this Course'
=> 'Eingabe des Zugriffsschlüssels zum Entsperren des Kurses',

   'Verifying Access Key to Unlock this Course'
=> 'Überprüfung des Zugriffsschlüssels, um Kurs zu entsperren',

   'Successfully registered key'
=> 'Schlüssel erfolgreich registriert',

   'Re-Enter Key'
=> 'Schlüssel erneut eingeben',

   'Assigned from [_1] at [_2] for [_3]'
=> 'Zugewiesen am [_2] von [_1] an [_3]',

   'Total Matches'
=> 'Gesamtanzahl Treffer',

   'Time Remaining'
=> 'Verbleibende Zeit',

   'IMPORT'
=> 'Importieren',

   'Help on slots'
=> 'Hilfe zu Slots',

   'New user accounts in [_1]'
=> 'Neue Benutzeraccounts in [_1]',

   'Student enrollment changes in [_1]'
=> 'Änderungen der studentischen Kursbelegung in [_1]',

   'The following [quant,_1,change] occurred in [_2] - [_3] as a result of the automated classlist update:'
=> 'Die [quant,_1,folgende Änderung trat,folgenden Änderungen traten] im Kurs [_2] - [_3] auf. Auslöser war der automatische Prozess zur Aktualisierung von Kursteilnehmerlisten.',

   'No institutional classlist data could be retrieved for [_1]'
=> 'Für [_1] konnte keine institutionelle Kursteilnehmerliste abgerufen werden.',

   'Not within time window for auto-enrollment in [_1]'
=> '[_1] befindet sich nicht innerhalb des Zeitfensters der automatischen Kursbelegung.',

   'Auto-enrollment not currently enabled for [_1]'
=> 'Für [_1] ist die automatische Kursbelegung derzeit nicht aktiviert.',

   'The courseID provided does not match a course in this domain.'
=> 'Die gewählte Kurs-ID gehört zu keinem Kurs in dieser Domäne.',

   'Not Open'
=> 'Derzeit kein Zugriff',

   "This resource currently isn't open. It will be available at [_1]."
=> "Auf diese Ressource darf momentan nicht zugegriffen werden. Sie wird ab [_1] verfügbar sein.",

   'Could not handle ambiguous resource reference'
=> 'Doppeldeutige Ressourcenreferenz',

   'The nature of the problem is unclear'
=> 'Die Fehlerursache ist unklar.',

   'Course Roster'
=> '课程名册',
#=> 'Kursteilnehmerliste',

   'Classlist'
=> '班级名册',
#=> 'Kursteilnehmerliste',

   'Display of a student-viewable course roster is not currently enabled.'
=> 'Die Anzeige der studenteneinsehbaren Kursteilnehmerliste ist derzeit deaktiviert.',

   'Student-viewable course roster'
=> 'Studenteneinsehbare Kursteilnehmerliste',

   'Students with no section'
=> 'Studenten in keiner Sektion',

   'Students in section "[_1]"'
=> 'Studenten in Sektion "[_1]"',

   'Students in any section'
=> 'Studenten in beliebiger Sektion',

   'Only students who have opted to be listed in the roster ([_1] out of [_2] students) are shown.'
=> 'Es werden nur Studenten angezeigt, die der Auflistung in der Kursteilnehmerliste zugestimmt haben (derzeit [_1] von insgesamt [_2]).',

   'The single student without a section[_1] has opted not to be listed in the roster.'
=> 'Der einzelne Student ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'The single student in the section[_1] has opted not to be listed in the roster.'
=> 'Der einzelne Student in der Sektion[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'The single student in the course[_1] has opted not to be listed in the roster.'
=> 'Der einzelne Student im Kurs[_1] hat der Auflistung in der Kursteilnehmerliste nicht zugestimmt.',

   'None of the [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studenten ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'None of the [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studenten in der Sektion[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'None of the [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Keiner der [_1] Studenten im Kurs[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students without a section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studenten ohne Sektionszugehörigkeit[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students in the section[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studenten in der Sektion[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students in the course[_2] have opted to be listed in the roster.'
=> 'Alle [_1] Studenten im Kurs[_2] haben der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student without a section[_1] has opted to be listed in the roster.'
=> 'Der einzelne Student ohne Sektionszugehörigkeit[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student in the section[_1] has opted to be listed in the roster.'
=> 'Der einzelne Student in der Sektion[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'The single student in the course[_1] has opted to be listed in the roster.'
=> 'Der einzelne Student im Kurs[_1] hat der Auflistung in der Kursteilnehmerliste zugestimmt.',

   'All [_1] students without a section[_2] are listed in the roster.'
=> 'Alle [_1] Studenten ohne Sektionszugehörigkeit[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'All [_1] students in the section[_2] are listed in the roster.'
=> 'Alle [_1] Studenten in der Sektion[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'All [_1] students in the course[_2] are listed in the roster.'
=> 'Alle [_1] Studenten im Kurs[_2] werden in der Kursteilnehmerliste aufgelistet.',

   'There is only a single student without a section[_1]'
=> 'Es gibt nur einen einzelnen Studenten ohne Sektionszugehörigkeit[_1].',

   'There is only a single student in the section[_1]'
=> 'Es gibt nur einen einzelnen Studenten in der Sektion[_1].',

   'There is only a single student in the course[_1]'
=> 'Es gibt nur einen einzelnen Studenten im Kurs[_1].',

   'There are currently no students to display.'
=> 'Derzeit gibt es keine Studenten, die angezeigt werden könnten.',

   'Available Portfolio files'
=> 'Verfügbare Portfolio-Dateien',

   'Name not given'
=> '姓名不详',

   '[quant,_1,file,files,No files]'
=> '[quant,_1,Datei,Dateien,Keine Dateien]',

   'Error retrieving file information.'
=> 'Fehler beim Abrufen der Dateiinformationen',

   'Your roster setting'
=> 'Ihre Kursteilnehmerlisten-Einstellung',

   'You are currently listed in the student-viewable roster.'
=> 'Sie werden derzeit in der studenteneinsehbaren Kursteilnehmerliste aufgelistet.',

   'You are currently <b>not</b> listed in the student-viewable roster.'
=> 'Sie werden derzeit <b>nicht</b> in der studenteneinsehbaren Kursteilnehmerliste aufgelistet.',

   'Include yourself in the roster?'
=> 'Möchten Sie in der Kursteilnehmerliste aufgelistet werden?',

   'Display of your name in the student-viewable roster set to <b>[_1]</b>.'
=> 'Anzeige Ihres Namens in der studenteneinsehbaren Kursteilnehmerliste auf <b>[_1]</b> gesetzt.',

   'Error occurred saving display setting.'
=> 'Es ist ein Fehler beim Speichern der Anzeige-Einstellungen aufgetreten.',

   'Display of your name in the student-viewable roster unchanged (set to <b>[_1]</b>).'
=> 'Anzeige Ihres Namens in der studenteneinsehbaren Kursteilnehmerliste bleibt unverändert (auf <b>[_1]</b> gesetzt).',

   'View course roster'
=> 'Kursteilnehmerliste',

   'Change Course Page Preferences'
=> 'Schnellzugriffsliste für Kurse',

   'Change Course Page Pref'
=> 'Schnellzugriffsliste für Kurse',

   'No context.'
=> 'Kein Kontext.',

   'unable to verify variable URL'
=> 'variable URL konnte nicht überprüft werden',

   'Receipt'
=> 'Empfangsbestätigung',

   'Problems during Course Initialization'
=> 'Probleme während der Kursinitialisierung',

   'Try Selecting Again'
=> 'Auswählen erneut versuchen',

   '<br />Invalid map: <tt>[_1]</tt>'
=> '<br />Ungültige Inhaltszusammenstellung: <tt>[_1]</tt>',

   'Please either [_1]close this window[_2] or [_3]log in again[_4].'
=> 'Bitte entweder [_1]dieses Fenster schließen[_2] oder [_3]erneut anmelden[_4].',

   'Thank you for using LON-CAPA.'
=> '感谢您使用 LON-CAPA。',

   'You have been successfully logged out.'
=> '您已成功退出。',

   'You can [_1]close this window[_2] now.'
=> '您现在可以 [_1]关闭这个窗口[_2]。',

   '[_1]Log in again[_2]'
=> '[_1]重新登录[_2]',

   'No matches found in resources.'
=> 'Keine Treffer in den Ressourcen.',

   'No matches found in postings.'
=> 'Keine Treffer in den Diskussionsbeiträgen.',

   'Unable to understand the search phrase [_1]. Please modify your search.'
=> 'Der Suchbegriff [_1] kann nicht ausgewertet werden. Bitte verändern Sie Ihre Anfrage.',

   'Unable to understand the search phrase [_1]: [_2]'
=> 'Der Suchbegriff [_1] kann nicht ausgewertet werden: [_2]',

   'You did not fill in enough information for the search to be started. You need to fill in relevant fields on the search page in order for a query to be processed.'
=> '搜寻无法完成，因为您没有足够的数据。您必须在搜索页面的搜索栏里填写关键词，从而使您的要求可以得到处理。',
# '您没有填写足够的信息进行搜索的开始。您需要填写在有关领域在搜寻网页上，以便查询处理。'

   'conditionally hidden'
=> '有条件的隐藏',

   'Problem Parameters'
=> '问题参数',

   'No group name provided.'
=> '没有组名称。',

   'Invalid group name provided.'
=> '无效的组名称。',

   'Invalid [_1]'
=> '无效的 [_1]', # ???

   '"[_1]" is not the name of a valid group in this [_2].'
=> '"[_1]" 并非是一个有效的名称在本组 [_2].',

   'You do not have privileges to view the membership roster in this group.'
=> '您没有权限以查看该组的会员名册。',

   'Group membership status - [_1]'
=> '组会员状态: [_1]',

   'group membership status - [_1]'
=> '组会员状态: [_1]',

   'There are no membership data to display for this group.'
=> '该组没有任何会员数据。Für diese Gruppe existieren keine anzeigbaren Mitgliedsdaten.',

   'Membership status: '
=> '会员状态: ',

   'There are no groups to display in this [_1].'
=> '没有任何组在此 [_1] 可以显示。', # ??? -> grouproster.pm

   'Start Date'
=> '开始日期',

   'End Date'
=> '结束日期',

   'Functionality'
=> '功能',

   'Privileges'
=> '权限',

   'Any Membership status'
=> '任何会员状态',

   'Active Member'
=> '活跃的会员',

   'Former Member'
=> '以前的会员',

   'Future Member'
=> '未来的会员',

   'Group Folder - [_1]'
=> '组文件夹 - [_1]',

   'Group homepage - [_1]'
=> '组网页 - [_1]',

   'A support request has been sent to'
=> 'Eine Support-Anfrage wurde gesendet an',

   'Your support request contained the following information'
=> 'Ihre Support-Anfrage enthält folgende Daten',

   'The following Cc e-mail address is invalid: '
=> 'Die folgende CC-E-Mail-Adresse is ungültig: ',

   'The following Cc e-mail addresses are invalid: '
=> 'Die folgende CC-E-Mail-Adressen sind ungültig: ',

   'As the e-mail address provided for this LON-CAPA server ([_1]) does not appear to be a valid e-mail address, your support request has <b>not</b> been sent to the LON-CAPA support staff or administrator at your institution.'
=> 'Da die für diesen LON-CAPA-Server angegebene E-Mail-Adresse ([_1]) anscheinend ungültig ist, wurde Ihre Support-Anfrage <b>nicht</b> an das LON-CAPA-Supportteam Ihrer Institution und auch nicht an den Adminstrator geschickt.',

   'Instead a copy has been sent to the LON-CAPA support team at Michigan State University.'
=> 'Stattdessen wurde eine Kopie an das LON-CAPA-Supportteam der Michigan State University gesendet.',

   'The uploaded screenshot file ([_1] bytes) included with your request exceeded the maximum allowed size - 128 KB, and has therefore been discarded.'
=> 'Die hochgeladene Screenshot-Datei Ihrer Anfrage hat die maximale Größe von 128 KB überschritten ([_1] Bytes) und wurde daher nicht verworfen.',

   'An uploaded screenshot file [_1] ([_2] bytes) was included in the request sent by [_3].'
=> 'Eine hochgeladene Screenshot-Datei [_1] ([_2] Bytes) wurde der Anfrage beigefügt, die von [_3] gesendet wurde.',

   'File does not have [_1] or [_2] starting tag'
=> 'Die Datei hat weder ein [_1]- noch ein [_2]-Start-Tag',

   'File does not have [_1] or [_2] ending tag'
=> 'Die Datei hat weder ein [_1]- noch ein [_2]-Ende-Tag',

   'Example'
=> 'Beispiel',

   'Algebraic Response Problems'
=> 'Algebraische Aufgaben',

   'Chemistry Problems'
=> 'Chemische Aufgaben',

   'Free Form Problems'
=> 'Aufgaben mit freier Gestaltung',

   'Handgraded Problems'
=> 'Manuell bewertete Aufgaben',

   'Miscellaneous'
=> 'Verschiedenes',

   'Multiple Choice Problems'
=> 'Auswahl-Aufgaben',

   'Numerical Problems'
=> 'Numerische Aufgaben',

   'Language:'
=> '语言：',

   'Math Rendering:'
=> 'Formeldarstellung:',

   'Restrict Domain Coordinator Access'
=> 'Zugriff durch Domänen-Koordinator',

   'By default, the Domain Coordinator can enter your construction space.'
=> 'Die Voreinstellung erlaubt dem Domänen-Koordinator, Ihren Konstruktionsbereich betreten zu können.',

   'Block access to construction space'
=> 'Zugriff auf Konstruktionsbereich verwehren',

   'jsMath'
=> 'jsMath',

   'tth (TeX to HTML)'
=> 'tth (TeX to HTML)',

   'mimetex (Convert to Images)'
=> 'mimetex (转换为图像)',

   'jsMath:'
=> 'jsMath:',

   'tth (TeX to HTML):'
=> 'tth (TeX to HTML):',

   'mimetex (Convert to Images):'
=> 'mimetex (转换为图像):',

   '[_1], [_2], or [_3]'
=> '[_1], [_2] 或者 [_3]',

   'internal, optional'
=> '内部的，可选的',

   'user:domain,user:domain,...'
=> '用户名：域，用户名：域...',

   'user:domain,user:domain(section;section;...;*;...),...'
=> '用户名：域，用户名：域（科，章节;...;*;...),...',

   'user:domain,user:domain,*:domain'
=> '用户名：域，用户名：域，*：域',

   'Course members with current access'
=> 'Kursteilnehmer mit aktuellem Zugriff',

   'Course members with expired access'
=> 'Kursteilnehmer mit abgelaufenen Zugriff',

   'Course members with future access'
=> 'Kursteilnehmer mit zukünftigem Zugriff',

   'Other Roles'
=> '其他角色',

   'Select Author'
=> '选择作者',

   'Non-standard Course'
=> '非标准课程',

   'Switch course role to...'
=> '更改用户角色...',

   'Message'
=> '邮件',

   'Time of change'
=> '更改时间',

   'active'
=> '活跃的',

   'previous'
=> '以前的',

   'Access dates to apply for selected users'
=> 'Zugriffszeiten für die ausgewählten Benutzer ändern',

   'Changes in section affiliation to apply to selected users'
=> 'Sektionszugehörigkeiten für die ausgewählten Benutzer ändern',

   'For student roles changing the section, will result in a section switch as students may only be in one section of a course at a time.'
=> 'Ein Sektionswechsel bei studentischen Rollen verursacht einen Austausch der Sektion, da Studierende nur in einer einzigen Sektion eines Kurses zur gleichen Zeit sein können.',

   'For a role in a course that is not a student role, a user may have roles in more than one section of a course at a time.'
=> 'Benutzer mit einer Kursrolle, die keine studentische Rolle ist, können in mehr als einer Sektion in einem Kurs zur gleichen Zeit sein.',

   "Retain each user's current section affiliations?"
=> "Sollen die bisherigen Sektionszugehörigkeiten beibehalten werden?",

   '(Does not apply to student roles).'
=> '(Betrifft nicht Studentenrollen).',

   '[_1]Show[_2] clicker id'
=> 'Clicker-ID [_1]anzeigen[_2]',

   '[_1]Hide[_2] clicker id'
=> 'Clicker-ID [_1]verbergen[_2]',

   'Catalog:'
=> '目录：',

   'Main Categories'
=> '主要类型',

   'Official courses (with institutional codes)'
=> '官方课程（带机构代码）',

   'Official courses'
=> '官方课程',

   'with institutional codes'
=> '带机构代码',

   'Self-enroll (if permitted)'
=> '自己报名（如果被允许）',

   'No ending date'
=> '无结束日期',

   'From:[_1]'
=> 'Start:[_1]',

   'To:[_1]'
=> 'Ende:[_1]',

   'Starts: [_1]'
=> '开始： [_1]',

   'Ends: [_1]'
=> '结束： [_1]',

   'Ended: [_1]'
=> 'Endete: [_1]',

   'Currently enabled'
=> 'Derzeit aktiviert',

   '[quant,_1,section:,sections:,No sections]'
=> '[quant,_1,Sektion:,Sektionen:,Keine Sektionen]',

   'No information available for [_1].'
=> 'Für "[_1]" sind keine Informationen verfügbar.',

   'Self-enrollers:'
=> 'Selbsteintragungen:',

   'Choices:'
=> 'Auswahlmöglichkeiten:',

   'Configure User Self-enrollment'
=> '配置用户自助注册',

   'View Change Logs'
=> 'Änderungsprotokoll', # long version: Änderungsprotokoll betrachten

   'View Log-in History'
=> 'Anmeldehistorie', # longversion: Anmeldehistorie betrachten

   'Configure Self-enrollment'
=> '配置自助注册',

   'Self-enrollment with a student role'
=> '自助注册一个学生角色',

   'Users allowed to self-enroll in this course'
=> '用户可自行注册来参加此课程',

   'Any user in any domain:'
=> '任何用户在任何域：',

   'User types:'
=> '用户类型：',

   'any'
=> '任意',

   'Any Users'
=> '任何用户',

   'Any users'
=> '任何用户',

   'Others'
=> '其他',

   'Additional domain:'
=> '其他域：',

   'Users in additional domain:'
=> '用户在其他域：',

   'Specific domain:'
=> '特定域：',

   'Users in specific domain:'
=> '用户在其特定域：',

   'Other domain:'
=> '其他域：',

   'Users in other domain:'
=> '用户在其他域：',

   'Restrict self-enrollment to students officially registered for the course'
=> '限制自助注册为正式注册的学生的课程',

   'Dates self-enrollment available'
=> '自助注册期限',

   'Starts'
=> '开始',

   'Ends'
=> '结束',

   'Course access dates assigned to self-enrolling users'
=> '课程访问日期分配给自助注册的用户',

   'Section assigned to self-enrolling users'
=> '章节指派给自助注册用户',

   'The following changes were made to self-enrollment settings:'
=> '进行了以下自助注册设置的更改：',

   '[_1]: "[_2]" set to "[_3]".'
=> '[_1]: "[_2]" 设置为 "[_3]".',

   '"[_1]" set to "[_2]".'
=> '"[_1]" 设置为 "[_2]".',

   'No changes were made to the existing self-enrollment settings in this course.'
=> '现有的自助注册设置在该课程中未作任何修改。',

   'Self-enrollment result'
=> '自助注册结果',

   'Enroll in course'
=> '注册课程',

   'Sections:'
=> '章节：',

   'Self-enroll in course'
=> '自助注册参加课程',

   'Self-enroll in a LON-CAPA course'
=> '自助注册参加LON-CAPA课程',

   'Self-enroll'
=> '自助注册',

   'Self-enroll in [_1]'
=> '自助注册到 [_1]',

   'Self-enrollment error'
=> '自助注册错误',

   'Invalid domain or course number'
=> '无效的域或课程数目',

   'Self-enrollment unavailable'
=> '自助注册无法使用',

   'Self-enrollment is restricted to students officially registered for this course.'
=> 'Die Selbsteintragung ist auf Studenten begrenzt, die offiziell für diesen Kurs registriert sind.',

   'Self-enrollment is not currently available for this course.'
=> 'Die Selbsteintragung ist für diesen Kurs derzeit nicht verfügbar.',

   'Self-enrollment is not currently available in this course'
=> 'Die Selbsteintragung ist für diesen Kurs derzeit nicht verfügbar.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users.'
=> 'Die Selbsteintragung wird am [_1] für alle LON-CAPA-Nutzer verfügbar werden.',

   'Self-enrollment will become available starting [_1], and will be available to all LON-CAPA users at your institution ([_2]).'
=> 'Die Selbsteintragung wird am [_1] für alle LON-CAPA-Nutzer Ihrer Einrichtung ([_2]) verfügbar werden.',

   'Self-enrollment will become available starting [_1]; please enroll at that time.'
=> 'Die Selbsteintragung wird am [_1] verfügbar werden. Bitte tragen Sie sich ab dann selbst ein.',

   'Although self-enrollment will become available starting [_1], you are ineligible for enrollment.'
=> 'Die  Selbsteintragung wird zwar am [_1] verfügbar werden, Ihnen ist es allerdings nicht gestattet sich selbst einzutragen.',

   'Self-enrollment will become available starting [_1].'
=> 'Die Selbsteintragung wird am [_1] verfügbar werden.',

   'The link to the requested page could not be followed.'
=> 'Die Verknüpfung zu der angeforderten Seite konnte nicht aufgerufen werden.',

   'The placeholder for the courseID is absent.'
=> 'Der Platzhalter für die Kurs-ID ist fehlt.',

   'LON-CAPA account required'
=> 'LON-CAPA-Account notwendig',

   'You need to be logged into LON-CAPA to self-enroll in a course.'
=> 'Sie müssen in LON-CAPA angemeldet sein, um sich in diesen Kurs selbst eintragen zu können.',

   'If you have an account in LON-CAPA, [_1]log-in[_2].'
=> 'Falls Sie einen LON-CAPA-Account haben, [_1]melden Sie sich bitte an[_2].',

   'Otherwise:'
=> 'Ansonsten:',

   "if you have an institutional log-in, use your institution's [_1]single sign on page[_2] to log-in, then create an account"
=> "Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, verwenden Sie Ihre institutionelle [_1]Single-Sign-On-Seite[_2], um sich anzumelden. Erzeugen Sie dann einen Account",

   'if you have an institutional login, [_1]create an account[_2]'
=> 'Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, [_1]erstellen Sie einen Account[_2]',

   'you can use an e-mail address to [_1]create an account[_2]'
=> 'Sie können eine E-Mail-Adresse verwenden, um [_1]einen Account zu erstellen[_2]',

   'Otherwise, if you have an institutional login, [_1]create an account[_2].'
=> 'Falls Sie einen Benutzeraccount Ihrer Einrichtung haben, [_1]erstellen Sie einen LON-CAPA-Account[_2].',

   'Otherwise, you will use an e-mail address to [_1]create an account[_2].'
=> 'Ansonsten verwenden Sie eine E-Mail-Adresse, um [_1]einen Account zu erstellen[_2].',

   "Otherwise, use your institution's [_1]single sign on page[_2] to log-in, then create an account."
=> "Ansonsten verwenden Sie Ihre institutionelle [_1]Single_Sign_On-Seite[_2], um sich anzumelden und erstellen Sie dann einen Account.",

   'You will be able to self enroll in this course once the account has been created.'
=> 'Sie haben die Möglichkeit sich selbst in den Kurs einzutragen, nachdem der Account erzeugt wurde.',

   'You will be able to self-enroll in the course you selected ([_1]) after you have successfully logged in.'
=> 'Sie haben die Möglichkeit sich selbst in den gewählten Kurs ([_1]) einzutragen, nachdem Sie sich erfolgreich angemeldet haben.',

   'You must [_1]log-in[_2] to LON-CAPA with an existing account to be able to enroll in this course, as account creation at this institution ([_3]) is not permitted when self-enrolling.'
=> 'Sie müssen sich in LON-CAPA mit einem bestehenden Account [_1]anmelden[_2], um sich in diesen Kurs eintragen zu können. Das Erstellen von Benutzeraccounts an dieser Einrichtung ([_3]) ist im Zuge der Selbsteintragung nicht gestattet.',

   'You already have an active student role (section: "[_1]") in this course.'
=> 'Sie haben in diesem Kurs bereits eine aktive studentische Rolle (Sektion "[_1]").',

   'You have a student role (section: "[_1]") in this course which will become active [_2].'
=> 'Sie haben in diesem Kurs (Sektion "[_1]") eine studentische Rolle, die am [_2] aktiv wird.',

   'Self-enrollment is restricted to officially registered students.'
=> 'Selbsteintragung ist auf offiziell registrierte Studenten beschränkt.',

   'As you are not currently registered for this course, self-enrollment is unavailable.'
=> 'Da Sie derzeit für diesen Kurs nicht registriert sind, ist die Selbsteintragung nicht verfügbar.',

   'The end date for access to this course for users who self-enroll has passed.'
=> 'Das Endedatum für den Zugriff auf diesen Kurs ist für Benutzer, die sich selbst eintragen können, abgelaufen.',

   'Consequently, although a new role was created for you in the course, it is an inactive role which does not provide access to the course.'
=> 'Das hat zur Folge, dass Ihre Benutzerrolle eine inaktive Rolle ist, die keinen Zugriff auf den Kurs gewährt, obwohl die Rolle für Sie in dem Kurs neu erstellt wurde.',

   'Self-enrollment in this course was successful.'
=> 'Die Selbsteintragung für diesem Kurs war erfolgreich.',

   'The start date for access to this course for users who self-enroll has yet to be reached.'
=> 'Das Anfangsdatum für den Zugriff auf diesen Kurs ist für Benutzer, die sich selbst eintragen können, noch nicht erreicht.',

   'Consequently, although a new role was created for you in the course, you will not be able to select this role until [_1].'
=> 'Das hat zur Folge, dass Sie diese Rolle nicht bis zum [_1] auswählen können, obwohl eine neue Rolle in diesem Kurs für Sie erstellt wurde.',

   'Your new role is available immediately, and will provide access to the course until [_1].'
=> 'Ihre neue Rolle is ab sofort verfügbar und erlaubt Ihnen bis [_1] Zugriff auf den Kurs.',

   'Enrollment process complete'
=> 'Kursbelegung abgeschlossen',

   'Enrollment incomplete'
=> 'Kursbelegung unvollständig',

   'Self-enrollment in this course failed.'
=> 'Die Selbsteintragung in diesen Kurs ist fehlgeschlagen.',

   'You are not permitted to enroll yourself in this course.'
=> 'Es ist Ihnen nicht gestattet, sich in diesen Kurs selbst einzutragen.',

   'Enter course now'
=> 'Kurs jetzt betreten',

   'other'
=> 'andere',

   'Self-enrollment in this course is available to any user affiliated with [_1].'
=> 'Die Selbsteintragung in diesen Kurs ist für beliebige Benutzer der Einrichtung "[_1]" verfügbar.',

   'Self-enrollment in this course is only available to users in affiliated with [_1] who have the following status: "[_2]".'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer der Einrichtung "[_1]" verfügbar, die folgenden Status haben: "[_2]".',

   'Self-enrollment is not currently available for this course for users affiliated with [_1].'
=> 'Die Selbsteintragung in diesen Kurs ist derzeit für Benutzer der Einrichtung "[_1]" nicht zulässig.',

   'Self-enrollment in this course is only available to users affiliated with the following institutions, and who have the required status:'
=> 'Die Selbsteintragung in diesen Kurs ist nur für Benutzer der folgenden Einrichtungen verfügbar, die den erforderlichen Status haben:',

   'Your registration status could not be verified.'
=> 'Ihr Registrierungsstatus konnte nicht überprüft werden.',

   'Your registration status could not determined, because a problem occurred retrieving data.'
=> 'Ihr Registrierungsstatus konnte nicht überprüft werden, da während des Datenabrufs ein Problem aufgetreten ist.',

   'As no institutional course sections are currently associated with this course, your registration status is undetermined.'
=> 'Da mit diesem Kurs keine institutionellen Kurssektionen verknüpft sind, ist Ihr Registrierungsstatus unbestimmt.',

   '[_1]Ad hoc[_2] roles in domain [_3] --'
=> '[_1]Ad-hoc[_2]-Rollen in der Domäne [_3] --',

   'Assemble resources'
=> '布置课程内容',

   'Create, edit, modify and publish resources'
=> 'Erstellen, Ändern und Veröffentlichen von Ressourcen',

   'Create, modify and delete course groups'
=> 'Erstellen, Ändern und Löschen von Kursgruppen',

   'View course groups'
=> '查看课程组',

   'View student activity'
=> 'Studentische Aktivitätsdaten anzeigen',

   'Show full details for each course ([_1] only)'
=> 'Alle Details für jeden Kurs zeigen (nur mit Benutzerrolle [_1] verfügbar)',

   'Include courses set to be hidden from catalog ([_1] only)'
=> 'Auch Kurse anzeigen, die im Kursüberblick als verborgen eingestellt sind (nur mit Benutzerrolle [_1] verfügbar)',

   'Include subcategories within "[_1]"'
=> '包含子类 "[_1]"',

   'Only show courses which allow self-enrollment'
=> '只显示允许自行登记的课程',

   'include subdirectories'
=> '包括子目录',

   'force republication of previously published files'
=> 'Erneute Veröffentlichung bereits zuvor veröffentlichter Ressourcen erzwingen',

   'make file(s) obsolete'
=> 'Ressourcen als überholt markieren',

   'force directory level catalog information over existing'
=> 'Kataloginformationen des Verzeichnisses sollen bestehende Kataloginformationen überschreiben',

   'Session could not be opened.'
=> 'Die Sitzung konnte nicht gestartet werden.',

   'The domain you provided is not a valid LON-CAPA domain.'
=> 'Die von Ihnen angegebene Domäne ist keine LON-CAPA-Domäne.',

   'Student Settings'
=> 'Studentische Einstellungen',

   'Coordinator Settings'
=> 'Koordinatoren-Einstellungen',

   'Author Settings'
=> 'Autoren-Einstellungen',

   'Administrator Settings'
=> 'Administratoren-Einstellungen',

   'Item'
=> 'Element',

   'Found [_1] without responses. This resource cannot be published.'
=> 'Ressource vom Typ [_1] gefunden, die keinen Antwortblock enthält. Diese Ressource kann nicht veröffentlicht werden.',

   'LON-CAPA helpdesk'
=> 'LON-CAPA-Helpdesk',

   'Create a user account in LON-CAPA'
=> 'Neuen Benutzeraccount in LON-CAPA erstellen',

   'Account creation unavailable'
=> 'Account-Erstellung nicht möglich',

   'Error creating token.'
=> 'Fehler beim Erstellen eines Merkzeichens.',

   'Account creation'
=> 'Account-Erstellung',

   'Creation of a new user account using an e-mail address or an institutional log-in ID as username is not permitted at this institution: ([_1]).'
=> 'Das Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzerkennung ist an der Einrichtung [_1] nicht gestattet.',

   'Creation of a new LON-CAPA user account using an e-mail address or an institutional log-in ID as your username is not permitted at [_1].'
=> 'Das Erstellen eines LON-CAPA-Benutzeraccounts mit einer E-Mail-Adresse oder einem Benutzeraccount Ihrer Einrichtung als Benutzerkennung ist an der Einrichtung [_1] nicht gestattet.',

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account in this domain."
=> "sie wurden zwar mit Ihrer Benutzerkennung und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Domäne.",

   "Although your username and password were authenticated by your institution's Single Sign On system, you do not currently have a LON-CAPA account at this institution, and you are not permitted to create one."
=> "Sie wurden zwar mit Ihrer Benutzerkennung und Passwort durch das institutionelle Single-Sign-On-System korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account an dieser Einrichtung und Sie sind nicht berechtigt, einen zu erstellen.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account at this institution."
=> "Sie wurden zwar mit Ihrer Benutzerkennung und Passwort korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Einrichtung.",

   "Although your username and password were authenticated, you do not currently have a LON-CAPA account in this domain, and you are not permitted to create one."
=> "Sie wurden zwar mit Ihrer Benutzerkennung und Passwort korrekt authentifiziert, besitzen derzeit allerdings keinen LON-CAPA-Account in dieser Domäne und Sie sind nicht berechtigt, einen zu erstellen.",

   'A LON-CAPA account may not be created with the username you use.'
=> 'Mit der von Ihnen verwendeten Benutzerkennung kann kein LON-CAPA-Account erzeugt werden.',

   'User Information'
=> 'Benutzerdaten',

   'User information'
=> 'Benutzerdaten',

   'Review user information'
=> 'Benutzerdaten bestätigen',

   'To create one, use the table below to provide information about yourself (if appropriate), then click the "Create LON-CAPA account" button.'
=> 'Um einen zu erstellen, verwenden Sie die untenstehende Tabelle, um Ihre persönliche Daten in die leeren Felder einzutragen. Klicken Sie anschließend auf "LON-CAPA-Account erstellen".',

   'To create one, use the table below to provide information about yourself, then click the [_1]Create LON-CAPA account[_2] button.'
=> 'Um einen zu erstellen, verwenden Sie die untenstehende Tabelle, um Ihre persönliche Daten in die leeren Felder einzutragen. Klicken Sie anschließend auf [_1]LON-CAPA-Account erstellen[_2].',

   'A user account will be created with information displayed in the table below, when you click the [_1]Create LON-CAPA account[_2] button.'
=> 'Durch Klicken auf [_1]LON-CAPA-Account erstellen[_2] wird mit den unten angezeigten Daten ein Benutzeraccount erzeugt.',

   'Confirmation'
=> 'Bestätigung',

   'Confirm that you wish to create an account.'
=> 'Bitte bestätigen Sie, dass Sie einen Account erzeugen möchten.',

   'New username'
=> 'Neue Benutzerkennung',

   'Create account'
=> 'Account anlegen',

   'You must enter a password'
=> 'Sie müssen ein Passwort angeben.',

   'The passwords you entered did not match.'
=> 'Die eingegebenen Passwörter stimmen nicht überein.',

   'Create account with a username provided by this institution'
=> 'Erstellen eines LON-CAPA-Accounts mit einem Benutzeraccount dieser Einrichtung',

   'If you already have a log-in ID at this institution,[_1] you may be able to use it for LON-CAPA.'
=> 'Falls Sie bereits einen Benutzeraccount dieser Einrichtung haben,[_1] können Sie diesen gegebenenfalls für LON-CAPA verwenden.',

   'Type in your log-in ID and password to find out.'
=> 'Geben Sie Ihren Benutzeraccount Ihrer Einrichtung und Ihr Passwort ein, um dies herauszufinden.',

   'Log-in ID'
=> 'Benutzeraccount Ihrer Einrichtung',

   'Create account with an e-mail address as your username'
=> 'Erstellen eines Benutzeraccounts mit einer E-Mail-Adresse als Benutzerkennung',

   'Provide your e-mail address to request a LON-CAPA account,[_1] if you do not have a log-in ID at your institution.'
=> 'Geben Sie Ihre E-Mail-Adresse an, um einen LON-CAPA-Account zu beantragen,[_1] falls Sie keinen Benutzeraccount Ihrer Einrichtung haben.',

   'Request LON-CAPA account'
=> 'LON-CAPA-Account anfordern',

   'Validation'
=> 'Gültigkeitsprüfung',

   'Thank you for your request to create a new LON-CAPA account.'
=> 'Vielen Dank für Ihren Antrag zur Erstellung eines neuen LON-CAPA-Accounts.',

   'A request was submitted on [_1] for creation of a LON-CAPA account at the following institution:[_2].'
=> 'Ein Antrag zur Erstellung eines LON-CAPA-Accounts wurde am [_1] für die Einrichtung [_2] abgeschickt.',

   'To complete this process please open a web browser and enter the following URL in the address/location box: [_1]'
=> 'Um den Vorgang abzuschließen, öffnen Sie bitte einen Webbrowser und geben Sie folgende URL in die Adresszeile ein: [_1]',

   'A message has been sent to the e-mail address you provided.'
=> 'An die von Ihnen angegebene E-Mail-Adresse wurde eine Nachricht geschickt.',

   'The message includes the web address for the link you will use to complete the account creation process.'
=> 'Die Nachricht enthält einen Link, mit dem Sie den Erstellungsvorgang Ihres Accounts abschließen können.',

   'The link included in the message will be valid for the next [_1]two[_2] hours.'
=> 'Der in die Nachricht eingebundene Link ist für die nächsten [_1]zwei Stunden gültig[_2].',

   'An error occurred when sending a message to the e-mail address you provided.'
=> 'Beim Verschicken Ihrer Nachricht an die von Ihnen angegebene E-Mail-Adresse ist ein Fehler aufgetreten.',

   'An error occurred creating a token required for the account creation process.'
=> 'Beim Erstellen eines Merkzeichens, das für den Erstellungsvorgang des Accounts notwendig ist, ist ein Fehler aufgetreten.',

   'Please contact the [_1] ([_2]) for assistance.'
=> 'Nehmen Sie zur Klärung bitte mit [_1] ([_2]) Kontakt auf.',

   'Sorry, the URL you provided to complete creation of a new LON-CAPA account was invalid. Either the token included in the URL has been deleted or the URL you provided was invalid.'
=> 'Die von Ihnen angegebene URL, um den Erstellungsvorgang eines neuen LON-CAPA-Accounts abzuschließen, ist ungültig. Entweder wurde das in der URL enthaltene Merkzeichen gelöscht oder die von Ihnen angegebene URL ist ungültig.',

   'Sorry, the token generated when you requested creation of an account has expired.'
=> 'Das Merkzeichen, das bei Ihrem Antrag zur Erstellung des Accounts generiert wurde, ist nicht mehr gültig.',

   'Sorry, the URL generated when you requested creation of an account contained incomplete information.'
=> 'Die URL, die bei Ihrem Antrag zur Erstellung des Accounts generiert wurde, enthält unvollständige Daten.',

   'Please submit a [_1]new request[_2] for account creation and follow the new link included in the e-mail that will be sent to you.'
=> 'Bitte stellen Sie einen [_1]erneuten Antrag[_2] zur Erstellung eines Accounts und folgen Sie dem neuen Link, der Ihnen per E-Mail zugesandt werden wird.',

   'A LON-CAPA account for the institution: [_1] has been created [_2] from IP address: [_3].  If you did not perform this action or authorize it, please contact the [_4] ([_5]).'
=> 'Am [_2] wurde für die Einrichtung [_1] von der IP-Adresse [_3] ein LON-CAPA-Account erzeugt. Falls Sie diese Anforderung nicht ausgeführt oder beauftragt hatten, nehmen Sie bitte mit [_4] ([_5]) Kontakt auf.',

   'A LON-CAPA account already exists for username [_1] at this institution ([_2]).'
=> 'Für den Benutzer [_1] existiert bereits ein LON-CAPA-Account an der Einrichtung [_2].',

   'The password entered was also correct so you have been logged in.'
=> 'Das von Ihnen eingegebene Passwort war korrekt, so dass Sie angemeldet wurden.',

   'Authentication failed'
=> 'Authentifizierung fehlgeschlagen',

   'An e-mail confirming creation of your new LON-CAPA account has been sent to [_1].'
=> 'Eine E-Mail zur Bestätigung der Erstellung Ihres neuen LON-CAPA-Accounts wurde an [_1] gesendet.',

   'An error occurred when sending e-mail to [_1] confirming creation of your LON-CAPA account.'
=> 'Beim Versenden der E-Mail zur Bestätigung der Erstellung Ihres neuen LON-CAPA-Accounts ist ein Fehler aufgetreten.',

   'A problem occurred when attempting to create your new LON-CAPA account.'
=> 'Beim Erstellen Ihres neuen LON-CAPA-Accounts ist ein Fehler aufgetreten.',

   'Please provide user information and a password for your new account.'
=> 'Bitte geben Sie Ihre Benutzerdaten und ein Passwort für Ihren neuen Account ein.',

   'Your password, which must contain at least seven characters, will be sent to the LON-CAPA server in an encrypted form.'
=> 'Ihr Passwort, das aus mindestens sieben Zeichen bestehen muss, wird in verschlüsselter Form an den LON-CAPA-Server geschickt.',

   'Create LON-CAPA account'
=> 'LON-CAPA-Account erstellen',

   'Could not load javascript file [_1]'
=> 'Konnte die Javascriptdatei [_1] nicht laden.',

   'Invalid ID format'
=> 'Ungültiges ID-Format',

   'An error occurred when storing a token'
=> 'Beim Speichern eines Merkzeichens ist ein Fehler aufgetreten.',

   'You will not be able to proceed to the next stage of account creation'
=> 'Sie werden den nächsten Schritt zum Erstellen eines Accounts nicht ausführen können.',

   'A LON-CAPA account has been created for username: [_1] in domain: [_2].'
=> 'Für den Benutzer [_1] in der Domäne [_2] wurde ein LON-CAPA-Account erstellt.',

   'Account creation failed for username: [_1] in domain: [_2].'
=> 'Das Erstellen eines LON-CAPA-Accounts für den Benutzer [_1] in der Domäne [_2] ist fehlgeschlafen.',

   'User account creation is not available for the current default authentication type.'
=> 'Für die momentan voreingestellte Authentifizierungsmethode ist das Erstellen von Benutzeraccounts nicht verfügbar.',

   'The e-mail address you provided is already in use as a username at this institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse wird in dieser LON-CAPA-Domäne als Benutzerkennung bereits verwendet.',

   'Username rules at this institution do not allow the e-mail address you provided to be used as a username.'
=> 'Die für diese Einrichtung eingestellten Regeln für Benutzerkennungen gestatten es nicht, die von Ihnen angegebene E-Mail-Adresse als Benutzerkennung zu verwenden.',

   'The e-mail address you provided may not be used as a username at this LON-CAPA institution.'
=> 'Die von Ihnen angegebene E-Mail-Adresse kann in dieser Einrichtung nicht als Benutzerkennung verwendet werden.',

   'Validation of the code your entered failed.'
=> 'Die Gültigskeitsprüfung des von Ihnen eingegebenen Codes ist fehlgeschlagen.',

   'Creation of a new user account using an e-mail address as username is not permitted at this LON-CAPA institution.'
=> 'Das Erstellen von neuen Benutzeraccounts mit einer E-Mail-Adresse als Benutzerkennung ist für diese Einrichtung nicht gestattet.',

   'Type in the letters/numbers shown below'
=> 'Geben Sie die unten angezeigten Buchstaben/Zahlen ein',

   'You may need to reload the previous page to obtain a new token.'
=> 'Sie können die vorherige Seite neu laden, um ein neues Merkzeichen zu erhalten.',

   'Unable to retrieve your log-in information - unexpected context'
=> 'Die Anmeldedaten konnten nicht erfolgreich abgerufen werden - unerwarteter Kontext',

   "Your e-mail address uses the same internet domain as your institution's LON-CAPA service."
=> "Ihre E-Mail-Adresse verwendet die gleiche Internetdomäne wie die Domäne des LON-CAPA-Systems Ihrer Institution.",

   'Creation of a LON-CAPA account with this type of e-mail address as username is not permitted.'
=> 'Das Erstellen eines LON-CAPA-Accounts mit dieser Art von E-Mail-Adressen als Benutzerkennung ist nicht zulässig.',

   'You should request creation of a LON-CAPA account for a log-in ID of "[_1]" at your institution instead.'
=> 'Stattdessen sollten Sie die Erstellung eines LON-CAPA-Accounts für Ihren Benutzeraccount "[_1]" an Ihrer Einrichtung beantragen.',

   'Changes/page:'
=> '每页显示列数：',

   'Window during which changes occurred:'
=> '在这个时期发生的变化：',

   'This page is either empty or it only contains resources that are currently hidden'
=> 'Diese Seite ist entweder leer oder enthält derzeit nur verborgene Ressourcen',

   'Please use the LON-CAPA navigation arrows to move to another item in the course'
=> 'Bitte verwenden Sie die LON-CAPA-Navigationspfeile, um zu anderen Ressourcen zu gelangen.',

   'Unable to modify requested student ([_1])'
=> 'Die Daten des angeforderten Studenten ([_1]) konnten nicht geändert werden.',

   'Unable to grade requested sequence ([_1]).'
=> 'Die angeforderte Sequenz ([_1]) konnte nicht bewertet werden.',

   'No score was changed or updated.'
=> 'An den Punkten wurde keine Änderung vorgenommen.',

   'The scores were changed for [quant,_1,problem].'
=> 'Für [quant,_1,Aufgabe wurde,Aufgaben wurden] die Punkte geändert.',

   '[_1]Visit the [_2]Course Catalog[_3] to view all [_4] LON-CAPA courses.' # _1: <b>, _2: <a>, _3: </a> </b>, _4: domain
=> '[_1]访问[_2]课程目录[_3], 来查看 [_4] LON-CAPA 的所有课程。',


   'If a course is [_1]not[_2] in your list of current courses below, you may be able to enroll if self-enrollment is permitted.'
=> '如果一个课程在下面列出您目前的课程中[_1]没有[_2]显示，你可以注册，如果自我注册是允许的。',

#SD begin 2008-07-02
   'When'
=> '什么时候',

   'Who made the change'
=> '谁进行了修改',

   'Changed User'
=> '改变用户',

   'Context'
=> '概述',

   'Context:'
=> '概述：',

   'After:'
=> '之后：',

   'Before:'
=> '之前：',

   'User Changes'
=> '用户更改',

   'For this user, the default quota would be [_1]'
=> '此使用者的默认的配额为[_1]',

   'Search for a user and enroll as a student'
=> '搜索用户并注册为学生',

   'username is known'
=> 'Benutzerkennung ist bekannt',

   'Create a new user'
=> '创建一个新用户',

   'Enroll'
=> '注册',

   'User Search to enroll student'
=> 'Benutzersuche, um Studierende einzutragen',

   'Select a user to enroll as a student'
=> 'Wählen Sie einen Benutzer zum Eintragen als Studierenden aus',

   'modify' #Kontext? breadcrumb_text
=> 'modifizieren',

#   'userpicked' #Kontext?
#=> '',

   'as a student'
=> '作为一名学生',

   'Set section/dates'
=> '设置章节/日期',

   'Unknown'
=> 'unbekannt',

   'You do not have privileges to assign co-author roles.'
=> 'Sie haben keine Berechtigung, um Co-Autor Rollen zuzuweisen',

   'This user has an unrecognized authentication scheme'
=> 'Dieser Benutzer hat ein unbekanntes Authentifizierungsschema',

   'Please alert a domain coordinator of this situation'
=> 'Bitte benachrichtigen Sie einen Domänen-Koordinator über diese Situation',

   'Please specify login data below'
=> 'Bitte spezifizieren Sie Login-Daten',

   'No domain specified'
=> 'Keine Domäne spezifiziert',

   'Invalid domain name'
=> 'Ungültiger Domänenname',

   'Only letters, numbers, periods, dashes, and underscores are valid'
=> 'Es sind nur erlaubt: Buchstaben, Ziffern, ".", "-", "_"',

   'You do not have the authority to modify this users authentification information'
=> 'Sie haben nicht die Berechtigung, um die Authentifizierungsinformationen dieses Benutzers zu modifizieren',

   'New Student/Employee ID does not match existing ID for this user.'
=> 'Die neue Studenten-/Mitarbeiter-ID stimmt nicht mit der bestehenden ID dieses Benutzers überein.',

   "Change is not permitted without checking the 'Force ID change' checkbox on the previous page."
=> "Ohne Auswahl der 'Erzwinge-ID-Änderung'-Checkbox auf der vorherigen Seite ist eine Änderung nicht erlaubt.",

   'Unable to successfully change environment for'
=> 'Es ist nicht möglich, die Umgebung zu ändern für',

   'No roles'
=> 'Keine Rollen',

   'The following fields were not updated: '
=> 'Die folgenden Felder wurden nicht aktualisiert: ',

   "You do not have the authority to change this field given the user's current set of active/future [_1] roles:"
=> 'Sie haben nicht die Berechtigung, um dieses Feld angesichts der aktuellen aktiven/zukünftigen [_1] Rollen des Benutzer zu ändern:',

   "You do not have the authority to change these fields given the user's current set of active/future [_1] roles:"
=> 'Sie haben nicht die Berechtigung, um diese Felder angesichts der aktuellen aktiven/zukünftigen [_1] Rollen des Benutzers zu ändern:',

   'Please contact your [_1]helpdesk[_2] for more information.'
=> 'Bitte kontaktieren Sie das [_1]Helpdesk[_2] für weitere Informationen.',

   '<b>[_1]</b> enrolled'
=> '<b>[_1]</b> 注册的',

   'in section [_1]'
=> 'in Sektion [_1]',

   'Access starts immediately'
=> '访问立即开始',

   'Access starts: '
=> '访问开始： ',

   'ends: no ending date'
=> '结束：没有结束日期',

   'ends: '
=> '结束： ',

   'If the student is currently logged-in to LON-CAPA, the new role will be available when the student next logs in.'
=> 'Falls der Studierende gerade an LON-CAPA angemeldet ist, wird die Rolle nach dem nächsten Anmelden des Studierenden verfügbar sein.  ',

   '(default)'
=> '(默认的)',

   '(default for [_1])'
=> '(默认 [_1])',

   'You are not authorized to make bulk changes to user roles'
=> 'Sie sind nicht authorisiert Massenänderungen an Benutzerrollen durchzuführen',

   'You do not have permission to modify dates or sections for users'
=> 'Sie haben keine Berechtigung, um Daten oder Sektionen für Benutzer zu modifizieren',

   'deleted'
=> 'gelöscht',

   'No start date'
=> '没有开始日期',

   'Previous [_1] changes'
=> 'Vorherige [_1] Änderungen',

   'Next [_1] changes'
=> 'Nächste [_1] Änderungen',

   'There are no records to display.'
=> '没有记录显示。',

   'There are no transactions to display.'
=> 'Es gibt keine Transaktionen, die angezeigt werden können.',

   'Automated enrollment'
=> '自动注册',

   'Roster Update'
=> '名册更新',

   'Course Creation'
=> '创建课程',

   'User Management in course'
=> '在课程中的用户管理',

   'User Management in domain'
=> '在域中的用户管理',

   'Self-enrolled'
=> '自助注册',

   'Your search term must contain more than just spaces.'
=> 'Ihre Suchanfrage muss mehr als nur Leerzeichen enthalten.',

   'this course'
=> '本课程',

   'LON-CAPA domain: '
=> 'LON-CAPA 域',

   'the institutional directory for domain: '
=> 'das institutionelle Verzeichnis für die Domäne: ',

   'Please contact the [_1]helpdesk[_2] if you need to create a new user.'
=> 'Bitte kontaktieren Sie das [_1]Helpdesk[_2], falls Sie einen neuen Benutzer erstellen möchten.',

   'Section for self-enrolled users unchanged as the proposed section is a group'
=> 'Sektion für selbst eingetragene Benutzer nicht geändert, da die vorgeschlagene Sektion eine Gruppe ist',

   'Group names and section names must be distinct'
=> '组名称和章节的名称必须是不同的',

   'Section for self-enrolled users unchanged, as "all" is a reserved section name.'
=> 'Sektion für selbst eingetragene Benutzer nicht geändert, da "all" ein system-intern reservierter Sektionsname ist.',

   'An error occurred when saving changes to self-enrollment settings in this course.'
=> 'Ein Fehler trat während des Speicherns der Änderungen an den Selbsteintragungs-Einstellungen in diesem Kurs auf.',

#SD end 2008-07-02

   '[_1] at [_2]'
=> '[_1] 在 [_2]',

   '[_1]: [_2]'
=> '[_1]: [_2]',

   'Server Switch Required'
=> 'Serverwechsel erforderlich',

   'Construction Space access is only available from the home server of the corresponding Author.'
=> 'Der Konstruktionsbereich ist nur vom Heimatserver des zugehörigen Autors verfügbar.',

   "Click the 'Switch Server' link to go there."
=> "Klicken Sie auf 'Server wechseln', um dort hinzugelangen.",

   'Default in use:'
=> '默认情况下使用：',

   'Self-creation of account by users with status: [_1]  '
=> 'Selbsterstellung eines Accounts durch Benutzer mit Status [_1]  ',

   'modifiable fields (if institutional data blank): '
=> 'änderbare Felder (falls Daten der Einrichtung leer sind): ',

# domainprefs.pm
#   'Formats disallowed for $text{$type}: '
#=> 'Formats disallowed for $text{$type}: ',
#
#   'Format rules to check for $text{$type}: '
#=> 'Format rules to check for $text{$type}: ',

# loncommon.pm
#   "You must either choose $text{'action'} with a different format --  $text{'one'} that will not conflict with 'official' institutional $text{'items'}, or leave the ID field blank."
# => "You must either choose $text{'action'} with a different format --  $text{'one'} that will not conflict with 'official' institutional $text{'items'}, or leave the ID field blank."

   'Source Code'
=> 'Quellcode',

   'Copy Problem Source Code to Construction Space'
=> 'Aufgaben-Quellcode in Konstruktionsbereich kopieren',

   'Please enter the directory that you would like the source code to go into.'
=> 'Bitte geben Sie das Verzeichnis ein, in das der Quellcode kopiert werden soll.',

   'Note: the path is in reference to the root of your construction space, and new directories will be automatically created.'
=> 'Beachten Sie, dass sich der Pfad auf das Heimatverzeichnis Ihres Konstruktionsbereichs bezieht. Noch nicht existierende Verzeichnisse werden automatisch angelegt.',

   'shared_source'
=> 'gemeinsame_Dokumente',

   'Copy to Construction Space'
=> 'In Konstruktionsbereich kopieren',

   '[_1]W[_2]ARNING' # Highlight first char
=> '[_1]W[_2]ARNUNG',

   'At end of file some tags were still left unclosed:'
=> 'Am Ende der Datei sind manche Tags noch nicht geschlossen:',

   'Unable to save file [_1]'
=> 'Die folgende Datei konnte nicht gespeichert werden: [_1]',

   'Warnings and Errors'
=> 'Warnungen und Fehler',

   'Edit Math'
=> 'Formeleditor',

   'DragMath Latex Equation Editor'
=> 'DragMath-LaTeX-Formel-Editor', # n.t.

   '[_1]Return[_2] to editing resource.'
=> '[_1]Zurück[_2] zur Ressource',

   'Counting pages for student: [_1]'
=> 'Zähle Seiten für Student [_1]',

   'LaTeX could not successfully parse your tex file.'
=> 'LaTeX konnte Ihre TeX-Datei nicht erfolgreich parsen.',

   'It probably has errors in it.'
=> 'Sie enthält vermutlich Fehler.',

   'Here are the error messages in the LaTeX log file:'
=> 'Die Fehlermeldungen der LaTeX-Logdatei:',

   'There are errors in [_1].'
=> 'Es sind Fehler aufgetreten. Ort: [_1]',

   'There are errors.'
=> 'Es sind Fehler aufgetreten.',

   'These errors prevent this resource from printing correctly.'
=> 'Diese Fehler verhindern, dass diese Ressource korrekt gedruckt werden kann.',

   'A message has been sent to the instructor describing this failure.'
=> 'Dem Dozenten wurde eine Nachricht gesendet, die eine Beschreibung des Fehlverhaltens enthält.',

   'You are running LaTeX in [_1]batch mode[_2].'
=> 'Sie verwenden LaTeX im [_1]Stapelverarbeitungsbetrieb[_2] (batch mode).',

   'It has found an error in [_1][_2]and corrected it.'
=> 'Es wurde ein Fehler in [_1] gefunden[_2]und korrigiert.',

   'Usually this correction is valid but you probably need to check the indicated resource one more time and implement neccessary corrections by yourself.'
=> 'Üblicherweise ist diese Korrektur gültig, allerdings sollten Sie dennoch die angezeigte Ressource überprüfen ',

   'The link to [_1]Your log file[_2]'
=> 'Link zur [_1]Logdatei[_2]',

   'The link to [_1]Your original LaTeX file[_2]'
=> 'Link zur [_1]Original-LaTeX-Datei[_2]',

   'bomb'
=> 'Bombe',

   'Output Tags'
=> 'Tags zur Ausgabe',

   'WARNING: Cannot connect to database!'
=> '警告：无法连接到数据库！',

   'Error occurred saving new values in metadata table in LON-CAPA database!'
=> '保存新值数据表到LON-CAPA数据库中时发生错误！',

   'Your course currently appears in the Course Catalog for this domain.'
=> '您的课程目前出现在此域的课程目录中。',

   'Courses can be both self-cataloging, based on an institutional code (e.g., fs08phy231), or can be assigned categories from a hierarchy defined for the domain.'
=> '课程可自我编目的基础的研究所代码（例如， fbi_ws20082009_linalg ）或可通过域的定义分配类别界定。',

   'Your course does not currently appear in the Course Catalog for this domain.'
=> '您的课程目前没有出现在此域的课程目录中。',

   'You should remedy this if you plan to allow self-enrollment, otherwise students will have difficulty finding your course.'
=> 'Sie sollten dies ändern, falls Sie Selbsteintragung für diesen Kurs anbieten möchten, da Studenten sonst Schwierigkeiten haben werden, Ihren Kurs zu finden.',

   'Courses can be absent from the Catalog, because they do not have an institutional code, have no assigned category, or have been specifically excluded.'
=> 'Gründe für das Fehlen der Auflistung von Kursen in der Kursübersicht können sein, dass die Kurse keinen institutionellen Code haben, ihnen keine Kategorie zugewiesen wurde oder mit Absicht aus der Auflistung ausgeschlossen wurden.',

   'Make any changes to self-enrollment settings below, click "Save changes", then take action to include the course in the Catalog:'
=> 'Nehmen Sie unten Änderungen an der Selbsteintragung vor, klicken Sie auf "Änderungen speichern" und sorgen Sie anschließend dafür, dass der Kurs in die Kursübersicht aufgenommen wird:',

   'Take the following action to ensure the course appears in the Catalog:'
=> 'Führen Sie folgende Schritte aus, damit der Kurs in der Kursübersicht aufgelistet wird:',

   'Ask a domain coordinator to change the "Exclude from course catalog" setting.'
=> 'Bitten Sie einen Domänen-Koordinator, die Einstellung "Kurs aus Kursübersicht ausschließen" zu ändern.',

   'Ask a domain coordinator to enable display the catalog of "Official courses (with institutional codes)".'
=> 'Bitten Sie einen Domänen-Koordinator, die Anzeige der Kursübersicht "Offizielle Kurse (mit institutionellen Codes)" zu aktivieren.',

   'Ask a domain coordinator to assign an institutional code (if this is an official course).'
=> 'Bitten Sie einen Domänen-Koordinator, einen institutionellen Code zuzuweisen (falls es sich um einen offiziellen Kurs handelt).',

   'Ask a domain coordinator to enable or create at least one course category in the domain.'
=> 'Bitten Sie einen Domänen-Koordinator, in der Domäne mindestens eine Kurskategorie anzulegen.',

   'Ask a domain coordinator to create a hierarchy of categories and sub categories for courses in the domain.'
=> 'Bitten Sie einen Domänen-Koordinator, für Kurse in der Domäne eine Hierarchie von Kategorien und Unterkategorien anzulegen.',

   'Ask a domain coordinator to change the category assigned to the course, as the one currently assigned is no longer used in the domain'
=> 'Bitten Sie einen Domänen-Koordinator, die diesem Kurs zugewiesene Kategorie zu abzuändern, da die derzeit zugewiesene in der Domäne nicht mehr verwendet wird.',

   'Ask a domain coordinator to assign a category to the course.'
=> 'Bitten Sie einen Domänen-Koordinator, dem Kurs eine Kategorie zuzuweisen.',

   'Use [_1]Set course environment[_2] to change the "Exclude from course catalog" setting.'
=> 'Gehen Sie zum Menüpunkt [_1]Kursumgebung[_2], um die Einstellung "Kurs aus Kursübersicht ausschließen" zu ändern.',

   'Use [_1]Set course environment[_2] to change the category assigned to the course, as the one currently assigned is no longer used in the domain.'
=> 'Gehen Sie zum Menüpunkt [_1]Kursumgebung[_2], um die diesem Kurs zugewiesene Kategorie zu abzuändern, da die derzeit zugewiesene in der Domäne nicht mehr verwendet wird.',

   'Use [_1]Set course environment[_2] to assign a category to the course.'
=> 'Gehen Sie zum Menüpunkt [_1]Kursumgebung[_2], um dem Kurs eine Kategorie zuzuweisen.',

   'You are able to both assign a course category and choose to exclude this course from the catalog.'
=> 'Sie können dem Kurs eine Kurskategorie zuweisen und den Kurs aus der Kursübersicht ausschließen.',

   'You are able to choose to exclude this course from the catalog, but only a Domain Coordinator may assign a course category.'
=> 'Sie können den Kurs aus der Kursübersicht ausschließen, aber nur ein Domänen-Koordinator darf dem Kurs eine Kurskategorie zuweisen.',

   'You may assign a course category, but only a Domain Coordinator may choose to exclude this course from the catalog.'
=> 'Sie können dem Kurs eine Kurskategorie zuweisen, aber nur ein Domänen-Koordinator darf den Kurs aus der Kursübersicht ausschließen.',

   'Only a Domain Coordinator may assign a course category or choose to exclude this course from the catalog.'
=> 'Nur ein Domänen-Koordinator darf dem Kurs eine Kurskategorie zuweisen und den Kurs aus der Kursübersicht ausschließen.',

   "Please use the 'Select Course' link to open a separate pick course window where you may select the course you wish to enter"
=> "Bitte verwenden Sie den 'Kurs auswählen'-Link, um ein extra Fenster zu öffnen, das Ihnen die Möglichkeit bietet, einen Kurs auszuwählen, den Sie betreten möchten.",

   'You can only use this screen to select courses in the current domain.'
=> 'Sie können diesen Bildschirm nur verwenden, um Kurse der derzeitigen Domäne auszuwählen.',

   '[_1]Your Excel spreadsheet[_2] is ready for download.'
=> '[_1]Ihre Exceldatei[_2] steht zum Download bereit.',

   '[_1]Your CSV file[_2] is ready for download.'
=> '[_1]Ihre CSV-Datei[_2] steht zum Download bereit.',

   'Name (username)'
=> 'Name (Benutzerkennung)',

   'Grades Assigned'
=> 'Zugewiesene Bewertungen',

   'Comments'
=> '注释',

   'No Course Data'
=> 'Keine Kursdaten vorhanden',

   'Error getting student data ([_1])'
=> 'Fehler beim Abrufen der studentischen Daten ([_1])',

   'Score'
=> 'Punkte',

   'Display Options'
=> '显示选项',

   'This role has section(s) associated with it.'
=> 'Mit dieser Rolle sind Sektionen verknüpft.',

   'Enter a specific section.'
=> 'Geben Sie eine bestimmte Sektion ein.',

   'Enter a specific section, or leave blank for no section.'
=> 'Geben Sie eine bestimmte Sektion ein oder lassen Sie das Feld frei für keine Sektion.',

   'Available sections are:'
=> 'Verfügbare Sektionen sind:',

   'You entered an invalid section choice:'
=> 'Sie haben einen ungültige Sektion eingegeben:',

   'You may wish to contact the [_1]LON-CAPA helpdesk[_2] for the [_3] domain.'
=> '您不妨联系[_2][_3]域的[_1] LON-CAPA 求助。',

   '([_1] time zone)'
=> '(时区 [_1])',

   'Selecting an Author'
=> 'Auswahl eines Autors',

   'Invalid domain'
=> '无效域',

   'There are no library servers containing Construction spaces currently in domain: [_1], so you can not assume a co-author role.'
=> 'In der Domäne [_1] existieren keine Library-Server mit Konstruktionsbereichen. Somit können Sie auch keine Co-Autoren-Rolle annehmen.',

   'You do not have a domain coordinator role in domain: [_1], so you cannot choose a Construction space for which you can assume a co-author role.'
=> 'In der Domäne [_1] haben Sie keine Domänen-Koordinatoren-Rolle. Somit können Sie auch keinen Konstruktionsbereich wählen, für den Sie eine Co-Autoren-Rolle annehmen könnten.',

   'You do not have a domain coordinator role, so you cannot choose a Construction space for which you can assume a co-author role.'
=> 'Sie habe keine Domänen-Koordinatoren-Rolle. Somit können Sie auch keinen Konstruktionsbereich wählen, für den Sie eine Co-Autoren-Rolle annehmen könnten.',

   'There are no author roles currently in domain: [_1], so there are no Construction spaces for which you can assume a co-author role.'
=> 'In der Domäne [_1] gibt es derzeit keine Autoren-Rollen. Somit können Sie auch keinen Konstruktionsbereich wählen, für den Sie eine Co-Autoren-Rolle annehmen könnten.',

   'As your session file for the course has expired, you will need to re-select the course.'
=> '当您的课程已过期，您将需要重新选择课程。',

   '[quant,_1,yr]'
=> '[quant,_1,Jahr,Jahre]',

   '[quant,_1,mth]'
=> '[quant,_1,Mon.,Mon.]',

   '[quant,_1,hr]'
=> '[quant,_1,h,h]',

   '[quant,_1,min]'
=> '[quant,_1,min,min]',

   '[quant,_1,sec]'
=> '[quant,_1,s,s]',

   'Loading student data...'
=> '检索学生数据...',

   'Options'
=> '选项',

   'Time Period'
=> '周期',

   'Rsource is undefined.'
=> 'Ressource ist nicht definiert.',

   'Plot Graph'
=> 'Graph plotten',

   'Download'
=> '下载',

   'PDF File'
=> 'PDF 文档',

   'Zip File'
=> 'ZIP 文档',

   'File Size (Bytes)'
=> '文件大小 (Bytes)',

   'Contents'
=> '内容',

   'Problem Type'
=> '问题类型',

   'not in this course'
=> 'nicht in diesem Kurs',
#Start: redesigned menus
#lonparmset.pm

   'Edit environment settings for this course.'
=> 'Einstellungen der Kursumgebung ändern.',

   'Portfolio Metadata'
=> '元数据-组合',

   'Settings for this Course'
=> '设置这门课程',

   'New and Existing Parameter Settings for Resources'
=> '新的和现有资源的参数设置',

   'Edit Resource Parameters - Helper Mode'
=> '编辑源参数 - 辅助模式',

   'Edit Resource Parameters - Overview Mode'
=> '编辑资源参数 - 概况模式',

   'Edit Resource Parameters - Table Mode'
=> '编辑资源参数 - 表模式',

   'Existing Parameter Settings for Resources'
=> '现有资源的参数设置',

   'Change Log'
=> '变更记录',

   'Restrict metadata for this course.'
=> 'Metadaten für diesen Kurs einschränken.',

   'Manage slots for this course.'
=> 'Slots für diesen Kurs vewalten.',

   'Reset access times for folders/maps, resources or the course.'
=> 'Zugriffszeiten für Verzeichnisse, Ressou-rcen oder den Kurs zurücksetzen.',

   'Set default actions for parameters.'
=> 'Standardaktionen für Parameter festlegen.',

   'Set/Modify resource parameters in helper mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Hilfsmodus.',

   'Set/Modify resource parameters in table mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Tabellenmodus.',

   'Set/Modify resource parameters in overview mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Übersichtsmodus.',

   'Set/Modify existing resource parameters in overview mode.'
=> 'Festlegen/Ändern von Parametern zur Kursbeurteilung im Übersichtsmodus.',

   'View parameter and course blog posting/user notification change log.'
=> 'Anzeigen des Änderungsprotokolls.',
#lonpreferences.pm

   'Screen Name'
=> '昵称',

   'Screenname'
=> '昵称',

   'Nickname'
=> '昵称',

   'Messages &amp; Notifications'
=> '邮件＆公告',

   'Message Management'
=> '邮件管理',

   'Discussion Display'
=> '讨论显示',

   'Page Display Settings'
=> '页面显示设置',

   'Color Scheme'
=> '颜色方案',

   'Menu Display'
=> '菜单显示',

   'Content Display Settings'
=> '内容显示设置',

   'WYSIWYG Editor'
=> 'WYSIWYG-编辑器',

   'Roles Page'
=> '角色页面',

   'Display of Scientific Equations'
=> '显示科学公式',

   'Edit information about yourself that should be displayed on your public profile.'
=> 'Informationen festlegen, die in ihrem öffentlichen Profil darstellt werden sollen.',

   'Change the name that is displayed in your posts.'
=> '变更在您的讨论中的名称。',

   'Change LON-CAPA default colors.'
=> 'Standardfarben für LON-CAPA festlegen.',

   'Change messageforwarding or notifications settings.'
=> 'Konfiguration der Nachrichtenweiterleitung und Benachrichtigungseinstellungen.',

   'Choose the default language for this user.'
=> 'Ändern der voreingestellten Benutzersprache für diesen Benutzer.',

   'Enable or disable the WYSIWYG-Editor.'
=> 'Aktivieren bzw. Deaktivieren des What-You-See-Is-What-You-Get-Editors.',

   'Configure the roles hotlist.'
=> 'Konfiguration der Rollen-Schnellzugriffsliste.',

   'Change how Scientific Equations are displayed.'
=> '改变如何显示科学方程。',

   'Register your clicker.'
=> '登记您的应答设备 (遥控).',

   'Change your password.'
=> '更改您的密码。',

   'Launch the remote control for LON-CAPA.'
=> 'Fernbedienung für LON-CAPA aktivieren.',

   'Collapse the remote control for LON-CAPA.'
=> 'Fernbedienung für LON-CAPA deaktivieren.',

   'Restrict domain coordinator access.'
=> 'Domänenkoordinatorzugriff beschränken.',

   'Set the default page to be displayed when you select a course role.'
=> 'Ändern der voreingestellten Seite, die nach Auswahl eines Kurses angezeigt wird.',

   'Toggle Debug Messages.'
=> 'Umschalten der Debug-Meldungen',

   'Change whether the menus are displayed with buttons, icons or icons and text.'
=> 'Festlegen, ob Menüs mit Buttons, Icons oder Icons und Text dargestellt werden sollen.',
   'Course Initialization'
=> '课程初始化',
#loncreateuser.pm
   'Single Users'
=> '单用户',

   'Upload a CSV or a text file containing users.'
=> '课程参加者上传CSV或文本文件。',

   'Add a user with a certain role to this course.'
=> '添加一个具有特定的角色的用户到这门课程中。',

   'Add/Modify a Student'
=> '添加/修改学生', 

   'Add a user with the role student to this course.'
=> '添加一个用户到课程中，作为学生角色。',

   'Configuration'
=> '设置',

   'Automated enrollment manager.'
=> '管理自助注册',

   'User Self-Enrollment'
=> '用户自助注册',

   'Configure user self enrollment.'
=> '配置用户自助注册。',

   'Manage course groups.'
=> '管理课程组。',

   'Change Logs'
=> '更改记录',

   'View change log.'
=> '显示更改记录。',

   'Administration'
=> '管理',

   'Manage Course Users'
=> '用户课程管理',

   'Show and manage users of this course.'
=> '查看和管理这门课程的用户。',

   'Remove a student from this course.'
=> '从这门课程中移除一名学生。',

   'Custom Roles'
=> '自定义角色',

   'Configure a custom role.'
=> '配置自定义角色。',

   'Multiple Users'
=> '多用户',

#lonstatistics.pm
   'Statistics and Analyses'
=> '统计与分析',

   'Plots'
=> '图表',

   'Reports'
=> '报告',


#2009.02.17

   'Personal Homepage'
=> '个人主页',

#2009.02.18
   'Link Name:'
=> '连接的名字：',

   'Address:'
=> '地址：',

   'Link Name'
=> '连接的名字',

   'Address'
=> '地址',

   'Broadcast to Active Members'
=> '通知活跃的会员',

   'Thank you for your input!'
=> '非常感谢您的评估！',

   'Saving feedback: [_1]'
=> '保存到信息反馈： [_1]',

   'Logging first evaluation'
=> '登录到首次评估',

   'The WYSIWYG editor only supports simple HTML and is in many cases unsuited for advanced authoring. In a number of cases, it may destroy advanced authoring involving LaTeX and script function calls.'
=> 'WYSIWYG 编辑器仅支持简单的 HTML，并且在许多情况下不适合复杂的创作。在一些情况下，它可能破坏复杂的创作及 LaTeX 和脚本函数的调用。',

   'Special Admin Options'
=> '特别管理选项',

   'Discussion postings'
=> '讨论帖子',

#2009.03.01

   'Currently using [_1] of the [_2] available.'
=> '目前使用 [_1] ，在 [_2] 可用中。',

   'Registering clickers: [_1]'
=> '注册的“遥控”号码为： [_1]',

   'New Broadcast Message'
=> '新的广播信息',

   'Send a broadcast message to members of this Course and/or other users.'
=> '发送广播信息给这门课程的成员和/或其他用户。',

   'New Messages from File'
=> '从文件生成新邮件',

   'Send copy to permanent e-mail address (if known)'
=> '发送一份副本给外部电子邮件（如果有的话）',

   'Require return receipt?'
=> '回执确认？',

#2009.03.05

   'Message Administration'
=> '邮件管理',

   'Message Log for Selected Users'
=> '选定用户的邮件日志',

#2009.03.09

   'New Document'
=> '新文档',

  'Bcc: course members with current access'
=> '密送：当前访问的课程参加者',

   'Tools:'
=> '工具:',

   'Upload PDF Form'
=> '上传PDF格式文档',

   'Upload a PDF Form with filled Form Fields'
=> '上传带有填写表格字段的PDF格式文档',

   'Please choose a PDF-File.'
=> '请选择一个PDF文件。',

   "Can't find any valid PDF formfields."
=> '找不到任何有效的PDF格式文档 。',

   'Results of PDF Form problems'
=> 'PDF格式习题答案',

   'Published Documents'
=> '公开文件',


   ''
=> '',


#SYNCMARKER
);

1;

